#include <stdio.h>
#include "tcplib.h"
#include "xmalloc.h"
#include "timelib.h"

const int port=8855;

#ifdef __hppa__
#define random() rand()
#define srandom(x) srand(x)
#endif

void Send(int npackets,int rmin,int rmax)
{
  int l,s;
  char *buf;
  TcpSocket conn;

  buf = xmalloc(rmax);

  conn = GetConnection(NULL,port);
  TcpLibBufferOutput(conn,1);
  srandom(time(NULL)>>1 ^ getpid()<<3);
  for(l=0;l<npackets;l++) {
    s = random()%(rmin-rmax+1)+rmin;
/*    printf("Send %d\n",l);*/
    SendSizedMsg(conn,buf,s);
/* Depend on automatic flushing */
  }
  TcpLibFlush(conn);
  exit(0);
}
  
void Receive(int npackets)
{
  int l;
  char *buf;
  TcpSocket server,conn;
  struct timeval start,end;
  long size,total;

  buf = xmalloc(size);

  server = BecomeServer(port);
  WaitForInput(&server,1,TCPLIB_FOREVER);
  if (!HasInput(server)) {
    fprintf(stderr,"WaitForInput returned, but no input\n");
    exit(1);
  }
/*  printf("Accepting Connection\n");*/
  conn = AcceptConnection(server,NULL);
  gettimeofday(&start,NULL);
  total = 0;
  for(l=0;l<npackets;l++) {
/*    printf("Receive %d\n",l);*/
    (void)GetSizedMsg(conn,&size);
    total += size;
  }
  gettimeofday(&end,NULL);
  printf("Receive of %d packets, total size %d took %d ms, %d bytes/ms\n",
	 npackets,total,msDiff(end,start),(total)/msDiff(end,start));
  exit(0);
}
    
main(int argc,char *argv[])
{
  int npackets,min,max;

  if ((argc == 3)&&
      (strcmp(argv[1],"-r")==0)&&
      ((npackets = atoi(argv[2]))>0)) {
    /* Good args -- receive */
  } else if ((argc == 5)&&
	     (strcmp(argv[1],"-s")==0) &&
	     ((npackets = atoi(argv[2]))>0) &&
	     ((min = atoi(argv[3]))>0) &&
	     ((max = atoi(argv[4]))>=min)) {
    /* Good Args -- send */
  } else {
    fprintf(stderr,"Usage:%s <-r npackets|-s npackets minsize maxsize>\n",
	    argv[0]);
    exit(1);
  }
  
  if (strcmp(argv[1],"-s")==0)
    Send(npackets,min,max);
  else
    Receive(npackets);
  exit(1);
}

