package Task::Error::Pure;

use strict;
use warnings;

our $VERSION = 0.04;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Error::Pure - Install the Error::Pure modules.

=head1 SYNOPSIS

 cpanm Task::Error::Pure

=head1 SEE ALSO

=over

=item L<Error::Pure>

Perl module for structured errors.

=item L<Error::Pure::ANSIColor>

Error::Pure modules with Term::ANSIColor support.

=item L<Error::Pure::ANSIColor::AllError>

Error::Pure module with full backtrace.

=item L<Error::Pure::ANSIColor::Die>

Error::Pure module with classic die.

=item L<Error::Pure::ANSIColor::Error>

Error::Pure module with error on one line with informations.

=item L<Error::Pure::ANSIColor::ErrorList>

Error::Pure module with list of errors in one line with informations.

=item L<Error::Pure::ANSIColor::Print>

Error::Pure module for simple error print.

=item L<Error::Pure::ANSIColor::PrintVar>

Error::Pure module for simple error print with all variables with ANSIColor support.

=item L<Error::Pure::AllError>

Error::Pure module with full backtrace.

=item L<Error::Pure::Always>

Perl module for rewrite die by err from Error::Pure module.

=item L<Error::Pure::Die>

Error::Pure module with classic die.

=item L<Error::Pure::Error>

Error::Pure module with error on one line with informations.

=item L<Error::Pure::ErrorList>

Error::Pure module with list of errors in one line with informations.

=item L<Error::Pure::HTTP::AllError>

Error::Pure module with full backtrace over HTTP.

=item L<Error::Pure::HTTP::Error>

Error::Pure module with error on one line over HTTP.

=item L<Error::Pure::HTTP::ErrorList>

Error::Pure module with list of errors in one line with informations over HTTP.

=item L<Error::Pure::HTTP::JSON>

Error::Pure module for JSON output over HTTP.

=item L<Error::Pure::HTTP::JSON::Advance>

Error::Pure module for JSON output with additional parameters over HTTP.

=item L<Error::Pure::HTTP::Print>

Error::Pure module for simple error print over HTTP.

=item L<Error::Pure::JSON>

Error::Pure module for JSON output.

=item L<Error::Pure::JSON::Advance>

Error::Pure module for JSON output with additional parameters.

=item L<Error::Pure::NoDie>

Error::Pure module for simple print instead die.

=item L<Error::Pure::Output::ANSIColor>

ANSIColor Output subroutines for Error::Pure.

=item L<Error::Pure::Output::JSON>

Output JSON subroutines for Error::Pure.

=item L<Error::Pure::Output::Text>

Output subroutines for Error::Pure.

=item L<Error::Pure::Output::Tags::HTMLCustomPage>

Error::Pure HTML output helper.

=item L<Error::Pure::Print>

Error::Pure module for simple error print.

=item L<Error::Pure::PrintVar>

Error::Pure module for simple error print with all variables.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Task-Error-Pure>

=head1 AUTHOR

Michal Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© 2015-2023 Michal Josef Špaček

Artistic License

BSD 2-Clause License

=head1 VERSION

0.04

=cut
