$::VERSION = $::VERSION = 0.01;
use 5.00503;
use strict;
use Test::Simply tests => 12;
use Stable::Module;

my @fileparse = '';

eval {
    @fileparse = fileparse('/usr/lo\al/bin/perl.pl');
};

ok(($fileparse[0] eq 'perl.pl'),          qq{(fileparse('/usr/lo\al/bin/perl.pl'))[0] $^X @{[__FILE__]}});
ok(($fileparse[1] eq '/usr/lo\al/bin/'), qq{(fileparse('/usr/lo\al/bin/perl.pl'))[1] $^X @{[__FILE__]}});
ok(((not defined($fileparse[2])) or ($fileparse[2] eq '')), qq{(fileparse('/usr/lo\al/bin/perl.pl'))[2] $^X @{[__FILE__]}});

eval {
    @fileparse = fileparse('/usr/lo\al/bin/perl.pl','.pl');
};

ok(($fileparse[0] eq 'perl'),             qq{(fileparse('/usr/lo\al/bin/perl.pl','.pl'))[0] $^X @{[__FILE__]}});
ok(($fileparse[1] eq '/usr/lo\al/bin/'), qq{(fileparse('/usr/lo\al/bin/perl.pl','.pl'))[1] $^X @{[__FILE__]}});
ok(($fileparse[2] eq '.pl'),              qq{(fileparse('/usr/lo\al/bin/perl.pl','.pl'))[2] $^X @{[__FILE__]}});

eval {
    @fileparse = fileparse('/usr/lo\al/bin/perl.pl','.txt');
};

ok(($fileparse[0] eq 'perl.pl'),          qq{(fileparse('/usr/lo\al/bin/perl.pl','.txt'))[0] $^X @{[__FILE__]}});
ok(($fileparse[1] eq '/usr/lo\al/bin/'), qq{(fileparse('/usr/lo\al/bin/perl.pl','.txt'))[1] $^X @{[__FILE__]}});
ok(($fileparse[2] eq ''),                 qq{(fileparse('/usr/lo\al/bin/perl.pl','.txt'))[2] $^X @{[__FILE__]}});

eval {
    @fileparse = fileparse('/usr/lo \ al/bin/p\ rl.p l','.p l');
};

ok(($fileparse[0] eq 'p\ rl'),             qq{(fileparse('/usr/lo \ al/bin/p\ rl.p l','.p l'))[0] $^X @{[__FILE__]}});
ok(($fileparse[1] eq '/usr/lo \ al/bin/'), qq{(fileparse('/usr/lo \ al/bin/p\ rl.p l','.p l'))[1] $^X @{[__FILE__]}});
ok(($fileparse[2] eq '.p l'),               qq{(fileparse('/usr/lo \ al/bin/p\ rl.p l','.p l'))[2] $^X @{[__FILE__]}});

__END__
