import QtQuick 2.8
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 6.2
import QtQuick.Studio.Effects 1.0

Button {
    id: carFrontButton
    checkable: true
    background: Rectangle {
        id: background
        width: 200
        height: 200
        color: "#00000000"
    }
    Rectangle {
        id: indicator1
        x: 0
        y: 66
        width: 100
        height: 2
        color: "#ffffff"
        antialiasing: true
        layer.samples: 4
        layer.enabled: true
    }

    Image {
        id: newVehicleIcon2
        x: 32
        y: 21
        width: 34
        source: "assets/newVehicleIcon@2.png"
        fillMode: Image.PreserveAspectFit
    }

    Image {
        id: newVehicleIcon3
        x: 32
        y: 21
        width: 34
        source: "assets/newVehicleIcon@2.png"
        layer.enabled: true
        layer.effect: ColorOverlayEffect {
            id: colorOverlay
            color: "#ffffff"
        }
        fillMode: Image.PreserveAspectFit
    }
    states: [
        State {
            name: "default"
            when: !carFrontButton.checked

            PropertyChanges {
                target: newVehicleIcon2
                visible: true
            }

            PropertyChanges {
                target: newVehicleIcon3
                visible: false
            }

            PropertyChanges {
                target: indicator1
                visible: false
            }
        },
        State {
            name: "checked"
            when: carFrontButton.checked

            PropertyChanges {
                target: newVehicleIcon3
                visible: true
            }

            PropertyChanges {
                target: newVehicleIcon2
                visible: false
            }

            PropertyChanges {
                target: indicator1
                visible: true
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;autoSize:true;height:68;width:100}
}
##^##*/

