import QtQuick 2.8
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 6.2

Button {
    id: steeringWheelBtn
    checkable: true
    state: "default"
    background: Rectangle {
        id: background
        width: 200
        height: 200
        color: "#00000000"
    }
    Rectangle {
        id: indicator2
        x: -2
        y: 62
        width: 100
        height: 2
        color: "#ffffff"
        antialiasing: true
        layer.samples: 4
        layer.enabled: true
    }

    SvgPathItem {
        id: sterringWheelDef
        x: 33
        y: 15
        width: 30
        height: 30
        strokeColor: "transparent"
        fillColor: "#6d737a"
        path: "M 29.83367468652111 13.030986956221932 C 29.846851327697266 12.782154105144802 29.819823755729622 12.532824394260617 29.753632203809133 12.292595137545792 C 29.053747649452998 8.478703194571704 26.904125401225436 5.084019352185061 23.75568064099634 2.820631766890844 C 20.60723588076724 0.5572441815966265 16.704618579558108 -0.39897204398302527 12.866462213102226 0.15256434764379695 C 9.028305846646342 0.7041007392706191 5.552852774159133 2.720532719748463 3.1691340426126082 5.77888263780342 C 0.785415311066084 8.837232555858378 -0.3213439470166461 12.699852362793262 0.08101641891392881 16.5564978055115 C 0.4833767848445037 20.41314324822974 2.3635909850697923 23.964135017339373 5.327255842883685 26.46459811306304 C 8.290920700697576 28.965061208786707 12.107746097603751 30.220697862593774 15.977092515608982 29.96811891280391 C 19.846438933614213 29.715539963014045 23.467639199360164 27.974372549822863 26.08109386367683 25.10985228518656 C 28.694548527993497 22.245332020550254 30.09717803477636 18.48004604494624 29.99475963432451 14.603821290342443 C 29.995760166360114 14.07454038942152 29.882700752654916 13.625302371927951 29.83367468652111 13.030986956221932 Z M 2.9323717546452905 18.700996139257466 C 2.9645234200349972 18.435697363716272 3.0796301927440592 18.18732608266755 3.261274117498057 17.991308940062947 C 3.4429180422520544 17.795291797458344 3.681821722591148 17.661638697266646 3.9439095125359436 17.609415270403375 C 4.221915885292606 17.586412268534833 4.50134691090367 17.586412268534833 4.779353283660333 17.609415270403375 C 5.52727521913259 17.612432586779075 6.262097731324964 17.80595193460783 6.914488847747403 18.171713985974307 C 8.182162836570882 19.61648080391891 10.125196585276456 21.542504426762555 10.125196585276456 21.542504426762555 C 10.930403949784091 22.599248037186584 11.544331258046535 23.78883603116278 11.93916080486368 25.057368527251274 C 12.115254433811822 26.004871442591522 11.248793496927568 26.244999474147015 10.494392369803663 26.293024964167333 C 9.173683294511923 25.842534793167328 7.937145803792135 25.175407603751893 6.835446824505701 24.318977662755884 C 5.032222396590086 22.850621111236357 3.6787469616470503 20.903405849586 2.9323717546452905 18.700996139257466 Z M 18.9038634624568 26.179964087181077 L 18.710759994877954 26.179964087181077 C 17.2339748291331 26.179964087181077 17.427078415984656 25.104394371300483 17.427078415984656 25.104394371300483 C 17.783717468050977 23.801122181763546 18.400792889972614 22.583649925204952 19.24104263557188 21.52549520072528 L 22.018518503204493 18.41184120498525 C 22.86357410400593 17.826979871779734 23.88150237429023 17.544908931935712 24.907055390945086 17.611417141615437 L 25.707480218064862 17.611417141615437 C 25.92687225509767 17.697502821910053 26.113085234002238 17.851326061961824 26.239043370546206 18.050519672280895 C 26.365001507090174 18.249713282599966 26.424138285227297 18.48389193009265 26.407853373067155 18.719005346720024 C 25.871702634438314 20.270361072173472 25.03116341397801 21.699035989598666 23.935538158774175 22.9212345419538 C 22.542583219112487 24.397241595448737 20.81363968650171 25.514858299864912 18.89585787833128 26.178964105755796 L 18.9038634624568 26.179964087181077 Z M 14.682619142143615 2.2292534388038083 C 17.399143555167633 2.239099645796874 20.037957744001588 3.1368442853987695 22.196889405956398 4.785665399853896 C 24.355821067911208 6.434486514309022 25.91646729173411 8.743957570889904 26.64097712782033 11.362100971152444 L 26.512908773808505 12.196544440777563 L 25.100156950160613 12.710817330874006 C 19.418135889081345 9.195951799114162 17.185949077105956 9.002848992881303 17.185949077105956 9.002848992881303 C 16.41400490271259 8.815214596522761 15.6209361601898 8.72877748139455 14.826695801861508 8.745712547833081 C 14.081505330663068 8.747164700979116 13.336968056447096 8.789919861221408 12.59650990882667 8.873780779644552 C 9.385802648388447 9.114908755352637 4.4922009007856545 12.56573987302526 4.4922009007856545 12.56573987302526 C 4.299906638890651 12.653706258485848 4.092191161373938 12.703000893698114 3.8808760335457197 12.710817330874006 C 3.5807361051907676 12.712915502591828 3.288109731224838 12.61701208977225 3.047432942816466 12.43767164121379 L 2.741270160188653 11.33008439028995 C 3.468248344956008 8.71869086464806 5.0281900248958715 6.4161663631947805 7.183851467757216 4.772692835476593 C 9.33951291061856 3.1292193077584054 11.97293811998351 2.234725584333035 14.68362007870472 2.2252513661959967 L 14.682619142143615 2.2292534388038083 Z"
        layer.samples: 4
        strokeWidth: 1
        antialiasing: true
        layer.enabled: true
    }
    states: [
        State {
            name: "default"
            when: !steeringWheelBtn.checked

            PropertyChanges {
                target: indicator2
                visible: false
            }

            PropertyChanges {
                target: sterringWheelDef
                visible: true
            }
        },
        State {
            name: "checked"
            when: steeringWheelBtn.checked

            PropertyChanges {
                target: indicator2
                visible: true
            }

            PropertyChanges {
                target: sterringWheelDef
                visible: true
                fillColor: "#fbfbfb"
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;height:64;width:100}
}
##^##*/

