import QtQuick
import QtQuick3D
import Generated.ComponentBundles.MaterialBundle
import QtQuick.Timeline

Node {
    id: node
    property double lampBrightness

    // Resources

    // Nodes:
    Node {
        id: root
        objectName: "ROOT"

        Model {
            id: lamp
            objectName: "lamp"
            rotation: Qt.quaternion(0.707107, 0, 0, -0.707107)
            scale.x: 1
            scale.y: 1
            scale.z: 1
            source: "meshes/lamp_mesh.mesh"
            materials: [
                metal_material,
                lamp_material,
                chrome_material
            ]
        }

        Model {
            id: button
            objectName: "button"
            x: -5.5
            y: 0.800000011920929
            scale.x: 0.5
            scale.y: 0.5
            scale.z: 0.5
            source: "meshes/button_mesh.mesh"
            materials: [
                button_material,
                chrome_material,
                metal_material
            ]
        }
    }

    Node {
        id: __materialLibrary__

        PrincipledMaterial {
            id: metal_material
            metalness: 1
            objectName: "metal"
            baseColor: "#414141"
            roughness: 0.4
            cullMode: PrincipledMaterial.NoCulling
            alphaMode: PrincipledMaterial.Opaque
        }

        PrincipledMaterial {
            id: lamp_material
            emissiveFactor.z: node.lampBrightness - 2.5
            emissiveFactor.y: node.lampBrightness
            emissiveFactor.x: node.lampBrightness
            objectName: "lamp"
            baseColor: "#ffffff"
            roughness: 0.5
            cullMode: PrincipledMaterial.NoCulling
            alphaMode: PrincipledMaterial.Opaque
        }

        PrincipledMaterial {
            id: chrome_material
            metalness: 1
            objectName: "chrome"
            baseColor: "#ffffff"
            roughness: 0.4
            cullMode: PrincipledMaterial.NoCulling
            alphaMode: PrincipledMaterial.Opaque
        }

        PrincipledMaterial {
            id: button_material
            objectName: "button"
            baseColor: "#ff0000"
            roughness: 0.5
            cullMode: PrincipledMaterial.NoCulling
            alphaMode: PrincipledMaterial.Opaque
        }

        PrincipledMaterial {
            id: lamp_beam
            opacity: 0.01
            clearcoatFresnelScale: 1
            fresnelPower: 10
            clearcoatRoughnessChannel: Material.A
            transmissionFactor: 1
            clearcoatFresnelBias: 0.2
            clearcoatFresnelScaleBiasEnabled: true
            clearcoatFresnelPower: 2
            clearcoatRoughnessAmount: 1
            clearcoatAmount: 1
            occlusionAmount: 0.1
            roughness: 0
            objectName: "lamp_beam"
            emissiveFactor.z: 0.25
            emissiveFactor.y: 1.5
            emissiveFactor.x: 1.5
            cullMode: PrincipledMaterial.NoCulling
            baseColor: "#ffffff"
            alphaMode: PrincipledMaterial.Opaque
        }
    }

    Model {
        id: cylinder
        x: -20.903
        y: 0
        visible: false
        source: "#Cylinder"
        eulerRotation.z: -90.00003
        eulerRotation.y: 0
        eulerRotation.x: 0
        scale.z: 0.02861
        scale.y: 0.25738
        scale.x: 0.02861
        z: 0.1182
        materials: lamp_beam
    }

    // Animations:
}

/*##^##
Designer {
    D{i:0;cameraSpeed3d:25;cameraSpeed3dMultiplier:1;matPrevEnvDoc:"SkyBox";matPrevEnvValueDoc:"preview_studio";matPrevModelDoc:"#Sphere"}
}
##^##*/
