import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Effects
import QtQuick.Layouts
import QtQuick.Studio.Components
import QtQuick3D.Helpers
import Generated.Bundles.Materials
import MaterialBundleDemo

RoundButton {
    id: roundButton
    width: 425
    height: 54
    radius: 8
    text: ""
    flat: true
    spacing: 6
    focusPolicy: Qt.TabFocus
    checkable: true
    checked: (root.meshSelection === 0 && root.matNameOuter === modelData)
             || (root.meshSelection === 1 && root.matNameInner === modelData)




        onClicked: {
            materialBall_Qt.materials[root.meshSelection] = root.materials[root.selectedCategory][index]

            if (root.meshSelection === 0)
                root.matNameOuter = modelData
            else if (root.meshSelection === 1)
                root.matNameInner = modelData
        }



    Rectangle {
        id: rectangle77
        color: parent.checked ? "#5c5c5d" :  "#212121"
        radius: 8
        border.color: "#5c5c5d"
        border.width: parent.hovered ? 1 : 0
        anchors.fill: parent
    }

    Text {
        id: text46
        x: 17
        y: 54
        color: "#ffffff"
        text: modelData
        anchors.fill: parent
        font.pixelSize: 14
        verticalAlignment: Text.AlignVCenter
        anchors.leftMargin: 20
    }

    Rectangle {
        id: rectangle78
        width: 18
        height: 18
        color: parent.checked ? "#ffffff" : "#212121"
        radius: 9
        border.color: "#aaaaaa"
        border.width: parent.checked ? 0 : 1
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: parent.right
        Image {
            id: checkmark46
            visible: parent.parent.checked
            anchors.verticalCenter: parent.verticalCenter
            source: "images/checkmark.png"
            fillMode: Image.PreserveAspectFit
            anchors.horizontalCenter: parent.horizontalCenter
        }
        anchors.rightMargin: 21
    }

    Item {
        id: __materialLibrary__
    }
    rightPadding: 9
    anchors.horizontalCenter: parent.horizontalCenter
    bottomPadding: 8
    highlighted: false
    font.pointSize: 12
}
