# Outrun Cluster

The Outrun Cluster example showcases how Qt Design Studio can be employed to create an automotive digital cockpit. This example features advanced 3D models, effects and animations.

This project is part of the multi-screen digital cockpit built with Qt. Learn more about this demo [here](https://www.qt.io/industry/qt-in-automotive/outrun).

![Screenshot](outrun_cluster.png)

## Requirements

The example works with QDS (4.x) and has been tested in Qt Creator with Qt 6.8.2 but it should also work with earlier versions of Qt.

To build and run the Cluster against a custom-built Qt, e.g. from the command-line, the following repositories must be available at minimum:
- qt/qtbase
- qt/qtshadertools
- qt/qtdeclarative
- qt/qtquicktimeline
- qt/qtquick3d
- qt/qt5compat
- qt-labs/qtquickdesigner-components

## Running

The Outrun Cluster can be run either from Qt Design Studio or by exporting the application using "Enable CMake Generator" in Qt Design Studio and opening the generated CMakeLists.txt file in QtCreator.

## Target Environments

All desktop platforms and Android.

## Keyboard Controls
|Key|Function  |
|--|--|
| + | Increase speed |
| - | Decrease speed |
| X | Increase battery |
| Z | Decrease battery |
| Left | Change lane to the left |
| Right | Change lane to the right |
| Up | Increase safety distance |
| Down | Decrease safety distance |
| ESC | Toggle between night and day modes |
| Q | Toggle between desert and city terrains |
| W | Toggle Lane Keeping Assist System |
| E | Show/Hide Topbar |
| R | Show/Hide Navigator |
| T | Show/Hide Panel |
| Y | Show/Hide Navigator blur effect |
| U | Toggle car headlights |
| N | Overtake the car in front |
| S | Toggle simulation on/off. Disables other keys when on |
| 1 | Sport mode |
| 2 | Autonomous driving mode |
| 3 | Change of safety distance mode |
| 4 | ADAS mode |
| 5 | Charging mode: behind |
| 6 | Charging mode: side |
| 7 | Charging mode: top |
| F12 | Toggle DebugView |
