/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlgen;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.postgresql.pljava.sqlgen.DDRProcessorImpl;
import org.postgresql.pljava.sqlgen.Lexicals;
import org.postgresql.pljava.sqlgen.Snippet;

public class DDRWriter {
    static final Pattern checker = Pattern.compile("(?s:\\\\.|[^;'\"]|'(?:\\\\.|[^'])*+'|\"(?:\\\\.|[^\"])*+\")*+");
    static final String checkMsg = "%s command contains unquoted ; or unbalanced '/\": %s";
    static final Pattern equoter = Pattern.compile("\\\\|'");

    static void emit(Snippet[] snips, DDRProcessorImpl p) throws IOException {
        if (!DDRWriter.ensureLexable(snips, p)) {
            return;
        }
        Writer w = p.filr.createResource(StandardLocation.CLASS_OUTPUT, "", p.output, new Element[0]).openWriter();
        w.write("SQLActions[]={\n\"BEGIN INSTALL\n");
        for (Snippet snip : snips) {
            for (String s : snip.deployStrings()) {
                DDRWriter.writeCommand(w, s, snip.implementor());
            }
        }
        w.write("END INSTALL\",\n\"BEGIN REMOVE\n");
        int i = snips.length;
        while (i-- > 0) {
            for (String s : snips[i].undeployStrings()) {
                DDRWriter.writeCommand(w, s, snips[i].implementor());
            }
        }
        w.write("END REMOVE\"\n}\n");
        w.close();
    }

    static void writeCommand(Writer w, String s, String implementor) throws IOException {
        if (null != implementor) {
            w.write("BEGIN ");
            w.write(implementor);
            w.write(10);
        }
        w.write(s);
        if (null != implementor) {
            w.write("\nEND ");
            w.write(implementor);
        }
        w.write(";\n");
    }

    static boolean ensureLexable(Snippet[] snips, DDRProcessorImpl p) {
        boolean errorRaised = false;
        Matcher m = checker.matcher("");
        Matcher i = Lexicals.ISO_PG_JAVA_IDENTIFIER.matcher("");
        for (Snippet snip : snips) {
            String implementor = snip.implementor();
            if (null != implementor) {
                i.reset(implementor);
                if (!i.matches()) {
                    p.msg(Diagnostic.Kind.ERROR, "non-SQL- or -Java-structured implementor-name: %s", implementor);
                }
            }
            for (String s : snip.deployStrings()) {
                m.reset(s);
                if (m.matches()) continue;
                p.msg(Diagnostic.Kind.ERROR, checkMsg, "install", s);
                errorRaised = true;
            }
            for (String s : snip.undeployStrings()) {
                m.reset(s);
                if (m.matches()) continue;
                p.msg(Diagnostic.Kind.ERROR, checkMsg, "remove", s);
                errorRaised = true;
            }
        }
        return !errorRaised;
    }

    public static String eQuote(CharSequence s) {
        Matcher m = equoter.matcher(s);
        return "e'" + m.replaceAll("$0$0") + '\'';
    }
}

