/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example.annotation;

import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.logging.Logger;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.MappedUDT;
import org.postgresql.pljava.annotation.SQLAction;
import org.postgresql.pljava.annotation.SQLType;

@SQLAction(requires={"complextuple type", "complextuple assertHasValues"}, install={"SELECT javatest.assertHasValues( CAST('(1,2)' AS javatest.complextuple), 1, 2)"})
@MappedUDT(schema="javatest", name="complextuple", provides={"complextuple type"}, structure={"x float8", "y float8"})
public class ComplexTuple
implements SQLData {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private double m_x;
    private double m_y;
    private String m_typeName;

    @Function(schema="javatest", name="logcomplex", effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL, type="javatest.complextuple", requires={"complextuple type"})
    public static ComplexTuple logAndReturn(@SQLType(value="javatest.complextuple") ComplexTuple cpl) {
        s_logger.info(cpl.getSQLTypeName() + "(" + cpl.m_x + ", " + cpl.m_y + ")");
        return cpl;
    }

    @Function(schema="javatest", requires={"complextuple type"}, provides={"complextuple assertHasValues"}, effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static void assertHasValues(@SQLType(value="javatest.complextuple") ComplexTuple cpl, double re, double im) throws SQLException {
        if (cpl.m_x != re || cpl.m_y != im) {
            throw new SQLException("assertHasValues fails");
        }
    }

    @Override
    public String getSQLTypeName() {
        return this.m_typeName;
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        this.m_typeName = typeName;
        this.m_x = stream.readDouble();
        this.m_y = stream.readDouble();
        s_logger.info(typeName + " from SQLInput");
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeDouble(this.m_x);
        stream.writeDouble(this.m_y);
        s_logger.info(this.m_typeName + " to SQLOutput");
    }
}

