/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractNarLayout;
import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.NarFileLayout;
import com.github.maven_nar.NarFileLayout10;
import com.github.maven_nar.NarInfo;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;

public class NarLayout20
extends AbstractNarLayout {
    private NarFileLayout fileLayout = new NarFileLayout10();

    public NarLayout20(Log log) {
        super(log);
    }

    @Override
    public File getNoArchDirectory(File baseDir, String artifactId, String version) throws MojoExecutionException, MojoFailureException {
        return baseDir;
    }

    @Override
    public final File getIncludeDirectory(File baseDir, String artifactId, String version) {
        return new File(baseDir, this.fileLayout.getIncludeDirectory());
    }

    @Override
    public final File getLibDirectory(File baseDir, String artifactId, String version, String aol, String type) throws MojoFailureException {
        if (type.equals("executable")) {
            throw new MojoFailureException("INTERNAL ERROR, Replace call to getLibDirectory with getBinDirectory");
        }
        File dir = new File(baseDir, this.fileLayout.getLibDirectory(aol, type));
        return dir;
    }

    @Override
    public final File getBinDirectory(File baseDir, String artifactId, String version, String aol) {
        File dir = new File(baseDir, this.fileLayout.getBinDirectory(aol));
        return dir;
    }

    @Override
    public final void prepareNarInfo(File baseDir, MavenProject project, NarInfo narInfo, AbstractNarMojo mojo) throws MojoExecutionException {
        if (this.getIncludeDirectory(baseDir, project.getArtifactId(), project.getVersion()).exists()) {
            narInfo.setNar(null, "noarch", project.getGroupId() + ":" + project.getArtifactId() + ":" + "nar" + ":" + "noarch");
        }
        String[] binAOL = new File(baseDir, "bin").list();
        for (int i = 0; binAOL != null && i < binAOL.length; ++i) {
            narInfo.setNar(null, "executable", project.getGroupId() + ":" + project.getArtifactId() + ":" + "nar" + ":" + "${aol}" + "-" + "executable");
            narInfo.setBinding(new AOL(binAOL[i]), "executable");
            narInfo.setBinding(null, "executable");
        }
        File libDir = new File(baseDir, "lib");
        String[] libAOL = libDir.list();
        for (int i = 0; libAOL != null && i < libAOL.length; ++i) {
            String bindingType = null;
            String[] libType = new File(libDir, libAOL[i]).list();
            for (int j = 0; libType != null && j < libType.length; ++j) {
                narInfo.setNar(null, libType[j], project.getGroupId() + ":" + project.getArtifactId() + ":" + "nar" + ":" + "${aol}" + "-" + libType[j]);
                if (bindingType != null && !libType[j].equals("shared")) continue;
                bindingType = libType[j];
            }
            AOL aol = new AOL(libAOL[i]);
            if (narInfo.getBinding(aol, null) == null) {
                narInfo.setBinding(aol, bindingType != null ? bindingType : "none");
            }
            if (narInfo.getBinding(null, null) != null) continue;
            narInfo.setBinding(null, bindingType != null ? bindingType : "none");
        }
    }

    @Override
    public final void attachNars(File baseDir, ArchiverManager archiverManager, MavenProjectHelper projectHelper, MavenProject project) throws MojoExecutionException {
        if (this.getIncludeDirectory(baseDir, project.getArtifactId(), project.getVersion()).exists()) {
            this.attachNar(archiverManager, projectHelper, project, "noarch", baseDir, "include/**");
        }
        String[] binAOL = new File(baseDir, "bin").list();
        for (int i = 0; binAOL != null && i < binAOL.length; ++i) {
            this.attachNar(archiverManager, projectHelper, project, binAOL[i] + "-" + "executable", baseDir, "bin/" + binAOL[i] + "/**");
        }
        File libDir = new File(baseDir, "lib");
        String[] libAOL = libDir.list();
        for (int i = 0; libAOL != null && i < libAOL.length; ++i) {
            Object bindingType = null;
            String[] libType = new File(libDir, libAOL[i]).list();
            for (int j = 0; libType != null && j < libType.length; ++j) {
                this.attachNar(archiverManager, projectHelper, project, libAOL[i] + "-" + libType[j], baseDir, "lib/" + libAOL[i] + "/" + libType[j] + "/**");
            }
        }
    }

    @Override
    public void unpackNar(File unpackDir, ArchiverManager archiverManager, File file, String os, String linkerName, AOL defaultAOL) throws MojoExecutionException, MojoFailureException {
        File flagFile = new File(unpackDir, FileUtils.basename((String)file.getPath(), (String)".nar") + ".flag");
        boolean process = false;
        if (!unpackDir.exists()) {
            unpackDir.mkdirs();
            process = true;
        } else if (!flagFile.exists()) {
            process = true;
        } else if (file.lastModified() > flagFile.lastModified()) {
            process = true;
        }
        if (process) {
            try {
                this.unpackNarAndProcess(archiverManager, file, unpackDir, os, linkerName, defaultAOL);
                FileUtils.fileDelete((String)flagFile.getPath());
                FileUtils.fileWrite((String)flagFile.getPath(), (String)"");
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot create flag file: " + flagFile.getPath(), (Throwable)e);
            }
        }
    }

    @Override
    public File getNarUnpackDirectory(File baseUnpackDirectory, File narFile) {
        File dir = new File(baseUnpackDirectory, FileUtils.basename((String)narFile.getPath(), (String)".nar"));
        return dir;
    }
}

