/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.mozilla;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.compiler.ProgressMonitor;
import com.github.maven_nar.cpptasks.gcc.LdLinker;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public final class XpidlCompiler
extends CommandLineCompiler {
    private static final XpidlCompiler INSTANCE = new XpidlCompiler(false, null);

    public static XpidlCompiler getInstance() {
        return INSTANCE;
    }

    private XpidlCompiler(boolean newEnvironment, Environment env) {
        super("xpidl", null, new String[]{".idl", ".xpidl"}, new String[0], ".xpt", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    @Override
    protected Parser createParser(File source) {
        return new CParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 3;
    }

    @Override
    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        String baseName = this.getBaseOutputName(inputFile);
        return new String[]{baseName + ".xpt", baseName + ".h"};
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        return "";
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected void addIncludes(String baseDirPath, File[] includeDirs, Vector<String> args, Vector<String> relativeArgs, StringBuffer includePathId) {
        for (int i = 0; i < includeDirs.length; ++i) {
            args.addElement("-I");
            args.addElement(includeDirs[i].getAbsolutePath());
            if (relativeArgs == null) continue;
            String relative = CUtil.getRelativePath(baseDirPath, includeDirs[i]);
            relativeArgs.addElement("-I");
            relativeArgs.addElement(relative);
            if (includePathId == null) continue;
            if (includePathId.length() == 0) {
                includePathId.append("-I ");
            } else {
                includePathId.append(" -I ");
            }
            includePathId.append(relative);
        }
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return "-I" + includeDir;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return new File[0];
    }

    @Override
    public Linker getLinker(LinkType type) {
        return LdLinker.getInstance();
    }

    @Override
    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) {
        BuildException exc = null;
        String[] thisSource = new String[1];
        String[] tlbCommand = new String[args.length + endArgs.length + 6];
        tlbCommand[0] = "xpidl";
        tlbCommand[1] = "-m";
        tlbCommand[2] = "typelib";
        String[] headerCommand = new String[args.length + endArgs.length + 6];
        headerCommand[0] = "xpidl";
        headerCommand[1] = "-m";
        headerCommand[2] = "header";
        for (int i = 0; i < args.length; ++i) {
            tlbCommand[i + 3] = args[i];
            headerCommand[i + 3] = args[i];
        }
        tlbCommand[args.length + 3] = "-e";
        headerCommand[args.length + 3] = "-e";
        int tlbIndex = args.length + 6;
        int headerIndex = args.length + 6;
        for (int i = 0; i < endArgs.length; ++i) {
            tlbCommand[tlbIndex++] = endArgs[i];
            headerCommand[headerIndex++] = endArgs[i];
        }
        for (int j = 0; j < sourceFiles.length; ++j) {
            tlbIndex = args.length + 4;
            headerIndex = args.length + 4;
            String[] outputFileNames = this.getOutputFileNames(sourceFiles[j], null);
            tlbCommand[tlbIndex++] = outputFileNames[0];
            tlbCommand[tlbIndex++] = sourceFiles[j];
            headerCommand[headerIndex++] = outputFileNames[1];
            headerCommand[headerIndex++] = sourceFiles[j];
            int retval = this.runCommand(task, outputDir, tlbCommand);
            if (retval == 0) {
                retval = this.runCommand(task, outputDir, headerCommand);
            }
            if (monitor != null) {
                thisSource[0] = sourceFiles[j];
                monitor.progress(thisSource);
            }
            if (retval == 0 || exc != null) continue;
            exc = new BuildException(this.getCommand() + " failed with return code " + retval, task.getLocation());
            if (relentless) continue;
            throw exc;
        }
        if (exc != null) {
            throw exc;
        }
    }

    @Override
    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        return 0;
    }

    @Override
    public String getIdentifier() {
        return "Mozilla xpidl";
    }
}

