/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.trolltech;

import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.gcc.LdLinker;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import com.github.maven_nar.cpptasks.trolltech.MetaObjectParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public final class MetaObjectCompiler
extends CommandLineCompiler {
    private static final MetaObjectCompiler INSTANCE = new MetaObjectCompiler(false, null);

    public static MetaObjectCompiler getInstance() {
        return INSTANCE;
    }

    private MetaObjectCompiler(boolean newEnvironment, Environment env) {
        super("moc", "-version", new String[]{".h", ".cpp"}, new String[0], ".moc", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    @Override
    protected Parser createParser(File source) {
        return new CParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 3;
    }

    @Override
    public int bid(String inputFile) {
        int baseBid = super.bid(inputFile);
        if (baseBid > 0) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(inputFile));
                boolean hasQObject = MetaObjectParser.hasQObject(reader);
                ((Reader)reader).close();
                if (hasQObject) {
                    return baseBid;
                }
            }
            catch (IOException ex) {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        if (inputFile.endsWith(".cpp")) {
            return super.getOutputFileNames(inputFile, versionInfo);
        }
        String baseName = this.getBaseOutputName(inputFile);
        return new String[]{"moc_" + baseName + ".cpp"};
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        switch (index) {
            case 0: {
                return "-o";
            }
            case 1: {
                String outputFileName = this.getOutputFileNames(filename, null)[0];
                return new File(outputDir, outputFileName).toString();
            }
            case 2: {
                return filename;
            }
        }
        return null;
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return "";
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return new File[0];
    }

    @Override
    public Linker getLinker(LinkType type) {
        return LdLinker.getInstance();
    }

    @Override
    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        String arg1 = this.getInputFileArgument(outputDir, inputFile, 0);
        String arg2 = this.getInputFileArgument(outputDir, inputFile, 1);
        return arg1.length() + arg2.length() + 3;
    }
}

