/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AtclauseOrderCheck
extends AbstractJavadocCheck {
    private static final String[] DEFAULT_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated"};
    private List<Integer> mTarget = Arrays.asList(14, 15, 158, 9, 8, 10);
    private List<String> mTagOrder = Arrays.asList(DEFAULT_ORDER);

    public void setTarget(String aTarget) {
        ArrayList<Integer> customTarget = new ArrayList<Integer>();
        for (String type : aTarget.split(", ")) {
            customTarget.add(TokenTypes.getTokenId(type));
        }
        this.mTarget = customTarget;
    }

    public void setTagOrder(String aOrder) {
        ArrayList<String> customOrder = new ArrayList<String>();
        for (String type : aOrder.split(", ")) {
            customOrder.add(type);
        }
        this.mTagOrder = customOrder;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public void visitJavadocToken(DetailNode aAst) {
        int parentType = this.getParentType(this.getBlockCommentAst());
        if (this.mTarget.contains(parentType)) {
            this.checkOrderInTagSection(aAst);
        }
    }

    private void checkOrderInTagSection(DetailNode aJavadoc) {
        int indexOrderOfPreviousTag = 0;
        int indexOrderOfCurrentTag = 0;
        for (DetailNode node : aJavadoc.getChildren()) {
            if (node.getType() != 10071) continue;
            String tagText = JavadocUtils.getFirstChild(node).getText();
            indexOrderOfCurrentTag = this.mTagOrder.indexOf(tagText);
            if (this.mTagOrder.contains(tagText) && indexOrderOfCurrentTag < indexOrderOfPreviousTag) {
                this.log(node.getLineNumber(), "at.clause.order", this.mTagOrder.toString());
            }
            indexOrderOfPreviousTag = indexOrderOfCurrentTag;
        }
    }

    private int getParentType(DetailAST aCommentBlock) {
        int type = 0;
        DetailAST parentNode = aCommentBlock.getParent();
        if (parentNode != null && ((type = parentNode.getType()) == 13 || type == 5)) {
            type = parentNode.getParent().getType();
        }
        return type;
    }
}

