/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PackageManager;
import javax.media.PlugInManager;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.logging.Logger;

public class FMJPlugInConfiguration {
    private static boolean codecsRegistered = false;
    private static boolean multiplexersRegistered = false;
    private static final String[] CUSTOM_CODECS = new String[]{OSUtils.IS_ANDROID ? "org.jitsi.impl.neomedia.codec.video.AndroidEncoder" : null, OSUtils.IS_ANDROID ? "org.jitsi.impl.neomedia.codec.video.AndroidDecoder" : null, "org.jitsi.impl.neomedia.codec.audio.alaw.DePacketizer", "org.jitsi.impl.neomedia.codec.audio.alaw.JavaEncoder", "org.jitsi.impl.neomedia.codec.audio.alaw.Packetizer", "org.jitsi.impl.neomedia.codec.audio.ulaw.JavaDecoder", "org.jitsi.impl.neomedia.codec.audio.ulaw.JavaEncoder", "org.jitsi.impl.neomedia.codec.audio.ulaw.Packetizer", "org.jitsi.impl.neomedia.codec.audio.opus.JNIDecoder", "org.jitsi.impl.neomedia.codec.audio.opus.JNIEncoder", "org.jitsi.impl.neomedia.codec.audio.speex.JNIDecoder", "org.jitsi.impl.neomedia.codec.audio.speex.JNIEncoder", "org.jitsi.impl.neomedia.codec.audio.speex.SpeexResampler", "org.jitsi.impl.neomedia.codec.audio.ilbc.JavaDecoder", "org.jitsi.impl.neomedia.codec.audio.ilbc.JavaEncoder", null, null, "org.jitsi.impl.neomedia.codec.audio.g722.JNIDecoderImpl", "org.jitsi.impl.neomedia.codec.audio.g722.JNIEncoderImpl", "org.jitsi.impl.neomedia.codec.audio.gsm.Decoder", "org.jitsi.impl.neomedia.codec.audio.gsm.Encoder", "org.jitsi.impl.neomedia.codec.audio.gsm.DePacketizer", "org.jitsi.impl.neomedia.codec.audio.gsm.Packetizer", "org.jitsi.impl.neomedia.codec.audio.silk.JavaDecoder", "org.jitsi.impl.neomedia.codec.audio.silk.JavaEncoder", "org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer", "org.jitsi.impl.neomedia.codec.video.vp8.Packetizer", "org.jitsi.impl.neomedia.codec.video.vp8.VPXDecoder", "org.jitsi.impl.neomedia.codec.video.vp8.VPXEncoder"};
    private static final String[] CUSTOM_CODECS_FFMPEG = new String[]{"org.jitsi.impl.neomedia.codec.audio.mp3.JNIEncoder", "org.jitsi.impl.neomedia.codec.video.h264.DePacketizer", "org.jitsi.impl.neomedia.codec.video.h264.JNIDecoder", "org.jitsi.impl.neomedia.codec.video.h264.JNIEncoder", "org.jitsi.impl.neomedia.codec.video.h264.Packetizer", "org.jitsi.impl.neomedia.codec.video.SwScale"};
    private static final String[] CUSTOM_PACKAGES = new String[]{"org.jitsi.impl.neomedia.jmfext", "net.java.sip.communicator.impl.neomedia.jmfext", "net.sf.fmj"};
    private static final String[] CUSTOM_MULTIPLEXERS = new String[]{"org.jitsi.impl.neomedia.recording.BasicWavMux"};
    private static final Logger logger = Logger.getLogger(FMJPlugInConfiguration.class);
    private static boolean packagesRegistered = false;

    public static void registerCustomCodecs(boolean enableFfmpeg) {
        String[] gsmCodecClasses;
        if (codecsRegistered) {
            return;
        }
        HashSet registeredPlugins = new HashSet(PlugInManager.getPlugInList(null, null, (int)2));
        boolean commit = false;
        PlugInManager.removePlugIn((String)"com.sun.media.codec.video.colorspace.JavaRGBToYUV", (int)2);
        PlugInManager.removePlugIn((String)"com.sun.media.codec.video.colorspace.JavaRGBConverter", (int)2);
        PlugInManager.removePlugIn((String)"com.sun.media.codec.video.colorspace.RGBScaler", (int)2);
        PlugInManager.removePlugIn((String)"com.sun.media.codec.video.vh263.NativeDecoder", (int)2);
        PlugInManager.removePlugIn((String)"com.ibm.media.codec.video.h263.NativeEncoder", (int)2);
        String gsmCodecPackage = "com.ibm.media.codec.audio.gsm.";
        for (String gsmCodecClass : gsmCodecClasses = new String[]{"JavaDecoder", "JavaDecoder_ms", "JavaEncoder", "JavaEncoder_ms", "NativeDecoder", "NativeDecoder_ms", "NativeEncoder", "NativeEncoder_ms", "Packetizer"}) {
            PlugInManager.removePlugIn((String)(gsmCodecPackage + gsmCodecClass), (int)2);
        }
        PlugInManager.removePlugIn((String)"net.sf.fmj.media.codec.JavaSoundCodec", (int)2);
        LinkedList<String> customCodecs = new LinkedList<String>();
        customCodecs.addAll(Arrays.asList(CUSTOM_CODECS));
        if (enableFfmpeg) {
            customCodecs.addAll(Arrays.asList(CUSTOM_CODECS_FFMPEG));
        }
        for (String className : customCodecs) {
            boolean registered;
            if (className == null) continue;
            if (registeredPlugins.contains(className)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Codec " + className + " is already registered"));
                continue;
            }
            commit = true;
            Throwable exception = null;
            try {
                Codec codec = (Codec)Class.forName(className).newInstance();
                registered = PlugInManager.addPlugIn((String)className, (Format[])codec.getSupportedInputFormats(), (Format[])codec.getSupportedOutputFormats(null), (int)2);
            }
            catch (Throwable ex) {
                registered = false;
                exception = ex;
            }
            if (registered) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Codec " + className + " is successfully registered"));
                continue;
            }
            logger.warn((Object)("Codec " + className + " is NOT successfully registered"), exception);
        }
        Vector codecs = PlugInManager.getPlugInList(null, null, (int)2);
        if (codecs != null) {
            boolean setPlugInList = false;
            for (String className : customCodecs) {
                int classNameIndex;
                if (className == null || (classNameIndex = codecs.indexOf(className)) == -1) continue;
                codecs.remove(classNameIndex);
                codecs.add(0, className);
                setPlugInList = true;
            }
            if (setPlugInList) {
                PlugInManager.setPlugInList((Vector)codecs, (int)2);
            }
        }
        if (commit && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
            try {
                PlugInManager.commit();
            }
            catch (IOException ex) {
                logger.error((Object)"Cannot commit to PlugInManager", (Throwable)ex);
            }
        }
        codecsRegistered = true;
    }

    public static void registerCustomPackages() {
        if (packagesRegistered) {
            return;
        }
        Vector packages = PackageManager.getProtocolPrefixList();
        boolean loggerIsDebugEnabled = logger.isDebugEnabled();
        for (int i = CUSTOM_PACKAGES.length - 1; i >= 0; --i) {
            String customPackage = CUSTOM_PACKAGES[i];
            if (packages.contains(customPackage)) continue;
            packages.add(0, customPackage);
            if (!loggerIsDebugEnabled) continue;
            logger.debug((Object)("Adding package  : " + customPackage));
        }
        PackageManager.setProtocolPrefixList((Vector)packages);
        PackageManager.commitProtocolPrefixList();
        if (loggerIsDebugEnabled) {
            logger.debug((Object)("Registering new protocol prefix list: " + packages));
        }
        packagesRegistered = true;
    }

    public static void registerCustomMultiplexers() {
        if (multiplexersRegistered) {
            return;
        }
        PlugInManager.removePlugIn((String)"com.sun.media.multiplexer.audio.WAVMux", (int)5);
        PlugInManager.removePlugIn((String)"net.sf.fmj.media.multiplexer.audio.WAVMux", (int)5);
        HashSet registeredMuxers = new HashSet(PlugInManager.getPlugInList(null, null, (int)5));
        boolean commit = false;
        for (String className : CUSTOM_MULTIPLEXERS) {
            boolean registered;
            if (className == null) continue;
            if (registeredMuxers.contains(className)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Multiplexer " + className + " is already registered"));
                continue;
            }
            Throwable exception = null;
            try {
                Multiplexer multiplexer = (Multiplexer)Class.forName(className).newInstance();
                registered = PlugInManager.addPlugIn((String)className, (Format[])multiplexer.getSupportedInputFormats(), (Format[])multiplexer.getSupportedOutputContentDescriptors(null), (int)5);
            }
            catch (Throwable ex) {
                registered = false;
                exception = ex;
            }
            if (registered) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Codec " + className + " is successfully registered"));
                }
            } else {
                logger.warn((Object)("Codec " + className + " is NOT successfully registered"), exception);
            }
            commit |= registered;
        }
        if (commit && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
            try {
                PlugInManager.commit();
            }
            catch (IOException ex) {
                logger.error((Object)"Cannot commit to PlugInManager", (Throwable)ex);
            }
        }
        multiplexersRegistered = true;
    }
}

