/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.fmj.media.rtp.RTCPPacket;

public class RTCPExtendedReport
extends RTCPPacket {
    public static final String SDP_ATTRIBUTE = "rtcp-xr";
    public static final int XR = 207;
    private final List<ReportBlock> reportBlocks = new LinkedList<ReportBlock>();
    private int ssrc;
    private long systemTimeStamp;

    public RTCPExtendedReport() {
        this.type = 207;
    }

    public RTCPExtendedReport(byte[] buf, int off, int len) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(buf, off, len)));
    }

    public RTCPExtendedReport(DataInputStream datainputstream) throws IOException {
        this();
        int b0 = datainputstream.readUnsignedByte();
        int pt = datainputstream.readUnsignedByte();
        int length = datainputstream.readUnsignedShort();
        if (length < 1) {
            throw new IOException("Invalid RTCP length.");
        }
        this.parse(b0, pt, length, datainputstream);
    }

    public RTCPExtendedReport(int b0, int pt, int length, DataInputStream datainputstream) throws IOException {
        this();
        this.parse(b0, pt, length, datainputstream);
    }

    private void parse(int b0, int pt, int length, DataInputStream datainputstream) throws IOException {
        length -= 4;
        if ((b0 & 0xC0) != 128) {
            throw new IOException("Invalid RTCP version (V).");
        }
        if (pt != 207) {
            throw new IOException("Invalid RTCP packet type (PT).");
        }
        this.setSSRC(datainputstream.readInt());
        length -= 4;
        while (length >= 4) {
            int bt = datainputstream.readUnsignedByte();
            datainputstream.readByte();
            int blockLength = datainputstream.readUnsignedShort() + 1 << 2;
            if (length < blockLength) {
                throw new IOException("Invalid extended block");
            }
            if (bt == 7) {
                this.addReportBlock(new VoIPMetricsReportBlock(blockLength - 4, datainputstream));
            } else {
                datainputstream.skip(blockLength - 4);
            }
            length -= blockLength;
        }
        if (length != 0) {
            throw new IOException("Invalid XR packet, unread bytes");
        }
    }

    public boolean addReportBlock(ReportBlock reportBlock) {
        if (reportBlock == null) {
            throw new NullPointerException("reportBlock");
        }
        return this.reportBlocks.add(reportBlock);
    }

    public void assemble(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeByte(128);
        dataoutputstream.writeByte(207);
        dataoutputstream.writeShort(this.calcLength() / 4 - 1);
        dataoutputstream.writeInt(this.getSSRC());
        for (ReportBlock reportBlock : this.getReportBlocks()) {
            reportBlock.assemble(dataoutputstream);
        }
    }

    public int calcLength() {
        int length = 8;
        for (ReportBlock reportBlock : this.getReportBlocks()) {
            length += reportBlock.calcLength();
        }
        return length;
    }

    public int getReportBlockCount() {
        return this.reportBlocks.size();
    }

    public List<ReportBlock> getReportBlocks() {
        return Collections.unmodifiableList(this.reportBlocks);
    }

    public int getSSRC() {
        return this.ssrc;
    }

    public long getSystemTimeStamp() {
        return this.systemTimeStamp;
    }

    public boolean removeReportBlock(ReportBlock reportBlock) {
        if (reportBlock == null) {
            return false;
        }
        return this.reportBlocks.remove(reportBlock);
    }

    public void setSSRC(int ssrc) {
        this.ssrc = ssrc;
    }

    public void setSystemTimeStamp(long systemTimeStamp) {
        this.systemTimeStamp = systemTimeStamp;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("RTCP XR");
        s.append(", SSRC ").append((long)this.getSSRC() & 0xFFFFFFFFL);
        List<ReportBlock> reportBlocks = this.getReportBlocks();
        boolean b = false;
        s.append(", report blocks [");
        for (ReportBlock reportBlock : reportBlocks) {
            if (b) {
                s.append("; ");
            } else {
                b = true;
            }
            s.append(reportBlock);
        }
        s.append("]");
        return s.toString();
    }

    public static class VoIPMetricsReportBlock
    extends ReportBlock {
        public static final byte ADAPTIVE_JITTER_BUFFER_ADAPTIVE = 3;
        public static final byte DISABLED_PACKET_LOSS_CONCEALMENT = 1;
        public static final byte ENHANCED_PACKET_LOSS_CONCEALMENT = 2;
        public static final byte NON_ADAPTIVE_JITTER_BUFFER_ADAPTIVE = 2;
        public static final byte RESERVED_JITTER_BUFFER_ADAPTIVE = 1;
        public static final String SDP_PARAMETER = "voip-metrics";
        public static final byte STANDARD_PACKET_LOSS_CONCEALMENT = 3;
        public static final byte UNKNOWN_JITTER_BUFFER_ADAPTIVE = 0;
        public static final byte UNSPECIFIED_PACKET_LOSS_CONCEALMENT = 0;
        public static final short VOIP_METRICS_REPORT_BLOCK_TYPE = 7;
        private short burstDensity = 0;
        private int burstDuration = 0;
        private short discardRate = 0;
        private int endSystemDelay = 0;
        private byte extRFactor = (byte)127;
        private short gapDensity = 0;
        private int gapDuration = 0;
        private short gMin = (short)16;
        private int jitterBufferAbsoluteMaximumDelay;
        private byte jitterBufferAdaptive = 0;
        private int jitterBufferMaximumDelay;
        private int jitterBufferNominalDelay;
        private byte jitterBufferRate = 0;
        private short lossRate = 0;
        private byte mosCq = (byte)127;
        private byte mosLq = (byte)127;
        private byte noiseLevel = (byte)127;
        private byte packetLossConcealment = 0;
        private byte residualEchoReturnLoss = (byte)127;
        private byte rFactor = (byte)127;
        private int roundTripDelay = 0;
        private byte signalLevel = (byte)127;
        private int sourceSSRC;

        public VoIPMetricsReportBlock() {
            super((short)7);
        }

        public VoIPMetricsReportBlock(int blockLength, DataInputStream datainputstream) throws IOException {
            this();
            if (blockLength != 32) {
                throw new IOException("Invalid RTCP XR VoIP Metrics block length.");
            }
            this.setSourceSSRC(datainputstream.readInt());
            this.setLossRate((short)datainputstream.readUnsignedByte());
            this.setDiscardRate((short)datainputstream.readUnsignedByte());
            this.setBurstDensity((short)datainputstream.readUnsignedByte());
            this.setGapDensity((short)datainputstream.readUnsignedByte());
            this.setBurstDuration(datainputstream.readUnsignedShort());
            this.setGapDuration(datainputstream.readUnsignedShort());
            this.setRoundTripDelay(datainputstream.readUnsignedShort());
            this.setEndSystemDelay(datainputstream.readUnsignedShort());
            this.setSignalLevel(datainputstream.readByte());
            this.setNoiseLevel(datainputstream.readByte());
            this.setResidualEchoReturnLoss(datainputstream.readByte());
            this.setGMin((short)datainputstream.readUnsignedByte());
            this.setRFactor(datainputstream.readByte());
            this.setExtRFactor(datainputstream.readByte());
            this.setMosLq(datainputstream.readByte());
            this.setMosCq(datainputstream.readByte());
            int rxConfig = datainputstream.readUnsignedByte();
            this.setPacketLossConcealment((byte)((rxConfig & 0xC0) >>> 6));
            this.setJitterBufferAdaptive((byte)((rxConfig & 0x30) >>> 4));
            this.setJitterBufferRate((byte)(rxConfig & 0xF));
            datainputstream.readByte();
            this.setJitterBufferNominalDelay(datainputstream.readUnsignedShort());
            this.setJitterBufferMaximumDelay(datainputstream.readUnsignedShort());
            this.setJitterBufferAbsoluteMaximumDelay(datainputstream.readUnsignedShort());
        }

        @Override
        protected void assemble(DataOutputStream dataoutputstream) throws IOException {
            dataoutputstream.writeByte(7);
            dataoutputstream.writeByte(0);
            dataoutputstream.writeShort(8);
            dataoutputstream.writeInt(this.getSourceSSRC());
            dataoutputstream.writeByte(this.getLossRate());
            dataoutputstream.writeByte(this.getDiscardRate());
            dataoutputstream.writeByte(this.getBurstDensity());
            dataoutputstream.writeByte(this.getGapDensity());
            dataoutputstream.writeShort(this.getBurstDuration());
            dataoutputstream.writeShort(this.getGapDuration());
            dataoutputstream.writeShort(this.getRoundTripDelay());
            dataoutputstream.writeShort(this.getEndSystemDelay());
            dataoutputstream.writeByte(this.getSignalLevel());
            dataoutputstream.writeByte(this.getNoiseLevel());
            dataoutputstream.writeByte(this.getResidualEchoReturnLoss());
            dataoutputstream.writeByte(this.getGMin());
            dataoutputstream.writeByte(this.getRFactor());
            dataoutputstream.writeByte(this.getExtRFactor());
            dataoutputstream.writeByte(this.getMosLq());
            dataoutputstream.writeByte(this.getMosCq());
            dataoutputstream.writeByte((this.getPacketLossConcealment() & 3) << 6 | (this.getJitterBufferAdaptive() & 3) << 4 | this.getJitterBufferRate() & 0xF);
            dataoutputstream.writeByte(0);
            dataoutputstream.writeShort(this.getJitterBufferNominalDelay());
            dataoutputstream.writeShort(this.getJitterBufferMaximumDelay());
            dataoutputstream.writeShort(this.getJitterBufferAbsoluteMaximumDelay());
        }

        @Override
        public int calcLength() {
            return 36;
        }

        public short getBurstDensity() {
            return this.burstDensity;
        }

        public int getBurstDuration() {
            return this.burstDuration;
        }

        public short getDiscardRate() {
            return this.discardRate;
        }

        public int getEndSystemDelay() {
            return this.endSystemDelay;
        }

        public byte getExtRFactor() {
            return this.extRFactor;
        }

        public short getGapDensity() {
            return this.gapDensity;
        }

        public int getGapDuration() {
            return this.gapDuration;
        }

        public short getGMin() {
            return this.gMin;
        }

        public int getJitterBufferAbsoluteMaximumDelay() {
            return this.jitterBufferAbsoluteMaximumDelay;
        }

        public byte getJitterBufferAdaptive() {
            return this.jitterBufferAdaptive;
        }

        public int getJitterBufferMaximumDelay() {
            return this.jitterBufferMaximumDelay;
        }

        public int getJitterBufferNominalDelay() {
            return this.jitterBufferNominalDelay;
        }

        public byte getJitterBufferRate() {
            return this.jitterBufferRate;
        }

        public short getLossRate() {
            return this.lossRate;
        }

        public byte getMosCq() {
            return this.mosCq;
        }

        public byte getMosLq() {
            return this.mosLq;
        }

        public byte getNoiseLevel() {
            return this.noiseLevel;
        }

        public byte getPacketLossConcealment() {
            return this.packetLossConcealment;
        }

        public byte getResidualEchoReturnLoss() {
            return this.residualEchoReturnLoss;
        }

        public byte getRFactor() {
            return this.rFactor;
        }

        public int getRoundTripDelay() {
            return this.roundTripDelay;
        }

        public byte getSignalLevel() {
            return this.signalLevel;
        }

        public int getSourceSSRC() {
            return this.sourceSSRC;
        }

        public void setBurstDensity(short burstDensity) {
            this.burstDensity = burstDensity;
        }

        public void setBurstDuration(int burstDuration) {
            this.burstDuration = burstDuration;
        }

        public void setDiscardRate(short discardRate) {
            this.discardRate = discardRate;
        }

        public void setEndSystemDelay(int endSystemDelay) {
            this.endSystemDelay = endSystemDelay;
        }

        public void setExtRFactor(byte extRFactor) {
            this.extRFactor = extRFactor;
        }

        public void setGapDensity(short gapDensity) {
            this.gapDensity = gapDensity;
        }

        public void setGapDuration(int gapDuration) {
            this.gapDuration = gapDuration;
        }

        public void setGMin(short gMin) {
            this.gMin = gMin;
        }

        public void setJitterBufferAbsoluteMaximumDelay(int jitterBufferAbsoluteMaximumDelay) {
            this.jitterBufferAbsoluteMaximumDelay = jitterBufferAbsoluteMaximumDelay;
        }

        public void setJitterBufferAdaptive(byte jitterBufferAdaptive) {
            switch (jitterBufferAdaptive) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.jitterBufferAdaptive = jitterBufferAdaptive;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("jitterBufferAdaptive");
                }
            }
        }

        public void setJitterBufferMaximumDelay(int jitterBufferMaximumDelay) {
            this.jitterBufferMaximumDelay = jitterBufferMaximumDelay;
        }

        public void setJitterBufferNominalDelay(int jitterBufferNominalDelay) {
            this.jitterBufferNominalDelay = jitterBufferNominalDelay;
        }

        public void setJitterBufferRate(byte jitterBufferRate) {
            this.jitterBufferRate = jitterBufferRate;
        }

        public void setLossRate(short lossRate) {
            this.lossRate = lossRate;
        }

        public void setMosCq(byte mosCq) {
            this.mosCq = mosCq;
        }

        public void setMosLq(byte mosLq) {
            this.mosLq = mosLq;
        }

        public void setNoiseLevel(byte noiseLevel) {
            this.noiseLevel = noiseLevel;
        }

        public void setPacketLossConcealment(byte packetLossConcealment) {
            switch (packetLossConcealment) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.packetLossConcealment = packetLossConcealment;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("packetLossConcealment");
                }
            }
        }

        public void setResidualEchoReturnLoss(byte residualEchoReturnLoss) {
            this.residualEchoReturnLoss = residualEchoReturnLoss;
        }

        public void setRFactor(byte rFactor) {
            this.rFactor = rFactor;
        }

        public void setRoundTripDelay(int roundTripDelay) {
            this.roundTripDelay = roundTripDelay;
        }

        public void setSignalLevel(byte signalLevel) {
            this.signalLevel = signalLevel;
        }

        public void setSourceSSRC(int sourceSSRC) {
            this.sourceSSRC = sourceSSRC;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("VoIP Metrics");
            s.append(", SSRC of source ").append((long)this.getSourceSSRC() & 0xFFFFFFFFL);
            s.append(", loss rate ").append(this.getLossRate());
            s.append(", discard rate ").append(this.getDiscardRate());
            s.append(", burst density ").append(this.getBurstDensity());
            s.append(", gap density ").append(this.getGapDensity());
            s.append(", burst duration ").append(this.getBurstDuration());
            s.append(", gap duration ").append(this.getGapDuration());
            s.append(", round trip delay ").append(this.getRoundTripDelay());
            return s.toString();
        }
    }

    public static abstract class ReportBlock {
        public final short blockType;

        protected ReportBlock(short blockType) {
            this.blockType = blockType;
        }

        protected abstract void assemble(DataOutputStream var1) throws IOException;

        public int calcLength() {
            return 4;
        }
    }
}

