/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.format.VideoFormat;

public abstract class BasicPlugIn
implements PlugIn {
    private static final boolean DEBUG = false;
    protected Object[] controls = new Control[0];
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = Class.class.getMethod("forName", String.class, Boolean.TYPE, ClassLoader.class);
            Method getSystemClassLoaderM = ClassLoader.class.getMethod("getSystemClassLoader", new Class[0]);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke(ClassLoader.class, new Object[0]);
            getContextClassLoaderM = Thread.class.getMethod("getContextClassLoader", new Class[0]);
            return true;
        }
        catch (Throwable t) {
            forName3ArgsM = null;
            return false;
        }
    }

    public static Class<?> getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e) {
                if (!BasicPlugIn.checkIfJDK12()) {
                    throw new ClassNotFoundException(e.getMessage());
                }
            }
            catch (Error e) {
                if (BasicPlugIn.checkIfJDK12()) break block9;
                throw e;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke(Class.class, className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable e) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), new Object[0]);
                return (Class)forName3ArgsM.invoke(Class.class, className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e2) {
                throw new ClassNotFoundException(e2.getMessage());
            }
            catch (Error e3) {
                throw e3;
            }
        }
    }

    public static Format matches(Format in, Format[] outs) {
        for (int i = 0; i < outs.length; ++i) {
            if (!in.matches(outs[i])) continue;
            return outs[i];
        }
        return null;
    }

    public static boolean plugInExists(String name, int type) {
        Vector cnames = PlugInManager.getPlugInList(null, null, type);
        for (int i = 0; i < cnames.size(); ++i) {
            if (!name.equals(cnames.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected void error() {
        throw new RuntimeException(this.getClass().getName() + " PlugIn error");
    }

    @Override
    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i = 0; i < cs.length; ++i) {
                if (!cls.isInstance(cs[i])) continue;
                return cs[i];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object[] getControls() {
        return this.controls;
    }

    protected Object getInputData(Buffer inBuffer) {
        return inBuffer.getData();
    }

    protected final long getNativeData(Object data) {
        return 0L;
    }

    protected Object getOutputData(Buffer buffer) {
        return buffer.getData();
    }

    protected byte[] validateByteArraySize(Buffer buffer, int newSize) {
        byte[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof byte[]) {
            typedArray = (byte[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            byte[] tempArray = new byte[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new byte[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected Object validateData(Buffer buffer, int length, boolean allowNative) {
        Format format = buffer.getFormat();
        Class<?> dataType = format.getDataType();
        if (length < 1 && format != null && format instanceof VideoFormat) {
            length = ((VideoFormat)format).getMaxDataLength();
        }
        if (dataType == Format.byteArray) {
            return this.validateByteArraySize(buffer, length);
        }
        if (dataType == Format.shortArray) {
            return this.validateShortArraySize(buffer, length);
        }
        if (dataType == Format.intArray) {
            return this.validateIntArraySize(buffer, length);
        }
        System.err.println("Error in validateData");
        return null;
    }

    protected int[] validateIntArraySize(Buffer buffer, int newSize) {
        int[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof int[]) {
            typedArray = (int[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            int[] tempArray = new int[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new int[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected short[] validateShortArraySize(Buffer buffer, int newSize) {
        short[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof short[]) {
            typedArray = (short[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            short[] tempArray = new short[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new short[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }
}

