/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.rtp.rtcp.Feedback;

public class RTCPReportBlock
implements Feedback {
    int ssrc;
    int fractionlost;
    int packetslost;
    long lastseq;
    int jitter;
    long lsr;
    long dlsr;
    public long receiptTime;

    public static String toString(RTCPReportBlock[] reports) {
        String s = "";
        for (int i = 0; i < reports.length; ++i) {
            s = s + reports[i];
        }
        return s;
    }

    public RTCPReportBlock(int ssrc, int fractionlost, int packetslost, long lastseq, int jitter, long lsr, long dlsr) {
        this.ssrc = ssrc;
        this.fractionlost = fractionlost;
        this.packetslost = packetslost;
        this.lastseq = lastseq;
        this.jitter = jitter;
        this.lsr = lsr;
        this.dlsr = dlsr;
    }

    public RTCPReportBlock() {
    }

    @Override
    public long getDLSR() {
        return this.dlsr;
    }

    @Override
    public int getFractionLost() {
        return this.fractionlost;
    }

    @Override
    public long getJitter() {
        return this.jitter;
    }

    @Override
    public long getLSR() {
        return this.lsr;
    }

    @Override
    public long getNumLost() {
        return this.packetslost;
    }

    @Override
    public long getSSRC() {
        return this.ssrc;
    }

    @Override
    public long getXtndSeqNum() {
        return this.lastseq;
    }

    public String toString() {
        long printssrc = 0xFFFFFFFFL & (long)this.ssrc;
        return "\t\tFor source " + printssrc + "\n\t\t\tFraction of packets lost: " + this.fractionlost + " (" + (double)this.fractionlost / 256.0 + ")\n\t\t\tPackets lost: " + this.packetslost + "\n\t\t\tLast sequence number: " + this.lastseq + "\n\t\t\tJitter: " + this.jitter + "\n\t\t\tLast SR packet received at time " + this.lsr + "\n\t\t\tDelay since last SR packet received: " + this.dlsr + " (" + (double)this.dlsr / 65536.0 + " seconds)\n";
    }
}

