/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.jboss.modules.ModuleClassLoader"};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    private void handleResourceLoader(Object resourceLoader, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        File file;
        if (resourceLoader == null) {
            return;
        }
        Object root = ReflectionUtils.getFieldVal(resourceLoader, "root", false);
        File physicalFile = (File)ReflectionUtils.invokeMethod(root, "getPhysicalFile", false);
        String path = null;
        if (physicalFile != null) {
            File file2;
            String name = (String)ReflectionUtils.invokeMethod(root, "getName", false);
            path = name != null ? (FileUtils.canRead(file2 = new File(physicalFile.getParentFile(), name)) ? file2.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
        } else {
            path = (String)ReflectionUtils.invokeMethod(root, "getPathName", false);
            if (path == null) {
                File file3 = root instanceof Path ? ((Path)root).toFile() : (file = root instanceof File ? (File)root : null);
                if (file != null) {
                    path = file.getAbsolutePath();
                }
            }
        }
        if (path == null && (file = (File)ReflectionUtils.getFieldVal(resourceLoader, "fileOfJar", false)) != null) {
            path = file.getAbsolutePath();
        }
        if (path != null) {
            classpathOrderOut.addClasspathEntry(path, classLoader, log);
        } else if (log != null) {
            log.log("Could not determine classpath for ResourceLoader: " + resourceLoader);
        }
    }

    private void handleRealModule(Object module, Set<Object> visitedModules, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object vfsResourceLoaders;
        if (!visitedModules.add(module)) {
            return;
        }
        ClassLoader moduleLoader = (ClassLoader)ReflectionUtils.invokeMethod(module, "getClassLoader", false);
        if (moduleLoader == null) {
            moduleLoader = classLoader;
        }
        if ((vfsResourceLoaders = ReflectionUtils.invokeMethod(moduleLoader, "getResourceLoaders", false)) != null) {
            int n = Array.getLength(vfsResourceLoaders);
            for (int i = 0; i < n; ++i) {
                Object resourceLoader = Array.get(vfsResourceLoaders, i);
                this.handleResourceLoader(resourceLoader, moduleLoader, classpathOrderOut, log);
            }
        }
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object module = ReflectionUtils.invokeMethod(classLoader, "getModule", false);
        Object callerModuleLoader = ReflectionUtils.invokeMethod(module, "getCallerModuleLoader", false);
        HashSet<Object> visitedModules = new HashSet<Object>();
        Map moduleMap = (Map)ReflectionUtils.getFieldVal(callerModuleLoader, "moduleMap", false);
        for (Map.Entry ent : moduleMap.entrySet()) {
            Object val = ent.getValue();
            Object realModule = ReflectionUtils.invokeMethod(val, "getModule", false);
            this.handleRealModule(realModule, visitedModules, classLoader, classpathOrderOut, log);
        }
        Map pathsMap = (Map)ReflectionUtils.invokeMethod(module, "getPaths", false);
        for (Map.Entry ent : pathsMap.entrySet()) {
            for (Object localLoader : (List)ent.getValue()) {
                Object moduleClassLoader = ReflectionUtils.getFieldVal(localLoader, "this$0", false);
                Object realModule = ReflectionUtils.getFieldVal(moduleClassLoader, "module", false);
                this.handleRealModule(realModule, visitedModules, classLoader, classpathOrderOut, log);
            }
        }
    }
}

