/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.IOException;
import java.io.InputStream;

class FixedSizeInputStream
extends InputStream {
    private long myLength;
    private InputStream mySource;

    public FixedSizeInputStream(InputStream source, long length) {
        this.mySource = source;
        this.myLength = length;
    }

    public int read() throws IOException {
        if (this.myLength > 0L) {
            --this.myLength;
            return this.mySource.read();
        }
        return -1;
    }

    public void close() {
        if (this.myLength > 0L) {
            try {
                FixedSizeInputStream.consumeRemaining(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void consumeRemaining(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        while (is.read(buffer) >= 0) {
        }
    }
}

