/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.svn.SVNEditModeReader;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.util.SVNDebugLog;

class SVNReader {
    private static final char[] VALID_TEMPLATE_CHARS = new char[]{'(', ')', '[', ']', 's', 'w', 'b', 'i', 'n', 't', 'p', 'd', 'f', 'l', 'a', 'r', 'e', 'x', 'l', '?', '*', 'z'};
    private static final char[] INVALID_CARDINALITY_SUBJECTS = new char[]{'(', ')', '[', ']', '?', '*', '<'};

    SVNReader() {
    }

    public static Date getDate(Object[] items, int index) {
        String str = SVNReader.getString(items, index);
        return SVNTimeUtil.parseDate(str);
    }

    public static long getLong(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return -1L;
        }
        if (items[index] instanceof Long) {
            return (Long)items[index];
        }
        if (items[index] instanceof Integer) {
            return ((Integer)items[index]).intValue();
        }
        return -1L;
    }

    public static boolean getBoolean(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return false;
        }
        if (items[index] instanceof Boolean) {
            return (Boolean)items[index];
        }
        if (items[index] instanceof String) {
            return Boolean.valueOf((String)items[index]);
        }
        return false;
    }

    public static Map getMap(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return Collections.EMPTY_MAP;
        }
        if (items[index] instanceof Map) {
            return (Map)items[index];
        }
        return Collections.EMPTY_MAP;
    }

    public static List getList(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return Collections.EMPTY_LIST;
        }
        if (items[index] instanceof List) {
            return (List)items[index];
        }
        return Collections.EMPTY_LIST;
    }

    public static String getString(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return null;
        }
        if (items[index] instanceof byte[]) {
            try {
                return new String((byte[])items[index], "UTF-8");
            }
            catch (IOException e) {
                return null;
            }
        }
        if (items[index] instanceof String) {
            return (String)items[index];
        }
        return null;
    }

    public static boolean hasValue(Object[] items, int index, boolean value) {
        return SVNReader.hasValue(items, index, (Object)value);
    }

    public static boolean hasValue(Object[] items, int index, int value) {
        return SVNReader.hasValue(items, index, new Long(value));
    }

    public static boolean hasValue(Object[] items, int index, Object value) {
        if (items == null || index >= items.length) {
            return false;
        }
        if (items[index] instanceof List) {
            for (Object element : (List)items[index]) {
                if (!element.equals(value)) continue;
                return true;
            }
        } else {
            if (items[index] == null) {
                return value == null;
            }
            if (items[index] instanceof byte[] && value instanceof String) {
                try {
                    items[index] = new String((byte[])items[index], "UTF-8");
                }
                catch (IOException e) {
                    return false;
                }
            }
            return items[index].equals(value);
        }
        return false;
    }

    public static Object[] parse(InputStream is, String templateStr, Object[] target) throws SVNException {
        if (target != null) {
            for (int i = 0; i < target.length; ++i) {
                if (target[i] instanceof Collection || target[i] instanceof Map || target[i] instanceof ISVNDirEntryHandler || target[i] instanceof ISVNEditor || target[i] instanceof OutputStream) continue;
                target[i] = null;
            }
        }
        StringBuffer template = SVNReader.normalizeTemplate(templateStr);
        SVNEditModeReader editorBaton = null;
        int targetIndex = 0;
        boolean unconditionalThrow = false;
        for (int i = 0; i < template.length(); ++i) {
            char ch = template.charAt(i);
            boolean optional = ch == '?' || ch == '*';
            boolean multiple = ch == '*';
            boolean doRead = Character.isUpperCase(ch) && !SVNReader.isListed(INVALID_CARDINALITY_SUBJECTS, ch);
            ch = Character.toLowerCase(ch);
            if (optional) {
                char next = i + 1 < template.length() ? template.charAt(i + 1) : (char)'<';
                doRead = Character.isUpperCase(next) && !SVNReader.isListed(INVALID_CARDINALITY_SUBJECTS, next);
                if (SVNReader.isListed(INVALID_CARDINALITY_SUBJECTS, next = Character.toLowerCase(next))) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed template data, ''{0}''", templateStr));
                }
                ++i;
                ch = next;
            }
            is.mark(512);
            Object result = null;
            try {
                block70: {
                    String word;
                    String name;
                    if (ch == 'b' || ch == 'i' || ch == 's') {
                        result = ch == 'b' ? SVNReader.readStringAsBytes(is) : (ch == 's' ? (Object)SVNReader.readString(is) : (Object)SVNReader.createDelegatingStream(is));
                    } else if (ch == 'p') {
                        SVNReader.readChar(is, '(');
                        name = SVNReader.readString(is);
                        String value = null;
                        is.mark(256);
                        try {
                            value = SVNReader.readString(is);
                            is.mark(-1);
                        }
                        catch (SVNException exception) {
                            try {
                                value = null;
                                is.reset();
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                        SVNReader.readChar(is, ')');
                        result = new String[]{name, value};
                    } else if (ch == 'z') {
                        SVNReader.readChar(is, '(');
                        name = SVNReader.readString(is);
                        String value = null;
                        SVNReader.readChar(is, '(');
                        is.mark(256);
                        try {
                            value = SVNReader.readString(is);
                            is.mark(-1);
                        }
                        catch (SVNException exception) {
                            try {
                                value = null;
                                is.reset();
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                        SVNReader.readChar(is, ')');
                        SVNReader.readChar(is, ')');
                        result = new String[]{name, value};
                    } else if (ch == 'w') {
                        word = SVNReader.readWord(is);
                        result = word;
                    } else if (ch == 't') {
                        result = SVNReader.readBoolean(is);
                    } else if (ch == 'n') {
                        result = new Long(SVNReader.readNumber(is));
                    } else if (ch == '[') {
                        SVNReader.readChar(is, '(');
                        word = SVNReader.readWord(is);
                        if ("failure".equals(word)) {
                            SVNReader.readChar(is, '(');
                            ArrayList<SVNErrorMessage> errorMessages = new ArrayList<SVNErrorMessage>();
                            try {
                                while (true) {
                                    is.mark(256);
                                    SVNErrorMessage err = SVNReader.readError(is);
                                    errorMessages.add(err);
                                    is.mark(-1);
                                }
                            }
                            catch (SVNException e) {
                                is.reset();
                                SVNReader.readChar(is, ')');
                                SVNReader.readChar(is, ')');
                                unconditionalThrow = true;
                                SVNErrorMessage topError = (SVNErrorMessage)errorMessages.get(0);
                                for (int k = 1; k < errorMessages.size(); ++k) {
                                    SVNErrorMessage child = (SVNErrorMessage)errorMessages.get(k);
                                    topError.setChildErrorMessage(child);
                                    topError = child;
                                }
                                SVNErrorManager.error((SVNErrorMessage)errorMessages.get(0));
                            }
                        } else if (!"success".equals(word)) {
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Unknown status ''{0}'' in command response", word));
                        }
                    } else if (ch == ')' || ch == ']') {
                        SVNReader.readChar(is, ')');
                    } else if (ch == '(') {
                        SVNReader.readChar(is, '(');
                    } else if (ch == 'd') {
                        result = SVNReader.readDirEntry(is);
                    } else if (ch == 'f') {
                        result = SVNReader.readStatEntry(is);
                    } else if (ch == 'e') {
                        if (editorBaton == null) {
                            editorBaton = new SVNEditModeReader();
                            if (target[targetIndex] instanceof ISVNEditor) {
                                editorBaton.setEditor((ISVNEditor)target[targetIndex]);
                            }
                        }
                        SVNReader.readChar(is, '(');
                        String commandName = SVNReader.readWord(is);
                        boolean hasMore = false;
                        try {
                            hasMore = editorBaton.processCommand(commandName, is);
                        }
                        catch (Throwable th) {
                            unconditionalThrow = true;
                            SVNDebugLog.getDefaultLog().info(th);
                            if (th instanceof SVNException) {
                                throw (SVNException)th;
                            }
                            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, th.getMessage()), th);
                        }
                        if (!"textdelta-chunk".equals(commandName)) {
                            SVNReader.readChar(is, ')');
                        }
                        if (!hasMore) {
                            return target;
                        }
                    } else {
                        if (ch == 'x') {
                            try {
                                word = SVNReader.readWord(is);
                                if (!"done".equals(word)) {
                                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed network data, 'done' expected"));
                                }
                                break block70;
                            }
                            catch (SVNException e) {
                                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_MALFORMED_DATA) {
                                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed network data, 'done' expected"));
                                }
                                break block70;
                            }
                        }
                        if (ch == 'l') {
                            result = SVNReader.readLock(is);
                        }
                    }
                }
                if (doRead) {
                    target = SVNReader.reportResult(target, targetIndex, result, multiple);
                }
                if (multiple) {
                    i -= 2;
                } else if (doRead) {
                    ++targetIndex;
                }
            }
            catch (SVNException e) {
                if (unconditionalThrow || e instanceof SVNCancelException || e instanceof SVNAuthenticationException) {
                    throw e;
                }
                try {
                    is.reset();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                if (optional) {
                    if (doRead) {
                        ++targetIndex;
                    }
                }
                throw e;
            }
            catch (IOException ioException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, ioException.getMessage()));
            }
            is.mark(-1);
        }
        if (target == null) {
            target = new Object[]{};
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] reportResult(Object[] target, int index, Object result, boolean multiple) throws SVNException {
        if (target == null) {
            target = new Object[index + 1];
        } else if (index >= target.length) {
            Object[] array = new Object[index + 1];
            System.arraycopy(target, 0, array, 0, target.length);
            target = array;
        }
        if (target[index] instanceof ISVNDirEntryHandler) {
            ISVNDirEntryHandler handler = (ISVNDirEntryHandler)target[index];
            if (result instanceof SVNDirEntry) {
                handler.handleDirEntry((SVNDirEntry)result);
            }
        } else if (target[index] == null) {
            target[index] = result instanceof String[] ? new HashMap() : (multiple ? new LinkedList() : result);
        } else if (target[index] instanceof OutputStream && result instanceof InputStream) {
            InputStream in = (InputStream)result;
            OutputStream out = (OutputStream)target[index];
            byte[] buffer = new byte[2048];
            boolean cancelled = false;
            try {
                int read;
                while ((read = in.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                out.flush();
            }
            catch (IOException e) {
                cancelled = true;
                if (e instanceof SVNCancellableOutputStream.IOCancelException) {
                    SVNErrorManager.cancel(e.getMessage());
                }
            }
            finally {
                try {
                    while (!cancelled && in.read(buffer) > 0) {
                    }
                }
                catch (IOException e1) {}
            }
        }
        if (target[index] instanceof List) {
            ((List)target[index]).add(result);
        } else if (target[index] instanceof Map && result instanceof String[]) {
            String[] property = (String[])result;
            ((Map)target[index]).put(property[0], property[1]);
        }
        return target;
    }

    private static StringBuffer normalizeTemplate(String template) throws SVNException {
        StringBuffer sb = new StringBuffer(template.length());
        for (int i = 0; i < template.length(); ++i) {
            char ch = template.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            char tch = Character.toLowerCase(ch);
            if (SVNReader.isListed(VALID_TEMPLATE_CHARS, tch)) {
                sb.append(ch);
                continue;
            }
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Template ''{0}'' is not valid", template));
        }
        return sb;
    }

    private static boolean isListed(char[] chars, char test) {
        for (int i = 0; i < chars.length; ++i) {
            if (test != chars[i]) continue;
            return true;
        }
        return false;
    }

    private static char skipWhitespace(InputStream is) throws IOException {
        char read;
        while (Character.isWhitespace(read = (char)is.read())) {
        }
        return read;
    }

    private static byte[] readStringAsBytes(InputStream is) throws IOException, SVNException {
        int length = SVNReader.readStringLength(is);
        return SVNReader.readBytes(is, length, null);
    }

    private static String readString(InputStream is) throws IOException, SVNException {
        int length = SVNReader.readStringLength(is);
        return new String(SVNReader.readBytes(is, length, null), 0, length, "UTF-8");
    }

    private static int readStringLength(InputStream is) throws IOException, SVNException {
        char ch = SVNReader.skipWhitespace(is);
        int length = 0;
        while (Character.isDigit(ch)) {
            length *= 10;
            length += ch - 48;
            ch = (char)is.read();
        }
        if (ch == ':') {
            return length;
        }
        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed network data, string length expected"));
        return -1;
    }

    private static int readNumber(InputStream is) throws IOException, SVNException {
        char ch = SVNReader.skipWhitespace(is);
        int length = 0;
        while (Character.isDigit(ch)) {
            length *= 10;
            length += ch - 48;
            ch = (char)is.read();
        }
        if (Character.isWhitespace(ch)) {
            return length;
        }
        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed network data, number expected"));
        return -1;
    }

    private static String readWord(InputStream is) throws IOException, SVNException {
        char ch = SVNReader.skipWhitespace(is);
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        while (!Character.isWhitespace(ch)) {
            if (count == 0 && !Character.isLetter(ch)) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed network data"));
            } else if (count > 0 && !Character.isLetterOrDigit(ch) && ch != '-') {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed network data"));
            }
            buffer.append(ch);
            ++count;
            ch = (char)is.read();
        }
        return buffer.toString();
    }

    private static boolean readBoolean(InputStream is) throws IOException, SVNException {
        String word = SVNReader.readWord(is);
        if ("true".equalsIgnoreCase(word)) {
            return true;
        }
        if ("false".equalsIgnoreCase(word)) {
            return false;
        }
        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed network data, 'true' or 'false' expected"));
        return false;
    }

    private static void readChar(InputStream is, char test) throws IOException, SVNException {
        char ch = SVNReader.skipWhitespace(is);
        if (ch != test) {
            if (ch < '\u0000' || ch == '\uffff') {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED));
            }
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Malformed network data"));
        }
    }

    private static byte[] readBytes(InputStream is, int length, byte[] buffer) throws IOException {
        int r;
        if (buffer == null || buffer.length < length) {
            buffer = new byte[length];
        }
        for (int offset = 0; offset < length; offset += r) {
            r = is.read(buffer, offset, length - offset);
            if (r > 0) continue;
            throw new IOException("Input/Output error while receiving svn data");
        }
        return buffer;
    }

    private static InputStream createDelegatingStream(final InputStream source) throws IOException, SVNException {
        int length = SVNReader.readStringLength(source);
        final int[] counter = new int[]{length};
        return new InputStream(){

            public int read() throws IOException {
                if (counter[0] > 0) {
                    counter[0] = counter[0] - 1;
                    return source.read();
                }
                return -1;
            }
        };
    }

    private static SVNErrorMessage readError(InputStream is) throws IOException, SVNException {
        InputStream pis = is;
        SVNReader.readChar(pis, '(');
        int code = SVNReader.readNumber(pis);
        String errorMessage = SVNReader.readString(pis);
        SVNReader.readString(pis);
        SVNReader.readNumber(pis);
        SVNReader.readChar(pis, ')');
        SVNErrorCode errorCode = SVNErrorCode.getErrorCode(code);
        return SVNErrorMessage.create(errorCode, errorMessage);
    }

    private static SVNDirEntry readDirEntry(InputStream is) throws SVNException {
        Object[] items = SVNReader.parse(is, "(SWNTN(?S)(?S))", null);
        String name = SVNReader.getString(items, 0);
        SVNNodeKind kind = SVNNodeKind.parseKind(SVNReader.getString(items, 1));
        long size = SVNReader.getLong(items, 2);
        boolean hasProps = SVNReader.getBoolean(items, 3);
        long revision = SVNReader.getLong(items, 4);
        Date date = items[5] != null ? SVNTimeUtil.parseDate(SVNReader.getString(items, 5)) : null;
        String author = SVNReader.getString(items, 6);
        return new SVNDirEntry(null, name, kind, size, hasProps, revision, date, author);
    }

    private static SVNDirEntry readStatEntry(InputStream is) throws SVNException {
        Object[] items = SVNReader.parse(is, "(WNTN(?S)(?S))", null);
        SVNNodeKind kind = SVNNodeKind.parseKind(SVNReader.getString(items, 0));
        long size = SVNReader.getLong(items, 1);
        boolean hasProps = SVNReader.getBoolean(items, 2);
        long revision = SVNReader.getLong(items, 3);
        Date date = items[4] != null ? SVNTimeUtil.parseDate(SVNReader.getString(items, 4)) : null;
        String author = SVNReader.getString(items, 5);
        return new SVNDirEntry(null, null, kind, size, hasProps, revision, date, author);
    }

    private static SVNLock readLock(InputStream is) throws SVNException {
        Object[] items = SVNReader.parse(is, "(SSS(?S)S(?S))", new Object[6]);
        String path = (String)items[0];
        String id = (String)items[1];
        String owner = (String)items[2];
        String comment = (String)items[3];
        String creationDate = (String)items[4];
        String expirationDate = (String)items[5];
        Date created = creationDate != null ? SVNTimeUtil.parseDate(creationDate) : null;
        Date expires = expirationDate != null ? SVNTimeUtil.parseDate(expirationDate) : null;
        return new SVNLock(path, id, owner, comment, created, expires);
    }
}

