/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SVNRollbackInputStream
extends InputStream {
    private int myLength;
    private byte[] myBuffer;
    private InputStream mySource;
    private int myPosition;
    private List myMarks;

    public SVNRollbackInputStream(InputStream source, int maxBufferSize) {
        this.mySource = source;
        this.myBuffer = new byte[maxBufferSize];
        this.myLength = 0;
        this.myPosition = 0;
        this.myMarks = new ArrayList();
    }

    public int read() throws IOException {
        if (this.myPosition < this.myLength) {
            ++this.myPosition;
            return this.myBuffer[this.myPosition - 1];
        }
        int r = this.mySource.read();
        if (r >= 0) {
            this.buffer((byte)(r & 0xFF));
        }
        return r;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        int reallyRead = 0;
        if (this.myPosition < this.myLength) {
            reallyRead = read = Math.min(len, this.myLength - this.myPosition);
            System.arraycopy(this.myBuffer, this.myPosition, b, off, read);
            this.myPosition += read;
        }
        if (read < len) {
            this.buffer(b, off + read, (reallyRead += this.mySource.read(b, off + read, len - read)) - read);
        }
        return reallyRead;
    }

    public synchronized void mark(int readlimit) {
        if (readlimit < 0) {
            if (!this.myMarks.isEmpty()) {
                this.myMarks.remove(this.myMarks.size() - 1);
            }
        } else {
            this.myMarks.add(new Mark(this.myPosition));
        }
    }

    public synchronized void reset() throws IOException {
        if (this.myMarks.isEmpty()) {
            throw new IOException("No valid mark found");
        }
        Mark lastMark = (Mark)this.myMarks.remove(this.myMarks.size() - 1);
        this.myPosition = lastMark.position;
    }

    public boolean markSupported() {
        return true;
    }

    private void buffer(byte b) {
        if (this.myMarks.isEmpty()) {
            this.myLength = 0;
            this.myPosition = 0;
            return;
        }
        if (this.myLength < this.myBuffer.length) {
            this.myBuffer[this.myLength] = b;
            ++this.myLength;
        } else {
            this.shiftBufferLeft(1);
            this.myBuffer[this.myLength - 1] = b;
            this.adjustMarks(1);
        }
        this.myPosition = this.myLength;
    }

    private void buffer(byte[] b, int off, int len) {
        if (this.myMarks.isEmpty()) {
            this.myLength = 0;
            this.myPosition = 0;
            return;
        }
        if (this.myLength + len < this.myBuffer.length) {
            System.arraycopy(b, off, this.myBuffer, this.myLength, len);
            this.myLength += len;
        } else if (len < this.myBuffer.length) {
            this.shiftBufferLeft(len);
            System.arraycopy(b, off, this.myBuffer, this.myBuffer.length - len, len);
            this.adjustMarks(len);
        } else {
            this.myLength = 0;
            this.myMarks.clear();
        }
        this.myPosition = this.myLength;
    }

    private void shiftBufferLeft(int shift) {
        byte[] newBuffer = new byte[this.myBuffer.length];
        System.arraycopy(this.myBuffer, shift, newBuffer, 0, this.myBuffer.length - shift);
        this.myBuffer = newBuffer;
    }

    private void adjustMarks(int shift) {
        Iterator marks = this.myMarks.iterator();
        while (marks.hasNext()) {
            Mark mark = (Mark)marks.next();
            mark.position -= shift;
            if (mark.position >= 0) continue;
            marks.remove();
        }
    }

    private static class Mark {
        int position;

        public Mark(int pos) {
            this.position = pos;
        }
    }
}

