/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.jitsi.utils.logging.Logger;

public class PropertyChangeNotifier {
    private static final Logger logger = Logger.getLogger(PropertyChangeNotifier.class);
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("The specified argument listener is null and that does not make sense.");
            }
        } else {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        PropertyChangeListener[] ls;
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
        }
        if (ls.length != 0) {
            PropertyChangeEvent ev = new PropertyChangeEvent(this.getPropertyChangeSource(property, oldValue, newValue), property, oldValue, newValue);
            for (PropertyChangeListener l : ls) {
                try {
                    l.propertyChange(ev);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.warn("A PropertyChangeListener threw an exception while handling a PropertyChangeEvent.", t);
                }
            }
        }
    }

    protected Object getPropertyChangeSource(String property, Object oldValue, Object newValue) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

