/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class InstallMojo
extends AbstractInstallMojo {
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    protected String packaging;
    @Parameter(defaultValue="${project.file}", required=true, readonly=true)
    private File pomFile;
    @Parameter(property="maven.install.skip", defaultValue="false", required=true)
    private boolean skip;
    @Parameter(defaultValue="${project.artifact}", required=true, readonly=true)
    private Artifact artifact;
    @Parameter(defaultValue="${project.attachedArtifacts}", required=true, readonly=true)
    private List attachedArtifacts;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact installation");
            return;
        }
        boolean isPomArtifact = "pom".equals(this.packaging);
        ProjectArtifactMetadata metadata = null;
        if (this.updateReleaseInfo) {
            this.artifact.setRelease(true);
        }
        try {
            LinkedHashSet metadataFiles = new LinkedHashSet();
            if (isPomArtifact) {
                this.installer.install(this.pomFile, this.artifact, this.localRepository);
                this.installChecksums(this.artifact, metadataFiles);
            } else {
                metadata = new ProjectArtifactMetadata(this.artifact, this.pomFile);
                this.artifact.addMetadata((ArtifactMetadata)metadata);
                File file = this.artifact.getFile();
                if (file != null && file.isFile()) {
                    this.installer.install(file, this.artifact, this.localRepository);
                    this.installChecksums(this.artifact, metadataFiles);
                } else if (!this.attachedArtifacts.isEmpty()) {
                    this.getLog().info((CharSequence)"No primary artifact to install, installing attached artifacts instead.");
                    Artifact pomArtifact = this.artifactFactory.createProjectArtifact(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getBaseVersion());
                    pomArtifact.setFile(this.pomFile);
                    if (this.updateReleaseInfo) {
                        pomArtifact.setRelease(true);
                    }
                    this.installer.install(this.pomFile, pomArtifact, this.localRepository);
                    this.installChecksums(pomArtifact, metadataFiles);
                } else {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
            }
            for (Artifact attached : this.attachedArtifacts) {
                this.installer.install(attached.getFile(), attached, this.localRepository);
                this.installChecksums(attached, metadataFiles);
            }
            this.installChecksums(metadataFiles);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

