/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.version;

import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.service.version.util.AbstractVersion;
import org.jitsi.utils.StringUtils;
import org.jitsi.version.AbstractVersionActivator;
import org.osgi.framework.BundleContext;

class VersionImpl
extends AbstractVersion {
    private String applicationName;
    private final String defaultApplicationName;
    private final String nightlyBuildId;
    private final String preReleaseId;

    VersionImpl(String defaultApplicationName, int majorVersion, int minorVersion, String nightlyBuildID, String preReleaseId) {
        super(majorVersion, minorVersion, nightlyBuildID);
        this.defaultApplicationName = defaultApplicationName;
        this.nightlyBuildId = nightlyBuildID;
        this.preReleaseId = preReleaseId;
    }

    public boolean isNightly() {
        return !StringUtils.isNullOrEmpty((String)this.nightlyBuildId);
    }

    public boolean isPreRelease() {
        return !StringUtils.isNullOrEmpty((String)this.preReleaseId);
    }

    public String getPreReleaseID() {
        return this.isPreRelease() ? this.preReleaseId : null;
    }

    public String getApplicationName() {
        if (this.applicationName == null) {
            try {
                ResourceManagementService resources = (ResourceManagementService)ServiceUtils.getService((BundleContext)AbstractVersionActivator.getBundleContext(), ResourceManagementService.class);
                if (resources != null) {
                    this.applicationName = resources.getSettingsString("service.gui.APPLICATION_NAME");
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (this.applicationName == null) {
                    this.applicationName = System.getProperty("sip-communicator.application.name");
                    if (this.applicationName == null || this.applicationName.length() == 0) {
                        this.applicationName = this.defaultApplicationName;
                    }
                }
            }
        }
        return this.applicationName;
    }
}

