/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.pom.tree.events.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.pom.PomModelAspect;
import org.jetbrains.kotlin.com.intellij.pom.event.PomChangeSet;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.ChangeInfo;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.TreeChange;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.TreeChangeEvent;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class TreeChangeEventImpl
implements TreeChangeEvent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.pom.tree.events.impl.TreeChangeEventImpl");
    private final Map<ASTNode, TreeChange> myChangedElements;
    private final List<Set<ASTNode>> myOfEqualDepth;
    private final PomModelAspect myAspect;
    private final FileElement myFileElement;

    public TreeChangeEventImpl(@NotNull PomModelAspect aspect, @NotNull FileElement treeElement) {
        if (aspect == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(0);
        }
        if (treeElement == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(1);
        }
        this.myChangedElements = new THashMap<ASTNode, TreeChange>();
        this.myOfEqualDepth = new ArrayList<Set<ASTNode>>(10);
        this.myAspect = aspect;
        this.myFileElement = treeElement;
    }

    public TreeChange getChangesByElement(@NotNull ASTNode element) {
        if (element == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(TreeChangeEventImpl.isAncestor(element, this.myFileElement), element);
        return this.myChangedElements.get(element);
    }

    private static boolean isAncestor(ASTNode thisElement, FileElement fileElement) {
        TreeElement element = (TreeElement)thisElement;
        while (element.getTreeParent() != null) {
            element = element.getTreeParent();
        }
        return element == fileElement;
    }

    @Override
    public void addElementaryChange(@NotNull ASTNode element, @NotNull ChangeInfo change) {
        if (element == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(5);
        }
        if (change == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(TreeChangeEventImpl.isAncestor(element, this.myFileElement), element);
        ASTNode parent2 = element.getTreeParent();
        if (parent2 == null) {
            return;
        }
        ASTNode prevParent = element;
        int depth = 0;
        for (ASTNode currentParent = parent2; currentParent != null; currentParent = currentParent.getTreeParent()) {
            if (this.myChangedElements.containsKey(currentParent)) {
                boolean currentParentHasChange;
                TreeChange changesByElement = this.getChangesByElement(currentParent);
                boolean bl = currentParentHasChange = changesByElement.getChangeByChild(prevParent) != null;
                if (currentParentHasChange && prevParent != element) {
                    return;
                }
                if (prevParent != element) {
                    ChangeInfoImpl newChange = ChangeInfoImpl.create((short)3, prevParent);
                    if (change.getChangeType() != 1) {
                        newChange.processElementaryChange(change, element);
                    }
                    change = newChange;
                }
                this.processElementaryChange(currentParent, prevParent, change, -1);
                return;
            }
            ++depth;
            prevParent = currentParent;
        }
        this.compactChanges(parent2, depth - 1);
        this.processElementaryChange(parent2, element, change, depth - 1);
    }

    private static int getDepth(ASTNode element) {
        int depth = 0;
        while ((element = element.getTreeParent()) != null) {
            ++depth;
        }
        return depth;
    }

    private void processElementaryChange(ASTNode parent2, ASTNode element, ChangeInfo change, int depth) {
        TreeChange treeChange = this.myChangedElements.get(parent2);
        if (treeChange == null) {
            treeChange = new TreeChangeImpl(parent2);
            this.myChangedElements.put(parent2, treeChange);
            int index2 = depth >= 0 ? depth : TreeChangeEventImpl.getDepth(parent2);
            this.addToEqualsDepthList(index2, parent2);
        }
        treeChange.addChange(element, change);
        if (change.getChangeType() == 1) {
            element.putUserData(CharTable.CHAR_TABLE_KEY, this.myFileElement.getCharTable());
        }
        if (treeChange.isEmpty()) {
            this.removeAssociatedChanges(parent2, depth);
        }
    }

    private void addToEqualsDepthList(int depth, ASTNode parent2) {
        Set<ASTNode> treeElements;
        Set<ASTNode> set = treeElements = depth < this.myOfEqualDepth.size() ? this.myOfEqualDepth.get(depth) : null;
        if (treeElements == null) {
            treeElements = new HashSet<ASTNode>();
            while (depth > this.myOfEqualDepth.size()) {
                this.myOfEqualDepth.add(new HashSet());
            }
            this.myOfEqualDepth.add(depth, treeElements);
        }
        treeElements.add(parent2);
    }

    private void compactChanges(ASTNode parent2, int depth) {
        int currentDepth = this.myOfEqualDepth.size();
        while (--currentDepth > depth) {
            Set<ASTNode> treeElements = this.myOfEqualDepth.get(currentDepth);
            if (treeElements == null) continue;
            Iterator<ASTNode> iterator2 = treeElements.iterator();
            while (iterator2.hasNext()) {
                TreeElement treeElement;
                boolean isUnderCompacted = false;
                for (ASTNode currentParent = treeElement = (TreeElement)iterator2.next(); currentParent != null; currentParent = currentParent.getTreeParent()) {
                    if (currentParent != parent2) continue;
                    isUnderCompacted = true;
                    break;
                }
                if (!isUnderCompacted) continue;
                ChangeInfoImpl compactedChange = ChangeInfoImpl.create((short)3, treeElement);
                compactedChange.compactChange(this.getChangesByElement(treeElement));
                iterator2.remove();
                this.removeAssociatedChanges(treeElement, currentDepth);
                CompositeElement treeParent = treeElement.getTreeParent();
                TreeChange changesByElement = this.getChangesByElement(treeParent);
                if (changesByElement != null) {
                    ChangeInfoImpl changeByChild = (ChangeInfoImpl)changesByElement.getChangeByChild(treeElement);
                    if (changeByChild != null) {
                        changeByChild.setOldLength(compactedChange.getOldLength());
                        continue;
                    }
                    changesByElement.addChange(treeElement, compactedChange);
                    continue;
                }
                this.processElementaryChange(treeParent, treeElement, compactedChange, currentDepth - 1);
            }
        }
    }

    private void removeAssociatedChanges(ASTNode treeElement, int depth) {
        if (this.myChangedElements.remove(treeElement) != null) {
            if (depth < 0) {
                depth = TreeChangeEventImpl.getDepth(treeElement);
            }
            if (depth < this.myOfEqualDepth.size()) {
                this.myOfEqualDepth.get(depth < 0 ? TreeChangeEventImpl.getDepth(treeElement) : depth).remove(treeElement);
            }
        }
    }

    @Override
    public void merge(@NotNull PomChangeSet blocked) {
        ASTNode changed;
        if (blocked == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(9);
        }
        if (!(blocked instanceof TreeChangeEventImpl)) {
            return;
        }
        TreeChangeEventImpl blockedTreeChange = (TreeChangeEventImpl)blocked;
        HashMap<ASTNode, TreeChange> changedElements = new HashMap<ASTNode, TreeChange>(blockedTreeChange.myChangedElements);
        Iterator iterator2 = changedElements.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            ASTNode changed2 = (ASTNode)entry.getKey();
            LOG.assertTrue(TreeChangeEventImpl.isAncestor(changed2, this.myFileElement), changed2);
            TreeChange treeChange = this.myChangedElements.get(changed2);
            if (treeChange == null) continue;
            iterator2.remove();
            treeChange.add((TreeChange)entry.getValue());
        }
        int depth = 0;
        Iterator iterator3 = changedElements.entrySet().iterator();
        block1: while (iterator3.hasNext()) {
            Map.Entry entry = iterator3.next();
            changed = (ASTNode)entry.getKey();
            TreeElement prevParent = (TreeElement)changed;
            for (CompositeElement currentParent = (CompositeElement)changed.getTreeParent(); currentParent != null; currentParent = currentParent.getTreeParent()) {
                if (this.myChangedElements.containsKey(currentParent)) {
                    ChangeInfoImpl newChange = ChangeInfoImpl.create((short)3, prevParent);
                    int newLength = ((TreeElement)changed).getNotCachedLength();
                    int oldLength = ((TreeChange)entry.getValue()).getOldLength();
                    newChange.setOldLength(prevParent.getNotCachedLength() - newLength + oldLength);
                    this.processElementaryChange(currentParent, prevParent, newChange, -1);
                    iterator3.remove();
                    continue block1;
                }
                ++depth;
                prevParent = currentParent;
            }
        }
        for (Map.Entry entry : changedElements.entrySet()) {
            changed = (ASTNode)entry.getKey();
            this.myChangedElements.put(changed, (TreeChange)entry.getValue());
            this.addToEqualsDepthList(depth, changed);
            this.compactChanges(changed, depth);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<ASTNode, TreeChange> entry : this.myChangedElements.entrySet()) {
            buffer.append(entry.getKey().getElementType().toString());
            buffer.append(": ");
            buffer.append(entry.getValue().toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aspect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/pom/tree/events/impl/TreeChangeEventImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocked";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/pom/tree/events/impl/TreeChangeEventImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChangesByElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addElementaryChange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

