/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.osgi.framework.launch;

import java.io.InputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jitsi.impl.osgi.framework.BundleImpl;
import org.jitsi.impl.osgi.framework.ServiceRegistrationImpl;
import org.jitsi.impl.osgi.framework.launch.EventDispatcher;
import org.jitsi.impl.osgi.framework.startlevel.FrameworkStartLevelImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class FrameworkImpl
extends BundleImpl
implements Framework {
    public static boolean killAfterShutdown = false;
    private final Logger logger = Logger.getLogger(FrameworkImpl.class.getName());
    private final List<BundleImpl> bundles = new LinkedList<BundleImpl>();
    private final Map<String, String> configuration;
    private EventDispatcher eventDispatcher;
    private FrameworkStartLevelImpl frameworkStartLevel;
    private long nextBundleId = 1L;
    private long nextServiceId = 1L;
    private final List<ServiceRegistrationImpl> serviceRegistrations = new LinkedList<ServiceRegistrationImpl>();

    public FrameworkImpl(Map<String, String> configuration, ClassLoader classLoader) {
        super(null, 0L, null, classLoader);
        this.configuration = configuration;
        this.bundles.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A adapt(Class<A> type) {
        FrameworkStartLevelImpl a;
        FrameworkStartLevelImpl adapt;
        if (FrameworkStartLevel.class.equals(type)) {
            FrameworkImpl frameworkImpl = this;
            synchronized (frameworkImpl) {
                if (this.frameworkStartLevel == null) {
                    this.frameworkStartLevel = new FrameworkStartLevelImpl(this);
                }
                adapt = this.frameworkStartLevel;
            }
        } else {
            adapt = null;
        }
        return (A)((a = adapt) != null ? a : (FrameworkStartLevelImpl)super.adapt(type));
    }

    public void addBundleListener(BundleImpl origin, BundleListener listener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addListener(origin, BundleListener.class, listener);
        }
    }

    public void addServiceListener(BundleImpl origin, ServiceListener listener, Filter filter) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addListener(origin, ServiceListener.class, listener);
        }
    }

    public void fireBundleEvent(int type, Bundle bundle) {
        this.fireBundleEvent(type, bundle, bundle);
    }

    private void fireBundleEvent(int type, Bundle bundle, Bundle origin) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.fireBundleEvent(new BundleEvent(type, bundle, origin));
        }
    }

    private void fireFrameworkEvent(int type, FrameworkListener ... listeners) {
        if (listeners != null && listeners.length != 0) {
            FrameworkEvent event = new FrameworkEvent(type, (Bundle)this, null);
            for (FrameworkListener listener : listeners) {
                try {
                    listener.frameworkEvent(event);
                }
                catch (Throwable t) {
                    if (type != 2) {
                        // empty if block
                    }
                    this.logger.log(Level.SEVERE, "Error firing framework event", t);
                }
            }
        }
    }

    private void fireServiceEvent(int type, ServiceReference<?> reference) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.fireServiceEvent(new ServiceEvent(type, reference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleImpl getBundle(long id) {
        if (id == 0L) {
            return this;
        }
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl bundle : this.bundles) {
                if (bundle.getBundleId() != id) continue;
                return bundle;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BundleImpl> getBundlesByStartLevel(int startLevel) {
        LinkedList<BundleImpl> bundles = new LinkedList<BundleImpl>();
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl bundle : this.bundles) {
                BundleStartLevel bundleStartLevel = bundle.adapt(BundleStartLevel.class);
                if (bundleStartLevel == null || bundleStartLevel.getStartLevel() != startLevel) continue;
                bundles.add(bundle);
            }
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ServiceReference> getServiceReferences(BundleImpl origin, Class<?> clazz, String className, Filter filter, boolean checkAssignable) throws InvalidSyntaxException {
        Filter classNameFilter = FrameworkUtil.createFilter((String)("(objectClass=" + (className == null ? Character.valueOf('*') : className) + ')'));
        LinkedList<ServiceReference> serviceReferences = new LinkedList<ServiceReference>();
        List<ServiceRegistrationImpl> list = this.serviceRegistrations;
        synchronized (list) {
            for (ServiceRegistrationImpl serviceRegistration : this.serviceRegistrations) {
                ServiceReference serviceReferenceS;
                ServiceRegistrationImpl.ServiceReferenceImpl serviceReference = serviceRegistration.getReference();
                if (!classNameFilter.match((ServiceReference)serviceReference) || filter != null && !filter.match((ServiceReference)serviceReference) || (serviceReferenceS = serviceRegistration.getReference(clazz)) == null) continue;
                serviceReferences.add(serviceReferenceS);
            }
        }
        return serviceReferences;
    }

    @Override
    public FrameworkImpl getFramework() {
        return this;
    }

    private long getNextBundleId() {
        return this.nextBundleId++;
    }

    public void init() throws BundleException {
        this.setState(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle installBundle(BundleImpl origin, String location, InputStream input) throws BundleException {
        if (location == null) {
            throw new BundleException("location");
        }
        BundleImpl bundle = null;
        boolean fireBundleEvent = false;
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl existing : this.bundles) {
                if (!existing.getLocation().equals(location)) continue;
                bundle = existing;
                break;
            }
            if (bundle == null) {
                bundle = new BundleImpl(this.getFramework(), this.getNextBundleId(), location, this.classLoader);
                this.bundles.add(bundle);
                fireBundleEvent = true;
            }
        }
        if (fireBundleEvent) {
            this.fireBundleEvent(1, bundle, origin);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration registerService(BundleImpl origin, Class clazz, String[] classNames, Object service, Dictionary<String, ?> properties) {
        if (classNames == null || classNames.length == 0) {
            throw new IllegalArgumentException("classNames");
        }
        if (service == null) {
            throw new IllegalArgumentException("service");
        }
        Class<?> serviceClass = service.getClass();
        if (!ServiceFactory.class.isAssignableFrom(serviceClass)) {
            ClassLoader classLoader = serviceClass.getClassLoader();
            for (String className : classNames) {
                boolean illegalArgumentException = true;
                Throwable cause = null;
                try {
                    if (Class.forName(className, false, classLoader).isAssignableFrom(serviceClass)) {
                        illegalArgumentException = false;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    cause = cnfe;
                }
                catch (ExceptionInInitializerError eiie) {
                    cause = eiie;
                }
                catch (LinkageError le) {
                    cause = le;
                }
                if (!illegalArgumentException) continue;
                IllegalArgumentException iae = new IllegalArgumentException(className);
                if (cause != null) {
                    iae.initCause(cause);
                }
                throw iae;
            }
        }
        String[] stringArray = this.serviceRegistrations;
        synchronized (this.serviceRegistrations) {
            long serviceId = this.nextServiceId++;
            // ** MonitorExit[var8_9] (shouldn't be in output)
            ServiceRegistrationImpl serviceRegistration = new ServiceRegistrationImpl(origin, serviceId, classNames, service, properties);
            List<ServiceRegistrationImpl> list = this.serviceRegistrations;
            synchronized (list) {
                this.serviceRegistrations.add(serviceRegistration);
            }
            this.fireServiceEvent(1, serviceRegistration.getReference());
            return serviceRegistration;
        }
    }

    public void removeBundleListener(BundleImpl origin, BundleListener listener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeListener(origin, BundleListener.class, listener);
        }
    }

    public void removeServiceListener(BundleImpl origin, ServiceListener listener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeListener(origin, ServiceListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int options) throws BundleException {
        int state = this.getState();
        if (state == 2 || state == 4) {
            this.init();
            state = this.getState();
        }
        if (state == 8) {
            String s;
            int startLevel = 1;
            if (this.configuration != null && (s = this.configuration.get("org.osgi.framework.startlevel.beginning")) != null) {
                try {
                    startLevel = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            FrameworkStartLevel frameworkStartLevel = this.adapt(FrameworkStartLevel.class);
            FrameworkListener listener = new FrameworkListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void frameworkEvent(FrameworkEvent event) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        this.notifyAll();
                    }
                }
            };
            frameworkStartLevel.setStartLevel(startLevel, new FrameworkListener[]{listener});
            FrameworkListener frameworkListener = listener;
            synchronized (frameworkListener) {
                boolean interrupted = false;
                while (frameworkStartLevel.getStartLevel() < startLevel) {
                    try {
                        listener.wait();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            this.setState(32);
        }
    }

    public void startLevelChanged(int oldStartLevel, int newStartLevel, FrameworkListener ... listeners) {
        if (oldStartLevel < newStartLevel) {
            for (BundleImpl bundle : this.getBundlesByStartLevel(newStartLevel)) {
                try {
                    BundleStartLevel bundleStartLevel = bundle.adapt(BundleStartLevel.class);
                    int options = 1;
                    if (bundleStartLevel.isActivationPolicyUsed()) {
                        options |= 2;
                    }
                    bundle.start(options);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    this.logger.log(Level.SEVERE, "Error changing start level", t);
                }
            }
        }
        this.fireFrameworkEvent(8, listeners);
    }

    public void startLevelChanging(int oldStartLevel, int newStartLevel, FrameworkListener ... listeners) {
        if (oldStartLevel > newStartLevel) {
            for (BundleImpl bundle : this.getBundlesByStartLevel(oldStartLevel)) {
                try {
                    bundle.stop(1);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    this.logger.log(Level.SEVERE, "Error changing start level", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stateChanged(int oldState, int newState) {
        switch (newState) {
            case 4: {
                if (this.eventDispatcher != null) {
                    this.eventDispatcher.stop();
                    this.eventDispatcher = null;
                }
                FrameworkImpl frameworkImpl = this;
                synchronized (frameworkImpl) {
                    if (this.frameworkStartLevel != null) {
                        this.frameworkStartLevel.stop();
                        this.frameworkStartLevel = null;
                    }
                    break;
                }
            }
            case 8: {
                this.eventDispatcher = new EventDispatcher();
            }
        }
        super.stateChanged(oldState, newState);
    }

    @Override
    public void stop(int options) throws BundleException {
        final FrameworkStartLevelImpl frameworkStartLevel = (FrameworkStartLevelImpl)this.adapt(FrameworkStartLevel.class);
        new Thread(this.getClass().getName() + ".stop"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FrameworkImpl framework = FrameworkImpl.this;
                framework.setState(16);
                FrameworkListener listener = new FrameworkListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void frameworkEvent(FrameworkEvent event) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.notifyAll();
                        }
                    }
                };
                frameworkStartLevel.internalSetStartLevel(0, listener);
                FrameworkListener frameworkListener = listener;
                synchronized (frameworkListener) {
                    boolean interrupted = false;
                    while (frameworkStartLevel.getStartLevel() != 0) {
                        try {
                            listener.wait();
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                framework.setState(4);
                if (killAfterShutdown) {
                    System.exit(0);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(BundleImpl origin, ServiceRegistration<?> serviceRegistration) {
        boolean removed;
        List<ServiceRegistrationImpl> list = this.serviceRegistrations;
        synchronized (list) {
            removed = this.serviceRegistrations.remove(serviceRegistration);
        }
        if (!removed) {
            throw new IllegalStateException("serviceRegistrations");
        }
        this.fireServiceEvent(4, serviceRegistration.getReference());
    }

    @Override
    public ServiceReference<?>[] getRegisteredServices() {
        ServiceReference[] references = new ServiceReference[this.serviceRegistrations.size()];
        for (int i = 0; i < this.serviceRegistrations.size(); ++i) {
            references[i] = this.serviceRegistrations.get(i).getReference();
        }
        return references;
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        return null;
    }
}

