/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import org.apache.maven.surefire.util.internal.StringUtils;

public final class UrlUtils {
    private static final BitSet UNRESERVED;
    private static final int RADIX = 16;
    private static final int MASK = 15;

    private UrlUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static URL toURL(File file) throws MalformedURLException {
        URL url = file.toURL();
        byte[] bytes = url.toString().getBytes(StringUtils.UTF_8);
        StringBuilder buf = new StringBuilder(bytes.length);
        for (byte b : bytes) {
            if (b > 0 && UNRESERVED.get(b)) {
                buf.append((char)b);
                continue;
            }
            buf.append('%');
            buf.append(Character.forDigit(b >>> 4 & 0xF, 16));
            buf.append(Character.forDigit(b & 0xF, 16));
        }
        return new URL(buf.toString());
    }

    static {
        byte[] bytes;
        UNRESERVED = new BitSet(256);
        for (byte aByte : bytes = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'():/".getBytes(StringUtils.UTF_8)) {
            UNRESERVED.set(aByte);
        }
    }
}

