/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.sctp4j;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.jitsi.sctp4j.NetworkLink;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.utils.logging.Logger;

public class UdpLink
implements NetworkLink {
    private static final Logger logger = Logger.getLogger(UdpLink.class);
    private final SctpSocket sctpSocket;
    private final DatagramSocket udpSocket;
    private final int remotePort;
    private final InetAddress remoteIp;

    public UdpLink(SctpSocket sctpSocket, String localIp, int localPort, String remoteIp, int remotePort) throws IOException {
        this.sctpSocket = sctpSocket;
        this.udpSocket = new DatagramSocket(localPort, InetAddress.getByName(localIp));
        this.remotePort = remotePort;
        this.remoteIp = InetAddress.getByName(remoteIp);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buff = new byte[2048];
                    DatagramPacket p = new DatagramPacket(buff, 2048);
                    while (true) {
                        UdpLink.this.udpSocket.receive(p);
                        UdpLink.this.sctpSocket.onConnIn(p.getData(), p.getOffset(), p.getLength());
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                    return;
                }
            }
        }).start();
    }

    @Override
    public void onConnOut(SctpSocket s, byte[] packetData) throws IOException {
        DatagramPacket packet = new DatagramPacket(packetData, packetData.length, this.remoteIp, this.remotePort);
        this.udpSocket.send(packet);
    }
}

