#include <sys/param.h>
#include <sys/event.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <netinet/in.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

void	dumpkevent(struct kevent *);

void
dumpkevent(struct kevent *event)
{
	printf(
"kevent: ident 0x%02lx filter %d flags: 0x%02x, fflags: 0x%02x, data 0x%lx\n",
	    event->ident, event->filter, event->flags, event->fflags,
	    event->data);
}


int
main(int argc, char **argv)
{
	struct timespec		timeout;
	struct timeval		then, now, diff;
	struct kevent		event[5];
	struct sockaddr_in	sa;
	int			sock, fd, kq, n, i, match;
	char			buffer[128];

	if (argc != 1)
		errx(1, "Usage: %s", argv[0]);

        kq = kqueue();
        if (kq == -1)
                err(1, "kqueue");
	
	sock = socket(PF_INET, SOCK_STREAM, 0);
	if (sock == -1)
		err(1, "socket");
	memset((void *)&sa, 0, sizeof(sa));
	if (bind(sock, (struct sockaddr *)&sa, sizeof(sa)) == -1)
		err(1, "bind");

		/*
		 * start listening
		 */

	if (listen(sock, 5) == -1)
		err(1, "listen");
	n = sizeof(sa);
	if (getsockname(sock, (struct sockaddr *)&sa, &n) == -1)
		err(1, "getsockname");
	printf("pid %d bound to port %d\n", getpid(), ntohs(sa.sin_port));

printf("waiting 5 seconds before accept()\n"); sleep(5);
	
	timeout.tv_sec = 5;
	timeout.tv_nsec = 0;

		/* set a kevent on the listen socket */
	EV_SET(&event[0], sock, EVFILT_READ, EV_ADD | EV_ENABLE | EV_ONESHOT,
	    0, NULL, NULL);
	n = kevent(kq, event, 1, NULL, 0, NULL);
	if (n == -1)
		err(1, "kevent(1)");
printf("registered sock %d\n", sock);

	for (;;) {
		if (gettimeofday(&then, NULL) == -1)
			err(1, "gettimeofday then");
		n = kevent(kq, NULL, 0, event, 1, &timeout);
		if (gettimeofday(&now, NULL) == -1)
			err(1, "gettimeofday now");
		timersub(&now, &then, &diff);

		printf("kevent returned %d in %ld.%06ld\n", n,
		    diff.tv_sec, diff.tv_usec);
		if (n == -1)
			err(1, "kevent");
		else if (n == 0)
			continue;
		dumpkevent(event);
		break;
	}


		/*
		 * accept connection, start reading
		 */
	n = sizeof(sa);
	fd = accept(sock, (struct sockaddr *)&sa, &n);
	if (fd == -1)
		err(1, "accept");
	printf("got connection from 0x%x port %d\n",
	    ntohl(sa.sin_addr.s_addr), ntohs(sa.sin_port));

	EV_SET(&event[0], fd, EVFILT_READ, EV_ADD | EV_ENABLE, 0, NULL, NULL);
	n = kevent(kq, event, 1, NULL, 0, NULL);
	if (n == -1)
		err(1, "kevent(1)");
printf("registered fd %d\n", fd);
	
	for (;;) {
		if (gettimeofday(&then, NULL) == -1)
			err(1, "gettimeofday then");
		n = kevent(kq, NULL, 0, event, 5, &timeout);
		if (gettimeofday(&now, NULL) == -1)
			err(1, "gettimeofday now");
		timersub(&now, &then, &diff);

		printf("kevent returned %d in %ld.%06ld\n", n,
		    diff.tv_sec, diff.tv_usec);
		if (n == -1)
			err(1, "kevent");
		else if (n == 0)
			continue;

		match = -1;
		for (i = 0; i < n; i++) {
			printf("event[%d]: ", i);
			dumpkevent(&event[i]);
			if (event[i].ident == fd)
				match = i;
		}
printf("match is %d\n", match); /* sleep(1); */
		if (match == -1)
			continue;

		n = read(fd, buffer, 128);
		buffer[n] = '\0';
buffer[0] = '\0';
		printf("[%d] %s", n, buffer);
		if (event[match].flags & EV_ERROR) {
			printf("error received: %d %m\n",
			    (int)event[match].data,
			    strerror((int)event[match].data));
			break;
		} else if (event[match].flags & EV_EOF) {
			printf("EOF received\n");
			break;
		}
	}
	return (0);
}
