#include <sys/param.h>
#include <sys/event.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <netinet/in.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int
main(int argc, char **argv)
{
	struct sockaddr_in	sa;
	int			sock, fd, n;
	char			buffer[128];

	if (argc != 1)
		errx(1, "Usage: %s", argv[0]);

	sock = socket(PF_INET, SOCK_STREAM, 0);
	if (sock == -1)
		err(1, "socket");
	memset((void *)&sa, 0, sizeof(sa));
	if (bind(sock, (struct sockaddr *)&sa, sizeof(sa)) == -1)
		err(1, "bind");

	if (listen(sock, 5) == -1)
		err(1, "listen");
	n = sizeof(sa);
	if (getsockname(sock, (struct sockaddr *)&sa, &n) == -1)
		err(1, "getsockname");
	printf("pid %d bound to port %d\n", getpid(), ntohs(sa.sin_port));
	
	n = sizeof(sa);
	fd = accept(sock, (struct sockaddr *)&sa, &n);
	if (fd == -1)
		err(1, "accept");
	printf("got connection from 0x%x port %d\n",
	    ntohl(sa.sin_addr.s_addr), ntohs(sa.sin_port));

	for (;;) {
			/* read from keyboard */
		n = read(0, buffer, 128);

			/* read from socket */
		n = read(fd, buffer, 128);
		if (n == -1) {
			printf("got -1\n");
			break;
		}
		buffer[n] = '\0';
		printf("[%d] %s", n, buffer);

	}
	return (0);
}
