#include <sys/param.h>
#include <sys/event.h>
#include <sys/ioctl.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int
main(int argc, char **argv)
{
	struct kfilter_mapping	km;
	int	kq;
	long	filter;
	char	*ep, buf[100];

	if (argc != 2)
		errx(1, "Usage: %s filter", argv[0]);
	
        kq = kqueue();
        if (kq < 0)
                err(1, "kqueue");

	filter = strtol(argv[1], &ep, 10);
	if (ep[0] == '\0') {		/* do number -> name */
		km.name = buf;
		km.len = sizeof(buf) - 1;
		km.filter = filter;
		if (ioctl(kq, KFILTER_BYFILTER, &km) == -1)
			err(1, "KFILTER_BYFILTER `%d'", km.filter);
		printf("Map %d -> %s\n", km.filter, km.name);
	} else {			/* do name -> number */
		km.name = argv[1];
		if (ioctl(kq, KFILTER_BYNAME, &km) == -1)
			err(1, "KFILTER_BYNAME `%s'", km.name);
		printf("Map %s -> %d\n", km.name, km.filter);
	}

	return (0);
}
