/*-
 * Copyright (c) 2003 Kip Macy All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $DragonFly: src/sys/sys/checkpoint.h,v 1.1 2004/11/23 06:32:34 dillon Exp $
 */

#ifndef _SYS_CHECKPOINT_H_
#define _SYS_CHECKPOINT_H_

#define CKPT_FREEZE    0x1
#define CKPT_THAW      0x2
#define CKPT_SETJMP    0x3
#define CKPT_LONGJMP   0x4
#define CKPT_CURR      0x5
#define CKPT_PREV      0x6
#define CKPT_SIGTYPE   0x7
#define CKPT_COUNT     0x8

#define IN  0
#define OUT 1
#ifdef _KERNEL

typedef struct {
	prstatus_t *status;
	prfpregset_t *fpregset;
	prpsinfo_t *psinfo;
} pstate_t;

typedef struct {
	pstate_t *pstate;
	int offset;
	int nthreads;
} lc_args_t;

#else

int sys_checkpoint(int type, int fd, pid_t pid, int retval);

#define tsetjmp() sys_checkpoint(CKPT_SETJMP, 0, -1, 0)
#define tlongjmp(x) sys_checkpoint(CKPT_LONGJMP, x, -1, 0)
#define chkpt_currstate() sys_checkpoint(CKPT_CURR, 0, -1, 0)
#define chkpt_prevstate() sys_checkpoint(CKPT_PREV, 0, -1, 0)
#define chkpt_count() sys_checkpoint(CKPT_COUNT, 0, -1, 0)
#define chkpt_signal() sys_checkpoint(CKPT_SIGTYPE, 0, -1, 0)
#endif

#endif /* PRIVATE_CKPT_H_ */

