#	$NetBSD: Makefile.inc,v 1.23 2025/10/04 21:03:16 nat Exp $

SOFTFLOAT_BITS?=64
.PATH:		${ARCHDIR}/softfloat \
		${.CURDIR}/softfloat/bits${SOFTFLOAT_BITS} ${.CURDIR}/softfloat

CPPFLAGS+=	-I${ARCHDIR}/softfloat -I${.CURDIR}/softfloat
CPPFLAGS+=	-DSOFTFLOAT_FOR_GCC

SRCS.softfloat= softfloat.c

.include <softfloat/Makefile.fenv.inc>

.if !empty(LIBC_MACHINE_ARCH:Mearm*)
SRCS.softfloat+=__aeabi_dcmpeq.c __aeabi_fcmpeq.c
SRCS.softfloat+=__aeabi_dcmpge.c __aeabi_fcmpge.c
SRCS.softfloat+=__aeabi_dcmpgt.c __aeabi_fcmpgt.c
SRCS.softfloat+=__aeabi_dcmple.c __aeabi_fcmple.c
SRCS.softfloat+=__aeabi_dcmplt.c __aeabi_fcmplt.c
SRCS.softfloat+=__aeabi_dcmpun.c __aeabi_fcmpun.c
.else
SRCS.softfloat+=eqsf2.c nesf2.c gtsf2.c gesf2.c ltsf2.c lesf2.c negsf2.c \
		eqdf2.c nedf2.c gtdf2.c gedf2.c ltdf2.c ledf2.c negdf2.c \
		eqtf2.c netf2.c gttf2.c getf2.c lttf2.c letf2.c negtf2.c \
		nexf2.c gtxf2.c gexf2.c negxf2.c \
		unordsf2.c unorddf2.c unordtf2.c
.endif

SRCS+=		flt_rounds.c
SRCS+=		${SRCS.softfloat}

# XXX
.if defined(HAVE_GCC)
# See doc/HACKS for more information.
. if (${LIBC_MACHINE_CPU} == "mips" || \
     ${LIBC_MACHINE_CPU} == "sh3")
COPTS.softfloat.c+=	-Wno-enum-compare
. endif
.endif
