/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularType
extends OpenType<TabularData> {
    static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType;
    private List<String> indexNames;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public TabularType(String string, String string2, CompositeType compositeType, String[] stringArray) throws OpenDataException {
        super(TabularData.class.getName(), string, string2, false);
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument rowType cannot be null.");
        }
        TabularType.checkForNullElement(stringArray, "indexNames");
        TabularType.checkForEmptyString(stringArray, "indexNames");
        for (int i = 0; i < stringArray.length; ++i) {
            if (compositeType.containsKey(stringArray[i])) continue;
            throw new OpenDataException("Argument's element value indexNames[" + i + "]=\"" + stringArray[i] + "\" is not a valid item name for rowType.");
        }
        this.rowType = compositeType;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.indexNames = Collections.unmodifiableList(arrayList);
    }

    private static void checkForNullElement(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument " + string + "[] cannot be null or empty.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be an empty string.");
        }
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public List<String> getIndexNames() {
        return this.indexNames;
    }

    @Override
    public boolean isValue(Object object) {
        if (!(object instanceof TabularData)) {
            return false;
        }
        TabularData tabularData = (TabularData)object;
        TabularType tabularType = tabularData.getTabularType();
        return this.isAssignableFrom(tabularType);
    }

    @Override
    boolean isAssignableFrom(OpenType<?> openType) {
        if (!(openType instanceof TabularType)) {
            return false;
        }
        TabularType tabularType = (TabularType)openType;
        if (!this.getTypeName().equals(tabularType.getTypeName()) || !((Object)this.getIndexNames()).equals(tabularType.getIndexNames())) {
            return false;
        }
        return this.getRowType().isAssignableFrom(tabularType.getRowType());
    }

    @Override
    public boolean equals(Object object) {
        TabularType tabularType;
        if (object == null) {
            return false;
        }
        try {
            tabularType = (TabularType)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getTypeName().equals(tabularType.getTypeName())) {
            return false;
        }
        if (!this.rowType.equals(tabularType.rowType)) {
            return false;
        }
        return ((Object)this.indexNames).equals(tabularType.indexNames);
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int n = 0;
            n += this.getTypeName().hashCode();
            n += this.rowType.hashCode();
            for (String string : this.indexNames) {
                n += string.hashCode();
            }
            this.myHashCode = n;
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getName()).append("(name=").append(this.getTypeName()).append(",rowType=").append(this.rowType.toString()).append(",indexNames=(");
            String string = "";
            for (String string2 : this.indexNames) {
                stringBuilder.append(string).append(string2);
                string = ",";
            }
            stringBuilder.append("))");
            this.myToString = stringBuilder.toString();
        }
        return this.myToString;
    }
}

