/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.api.impl.j2s;

import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.tools.internal.xjc.api.ErrorListener;
import com.sun.tools.internal.xjc.api.J2SJAXBModel;
import com.sun.tools.internal.xjc.api.Reference;
import com.sun.xml.internal.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.internal.bind.v2.model.core.ArrayInfo;
import com.sun.xml.internal.bind.v2.model.core.ClassInfo;
import com.sun.xml.internal.bind.v2.model.core.Element;
import com.sun.xml.internal.bind.v2.model.core.EnumLeafInfo;
import com.sun.xml.internal.bind.v2.model.core.NonElement;
import com.sun.xml.internal.bind.v2.model.core.Ref;
import com.sun.xml.internal.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JAXBModelImpl
implements J2SJAXBModel {
    private final Map<QName, Reference> additionalElementDecls;
    private final List<String> classList = new ArrayList<String>();
    private final TypeInfoSet<TypeMirror, TypeDeclaration, FieldDeclaration, MethodDeclaration> types;
    private final AnnotationReader<TypeMirror, TypeDeclaration, FieldDeclaration, MethodDeclaration> reader;
    private final Map<Reference, NonElement<TypeMirror, TypeDeclaration>> refMap = new HashMap<Reference, NonElement<TypeMirror, TypeDeclaration>>();

    public JAXBModelImpl(TypeInfoSet<TypeMirror, TypeDeclaration, FieldDeclaration, MethodDeclaration> typeInfoSet, AnnotationReader<TypeMirror, TypeDeclaration, FieldDeclaration, MethodDeclaration> annotationReader, Collection<Reference> collection, Map<QName, Reference> map) {
        String string;
        Object object;
        this.types = typeInfoSet;
        this.reader = annotationReader;
        this.additionalElementDecls = map;
        Navigator navigator = typeInfoSet.getNavigator();
        for (ClassInfo object2 : typeInfoSet.beans().values()) {
            this.classList.add(object2.getName());
        }
        for (ArrayInfo arrayInfo : typeInfoSet.arrays().values()) {
            object = navigator.getTypeName(arrayInfo.getType());
            this.classList.add((String)object);
        }
        for (EnumLeafInfo enumLeafInfo : typeInfoSet.enums().values()) {
            object = enumLeafInfo.getTypeName();
            if (object == null) continue;
            string = navigator.getTypeName(enumLeafInfo.getType());
            this.classList.add(string);
        }
        for (Reference reference : collection) {
            this.refMap.put(reference, this.getXmlType(reference));
        }
        Iterator<Object> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Element element;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (entry.getValue() == null) continue;
            object = this.getXmlType((Reference)entry.getValue());
            assert (object != null);
            this.refMap.put((Reference)entry.getValue(), (NonElement<TypeMirror, TypeDeclaration>)object);
            if (object instanceof ClassInfo && (element = (string = (ClassInfo)object).asElement()) != null && element.getElementName().equals(entry.getKey())) {
                iterator.remove();
                continue;
            }
            string = typeInfoSet.getElementInfo(null, (QName)entry.getKey());
            if (string == null || string.getContentType() != object) continue;
            iterator.remove();
        }
    }

    @Override
    public List<String> getClassList() {
        return this.classList;
    }

    @Override
    public QName getXmlTypeName(Reference reference) {
        NonElement<TypeMirror, TypeDeclaration> nonElement = this.refMap.get(reference);
        if (nonElement != null) {
            return nonElement.getTypeName();
        }
        return null;
    }

    private NonElement<TypeMirror, TypeDeclaration> getXmlType(Reference reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        XmlJavaTypeAdapter xmlJavaTypeAdapter = reference.annotations.getAnnotation(XmlJavaTypeAdapter.class);
        XmlList xmlList = reference.annotations.getAnnotation(XmlList.class);
        Ref ref = new Ref(this.reader, this.types.getNavigator(), (Object)reference.type, xmlJavaTypeAdapter, xmlList);
        return this.types.getTypeInfo(ref);
    }

    @Override
    public void generateSchema(SchemaOutputResolver schemaOutputResolver, ErrorListener errorListener) throws IOException {
        XmlSchemaGenerator xmlSchemaGenerator = new XmlSchemaGenerator(this.types.getNavigator(), this.types);
        for (Map.Entry<QName, Reference> entry : this.additionalElementDecls.entrySet()) {
            Reference reference = entry.getValue();
            if (reference != null) {
                NonElement<TypeMirror, TypeDeclaration> nonElement = this.refMap.get(reference);
                if (nonElement == null) {
                    throw new IllegalArgumentException(entry.getValue() + " was not specified to JavaCompiler.bind");
                }
                xmlSchemaGenerator.add(entry.getKey(), !(reference.type instanceof PrimitiveType), nonElement);
                continue;
            }
            xmlSchemaGenerator.add(entry.getKey(), false, null);
        }
        xmlSchemaGenerator.write(schemaOutputResolver);
    }
}

