/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader;

import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CCustomizations;
import com.sun.tools.internal.xjc.model.CElementInfo;
import com.sun.tools.internal.xjc.model.CElementPropertyInfo;
import com.sun.tools.internal.xjc.model.CNonElement;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.model.Multiplicity;
import com.sun.tools.internal.xjc.model.TypeUse;
import com.sun.tools.internal.xjc.reader.Ring;
import com.sun.tools.internal.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.ClassSelector;
import com.sun.tools.internal.xjc.reader.xmlschema.SimpleTypeBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIGlobalBinding;
import com.sun.xml.internal.bind.v2.model.core.ID;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSType;
import com.sun.xml.internal.xsom.XmlString;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.MimeType;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RawTypeSet {
    public final Set<Ref> refs;
    public final Mode canBeTypeRefs;
    public final Multiplicity mul;
    private CElementPropertyInfo.CollectionMode collectionMode;

    public RawTypeSet(Set<Ref> set, Multiplicity multiplicity) {
        this.refs = set;
        this.mul = multiplicity;
        this.canBeTypeRefs = this.canBeTypeRefs();
    }

    public CElementPropertyInfo.CollectionMode getCollectionMode() {
        return this.collectionMode;
    }

    public boolean isRequired() {
        return this.mul.min > 0;
    }

    private Mode canBeTypeRefs() {
        HashSet<Object> hashSet = new HashSet<Object>();
        this.collectionMode = this.mul.isAtMostOnce() ? CElementPropertyInfo.CollectionMode.NOT_REPEATED : CElementPropertyInfo.CollectionMode.REPEATED_ELEMENT;
        Mode mode = Mode.SHOULD_BE_TYPEREF;
        for (Ref ref : this.refs) {
            if ((mode = mode.or(ref.canBeType(this))) == Mode.MUST_BE_REFERENCE) {
                return mode;
            }
            if (!hashSet.add(ref.toTypeRef(null).getTarget().getType())) {
                return Mode.MUST_BE_REFERENCE;
            }
            if (!ref.isListOfValues()) continue;
            if (this.refs.size() > 1 || !this.mul.isAtMostOnce()) {
                return Mode.MUST_BE_REFERENCE;
            }
            this.collectionMode = CElementPropertyInfo.CollectionMode.REPEATED_VALUE;
        }
        return mode;
    }

    public void addTo(CElementPropertyInfo cElementPropertyInfo) {
        assert (this.canBeTypeRefs != Mode.MUST_BE_REFERENCE);
        if (this.mul.isZero()) {
            return;
        }
        List<CTypeRef> list = cElementPropertyInfo.getTypes();
        for (Ref ref : this.refs) {
            list.add(ref.toTypeRef(cElementPropertyInfo));
        }
    }

    public void addTo(CReferencePropertyInfo cReferencePropertyInfo) {
        if (this.mul.isZero()) {
            return;
        }
        for (Ref ref : this.refs) {
            ref.toElementRef(cReferencePropertyInfo);
        }
    }

    public ID id() {
        for (Ref ref : this.refs) {
            ID iD = ref.id();
            if (iD == ID.NONE) continue;
            return iD;
        }
        return ID.NONE;
    }

    public MimeType getExpectedMimeType() {
        for (Ref ref : this.refs) {
            MimeType mimeType = ref.getExpectedMimeType();
            if (mimeType == null) continue;
            return mimeType;
        }
        return null;
    }

    private static TypeUse bindToType(XSElementDecl xSElementDecl) {
        SimpleTypeBuilder simpleTypeBuilder = Ring.get(SimpleTypeBuilder.class);
        simpleTypeBuilder.refererStack.push(xSElementDecl);
        TypeUse typeUse = Ring.get(ClassSelector.class).bindToType(xSElementDecl.getType());
        simpleTypeBuilder.refererStack.pop();
        return typeUse;
    }

    public static final class XmlTypeRef
    extends Ref {
        public final QName elementName;
        public final TypeUse target;
        public final Locator locator;
        public final XSComponent source;
        public final CCustomizations custs;
        public final boolean nillable;
        public final XmlString defaultValue;

        public XmlTypeRef(QName qName, TypeUse typeUse, boolean bl, XmlString xmlString, XSComponent xSComponent, CCustomizations cCustomizations, Locator locator) {
            assert (qName != null);
            assert (typeUse != null);
            this.elementName = qName;
            this.target = typeUse;
            this.source = xSComponent;
            this.custs = cCustomizations;
            this.nillable = bl;
            this.defaultValue = xmlString;
            this.locator = locator;
        }

        public XmlTypeRef(QName qName, XSType xSType, boolean bl, XmlString xmlString) {
            this(qName, Ring.get(ClassSelector.class).bindToType(xSType), bl, xmlString, xSType, Ring.get(BGMBuilder.class).getBindInfo(xSType).toCustomizationList(), xSType.getLocator());
        }

        public XmlTypeRef(XSElementDecl xSElementDecl) {
            this(new QName(xSElementDecl.getTargetNamespace(), xSElementDecl.getName()), RawTypeSet.bindToType(xSElementDecl), xSElementDecl.isNillable(), xSElementDecl.getDefaultValue(), xSElementDecl, Ring.get(BGMBuilder.class).getBindInfo(xSElementDecl).toCustomizationList(), xSElementDecl.getLocator());
        }

        protected CTypeRef toTypeRef(CElementPropertyInfo cElementPropertyInfo) {
            if (cElementPropertyInfo != null && this.target.getAdapterUse() != null) {
                cElementPropertyInfo.setAdapter(this.target.getAdapterUse());
            }
            return new CTypeRef((CNonElement)this.target.getInfo(), this.elementName, this.nillable, this.defaultValue);
        }

        protected void toElementRef(CReferencePropertyInfo cReferencePropertyInfo) {
            CClassInfo cClassInfo = Ring.get(ClassSelector.class).getCurrentBean();
            Model model = Ring.get(Model.class);
            if (this.target instanceof CClassInfo && Ring.get(BIGlobalBinding.class).isSimpleMode()) {
                CClassInfo cClassInfo2 = new CClassInfo(model, cClassInfo, model.getNameConverter().toClassName(this.elementName.getLocalPart()), this.locator, null, this.elementName, this.source, this.custs);
                cClassInfo2.setBaseClass((CClassInfo)this.target);
                cReferencePropertyInfo.getElements().add(cClassInfo2);
            } else {
                CElementInfo cElementInfo = new CElementInfo(model, this.elementName, cClassInfo, this.target, this.defaultValue, this.source, this.custs, this.locator);
                cReferencePropertyInfo.getElements().add(cElementInfo);
            }
        }

        protected Mode canBeType(RawTypeSet rawTypeSet) {
            if (!(rawTypeSet.refs.size() <= 1 && rawTypeSet.mul.isAtMostOnce() || this.target.getAdapterUse() == null && this.target.idUse() == ID.NONE)) {
                return Mode.MUST_BE_REFERENCE;
            }
            if (this.nillable && rawTypeSet.mul.isOptional()) {
                return Mode.CAN_BE_TYPEREF;
            }
            return Mode.SHOULD_BE_TYPEREF;
        }

        protected boolean isListOfValues() {
            return this.target.isCollection();
        }

        protected ID id() {
            return this.target.idUse();
        }

        protected MimeType getExpectedMimeType() {
            return this.target.getExpectedMimeType();
        }
    }

    public static abstract class Ref {
        protected abstract CTypeRef toTypeRef(CElementPropertyInfo var1);

        protected abstract void toElementRef(CReferencePropertyInfo var1);

        protected abstract Mode canBeType(RawTypeSet var1);

        protected abstract boolean isListOfValues();

        protected abstract ID id();

        protected MimeType getExpectedMimeType() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SHOULD_BE_TYPEREF(0),
        CAN_BE_TYPEREF(1),
        MUST_BE_REFERENCE(2);

        private final int rank;

        private Mode(int n2) {
            this.rank = n2;
        }

        Mode or(Mode mode) {
            switch (Math.max(this.rank, mode.rank)) {
                case 0: {
                    return SHOULD_BE_TYPEREF;
                }
                case 1: {
                    return CAN_BE_TYPEREF;
                }
                case 2: {
                    return MUST_BE_REFERENCE;
                }
            }
            throw new AssertionError();
        }
    }
}

