// Code generated by smithy-go-codegen DO NOT EDIT.

package comprehend

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/comprehend/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new document classification request to analyze a single document in
// real-time, using a previously created and trained custom model and an endpoint.
func (c *Client) ClassifyDocument(ctx context.Context, params *ClassifyDocumentInput, optFns ...func(*Options)) (*ClassifyDocumentOutput, error) {
	if params == nil {
		params = &ClassifyDocumentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ClassifyDocument", params, optFns, c.addOperationClassifyDocumentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ClassifyDocumentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ClassifyDocumentInput struct {

	// The Amazon Resource Number (ARN) of the endpoint. For information about
	// endpoints, see Managing endpoints
	// (https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html).
	//
	// This member is required.
	EndpointArn *string

	// The document text to be analyzed.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

type ClassifyDocumentOutput struct {

	// The classes used by the document being analyzed. These are used for multi-class
	// trained models. Individual classes are mutually exclusive and each document is
	// expected to have only a single class assigned to it. For example, an animal can
	// be a dog or a cat, but not both at the same time.
	Classes []types.DocumentClass

	// The labels used the document being analyzed. These are used for multi-label
	// trained models. Individual labels represent different categories that are
	// related in some manner and are not mutually exclusive. For example, a movie can
	// be just an action movie, or it can be an action movie, a science fiction movie,
	// and a comedy, all at the same time.
	Labels []types.DocumentLabel

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationClassifyDocumentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpClassifyDocument{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpClassifyDocument{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpClassifyDocumentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opClassifyDocument(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opClassifyDocument(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "comprehend",
		OperationName: "ClassifyDocument",
	}
}
