// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package b2biiface provides an interface to enable mocking the AWS B2B Data Interchange service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package b2biiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/b2bi"
)

// B2biAPI provides an interface to enable mocking the
// b2bi.B2bi service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS B2B Data Interchange.
//	func myFunc(svc b2biiface.B2biAPI) bool {
//	    // Make svc.CreateCapability request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := b2bi.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockB2biClient struct {
//	    b2biiface.B2biAPI
//	}
//	func (m *mockB2biClient) CreateCapability(input *b2bi.CreateCapabilityInput) (*b2bi.CreateCapabilityOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockB2biClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type B2biAPI interface {
	CreateCapability(*b2bi.CreateCapabilityInput) (*b2bi.CreateCapabilityOutput, error)
	CreateCapabilityWithContext(aws.Context, *b2bi.CreateCapabilityInput, ...request.Option) (*b2bi.CreateCapabilityOutput, error)
	CreateCapabilityRequest(*b2bi.CreateCapabilityInput) (*request.Request, *b2bi.CreateCapabilityOutput)

	CreatePartnership(*b2bi.CreatePartnershipInput) (*b2bi.CreatePartnershipOutput, error)
	CreatePartnershipWithContext(aws.Context, *b2bi.CreatePartnershipInput, ...request.Option) (*b2bi.CreatePartnershipOutput, error)
	CreatePartnershipRequest(*b2bi.CreatePartnershipInput) (*request.Request, *b2bi.CreatePartnershipOutput)

	CreateProfile(*b2bi.CreateProfileInput) (*b2bi.CreateProfileOutput, error)
	CreateProfileWithContext(aws.Context, *b2bi.CreateProfileInput, ...request.Option) (*b2bi.CreateProfileOutput, error)
	CreateProfileRequest(*b2bi.CreateProfileInput) (*request.Request, *b2bi.CreateProfileOutput)

	CreateTransformer(*b2bi.CreateTransformerInput) (*b2bi.CreateTransformerOutput, error)
	CreateTransformerWithContext(aws.Context, *b2bi.CreateTransformerInput, ...request.Option) (*b2bi.CreateTransformerOutput, error)
	CreateTransformerRequest(*b2bi.CreateTransformerInput) (*request.Request, *b2bi.CreateTransformerOutput)

	DeleteCapability(*b2bi.DeleteCapabilityInput) (*b2bi.DeleteCapabilityOutput, error)
	DeleteCapabilityWithContext(aws.Context, *b2bi.DeleteCapabilityInput, ...request.Option) (*b2bi.DeleteCapabilityOutput, error)
	DeleteCapabilityRequest(*b2bi.DeleteCapabilityInput) (*request.Request, *b2bi.DeleteCapabilityOutput)

	DeletePartnership(*b2bi.DeletePartnershipInput) (*b2bi.DeletePartnershipOutput, error)
	DeletePartnershipWithContext(aws.Context, *b2bi.DeletePartnershipInput, ...request.Option) (*b2bi.DeletePartnershipOutput, error)
	DeletePartnershipRequest(*b2bi.DeletePartnershipInput) (*request.Request, *b2bi.DeletePartnershipOutput)

	DeleteProfile(*b2bi.DeleteProfileInput) (*b2bi.DeleteProfileOutput, error)
	DeleteProfileWithContext(aws.Context, *b2bi.DeleteProfileInput, ...request.Option) (*b2bi.DeleteProfileOutput, error)
	DeleteProfileRequest(*b2bi.DeleteProfileInput) (*request.Request, *b2bi.DeleteProfileOutput)

	DeleteTransformer(*b2bi.DeleteTransformerInput) (*b2bi.DeleteTransformerOutput, error)
	DeleteTransformerWithContext(aws.Context, *b2bi.DeleteTransformerInput, ...request.Option) (*b2bi.DeleteTransformerOutput, error)
	DeleteTransformerRequest(*b2bi.DeleteTransformerInput) (*request.Request, *b2bi.DeleteTransformerOutput)

	GetCapability(*b2bi.GetCapabilityInput) (*b2bi.GetCapabilityOutput, error)
	GetCapabilityWithContext(aws.Context, *b2bi.GetCapabilityInput, ...request.Option) (*b2bi.GetCapabilityOutput, error)
	GetCapabilityRequest(*b2bi.GetCapabilityInput) (*request.Request, *b2bi.GetCapabilityOutput)

	GetPartnership(*b2bi.GetPartnershipInput) (*b2bi.GetPartnershipOutput, error)
	GetPartnershipWithContext(aws.Context, *b2bi.GetPartnershipInput, ...request.Option) (*b2bi.GetPartnershipOutput, error)
	GetPartnershipRequest(*b2bi.GetPartnershipInput) (*request.Request, *b2bi.GetPartnershipOutput)

	GetProfile(*b2bi.GetProfileInput) (*b2bi.GetProfileOutput, error)
	GetProfileWithContext(aws.Context, *b2bi.GetProfileInput, ...request.Option) (*b2bi.GetProfileOutput, error)
	GetProfileRequest(*b2bi.GetProfileInput) (*request.Request, *b2bi.GetProfileOutput)

	GetTransformer(*b2bi.GetTransformerInput) (*b2bi.GetTransformerOutput, error)
	GetTransformerWithContext(aws.Context, *b2bi.GetTransformerInput, ...request.Option) (*b2bi.GetTransformerOutput, error)
	GetTransformerRequest(*b2bi.GetTransformerInput) (*request.Request, *b2bi.GetTransformerOutput)

	GetTransformerJob(*b2bi.GetTransformerJobInput) (*b2bi.GetTransformerJobOutput, error)
	GetTransformerJobWithContext(aws.Context, *b2bi.GetTransformerJobInput, ...request.Option) (*b2bi.GetTransformerJobOutput, error)
	GetTransformerJobRequest(*b2bi.GetTransformerJobInput) (*request.Request, *b2bi.GetTransformerJobOutput)

	ListCapabilities(*b2bi.ListCapabilitiesInput) (*b2bi.ListCapabilitiesOutput, error)
	ListCapabilitiesWithContext(aws.Context, *b2bi.ListCapabilitiesInput, ...request.Option) (*b2bi.ListCapabilitiesOutput, error)
	ListCapabilitiesRequest(*b2bi.ListCapabilitiesInput) (*request.Request, *b2bi.ListCapabilitiesOutput)

	ListCapabilitiesPages(*b2bi.ListCapabilitiesInput, func(*b2bi.ListCapabilitiesOutput, bool) bool) error
	ListCapabilitiesPagesWithContext(aws.Context, *b2bi.ListCapabilitiesInput, func(*b2bi.ListCapabilitiesOutput, bool) bool, ...request.Option) error

	ListPartnerships(*b2bi.ListPartnershipsInput) (*b2bi.ListPartnershipsOutput, error)
	ListPartnershipsWithContext(aws.Context, *b2bi.ListPartnershipsInput, ...request.Option) (*b2bi.ListPartnershipsOutput, error)
	ListPartnershipsRequest(*b2bi.ListPartnershipsInput) (*request.Request, *b2bi.ListPartnershipsOutput)

	ListPartnershipsPages(*b2bi.ListPartnershipsInput, func(*b2bi.ListPartnershipsOutput, bool) bool) error
	ListPartnershipsPagesWithContext(aws.Context, *b2bi.ListPartnershipsInput, func(*b2bi.ListPartnershipsOutput, bool) bool, ...request.Option) error

	ListProfiles(*b2bi.ListProfilesInput) (*b2bi.ListProfilesOutput, error)
	ListProfilesWithContext(aws.Context, *b2bi.ListProfilesInput, ...request.Option) (*b2bi.ListProfilesOutput, error)
	ListProfilesRequest(*b2bi.ListProfilesInput) (*request.Request, *b2bi.ListProfilesOutput)

	ListProfilesPages(*b2bi.ListProfilesInput, func(*b2bi.ListProfilesOutput, bool) bool) error
	ListProfilesPagesWithContext(aws.Context, *b2bi.ListProfilesInput, func(*b2bi.ListProfilesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*b2bi.ListTagsForResourceInput) (*b2bi.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *b2bi.ListTagsForResourceInput, ...request.Option) (*b2bi.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*b2bi.ListTagsForResourceInput) (*request.Request, *b2bi.ListTagsForResourceOutput)

	ListTransformers(*b2bi.ListTransformersInput) (*b2bi.ListTransformersOutput, error)
	ListTransformersWithContext(aws.Context, *b2bi.ListTransformersInput, ...request.Option) (*b2bi.ListTransformersOutput, error)
	ListTransformersRequest(*b2bi.ListTransformersInput) (*request.Request, *b2bi.ListTransformersOutput)

	ListTransformersPages(*b2bi.ListTransformersInput, func(*b2bi.ListTransformersOutput, bool) bool) error
	ListTransformersPagesWithContext(aws.Context, *b2bi.ListTransformersInput, func(*b2bi.ListTransformersOutput, bool) bool, ...request.Option) error

	StartTransformerJob(*b2bi.StartTransformerJobInput) (*b2bi.StartTransformerJobOutput, error)
	StartTransformerJobWithContext(aws.Context, *b2bi.StartTransformerJobInput, ...request.Option) (*b2bi.StartTransformerJobOutput, error)
	StartTransformerJobRequest(*b2bi.StartTransformerJobInput) (*request.Request, *b2bi.StartTransformerJobOutput)

	TagResource(*b2bi.TagResourceInput) (*b2bi.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *b2bi.TagResourceInput, ...request.Option) (*b2bi.TagResourceOutput, error)
	TagResourceRequest(*b2bi.TagResourceInput) (*request.Request, *b2bi.TagResourceOutput)

	TestMapping(*b2bi.TestMappingInput) (*b2bi.TestMappingOutput, error)
	TestMappingWithContext(aws.Context, *b2bi.TestMappingInput, ...request.Option) (*b2bi.TestMappingOutput, error)
	TestMappingRequest(*b2bi.TestMappingInput) (*request.Request, *b2bi.TestMappingOutput)

	TestParsing(*b2bi.TestParsingInput) (*b2bi.TestParsingOutput, error)
	TestParsingWithContext(aws.Context, *b2bi.TestParsingInput, ...request.Option) (*b2bi.TestParsingOutput, error)
	TestParsingRequest(*b2bi.TestParsingInput) (*request.Request, *b2bi.TestParsingOutput)

	UntagResource(*b2bi.UntagResourceInput) (*b2bi.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *b2bi.UntagResourceInput, ...request.Option) (*b2bi.UntagResourceOutput, error)
	UntagResourceRequest(*b2bi.UntagResourceInput) (*request.Request, *b2bi.UntagResourceOutput)

	UpdateCapability(*b2bi.UpdateCapabilityInput) (*b2bi.UpdateCapabilityOutput, error)
	UpdateCapabilityWithContext(aws.Context, *b2bi.UpdateCapabilityInput, ...request.Option) (*b2bi.UpdateCapabilityOutput, error)
	UpdateCapabilityRequest(*b2bi.UpdateCapabilityInput) (*request.Request, *b2bi.UpdateCapabilityOutput)

	UpdatePartnership(*b2bi.UpdatePartnershipInput) (*b2bi.UpdatePartnershipOutput, error)
	UpdatePartnershipWithContext(aws.Context, *b2bi.UpdatePartnershipInput, ...request.Option) (*b2bi.UpdatePartnershipOutput, error)
	UpdatePartnershipRequest(*b2bi.UpdatePartnershipInput) (*request.Request, *b2bi.UpdatePartnershipOutput)

	UpdateProfile(*b2bi.UpdateProfileInput) (*b2bi.UpdateProfileOutput, error)
	UpdateProfileWithContext(aws.Context, *b2bi.UpdateProfileInput, ...request.Option) (*b2bi.UpdateProfileOutput, error)
	UpdateProfileRequest(*b2bi.UpdateProfileInput) (*request.Request, *b2bi.UpdateProfileOutput)

	UpdateTransformer(*b2bi.UpdateTransformerInput) (*b2bi.UpdateTransformerOutput, error)
	UpdateTransformerWithContext(aws.Context, *b2bi.UpdateTransformerInput, ...request.Option) (*b2bi.UpdateTransformerOutput, error)
	UpdateTransformerRequest(*b2bi.UpdateTransformerInput) (*request.Request, *b2bi.UpdateTransformerOutput)
}

var _ B2biAPI = (*b2bi.B2bi)(nil)
