# Copyright 2015 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'date'
require 'google/apis/core/base_service'
require 'google/apis/core/json_representation'
require 'google/apis/core/hashable'
require 'google/apis/errors'

module Google
  module Apis
    module VaultV1
      
      class AccountCount
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AccountCountError
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AccountInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddHeldAccountResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddHeldAccountsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddHeldAccountsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AddMatterPermissionsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CancelOperationRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CloseMatterRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CloseMatterResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CloudStorageFile
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CloudStorageSink
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CorpusQuery
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CountArtifactsMetadata
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CountArtifactsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class CountArtifactsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DriveExportOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class DriveOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Empty
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Export
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ExportOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ExportStats
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GroupsCountResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class GroupsExportOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HangoutsChatExportOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HangoutsChatInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HangoutsChatOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HeldAccount
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HeldDriveQuery
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HeldGroupsQuery
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HeldHangoutsChatQuery
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HeldMailQuery
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HeldOrgUnit
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class HeldVoiceQuery
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Hold
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListExportsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListHeldAccountsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListHoldsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListMattersResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListOperationsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ListSavedQueriesResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MailCountResult
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MailExportOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MailOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Matter
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class MatterPermission
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Operation
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class OrgUnitInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Query
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveHeldAccountsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveHeldAccountsResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class RemoveMatterPermissionsRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ReopenMatterRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class ReopenMatterResponse
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SavedQuery
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class SharedDriveInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class Status
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class TeamDriveInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UndeleteMatterRequest
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class UserInfo
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class VoiceExportOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class VoiceOptions
        class Representation < Google::Apis::Core::JsonRepresentation; end
      
        include Google::Apis::Core::JsonObjectSupport
      end
      
      class AccountCount
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account, as: 'account', class: Google::Apis::VaultV1::UserInfo, decorator: Google::Apis::VaultV1::UserInfo::Representation
      
          property :count, :numeric_string => true, as: 'count'
        end
      end
      
      class AccountCountError
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account, as: 'account', class: Google::Apis::VaultV1::UserInfo, decorator: Google::Apis::VaultV1::UserInfo::Representation
      
          property :error_type, as: 'errorType'
        end
      end
      
      class AccountInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :emails, as: 'emails'
        end
      end
      
      class AddHeldAccountResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account, as: 'account', class: Google::Apis::VaultV1::HeldAccount, decorator: Google::Apis::VaultV1::HeldAccount::Representation
      
          property :status, as: 'status', class: Google::Apis::VaultV1::Status, decorator: Google::Apis::VaultV1::Status::Representation
      
        end
      end
      
      class AddHeldAccountsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :account_ids, as: 'accountIds'
          collection :emails, as: 'emails'
        end
      end
      
      class AddHeldAccountsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :responses, as: 'responses', class: Google::Apis::VaultV1::AddHeldAccountResult, decorator: Google::Apis::VaultV1::AddHeldAccountResult::Representation
      
        end
      end
      
      class AddMatterPermissionsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :cc_me, as: 'ccMe'
          property :matter_permission, as: 'matterPermission', class: Google::Apis::VaultV1::MatterPermission, decorator: Google::Apis::VaultV1::MatterPermission::Representation
      
          property :send_emails, as: 'sendEmails'
        end
      end
      
      class CancelOperationRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class CloseMatterRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class CloseMatterResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :matter, as: 'matter', class: Google::Apis::VaultV1::Matter, decorator: Google::Apis::VaultV1::Matter::Representation
      
        end
      end
      
      class CloudStorageFile
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :bucket_name, as: 'bucketName'
          property :md5_hash, as: 'md5Hash'
          property :object_name, as: 'objectName'
          property :size, :numeric_string => true, as: 'size'
        end
      end
      
      class CloudStorageSink
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :files, as: 'files', class: Google::Apis::VaultV1::CloudStorageFile, decorator: Google::Apis::VaultV1::CloudStorageFile::Representation
      
        end
      end
      
      class CorpusQuery
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :drive_query, as: 'driveQuery', class: Google::Apis::VaultV1::HeldDriveQuery, decorator: Google::Apis::VaultV1::HeldDriveQuery::Representation
      
          property :groups_query, as: 'groupsQuery', class: Google::Apis::VaultV1::HeldGroupsQuery, decorator: Google::Apis::VaultV1::HeldGroupsQuery::Representation
      
          property :hangouts_chat_query, as: 'hangoutsChatQuery', class: Google::Apis::VaultV1::HeldHangoutsChatQuery, decorator: Google::Apis::VaultV1::HeldHangoutsChatQuery::Representation
      
          property :mail_query, as: 'mailQuery', class: Google::Apis::VaultV1::HeldMailQuery, decorator: Google::Apis::VaultV1::HeldMailQuery::Representation
      
          property :voice_query, as: 'voiceQuery', class: Google::Apis::VaultV1::HeldVoiceQuery, decorator: Google::Apis::VaultV1::HeldVoiceQuery::Representation
      
        end
      end
      
      class CountArtifactsMetadata
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :end_time, as: 'endTime'
          property :matter_id, as: 'matterId'
          property :query, as: 'query', class: Google::Apis::VaultV1::Query, decorator: Google::Apis::VaultV1::Query::Representation
      
          property :start_time, as: 'startTime'
        end
      end
      
      class CountArtifactsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :query, as: 'query', class: Google::Apis::VaultV1::Query, decorator: Google::Apis::VaultV1::Query::Representation
      
          property :view, as: 'view'
        end
      end
      
      class CountArtifactsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :groups_count_result, as: 'groupsCountResult', class: Google::Apis::VaultV1::GroupsCountResult, decorator: Google::Apis::VaultV1::GroupsCountResult::Representation
      
          property :mail_count_result, as: 'mailCountResult', class: Google::Apis::VaultV1::MailCountResult, decorator: Google::Apis::VaultV1::MailCountResult::Representation
      
          property :total_count, :numeric_string => true, as: 'totalCount'
        end
      end
      
      class DriveExportOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :include_access_info, as: 'includeAccessInfo'
        end
      end
      
      class DriveOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :include_shared_drives, as: 'includeSharedDrives'
          property :include_team_drives, as: 'includeTeamDrives'
          property :version_date, as: 'versionDate'
        end
      end
      
      class Empty
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class Export
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :cloud_storage_sink, as: 'cloudStorageSink', class: Google::Apis::VaultV1::CloudStorageSink, decorator: Google::Apis::VaultV1::CloudStorageSink::Representation
      
          property :create_time, as: 'createTime'
          property :export_options, as: 'exportOptions', class: Google::Apis::VaultV1::ExportOptions, decorator: Google::Apis::VaultV1::ExportOptions::Representation
      
          property :id, as: 'id'
          property :matter_id, as: 'matterId'
          property :name, as: 'name'
          property :query, as: 'query', class: Google::Apis::VaultV1::Query, decorator: Google::Apis::VaultV1::Query::Representation
      
          property :requester, as: 'requester', class: Google::Apis::VaultV1::UserInfo, decorator: Google::Apis::VaultV1::UserInfo::Representation
      
          property :stats, as: 'stats', class: Google::Apis::VaultV1::ExportStats, decorator: Google::Apis::VaultV1::ExportStats::Representation
      
          property :status, as: 'status'
        end
      end
      
      class ExportOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :drive_options, as: 'driveOptions', class: Google::Apis::VaultV1::DriveExportOptions, decorator: Google::Apis::VaultV1::DriveExportOptions::Representation
      
          property :groups_options, as: 'groupsOptions', class: Google::Apis::VaultV1::GroupsExportOptions, decorator: Google::Apis::VaultV1::GroupsExportOptions::Representation
      
          property :hangouts_chat_options, as: 'hangoutsChatOptions', class: Google::Apis::VaultV1::HangoutsChatExportOptions, decorator: Google::Apis::VaultV1::HangoutsChatExportOptions::Representation
      
          property :mail_options, as: 'mailOptions', class: Google::Apis::VaultV1::MailExportOptions, decorator: Google::Apis::VaultV1::MailExportOptions::Representation
      
          property :region, as: 'region'
          property :voice_options, as: 'voiceOptions', class: Google::Apis::VaultV1::VoiceExportOptions, decorator: Google::Apis::VaultV1::VoiceExportOptions::Representation
      
        end
      end
      
      class ExportStats
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :exported_artifact_count, :numeric_string => true, as: 'exportedArtifactCount'
          property :size_in_bytes, :numeric_string => true, as: 'sizeInBytes'
          property :total_artifact_count, :numeric_string => true, as: 'totalArtifactCount'
        end
      end
      
      class GroupsCountResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :account_count_errors, as: 'accountCountErrors', class: Google::Apis::VaultV1::AccountCountError, decorator: Google::Apis::VaultV1::AccountCountError::Representation
      
          collection :account_counts, as: 'accountCounts', class: Google::Apis::VaultV1::AccountCount, decorator: Google::Apis::VaultV1::AccountCount::Representation
      
          property :matching_accounts_count, :numeric_string => true, as: 'matchingAccountsCount'
          collection :non_queryable_accounts, as: 'nonQueryableAccounts'
          property :queried_accounts_count, :numeric_string => true, as: 'queriedAccountsCount'
        end
      end
      
      class GroupsExportOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :export_format, as: 'exportFormat'
        end
      end
      
      class HangoutsChatExportOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :export_format, as: 'exportFormat'
        end
      end
      
      class HangoutsChatInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :room_id, as: 'roomId'
        end
      end
      
      class HangoutsChatOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :include_rooms, as: 'includeRooms'
        end
      end
      
      class HeldAccount
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account_id, as: 'accountId'
          property :email, as: 'email'
          property :first_name, as: 'firstName'
          property :hold_time, as: 'holdTime'
          property :last_name, as: 'lastName'
        end
      end
      
      class HeldDriveQuery
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :include_shared_drive_files, as: 'includeSharedDriveFiles'
          property :include_team_drive_files, as: 'includeTeamDriveFiles'
        end
      end
      
      class HeldGroupsQuery
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :end_time, as: 'endTime'
          property :start_time, as: 'startTime'
          property :terms, as: 'terms'
        end
      end
      
      class HeldHangoutsChatQuery
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :include_rooms, as: 'includeRooms'
        end
      end
      
      class HeldMailQuery
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :end_time, as: 'endTime'
          property :start_time, as: 'startTime'
          property :terms, as: 'terms'
        end
      end
      
      class HeldOrgUnit
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :hold_time, as: 'holdTime'
          property :org_unit_id, as: 'orgUnitId'
        end
      end
      
      class HeldVoiceQuery
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :covered_data, as: 'coveredData'
        end
      end
      
      class Hold
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :accounts, as: 'accounts', class: Google::Apis::VaultV1::HeldAccount, decorator: Google::Apis::VaultV1::HeldAccount::Representation
      
          property :corpus, as: 'corpus'
          property :hold_id, as: 'holdId'
          property :name, as: 'name'
          property :org_unit, as: 'orgUnit', class: Google::Apis::VaultV1::HeldOrgUnit, decorator: Google::Apis::VaultV1::HeldOrgUnit::Representation
      
          property :query, as: 'query', class: Google::Apis::VaultV1::CorpusQuery, decorator: Google::Apis::VaultV1::CorpusQuery::Representation
      
          property :update_time, as: 'updateTime'
        end
      end
      
      class ListExportsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :exports, as: 'exports', class: Google::Apis::VaultV1::Export, decorator: Google::Apis::VaultV1::Export::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListHeldAccountsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :accounts, as: 'accounts', class: Google::Apis::VaultV1::HeldAccount, decorator: Google::Apis::VaultV1::HeldAccount::Representation
      
        end
      end
      
      class ListHoldsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :holds, as: 'holds', class: Google::Apis::VaultV1::Hold, decorator: Google::Apis::VaultV1::Hold::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListMattersResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :matters, as: 'matters', class: Google::Apis::VaultV1::Matter, decorator: Google::Apis::VaultV1::Matter::Representation
      
          property :next_page_token, as: 'nextPageToken'
        end
      end
      
      class ListOperationsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :operations, as: 'operations', class: Google::Apis::VaultV1::Operation, decorator: Google::Apis::VaultV1::Operation::Representation
      
        end
      end
      
      class ListSavedQueriesResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :next_page_token, as: 'nextPageToken'
          collection :saved_queries, as: 'savedQueries', class: Google::Apis::VaultV1::SavedQuery, decorator: Google::Apis::VaultV1::SavedQuery::Representation
      
        end
      end
      
      class MailCountResult
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :account_count_errors, as: 'accountCountErrors', class: Google::Apis::VaultV1::AccountCountError, decorator: Google::Apis::VaultV1::AccountCountError::Representation
      
          collection :account_counts, as: 'accountCounts', class: Google::Apis::VaultV1::AccountCount, decorator: Google::Apis::VaultV1::AccountCount::Representation
      
          property :matching_accounts_count, :numeric_string => true, as: 'matchingAccountsCount'
          collection :non_queryable_accounts, as: 'nonQueryableAccounts'
          property :queried_accounts_count, :numeric_string => true, as: 'queriedAccountsCount'
        end
      end
      
      class MailExportOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :export_format, as: 'exportFormat'
          property :show_confidential_mode_content, as: 'showConfidentialModeContent'
        end
      end
      
      class MailOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :exclude_drafts, as: 'excludeDrafts'
        end
      end
      
      class Matter
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :description, as: 'description'
          property :matter_id, as: 'matterId'
          collection :matter_permissions, as: 'matterPermissions', class: Google::Apis::VaultV1::MatterPermission, decorator: Google::Apis::VaultV1::MatterPermission::Representation
      
          property :name, as: 'name'
          property :state, as: 'state'
        end
      end
      
      class MatterPermission
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account_id, as: 'accountId'
          property :role, as: 'role'
        end
      end
      
      class Operation
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :done, as: 'done'
          property :error, as: 'error', class: Google::Apis::VaultV1::Status, decorator: Google::Apis::VaultV1::Status::Representation
      
          hash :metadata, as: 'metadata'
          property :name, as: 'name'
          hash :response, as: 'response'
        end
      end
      
      class OrgUnitInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :org_unit_id, as: 'orgUnitId'
        end
      end
      
      class Query
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account_info, as: 'accountInfo', class: Google::Apis::VaultV1::AccountInfo, decorator: Google::Apis::VaultV1::AccountInfo::Representation
      
          property :corpus, as: 'corpus'
          property :data_scope, as: 'dataScope'
          property :drive_options, as: 'driveOptions', class: Google::Apis::VaultV1::DriveOptions, decorator: Google::Apis::VaultV1::DriveOptions::Representation
      
          property :end_time, as: 'endTime'
          property :hangouts_chat_info, as: 'hangoutsChatInfo', class: Google::Apis::VaultV1::HangoutsChatInfo, decorator: Google::Apis::VaultV1::HangoutsChatInfo::Representation
      
          property :hangouts_chat_options, as: 'hangoutsChatOptions', class: Google::Apis::VaultV1::HangoutsChatOptions, decorator: Google::Apis::VaultV1::HangoutsChatOptions::Representation
      
          property :mail_options, as: 'mailOptions', class: Google::Apis::VaultV1::MailOptions, decorator: Google::Apis::VaultV1::MailOptions::Representation
      
          property :method_prop, as: 'method'
          property :org_unit_info, as: 'orgUnitInfo', class: Google::Apis::VaultV1::OrgUnitInfo, decorator: Google::Apis::VaultV1::OrgUnitInfo::Representation
      
          property :search_method, as: 'searchMethod'
          property :shared_drive_info, as: 'sharedDriveInfo', class: Google::Apis::VaultV1::SharedDriveInfo, decorator: Google::Apis::VaultV1::SharedDriveInfo::Representation
      
          property :start_time, as: 'startTime'
          property :team_drive_info, as: 'teamDriveInfo', class: Google::Apis::VaultV1::TeamDriveInfo, decorator: Google::Apis::VaultV1::TeamDriveInfo::Representation
      
          property :terms, as: 'terms'
          property :time_zone, as: 'timeZone'
          property :voice_options, as: 'voiceOptions', class: Google::Apis::VaultV1::VoiceOptions, decorator: Google::Apis::VaultV1::VoiceOptions::Representation
      
        end
      end
      
      class RemoveHeldAccountsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :account_ids, as: 'accountIds'
        end
      end
      
      class RemoveHeldAccountsResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :statuses, as: 'statuses', class: Google::Apis::VaultV1::Status, decorator: Google::Apis::VaultV1::Status::Representation
      
        end
      end
      
      class RemoveMatterPermissionsRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :account_id, as: 'accountId'
        end
      end
      
      class ReopenMatterRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class ReopenMatterResponse
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :matter, as: 'matter', class: Google::Apis::VaultV1::Matter, decorator: Google::Apis::VaultV1::Matter::Representation
      
        end
      end
      
      class SavedQuery
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :create_time, as: 'createTime'
          property :display_name, as: 'displayName'
          property :matter_id, as: 'matterId'
          property :query, as: 'query', class: Google::Apis::VaultV1::Query, decorator: Google::Apis::VaultV1::Query::Representation
      
          property :saved_query_id, as: 'savedQueryId'
        end
      end
      
      class SharedDriveInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :shared_drive_ids, as: 'sharedDriveIds'
        end
      end
      
      class Status
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :code, as: 'code'
          collection :details, as: 'details'
          property :message, as: 'message'
        end
      end
      
      class TeamDriveInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :team_drive_ids, as: 'teamDriveIds'
        end
      end
      
      class UndeleteMatterRequest
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
        end
      end
      
      class UserInfo
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :display_name, as: 'displayName'
          property :email, as: 'email'
        end
      end
      
      class VoiceExportOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          property :export_format, as: 'exportFormat'
        end
      end
      
      class VoiceOptions
        # @private
        class Representation < Google::Apis::Core::JsonRepresentation
          collection :covered_data, as: 'coveredData'
        end
      end
    end
  end
end
