/* Symlink
 * File:	main.c
 * Authors:	CM King with AJ Rixon
 * Comment:	Main routine
 */

#include "linker.h"
#include "make_links.h"

char    root_path[MAXPATHLEN];	/* root path to application */
FILE   *log_file;

/* main
 * Comment:     main function
 * Inputs:      linker arguments
 * Output:      exit values
 */
main(argc, argv)
    int     argc;
    char  **argv;
{
    FILE   *filedes;		/* handle for link desc file */
    char   *infile;		/* link desc. filename */
    int     c;			/* current argument */

    while ((c = getopt(argc, argv, "abilht")) != -1)  /* parse arguments */
	switch (c) {
	case 'l':    {	/* open log file for writing */
		if ((log_file = fopen(LOGFILE, "w")) == NULL) {
		  log_file = stderr;
  	          (void) perror("Cannot open logfile");
  	          (void) fprintf(stderr, "logging to STDERR instead\n");
		}
		break;
	    }
	case 'i': { /* overwrite existing links */
		ignore = 1;
		break;
	    }
	case 'b': { /* backoff (preserve links) option */
		backoff = 1;
		break;
	    }
	case 't': { /* test mode */
		trial = 1;
		break;
	    }
	case 'a':  {	/* interactive (acknowledge) mode */
		ack = 1;
		break;
	    }
	case 'h': { /* syntax */
		(void) fprintf(stderr, USAGE);
		exit(1);
	    }
	}
    /* Usage: linker [-h] [-ailt] <link description file> */
    if (!(argc >= 2)) {
	(void) fprintf(stderr, USAGE);
	exit(1);
    }

    if (log_file == NULL)  /* no log file, log to stderr */
	log_file = stderr;

    infile = argv[argc - 1];	/* link desc. filename */
    /* open link desc file for reading as stdin (for yacc) */
    if ((filedes = freopen(infile, "r", stdin)) == NULL) {
	(void) fprintf(stderr, "Cannot open %s\n", infile);
	exit(2);
    }

    yyparse();			/* parse the file */

    (void) fclose(filedes);

    /* (re)open stdin to read from the keyboard */
    if ((freopen("/dev/tty", "r", stdin)) == NULL) {
	perror("Failed to reopen STDIN\n");
	exit(1);
    }
    if (log_file != NULL)
	(void) fclose(log_file);

    return (0);
}
