/*
 * File:        str_func.c
 * Authors:     CM King with AJ Rixon
 * Comment:     Misc string functions
 */

#include "str_func.h"

/* rm_cr
 * Comment:     copies a string, minus any newlines
 * Comment:     must allocate space for outst before calling
 * Inputs:      string to copy from, string to copy to
 * Output:      none
 */
void    rm_cr(inst, outst)
    char   *inst;
    char   *outst;
{
    int     x, y;

    /* only copy if char is not a newline */
    for (x = 0, y = 0; y <= (int) strlen(inst); y++) {
	if (inst[y] != '\n') {
	    outst[x] = inst[y];
	    x++;
	}
    }
    outst[x] = '\0';
}

/* countchar_in_line
 * Comment:     count occurrences of a char in a line
 * Inputs:      line, char to count
 * Output:      no. of occurrences
 */
int     countchar_in_line(line, test_char)
    char   *line;
    char    test_char;
{
   /* should be one since does not include null terminator */
   int  char_count = 1;	

   while (*line != '\0') {
      if (*line == test_char)
	 char_count++;
      line++;
    }
   return char_count;
}
