/*	$NetBSD: kvm_m68k.h,v 1.7 2025/11/27 15:42:13 thorpej Exp $	*/

/*-
 * Copyright (c) 1997 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Gordon W. Ross and Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

struct kvm_ops {
	int   (*initvtop)(kvm_t *);
	void  (*freevtop)(kvm_t *);
	int   (*kvatop)  (kvm_t *, vaddr_t, paddr_t *);
	off_t (*pa2off)  (kvm_t *, paddr_t);
};

struct vmstate {
	struct kvm_ops *ops;	/* ops vector */
	u_int32_t pgshift;	/* log2(page_size) */
	u_int32_t pgofset;	/* mask to find offset into page */
	void *private;		/* private to the bottom layer */
};

extern struct kvm_ops _kvm_ops_cmn;
extern struct kvm_ops _kvm_ops_gen68k;
extern struct kvm_ops _kvm_ops_sun2;
extern struct kvm_ops _kvm_ops_sun3;
extern struct kvm_ops _kvm_ops_sun3x;
