#! /bin/sh

# $NetBSD: t_netpgpkeys.sh,v 1.1 2026/01/23 20:57:10 wiz Exp $

#
# Copyright (c) 2026 The NetBSD Foundation, Inc.
# All rights reserved.
#
# This code is derived from software contributed to The NetBSD Foundation
# by Thomas Klausner <wiz@NetBSD.org>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
# AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

# Test set 1 (rsa key) for netpgpkeys
atf_test_case netpgpkeys_testset_1_rsa_keys

netpgpkeys_testset_1_rsa_keys_head() {
	atf_set "descr" "Test set 1 (rsa_keys) for netpgpkeys"
}
netpgpkeys_testset_1_rsa_keys_body() {
        atf_expect_fail "PR bin/59936 - does not support keys generated by gnugp2"
	uudecode << EOF
begin-base64 664 testkey-rsa.pub
mQINBGlz2mABEADOhQSqLh3zpdtL5s25l6VG5S3EGYFixiSOX3qy+/GfZpAAmNni
QJwYPAMe6pyJ34/lJclmQu3yaxLfelLwb0feh0N0GWqfRGa5tVKrMxaz8S6FAAWQ
r17MUsXsqFHJiCqU3+5/70fn+3gPSS/KP+3s7GaXtYoXfuf0J1c/pfqy4OeY5OEf
1KtF4mIFBCqF+fnrt1R66VQh8/WwS0052+s4EOcJzVi7qEiMB9A6dYVGYJ47HyNF
OiIm+jpUfUyZCbh0b7b/ZB1oMvGSiU5r+R5FGShBUOmMT5c6x+BRNizeCLWgwKA3
5+/ecOoEaWwArIeKTHLyFmhIse6YdD7G4jIKVngLle+bR9RwfctO9iyB14m7nrfZ
cFsLW36JW7D2FsJTEA74FU02/tT9Mcr/UDr+ZMxewxPADLDPUX6l8EuG+8vWo+qK
AWs7r9f7Kwv/ZnY0Z+bhWwq6oGKauNn1pJqpfbJoeAobh9ynwnDFvxvXOPnuu2zS
zJIfIAzGM7p2XDtMg3D0WWul1/q6U8Rmie7iaroYsaPPcGf1KpGz8W3hSmRW4FZ6
ddX47S2Sa5qF6ggwmF/KzWI60PXXUzf/fxk66YIjp4geAzXMM2n6i4jzFeLkg2Wh
6+2zASMIGnsxlF+Sp01OcI6L51velWzC6UZQmBnKnX23mYbT0JUF4BPlhQARAQAB
tBZ0ZXN0IDx0ZXN0QE5ldEJTRC5vcmc+iQJRBBMBCAA7FiEEWFZ/P6oG3WjQHypk
Z1NP82elnLAFAmlz2mACGwMFCwkIBwICIgIGFQoJCAsCBBYCAwECHgcCF4AACgkQ
Z1NP82elnLBfXA/8DEaN4lQkt0L/iTpLFeSJ0p2XNW4wC6ABmg+HRPE0F7YYnnSm
LFy3xm3NOFy6bpw660nAi/Pv7KB1FAbMFd/F+KYT+kv6yhS/XVZSvL/RQrUdUDBJ
NIbwiD+Cp3J220EBviyh61R4f2SZRdYsJPS7Vo0J7S3lcJHMxBlTSVyo/SMPwdiE
Jo5vOGh7QmuskmaHl6Cdnv9/k36DhVTvabCmgunGd3saaWaRoSI7uEnTR2qFKAVs
0eB2AJQdrM5T7CmGn1KBQClV/3nzifuv4KDF3UDg3gKwEUoPjlmzVuF2BvXVpAH4
OPZq7GthLHNHgOvfzKn3A+/PAooHnWqsCN54GrloStbrR9B2BUzoo5DCmLp9wDJF
pWoWTFWOQbYmjNEjqJmS1iZv/dm2pTZbzqcYIEdKprj+Ua+Tw5qjC+0TVVoki4f+
uqfO2GQeJ5AthGwR5o8W9BYiRFL1ncR5YEXmpnZdjxiq6Ub0p8tz5UQyOip8hLen
JkGfBpxl9Wo+z3morTbJQ3z3gNuoey5O47tJE+FYmM3e9TilxJcqVjqAPFNjG6QD
WM19hA2G7Y0KRvokJun2zLeK4ZjGXbceQTp8Rwybd9EO4i7vdh6UTYaduDhKbS8B
kWwQcol8U4xbBPXB1/Ks+AsrCzmMAdKi4T9uNmILzec2F32N65I0T+T0PRO5Ag0E
aXPaYAEQAMFT9cLS7ED1SqLmNzmEC+CYcRyGzKXTtrL0hoSF/wCcAWGMrWBbMCg7
i4MmOrRY3WtNaWr6TZ6bz36kX+at7N3wzn6rAft2/NAmEAkNtBEddOyAMHQv1UL1
c4kQQ8qaGD5TF64Ga3E8a/gyCQ7j3/ftzvB8fKRG7m/bDlmVqw97L1HZoVh6qgLQ
fR7vZ7XzJ+aC4M1q2XZ4kcqoWtcYUfWSLSkS0t4qK/ea7wkYKykseBEd2yrNWKng
qYeLDZgbuJApQwEVWaI9T/0m46VmGaSvcU1UgpeGWRiiXAmH3R7eiFLzZF4zwc1Z
oXF6Y95+mlPbsfq2CKlbGq2QgE45ykv3z1h/MwpnAZCcu/y0RVmVqsROHiSjQTga
EKSlMYMj8kMFpCKPlPsOmQXqp9DFNEgFSNs+k6spPwCyP6O83vnSnkgQmk1eOwkd
tM7xDivlZlQKwWGyqqqIeoj4Qs4RLLvr9g02ZnzRpjpRd8xv6tF8et4JGdFpOyNu
xYJ67IZ5VCWOyPnvPFgVILQbhIjXVwFjTY+sQtxRaVUmw1dswx///PJI/EGmF4Rb
g4EUqqPvJjMXG6l4iG+LNd0KOzVu/YbLsWRJBKuSGZ8DrKCdyRi5e7oaNtcEJFnE
qXgc8XacWeAsTr5cTL0zqypoJcAWqh/qr/qcZ4wek1YXyud4E4k/ABEBAAGJAjYE
GAEIACAWIQRYVn8/qgbdaNAfKmRnU0/zZ6WcsAUCaXPaYAIbDAAKCRBnU0/zZ6Wc
sOY1EACe9olfRYIYrBhQoC8gHWoH9dzANEnKKzetPoxskEdiB3EqLl0fjV2rJ44M
ygFc482JTOx4LAq/tfd6YHa0k9nvXvxIFndZ9xbB4lZkXVc0olNUFQ5j5OQIHeNF
m98MU167kvIhpAomVHIWaIZlNI4J5NesDgnvAJYaxl86bPeMR3z5O4NziE2OqWp6
GZTuMQAWl6IZlmHmfavizU/kiVPWh8lkiiUZaIolMIs/f1GrzXU/LCFfTP1nClic
mKiq22bNbeSH7GgnwvE+pBMf3M37Crlw7ftZ8ILTElYp5kHQ37Ov4gnOJOGMz41M
c5+pdHk2OKh0MZwElEUXTkSMNaU+bMK3fw/LKjlDbIaRUYaBha1ahATbm0lGsdy4
3vVNqMWojnHKlnWkMRgpWs3Q1pMan1BtczB1tQtmid01pc/RqZqjfiac5qaeeJGi
aIZASR7DJ3TPHLvMm4hKuyxr/clEqEZCo94xVXVkeKrz76U0Bo34yteruZK8llpx
f4Q3IRqjtxl2weU6ko8WBUWtmh1fBhXEWLpAr0tHgcJE5XIWTtlk68t18nRCgF8x
Iw0H82nu+zERxpKhu6xT4PcnOGinQtC7uaAKn6M9rLrOZT0Gus42w+d2ABuyECs7
UVuYOxUw6lXquwOl4WO37imwmqIhFuqQaVLlVCrhc1QRcnHZ0g==
====
EOF
	# TODO: fix netpgpkeys so it doesn't need an empty keyring
	uudecode << EOF
begin-base64 664 pubring.gpg
====
EOF
	# TODO: needs fixing once netpgpkeys accepts the key
	uudecode << EOF
begin-base64 664 expected_rsa.out
====
EOF
	atf_check -s exit:0 -o file:expected_rsa.out -e empty env TZ=US/Pacific netpgpkeys --keyring pubring.gpg --import-key testkey-rsa.pub
}

# Test set 2 (elliptic curve keys) for netpgpkeys
atf_test_case netpgpkeys_testset_2_ec_keys

netpgpkeys_testset_2_ec_keys_head() {
	atf_set "descr" "Test set 2 (ec_keys) for netpgpkeys"
}
netpgpkeys_testset_2_ec_keys_body() {
        atf_expect_fail "PR bin/59936 - does not support keys generated by gnugp2 - dumps core for EC keys"
	uudecode << EOF
begin-base64 664 testkey-ec.pub
mDMEaXPYGBYJKwYBBAHaRw8BAQdAJItrcRJ05uSrXI4pWRwwYBzcqq+DMVL951D6
Uta3t/m0FnRlc3QgPHRlc3RATmV0QlNELm9yZz6ImQQTFgoAQRYhBCSzfniW90FO
SQjiiNqj8eXPHLOfBQJpc9gYAhsDBQkFo5qABQsJCAcCAiICBhUKCQgLAgQWAgMB
Ah4HAheAAAoJENqj8eXPHLOfgBQA/1dkSm8JHk1nKDbsAugPyEPhrCRXOdSPq/mH
rjii7/M4AP0VteJ7uuxW7BNYNXQHaHokWVIrUaIjdybnB3SmCZnwBrg4BGlz2BgS
CisGAQQBl1UBBQEBB0AoRgnCTqdaT7uCOLC/zzG0Ul15Sx36OxNBsYwBfrbkGwMB
CAeIfgQYFgoAJhYhBCSzfniW90FOSQjiiNqj8eXPHLOfBQJpc9gYAhsMBQkFo5qA
AAoJENqj8eXPHLOfGxkBAM+FmClSgZIon6yACCuhz8gSDtUAsaIhACG0tWVVYxaR
AQCGIvbI0ZmcpPZ2ptYKiLxSfeOk1JigVxGG61Sy8k+oDg==
====
EOF
	# TODO: fix netpgpkeys so it doesn't need an empty keyring
	uudecode << EOF
begin-base64 664 pubring.gpg
====
EOF
	# TODO: needs fixing once netpgpkeys doesn't dump core
	uudecode << EOF
begin-base64 664 expected_ec.out
====
EOF
	atf_check -s exit:0 -o file:expected_ec.out -e empty env TZ=US/Pacific netpgpkeys --keyring pubring.gpg --import-key testkey-ec.pub
}

# all test sets
atf_init_test_cases() {
	atf_add_test_case netpgpkeys_testset_1_rsa_keys
	atf_add_test_case netpgpkeys_testset_2_ec_keys
}

