/*	$NetBSD: imx50_iomuxreg.h,v 1.1 2014/07/25 07:49:56 hkenken Exp $	*/

/*
 * Copyright (c) 2012  Genetec Corporation.  All rights reserved.
 * Written by Hashimoto Kenichi for Genetec Corporation.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GENETEC CORPORATION ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL GENETEC CORPORATION
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This file was generated automatically from PDF file by mkiomuxreg_imx50.rb
 */

#ifndef	_ARM_IMX_IMX50_IOMUXREG_H
#define	_ARM_IMX_IMX50_IOMUXREG_H

/* register offset address */

#define IOMUXC_GPR0						0x0000
#define IOMUXC_GPR1						0x0004
#define IOMUXC_GPR2						0x0008
#define IOMUXC_OBSERVE_MUX_0					0x000C
#define IOMUXC_OBSERVE_MUX_1					0x0010
#define IOMUXC_OBSERVE_MUX_2					0x0014
#define IOMUXC_OBSERVE_MUX_3					0x0018
#define IOMUXC_OBSERVE_MUX_4					0x001C
#define IOMUXC_SW_MUX_CTL_PAD_KEY_COL0				0x0020
#define IOMUXC_SW_MUX_CTL_PAD_KEY_ROW0				0x0024
#define IOMUXC_SW_MUX_CTL_PAD_KEY_COL1				0x0028
#define IOMUXC_SW_MUX_CTL_PAD_KEY_ROW1				0x002C
#define IOMUXC_SW_MUX_CTL_PAD_KEY_COL2				0x0030
#define IOMUXC_SW_MUX_CTL_PAD_KEY_ROW2				0x0034
#define IOMUXC_SW_MUX_CTL_PAD_KEY_COL3				0x0038
#define IOMUXC_SW_MUX_CTL_PAD_KEY_ROW3				0x003C
#define IOMUXC_SW_MUX_CTL_PAD_I2C1_SCL				0x0040
#define IOMUXC_SW_MUX_CTL_PAD_I2C1_SDA				0x0044
#define IOMUXC_SW_MUX_CTL_PAD_I2C2_SCL				0x0048
#define IOMUXC_SW_MUX_CTL_PAD_I2C2_SDA				0x004C
#define IOMUXC_SW_MUX_CTL_PAD_I2C3_SCL				0x0050
#define IOMUXC_SW_MUX_CTL_PAD_I2C3_SDA				0x0054
#define IOMUXC_SW_MUX_CTL_PAD_PWM1				0x0058
#define IOMUXC_SW_MUX_CTL_PAD_PWM2				0x005C
#define IOMUXC_SW_MUX_CTL_PAD_OWIRE				0x0060
#define IOMUXC_SW_MUX_CTL_PAD_EPITO				0x0064
#define IOMUXC_SW_MUX_CTL_PAD_WDOG				0x0068
#define IOMUXC_SW_MUX_CTL_PAD_SSI_TXFS				0x006C
#define IOMUXC_SW_MUX_CTL_PAD_SSI_TXC				0x0070
#define IOMUXC_SW_MUX_CTL_PAD_SSI_TXD				0x0074
#define IOMUXC_SW_MUX_CTL_PAD_SSI_RXD				0x0078
#define IOMUXC_SW_MUX_CTL_PAD_SSI_RXF				0x007C
#define IOMUXC_SW_MUX_CTL_PAD_SSI_RXC				0x0080
#define IOMUXC_SW_MUX_CTL_PAD_UART1_TXD				0x0084
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RXD				0x0088
#define IOMUXC_SW_MUX_CTL_PAD_UART1_CTS				0x008C
#define IOMUXC_SW_MUX_CTL_PAD_UART1_RTS				0x0090
#define IOMUXC_SW_MUX_CTL_PAD_UART2_TXD				0x0094
#define IOMUXC_SW_MUX_CTL_PAD_UART2_RXD				0x0098
#define IOMUXC_SW_MUX_CTL_PAD_UART2_CTS				0x009C
#define IOMUXC_SW_MUX_CTL_PAD_UART2_RTS				0x00A0
#define IOMUXC_SW_MUX_CTL_PAD_UART3_TXD				0x00A4
#define IOMUXC_SW_MUX_CTL_PAD_UART3_RXD				0x00A8
#define IOMUXC_SW_MUX_CTL_PAD_UART4_TXD				0x00AC
#define IOMUXC_SW_MUX_CTL_PAD_UART4_RXD				0x00B0
#define IOMUXC_SW_MUX_CTL_PAD_CSPI_SCLK				0x00B4
#define IOMUXC_SW_MUX_CTL_PAD_CSPI_MOSI				0x00B8
#define IOMUXC_SW_MUX_CTL_PAD_CSPI_MISO				0x00BC
#define IOMUXC_SW_MUX_CTL_PAD_CSPI_SS0				0x00C0
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SCLK			0x00C4
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MOSI			0x00C8
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_MISO			0x00CC
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI1_SS0			0x00D0
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SCLK			0x00D4
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MOSI			0x00D8
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_MISO			0x00DC
#define IOMUXC_SW_MUX_CTL_PAD_ECSPI2_SS0			0x00E0
#define IOMUXC_SW_MUX_CTL_PAD_SD1_CLK				0x00E4
#define IOMUXC_SW_MUX_CTL_PAD_SD1_CMD				0x00E8
#define IOMUXC_SW_MUX_CTL_PAD_SD1_D0				0x00EC
#define IOMUXC_SW_MUX_CTL_PAD_SD1_D1				0x00F0
#define IOMUXC_SW_MUX_CTL_PAD_SD1_D2				0x00F4
#define IOMUXC_SW_MUX_CTL_PAD_SD1_D3				0x00F8
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CLK				0x00FC
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CMD				0x0100
#define IOMUXC_SW_MUX_CTL_PAD_SD2_D0				0x0104
#define IOMUXC_SW_MUX_CTL_PAD_SD2_D1				0x0108
#define IOMUXC_SW_MUX_CTL_PAD_SD2_D2				0x010C
#define IOMUXC_SW_MUX_CTL_PAD_SD2_D3				0x0110
#define IOMUXC_SW_MUX_CTL_PAD_SD2_D4				0x0114
#define IOMUXC_SW_MUX_CTL_PAD_SD2_D5				0x0118
#define IOMUXC_SW_MUX_CTL_PAD_SD2_D6				0x011C
#define IOMUXC_SW_MUX_CTL_PAD_SD2_D7				0x0120
#define IOMUXC_SW_MUX_CTL_PAD_SD2_WP				0x0124
#define IOMUXC_SW_MUX_CTL_PAD_SD2_CD				0x0128
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D0				0x012C
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D1				0x0130
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D2				0x0134
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D3				0x0138
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D4				0x013C
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D5				0x0140
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D6				0x0144
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D7				0x0148
#define IOMUXC_SW_MUX_CTL_PAD_DISP_WR				0x014C
#define IOMUXC_SW_MUX_CTL_PAD_DISP_RD				0x0150
#define IOMUXC_SW_MUX_CTL_PAD_DISP_RS				0x0154
#define IOMUXC_SW_MUX_CTL_PAD_DISP_CS				0x0158
#define IOMUXC_SW_MUX_CTL_PAD_DISP_BUSY				0x015C
#define IOMUXC_SW_MUX_CTL_PAD_DISP_RESET			0x0160
#define IOMUXC_SW_MUX_CTL_PAD_SD3_CMD				0x0164
#define IOMUXC_SW_MUX_CTL_PAD_SD3_CLK				0x0168
#define IOMUXC_SW_MUX_CTL_PAD_SD3_D0				0x016C
#define IOMUXC_SW_MUX_CTL_PAD_SD3_D1				0x0170
#define IOMUXC_SW_MUX_CTL_PAD_SD3_D2				0x0174
#define IOMUXC_SW_MUX_CTL_PAD_SD3_D3				0x0178
#define IOMUXC_SW_MUX_CTL_PAD_SD3_D4				0x017C
#define IOMUXC_SW_MUX_CTL_PAD_SD3_D5				0x0180
#define IOMUXC_SW_MUX_CTL_PAD_SD3_D6				0x0184
#define IOMUXC_SW_MUX_CTL_PAD_SD3_D7				0x0188
#define IOMUXC_SW_MUX_CTL_PAD_SD3_WP				0x018C
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D8				0x0190
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D9				0x0194
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D10				0x0198
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D11				0x019C
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D12				0x01A0
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D13				0x01A4
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D14				0x01A8
#define IOMUXC_SW_MUX_CTL_PAD_DISP_D15				0x01AC
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D0				0x01B0
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D1				0x01B4
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D2				0x01B8
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D3				0x01BC
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D4				0x01C0
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D5				0x01C4
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D6				0x01C8
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D7				0x01CC
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D8				0x01D0
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D9				0x01D4
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D10				0x01D8
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D11				0x01DC
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D12				0x01E0
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D13				0x01E4
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D14				0x01E8
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_D15				0x01EC
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK			0x01F0
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP				0x01F4
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE				0x01F8
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL				0x01FC
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK			0x0200
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOEZ			0x0204
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOED			0x0208
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE				0x020C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE				0x0210
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLKN			0x0214
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR			0x0218
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCOM			0x021C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRSTAT			0x0220
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCTRL0			0x0224
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCTRL1			0x0228
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCTRL2			0x022C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_PWRCTRL3			0x0230
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM0			0x0234
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM1			0x0238
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0				0x023C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1				0x0240
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0			0x0244
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1			0x0248
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2			0x024C
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3			0x0250
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE4			0x0254
#define IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE5			0x0258
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA0				0x025C
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA1				0x0260
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA2				0x0264
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA3				0x0268
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA4				0x026C
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA5				0x0270
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA6				0x0274
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA7				0x0278
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA8				0x027C
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA9				0x0280
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA10				0x0284
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA11				0x0288
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA12				0x028C
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA13				0x0290
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA14				0x0294
#define IOMUXC_SW_MUX_CTL_PAD_EIM_DA15				0x0298
#define IOMUXC_SW_MUX_CTL_PAD_EIM_CS2				0x029C
#define IOMUXC_SW_MUX_CTL_PAD_EIM_CS1				0x02A0
#define IOMUXC_SW_MUX_CTL_PAD_EIM_CS0				0x02A4
#define IOMUXC_SW_MUX_CTL_PAD_EIM_EB0				0x02A8
#define IOMUXC_SW_MUX_CTL_PAD_EIM_EB1				0x02AC
#define IOMUXC_SW_MUX_CTL_PAD_EIM_WAIT				0x02B0
#define IOMUXC_SW_MUX_CTL_PAD_EIM_BCLK				0x02B4
#define IOMUXC_SW_MUX_CTL_PAD_EIM_RDY				0x02B8
#define IOMUXC_SW_MUX_CTL_PAD_EIM_OE				0x02BC
#define IOMUXC_SW_MUX_CTL_PAD_EIM_RW				0x02C0
#define IOMUXC_SW_MUX_CTL_PAD_EIM_LBA				0x02C4
#define IOMUXC_SW_MUX_CTL_PAD_EIM_CRE				0x02C8
#define IOMUXC_SW_PAD_CTL_PAD_KEY_COL0				0x02CC
#define IOMUXC_SW_PAD_CTL_PAD_KEY_ROW0				0x02D0
#define IOMUXC_SW_PAD_CTL_PAD_KEY_COL1				0x02D4
#define IOMUXC_SW_PAD_CTL_PAD_KEY_ROW1				0x02D8
#define IOMUXC_SW_PAD_CTL_PAD_KEY_COL2				0x02DC
#define IOMUXC_SW_PAD_CTL_PAD_KEY_ROW2				0x02E0
#define IOMUXC_SW_PAD_CTL_PAD_KEY_COL3				0x02E4
#define IOMUXC_SW_PAD_CTL_PAD_KEY_ROW3				0x02E8
#define IOMUXC_SW_PAD_CTL_PAD_I2C1_SCL				0x02EC
#define IOMUXC_SW_PAD_CTL_PAD_I2C1_SDA				0x02F0
#define IOMUXC_SW_PAD_CTL_PAD_I2C2_SCL				0x02F4
#define IOMUXC_SW_PAD_CTL_PAD_I2C2_SDA				0x02F8
#define IOMUXC_SW_PAD_CTL_PAD_I2C3_SCL				0x02FC
#define IOMUXC_SW_PAD_CTL_PAD_I2C3_SDA				0x0300
#define IOMUXC_SW_PAD_CTL_PAD_PWM1				0x0304
#define IOMUXC_SW_PAD_CTL_PAD_PWM2				0x0308
#define IOMUXC_SW_PAD_CTL_PAD_OWIRE				0x030C
#define IOMUXC_SW_PAD_CTL_PAD_EPITO				0x0310
#define IOMUXC_SW_PAD_CTL_PAD_WDOG				0x0314
#define IOMUXC_SW_PAD_CTL_PAD_SSI_TXFS				0x0318
#define IOMUXC_SW_PAD_CTL_PAD_SSI_TXC				0x031C
#define IOMUXC_SW_PAD_CTL_PAD_SSI_TXD				0x0320
#define IOMUXC_SW_PAD_CTL_PAD_SSI_RXD				0x0324
#define IOMUXC_SW_PAD_CTL_PAD_SSI_RXFS				0x0328
#define IOMUXC_SW_PAD_CTL_PAD_SSI_RXC				0x032C
#define IOMUXC_SW_PAD_CTL_PAD_UART1_TXD				0x0330
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RXD				0x0334
#define IOMUXC_SW_PAD_CTL_PAD_UART1_CTS				0x0338
#define IOMUXC_SW_PAD_CTL_PAD_UART1_RTS				0x033C
#define IOMUXC_SW_PAD_CTL_PAD_UART2_TXD				0x0340
#define IOMUXC_SW_PAD_CTL_PAD_UART2_RXD				0x0344
#define IOMUXC_SW_PAD_CTL_PAD_UART2_CTS				0x0348
#define IOMUXC_SW_PAD_CTL_PAD_UART2_RTS				0x034C
#define IOMUXC_SW_PAD_CTL_PAD_UART3_TXD				0x0350
#define IOMUXC_SW_PAD_CTL_PAD_UART3_RXD				0x0354
#define IOMUXC_SW_PAD_CTL_PAD_UART4_TXD				0x0358
#define IOMUXC_SW_PAD_CTL_PAD_UART4_RXD				0x035C
#define IOMUXC_SW_PAD_CTL_PAD_CSPI_SCLK				0x0360
#define IOMUXC_SW_PAD_CTL_PAD_CSPI_MOSI				0x0364
#define IOMUXC_SW_PAD_CTL_PAD_CSPI_MISO				0x0368
#define IOMUXC_SW_PAD_CTL_PAD_CSPI_SS0				0x036C
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SCLK			0x0370
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MOSI			0x0374
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_MISO			0x0378
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI1_SS0			0x037C
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SCLK			0x0380
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MOSI			0x0384
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_MISO			0x0388
#define IOMUXC_SW_PAD_CTL_PAD_ECSPI2_SS0			0x038C
#define IOMUXC_SW_PAD_CTL_PAD_SD1_CLK				0x0390
#define IOMUXC_SW_PAD_CTL_PAD_SD1_CMD				0x0394
#define IOMUXC_SW_PAD_CTL_PAD_SD1_D0				0x0398
#define IOMUXC_SW_PAD_CTL_PAD_SD1_D1				0x039C
#define IOMUXC_SW_PAD_CTL_PAD_SD1_D2				0x03A0
#define IOMUXC_SW_PAD_CTL_PAD_SD1_D3				0x03A4
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CLK				0x03A8
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CMD				0x03AC
#define IOMUXC_SW_PAD_CTL_PAD_SD2_D0				0x03B0
#define IOMUXC_SW_PAD_CTL_PAD_SD2_D1				0x03B4
#define IOMUXC_SW_PAD_CTL_PAD_SD2_D2				0x03B8
#define IOMUXC_SW_PAD_CTL_PAD_SD2_D3				0x03BC
#define IOMUXC_SW_PAD_CTL_PAD_SD2_D4				0x03C0
#define IOMUXC_SW_PAD_CTL_PAD_SD2_D5				0x03C4
#define IOMUXC_SW_PAD_CTL_PAD_SD2_D6				0x03C8
#define IOMUXC_SW_PAD_CTL_PAD_SD2_D7				0x03CC
#define IOMUXC_SW_PAD_CTL_PAD_SD2_WP				0x03D0
#define IOMUXC_SW_PAD_CTL_PAD_SD2_CD				0x03D4
#define IOMUXC_SW_PAD_CTL_PAD_PMIC_ON_REQ			0x03D8
#define IOMUXC_SW_PAD_CTL_PAD_PMIC_STBY_REQ			0x03DC
#define IOMUXC_SW_PAD_CTL_PAD_POR_B				0x03E0
#define IOMUXC_SW_PAD_CTL_PAD_BOOT_MODE1			0x03E4
#define IOMUXC_SW_PAD_CTL_PAD_RESET_IN_B			0x03E8
#define IOMUXC_SW_PAD_CTL_PAD_BOOT_MODE0			0x03EC
#define IOMUXC_SW_PAD_CTL_PAD_TEST_MODE				0x03F0
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TMS				0x03F4
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_MOD				0x03F8
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TRSTB			0x03FC
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TDI				0x0400
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TCK				0x0404
#define IOMUXC_SW_PAD_CTL_PAD_JTAG_TDO				0x0408
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D0				0x040C
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D1				0x0410
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D2				0x0414
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D3				0x0418
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D4				0x041C
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D5				0x0420
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D6				0x0424
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D7				0x0428
#define IOMUXC_SW_PAD_CTL_PAD_DISP_WR				0x042C
#define IOMUXC_SW_PAD_CTL_PAD_DISP_RD				0x0430
#define IOMUXC_SW_PAD_CTL_PAD_DISP_RS				0x0434
#define IOMUXC_SW_PAD_CTL_PAD_DISP_CS				0x0438
#define IOMUXC_SW_PAD_CTL_PAD_DISP_BUSY				0x043C
#define IOMUXC_SW_PAD_CTL_PAD_DISP_RESET			0x0440
#define IOMUXC_SW_PAD_CTL_PAD_SD3_CMD				0x0444
#define IOMUXC_SW_PAD_CTL_PAD_SD3_CLK				0x0448
#define IOMUXC_SW_PAD_CTL_PAD_SD3_D0				0x044C
#define IOMUXC_SW_PAD_CTL_PAD_SD3_D1				0x0450
#define IOMUXC_SW_PAD_CTL_PAD_SD3_D2				0x0454
#define IOMUXC_SW_PAD_CTL_PAD_SD3_D3				0x0458
#define IOMUXC_SW_PAD_CTL_PAD_SD3_D4				0x045C
#define IOMUXC_SW_PAD_CTL_PAD_SD3_D5				0x0460
#define IOMUXC_SW_PAD_CTL_PAD_SD3_D6				0x0464
#define IOMUXC_SW_PAD_CTL_PAD_SD3_D7				0x0468
#define IOMUXC_SW_PAD_CTL_PAD_SD3_WP				0x046C
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D8				0x0470
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D9				0x0474
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D10				0x0478
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D11				0x047C
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D12				0x0480
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D13				0x0484
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D14				0x0488
#define IOMUXC_SW_PAD_CTL_PAD_DISP_D15				0x048C
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_OPEN				0x0490
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_OPENFB			0x0494
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_1			0x0498
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_0			0x049C
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE			0x04A0
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT0			0x04A4
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D16				0x04A8
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D17				0x04AC
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D18				0x04B0
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D19				0x04B4
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D20				0x04B8
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D21				0x04BC
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D22				0x04C0
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D23				0x04C4
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2				0x04C8
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2			0x04CC
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D0				0x04D0
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D1				0x04D4
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D2				0x04D8
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D3				0x04DC
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D4				0x04E0
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D5				0x04E4
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D6				0x04E8
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D7				0x04EC
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0				0x04F0
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0			0x04F4
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT1			0x04F8
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1			0x04FC
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1				0x0500
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D8				0x0504
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D9				0x0508
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D10				0x050C
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D11				0x0510
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D12				0x0514
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D13				0x0518
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D14				0x051C
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D15				0x0520
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3			0x0524
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3				0x0528
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D24				0x052C
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D25				0x0530
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D26				0x0534
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D27				0x0538
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D28				0x053C
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D29				0x0540
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D30				0x0544
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_D31				0x0548
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D0				0x054C
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D1				0x0550
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D2				0x0554
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D3				0x0558
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D4				0x055C
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D5				0x0560
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D6				0x0564
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D7				0x0568
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D8				0x056C
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D9				0x0570
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D10				0x0574
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D11				0x0578
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D12				0x057C
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D13				0x0580
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D14				0x0584
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_D15				0x0588
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK			0x058C
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP				0x0590
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE				0x0594
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL				0x0598
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK			0x059C
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOEZ			0x05A0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOED			0x05A4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE				0x05A8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE				0x05AC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLKN			0x05B0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR			0x05B4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCOM			0x05B8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRSTAT			0x05BC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCTRL0			0x05C0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCTRL1			0x05C4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCTRL2			0x05C8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_PWRCTRL3			0x05CC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0			0x05D0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1			0x05D4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0				0x05D8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1				0x05DC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0			0x05E0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1			0x05E4
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2			0x05E8
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3			0x05EC
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE4			0x05F0
#define IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE5			0x05F4
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA0				0x05F8
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA1				0x05FC
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA2				0x0600
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA3				0x0604
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA4				0x0608
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA5				0x060C
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA6				0x0610
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA7				0x0614
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA8				0x0618
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA9				0x061C
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA10				0x0620
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA11				0x0624
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA12				0x0628
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA13				0x062C
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA14				0x0630
#define IOMUXC_SW_PAD_CTL_PAD_EIM_DA15				0x0634
#define IOMUXC_SW_PAD_CTL_PAD_EIM_CS2				0x0638
#define IOMUXC_SW_PAD_CTL_PAD_EIM_CS1				0x063C
#define IOMUXC_SW_PAD_CTL_PAD_EIM_CS0				0x0640
#define IOMUXC_SW_PAD_CTL_PAD_EIM_EB0				0x0644
#define IOMUXC_SW_PAD_CTL_PAD_EIM_EB1				0x0648
#define IOMUXC_SW_PAD_CTL_PAD_EIM_WAIT				0x064C
#define IOMUXC_SW_PAD_CTL_PAD_EIM_BCLK				0x0650
#define IOMUXC_SW_PAD_CTL_PAD_EIM_RDY				0x0654
#define IOMUXC_SW_PAD_CTL_PAD_EIM_OE				0x0658
#define IOMUXC_SW_PAD_CTL_PAD_EIM_RW				0x065C
#define IOMUXC_SW_PAD_CTL_PAD_EIM_LBA				0x0660
#define IOMUXC_SW_PAD_CTL_PAD_EIM_CRE				0x0664
#define IOMUXC_SW_PAD_CTL_GRP_ADDDS				0x0668
#define IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL			0x066C
#define IOMUXC_SW_PAD_CTL_GRP_DDRPKE				0x0670
#define IOMUXC_SW_PAD_CTL_GRP_EIM				0x0674
#define IOMUXC_SW_PAD_CTL_GRP_EPDC				0x0678
#define IOMUXC_SW_PAD_CTL_GRP_UART				0x067C
#define IOMUXC_SW_PAD_CTL_GRP_DDRPK				0x0680
#define IOMUXC_SW_PAD_CTL_GRP_DDRHYS				0x0684
#define IOMUXC_SW_PAD_CTL_GRP_KEYPAD				0x0688
#define IOMUXC_SW_PAD_CTL_GRP_DDRMODE				0x068C
#define IOMUXC_SW_PAD_CTL_GRP_SSI				0x0690
#define IOMUXC_SW_PAD_CTL_GRP_SD1				0x0694
#define IOMUXC_SW_PAD_CTL_GRP_B0DS				0x0698
#define IOMUXC_SW_PAD_CTL_GRP_SD2				0x069C
#define IOMUXC_SW_PAD_CTL_GRP_B1DS				0x06A0
#define IOMUXC_SW_PAD_CTL_GRP_CTLDS				0x06A4
#define IOMUXC_SW_PAD_CTL_GRP_B2DS				0x06A8
#define IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE				0x06AC
#define IOMUXC_SW_PAD_CTL_GRP_LCD				0x06B0
#define IOMUXC_SW_PAD_CTL_GRP_B3DS				0x06B4
#define IOMUXC_SW_PAD_CTL_GRP_MISC				0x06B8
#define IOMUXC_SW_PAD_CTL_GRP_SPI				0x06BC
#define IOMUXC_SW_PAD_CTL_GRP_NANDF				0x06C0
#define IOMUXC_AUDMUX_P4_INPUT_DA_AMX_SELECT_INPUT		0x06C4
#define IOMUXC_AUDMUX_P4_INPUT_DB_AMX_SELECT_INPUT		0x06C8
#define IOMUXC_AUDMUX_P4_INPUT_RXCLK_AMX_SELECT_INPUT		0x06CC
#define IOMUXC_AUDMUX_P4_INPUT_RXFS_AMX_SELECT_INPUT		0x06D0
#define IOMUXC_AUDMUX_P4_INPUT_TXCLK_AMX_SELECT_INPUT		0x06D4
#define IOMUXC_AUDMUX_P4_INPUT_TXFS_AMX_SELECT_INPUT		0x06D8
#define IOMUXC_CCM_PLL1_BYPASS_CLK_SELECT_INPUT			0x06DC
#define IOMUXC_CCM_PLL2_BYPASS_CLK_SELECT_INPUT			0x06E0
#define IOMUXC_CCM_PLL3_BYPASS_CLK_SELECT_INPUT			0x06E4
#define IOMUXC_CSPI_IPP_IND_DATAREADY_B_SELECT_INPUT		0x06E8
#define IOMUXC_CSPI_IPP_IND_SS1_B_SELECT_INPUT			0x06EC
#define IOMUXC_CSPI_IPP_IND_SS2_B_SELECT_INPUT			0x06F0
#define IOMUXC_CSPI_IPP_IND_SS3_B_SELECT_INPUT			0x06F4
#define IOMUXC_ELCDIF_LCDIF_BUSY_SELECT_INPUT			0x06F8
#define IOMUXC_ELCDIF_LCDIF_RXDATA_0_SELECT_INPUT		0x06FC
#define IOMUXC_ELCDIF_LCDIF_RXDATA_1_SELECT_INPUT		0x0700
#define IOMUXC_ELCDIF_LCDIF_RXDATA_2_SELECT_INPUT		0x0704
#define IOMUXC_ELCDIF_LCDIF_RXDATA_3_SELECT_INPUT		0x0708
#define IOMUXC_ELCDIF_LCDIF_RXDATA_4_SELECT_INPUT		0x070C
#define IOMUXC_ELCDIF_LCDIF_RXDATA_5_SELECT_INPUT		0x0710
#define IOMUXC_ELCDIF_LCDIF_RXDATA_6_SELECT_INPUT		0x0714
#define IOMUXC_ELCDIF_LCDIF_RXDATA_7_SELECT_INPUT		0x0718
#define IOMUXC_ELCDIF_LCDIF_RXDATA_8_SELECT_INPUT		0x071C
#define IOMUXC_C_ELCDIF_LCDIF_RXDATA_9_SELECT_INPUT		0x0720
#define IOMUXC_ELCDIF_LCDIF_RXDATA_10_SELECT_INPUT		0x0724
#define IOMUXC_ELCDIF_LCDIF_RXDATA_11_SELECT_INPUT		0x0728
#define IOMUXC_ELCDIF_LCDIF_RXDATA_12_SELECT_INPUT		0x072C
#define IOMUXC_ELCDIF_LCDIF_RXDATA_13_SELECT_INPUT		0x0730
#define IOMUXC_ELCDIF_LCDIF_RXDATA_14_SELECT_INPUT		0x0734
#define IOMUXC_ELCDIF_LCDIF_RXDATA_15_SELECT_INPUT		0x0738
#define IOMUXC_ELCDIF_VSYNC_I_SELECT_INPUT			0x073C
#define IOMUXC_ESDHC2_IPP_CARD_DET_SELECT_INPUT			0x0740
#define IOMUXC_ESDHC2_IPP_WP_ON_SELECT_INPUT			0x0744
#define IOMUXC_ESDHC4_IPP_CARD_CLK_IN_SELECT_INPUT		0x0748
#define IOMUXC_ESDHC4_IPP_CMD_IN_SELECT_INPUT			0x074C
#define IOMUXC_ESDHC4_IPP_DAT0_IN_SELECT_INPUT			0x0750
#define IOMUXC_XC_ESDHC4_IPP_DAT1_IN_SELECT_INPUT		0x0754
#define IOMUXC_ESDHC4_IPP_DAT2_IN_SELECT_INPUT			0x0758
#define IOMUXC_ESDHC4_IPP_DAT3_IN_SELECT_INPUT			0x075C
#define IOMUXC_ESDHC4_IPP_DAT4_IN_SELECT_INPUT			0x0760
#define IOMUXC_ESDHC4_IPP_DAT5_IN_SELECT_INPUT			0x0764
#define IOMUXC_ESDHC4_IPP_DAT6_IN_SELECT_INPUT			0x0768
#define IOMUXC_ESDHC4_IPP_DAT7_IN_SELECT_INPUT			0x076C
#define IOMUXC_FEC_FEC_COL_SELECT_INPUT				0x0770
#define IOMUXC_FEC_FEC_MDI_SELECT_INPUT				0x0774
#define IOMUXC_FEC_FEC_RDATA_0_SELECT_INPUT			0x0778
#define IOMUXC_FEC_FEC_RDATA_1_SELECT_INPUT			0x077C
#define IOMUXC_FEC_FEC_RX_CLK_SELECT_INPUT			0x0780
#define IOMUXC_FEC_FEC_RX_DV_SELECT_INPUT			0x0784
#define IOMUXC_FEC_FEC_RX_ER_SELECT_INPUT			0x0788
#define IOMUXC_FEC_FEC_TX_CLK_SELECT_INPUT			0x078C
#define IOMUXC_KPP_IPP_IND_COL_4_SELECT_INPUT			0x0790
#define IOMUXC_KPP_IPP_IND_COL_5_SELECT_INPUT			0x0794
#define IOMUXC_KPP_IPP_IND_COL_6_SELECT_INPUT			0x0798
#define IOMUXC_KPP_IPP_IND_COL_7_SELECT_INPUT			0x079C
#define IOMUXC_KPP_IPP_IND_ROW_4_SELECT_INPUT			0x07A0
#define IOMUXC_KPP_IPP_IND_ROW_5_SELECT_INPUT			0x07A4
#define IOMUXC_KPP_IPP_IND_ROW_6_SELECT_INPUT			0x07A8
#define IOMUXC_KPP_IPP_IND_ROW_7_SELECT_INPUT			0x07AC
#define IOMUXC_RAWNAND_U_GPMI_INPUT_GPMI_DQS_IN_SELECT_INPUT	0x07B0
#define IOMUXC_RAWNAND_U_GPMI_INPUT_GPMI_RDY0_SELECT_INPUT	0x07B4
#define IOMUXC_SDMA_EVENTS_14_SELECT_INPUT			0x07B8
#define IOMUXC_SDMA_EVENTS_15_SELECT_INPUT			0x07BC
#define IOMUXC_UART1_IPP_UART_RTS_B_SELECT_INPUT		0x07C0
#define IOMUXC_UART1_IPP_UART_RXD_MUX_SELECT_INPUT		0x07C4
#define IOMUXC_UART2_IPP_UART_RTS_B_SELECT_INPUT		0x07C8
#define IOMUXC_UART2_IPP_UART_RXD_MUX_SELECT_INPUT		0x07CC
#define IOMUXC_UART3_IPP_UART_RTS_B_SELECT_INPUT		0x07D0
#define IOMUXC_UART3_IPP_UART_RXD_MUX_SELECT_INPUT		0x07D4
#define IOMUXC_UART4_IPP_UART_RTS_B_SELECT_INPUT		0x07D8
#define IOMUXC_UART4_IPP_UART_RXD_MUX_SELECT_INPUT		0x07DC
#define IOMUXC_UART5_IPP_UART_RTS_B_SELECT_INPUT		0x07E0
#define IOMUXC_UART5_IPP_UART_RXD_MUX_SELECT_INPUT		0x07E4
#define IOMUXC_USBOH1_IPP_IND_OTG_OC_SELECT_INPUT		0x07E8
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_0_SELECT_INPUT		0x07EC
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_1_SELECT_INPUT		0x07F0
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_2_SELECT_INPUT		0x07F4
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_3_SELECT_INPUT		0x07F8
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_4_SELECT_INPUT		0x07FC
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_5_SELECT_INPUT		0x0800
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_6_SELECT_INPUT		0x0804
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_7_SELECT_INPUT		0x0808
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_8_SELECT_INPUT		0x080C
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_9_SELECT_INPUT		0x0810
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_10_SELECT_INPUT		0x0814
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_11_SELECT_INPUT		0x0818
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_12_SELECT_INPUT		0x081C
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_13_SELECT_INPUT		0x0820
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_14_SELECT_INPUT		0x0824
#define IOMUXC_WEIMV2_IPP_IND_READ_DATA_15_SELECT_INPUT		0x0828

#endif /* _ARM_IMX_IMX50_IOMUXREG_H */

