/* $NetBSD: omap3_uhhreg.h,v 1.4 2016/10/04 15:46:07 kiyohara Exp $ */

/*-
 * Copyright (c) 2010 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _OMAP3_UHHREG_H
#define _OMAP3_UHHREG_H

/* 32-bit */
#define	UHH_REVISION				0x00
#define	 UHH_REVISION_MAJOR(x)			(((x) >> 4) & 0xf)
#define	 UHH_REVISION_MINOR(x)			((x) & 0xf)
#define  UHH_REVISION_VERS2			0

#define UHH_HWINFO				0x04
#define  UHH_HWINFO_SAR_CNTX_SIZE		 __BITS(9,0)

#define	UHH_SYSCONFIG				0x10
#define	 UHH3_SYSCONFIG_MIDLEMODE_MASK		0x00003000
#define   UHH3_SYSCONFIG_MIDLEMODE_SMARTSTANDBY	0x00002000
#define	 UHH3_SYSCONFIG_CLOCKACTIVITY		0x00000100
#define	 UHH3_SYSCONFIG_SIDLEMODE_MASK		0x00000018
#define   UHH3_SYSCONFIG_SIDLEMODE_SMARTIDLE	0x00000008
#define	 UHH3_SYSCONFIG_ENAWAKEUP		0x00000004
#define	 UHH3_SYSCONFIG_SOFTRESET		0x00000002
#define	 UHH3_SYSCONFIG_AUTOIDLE		0x00000001

#define  UHH4_SYSCONFIG_STANDBYMODE		__BITS(5,4)
#define   UHH4_SYSCONFIG_STANDBYMODE_SMARTSTANDBY	__SHIFTIN(2,UHH4_SYSCONFIG_STANDBYMODE)
#define  UHH4_SYSCONFIG_SIDLEMODE		__BITS(3,2)
#define   UHH4_SYSCONFIG_SIDLEMODE_SMARTIDLE	__SHIFTIN(2,UHH4_SYSCONFIG_SIDLEMODE)
#define  UHH4_SYSCONFIG_SOFTRESET		__BIT(0)

#define	UHH_SYSSTATUS				0x14
#define	 UHH_SYSSTATUS_EHCI_RESETDONE		0x00000004
#define	 UHH_SYSSTATUS_OHCI_RESETDONE		0x00000002
#define	 UHH3_SYSSTATUS_RESETDONE		0x00000001
#define	 UHH3_SYSSTATUS_RESETDONE_ALL		\
	 (UHH_SYSSTATUS_EHCI_RESETDONE |	\
	  UHH_SYSSTATUS_OHCI_RESETDONE |	\
	  UHH3_SYSSTATUS_RESETDONE)
#define	 UHH4_SYSSTATUS_RESETDONE_ALL		\
	 (UHH_SYSSTATUS_EHCI_RESETDONE |	\
	  UHH_SYSSTATUS_OHCI_RESETDONE)

#define	UHH_HOSTCONFIG				0x40
#define  UHH_HOSTCONFIG_APP_START_CLK		__BIT(31)
#define	 UHH_HOSTCONFIG_P3_MODE			__BITS(21,20)
#define	 UHH_HOSTCONFIG_P2_MODE			__BITS(19,18)
#define	 UHH_HOSTCONFIG_P1_MODE			__BITS(17,16)
#define   UHH_HOSTCONFIG_PMODE_ULPI_PHY		0
#define   UHH_HOSTCONFIG_PMODE_UTMI		1
#define   UHH_HOSTCONFIG_PMODE__RSVD2		2
#define   UHH_HOSTCONFIG_PMODE_HSIC		3
#define	 UHH_HOSTCONFIG_P3_ULPI_BYPASS		__BIT(12)
#define	 UHH_HOSTCONFIG_P2_ULPI_BYPASS		__BIT(11)
#define	 UHH_HOSTCONFIG_P3_CONNECT_STATUS	__BIT(10)
#define	 UHH_HOSTCONFIG_P2_CONNECT_STATUS	__BIT(9)
#define	 UHH_HOSTCONFIG_P1_CONNECT_STATUS	__BIT(8)
#define	 UHH_HOSTCONFIG_ENA_INCR_ALIGN		__BIT(5)
#define	 UHH_HOSTCONFIG_ENA_INCR16		__BIT(4)
#define	 UHH_HOSTCONFIG_ENA_INCR8		__BIT(3)
#define	 UHH_HOSTCONFIG_ENA_INCR4		__BIT(2)
#define	 UHH_HOSTCONFIG_AUTOPPD_ON_OVERCUR_EN	__BIT(1)
#define	 UHH_HOSTCONFIG_P1_ULPI_BYPASS		__BIT(0)

#define	UHH_DEBUG_CSR	0x44
#define	 UHH_DEBUG_CSR_OHCI_CCS_3		0x00080000
#define	 UHH_DEBUG_CSR_OHCI_CCS_2		0x00040000
#define	 UHH_DEBUG_CSR_OHCI_CCS_1		0x00020000
#define	 UHH_DEBUG_CSR_OHCI_GLOBALSUSPEND	0x00010000
#define	 UHH_DEBUG_CSR_OHCI_CNTSEL		0x00000080
#define	 UHH_DEBUG_CSR_EHCI_SIMULATION_MODE	0x00000040
#define	 UHH_DEBUG_CSR_EHCI_FLADJ		0x0000003f

#define UHH_SAR_CNTX_BASE	0x100

#endif /* !_OMAP3_UHHREG_H */
