/*	$NetBSD: gmc_8_1_sh_mask.h,v 1.2 2018/08/27 04:58:22 riastradh Exp $	*/

/*
 * GMC_8_1 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef GMC_8_1_SH_MASK_H
#define GMC_8_1_SH_MASK_H

#define MC_CONFIG__MCDW_WR_ENABLE_MASK 0x1
#define MC_CONFIG__MCDW_WR_ENABLE__SHIFT 0x0
#define MC_CONFIG__MCDX_WR_ENABLE_MASK 0x2
#define MC_CONFIG__MCDX_WR_ENABLE__SHIFT 0x1
#define MC_CONFIG__MCDY_WR_ENABLE_MASK 0x4
#define MC_CONFIG__MCDY_WR_ENABLE__SHIFT 0x2
#define MC_CONFIG__MCDZ_WR_ENABLE_MASK 0x8
#define MC_CONFIG__MCDZ_WR_ENABLE__SHIFT 0x3
#define MC_CONFIG__MCDS_WR_ENABLE_MASK 0x10
#define MC_CONFIG__MCDS_WR_ENABLE__SHIFT 0x4
#define MC_CONFIG__MCDT_WR_ENABLE_MASK 0x20
#define MC_CONFIG__MCDT_WR_ENABLE__SHIFT 0x5
#define MC_CONFIG__MCDU_WR_ENABLE_MASK 0x40
#define MC_CONFIG__MCDU_WR_ENABLE__SHIFT 0x6
#define MC_CONFIG__MCDV_WR_ENABLE_MASK 0x80
#define MC_CONFIG__MCDV_WR_ENABLE__SHIFT 0x7
#define MC_CONFIG__MC_RD_ENABLE_MASK 0x700
#define MC_CONFIG__MC_RD_ENABLE__SHIFT 0x8
#define MC_CONFIG__MCC_INDEX_MODE_ENABLE_MASK 0x80000000
#define MC_CONFIG__MCC_INDEX_MODE_ENABLE__SHIFT 0x1f
#define MC_ARB_ATOMIC__TC_GRP_MASK 0x7
#define MC_ARB_ATOMIC__TC_GRP__SHIFT 0x0
#define MC_ARB_ATOMIC__TC_GRP_EN_MASK 0x8
#define MC_ARB_ATOMIC__TC_GRP_EN__SHIFT 0x3
#define MC_ARB_ATOMIC__SDMA_GRP_MASK 0x70
#define MC_ARB_ATOMIC__SDMA_GRP__SHIFT 0x4
#define MC_ARB_ATOMIC__SDMA_GRP_EN_MASK 0x80
#define MC_ARB_ATOMIC__SDMA_GRP_EN__SHIFT 0x7
#define MC_ARB_ATOMIC__OUTSTANDING_MASK 0xff00
#define MC_ARB_ATOMIC__OUTSTANDING__SHIFT 0x8
#define MC_ARB_ATOMIC__ATOMIC_RTN_GRP_MASK 0xff0000
#define MC_ARB_ATOMIC__ATOMIC_RTN_GRP__SHIFT 0x10
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP0_MASK 0x1
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP0__SHIFT 0x0
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP1_MASK 0x2
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP1__SHIFT 0x1
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP2_MASK 0x4
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP2__SHIFT 0x2
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP3_MASK 0x8
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP3__SHIFT 0x3
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP4_MASK 0x10
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP4__SHIFT 0x4
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP5_MASK 0x20
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP5__SHIFT 0x5
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP6_MASK 0x40
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP6__SHIFT 0x6
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP7_MASK 0x80
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP7__SHIFT 0x7
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP0_MASK 0x100
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP0__SHIFT 0x8
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP1_MASK 0x200
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP1__SHIFT 0x9
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP2_MASK 0x400
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP2__SHIFT 0xa
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP3_MASK 0x800
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP3__SHIFT 0xb
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP4_MASK 0x1000
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP4__SHIFT 0xc
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP5_MASK 0x2000
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP5__SHIFT 0xd
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP6_MASK 0x4000
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP6__SHIFT 0xe
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP7_MASK 0x8000
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP7__SHIFT 0xf
#define MC_ARB_AGE_CNTL__AGE_LOW_RATE_RD_MASK 0x70000
#define MC_ARB_AGE_CNTL__AGE_LOW_RATE_RD__SHIFT 0x10
#define MC_ARB_AGE_CNTL__AGE_LOW_RATE_WR_MASK 0x380000
#define MC_ARB_AGE_CNTL__AGE_LOW_RATE_WR__SHIFT 0x13
#define MC_ARB_AGE_CNTL__TIMER_STALL_RD_MASK 0x400000
#define MC_ARB_AGE_CNTL__TIMER_STALL_RD__SHIFT 0x16
#define MC_ARB_AGE_CNTL__TIMER_STALL_WR_MASK 0x800000
#define MC_ARB_AGE_CNTL__TIMER_STALL_WR__SHIFT 0x17
#define MC_ARB_AGE_CNTL__EXTEND_WEIGHT_RD_MASK 0x1000000
#define MC_ARB_AGE_CNTL__EXTEND_WEIGHT_RD__SHIFT 0x18
#define MC_ARB_AGE_CNTL__EXTEND_WEIGHT_WR_MASK 0x2000000
#define MC_ARB_AGE_CNTL__EXTEND_WEIGHT_WR__SHIFT 0x19
#define MC_ARB_RET_CREDITS2__ACP_WR_MASK 0xff
#define MC_ARB_RET_CREDITS2__ACP_WR__SHIFT 0x0
#define MC_ARB_RET_CREDITS2__NECKDOWN_CNTR_EN_RD_MASK 0x100
#define MC_ARB_RET_CREDITS2__NECKDOWN_CNTR_EN_RD__SHIFT 0x8
#define MC_ARB_RET_CREDITS2__NECKDOWN_CNTR_EN_WR_MASK 0x200
#define MC_ARB_RET_CREDITS2__NECKDOWN_CNTR_EN_WR__SHIFT 0x9
#define MC_ARB_RET_CREDITS2__ACP_RDRET_URG_MASK 0x400
#define MC_ARB_RET_CREDITS2__ACP_RDRET_URG__SHIFT 0xa
#define MC_ARB_RET_CREDITS2__HDP_RDRET_URG_MASK 0x800
#define MC_ARB_RET_CREDITS2__HDP_RDRET_URG__SHIFT 0xb
#define MC_ARB_RET_CREDITS2__NECKDOWN_CNTR_MONITOR_RD_MASK 0x1000
#define MC_ARB_RET_CREDITS2__NECKDOWN_CNTR_MONITOR_RD__SHIFT 0xc
#define MC_ARB_RET_CREDITS2__NECKDOWN_CNTR_MONITOR_WR_MASK 0x2000
#define MC_ARB_RET_CREDITS2__NECKDOWN_CNTR_MONITOR_WR__SHIFT 0xd
#define MC_ARB_RET_CREDITS2__DISABLE_DISP_RDY_RD_MASK 0x4000
#define MC_ARB_RET_CREDITS2__DISABLE_DISP_RDY_RD__SHIFT 0xe
#define MC_ARB_RET_CREDITS2__DISABLE_ACP_RDY_WR_MASK 0x8000
#define MC_ARB_RET_CREDITS2__DISABLE_ACP_RDY_WR__SHIFT 0xf
#define MC_ARB_RET_CREDITS2__RDRET_CREDIT_MED_MASK 0xff0000
#define MC_ARB_RET_CREDITS2__RDRET_CREDIT_MED__SHIFT 0x10
#define MC_ARB_FED_CNTL__MODE_MASK 0x3
#define MC_ARB_FED_CNTL__MODE__SHIFT 0x0
#define MC_ARB_FED_CNTL__WR_ERR_MASK 0xc
#define MC_ARB_FED_CNTL__WR_ERR__SHIFT 0x2
#define MC_ARB_FED_CNTL__KEEP_POISON_IN_PAGE_MASK 0x10
#define MC_ARB_FED_CNTL__KEEP_POISON_IN_PAGE__SHIFT 0x4
#define MC_ARB_FED_CNTL__RDRET_PARITY_NACK_MASK 0x20
#define MC_ARB_FED_CNTL__RDRET_PARITY_NACK__SHIFT 0x5
#define MC_ARB_FED_CNTL__USE_LEGACY_NACK_MASK 0x40
#define MC_ARB_FED_CNTL__USE_LEGACY_NACK__SHIFT 0x6
#define MC_ARB_FED_CNTL__DEBUG_RSV_MASK 0xffffff80
#define MC_ARB_FED_CNTL__DEBUG_RSV__SHIFT 0x7
#define MC_ARB_GECC2_STATUS__CORR_STS0_MASK 0x1
#define MC_ARB_GECC2_STATUS__CORR_STS0__SHIFT 0x0
#define MC_ARB_GECC2_STATUS__UNCORR_STS0_MASK 0x2
#define MC_ARB_GECC2_STATUS__UNCORR_STS0__SHIFT 0x1
#define MC_ARB_GECC2_STATUS__FED_STS0_MASK 0x4
#define MC_ARB_GECC2_STATUS__FED_STS0__SHIFT 0x2
#define MC_ARB_GECC2_STATUS__RSVD0_MASK 0x8
#define MC_ARB_GECC2_STATUS__RSVD0__SHIFT 0x3
#define MC_ARB_GECC2_STATUS__CORR_STS1_MASK 0x10
#define MC_ARB_GECC2_STATUS__CORR_STS1__SHIFT 0x4
#define MC_ARB_GECC2_STATUS__UNCORR_STS1_MASK 0x20
#define MC_ARB_GECC2_STATUS__UNCORR_STS1__SHIFT 0x5
#define MC_ARB_GECC2_STATUS__FED_STS1_MASK 0x40
#define MC_ARB_GECC2_STATUS__FED_STS1__SHIFT 0x6
#define MC_ARB_GECC2_STATUS__RSVD1_MASK 0x80
#define MC_ARB_GECC2_STATUS__RSVD1__SHIFT 0x7
#define MC_ARB_GECC2_STATUS__CORR_CLEAR0_MASK 0x100
#define MC_ARB_GECC2_STATUS__CORR_CLEAR0__SHIFT 0x8
#define MC_ARB_GECC2_STATUS__UNCORR_CLEAR0_MASK 0x200
#define MC_ARB_GECC2_STATUS__UNCORR_CLEAR0__SHIFT 0x9
#define MC_ARB_GECC2_STATUS__FED_CLEAR0_MASK 0x400
#define MC_ARB_GECC2_STATUS__FED_CLEAR0__SHIFT 0xa
#define MC_ARB_GECC2_STATUS__RSVD2_MASK 0x800
#define MC_ARB_GECC2_STATUS__RSVD2__SHIFT 0xb
#define MC_ARB_GECC2_STATUS__CORR_CLEAR1_MASK 0x1000
#define MC_ARB_GECC2_STATUS__CORR_CLEAR1__SHIFT 0xc
#define MC_ARB_GECC2_STATUS__UNCORR_CLEAR1_MASK 0x2000
#define MC_ARB_GECC2_STATUS__UNCORR_CLEAR1__SHIFT 0xd
#define MC_ARB_GECC2_STATUS__FED_CLEAR1_MASK 0x4000
#define MC_ARB_GECC2_STATUS__FED_CLEAR1__SHIFT 0xe
#define MC_ARB_GECC2_STATUS__RSVD3_MASK 0x8000
#define MC_ARB_GECC2_STATUS__RSVD3__SHIFT 0xf
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_STS0_MASK 0x10000
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_STS0__SHIFT 0x10
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_STS0_MASK 0x20000
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_STS0__SHIFT 0x11
#define MC_ARB_GECC2_STATUS__RSVD4_MASK 0xc0000
#define MC_ARB_GECC2_STATUS__RSVD4__SHIFT 0x12
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_STS1_MASK 0x100000
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_STS1__SHIFT 0x14
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_STS1_MASK 0x200000
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_STS1__SHIFT 0x15
#define MC_ARB_GECC2_STATUS__RSVD5_MASK 0xc00000
#define MC_ARB_GECC2_STATUS__RSVD5__SHIFT 0x16
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_CLEAR0_MASK 0x1000000
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_CLEAR0__SHIFT 0x18
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_CLEAR0_MASK 0x2000000
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_CLEAR0__SHIFT 0x19
#define MC_ARB_GECC2_STATUS__RSVD6_MASK 0xc000000
#define MC_ARB_GECC2_STATUS__RSVD6__SHIFT 0x1a
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_CLEAR1_MASK 0x10000000
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_CLEAR1__SHIFT 0x1c
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_CLEAR1_MASK 0x20000000
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_CLEAR1__SHIFT 0x1d
#define MC_ARB_GECC2_MISC__STREAK_BREAK_MASK 0xf
#define MC_ARB_GECC2_MISC__STREAK_BREAK__SHIFT 0x0
#define MC_ARB_GECC2_MISC__COL10_HACK_MASK 0x10
#define MC_ARB_GECC2_MISC__COL10_HACK__SHIFT 0x4
#define MC_ARB_GECC2_MISC__CWRD_IN_REPLAY_MASK 0x20
#define MC_ARB_GECC2_MISC__CWRD_IN_REPLAY__SHIFT 0x5
#define MC_ARB_GECC2_MISC__NO_EOB_ALL_WR_IN_REPLAY_MASK 0x40
#define MC_ARB_GECC2_MISC__NO_EOB_ALL_WR_IN_REPLAY__SHIFT 0x6
#define MC_ARB_GECC2_MISC__RMW_LM_WR_STALL_MASK 0x80
#define MC_ARB_GECC2_MISC__RMW_LM_WR_STALL__SHIFT 0x7
#define MC_ARB_GECC2_MISC__RMW_STALL_RELEASE_MASK 0x100
#define MC_ARB_GECC2_MISC__RMW_STALL_RELEASE__SHIFT 0x8
#define MC_ARB_GECC2_MISC__WR_EDC_MASK_REPLAY_MASK 0x200
#define MC_ARB_GECC2_MISC__WR_EDC_MASK_REPLAY__SHIFT 0x9
#define MC_ARB_GECC2_MISC__CWRD_REPLAY_AGAIN_MASK 0x400
#define MC_ARB_GECC2_MISC__CWRD_REPLAY_AGAIN__SHIFT 0xa
#define MC_ARB_GECC2_MISC__WRRDWR_REPLAY_AGAIN_MASK 0x800
#define MC_ARB_GECC2_MISC__WRRDWR_REPLAY_AGAIN__SHIFT 0xb
#define MC_ARB_GECC2_MISC__ALLOW_RMW_ERR_AFTER_REPLAY_MASK 0x1000
#define MC_ARB_GECC2_MISC__ALLOW_RMW_ERR_AFTER_REPLAY__SHIFT 0xc
#define MC_ARB_GECC2_MISC__DEBUG_RSV_MASK 0xffffe000
#define MC_ARB_GECC2_MISC__DEBUG_RSV__SHIFT 0xd
#define MC_ARB_GECC2_DEBUG__NUM_ERR_BITS_MASK 0x3
#define MC_ARB_GECC2_DEBUG__NUM_ERR_BITS__SHIFT 0x0
#define MC_ARB_GECC2_DEBUG__DIRECTION_MASK 0x4
#define MC_ARB_GECC2_DEBUG__DIRECTION__SHIFT 0x2
#define MC_ARB_GECC2_DEBUG__DATA_FIELD_MASK 0x18
#define MC_ARB_GECC2_DEBUG__DATA_FIELD__SHIFT 0x3
#define MC_ARB_GECC2_DEBUG__SW_INJECTION_MASK 0x20
#define MC_ARB_GECC2_DEBUG__SW_INJECTION__SHIFT 0x5
#define MC_ARB_GECC2_DEBUG2__PERIOD_MASK 0xff
#define MC_ARB_GECC2_DEBUG2__PERIOD__SHIFT 0x0
#define MC_ARB_GECC2_DEBUG2__ERR0_START_MASK 0xff00
#define MC_ARB_GECC2_DEBUG2__ERR0_START__SHIFT 0x8
#define MC_ARB_GECC2_DEBUG2__ERR1_START_MASK 0xff0000
#define MC_ARB_GECC2_DEBUG2__ERR1_START__SHIFT 0x10
#define MC_ARB_GECC2_DEBUG2__ERR2_START_MASK 0xff000000
#define MC_ARB_GECC2_DEBUG2__ERR2_START__SHIFT 0x18
#define MC_ARB_PERF_CID__CH0_MASK 0xff
#define MC_ARB_PERF_CID__CH0__SHIFT 0x0
#define MC_ARB_PERF_CID__CH1_MASK 0xff00
#define MC_ARB_PERF_CID__CH1__SHIFT 0x8
#define MC_ARB_PERF_CID__CH0_EN_MASK 0x10000
#define MC_ARB_PERF_CID__CH0_EN__SHIFT 0x10
#define MC_ARB_PERF_CID__CH1_EN_MASK 0x20000
#define MC_ARB_PERF_CID__CH1_EN__SHIFT 0x11
#define MC_ARB_SNOOP__TC_GRP_RD_MASK 0x7
#define MC_ARB_SNOOP__TC_GRP_RD__SHIFT 0x0
#define MC_ARB_SNOOP__TC_GRP_RD_EN_MASK 0x8
#define MC_ARB_SNOOP__TC_GRP_RD_EN__SHIFT 0x3
#define MC_ARB_SNOOP__TC_GRP_WR_MASK 0x70
#define MC_ARB_SNOOP__TC_GRP_WR__SHIFT 0x4
#define MC_ARB_SNOOP__TC_GRP_WR_EN_MASK 0x80
#define MC_ARB_SNOOP__TC_GRP_WR_EN__SHIFT 0x7
#define MC_ARB_SNOOP__SDMA_GRP_RD_MASK 0x700
#define MC_ARB_SNOOP__SDMA_GRP_RD__SHIFT 0x8
#define MC_ARB_SNOOP__SDMA_GRP_RD_EN_MASK 0x800
#define MC_ARB_SNOOP__SDMA_GRP_RD_EN__SHIFT 0xb
#define MC_ARB_SNOOP__SDMA_GRP_WR_MASK 0x7000
#define MC_ARB_SNOOP__SDMA_GRP_WR__SHIFT 0xc
#define MC_ARB_SNOOP__SDMA_GRP_WR_EN_MASK 0x8000
#define MC_ARB_SNOOP__SDMA_GRP_WR_EN__SHIFT 0xf
#define MC_ARB_SNOOP__OUTSTANDING_RD_MASK 0xff0000
#define MC_ARB_SNOOP__OUTSTANDING_RD__SHIFT 0x10
#define MC_ARB_SNOOP__OUTSTANDING_WR_MASK 0xff000000
#define MC_ARB_SNOOP__OUTSTANDING_WR__SHIFT 0x18
#define MC_ARB_GRUB__GRUB_WATERMARK_MASK 0xff
#define MC_ARB_GRUB__GRUB_WATERMARK__SHIFT 0x0
#define MC_ARB_GRUB__GRUB_WATERMARK_PRI_MASK 0xff00
#define MC_ARB_GRUB__GRUB_WATERMARK_PRI__SHIFT 0x8
#define MC_ARB_GRUB__GRUB_WATERMARK_MED_MASK 0xff0000
#define MC_ARB_GRUB__GRUB_WATERMARK_MED__SHIFT 0x10
#define MC_ARB_GRUB__REG_WR_EN_MASK 0x3000000
#define MC_ARB_GRUB__REG_WR_EN__SHIFT 0x18
#define MC_ARB_GRUB__REG_RD_SEL_MASK 0x4000000
#define MC_ARB_GRUB__REG_RD_SEL__SHIFT 0x1a
#define MC_ARB_GECC2__ENABLE_MASK 0x1
#define MC_ARB_GECC2__ENABLE__SHIFT 0x0
#define MC_ARB_GECC2__ECC_MODE_MASK 0x6
#define MC_ARB_GECC2__ECC_MODE__SHIFT 0x1
#define MC_ARB_GECC2__PAGE_BIT0_MASK 0x18
#define MC_ARB_GECC2__PAGE_BIT0__SHIFT 0x3
#define MC_ARB_GECC2__EXOR_BANK_SEL_MASK 0x60
#define MC_ARB_GECC2__EXOR_BANK_SEL__SHIFT 0x5
#define MC_ARB_GECC2__NO_GECC_CLI_MASK 0x780
#define MC_ARB_GECC2__NO_GECC_CLI__SHIFT 0x7
#define MC_ARB_GECC2__READ_ERR_MASK 0x3800
#define MC_ARB_GECC2__READ_ERR__SHIFT 0xb
#define MC_ARB_GECC2__CLOSE_BANK_RMW_MASK 0x4000
#define MC_ARB_GECC2__CLOSE_BANK_RMW__SHIFT 0xe
#define MC_ARB_GECC2__COLFIFO_WATER_MASK 0x1f8000
#define MC_ARB_GECC2__COLFIFO_WATER__SHIFT 0xf
#define MC_ARB_GECC2__WRADDR_CONV_MASK 0x200000
#define MC_ARB_GECC2__WRADDR_CONV__SHIFT 0x15
#define MC_ARB_GECC2__RMWRD_UNCOR_POISON_MASK 0x400000
#define MC_ARB_GECC2__RMWRD_UNCOR_POISON__SHIFT 0x16
#define MC_ARB_GECC2_CLI__NO_GECC_CLI0_MASK 0xff
#define MC_ARB_GECC2_CLI__NO_GECC_CLI0__SHIFT 0x0
#define MC_ARB_GECC2_CLI__NO_GECC_CLI1_MASK 0xff00
#define MC_ARB_GECC2_CLI__NO_GECC_CLI1__SHIFT 0x8
#define MC_ARB_GECC2_CLI__NO_GECC_CLI2_MASK 0xff0000
#define MC_ARB_GECC2_CLI__NO_GECC_CLI2__SHIFT 0x10
#define MC_ARB_GECC2_CLI__NO_GECC_CLI3_MASK 0xff000000
#define MC_ARB_GECC2_CLI__NO_GECC_CLI3__SHIFT 0x18
#define MC_ARB_ADDR_SWIZ0__A8_MASK 0xf
#define MC_ARB_ADDR_SWIZ0__A8__SHIFT 0x0
#define MC_ARB_ADDR_SWIZ0__A9_MASK 0xf0
#define MC_ARB_ADDR_SWIZ0__A9__SHIFT 0x4
#define MC_ARB_ADDR_SWIZ0__A10_MASK 0xf00
#define MC_ARB_ADDR_SWIZ0__A10__SHIFT 0x8
#define MC_ARB_ADDR_SWIZ0__A11_MASK 0xf000
#define MC_ARB_ADDR_SWIZ0__A11__SHIFT 0xc
#define MC_ARB_ADDR_SWIZ0__A12_MASK 0xf0000
#define MC_ARB_ADDR_SWIZ0__A12__SHIFT 0x10
#define MC_ARB_ADDR_SWIZ0__A13_MASK 0xf00000
#define MC_ARB_ADDR_SWIZ0__A13__SHIFT 0x14
#define MC_ARB_ADDR_SWIZ0__A14_MASK 0xf000000
#define MC_ARB_ADDR_SWIZ0__A14__SHIFT 0x18
#define MC_ARB_ADDR_SWIZ0__A15_MASK 0xf0000000
#define MC_ARB_ADDR_SWIZ0__A15__SHIFT 0x1c
#define MC_ARB_ADDR_SWIZ1__A16_MASK 0xf
#define MC_ARB_ADDR_SWIZ1__A16__SHIFT 0x0
#define MC_ARB_ADDR_SWIZ1__A17_MASK 0xf0
#define MC_ARB_ADDR_SWIZ1__A17__SHIFT 0x4
#define MC_ARB_ADDR_SWIZ1__A18_MASK 0xf00
#define MC_ARB_ADDR_SWIZ1__A18__SHIFT 0x8
#define MC_ARB_ADDR_SWIZ1__A19_MASK 0xf000
#define MC_ARB_ADDR_SWIZ1__A19__SHIFT 0xc
#define MC_ARB_MISC3__NO_GECC_EXT_EOB_MASK 0x1
#define MC_ARB_MISC3__NO_GECC_EXT_EOB__SHIFT 0x0
#define MC_ARB_MISC3__CHAN4_EN_MASK 0x2
#define MC_ARB_MISC3__CHAN4_EN__SHIFT 0x1
#define MC_ARB_MISC3__CHAN4_ARB_SEL_MASK 0x4
#define MC_ARB_MISC3__CHAN4_ARB_SEL__SHIFT 0x2
#define MC_ARB_MISC3__UVD_URG_MODE_MASK 0x8
#define MC_ARB_MISC3__UVD_URG_MODE__SHIFT 0x3
#define MC_ARB_MISC3__UVD_DMIF_HARSH_WT_EN_MASK 0x10
#define MC_ARB_MISC3__UVD_DMIF_HARSH_WT_EN__SHIFT 0x4
#define MC_ARB_MISC3__TBD_FIELD_MASK 0xffffffe0
#define MC_ARB_MISC3__TBD_FIELD__SHIFT 0x5
#define MC_ARB_GRUB_PROMOTE__URGENT_RD_MASK 0xff
#define MC_ARB_GRUB_PROMOTE__URGENT_RD__SHIFT 0x0
#define MC_ARB_GRUB_PROMOTE__URGENT_WR_MASK 0xff00
#define MC_ARB_GRUB_PROMOTE__URGENT_WR__SHIFT 0x8
#define MC_ARB_GRUB_PROMOTE__PROMOTE_RD_MASK 0xff0000
#define MC_ARB_GRUB_PROMOTE__PROMOTE_RD__SHIFT 0x10
#define MC_ARB_GRUB_PROMOTE__PROMOTE_WR_MASK 0xff000000
#define MC_ARB_GRUB_PROMOTE__PROMOTE_WR__SHIFT 0x18
#define MC_ARB_RTT_DATA__PATTERN_MASK 0xff
#define MC_ARB_RTT_DATA__PATTERN__SHIFT 0x0
#define MC_ARB_RTT_CNTL0__ENABLE_MASK 0x1
#define MC_ARB_RTT_CNTL0__ENABLE__SHIFT 0x0
#define MC_ARB_RTT_CNTL0__START_IDLE_MASK 0x2
#define MC_ARB_RTT_CNTL0__START_IDLE__SHIFT 0x1
#define MC_ARB_RTT_CNTL0__START_R2W_MASK 0xc
#define MC_ARB_RTT_CNTL0__START_R2W__SHIFT 0x2
#define MC_ARB_RTT_CNTL0__FLUSH_ON_ENTER_MASK 0x10
#define MC_ARB_RTT_CNTL0__FLUSH_ON_ENTER__SHIFT 0x4
#define MC_ARB_RTT_CNTL0__HARSH_START_MASK 0x20
#define MC_ARB_RTT_CNTL0__HARSH_START__SHIFT 0x5
#define MC_ARB_RTT_CNTL0__TPS_HARSH_PRIORITY_MASK 0x40
#define MC_ARB_RTT_CNTL0__TPS_HARSH_PRIORITY__SHIFT 0x6
#define MC_ARB_RTT_CNTL0__TWRT_HARSH_PRIORITY_MASK 0x80
#define MC_ARB_RTT_CNTL0__TWRT_HARSH_PRIORITY__SHIFT 0x7
#define MC_ARB_RTT_CNTL0__BREAK_ON_HARSH_MASK 0x100
#define MC_ARB_RTT_CNTL0__BREAK_ON_HARSH__SHIFT 0x8
#define MC_ARB_RTT_CNTL0__BREAK_ON_URGENTRD_MASK 0x200
#define MC_ARB_RTT_CNTL0__BREAK_ON_URGENTRD__SHIFT 0x9
#define MC_ARB_RTT_CNTL0__BREAK_ON_URGENTWR_MASK 0x400
#define MC_ARB_RTT_CNTL0__BREAK_ON_URGENTWR__SHIFT 0xa
#define MC_ARB_RTT_CNTL0__TRAIN_PERIOD_MASK 0x3800
#define MC_ARB_RTT_CNTL0__TRAIN_PERIOD__SHIFT 0xb
#define MC_ARB_RTT_CNTL0__START_R2W_RFSH_MASK 0x4000
#define MC_ARB_RTT_CNTL0__START_R2W_RFSH__SHIFT 0xe
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_0_MASK 0x8000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_0__SHIFT 0xf
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_1_MASK 0x10000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_1__SHIFT 0x10
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_2_MASK 0x20000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_2__SHIFT 0x11
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_3_MASK 0x40000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_3__SHIFT 0x12
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_4_MASK 0x80000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_4__SHIFT 0x13
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_5_MASK 0x100000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_5__SHIFT 0x14
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_6_MASK 0x200000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_6__SHIFT 0x15
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_7_MASK 0x400000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_7__SHIFT 0x16
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_8_MASK 0x800000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_8__SHIFT 0x17
#define MC_ARB_RTT_CNTL0__DATA_CNTL_MASK 0x1000000
#define MC_ARB_RTT_CNTL0__DATA_CNTL__SHIFT 0x18
#define MC_ARB_RTT_CNTL0__NEIGHBOR_BIT_MASK 0x2000000
#define MC_ARB_RTT_CNTL0__NEIGHBOR_BIT__SHIFT 0x19
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MASK 0x1f
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE__SHIFT 0x0
#define MC_ARB_RTT_CNTL1__WINDOW_UPDATE_MASK 0x20
#define MC_ARB_RTT_CNTL1__WINDOW_UPDATE__SHIFT 0x5
#define MC_ARB_RTT_CNTL1__WINDOW_INC_THRESHOLD_MASK 0x1fc0
#define MC_ARB_RTT_CNTL1__WINDOW_INC_THRESHOLD__SHIFT 0x6
#define MC_ARB_RTT_CNTL1__WINDOW_DEC_THRESHOLD_MASK 0xfe000
#define MC_ARB_RTT_CNTL1__WINDOW_DEC_THRESHOLD__SHIFT 0xd
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MAX_MASK 0x1f00000
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MAX__SHIFT 0x14
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MIN_MASK 0x3e000000
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MIN__SHIFT 0x19
#define MC_ARB_RTT_CNTL1__WINDOW_UPDATE_COUNT_MASK 0xc0000000
#define MC_ARB_RTT_CNTL1__WINDOW_UPDATE_COUNT__SHIFT 0x1e
#define MC_ARB_RTT_CNTL2__SAMPLE_CNT_MASK 0x3f
#define MC_ARB_RTT_CNTL2__SAMPLE_CNT__SHIFT 0x0
#define MC_ARB_RTT_CNTL2__PHASE_ADJUST_THRESHOLD_MASK 0xfc0
#define MC_ARB_RTT_CNTL2__PHASE_ADJUST_THRESHOLD__SHIFT 0x6
#define MC_ARB_RTT_CNTL2__PHASE_ADJUST_SIZE_MASK 0x1000
#define MC_ARB_RTT_CNTL2__PHASE_ADJUST_SIZE__SHIFT 0xc
#define MC_ARB_RTT_CNTL2__FILTER_CNTL_MASK 0x2000
#define MC_ARB_RTT_CNTL2__FILTER_CNTL__SHIFT 0xd
#define MC_ARB_RTT_DEBUG__DEBUG_BYTE_CH0_MASK 0x3
#define MC_ARB_RTT_DEBUG__DEBUG_BYTE_CH0__SHIFT 0x0
#define MC_ARB_RTT_DEBUG__DEBUG_BYTE_CH1_MASK 0xc
#define MC_ARB_RTT_DEBUG__DEBUG_BYTE_CH1__SHIFT 0x2
#define MC_ARB_RTT_DEBUG__SHIFTED_PHASE_CH0_MASK 0xff0
#define MC_ARB_RTT_DEBUG__SHIFTED_PHASE_CH0__SHIFT 0x4
#define MC_ARB_RTT_DEBUG__WINDOW_SIZE_CH0_MASK 0x1f000
#define MC_ARB_RTT_DEBUG__WINDOW_SIZE_CH0__SHIFT 0xc
#define MC_ARB_RTT_DEBUG__SHIFTED_PHASE_CH1_MASK 0x1fe0000
#define MC_ARB_RTT_DEBUG__SHIFTED_PHASE_CH1__SHIFT 0x11
#define MC_ARB_RTT_DEBUG__WINDOW_SIZE_CH1_MASK 0x3e000000
#define MC_ARB_RTT_DEBUG__WINDOW_SIZE_CH1__SHIFT 0x19
#define MC_ARB_CAC_CNTL__ENABLE_MASK 0x1
#define MC_ARB_CAC_CNTL__ENABLE__SHIFT 0x0
#define MC_ARB_CAC_CNTL__READ_WEIGHT_MASK 0x7e
#define MC_ARB_CAC_CNTL__READ_WEIGHT__SHIFT 0x1
#define MC_ARB_CAC_CNTL__WRITE_WEIGHT_MASK 0x1f80
#define MC_ARB_CAC_CNTL__WRITE_WEIGHT__SHIFT 0x7
#define MC_ARB_CAC_CNTL__ALLOW_OVERFLOW_MASK 0x2000
#define MC_ARB_CAC_CNTL__ALLOW_OVERFLOW__SHIFT 0xd
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_ENABLE_MASK 0x20
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_ENABLE__SHIFT 0x5
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT4_MASK 0x40
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT4__SHIFT 0x6
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT5_MASK 0x80
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT5__SHIFT 0x7
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT6_MASK 0x100
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT6__SHIFT 0x8
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT7_MASK 0x200
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT7__SHIFT 0x9
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT8_MASK 0x400
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT8__SHIFT 0xa
#define MC_ARB_MISC2__POP_IDLE_REPLAY_MASK 0x800
#define MC_ARB_MISC2__POP_IDLE_REPLAY__SHIFT 0xb
#define MC_ARB_MISC2__RDRET_NO_REORDERING_MASK 0x1000
#define MC_ARB_MISC2__RDRET_NO_REORDERING__SHIFT 0xc
#define MC_ARB_MISC2__RDRET_NO_BP_MASK 0x2000
#define MC_ARB_MISC2__RDRET_NO_BP__SHIFT 0xd
#define MC_ARB_MISC2__RDRET_SEQ_SKID_MASK 0x3c000
#define MC_ARB_MISC2__RDRET_SEQ_SKID__SHIFT 0xe
#define MC_ARB_MISC2__GECC_MASK 0x40000
#define MC_ARB_MISC2__GECC__SHIFT 0x12
#define MC_ARB_MISC2__GECC_RST_MASK 0x80000
#define MC_ARB_MISC2__GECC_RST__SHIFT 0x13
#define MC_ARB_MISC2__GECC_STATUS_MASK 0x100000
#define MC_ARB_MISC2__GECC_STATUS__SHIFT 0x14
#define MC_ARB_MISC2__TAGFIFO_THRESHOLD_MASK 0x1e00000
#define MC_ARB_MISC2__TAGFIFO_THRESHOLD__SHIFT 0x15
#define MC_ARB_MISC2__WCDR_REPLAY_MASKCNT_MASK 0xe000000
#define MC_ARB_MISC2__WCDR_REPLAY_MASKCNT__SHIFT 0x19
#define MC_ARB_MISC2__REPLAY_DEBUG_MASK 0x10000000
#define MC_ARB_MISC2__REPLAY_DEBUG__SHIFT 0x1c
#define MC_ARB_MISC2__ARB_DEBUG29_MASK 0x20000000
#define MC_ARB_MISC2__ARB_DEBUG29__SHIFT 0x1d
#define MC_ARB_MISC2__SEQ_RDY_POP_IDLE_MASK 0x40000000
#define MC_ARB_MISC2__SEQ_RDY_POP_IDLE__SHIFT 0x1e
#define MC_ARB_MISC2__TCCDL4_REPLAY_EOB_MASK 0x80000000
#define MC_ARB_MISC2__TCCDL4_REPLAY_EOB__SHIFT 0x1f
#define MC_ARB_MISC__STICKY_RFSH_MASK 0x1
#define MC_ARB_MISC__STICKY_RFSH__SHIFT 0x0
#define MC_ARB_MISC__IDLE_RFSH_MASK 0x2
#define MC_ARB_MISC__IDLE_RFSH__SHIFT 0x1
#define MC_ARB_MISC__STUTTER_RFSH_MASK 0x4
#define MC_ARB_MISC__STUTTER_RFSH__SHIFT 0x2
#define MC_ARB_MISC__CHAN_COUPLE_MASK 0x7f8
#define MC_ARB_MISC__CHAN_COUPLE__SHIFT 0x3
#define MC_ARB_MISC__HARSHNESS_MASK 0x7f800
#define MC_ARB_MISC__HARSHNESS__SHIFT 0xb
#define MC_ARB_MISC__SMART_RDWR_SW_MASK 0x80000
#define MC_ARB_MISC__SMART_RDWR_SW__SHIFT 0x13
#define MC_ARB_MISC__CALI_ENABLE_MASK 0x100000
#define MC_ARB_MISC__CALI_ENABLE__SHIFT 0x14
#define MC_ARB_MISC__CALI_RATES_MASK 0x600000
#define MC_ARB_MISC__CALI_RATES__SHIFT 0x15
#define MC_ARB_MISC__DISPURGVLD_NOWRT_MASK 0x800000
#define MC_ARB_MISC__DISPURGVLD_NOWRT__SHIFT 0x17
#define MC_ARB_MISC__DISPURG_NOSW2WR_MASK 0x1000000
#define MC_ARB_MISC__DISPURG_NOSW2WR__SHIFT 0x18
#define MC_ARB_MISC__DISPURG_STALL_MASK 0x2000000
#define MC_ARB_MISC__DISPURG_STALL__SHIFT 0x19
#define MC_ARB_MISC__DISPURG_THROTTLE_MASK 0x3c000000
#define MC_ARB_MISC__DISPURG_THROTTLE__SHIFT 0x1a
#define MC_ARB_MISC__EXTEND_WEIGHT_MASK 0x40000000
#define MC_ARB_MISC__EXTEND_WEIGHT__SHIFT 0x1e
#define MC_ARB_MISC__ACPURG_STALL_MASK 0x80000000
#define MC_ARB_MISC__ACPURG_STALL__SHIFT 0x1f
#define MC_ARB_BANKMAP__BANK0_MASK 0xf
#define MC_ARB_BANKMAP__BANK0__SHIFT 0x0
#define MC_ARB_BANKMAP__BANK1_MASK 0xf0
#define MC_ARB_BANKMAP__BANK1__SHIFT 0x4
#define MC_ARB_BANKMAP__BANK2_MASK 0xf00
#define MC_ARB_BANKMAP__BANK2__SHIFT 0x8
#define MC_ARB_BANKMAP__BANK3_MASK 0xf000
#define MC_ARB_BANKMAP__BANK3__SHIFT 0xc
#define MC_ARB_BANKMAP__RANK_MASK 0xf0000
#define MC_ARB_BANKMAP__RANK__SHIFT 0x10
#define MC_ARB_RAMCFG__NOOFBANK_MASK 0x3
#define MC_ARB_RAMCFG__NOOFBANK__SHIFT 0x0
#define MC_ARB_RAMCFG__NOOFRANKS_MASK 0x4
#define MC_ARB_RAMCFG__NOOFRANKS__SHIFT 0x2
#define MC_ARB_RAMCFG__NOOFROWS_MASK 0x38
#define MC_ARB_RAMCFG__NOOFROWS__SHIFT 0x3
#define MC_ARB_RAMCFG__NOOFCOLS_MASK 0xc0
#define MC_ARB_RAMCFG__NOOFCOLS__SHIFT 0x6
#define MC_ARB_RAMCFG__CHANSIZE_MASK 0x100
#define MC_ARB_RAMCFG__CHANSIZE__SHIFT 0x8
#define MC_ARB_RAMCFG__RSV_1_MASK 0x200
#define MC_ARB_RAMCFG__RSV_1__SHIFT 0x9
#define MC_ARB_RAMCFG__RSV_2_MASK 0x400
#define MC_ARB_RAMCFG__RSV_2__SHIFT 0xa
#define MC_ARB_RAMCFG__RSV_3_MASK 0x800
#define MC_ARB_RAMCFG__RSV_3__SHIFT 0xb
#define MC_ARB_RAMCFG__NOOFGROUPS_MASK 0x1000
#define MC_ARB_RAMCFG__NOOFGROUPS__SHIFT 0xc
#define MC_ARB_RAMCFG__RSV_4_MASK 0x3e000
#define MC_ARB_RAMCFG__RSV_4__SHIFT 0xd
#define MC_ARB_POP__ENABLE_ARB_MASK 0x1
#define MC_ARB_POP__ENABLE_ARB__SHIFT 0x0
#define MC_ARB_POP__SPEC_OPEN_MASK 0x2
#define MC_ARB_POP__SPEC_OPEN__SHIFT 0x1
#define MC_ARB_POP__POP_DEPTH_MASK 0x3c
#define MC_ARB_POP__POP_DEPTH__SHIFT 0x2
#define MC_ARB_POP__WRDATAINDEX_DEPTH_MASK 0xfc0
#define MC_ARB_POP__WRDATAINDEX_DEPTH__SHIFT 0x6
#define MC_ARB_POP__SKID_DEPTH_MASK 0x7000
#define MC_ARB_POP__SKID_DEPTH__SHIFT 0xc
#define MC_ARB_POP__WAIT_AFTER_RFSH_MASK 0x18000
#define MC_ARB_POP__WAIT_AFTER_RFSH__SHIFT 0xf
#define MC_ARB_POP__QUICK_STOP_MASK 0x20000
#define MC_ARB_POP__QUICK_STOP__SHIFT 0x11
#define MC_ARB_POP__ENABLE_TWO_PAGE_MASK 0x40000
#define MC_ARB_POP__ENABLE_TWO_PAGE__SHIFT 0x12
#define MC_ARB_POP__ALLOW_EOB_BY_WRRET_STALL_MASK 0x80000
#define MC_ARB_POP__ALLOW_EOB_BY_WRRET_STALL__SHIFT 0x13
#define MC_ARB_MINCLKS__READ_CLKS_MASK 0xff
#define MC_ARB_MINCLKS__READ_CLKS__SHIFT 0x0
#define MC_ARB_MINCLKS__WRITE_CLKS_MASK 0xff00
#define MC_ARB_MINCLKS__WRITE_CLKS__SHIFT 0x8
#define MC_ARB_MINCLKS__ARB_RW_SWITCH_MASK 0x10000
#define MC_ARB_MINCLKS__ARB_RW_SWITCH__SHIFT 0x10
#define MC_ARB_MINCLKS__RW_SWITCH_HARSH_MASK 0x60000
#define MC_ARB_MINCLKS__RW_SWITCH_HARSH__SHIFT 0x11
#define MC_ARB_SQM_CNTL__MIN_PENAL_MASK 0xff
#define MC_ARB_SQM_CNTL__MIN_PENAL__SHIFT 0x0
#define MC_ARB_SQM_CNTL__DYN_SQM_ENABLE_MASK 0x100
#define MC_ARB_SQM_CNTL__DYN_SQM_ENABLE__SHIFT 0x8
#define MC_ARB_SQM_CNTL__SQM_RDY16_MASK 0x200
#define MC_ARB_SQM_CNTL__SQM_RDY16__SHIFT 0x9
#define MC_ARB_SQM_CNTL__SQM_RESERVE_MASK 0xfc00
#define MC_ARB_SQM_CNTL__SQM_RESERVE__SHIFT 0xa
#define MC_ARB_SQM_CNTL__RATIO_MASK 0xff0000
#define MC_ARB_SQM_CNTL__RATIO__SHIFT 0x10
#define MC_ARB_SQM_CNTL__RATIO_DEBUG_MASK 0xff000000
#define MC_ARB_SQM_CNTL__RATIO_DEBUG__SHIFT 0x18
#define MC_ARB_ADDR_HASH__BANK_XOR_ENABLE_MASK 0xf
#define MC_ARB_ADDR_HASH__BANK_XOR_ENABLE__SHIFT 0x0
#define MC_ARB_ADDR_HASH__COL_XOR_MASK 0xff0
#define MC_ARB_ADDR_HASH__COL_XOR__SHIFT 0x4
#define MC_ARB_ADDR_HASH__ROW_XOR_MASK 0xffff000
#define MC_ARB_ADDR_HASH__ROW_XOR__SHIFT 0xc
#define MC_ARB_DRAM_TIMING__ACTRD_MASK 0xff
#define MC_ARB_DRAM_TIMING__ACTRD__SHIFT 0x0
#define MC_ARB_DRAM_TIMING__ACTWR_MASK 0xff00
#define MC_ARB_DRAM_TIMING__ACTWR__SHIFT 0x8
#define MC_ARB_DRAM_TIMING__RASMACTRD_MASK 0xff0000
#define MC_ARB_DRAM_TIMING__RASMACTRD__SHIFT 0x10
#define MC_ARB_DRAM_TIMING__RASMACTWR_MASK 0xff000000
#define MC_ARB_DRAM_TIMING__RASMACTWR__SHIFT 0x18
#define MC_ARB_DRAM_TIMING2__RAS2RAS_MASK 0xff
#define MC_ARB_DRAM_TIMING2__RAS2RAS__SHIFT 0x0
#define MC_ARB_DRAM_TIMING2__RP_MASK 0xff00
#define MC_ARB_DRAM_TIMING2__RP__SHIFT 0x8
#define MC_ARB_DRAM_TIMING2__WRPLUSRP_MASK 0xff0000
#define MC_ARB_DRAM_TIMING2__WRPLUSRP__SHIFT 0x10
#define MC_ARB_DRAM_TIMING2__BUS_TURN_MASK 0x1f000000
#define MC_ARB_DRAM_TIMING2__BUS_TURN__SHIFT 0x18
#define MC_ARB_WTM_CNTL_RD__WTMODE_MASK 0x3
#define MC_ARB_WTM_CNTL_RD__WTMODE__SHIFT 0x0
#define MC_ARB_WTM_CNTL_RD__HARSH_PRI_MASK 0x4
#define MC_ARB_WTM_CNTL_RD__HARSH_PRI__SHIFT 0x2
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP0_MASK 0x8
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP0__SHIFT 0x3
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP1_MASK 0x10
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP1__SHIFT 0x4
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP2_MASK 0x20
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP2__SHIFT 0x5
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP3_MASK 0x40
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP3__SHIFT 0x6
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP4_MASK 0x80
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP4__SHIFT 0x7
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP5_MASK 0x100
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP5__SHIFT 0x8
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP6_MASK 0x200
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP6__SHIFT 0x9
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP7_MASK 0x400
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP7__SHIFT 0xa
#define MC_ARB_WTM_CNTL_RD__ACP_HARSH_PRI_MASK 0x800
#define MC_ARB_WTM_CNTL_RD__ACP_HARSH_PRI__SHIFT 0xb
#define MC_ARB_WTM_CNTL_RD__ACP_OVER_DISP_MASK 0x1000
#define MC_ARB_WTM_CNTL_RD__ACP_OVER_DISP__SHIFT 0xc
#define MC_ARB_WTM_CNTL_RD__FORCE_ACP_URG_MASK 0x2000
#define MC_ARB_WTM_CNTL_RD__FORCE_ACP_URG__SHIFT 0xd
#define MC_ARB_WTM_CNTL_WR__WTMODE_MASK 0x3
#define MC_ARB_WTM_CNTL_WR__WTMODE__SHIFT 0x0
#define MC_ARB_WTM_CNTL_WR__HARSH_PRI_MASK 0x4
#define MC_ARB_WTM_CNTL_WR__HARSH_PRI__SHIFT 0x2
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP0_MASK 0x8
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP0__SHIFT 0x3
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP1_MASK 0x10
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP1__SHIFT 0x4
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP2_MASK 0x20
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP2__SHIFT 0x5
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP3_MASK 0x40
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP3__SHIFT 0x6
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP4_MASK 0x80
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP4__SHIFT 0x7
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP5_MASK 0x100
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP5__SHIFT 0x8
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP6_MASK 0x200
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP6__SHIFT 0x9
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP7_MASK 0x400
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP7__SHIFT 0xa
#define MC_ARB_WTM_CNTL_WR__ACP_HARSH_PRI_MASK 0x800
#define MC_ARB_WTM_CNTL_WR__ACP_HARSH_PRI__SHIFT 0xb
#define MC_ARB_WTM_CNTL_WR__ACP_OVER_DISP_MASK 0x1000
#define MC_ARB_WTM_CNTL_WR__ACP_OVER_DISP__SHIFT 0xc
#define MC_ARB_WTM_CNTL_WR__FORCE_ACP_URG_MASK 0x2000
#define MC_ARB_WTM_CNTL_WR__FORCE_ACP_URG__SHIFT 0xd
#define MC_ARB_WTM_GRPWT_RD__GRP0_MASK 0x3
#define MC_ARB_WTM_GRPWT_RD__GRP0__SHIFT 0x0
#define MC_ARB_WTM_GRPWT_RD__GRP1_MASK 0xc
#define MC_ARB_WTM_GRPWT_RD__GRP1__SHIFT 0x2
#define MC_ARB_WTM_GRPWT_RD__GRP2_MASK 0x30
#define MC_ARB_WTM_GRPWT_RD__GRP2__SHIFT 0x4
#define MC_ARB_WTM_GRPWT_RD__GRP3_MASK 0xc0
#define MC_ARB_WTM_GRPWT_RD__GRP3__SHIFT 0x6
#define MC_ARB_WTM_GRPWT_RD__GRP4_MASK 0x300
#define MC_ARB_WTM_GRPWT_RD__GRP4__SHIFT 0x8
#define MC_ARB_WTM_GRPWT_RD__GRP5_MASK 0xc00
#define MC_ARB_WTM_GRPWT_RD__GRP5__SHIFT 0xa
#define MC_ARB_WTM_GRPWT_RD__GRP6_MASK 0x3000
#define MC_ARB_WTM_GRPWT_RD__GRP6__SHIFT 0xc
#define MC_ARB_WTM_GRPWT_RD__GRP7_MASK 0xc000
#define MC_ARB_WTM_GRPWT_RD__GRP7__SHIFT 0xe
#define MC_ARB_WTM_GRPWT_RD__GRP_EXT_MASK 0xff0000
#define MC_ARB_WTM_GRPWT_RD__GRP_EXT__SHIFT 0x10
#define MC_ARB_WTM_GRPWT_WR__GRP0_MASK 0x3
#define MC_ARB_WTM_GRPWT_WR__GRP0__SHIFT 0x0
#define MC_ARB_WTM_GRPWT_WR__GRP1_MASK 0xc
#define MC_ARB_WTM_GRPWT_WR__GRP1__SHIFT 0x2
#define MC_ARB_WTM_GRPWT_WR__GRP2_MASK 0x30
#define MC_ARB_WTM_GRPWT_WR__GRP2__SHIFT 0x4
#define MC_ARB_WTM_GRPWT_WR__GRP3_MASK 0xc0
#define MC_ARB_WTM_GRPWT_WR__GRP3__SHIFT 0x6
#define MC_ARB_WTM_GRPWT_WR__GRP4_MASK 0x300
#define MC_ARB_WTM_GRPWT_WR__GRP4__SHIFT 0x8
#define MC_ARB_WTM_GRPWT_WR__GRP5_MASK 0xc00
#define MC_ARB_WTM_GRPWT_WR__GRP5__SHIFT 0xa
#define MC_ARB_WTM_GRPWT_WR__GRP6_MASK 0x3000
#define MC_ARB_WTM_GRPWT_WR__GRP6__SHIFT 0xc
#define MC_ARB_WTM_GRPWT_WR__GRP7_MASK 0xc000
#define MC_ARB_WTM_GRPWT_WR__GRP7__SHIFT 0xe
#define MC_ARB_WTM_GRPWT_WR__GRP_EXT_MASK 0xff0000
#define MC_ARB_WTM_GRPWT_WR__GRP_EXT__SHIFT 0x10
#define MC_ARB_TM_CNTL_RD__GROUPBY_RANK_MASK 0x1
#define MC_ARB_TM_CNTL_RD__GROUPBY_RANK__SHIFT 0x0
#define MC_ARB_TM_CNTL_RD__BANK_SELECT_MASK 0x6
#define MC_ARB_TM_CNTL_RD__BANK_SELECT__SHIFT 0x1
#define MC_ARB_TM_CNTL_RD__MATCH_RANK_MASK 0x8
#define MC_ARB_TM_CNTL_RD__MATCH_RANK__SHIFT 0x3
#define MC_ARB_TM_CNTL_RD__MATCH_BANK_MASK 0x10
#define MC_ARB_TM_CNTL_RD__MATCH_BANK__SHIFT 0x4
#define MC_ARB_TM_CNTL_WR__GROUPBY_RANK_MASK 0x1
#define MC_ARB_TM_CNTL_WR__GROUPBY_RANK__SHIFT 0x0
#define MC_ARB_TM_CNTL_WR__BANK_SELECT_MASK 0x6
#define MC_ARB_TM_CNTL_WR__BANK_SELECT__SHIFT 0x1
#define MC_ARB_TM_CNTL_WR__MATCH_RANK_MASK 0x8
#define MC_ARB_TM_CNTL_WR__MATCH_RANK__SHIFT 0x3
#define MC_ARB_TM_CNTL_WR__MATCH_BANK_MASK 0x10
#define MC_ARB_TM_CNTL_WR__MATCH_BANK__SHIFT 0x4
#define MC_ARB_LAZY0_RD__GROUP0_MASK 0xff
#define MC_ARB_LAZY0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_LAZY0_RD__GROUP1_MASK 0xff00
#define MC_ARB_LAZY0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_LAZY0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_LAZY0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_LAZY0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_LAZY0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_LAZY0_WR__GROUP0_MASK 0xff
#define MC_ARB_LAZY0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_LAZY0_WR__GROUP1_MASK 0xff00
#define MC_ARB_LAZY0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_LAZY0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_LAZY0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_LAZY0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_LAZY0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_LAZY1_RD__GROUP4_MASK 0xff
#define MC_ARB_LAZY1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_LAZY1_RD__GROUP5_MASK 0xff00
#define MC_ARB_LAZY1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_LAZY1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_LAZY1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_LAZY1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_LAZY1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_LAZY1_WR__GROUP4_MASK 0xff
#define MC_ARB_LAZY1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_LAZY1_WR__GROUP5_MASK 0xff00
#define MC_ARB_LAZY1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_LAZY1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_LAZY1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_LAZY1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_LAZY1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_AGE_RD__RATE_GROUP0_MASK 0x3
#define MC_ARB_AGE_RD__RATE_GROUP0__SHIFT 0x0
#define MC_ARB_AGE_RD__RATE_GROUP1_MASK 0xc
#define MC_ARB_AGE_RD__RATE_GROUP1__SHIFT 0x2
#define MC_ARB_AGE_RD__RATE_GROUP2_MASK 0x30
#define MC_ARB_AGE_RD__RATE_GROUP2__SHIFT 0x4
#define MC_ARB_AGE_RD__RATE_GROUP3_MASK 0xc0
#define MC_ARB_AGE_RD__RATE_GROUP3__SHIFT 0x6
#define MC_ARB_AGE_RD__RATE_GROUP4_MASK 0x300
#define MC_ARB_AGE_RD__RATE_GROUP4__SHIFT 0x8
#define MC_ARB_AGE_RD__RATE_GROUP5_MASK 0xc00
#define MC_ARB_AGE_RD__RATE_GROUP5__SHIFT 0xa
#define MC_ARB_AGE_RD__RATE_GROUP6_MASK 0x3000
#define MC_ARB_AGE_RD__RATE_GROUP6__SHIFT 0xc
#define MC_ARB_AGE_RD__RATE_GROUP7_MASK 0xc000
#define MC_ARB_AGE_RD__RATE_GROUP7__SHIFT 0xe
#define MC_ARB_AGE_RD__ENABLE_GROUP0_MASK 0x10000
#define MC_ARB_AGE_RD__ENABLE_GROUP0__SHIFT 0x10
#define MC_ARB_AGE_RD__ENABLE_GROUP1_MASK 0x20000
#define MC_ARB_AGE_RD__ENABLE_GROUP1__SHIFT 0x11
#define MC_ARB_AGE_RD__ENABLE_GROUP2_MASK 0x40000
#define MC_ARB_AGE_RD__ENABLE_GROUP2__SHIFT 0x12
#define MC_ARB_AGE_RD__ENABLE_GROUP3_MASK 0x80000
#define MC_ARB_AGE_RD__ENABLE_GROUP3__SHIFT 0x13
#define MC_ARB_AGE_RD__ENABLE_GROUP4_MASK 0x100000
#define MC_ARB_AGE_RD__ENABLE_GROUP4__SHIFT 0x14
#define MC_ARB_AGE_RD__ENABLE_GROUP5_MASK 0x200000
#define MC_ARB_AGE_RD__ENABLE_GROUP5__SHIFT 0x15
#define MC_ARB_AGE_RD__ENABLE_GROUP6_MASK 0x400000
#define MC_ARB_AGE_RD__ENABLE_GROUP6__SHIFT 0x16
#define MC_ARB_AGE_RD__ENABLE_GROUP7_MASK 0x800000
#define MC_ARB_AGE_RD__ENABLE_GROUP7__SHIFT 0x17
#define MC_ARB_AGE_RD__DIVIDE_GROUP0_MASK 0x1000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP0__SHIFT 0x18
#define MC_ARB_AGE_RD__DIVIDE_GROUP1_MASK 0x2000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP1__SHIFT 0x19
#define MC_ARB_AGE_RD__DIVIDE_GROUP2_MASK 0x4000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP2__SHIFT 0x1a
#define MC_ARB_AGE_RD__DIVIDE_GROUP3_MASK 0x8000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP3__SHIFT 0x1b
#define MC_ARB_AGE_RD__DIVIDE_GROUP4_MASK 0x10000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP4__SHIFT 0x1c
#define MC_ARB_AGE_RD__DIVIDE_GROUP5_MASK 0x20000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP5__SHIFT 0x1d
#define MC_ARB_AGE_RD__DIVIDE_GROUP6_MASK 0x40000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP6__SHIFT 0x1e
#define MC_ARB_AGE_RD__DIVIDE_GROUP7_MASK 0x80000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP7__SHIFT 0x1f
#define MC_ARB_AGE_WR__RATE_GROUP0_MASK 0x3
#define MC_ARB_AGE_WR__RATE_GROUP0__SHIFT 0x0
#define MC_ARB_AGE_WR__RATE_GROUP1_MASK 0xc
#define MC_ARB_AGE_WR__RATE_GROUP1__SHIFT 0x2
#define MC_ARB_AGE_WR__RATE_GROUP2_MASK 0x30
#define MC_ARB_AGE_WR__RATE_GROUP2__SHIFT 0x4
#define MC_ARB_AGE_WR__RATE_GROUP3_MASK 0xc0
#define MC_ARB_AGE_WR__RATE_GROUP3__SHIFT 0x6
#define MC_ARB_AGE_WR__RATE_GROUP4_MASK 0x300
#define MC_ARB_AGE_WR__RATE_GROUP4__SHIFT 0x8
#define MC_ARB_AGE_WR__RATE_GROUP5_MASK 0xc00
#define MC_ARB_AGE_WR__RATE_GROUP5__SHIFT 0xa
#define MC_ARB_AGE_WR__RATE_GROUP6_MASK 0x3000
#define MC_ARB_AGE_WR__RATE_GROUP6__SHIFT 0xc
#define MC_ARB_AGE_WR__RATE_GROUP7_MASK 0xc000
#define MC_ARB_AGE_WR__RATE_GROUP7__SHIFT 0xe
#define MC_ARB_AGE_WR__ENABLE_GROUP0_MASK 0x10000
#define MC_ARB_AGE_WR__ENABLE_GROUP0__SHIFT 0x10
#define MC_ARB_AGE_WR__ENABLE_GROUP1_MASK 0x20000
#define MC_ARB_AGE_WR__ENABLE_GROUP1__SHIFT 0x11
#define MC_ARB_AGE_WR__ENABLE_GROUP2_MASK 0x40000
#define MC_ARB_AGE_WR__ENABLE_GROUP2__SHIFT 0x12
#define MC_ARB_AGE_WR__ENABLE_GROUP3_MASK 0x80000
#define MC_ARB_AGE_WR__ENABLE_GROUP3__SHIFT 0x13
#define MC_ARB_AGE_WR__ENABLE_GROUP4_MASK 0x100000
#define MC_ARB_AGE_WR__ENABLE_GROUP4__SHIFT 0x14
#define MC_ARB_AGE_WR__ENABLE_GROUP5_MASK 0x200000
#define MC_ARB_AGE_WR__ENABLE_GROUP5__SHIFT 0x15
#define MC_ARB_AGE_WR__ENABLE_GROUP6_MASK 0x400000
#define MC_ARB_AGE_WR__ENABLE_GROUP6__SHIFT 0x16
#define MC_ARB_AGE_WR__ENABLE_GROUP7_MASK 0x800000
#define MC_ARB_AGE_WR__ENABLE_GROUP7__SHIFT 0x17
#define MC_ARB_AGE_WR__DIVIDE_GROUP0_MASK 0x1000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP0__SHIFT 0x18
#define MC_ARB_AGE_WR__DIVIDE_GROUP1_MASK 0x2000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP1__SHIFT 0x19
#define MC_ARB_AGE_WR__DIVIDE_GROUP2_MASK 0x4000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP2__SHIFT 0x1a
#define MC_ARB_AGE_WR__DIVIDE_GROUP3_MASK 0x8000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP3__SHIFT 0x1b
#define MC_ARB_AGE_WR__DIVIDE_GROUP4_MASK 0x10000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP4__SHIFT 0x1c
#define MC_ARB_AGE_WR__DIVIDE_GROUP5_MASK 0x20000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP5__SHIFT 0x1d
#define MC_ARB_AGE_WR__DIVIDE_GROUP6_MASK 0x40000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP6__SHIFT 0x1e
#define MC_ARB_AGE_WR__DIVIDE_GROUP7_MASK 0x80000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP7__SHIFT 0x1f
#define MC_ARB_RFSH_CNTL__ENABLE_MASK 0x1
#define MC_ARB_RFSH_CNTL__ENABLE__SHIFT 0x0
#define MC_ARB_RFSH_CNTL__URG0_MASK 0x3e
#define MC_ARB_RFSH_CNTL__URG0__SHIFT 0x1
#define MC_ARB_RFSH_CNTL__URG1_MASK 0x7c0
#define MC_ARB_RFSH_CNTL__URG1__SHIFT 0x6
#define MC_ARB_RFSH_CNTL__ACCUM_MASK 0x800
#define MC_ARB_RFSH_CNTL__ACCUM__SHIFT 0xb
#define MC_ARB_RFSH_CNTL__SINGLE_BANK_MASK 0x1000
#define MC_ARB_RFSH_CNTL__SINGLE_BANK__SHIFT 0xc
#define MC_ARB_RFSH_CNTL__PUSH_SINGLE_BANK_REFRESH_MASK 0x2000
#define MC_ARB_RFSH_CNTL__PUSH_SINGLE_BANK_REFRESH__SHIFT 0xd
#define MC_ARB_RFSH_CNTL__PENDING_RATE_SEL_MASK 0x1c000
#define MC_ARB_RFSH_CNTL__PENDING_RATE_SEL__SHIFT 0xe
#define MC_ARB_RFSH_CNTL__REFSB_PER_PAGE_MASK 0x20000
#define MC_ARB_RFSH_CNTL__REFSB_PER_PAGE__SHIFT 0x11
#define MC_ARB_RFSH_RATE__POWERMODE0_MASK 0xff
#define MC_ARB_RFSH_RATE__POWERMODE0__SHIFT 0x0
#define MC_ARB_PM_CNTL__OVERRIDE_CGSTATE_MASK 0x3
#define MC_ARB_PM_CNTL__OVERRIDE_CGSTATE__SHIFT 0x0
#define MC_ARB_PM_CNTL__OVRR_CGRFSH_MASK 0x4
#define MC_ARB_PM_CNTL__OVRR_CGRFSH__SHIFT 0x2
#define MC_ARB_PM_CNTL__OVRR_CGSQM_MASK 0x8
#define MC_ARB_PM_CNTL__OVRR_CGSQM__SHIFT 0x3
#define MC_ARB_PM_CNTL__SRFSH_ON_D1_MASK 0x10
#define MC_ARB_PM_CNTL__SRFSH_ON_D1__SHIFT 0x4
#define MC_ARB_PM_CNTL__BLKOUT_ON_D1_MASK 0x20
#define MC_ARB_PM_CNTL__BLKOUT_ON_D1__SHIFT 0x5
#define MC_ARB_PM_CNTL__IDLE_ON_D1_MASK 0x40
#define MC_ARB_PM_CNTL__IDLE_ON_D1__SHIFT 0x6
#define MC_ARB_PM_CNTL__OVRR_PM_MASK 0x80
#define MC_ARB_PM_CNTL__OVRR_PM__SHIFT 0x7
#define MC_ARB_PM_CNTL__OVRR_PM_STATE_MASK 0x300
#define MC_ARB_PM_CNTL__OVRR_PM_STATE__SHIFT 0x8
#define MC_ARB_PM_CNTL__OVRR_RD_MASK 0x400
#define MC_ARB_PM_CNTL__OVRR_RD__SHIFT 0xa
#define MC_ARB_PM_CNTL__OVRR_RD_STATE_MASK 0x800
#define MC_ARB_PM_CNTL__OVRR_RD_STATE__SHIFT 0xb
#define MC_ARB_PM_CNTL__OVRR_WR_MASK 0x1000
#define MC_ARB_PM_CNTL__OVRR_WR__SHIFT 0xc
#define MC_ARB_PM_CNTL__OVRR_WR_STATE_MASK 0x2000
#define MC_ARB_PM_CNTL__OVRR_WR_STATE__SHIFT 0xd
#define MC_ARB_PM_CNTL__OVRR_RFSH_MASK 0x4000
#define MC_ARB_PM_CNTL__OVRR_RFSH__SHIFT 0xe
#define MC_ARB_PM_CNTL__OVRR_RFSH_STATE_MASK 0x8000
#define MC_ARB_PM_CNTL__OVRR_RFSH_STATE__SHIFT 0xf
#define MC_ARB_PM_CNTL__OVRR_RD0_BUSY_MASK 0x10000
#define MC_ARB_PM_CNTL__OVRR_RD0_BUSY__SHIFT 0x10
#define MC_ARB_PM_CNTL__OVRR_RD1_BUSY_MASK 0x20000
#define MC_ARB_PM_CNTL__OVRR_RD1_BUSY__SHIFT 0x11
#define MC_ARB_PM_CNTL__IDLE_ON_D2_MASK 0x40000
#define MC_ARB_PM_CNTL__IDLE_ON_D2__SHIFT 0x12
#define MC_ARB_PM_CNTL__IDLE_ON_D3_MASK 0x80000
#define MC_ARB_PM_CNTL__IDLE_ON_D3__SHIFT 0x13
#define MC_ARB_PM_CNTL__IDLE_CNT_MASK 0xf00000
#define MC_ARB_PM_CNTL__IDLE_CNT__SHIFT 0x14
#define MC_ARB_PM_CNTL__OVRR_WR0_BUSY_MASK 0x1000000
#define MC_ARB_PM_CNTL__OVRR_WR0_BUSY__SHIFT 0x18
#define MC_ARB_PM_CNTL__OVRR_WR1_BUSY_MASK 0x2000000
#define MC_ARB_PM_CNTL__OVRR_WR1_BUSY__SHIFT 0x19
#define MC_ARB_GDEC_RD_CNTL__PAGEBIT0_MASK 0xf
#define MC_ARB_GDEC_RD_CNTL__PAGEBIT0__SHIFT 0x0
#define MC_ARB_GDEC_RD_CNTL__PAGEBIT1_MASK 0xf0
#define MC_ARB_GDEC_RD_CNTL__PAGEBIT1__SHIFT 0x4
#define MC_ARB_GDEC_RD_CNTL__USE_RANK_MASK 0x100
#define MC_ARB_GDEC_RD_CNTL__USE_RANK__SHIFT 0x8
#define MC_ARB_GDEC_RD_CNTL__USE_RSNO_MASK 0x200
#define MC_ARB_GDEC_RD_CNTL__USE_RSNO__SHIFT 0x9
#define MC_ARB_GDEC_RD_CNTL__REM_DEFAULT_GRP_MASK 0x3c00
#define MC_ARB_GDEC_RD_CNTL__REM_DEFAULT_GRP__SHIFT 0xa
#define MC_ARB_GDEC_WR_CNTL__PAGEBIT0_MASK 0xf
#define MC_ARB_GDEC_WR_CNTL__PAGEBIT0__SHIFT 0x0
#define MC_ARB_GDEC_WR_CNTL__PAGEBIT1_MASK 0xf0
#define MC_ARB_GDEC_WR_CNTL__PAGEBIT1__SHIFT 0x4
#define MC_ARB_GDEC_WR_CNTL__USE_RANK_MASK 0x100
#define MC_ARB_GDEC_WR_CNTL__USE_RANK__SHIFT 0x8
#define MC_ARB_GDEC_WR_CNTL__USE_RSNO_MASK 0x200
#define MC_ARB_GDEC_WR_CNTL__USE_RSNO__SHIFT 0x9
#define MC_ARB_GDEC_WR_CNTL__REM_DEFAULT_GRP_MASK 0x3c00
#define MC_ARB_GDEC_WR_CNTL__REM_DEFAULT_GRP__SHIFT 0xa
#define MC_ARB_LM_RD__STREAK_LIMIT_MASK 0xff
#define MC_ARB_LM_RD__STREAK_LIMIT__SHIFT 0x0
#define MC_ARB_LM_RD__STREAK_LIMIT_UBER_MASK 0xff00
#define MC_ARB_LM_RD__STREAK_LIMIT_UBER__SHIFT 0x8
#define MC_ARB_LM_RD__STREAK_BREAK_MASK 0x10000
#define MC_ARB_LM_RD__STREAK_BREAK__SHIFT 0x10
#define MC_ARB_LM_RD__STREAK_UBER_MASK 0x20000
#define MC_ARB_LM_RD__STREAK_UBER__SHIFT 0x11
#define MC_ARB_LM_RD__ENABLE_TWO_LIST_MASK 0x40000
#define MC_ARB_LM_RD__ENABLE_TWO_LIST__SHIFT 0x12
#define MC_ARB_LM_RD__POPIDLE_RST_TWOLIST_MASK 0x80000
#define MC_ARB_LM_RD__POPIDLE_RST_TWOLIST__SHIFT 0x13
#define MC_ARB_LM_RD__SKID1_RST_TWOLIST_MASK 0x100000
#define MC_ARB_LM_RD__SKID1_RST_TWOLIST__SHIFT 0x14
#define MC_ARB_LM_RD__BANKGROUP_CONFIG_MASK 0xe00000
#define MC_ARB_LM_RD__BANKGROUP_CONFIG__SHIFT 0x15
#define MC_ARB_LM_WR__STREAK_LIMIT_MASK 0xff
#define MC_ARB_LM_WR__STREAK_LIMIT__SHIFT 0x0
#define MC_ARB_LM_WR__STREAK_LIMIT_UBER_MASK 0xff00
#define MC_ARB_LM_WR__STREAK_LIMIT_UBER__SHIFT 0x8
#define MC_ARB_LM_WR__STREAK_BREAK_MASK 0x10000
#define MC_ARB_LM_WR__STREAK_BREAK__SHIFT 0x10
#define MC_ARB_LM_WR__STREAK_UBER_MASK 0x20000
#define MC_ARB_LM_WR__STREAK_UBER__SHIFT 0x11
#define MC_ARB_LM_WR__ENABLE_TWO_LIST_MASK 0x40000
#define MC_ARB_LM_WR__ENABLE_TWO_LIST__SHIFT 0x12
#define MC_ARB_LM_WR__POPIDLE_RST_TWOLIST_MASK 0x80000
#define MC_ARB_LM_WR__POPIDLE_RST_TWOLIST__SHIFT 0x13
#define MC_ARB_LM_WR__SKID1_RST_TWOLIST_MASK 0x100000
#define MC_ARB_LM_WR__SKID1_RST_TWOLIST__SHIFT 0x14
#define MC_ARB_LM_WR__BANKGROUP_CONFIG_MASK 0xe00000
#define MC_ARB_LM_WR__BANKGROUP_CONFIG__SHIFT 0x15
#define MC_ARB_LM_WR__MASKWR_LM_EOB_MASK 0x1000000
#define MC_ARB_LM_WR__MASKWR_LM_EOB__SHIFT 0x18
#define MC_ARB_LM_WR__ATOMIC_LM_EOB_MASK 0x2000000
#define MC_ARB_LM_WR__ATOMIC_LM_EOB__SHIFT 0x19
#define MC_ARB_LM_WR__ATOMIC_RTN_LM_EOB_MASK 0x4000000
#define MC_ARB_LM_WR__ATOMIC_RTN_LM_EOB__SHIFT 0x1a
#define MC_ARB_REMREQ__RD_WATER_MASK 0xff
#define MC_ARB_REMREQ__RD_WATER__SHIFT 0x0
#define MC_ARB_REMREQ__WR_WATER_MASK 0xff00
#define MC_ARB_REMREQ__WR_WATER__SHIFT 0x8
#define MC_ARB_REMREQ__WR_MAXBURST_SIZE_MASK 0xf0000
#define MC_ARB_REMREQ__WR_MAXBURST_SIZE__SHIFT 0x10
#define MC_ARB_REMREQ__WR_LAZY_TIMER_MASK 0xf00000
#define MC_ARB_REMREQ__WR_LAZY_TIMER__SHIFT 0x14
#define MC_ARB_REMREQ__ENABLE_REMOTE_NACK_REQ_MASK 0x1000000
#define MC_ARB_REMREQ__ENABLE_REMOTE_NACK_REQ__SHIFT 0x18
#define MC_ARB_REPLAY__ENABLE_RD_MASK 0x1
#define MC_ARB_REPLAY__ENABLE_RD__SHIFT 0x0
#define MC_ARB_REPLAY__ENABLE_WR_MASK 0x2
#define MC_ARB_REPLAY__ENABLE_WR__SHIFT 0x1
#define MC_ARB_REPLAY__WRACK_MODE_MASK 0x4
#define MC_ARB_REPLAY__WRACK_MODE__SHIFT 0x2
#define MC_ARB_REPLAY__WAW_ENABLE_MASK 0x8
#define MC_ARB_REPLAY__WAW_ENABLE__SHIFT 0x3
#define MC_ARB_REPLAY__RAW_ENABLE_MASK 0x10
#define MC_ARB_REPLAY__RAW_ENABLE__SHIFT 0x4
#define MC_ARB_REPLAY__IGNORE_WR_CDC_MASK 0x20
#define MC_ARB_REPLAY__IGNORE_WR_CDC__SHIFT 0x5
#define MC_ARB_REPLAY__BREAK_ON_STALL_MASK 0x40
#define MC_ARB_REPLAY__BREAK_ON_STALL__SHIFT 0x6
#define MC_ARB_REPLAY__BOS_ENABLE_WAIT_CYC_MASK 0x80
#define MC_ARB_REPLAY__BOS_ENABLE_WAIT_CYC__SHIFT 0x7
#define MC_ARB_REPLAY__BOS_WAIT_CYC_MASK 0x7f00
#define MC_ARB_REPLAY__BOS_WAIT_CYC__SHIFT 0x8
#define MC_ARB_REPLAY__NO_PCH_AT_REPLAY_START_MASK 0x8000
#define MC_ARB_REPLAY__NO_PCH_AT_REPLAY_START__SHIFT 0xf
#define MC_ARB_RET_CREDITS_RD__LCL_MASK 0xff
#define MC_ARB_RET_CREDITS_RD__LCL__SHIFT 0x0
#define MC_ARB_RET_CREDITS_RD__HUB_MASK 0xff00
#define MC_ARB_RET_CREDITS_RD__HUB__SHIFT 0x8
#define MC_ARB_RET_CREDITS_RD__DISP_MASK 0xff0000
#define MC_ARB_RET_CREDITS_RD__DISP__SHIFT 0x10
#define MC_ARB_RET_CREDITS_RD__RETURN_CREDIT_MASK 0xff000000
#define MC_ARB_RET_CREDITS_RD__RETURN_CREDIT__SHIFT 0x18
#define MC_ARB_RET_CREDITS_WR__LCL_MASK 0xff
#define MC_ARB_RET_CREDITS_WR__LCL__SHIFT 0x0
#define MC_ARB_RET_CREDITS_WR__HUB_MASK 0xff00
#define MC_ARB_RET_CREDITS_WR__HUB__SHIFT 0x8
#define MC_ARB_RET_CREDITS_WR__RETURN_CREDIT_MASK 0xff0000
#define MC_ARB_RET_CREDITS_WR__RETURN_CREDIT__SHIFT 0x10
#define MC_ARB_RET_CREDITS_WR__WRRET_SEQ_SKID_MASK 0xf000000
#define MC_ARB_RET_CREDITS_WR__WRRET_SEQ_SKID__SHIFT 0x18
#define MC_ARB_RET_CREDITS_WR__WRRET_BP_MASK 0x10000000
#define MC_ARB_RET_CREDITS_WR__WRRET_BP__SHIFT 0x1c
#define MC_ARB_MAX_LAT_CID__CID_CH0_MASK 0xff
#define MC_ARB_MAX_LAT_CID__CID_CH0__SHIFT 0x0
#define MC_ARB_MAX_LAT_CID__CID_CH1_MASK 0xff00
#define MC_ARB_MAX_LAT_CID__CID_CH1__SHIFT 0x8
#define MC_ARB_MAX_LAT_CID__WRITE_CH0_MASK 0x10000
#define MC_ARB_MAX_LAT_CID__WRITE_CH0__SHIFT 0x10
#define MC_ARB_MAX_LAT_CID__WRITE_CH1_MASK 0x20000
#define MC_ARB_MAX_LAT_CID__WRITE_CH1__SHIFT 0x11
#define MC_ARB_MAX_LAT_CID__REALTIME_CH0_MASK 0x40000
#define MC_ARB_MAX_LAT_CID__REALTIME_CH0__SHIFT 0x12
#define MC_ARB_MAX_LAT_CID__REALTIME_CH1_MASK 0x80000
#define MC_ARB_MAX_LAT_CID__REALTIME_CH1__SHIFT 0x13
#define MC_ARB_MAX_LAT_RSLT0__MAX_LATENCY_MASK 0xffffffff
#define MC_ARB_MAX_LAT_RSLT0__MAX_LATENCY__SHIFT 0x0
#define MC_ARB_MAX_LAT_RSLT1__MAX_LATENCY_MASK 0xffffffff
#define MC_ARB_MAX_LAT_RSLT1__MAX_LATENCY__SHIFT 0x0
#define MC_ARB_GRUB_REALTIME_RD__CB0_MASK 0x1
#define MC_ARB_GRUB_REALTIME_RD__CB0__SHIFT 0x0
#define MC_ARB_GRUB_REALTIME_RD__CBCMASK0_MASK 0x2
#define MC_ARB_GRUB_REALTIME_RD__CBCMASK0__SHIFT 0x1
#define MC_ARB_GRUB_REALTIME_RD__CBFMASK0_MASK 0x4
#define MC_ARB_GRUB_REALTIME_RD__CBFMASK0__SHIFT 0x2
#define MC_ARB_GRUB_REALTIME_RD__DB0_MASK 0x8
#define MC_ARB_GRUB_REALTIME_RD__DB0__SHIFT 0x3
#define MC_ARB_GRUB_REALTIME_RD__DBHTILE0_MASK 0x10
#define MC_ARB_GRUB_REALTIME_RD__DBHTILE0__SHIFT 0x4
#define MC_ARB_GRUB_REALTIME_RD__DBSTEN0_MASK 0x20
#define MC_ARB_GRUB_REALTIME_RD__DBSTEN0__SHIFT 0x5
#define MC_ARB_GRUB_REALTIME_RD__TC0_MASK 0x40
#define MC_ARB_GRUB_REALTIME_RD__TC0__SHIFT 0x6
#define MC_ARB_GRUB_REALTIME_RD__IA_MASK 0x80
#define MC_ARB_GRUB_REALTIME_RD__IA__SHIFT 0x7
#define MC_ARB_GRUB_REALTIME_RD__ACPG_MASK 0x100
#define MC_ARB_GRUB_REALTIME_RD__ACPG__SHIFT 0x8
#define MC_ARB_GRUB_REALTIME_RD__ACPO_MASK 0x200
#define MC_ARB_GRUB_REALTIME_RD__ACPO__SHIFT 0x9
#define MC_ARB_GRUB_REALTIME_RD__DMIF_MASK 0x400
#define MC_ARB_GRUB_REALTIME_RD__DMIF__SHIFT 0xa
#define MC_ARB_GRUB_REALTIME_RD__DMIF_EXT0_MASK 0x800
#define MC_ARB_GRUB_REALTIME_RD__DMIF_EXT0__SHIFT 0xb
#define MC_ARB_GRUB_REALTIME_RD__DMIF_EXT1_MASK 0x1000
#define MC_ARB_GRUB_REALTIME_RD__DMIF_EXT1__SHIFT 0xc
#define MC_ARB_GRUB_REALTIME_RD__DMIF_TW_MASK 0x2000
#define MC_ARB_GRUB_REALTIME_RD__DMIF_TW__SHIFT 0xd
#define MC_ARB_GRUB_REALTIME_RD__MCIF_MASK 0x4000
#define MC_ARB_GRUB_REALTIME_RD__MCIF__SHIFT 0xe
#define MC_ARB_GRUB_REALTIME_RD__RLC_MASK 0x8000
#define MC_ARB_GRUB_REALTIME_RD__RLC__SHIFT 0xf
#define MC_ARB_GRUB_REALTIME_RD__VMC_MASK 0x10000
#define MC_ARB_GRUB_REALTIME_RD__VMC__SHIFT 0x10
#define MC_ARB_GRUB_REALTIME_RD__SDMA1_MASK 0x20000
#define MC_ARB_GRUB_REALTIME_RD__SDMA1__SHIFT 0x11
#define MC_ARB_GRUB_REALTIME_RD__SMU_MASK 0x40000
#define MC_ARB_GRUB_REALTIME_RD__SMU__SHIFT 0x12
#define MC_ARB_GRUB_REALTIME_RD__VCE0_MASK 0x80000
#define MC_ARB_GRUB_REALTIME_RD__VCE0__SHIFT 0x13
#define MC_ARB_GRUB_REALTIME_RD__VCE1_MASK 0x100000
#define MC_ARB_GRUB_REALTIME_RD__VCE1__SHIFT 0x14
#define MC_ARB_GRUB_REALTIME_RD__XDMAM_MASK 0x200000
#define MC_ARB_GRUB_REALTIME_RD__XDMAM__SHIFT 0x15
#define MC_ARB_GRUB_REALTIME_RD__SDMA0_MASK 0x400000
#define MC_ARB_GRUB_REALTIME_RD__SDMA0__SHIFT 0x16
#define MC_ARB_GRUB_REALTIME_RD__HDP_MASK 0x800000
#define MC_ARB_GRUB_REALTIME_RD__HDP__SHIFT 0x17
#define MC_ARB_GRUB_REALTIME_RD__UMC_MASK 0x1000000
#define MC_ARB_GRUB_REALTIME_RD__UMC__SHIFT 0x18
#define MC_ARB_GRUB_REALTIME_RD__UVD_MASK 0x2000000
#define MC_ARB_GRUB_REALTIME_RD__UVD__SHIFT 0x19
#define MC_ARB_GRUB_REALTIME_RD__UVD_EXT0_MASK 0x4000000
#define MC_ARB_GRUB_REALTIME_RD__UVD_EXT0__SHIFT 0x1a
#define MC_ARB_GRUB_REALTIME_RD__UVD_EXT1_MASK 0x8000000
#define MC_ARB_GRUB_REALTIME_RD__UVD_EXT1__SHIFT 0x1b
#define MC_ARB_GRUB_REALTIME_RD__SEM_MASK 0x10000000
#define MC_ARB_GRUB_REALTIME_RD__SEM__SHIFT 0x1c
#define MC_ARB_GRUB_REALTIME_RD__SAMMSP_MASK 0x20000000
#define MC_ARB_GRUB_REALTIME_RD__SAMMSP__SHIFT 0x1d
#define MC_ARB_GRUB_REALTIME_RD__VP8_MASK 0x40000000
#define MC_ARB_GRUB_REALTIME_RD__VP8__SHIFT 0x1e
#define MC_ARB_GRUB_REALTIME_RD__ISP_MASK 0x80000000
#define MC_ARB_GRUB_REALTIME_RD__ISP__SHIFT 0x1f
#define MC_ARB_CG__CG_ARB_REQ_MASK 0xff
#define MC_ARB_CG__CG_ARB_REQ__SHIFT 0x0
#define MC_ARB_CG__CG_ARB_RESP_MASK 0xff00
#define MC_ARB_CG__CG_ARB_RESP__SHIFT 0x8
#define MC_ARB_CG__RSV_0_MASK 0xff0000
#define MC_ARB_CG__RSV_0__SHIFT 0x10
#define MC_ARB_CG__RSV_1_MASK 0xff000000
#define MC_ARB_CG__RSV_1__SHIFT 0x18
#define MC_ARB_GRUB_REALTIME_WR__CB0_MASK 0x1
#define MC_ARB_GRUB_REALTIME_WR__CB0__SHIFT 0x0
#define MC_ARB_GRUB_REALTIME_WR__CBCMASK0_MASK 0x2
#define MC_ARB_GRUB_REALTIME_WR__CBCMASK0__SHIFT 0x1
#define MC_ARB_GRUB_REALTIME_WR__CBFMASK0_MASK 0x4
#define MC_ARB_GRUB_REALTIME_WR__CBFMASK0__SHIFT 0x2
#define MC_ARB_GRUB_REALTIME_WR__CBIMMED0_MASK 0x8
#define MC_ARB_GRUB_REALTIME_WR__CBIMMED0__SHIFT 0x3
#define MC_ARB_GRUB_REALTIME_WR__DB0_MASK 0x10
#define MC_ARB_GRUB_REALTIME_WR__DB0__SHIFT 0x4
#define MC_ARB_GRUB_REALTIME_WR__DBHTILE0_MASK 0x20
#define MC_ARB_GRUB_REALTIME_WR__DBHTILE0__SHIFT 0x5
#define MC_ARB_GRUB_REALTIME_WR__DBSTEN0_MASK 0x40
#define MC_ARB_GRUB_REALTIME_WR__DBSTEN0__SHIFT 0x6
#define MC_ARB_GRUB_REALTIME_WR__TC0_MASK 0x80
#define MC_ARB_GRUB_REALTIME_WR__TC0__SHIFT 0x7
#define MC_ARB_GRUB_REALTIME_WR__SH_MASK 0x100
#define MC_ARB_GRUB_REALTIME_WR__SH__SHIFT 0x8
#define MC_ARB_GRUB_REALTIME_WR__ACPG_MASK 0x200
#define MC_ARB_GRUB_REALTIME_WR__ACPG__SHIFT 0x9
#define MC_ARB_GRUB_REALTIME_WR__ACPO_MASK 0x400
#define MC_ARB_GRUB_REALTIME_WR__ACPO__SHIFT 0xa
#define MC_ARB_GRUB_REALTIME_WR__MCIF_MASK 0x800
#define MC_ARB_GRUB_REALTIME_WR__MCIF__SHIFT 0xb
#define MC_ARB_GRUB_REALTIME_WR__RLC_MASK 0x1000
#define MC_ARB_GRUB_REALTIME_WR__RLC__SHIFT 0xc
#define MC_ARB_GRUB_REALTIME_WR__SDMA1_MASK 0x2000
#define MC_ARB_GRUB_REALTIME_WR__SDMA1__SHIFT 0xd
#define MC_ARB_GRUB_REALTIME_WR__SMU_MASK 0x4000
#define MC_ARB_GRUB_REALTIME_WR__SMU__SHIFT 0xe
#define MC_ARB_GRUB_REALTIME_WR__VCE0_MASK 0x8000
#define MC_ARB_GRUB_REALTIME_WR__VCE0__SHIFT 0xf
#define MC_ARB_GRUB_REALTIME_WR__VCE1_MASK 0x10000
#define MC_ARB_GRUB_REALTIME_WR__VCE1__SHIFT 0x10
#define MC_ARB_GRUB_REALTIME_WR__SAMMSP_MASK 0x20000
#define MC_ARB_GRUB_REALTIME_WR__SAMMSP__SHIFT 0x11
#define MC_ARB_GRUB_REALTIME_WR__XDMA_MASK 0x40000
#define MC_ARB_GRUB_REALTIME_WR__XDMA__SHIFT 0x12
#define MC_ARB_GRUB_REALTIME_WR__XDMAM_MASK 0x80000
#define MC_ARB_GRUB_REALTIME_WR__XDMAM__SHIFT 0x13
#define MC_ARB_GRUB_REALTIME_WR__SDMA0_MASK 0x100000
#define MC_ARB_GRUB_REALTIME_WR__SDMA0__SHIFT 0x14
#define MC_ARB_GRUB_REALTIME_WR__HDP_MASK 0x200000
#define MC_ARB_GRUB_REALTIME_WR__HDP__SHIFT 0x15
#define MC_ARB_GRUB_REALTIME_WR__UMC_MASK 0x400000
#define MC_ARB_GRUB_REALTIME_WR__UMC__SHIFT 0x16
#define MC_ARB_GRUB_REALTIME_WR__UVD_MASK 0x800000
#define MC_ARB_GRUB_REALTIME_WR__UVD__SHIFT 0x17
#define MC_ARB_GRUB_REALTIME_WR__UVD_EXT0_MASK 0x1000000
#define MC_ARB_GRUB_REALTIME_WR__UVD_EXT0__SHIFT 0x18
#define MC_ARB_GRUB_REALTIME_WR__UVD_EXT1_MASK 0x2000000
#define MC_ARB_GRUB_REALTIME_WR__UVD_EXT1__SHIFT 0x19
#define MC_ARB_GRUB_REALTIME_WR__XDP_MASK 0x4000000
#define MC_ARB_GRUB_REALTIME_WR__XDP__SHIFT 0x1a
#define MC_ARB_GRUB_REALTIME_WR__SEM_MASK 0x8000000
#define MC_ARB_GRUB_REALTIME_WR__SEM__SHIFT 0x1b
#define MC_ARB_GRUB_REALTIME_WR__IH_MASK 0x10000000
#define MC_ARB_GRUB_REALTIME_WR__IH__SHIFT 0x1c
#define MC_ARB_GRUB_REALTIME_WR__VP8_MASK 0x20000000
#define MC_ARB_GRUB_REALTIME_WR__VP8__SHIFT 0x1d
#define MC_ARB_GRUB_REALTIME_WR__ISP_MASK 0x40000000
#define MC_ARB_GRUB_REALTIME_WR__ISP__SHIFT 0x1e
#define MC_ARB_GRUB_REALTIME_WR__VIN0_MASK 0x80000000
#define MC_ARB_GRUB_REALTIME_WR__VIN0__SHIFT 0x1f
#define MC_ARB_DRAM_TIMING_1__ACTRD_MASK 0xff
#define MC_ARB_DRAM_TIMING_1__ACTRD__SHIFT 0x0
#define MC_ARB_DRAM_TIMING_1__ACTWR_MASK 0xff00
#define MC_ARB_DRAM_TIMING_1__ACTWR__SHIFT 0x8
#define MC_ARB_DRAM_TIMING_1__RASMACTRD_MASK 0xff0000
#define MC_ARB_DRAM_TIMING_1__RASMACTRD__SHIFT 0x10
#define MC_ARB_DRAM_TIMING_1__RASMACTWR_MASK 0xff000000
#define MC_ARB_DRAM_TIMING_1__RASMACTWR__SHIFT 0x18
#define MC_ARB_BUSY_STATUS__LM_RD0_MASK 0x1
#define MC_ARB_BUSY_STATUS__LM_RD0__SHIFT 0x0
#define MC_ARB_BUSY_STATUS__LM_RD1_MASK 0x2
#define MC_ARB_BUSY_STATUS__LM_RD1__SHIFT 0x1
#define MC_ARB_BUSY_STATUS__LM_WR0_MASK 0x4
#define MC_ARB_BUSY_STATUS__LM_WR0__SHIFT 0x2
#define MC_ARB_BUSY_STATUS__LM_WR1_MASK 0x8
#define MC_ARB_BUSY_STATUS__LM_WR1__SHIFT 0x3
#define MC_ARB_BUSY_STATUS__HM_RD0_MASK 0x10
#define MC_ARB_BUSY_STATUS__HM_RD0__SHIFT 0x4
#define MC_ARB_BUSY_STATUS__HM_RD1_MASK 0x20
#define MC_ARB_BUSY_STATUS__HM_RD1__SHIFT 0x5
#define MC_ARB_BUSY_STATUS__HM_WR0_MASK 0x40
#define MC_ARB_BUSY_STATUS__HM_WR0__SHIFT 0x6
#define MC_ARB_BUSY_STATUS__HM_WR1_MASK 0x80
#define MC_ARB_BUSY_STATUS__HM_WR1__SHIFT 0x7
#define MC_ARB_BUSY_STATUS__WDE_RD0_MASK 0x100
#define MC_ARB_BUSY_STATUS__WDE_RD0__SHIFT 0x8
#define MC_ARB_BUSY_STATUS__WDE_RD1_MASK 0x200
#define MC_ARB_BUSY_STATUS__WDE_RD1__SHIFT 0x9
#define MC_ARB_BUSY_STATUS__WDE_WR0_MASK 0x400
#define MC_ARB_BUSY_STATUS__WDE_WR0__SHIFT 0xa
#define MC_ARB_BUSY_STATUS__WDE_WR1_MASK 0x800
#define MC_ARB_BUSY_STATUS__WDE_WR1__SHIFT 0xb
#define MC_ARB_BUSY_STATUS__POP0_MASK 0x1000
#define MC_ARB_BUSY_STATUS__POP0__SHIFT 0xc
#define MC_ARB_BUSY_STATUS__POP1_MASK 0x2000
#define MC_ARB_BUSY_STATUS__POP1__SHIFT 0xd
#define MC_ARB_BUSY_STATUS__TAGFIFO0_MASK 0x4000
#define MC_ARB_BUSY_STATUS__TAGFIFO0__SHIFT 0xe
#define MC_ARB_BUSY_STATUS__TAGFIFO1_MASK 0x8000
#define MC_ARB_BUSY_STATUS__TAGFIFO1__SHIFT 0xf
#define MC_ARB_BUSY_STATUS__REPLAY0_MASK 0x10000
#define MC_ARB_BUSY_STATUS__REPLAY0__SHIFT 0x10
#define MC_ARB_BUSY_STATUS__REPLAY1_MASK 0x20000
#define MC_ARB_BUSY_STATUS__REPLAY1__SHIFT 0x11
#define MC_ARB_BUSY_STATUS__RDRET0_MASK 0x40000
#define MC_ARB_BUSY_STATUS__RDRET0__SHIFT 0x12
#define MC_ARB_BUSY_STATUS__RDRET1_MASK 0x80000
#define MC_ARB_BUSY_STATUS__RDRET1__SHIFT 0x13
#define MC_ARB_BUSY_STATUS__GECC2_RD0_MASK 0x100000
#define MC_ARB_BUSY_STATUS__GECC2_RD0__SHIFT 0x14
#define MC_ARB_BUSY_STATUS__GECC2_RD1_MASK 0x200000
#define MC_ARB_BUSY_STATUS__GECC2_RD1__SHIFT 0x15
#define MC_ARB_BUSY_STATUS__GECC2_WR0_MASK 0x400000
#define MC_ARB_BUSY_STATUS__GECC2_WR0__SHIFT 0x16
#define MC_ARB_BUSY_STATUS__GECC2_WR1_MASK 0x800000
#define MC_ARB_BUSY_STATUS__GECC2_WR1__SHIFT 0x17
#define MC_ARB_BUSY_STATUS__WRRET0_MASK 0x1000000
#define MC_ARB_BUSY_STATUS__WRRET0__SHIFT 0x18
#define MC_ARB_BUSY_STATUS__WRRET1_MASK 0x2000000
#define MC_ARB_BUSY_STATUS__WRRET1__SHIFT 0x19
#define MC_ARB_BUSY_STATUS__RTT0_MASK 0x4000000
#define MC_ARB_BUSY_STATUS__RTT0__SHIFT 0x1a
#define MC_ARB_BUSY_STATUS__RTT1_MASK 0x8000000
#define MC_ARB_BUSY_STATUS__RTT1__SHIFT 0x1b
#define MC_ARB_BUSY_STATUS__REM_RD0_MASK 0x10000000
#define MC_ARB_BUSY_STATUS__REM_RD0__SHIFT 0x1c
#define MC_ARB_BUSY_STATUS__REM_RD1_MASK 0x20000000
#define MC_ARB_BUSY_STATUS__REM_RD1__SHIFT 0x1d
#define MC_ARB_BUSY_STATUS__REM_WR0_MASK 0x40000000
#define MC_ARB_BUSY_STATUS__REM_WR0__SHIFT 0x1e
#define MC_ARB_BUSY_STATUS__REM_WR1_MASK 0x80000000
#define MC_ARB_BUSY_STATUS__REM_WR1__SHIFT 0x1f
#define MC_ARB_DRAM_TIMING2_1__RAS2RAS_MASK 0xff
#define MC_ARB_DRAM_TIMING2_1__RAS2RAS__SHIFT 0x0
#define MC_ARB_DRAM_TIMING2_1__RP_MASK 0xff00
#define MC_ARB_DRAM_TIMING2_1__RP__SHIFT 0x8
#define MC_ARB_DRAM_TIMING2_1__WRPLUSRP_MASK 0xff0000
#define MC_ARB_DRAM_TIMING2_1__WRPLUSRP__SHIFT 0x10
#define MC_ARB_DRAM_TIMING2_1__BUS_TURN_MASK 0x1f000000
#define MC_ARB_DRAM_TIMING2_1__BUS_TURN__SHIFT 0x18
#define MC_ARB_GRUB2__REALTIME_GRP_RD_MASK 0xff
#define MC_ARB_GRUB2__REALTIME_GRP_RD__SHIFT 0x0
#define MC_ARB_GRUB2__REALTIME_GRP_WR_MASK 0xff00
#define MC_ARB_GRUB2__REALTIME_GRP_WR__SHIFT 0x8
#define MC_ARB_GRUB2__DISP_RD_STALL_EN_MASK 0x10000
#define MC_ARB_GRUB2__DISP_RD_STALL_EN__SHIFT 0x10
#define MC_ARB_GRUB2__ACP_RD_STALL_EN_MASK 0x20000
#define MC_ARB_GRUB2__ACP_RD_STALL_EN__SHIFT 0x11
#define MC_ARB_GRUB2__UVD_RD_STALL_EN_MASK 0x40000
#define MC_ARB_GRUB2__UVD_RD_STALL_EN__SHIFT 0x12
#define MC_ARB_GRUB2__VCE0_RD_STALL_EN_MASK 0x80000
#define MC_ARB_GRUB2__VCE0_RD_STALL_EN__SHIFT 0x13
#define MC_ARB_GRUB2__VCE1_RD_STALL_EN_MASK 0x100000
#define MC_ARB_GRUB2__VCE1_RD_STALL_EN__SHIFT 0x14
#define MC_ARB_GRUB2__REALTIME_RD_WTS_MASK 0x200000
#define MC_ARB_GRUB2__REALTIME_RD_WTS__SHIFT 0x15
#define MC_ARB_GRUB2__REALTIME_WR_WTS_MASK 0x400000
#define MC_ARB_GRUB2__REALTIME_WR_WTS__SHIFT 0x16
#define MC_ARB_GRUB2__URGENT_BY_DISP_STALL_MASK 0x800000
#define MC_ARB_GRUB2__URGENT_BY_DISP_STALL__SHIFT 0x17
#define MC_ARB_GRUB2__PROMOTE_BY_DMIF_URG_MASK 0x1000000
#define MC_ARB_GRUB2__PROMOTE_BY_DMIF_URG__SHIFT 0x18
#define MC_ARB_GRUB2__PRIORITY_URGENT_OUTSTANDING_ONLY_RD_MASK 0x2000000
#define MC_ARB_GRUB2__PRIORITY_URGENT_OUTSTANDING_ONLY_RD__SHIFT 0x19
#define MC_ARB_GRUB2__PRIORITY_PROMOTE_OUTSTANDING_ONLY_RD_MASK 0x4000000
#define MC_ARB_GRUB2__PRIORITY_PROMOTE_OUTSTANDING_ONLY_RD__SHIFT 0x1a
#define MC_ARB_GRUB2__PRIORITY_URGENT_OUTSTANDING_ONLY_WR_MASK 0x8000000
#define MC_ARB_GRUB2__PRIORITY_URGENT_OUTSTANDING_ONLY_WR__SHIFT 0x1b
#define MC_ARB_GRUB2__PRIORITY_PROMOTE_OUTSTANDING_ONLY_WR_MASK 0x10000000
#define MC_ARB_GRUB2__PRIORITY_PROMOTE_OUTSTANDING_ONLY_WR__SHIFT 0x1c
#define MC_ARB_BURST_TIME__STATE0_MASK 0x1f
#define MC_ARB_BURST_TIME__STATE0__SHIFT 0x0
#define MC_ARB_BURST_TIME__STATE1_MASK 0x3e0
#define MC_ARB_BURST_TIME__STATE1__SHIFT 0x5
#define MC_ARB_BURST_TIME__TRRDS0_MASK 0x7c00
#define MC_ARB_BURST_TIME__TRRDS0__SHIFT 0xa
#define MC_ARB_BURST_TIME__TRRDS1_MASK 0xf8000
#define MC_ARB_BURST_TIME__TRRDS1__SHIFT 0xf
#define MC_ARB_BURST_TIME__TRRDL0_MASK 0x1f00000
#define MC_ARB_BURST_TIME__TRRDL0__SHIFT 0x14
#define MC_ARB_BURST_TIME__TRRDL1_MASK 0x3e000000
#define MC_ARB_BURST_TIME__TRRDL1__SHIFT 0x19
#define MC_CITF_XTRA_ENABLE__CB1_RD_MASK 0x1
#define MC_CITF_XTRA_ENABLE__CB1_RD__SHIFT 0x0
#define MC_CITF_XTRA_ENABLE__CB1_WR_MASK 0x2
#define MC_CITF_XTRA_ENABLE__CB1_WR__SHIFT 0x1
#define MC_CITF_XTRA_ENABLE__DB1_RD_MASK 0x4
#define MC_CITF_XTRA_ENABLE__DB1_RD__SHIFT 0x2
#define MC_CITF_XTRA_ENABLE__DB1_WR_MASK 0x8
#define MC_CITF_XTRA_ENABLE__DB1_WR__SHIFT 0x3
#define MC_CITF_XTRA_ENABLE__TC2_RD_MASK 0x10
#define MC_CITF_XTRA_ENABLE__TC2_RD__SHIFT 0x4
#define MC_CITF_XTRA_ENABLE__ARB_DBG_MASK 0xf00
#define MC_CITF_XTRA_ENABLE__ARB_DBG__SHIFT 0x8
#define MC_CITF_XTRA_ENABLE__TC2_WR_MASK 0x1000
#define MC_CITF_XTRA_ENABLE__TC2_WR__SHIFT 0xc
#define MC_CITF_XTRA_ENABLE__CB0_CONNECT_CNTL_MASK 0x6000
#define MC_CITF_XTRA_ENABLE__CB0_CONNECT_CNTL__SHIFT 0xd
#define MC_CITF_XTRA_ENABLE__DB0_CONNECT_CNTL_MASK 0x18000
#define MC_CITF_XTRA_ENABLE__DB0_CONNECT_CNTL__SHIFT 0xf
#define MC_CITF_XTRA_ENABLE__CB1_CONNECT_CNTL_MASK 0x60000
#define MC_CITF_XTRA_ENABLE__CB1_CONNECT_CNTL__SHIFT 0x11
#define MC_CITF_XTRA_ENABLE__DB1_CONNECT_CNTL_MASK 0x180000
#define MC_CITF_XTRA_ENABLE__DB1_CONNECT_CNTL__SHIFT 0x13
#define MC_CITF_XTRA_ENABLE__TC0_CONNECT_CNTL_MASK 0x600000
#define MC_CITF_XTRA_ENABLE__TC0_CONNECT_CNTL__SHIFT 0x15
#define MC_CITF_XTRA_ENABLE__TC1_CONNECT_CNTL_MASK 0x1800000
#define MC_CITF_XTRA_ENABLE__TC1_CONNECT_CNTL__SHIFT 0x17
#define MC_CITF_XTRA_ENABLE__CB0_CID_CNTL_ENABLE_MASK 0x2000000
#define MC_CITF_XTRA_ENABLE__CB0_CID_CNTL_ENABLE__SHIFT 0x19
#define MC_CITF_XTRA_ENABLE__DB0_CID_CNTL_ENABLE_MASK 0x4000000
#define MC_CITF_XTRA_ENABLE__DB0_CID_CNTL_ENABLE__SHIFT 0x1a
#define MC_CITF_XTRA_ENABLE__CB1_CID_CNTL_ENABLE_MASK 0x8000000
#define MC_CITF_XTRA_ENABLE__CB1_CID_CNTL_ENABLE__SHIFT 0x1b
#define MC_CITF_XTRA_ENABLE__DB1_CID_CNTL_ENABLE_MASK 0x10000000
#define MC_CITF_XTRA_ENABLE__DB1_CID_CNTL_ENABLE__SHIFT 0x1c
#define MC_CITF_XTRA_ENABLE__TC2_REPAIR_ENABLE_MASK 0x60000000
#define MC_CITF_XTRA_ENABLE__TC2_REPAIR_ENABLE__SHIFT 0x1d
#define CC_MC_MAX_CHANNEL__NOOFCHAN_MASK 0x1e
#define CC_MC_MAX_CHANNEL__NOOFCHAN__SHIFT 0x1
#define MC_CG_CONFIG__MCDW_WR_ENABLE_MASK 0x1
#define MC_CG_CONFIG__MCDW_WR_ENABLE__SHIFT 0x0
#define MC_CG_CONFIG__MCDX_WR_ENABLE_MASK 0x2
#define MC_CG_CONFIG__MCDX_WR_ENABLE__SHIFT 0x1
#define MC_CG_CONFIG__MCDY_WR_ENABLE_MASK 0x4
#define MC_CG_CONFIG__MCDY_WR_ENABLE__SHIFT 0x2
#define MC_CG_CONFIG__MCDZ_WR_ENABLE_MASK 0x8
#define MC_CG_CONFIG__MCDZ_WR_ENABLE__SHIFT 0x3
#define MC_CG_CONFIG__MC_RD_ENABLE_MASK 0x30
#define MC_CG_CONFIG__MC_RD_ENABLE__SHIFT 0x4
#define MC_CG_CONFIG__INDEX_MASK 0x3fffc0
#define MC_CG_CONFIG__INDEX__SHIFT 0x6
#define MC_CITF_CNTL__IGNOREPM_MASK 0x4
#define MC_CITF_CNTL__IGNOREPM__SHIFT 0x2
#define MC_CITF_CNTL__EXEMPTPM_MASK 0x8
#define MC_CITF_CNTL__EXEMPTPM__SHIFT 0x3
#define MC_CITF_CNTL__GFX_IDLE_OVERRIDE_MASK 0x30
#define MC_CITF_CNTL__GFX_IDLE_OVERRIDE__SHIFT 0x4
#define MC_CITF_CNTL__MCD_SRBM_MASK_ENABLE_MASK 0x40
#define MC_CITF_CNTL__MCD_SRBM_MASK_ENABLE__SHIFT 0x6
#define MC_CITF_CNTL__CNTR_CHMAP_MODE_MASK 0x180
#define MC_CITF_CNTL__CNTR_CHMAP_MODE__SHIFT 0x7
#define MC_CITF_CNTL__REMOTE_RB_CONNECT_ENABLE_MASK 0x200
#define MC_CITF_CNTL__REMOTE_RB_CONNECT_ENABLE__SHIFT 0x9
#define MC_CITF_CREDITS_VM__READ_ALL_MASK 0x3f
#define MC_CITF_CREDITS_VM__READ_ALL__SHIFT 0x0
#define MC_CITF_CREDITS_VM__WRITE_ALL_MASK 0xfc0
#define MC_CITF_CREDITS_VM__WRITE_ALL__SHIFT 0x6
#define MC_CITF_CREDITS_ARB_RD__READ_LCL_MASK 0xff
#define MC_CITF_CREDITS_ARB_RD__READ_LCL__SHIFT 0x0
#define MC_CITF_CREDITS_ARB_RD__READ_HUB_MASK 0xff00
#define MC_CITF_CREDITS_ARB_RD__READ_HUB__SHIFT 0x8
#define MC_CITF_CREDITS_ARB_RD__READ_PRI_MASK 0xff0000
#define MC_CITF_CREDITS_ARB_RD__READ_PRI__SHIFT 0x10
#define MC_CITF_CREDITS_ARB_RD__LCL_PRI_MASK 0x1000000
#define MC_CITF_CREDITS_ARB_RD__LCL_PRI__SHIFT 0x18
#define MC_CITF_CREDITS_ARB_RD__HUB_PRI_MASK 0x2000000
#define MC_CITF_CREDITS_ARB_RD__HUB_PRI__SHIFT 0x19
#define MC_CITF_CREDITS_ARB_WR__WRITE_LCL_MASK 0xff
#define MC_CITF_CREDITS_ARB_WR__WRITE_LCL__SHIFT 0x0
#define MC_CITF_CREDITS_ARB_WR__WRITE_HUB_MASK 0xff00
#define MC_CITF_CREDITS_ARB_WR__WRITE_HUB__SHIFT 0x8
#define MC_CITF_CREDITS_ARB_WR__WRITE_PRI_MASK 0xff0000
#define MC_CITF_CREDITS_ARB_WR__WRITE_PRI__SHIFT 0x10
#define MC_CITF_CREDITS_ARB_WR__HUB_PRI_MASK 0x1000000
#define MC_CITF_CREDITS_ARB_WR__HUB_PRI__SHIFT 0x18
#define MC_CITF_CREDITS_ARB_WR__LCL_PRI_MASK 0x2000000
#define MC_CITF_CREDITS_ARB_WR__LCL_PRI__SHIFT 0x19
#define MC_CITF_DAGB_CNTL__JUMP_AHEAD_MASK 0x1
#define MC_CITF_DAGB_CNTL__JUMP_AHEAD__SHIFT 0x0
#define MC_CITF_DAGB_CNTL__CENTER_RD_MAX_BURST_MASK 0x1e
#define MC_CITF_DAGB_CNTL__CENTER_RD_MAX_BURST__SHIFT 0x1
#define MC_CITF_DAGB_CNTL__DISABLE_SELF_INIT_MASK 0x20
#define MC_CITF_DAGB_CNTL__DISABLE_SELF_INIT__SHIFT 0x5
#define MC_CITF_DAGB_CNTL__CENTER_WR_MAX_BURST_MASK 0x3c0
#define MC_CITF_DAGB_CNTL__CENTER_WR_MAX_BURST__SHIFT 0x6
#define MC_CITF_INT_CREDITS__REMRDRET_MASK 0x3f
#define MC_CITF_INT_CREDITS__REMRDRET__SHIFT 0x0
#define MC_CITF_INT_CREDITS__CNTR_RD_HUB_LP_MASK 0x3f000
#define MC_CITF_INT_CREDITS__CNTR_RD_HUB_LP__SHIFT 0xc
#define MC_CITF_INT_CREDITS__CNTR_RD_HUB_HP_MASK 0xfc0000
#define MC_CITF_INT_CREDITS__CNTR_RD_HUB_HP__SHIFT 0x12
#define MC_CITF_INT_CREDITS__CNTR_RD_LCL_MASK 0x3f000000
#define MC_CITF_INT_CREDITS__CNTR_RD_LCL__SHIFT 0x18
#define MC_CITF_RET_MODE__INORDER_RD_MASK 0x1
#define MC_CITF_RET_MODE__INORDER_RD__SHIFT 0x0
#define MC_CITF_RET_MODE__INORDER_WR_MASK 0x2
#define MC_CITF_RET_MODE__INORDER_WR__SHIFT 0x1
#define MC_CITF_RET_MODE__REMPRI_RD_MASK 0x4
#define MC_CITF_RET_MODE__REMPRI_RD__SHIFT 0x2
#define MC_CITF_RET_MODE__REMPRI_WR_MASK 0x8
#define MC_CITF_RET_MODE__REMPRI_WR__SHIFT 0x3
#define MC_CITF_RET_MODE__LCLPRI_RD_MASK 0x10
#define MC_CITF_RET_MODE__LCLPRI_RD__SHIFT 0x4
#define MC_CITF_RET_MODE__LCLPRI_WR_MASK 0x20
#define MC_CITF_RET_MODE__LCLPRI_WR__SHIFT 0x5
#define MC_CITF_RET_MODE__RDRET_STALL_EN_MASK 0x40
#define MC_CITF_RET_MODE__RDRET_STALL_EN__SHIFT 0x6
#define MC_CITF_RET_MODE__RDRET_STALL_THRESHOLD_MASK 0x7f80
#define MC_CITF_RET_MODE__RDRET_STALL_THRESHOLD__SHIFT 0x7
#define MC_CITF_DAGB_DLY__DLY_MASK 0x1f
#define MC_CITF_DAGB_DLY__DLY__SHIFT 0x0
#define MC_CITF_DAGB_DLY__CLI_MASK 0x3f0000
#define MC_CITF_DAGB_DLY__CLI__SHIFT 0x10
#define MC_CITF_DAGB_DLY__POS_MASK 0x3f000000
#define MC_CITF_DAGB_DLY__POS__SHIFT 0x18
#define MC_RD_GRP_EXT__DBSTEN0_MASK 0xf
#define MC_RD_GRP_EXT__DBSTEN0__SHIFT 0x0
#define MC_RD_GRP_EXT__TC0_MASK 0xf0
#define MC_RD_GRP_EXT__TC0__SHIFT 0x4
#define MC_WR_GRP_EXT__DBSTEN0_MASK 0xf
#define MC_WR_GRP_EXT__DBSTEN0__SHIFT 0x0
#define MC_WR_GRP_EXT__TC0_MASK 0xf0
#define MC_WR_GRP_EXT__TC0__SHIFT 0x4
#define MC_CITF_REMREQ__READ_CREDITS_MASK 0x7f
#define MC_CITF_REMREQ__READ_CREDITS__SHIFT 0x0
#define MC_CITF_REMREQ__WRITE_CREDITS_MASK 0x3f80
#define MC_CITF_REMREQ__WRITE_CREDITS__SHIFT 0x7
#define MC_CITF_REMREQ__CREDITS_ENABLE_MASK 0x4000
#define MC_CITF_REMREQ__CREDITS_ENABLE__SHIFT 0xe
#define MC_WR_TC0__ENABLE_MASK 0x1
#define MC_WR_TC0__ENABLE__SHIFT 0x0
#define MC_WR_TC0__PRESCALE_MASK 0x6
#define MC_WR_TC0__PRESCALE__SHIFT 0x1
#define MC_WR_TC0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_TC0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_TC0__STALL_MODE_MASK 0x30
#define MC_WR_TC0__STALL_MODE__SHIFT 0x4
#define MC_WR_TC0__STALL_OVERRIDE_MASK 0x40
#define MC_WR_TC0__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_TC0__MAX_BURST_MASK 0x780
#define MC_WR_TC0__MAX_BURST__SHIFT 0x7
#define MC_WR_TC0__LAZY_TIMER_MASK 0x7800
#define MC_WR_TC0__LAZY_TIMER__SHIFT 0xb
#define MC_WR_TC0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_TC0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_WR_TC1__ENABLE_MASK 0x1
#define MC_WR_TC1__ENABLE__SHIFT 0x0
#define MC_WR_TC1__PRESCALE_MASK 0x6
#define MC_WR_TC1__PRESCALE__SHIFT 0x1
#define MC_WR_TC1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_TC1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_TC1__STALL_MODE_MASK 0x30
#define MC_WR_TC1__STALL_MODE__SHIFT 0x4
#define MC_WR_TC1__STALL_OVERRIDE_MASK 0x40
#define MC_WR_TC1__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_TC1__MAX_BURST_MASK 0x780
#define MC_WR_TC1__MAX_BURST__SHIFT 0x7
#define MC_WR_TC1__LAZY_TIMER_MASK 0x7800
#define MC_WR_TC1__LAZY_TIMER__SHIFT 0xb
#define MC_WR_TC1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_TC1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_CITF_INT_CREDITS_WR__CNTR_WR_HUB_MASK 0x3f
#define MC_CITF_INT_CREDITS_WR__CNTR_WR_HUB__SHIFT 0x0
#define MC_CITF_INT_CREDITS_WR__CNTR_WR_LCL_MASK 0xfc0
#define MC_CITF_INT_CREDITS_WR__CNTR_WR_LCL__SHIFT 0x6
#define MC_CITF_CREDITS_ARB_RD2__READ_MED_MASK 0xff
#define MC_CITF_CREDITS_ARB_RD2__READ_MED__SHIFT 0x0
#define MC_CITF_WTM_RD_CNTL__GROUP0_DECREMENT_MASK 0x7
#define MC_CITF_WTM_RD_CNTL__GROUP0_DECREMENT__SHIFT 0x0
#define MC_CITF_WTM_RD_CNTL__GROUP1_DECREMENT_MASK 0x38
#define MC_CITF_WTM_RD_CNTL__GROUP1_DECREMENT__SHIFT 0x3
#define MC_CITF_WTM_RD_CNTL__GROUP2_DECREMENT_MASK 0x1c0
#define MC_CITF_WTM_RD_CNTL__GROUP2_DECREMENT__SHIFT 0x6
#define MC_CITF_WTM_RD_CNTL__GROUP3_DECREMENT_MASK 0xe00
#define MC_CITF_WTM_RD_CNTL__GROUP3_DECREMENT__SHIFT 0x9
#define MC_CITF_WTM_RD_CNTL__GROUP4_DECREMENT_MASK 0x7000
#define MC_CITF_WTM_RD_CNTL__GROUP4_DECREMENT__SHIFT 0xc
#define MC_CITF_WTM_RD_CNTL__GROUP5_DECREMENT_MASK 0x38000
#define MC_CITF_WTM_RD_CNTL__GROUP5_DECREMENT__SHIFT 0xf
#define MC_CITF_WTM_RD_CNTL__GROUP6_DECREMENT_MASK 0x1c0000
#define MC_CITF_WTM_RD_CNTL__GROUP6_DECREMENT__SHIFT 0x12
#define MC_CITF_WTM_RD_CNTL__GROUP7_DECREMENT_MASK 0xe00000
#define MC_CITF_WTM_RD_CNTL__GROUP7_DECREMENT__SHIFT 0x15
#define MC_CITF_WTM_RD_CNTL__DISABLE_REMOTE_MASK 0x1000000
#define MC_CITF_WTM_RD_CNTL__DISABLE_REMOTE__SHIFT 0x18
#define MC_CITF_WTM_RD_CNTL__DISABLE_LOCAL_MASK 0x2000000
#define MC_CITF_WTM_RD_CNTL__DISABLE_LOCAL__SHIFT 0x19
#define MC_CITF_WTM_WR_CNTL__GROUP0_DECREMENT_MASK 0x7
#define MC_CITF_WTM_WR_CNTL__GROUP0_DECREMENT__SHIFT 0x0
#define MC_CITF_WTM_WR_CNTL__GROUP1_DECREMENT_MASK 0x38
#define MC_CITF_WTM_WR_CNTL__GROUP1_DECREMENT__SHIFT 0x3
#define MC_CITF_WTM_WR_CNTL__GROUP2_DECREMENT_MASK 0x1c0
#define MC_CITF_WTM_WR_CNTL__GROUP2_DECREMENT__SHIFT 0x6
#define MC_CITF_WTM_WR_CNTL__GROUP3_DECREMENT_MASK 0xe00
#define MC_CITF_WTM_WR_CNTL__GROUP3_DECREMENT__SHIFT 0x9
#define MC_CITF_WTM_WR_CNTL__GROUP4_DECREMENT_MASK 0x7000
#define MC_CITF_WTM_WR_CNTL__GROUP4_DECREMENT__SHIFT 0xc
#define MC_CITF_WTM_WR_CNTL__GROUP5_DECREMENT_MASK 0x38000
#define MC_CITF_WTM_WR_CNTL__GROUP5_DECREMENT__SHIFT 0xf
#define MC_CITF_WTM_WR_CNTL__GROUP6_DECREMENT_MASK 0x1c0000
#define MC_CITF_WTM_WR_CNTL__GROUP6_DECREMENT__SHIFT 0x12
#define MC_CITF_WTM_WR_CNTL__GROUP7_DECREMENT_MASK 0xe00000
#define MC_CITF_WTM_WR_CNTL__GROUP7_DECREMENT__SHIFT 0x15
#define MC_CITF_WTM_WR_CNTL__DISABLE_REMOTE_MASK 0x1000000
#define MC_CITF_WTM_WR_CNTL__DISABLE_REMOTE__SHIFT 0x18
#define MC_CITF_WTM_WR_CNTL__DISABLE_LOCAL_MASK 0x2000000
#define MC_CITF_WTM_WR_CNTL__DISABLE_LOCAL__SHIFT 0x19
#define MC_RD_CB__ENABLE_MASK 0x1
#define MC_RD_CB__ENABLE__SHIFT 0x0
#define MC_RD_CB__PRESCALE_MASK 0x6
#define MC_RD_CB__PRESCALE__SHIFT 0x1
#define MC_RD_CB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_CB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_CB__STALL_MODE_MASK 0x30
#define MC_RD_CB__STALL_MODE__SHIFT 0x4
#define MC_RD_CB__STALL_OVERRIDE_MASK 0x40
#define MC_RD_CB__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_CB__MAX_BURST_MASK 0x780
#define MC_RD_CB__MAX_BURST__SHIFT 0x7
#define MC_RD_CB__LAZY_TIMER_MASK 0x7800
#define MC_RD_CB__LAZY_TIMER__SHIFT 0xb
#define MC_RD_CB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_CB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RD_DB__ENABLE_MASK 0x1
#define MC_RD_DB__ENABLE__SHIFT 0x0
#define MC_RD_DB__PRESCALE_MASK 0x6
#define MC_RD_DB__PRESCALE__SHIFT 0x1
#define MC_RD_DB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_DB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_DB__STALL_MODE_MASK 0x30
#define MC_RD_DB__STALL_MODE__SHIFT 0x4
#define MC_RD_DB__STALL_OVERRIDE_MASK 0x40
#define MC_RD_DB__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_DB__MAX_BURST_MASK 0x780
#define MC_RD_DB__MAX_BURST__SHIFT 0x7
#define MC_RD_DB__LAZY_TIMER_MASK 0x7800
#define MC_RD_DB__LAZY_TIMER__SHIFT 0xb
#define MC_RD_DB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_DB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RD_TC0__ENABLE_MASK 0x1
#define MC_RD_TC0__ENABLE__SHIFT 0x0
#define MC_RD_TC0__PRESCALE_MASK 0x6
#define MC_RD_TC0__PRESCALE__SHIFT 0x1
#define MC_RD_TC0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_TC0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_TC0__STALL_MODE_MASK 0x30
#define MC_RD_TC0__STALL_MODE__SHIFT 0x4
#define MC_RD_TC0__STALL_OVERRIDE_MASK 0x40
#define MC_RD_TC0__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_TC0__MAX_BURST_MASK 0x780
#define MC_RD_TC0__MAX_BURST__SHIFT 0x7
#define MC_RD_TC0__LAZY_TIMER_MASK 0x7800
#define MC_RD_TC0__LAZY_TIMER__SHIFT 0xb
#define MC_RD_TC0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_TC0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RD_TC1__ENABLE_MASK 0x1
#define MC_RD_TC1__ENABLE__SHIFT 0x0
#define MC_RD_TC1__PRESCALE_MASK 0x6
#define MC_RD_TC1__PRESCALE__SHIFT 0x1
#define MC_RD_TC1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_TC1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_TC1__STALL_MODE_MASK 0x30
#define MC_RD_TC1__STALL_MODE__SHIFT 0x4
#define MC_RD_TC1__STALL_OVERRIDE_MASK 0x40
#define MC_RD_TC1__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_TC1__MAX_BURST_MASK 0x780
#define MC_RD_TC1__MAX_BURST__SHIFT 0x7
#define MC_RD_TC1__LAZY_TIMER_MASK 0x7800
#define MC_RD_TC1__LAZY_TIMER__SHIFT 0xb
#define MC_RD_TC1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_TC1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RD_HUB__ENABLE_MASK 0x1
#define MC_RD_HUB__ENABLE__SHIFT 0x0
#define MC_RD_HUB__PRESCALE_MASK 0x6
#define MC_RD_HUB__PRESCALE__SHIFT 0x1
#define MC_RD_HUB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_HUB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_HUB__STALL_MODE_MASK 0x30
#define MC_RD_HUB__STALL_MODE__SHIFT 0x4
#define MC_RD_HUB__STALL_OVERRIDE_MASK 0x40
#define MC_RD_HUB__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_HUB__MAX_BURST_MASK 0x780
#define MC_RD_HUB__MAX_BURST__SHIFT 0x7
#define MC_RD_HUB__LAZY_TIMER_MASK 0x7800
#define MC_RD_HUB__LAZY_TIMER__SHIFT 0xb
#define MC_RD_HUB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_HUB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_WR_CB__ENABLE_MASK 0x1
#define MC_WR_CB__ENABLE__SHIFT 0x0
#define MC_WR_CB__PRESCALE_MASK 0x6
#define MC_WR_CB__PRESCALE__SHIFT 0x1
#define MC_WR_CB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_CB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_CB__STALL_MODE_MASK 0x30
#define MC_WR_CB__STALL_MODE__SHIFT 0x4
#define MC_WR_CB__STALL_OVERRIDE_MASK 0x40
#define MC_WR_CB__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_CB__MAX_BURST_MASK 0x780
#define MC_WR_CB__MAX_BURST__SHIFT 0x7
#define MC_WR_CB__LAZY_TIMER_MASK 0x7800
#define MC_WR_CB__LAZY_TIMER__SHIFT 0xb
#define MC_WR_CB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_CB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_WR_DB__ENABLE_MASK 0x1
#define MC_WR_DB__ENABLE__SHIFT 0x0
#define MC_WR_DB__PRESCALE_MASK 0x6
#define MC_WR_DB__PRESCALE__SHIFT 0x1
#define MC_WR_DB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_DB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_DB__STALL_MODE_MASK 0x30
#define MC_WR_DB__STALL_MODE__SHIFT 0x4
#define MC_WR_DB__STALL_OVERRIDE_MASK 0x40
#define MC_WR_DB__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_DB__MAX_BURST_MASK 0x780
#define MC_WR_DB__MAX_BURST__SHIFT 0x7
#define MC_WR_DB__LAZY_TIMER_MASK 0x7800
#define MC_WR_DB__LAZY_TIMER__SHIFT 0xb
#define MC_WR_DB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_DB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_WR_HUB__ENABLE_MASK 0x1
#define MC_WR_HUB__ENABLE__SHIFT 0x0
#define MC_WR_HUB__PRESCALE_MASK 0x6
#define MC_WR_HUB__PRESCALE__SHIFT 0x1
#define MC_WR_HUB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_HUB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_HUB__STALL_MODE_MASK 0x30
#define MC_WR_HUB__STALL_MODE__SHIFT 0x4
#define MC_WR_HUB__STALL_OVERRIDE_MASK 0x40
#define MC_WR_HUB__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_HUB__MAX_BURST_MASK 0x780
#define MC_WR_HUB__MAX_BURST__SHIFT 0x7
#define MC_WR_HUB__LAZY_TIMER_MASK 0x7800
#define MC_WR_HUB__LAZY_TIMER__SHIFT 0xb
#define MC_WR_HUB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_HUB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_CITF_CREDITS_XBAR__READ_LCL_MASK 0xff
#define MC_CITF_CREDITS_XBAR__READ_LCL__SHIFT 0x0
#define MC_CITF_CREDITS_XBAR__WRITE_LCL_MASK 0xff00
#define MC_CITF_CREDITS_XBAR__WRITE_LCL__SHIFT 0x8
#define MC_RD_GRP_LCL__CB0_MASK 0xf000
#define MC_RD_GRP_LCL__CB0__SHIFT 0xc
#define MC_RD_GRP_LCL__CBCMASK0_MASK 0xf0000
#define MC_RD_GRP_LCL__CBCMASK0__SHIFT 0x10
#define MC_RD_GRP_LCL__CBFMASK0_MASK 0xf00000
#define MC_RD_GRP_LCL__CBFMASK0__SHIFT 0x14
#define MC_RD_GRP_LCL__DB0_MASK 0xf000000
#define MC_RD_GRP_LCL__DB0__SHIFT 0x18
#define MC_RD_GRP_LCL__DBHTILE0_MASK 0xf0000000
#define MC_RD_GRP_LCL__DBHTILE0__SHIFT 0x1c
#define MC_WR_GRP_LCL__CB0_MASK 0xf
#define MC_WR_GRP_LCL__CB0__SHIFT 0x0
#define MC_WR_GRP_LCL__CBCMASK0_MASK 0xf0
#define MC_WR_GRP_LCL__CBCMASK0__SHIFT 0x4
#define MC_WR_GRP_LCL__CBFMASK0_MASK 0xf00
#define MC_WR_GRP_LCL__CBFMASK0__SHIFT 0x8
#define MC_WR_GRP_LCL__DB0_MASK 0xf000
#define MC_WR_GRP_LCL__DB0__SHIFT 0xc
#define MC_WR_GRP_LCL__DBHTILE0_MASK 0xf0000
#define MC_WR_GRP_LCL__DBHTILE0__SHIFT 0x10
#define MC_WR_GRP_LCL__SX0_MASK 0xf00000
#define MC_WR_GRP_LCL__SX0__SHIFT 0x14
#define MC_WR_GRP_LCL__CBIMMED0_MASK 0xf0000000
#define MC_WR_GRP_LCL__CBIMMED0__SHIFT 0x1c
#define MC_CITF_PERF_MON_CNTL2__CID_MASK 0xff
#define MC_CITF_PERF_MON_CNTL2__CID__SHIFT 0x0
#define MC_CITF_PERF_MON_RSLT2__CB_RD_BUSY_MASK 0x2
#define MC_CITF_PERF_MON_RSLT2__CB_RD_BUSY__SHIFT 0x1
#define MC_CITF_PERF_MON_RSLT2__DB_RD_BUSY_MASK 0x4
#define MC_CITF_PERF_MON_RSLT2__DB_RD_BUSY__SHIFT 0x2
#define MC_CITF_PERF_MON_RSLT2__TC0_RD_BUSY_MASK 0x8
#define MC_CITF_PERF_MON_RSLT2__TC0_RD_BUSY__SHIFT 0x3
#define MC_CITF_PERF_MON_RSLT2__VC0_RD_BUSY_MASK 0x10
#define MC_CITF_PERF_MON_RSLT2__VC0_RD_BUSY__SHIFT 0x4
#define MC_CITF_PERF_MON_RSLT2__TC1_RD_BUSY_MASK 0x20
#define MC_CITF_PERF_MON_RSLT2__TC1_RD_BUSY__SHIFT 0x5
#define MC_CITF_PERF_MON_RSLT2__VC1_RD_BUSY_MASK 0x40
#define MC_CITF_PERF_MON_RSLT2__VC1_RD_BUSY__SHIFT 0x6
#define MC_CITF_PERF_MON_RSLT2__CB_WR_BUSY_MASK 0x80
#define MC_CITF_PERF_MON_RSLT2__CB_WR_BUSY__SHIFT 0x7
#define MC_CITF_PERF_MON_RSLT2__DB_WR_BUSY_MASK 0x100
#define MC_CITF_PERF_MON_RSLT2__DB_WR_BUSY__SHIFT 0x8
#define MC_CITF_PERF_MON_RSLT2__SX_WR_BUSY_MASK 0x200
#define MC_CITF_PERF_MON_RSLT2__SX_WR_BUSY__SHIFT 0x9
#define MC_CITF_PERF_MON_RSLT2__TC2_RD_BUSY_MASK 0x400
#define MC_CITF_PERF_MON_RSLT2__TC2_RD_BUSY__SHIFT 0xa
#define MC_CITF_PERF_MON_RSLT2__TC0_WR_BUSY_MASK 0x800
#define MC_CITF_PERF_MON_RSLT2__TC0_WR_BUSY__SHIFT 0xb
#define MC_CITF_PERF_MON_RSLT2__TC1_WR_BUSY_MASK 0x1000
#define MC_CITF_PERF_MON_RSLT2__TC1_WR_BUSY__SHIFT 0xc
#define MC_CITF_PERF_MON_RSLT2__TC2_WR_BUSY_MASK 0x2000
#define MC_CITF_PERF_MON_RSLT2__TC2_WR_BUSY__SHIFT 0xd
#define MC_CITF_PERF_MON_RSLT2__TC0_ATOM_BUSY_MASK 0x4000
#define MC_CITF_PERF_MON_RSLT2__TC0_ATOM_BUSY__SHIFT 0xe
#define MC_CITF_PERF_MON_RSLT2__TC1_ATOM_BUSY_MASK 0x8000
#define MC_CITF_PERF_MON_RSLT2__TC1_ATOM_BUSY__SHIFT 0xf
#define MC_CITF_PERF_MON_RSLT2__TC2_ATOM_BUSY_MASK 0x10000
#define MC_CITF_PERF_MON_RSLT2__TC2_ATOM_BUSY__SHIFT 0x10
#define MC_CITF_PERF_MON_RSLT2__CB_ATOM_BUSY_MASK 0x20000
#define MC_CITF_PERF_MON_RSLT2__CB_ATOM_BUSY__SHIFT 0x11
#define MC_CITF_PERF_MON_RSLT2__DB_ATOM_BUSY_MASK 0x40000
#define MC_CITF_PERF_MON_RSLT2__DB_ATOM_BUSY__SHIFT 0x12
#define MC_CITF_MISC_RD_CG__ONDLY_MASK 0x3f
#define MC_CITF_MISC_RD_CG__ONDLY__SHIFT 0x0
#define MC_CITF_MISC_RD_CG__OFFDLY_MASK 0xfc0
#define MC_CITF_MISC_RD_CG__OFFDLY__SHIFT 0x6
#define MC_CITF_MISC_RD_CG__RDYDLY_MASK 0x3f000
#define MC_CITF_MISC_RD_CG__RDYDLY__SHIFT 0xc
#define MC_CITF_MISC_RD_CG__ENABLE_MASK 0x40000
#define MC_CITF_MISC_RD_CG__ENABLE__SHIFT 0x12
#define MC_CITF_MISC_RD_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_CITF_MISC_RD_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_CITF_MISC_WR_CG__ONDLY_MASK 0x3f
#define MC_CITF_MISC_WR_CG__ONDLY__SHIFT 0x0
#define MC_CITF_MISC_WR_CG__OFFDLY_MASK 0xfc0
#define MC_CITF_MISC_WR_CG__OFFDLY__SHIFT 0x6
#define MC_CITF_MISC_WR_CG__RDYDLY_MASK 0x3f000
#define MC_CITF_MISC_WR_CG__RDYDLY__SHIFT 0xc
#define MC_CITF_MISC_WR_CG__ENABLE_MASK 0x40000
#define MC_CITF_MISC_WR_CG__ENABLE__SHIFT 0x12
#define MC_CITF_MISC_WR_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_CITF_MISC_WR_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_CITF_MISC_VM_CG__ONDLY_MASK 0x3f
#define MC_CITF_MISC_VM_CG__ONDLY__SHIFT 0x0
#define MC_CITF_MISC_VM_CG__OFFDLY_MASK 0xfc0
#define MC_CITF_MISC_VM_CG__OFFDLY__SHIFT 0x6
#define MC_CITF_MISC_VM_CG__RDYDLY_MASK 0x3f000
#define MC_CITF_MISC_VM_CG__RDYDLY__SHIFT 0xc
#define MC_CITF_MISC_VM_CG__ENABLE_MASK 0x40000
#define MC_CITF_MISC_VM_CG__ENABLE__SHIFT 0x12
#define MC_CITF_MISC_VM_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_CITF_MISC_VM_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_HUB_MISC_POWER__SRBM_GATE_OVERRIDE_MASK 0x4
#define MC_HUB_MISC_POWER__SRBM_GATE_OVERRIDE__SHIFT 0x2
#define MC_HUB_MISC_POWER__PM_BLACKOUT_CNTL_MASK 0x18
#define MC_HUB_MISC_POWER__PM_BLACKOUT_CNTL__SHIFT 0x3
#define MC_HUB_MISC_HUB_CG__ONDLY_MASK 0x3f
#define MC_HUB_MISC_HUB_CG__ONDLY__SHIFT 0x0
#define MC_HUB_MISC_HUB_CG__OFFDLY_MASK 0xfc0
#define MC_HUB_MISC_HUB_CG__OFFDLY__SHIFT 0x6
#define MC_HUB_MISC_HUB_CG__RDYDLY_MASK 0x3f000
#define MC_HUB_MISC_HUB_CG__RDYDLY__SHIFT 0xc
#define MC_HUB_MISC_HUB_CG__ENABLE_MASK 0x40000
#define MC_HUB_MISC_HUB_CG__ENABLE__SHIFT 0x12
#define MC_HUB_MISC_HUB_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_HUB_MISC_HUB_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_HUB_MISC_VM_CG__ONDLY_MASK 0x3f
#define MC_HUB_MISC_VM_CG__ONDLY__SHIFT 0x0
#define MC_HUB_MISC_VM_CG__OFFDLY_MASK 0xfc0
#define MC_HUB_MISC_VM_CG__OFFDLY__SHIFT 0x6
#define MC_HUB_MISC_VM_CG__RDYDLY_MASK 0x3f000
#define MC_HUB_MISC_VM_CG__RDYDLY__SHIFT 0xc
#define MC_HUB_MISC_VM_CG__ENABLE_MASK 0x40000
#define MC_HUB_MISC_VM_CG__ENABLE__SHIFT 0x12
#define MC_HUB_MISC_VM_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_HUB_MISC_VM_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_HUB_MISC_SIP_CG__ONDLY_MASK 0x3f
#define MC_HUB_MISC_SIP_CG__ONDLY__SHIFT 0x0
#define MC_HUB_MISC_SIP_CG__OFFDLY_MASK 0xfc0
#define MC_HUB_MISC_SIP_CG__OFFDLY__SHIFT 0x6
#define MC_HUB_MISC_SIP_CG__RDYDLY_MASK 0x3f000
#define MC_HUB_MISC_SIP_CG__RDYDLY__SHIFT 0xc
#define MC_HUB_MISC_SIP_CG__ENABLE_MASK 0x40000
#define MC_HUB_MISC_SIP_CG__ENABLE__SHIFT 0x12
#define MC_HUB_MISC_SIP_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_HUB_MISC_SIP_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_HUB_MISC_STATUS__OUTSTANDING_READ_MASK 0x1
#define MC_HUB_MISC_STATUS__OUTSTANDING_READ__SHIFT 0x0
#define MC_HUB_MISC_STATUS__OUTSTANDING_WRITE_MASK 0x2
#define MC_HUB_MISC_STATUS__OUTSTANDING_WRITE__SHIFT 0x1
#define MC_HUB_MISC_STATUS__OUTSTANDING_ATOMIC_MASK 0x4
#define MC_HUB_MISC_STATUS__OUTSTANDING_ATOMIC__SHIFT 0x2
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_RDREQ_MASK 0x8
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_RDREQ__SHIFT 0x3
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_RDRET_MASK 0x10
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_RDRET__SHIFT 0x4
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_WRREQ_MASK 0x20
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_WRREQ__SHIFT 0x5
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_WRRET_MASK 0x40
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_WRRET__SHIFT 0x6
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_ATOMIC_REQ_MASK 0x80
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_ATOMIC_REQ__SHIFT 0x7
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_ATOMIC_RET_MASK 0x100
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_ATOMIC_RET__SHIFT 0x8
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_READ_MASK 0x200
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_READ__SHIFT 0x9
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_WRITE_MASK 0x400
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_WRITE__SHIFT 0xa
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_ATOMIC_MASK 0x800
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_ATOMIC__SHIFT 0xb
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_READ_MASK 0x1000
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_READ__SHIFT 0xc
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_WRITE_MASK 0x2000
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_WRITE__SHIFT 0xd
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_ATOMIC_MASK 0x4000
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_ATOMIC__SHIFT 0xe
#define MC_HUB_MISC_STATUS__RPB_BUSY_MASK 0x8000
#define MC_HUB_MISC_STATUS__RPB_BUSY__SHIFT 0xf
#define MC_HUB_MISC_STATUS__WRITE_DEADLOCK_WARNING_MASK 0x10000
#define MC_HUB_MISC_STATUS__WRITE_DEADLOCK_WARNING__SHIFT 0x10
#define MC_HUB_MISC_STATUS__READ_DEADLOCK_WARNING_MASK 0x20000
#define MC_HUB_MISC_STATUS__READ_DEADLOCK_WARNING__SHIFT 0x11
#define MC_HUB_MISC_STATUS__ATOMIC_DEADLOCK_WARNING_MASK 0x40000
#define MC_HUB_MISC_STATUS__ATOMIC_DEADLOCK_WARNING__SHIFT 0x12
#define MC_HUB_MISC_STATUS__GFX_BUSY_MASK 0x80000
#define MC_HUB_MISC_STATUS__GFX_BUSY__SHIFT 0x13
#define MC_HUB_MISC_OVERRIDE__IDLE_MASK 0x3
#define MC_HUB_MISC_OVERRIDE__IDLE__SHIFT 0x0
#define MC_HUB_MISC_FRAMING__BITS_MASK 0xffffffff
#define MC_HUB_MISC_FRAMING__BITS__SHIFT 0x0
#define MC_HUB_WDP_CNTL__JUMPAHEAD_GBL0_MASK 0x2
#define MC_HUB_WDP_CNTL__JUMPAHEAD_GBL0__SHIFT 0x1
#define MC_HUB_WDP_CNTL__JUMPAHEAD_GBL1_MASK 0x4
#define MC_HUB_WDP_CNTL__JUMPAHEAD_GBL1__SHIFT 0x2
#define MC_HUB_WDP_CNTL__JUMPAHEAD_INTERNAL_MASK 0x8
#define MC_HUB_WDP_CNTL__JUMPAHEAD_INTERNAL__SHIFT 0x3
#define MC_HUB_WDP_CNTL__OVERRIDE_STALL_ENABLE_MASK 0x10
#define MC_HUB_WDP_CNTL__OVERRIDE_STALL_ENABLE__SHIFT 0x4
#define MC_HUB_WDP_CNTL__DEBUG_REG_MASK 0x1fe0
#define MC_HUB_WDP_CNTL__DEBUG_REG__SHIFT 0x5
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_GBL0_MASK 0x2000
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_GBL0__SHIFT 0xd
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_GBL1_MASK 0x4000
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_GBL1__SHIFT 0xe
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_INTERNAL_MASK 0x8000
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_INTERNAL__SHIFT 0xf
#define MC_HUB_WDP_CNTL__FAIR_CH_SW_MASK 0x10000
#define MC_HUB_WDP_CNTL__FAIR_CH_SW__SHIFT 0x10
#define MC_HUB_WDP_CNTL__LCLWRREQ_BYPASS_MASK 0x20000
#define MC_HUB_WDP_CNTL__LCLWRREQ_BYPASS__SHIFT 0x11
#define MC_HUB_WDP_CNTL__DISP_WAIT_EOP_MASK 0x40000
#define MC_HUB_WDP_CNTL__DISP_WAIT_EOP__SHIFT 0x12
#define MC_HUB_WDP_CNTL__MCD_WAIT_EOP_MASK 0x80000
#define MC_HUB_WDP_CNTL__MCD_WAIT_EOP__SHIFT 0x13
#define MC_HUB_WDP_CNTL__SIP_WAIT_EOP_MASK 0x100000
#define MC_HUB_WDP_CNTL__SIP_WAIT_EOP__SHIFT 0x14
#define MC_HUB_WDP_CNTL__UVD_VCE_WRITE_PRI_EN_MASK 0x200000
#define MC_HUB_WDP_CNTL__UVD_VCE_WRITE_PRI_EN__SHIFT 0x15
#define MC_HUB_WDP_CNTL__WRITE_PRI_EN_MASK 0x400000
#define MC_HUB_WDP_CNTL__WRITE_PRI_EN__SHIFT 0x16
#define MC_HUB_WDP_CNTL__IH_PHYSADDR_ENABLE_MASK 0x800000
#define MC_HUB_WDP_CNTL__IH_PHYSADDR_ENABLE__SHIFT 0x17
#define MC_HUB_WDP_ERR__MGPU1_TARG_SYS_MASK 0x1
#define MC_HUB_WDP_ERR__MGPU1_TARG_SYS__SHIFT 0x0
#define MC_HUB_WDP_ERR__MGPU2_TARG_SYS_MASK 0x2
#define MC_HUB_WDP_ERR__MGPU2_TARG_SYS__SHIFT 0x1
#define MC_HUB_WDP_BP__ENABLE_MASK 0x1
#define MC_HUB_WDP_BP__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_BP__RDRET_MASK 0x3fffe
#define MC_HUB_WDP_BP__RDRET__SHIFT 0x1
#define MC_HUB_WDP_BP__WRREQ_MASK 0x3ffc0000
#define MC_HUB_WDP_BP__WRREQ__SHIFT 0x12
#define MC_HUB_WDP_STATUS__SIP_AVAIL_MASK 0x1
#define MC_HUB_WDP_STATUS__SIP_AVAIL__SHIFT 0x0
#define MC_HUB_WDP_STATUS__MCDW_RD_AVAIL_MASK 0x2
#define MC_HUB_WDP_STATUS__MCDW_RD_AVAIL__SHIFT 0x1
#define MC_HUB_WDP_STATUS__MCDX_RD_AVAIL_MASK 0x4
#define MC_HUB_WDP_STATUS__MCDX_RD_AVAIL__SHIFT 0x2
#define MC_HUB_WDP_STATUS__MCDY_RD_AVAIL_MASK 0x8
#define MC_HUB_WDP_STATUS__MCDY_RD_AVAIL__SHIFT 0x3
#define MC_HUB_WDP_STATUS__MCDZ_RD_AVAIL_MASK 0x10
#define MC_HUB_WDP_STATUS__MCDZ_RD_AVAIL__SHIFT 0x4
#define MC_HUB_WDP_STATUS__MCDS_RD_AVAIL_MASK 0x20
#define MC_HUB_WDP_STATUS__MCDS_RD_AVAIL__SHIFT 0x5
#define MC_HUB_WDP_STATUS__MCDT_RD_AVAIL_MASK 0x40
#define MC_HUB_WDP_STATUS__MCDT_RD_AVAIL__SHIFT 0x6
#define MC_HUB_WDP_STATUS__MCDU_RD_AVAIL_MASK 0x80
#define MC_HUB_WDP_STATUS__MCDU_RD_AVAIL__SHIFT 0x7
#define MC_HUB_WDP_STATUS__MCDV_RD_AVAIL_MASK 0x100
#define MC_HUB_WDP_STATUS__MCDV_RD_AVAIL__SHIFT 0x8
#define MC_HUB_WDP_STATUS__MCDW_WR_AVAIL_MASK 0x200
#define MC_HUB_WDP_STATUS__MCDW_WR_AVAIL__SHIFT 0x9
#define MC_HUB_WDP_STATUS__MCDX_WR_AVAIL_MASK 0x400
#define MC_HUB_WDP_STATUS__MCDX_WR_AVAIL__SHIFT 0xa
#define MC_HUB_WDP_STATUS__MCDY_WR_AVAIL_MASK 0x800
#define MC_HUB_WDP_STATUS__MCDY_WR_AVAIL__SHIFT 0xb
#define MC_HUB_WDP_STATUS__MCDZ_WR_AVAIL_MASK 0x1000
#define MC_HUB_WDP_STATUS__MCDZ_WR_AVAIL__SHIFT 0xc
#define MC_HUB_WDP_STATUS__MCDS_WR_AVAIL_MASK 0x2000
#define MC_HUB_WDP_STATUS__MCDS_WR_AVAIL__SHIFT 0xd
#define MC_HUB_WDP_STATUS__MCDT_WR_AVAIL_MASK 0x4000
#define MC_HUB_WDP_STATUS__MCDT_WR_AVAIL__SHIFT 0xe
#define MC_HUB_WDP_STATUS__MCDU_WR_AVAIL_MASK 0x8000
#define MC_HUB_WDP_STATUS__MCDU_WR_AVAIL__SHIFT 0xf
#define MC_HUB_WDP_STATUS__MCDV_WR_AVAIL_MASK 0x10000
#define MC_HUB_WDP_STATUS__MCDV_WR_AVAIL__SHIFT 0x10
#define MC_HUB_WDP_STATUS__GBL0_VM_FULL_MASK 0x20000
#define MC_HUB_WDP_STATUS__GBL0_VM_FULL__SHIFT 0x11
#define MC_HUB_WDP_STATUS__GBL0_STOR_FULL_MASK 0x40000
#define MC_HUB_WDP_STATUS__GBL0_STOR_FULL__SHIFT 0x12
#define MC_HUB_WDP_STATUS__GBL0_BYPASS_STOR_FULL_MASK 0x80000
#define MC_HUB_WDP_STATUS__GBL0_BYPASS_STOR_FULL__SHIFT 0x13
#define MC_HUB_WDP_STATUS__GBL1_VM_FULL_MASK 0x100000
#define MC_HUB_WDP_STATUS__GBL1_VM_FULL__SHIFT 0x14
#define MC_HUB_WDP_STATUS__GBL1_STOR_FULL_MASK 0x200000
#define MC_HUB_WDP_STATUS__GBL1_STOR_FULL__SHIFT 0x15
#define MC_HUB_WDP_STATUS__GBL1_BYPASS_STOR_FULL_MASK 0x400000
#define MC_HUB_WDP_STATUS__GBL1_BYPASS_STOR_FULL__SHIFT 0x16
#define MC_HUB_RDREQ_STATUS__SIP_AVAIL_MASK 0x1
#define MC_HUB_RDREQ_STATUS__SIP_AVAIL__SHIFT 0x0
#define MC_HUB_RDREQ_STATUS__MCDW_RD_AVAIL_MASK 0x2
#define MC_HUB_RDREQ_STATUS__MCDW_RD_AVAIL__SHIFT 0x1
#define MC_HUB_RDREQ_STATUS__MCDX_RD_AVAIL_MASK 0x4
#define MC_HUB_RDREQ_STATUS__MCDX_RD_AVAIL__SHIFT 0x2
#define MC_HUB_RDREQ_STATUS__MCDY_RD_AVAIL_MASK 0x8
#define MC_HUB_RDREQ_STATUS__MCDY_RD_AVAIL__SHIFT 0x3
#define MC_HUB_RDREQ_STATUS__MCDZ_RD_AVAIL_MASK 0x10
#define MC_HUB_RDREQ_STATUS__MCDZ_RD_AVAIL__SHIFT 0x4
#define MC_HUB_RDREQ_STATUS__MCDS_RD_AVAIL_MASK 0x20
#define MC_HUB_RDREQ_STATUS__MCDS_RD_AVAIL__SHIFT 0x5
#define MC_HUB_RDREQ_STATUS__MCDT_RD_AVAIL_MASK 0x40
#define MC_HUB_RDREQ_STATUS__MCDT_RD_AVAIL__SHIFT 0x6
#define MC_HUB_RDREQ_STATUS__MCDU_RD_AVAIL_MASK 0x80
#define MC_HUB_RDREQ_STATUS__MCDU_RD_AVAIL__SHIFT 0x7
#define MC_HUB_RDREQ_STATUS__MCDV_RD_AVAIL_MASK 0x100
#define MC_HUB_RDREQ_STATUS__MCDV_RD_AVAIL__SHIFT 0x8
#define MC_HUB_RDREQ_STATUS__GBL0_VM_FULL_MASK 0x200
#define MC_HUB_RDREQ_STATUS__GBL0_VM_FULL__SHIFT 0x9
#define MC_HUB_RDREQ_STATUS__GBL0_STOR_FULL_MASK 0x400
#define MC_HUB_RDREQ_STATUS__GBL0_STOR_FULL__SHIFT 0xa
#define MC_HUB_RDREQ_STATUS__GBL0_BYPASS_STOR_FULL_MASK 0x800
#define MC_HUB_RDREQ_STATUS__GBL0_BYPASS_STOR_FULL__SHIFT 0xb
#define MC_HUB_RDREQ_STATUS__GBL1_VM_FULL_MASK 0x1000
#define MC_HUB_RDREQ_STATUS__GBL1_VM_FULL__SHIFT 0xc
#define MC_HUB_RDREQ_STATUS__GBL1_STOR_FULL_MASK 0x2000
#define MC_HUB_RDREQ_STATUS__GBL1_STOR_FULL__SHIFT 0xd
#define MC_HUB_RDREQ_STATUS__GBL1_BYPASS_STOR_FULL_MASK 0x4000
#define MC_HUB_RDREQ_STATUS__GBL1_BYPASS_STOR_FULL__SHIFT 0xe
#define MC_HUB_RDREQ_STATUS__PWRXPRESS_ERR_MASK 0x8000
#define MC_HUB_RDREQ_STATUS__PWRXPRESS_ERR__SHIFT 0xf
#define MC_HUB_WRRET_STATUS__MCDW_AVAIL_MASK 0x1
#define MC_HUB_WRRET_STATUS__MCDW_AVAIL__SHIFT 0x0
#define MC_HUB_WRRET_STATUS__MCDX_AVAIL_MASK 0x2
#define MC_HUB_WRRET_STATUS__MCDX_AVAIL__SHIFT 0x1
#define MC_HUB_WRRET_STATUS__MCDY_AVAIL_MASK 0x4
#define MC_HUB_WRRET_STATUS__MCDY_AVAIL__SHIFT 0x2
#define MC_HUB_WRRET_STATUS__MCDZ_AVAIL_MASK 0x8
#define MC_HUB_WRRET_STATUS__MCDZ_AVAIL__SHIFT 0x3
#define MC_HUB_WRRET_STATUS__MCDS_AVAIL_MASK 0x10
#define MC_HUB_WRRET_STATUS__MCDS_AVAIL__SHIFT 0x4
#define MC_HUB_WRRET_STATUS__MCDT_AVAIL_MASK 0x20
#define MC_HUB_WRRET_STATUS__MCDT_AVAIL__SHIFT 0x5
#define MC_HUB_WRRET_STATUS__MCDU_AVAIL_MASK 0x40
#define MC_HUB_WRRET_STATUS__MCDU_AVAIL__SHIFT 0x6
#define MC_HUB_WRRET_STATUS__MCDV_AVAIL_MASK 0x80
#define MC_HUB_WRRET_STATUS__MCDV_AVAIL__SHIFT 0x7
#define MC_HUB_RDREQ_CNTL__REMOTE_BLACKOUT_MASK 0x1
#define MC_HUB_RDREQ_CNTL__REMOTE_BLACKOUT__SHIFT 0x0
#define MC_HUB_RDREQ_CNTL__JUMPAHEAD_GBL0_MASK 0x4
#define MC_HUB_RDREQ_CNTL__JUMPAHEAD_GBL0__SHIFT 0x2
#define MC_HUB_RDREQ_CNTL__JUMPAHEAD_GBL1_MASK 0x8
#define MC_HUB_RDREQ_CNTL__JUMPAHEAD_GBL1__SHIFT 0x3
#define MC_HUB_RDREQ_CNTL__OVERRIDE_STALL_ENABLE_MASK 0x10
#define MC_HUB_RDREQ_CNTL__OVERRIDE_STALL_ENABLE__SHIFT 0x4
#define MC_HUB_RDREQ_CNTL__MCDW_STALL_MODE_MASK 0x20
#define MC_HUB_RDREQ_CNTL__MCDW_STALL_MODE__SHIFT 0x5
#define MC_HUB_RDREQ_CNTL__MCDX_STALL_MODE_MASK 0x40
#define MC_HUB_RDREQ_CNTL__MCDX_STALL_MODE__SHIFT 0x6
#define MC_HUB_RDREQ_CNTL__MCDY_STALL_MODE_MASK 0x80
#define MC_HUB_RDREQ_CNTL__MCDY_STALL_MODE__SHIFT 0x7
#define MC_HUB_RDREQ_CNTL__MCDZ_STALL_MODE_MASK 0x100
#define MC_HUB_RDREQ_CNTL__MCDZ_STALL_MODE__SHIFT 0x8
#define MC_HUB_RDREQ_CNTL__MCDS_STALL_MODE_MASK 0x200
#define MC_HUB_RDREQ_CNTL__MCDS_STALL_MODE__SHIFT 0x9
#define MC_HUB_RDREQ_CNTL__MCDT_STALL_MODE_MASK 0x400
#define MC_HUB_RDREQ_CNTL__MCDT_STALL_MODE__SHIFT 0xa
#define MC_HUB_RDREQ_CNTL__MCDU_STALL_MODE_MASK 0x800
#define MC_HUB_RDREQ_CNTL__MCDU_STALL_MODE__SHIFT 0xb
#define MC_HUB_RDREQ_CNTL__MCDV_STALL_MODE_MASK 0x1000
#define MC_HUB_RDREQ_CNTL__MCDV_STALL_MODE__SHIFT 0xc
#define MC_HUB_RDREQ_CNTL__BREAK_HDP_DEADLOCK_MASK 0x2000
#define MC_HUB_RDREQ_CNTL__BREAK_HDP_DEADLOCK__SHIFT 0xd
#define MC_HUB_RDREQ_CNTL__DEBUG_REG_MASK 0x1fc000
#define MC_HUB_RDREQ_CNTL__DEBUG_REG__SHIFT 0xe
#define MC_HUB_RDREQ_CNTL__DISABLE_SELF_INIT_GBL0_MASK 0x200000
#define MC_HUB_RDREQ_CNTL__DISABLE_SELF_INIT_GBL0__SHIFT 0x15
#define MC_HUB_RDREQ_CNTL__DISABLE_SELF_INIT_GBL1_MASK 0x400000
#define MC_HUB_RDREQ_CNTL__DISABLE_SELF_INIT_GBL1__SHIFT 0x16
#define MC_HUB_RDREQ_CNTL__PWRXPRESS_MODE_MASK 0x800000
#define MC_HUB_RDREQ_CNTL__PWRXPRESS_MODE__SHIFT 0x17
#define MC_HUB_RDREQ_CNTL__ACPG_HP_TO_MCD_OVERRIDE_MASK 0x1000000
#define MC_HUB_RDREQ_CNTL__ACPG_HP_TO_MCD_OVERRIDE__SHIFT 0x18
#define MC_HUB_RDREQ_CNTL__GBL0_PRI_ENABLE_MASK 0x2000000
#define MC_HUB_RDREQ_CNTL__GBL0_PRI_ENABLE__SHIFT 0x19
#define MC_HUB_RDREQ_CNTL__UVD_TRANSCODE_ENABLE_MASK 0x4000000
#define MC_HUB_RDREQ_CNTL__UVD_TRANSCODE_ENABLE__SHIFT 0x1a
#define MC_HUB_RDREQ_CNTL__DMIF_URG_THRESHOLD_MASK 0x78000000
#define MC_HUB_RDREQ_CNTL__DMIF_URG_THRESHOLD__SHIFT 0x1b
#define MC_HUB_WRRET_CNTL__JUMPAHEAD_MASK 0x1
#define MC_HUB_WRRET_CNTL__JUMPAHEAD__SHIFT 0x0
#define MC_HUB_WRRET_CNTL__BP_MASK 0x1ffffe
#define MC_HUB_WRRET_CNTL__BP__SHIFT 0x1
#define MC_HUB_WRRET_CNTL__BP_ENABLE_MASK 0x200000
#define MC_HUB_WRRET_CNTL__BP_ENABLE__SHIFT 0x15
#define MC_HUB_WRRET_CNTL__DEBUG_REG_MASK 0x3fc00000
#define MC_HUB_WRRET_CNTL__DEBUG_REG__SHIFT 0x16
#define MC_HUB_WRRET_CNTL__DISABLE_SELF_INIT_MASK 0x40000000
#define MC_HUB_WRRET_CNTL__DISABLE_SELF_INIT__SHIFT 0x1e
#define MC_HUB_WRRET_CNTL__FAIR_CH_SW_MASK 0x80000000
#define MC_HUB_WRRET_CNTL__FAIR_CH_SW__SHIFT 0x1f
#define MC_HUB_RDREQ_WTM_CNTL__GROUP0_DECREMENT_MASK 0x7
#define MC_HUB_RDREQ_WTM_CNTL__GROUP0_DECREMENT__SHIFT 0x0
#define MC_HUB_RDREQ_WTM_CNTL__GROUP1_DECREMENT_MASK 0x38
#define MC_HUB_RDREQ_WTM_CNTL__GROUP1_DECREMENT__SHIFT 0x3
#define MC_HUB_RDREQ_WTM_CNTL__GROUP2_DECREMENT_MASK 0x1c0
#define MC_HUB_RDREQ_WTM_CNTL__GROUP2_DECREMENT__SHIFT 0x6
#define MC_HUB_RDREQ_WTM_CNTL__GROUP3_DECREMENT_MASK 0xe00
#define MC_HUB_RDREQ_WTM_CNTL__GROUP3_DECREMENT__SHIFT 0x9
#define MC_HUB_RDREQ_WTM_CNTL__GROUP4_DECREMENT_MASK 0x7000
#define MC_HUB_RDREQ_WTM_CNTL__GROUP4_DECREMENT__SHIFT 0xc
#define MC_HUB_RDREQ_WTM_CNTL__GROUP5_DECREMENT_MASK 0x38000
#define MC_HUB_RDREQ_WTM_CNTL__GROUP5_DECREMENT__SHIFT 0xf
#define MC_HUB_RDREQ_WTM_CNTL__GROUP6_DECREMENT_MASK 0x1c0000
#define MC_HUB_RDREQ_WTM_CNTL__GROUP6_DECREMENT__SHIFT 0x12
#define MC_HUB_RDREQ_WTM_CNTL__GROUP7_DECREMENT_MASK 0xe00000
#define MC_HUB_RDREQ_WTM_CNTL__GROUP7_DECREMENT__SHIFT 0x15
#define MC_HUB_WDP_WTM_CNTL__GROUP0_DECREMENT_MASK 0x7
#define MC_HUB_WDP_WTM_CNTL__GROUP0_DECREMENT__SHIFT 0x0
#define MC_HUB_WDP_WTM_CNTL__GROUP1_DECREMENT_MASK 0x38
#define MC_HUB_WDP_WTM_CNTL__GROUP1_DECREMENT__SHIFT 0x3
#define MC_HUB_WDP_WTM_CNTL__GROUP2_DECREMENT_MASK 0x1c0
#define MC_HUB_WDP_WTM_CNTL__GROUP2_DECREMENT__SHIFT 0x6
#define MC_HUB_WDP_WTM_CNTL__GROUP3_DECREMENT_MASK 0xe00
#define MC_HUB_WDP_WTM_CNTL__GROUP3_DECREMENT__SHIFT 0x9
#define MC_HUB_WDP_WTM_CNTL__GROUP4_DECREMENT_MASK 0x7000
#define MC_HUB_WDP_WTM_CNTL__GROUP4_DECREMENT__SHIFT 0xc
#define MC_HUB_WDP_WTM_CNTL__GROUP5_DECREMENT_MASK 0x38000
#define MC_HUB_WDP_WTM_CNTL__GROUP5_DECREMENT__SHIFT 0xf
#define MC_HUB_WDP_WTM_CNTL__GROUP6_DECREMENT_MASK 0x1c0000
#define MC_HUB_WDP_WTM_CNTL__GROUP6_DECREMENT__SHIFT 0x12
#define MC_HUB_WDP_WTM_CNTL__GROUP7_DECREMENT_MASK 0xe00000
#define MC_HUB_WDP_WTM_CNTL__GROUP7_DECREMENT__SHIFT 0x15
#define MC_HUB_WDP_CREDITS__VM0_MASK 0xff
#define MC_HUB_WDP_CREDITS__VM0__SHIFT 0x0
#define MC_HUB_WDP_CREDITS__VM1_MASK 0xff00
#define MC_HUB_WDP_CREDITS__VM1__SHIFT 0x8
#define MC_HUB_WDP_CREDITS__STOR0_MASK 0xff0000
#define MC_HUB_WDP_CREDITS__STOR0__SHIFT 0x10
#define MC_HUB_WDP_CREDITS__STOR1_MASK 0xff000000
#define MC_HUB_WDP_CREDITS__STOR1__SHIFT 0x18
#define MC_HUB_WDP_CREDITS2__STOR0_PRI_MASK 0xff
#define MC_HUB_WDP_CREDITS2__STOR0_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS2__STOR1_PRI_MASK 0xff00
#define MC_HUB_WDP_CREDITS2__STOR1_PRI__SHIFT 0x8
#define MC_HUB_WDP_CREDITS2__VM2_MASK 0xff0000
#define MC_HUB_WDP_CREDITS2__VM2__SHIFT 0x10
#define MC_HUB_WDP_CREDITS2__VM3_MASK 0xff000000
#define MC_HUB_WDP_CREDITS2__VM3__SHIFT 0x18
#define MC_HUB_WDP_GBL0__MAXBURST_MASK 0xf
#define MC_HUB_WDP_GBL0__MAXBURST__SHIFT 0x0
#define MC_HUB_WDP_GBL0__LAZY_TIMER_MASK 0xf0
#define MC_HUB_WDP_GBL0__LAZY_TIMER__SHIFT 0x4
#define MC_HUB_WDP_GBL0__STALL_THRESHOLD_MASK 0xff00
#define MC_HUB_WDP_GBL0__STALL_THRESHOLD__SHIFT 0x8
#define MC_HUB_WDP_GBL0__STALL_MODE_MASK 0x10000
#define MC_HUB_WDP_GBL0__STALL_MODE__SHIFT 0x10
#define MC_HUB_WDP_GBL0__STALL_THRESHOLD_PRI_MASK 0x1fe0000
#define MC_HUB_WDP_GBL0__STALL_THRESHOLD_PRI__SHIFT 0x11
#define MC_HUB_WDP_GBL0__STALL_THRESHOLD_URG_MASK 0xfe000000
#define MC_HUB_WDP_GBL0__STALL_THRESHOLD_URG__SHIFT 0x19
#define MC_HUB_WDP_GBL1__MAXBURST_MASK 0xf
#define MC_HUB_WDP_GBL1__MAXBURST__SHIFT 0x0
#define MC_HUB_WDP_GBL1__LAZY_TIMER_MASK 0xf0
#define MC_HUB_WDP_GBL1__LAZY_TIMER__SHIFT 0x4
#define MC_HUB_WDP_GBL1__STALL_THRESHOLD_MASK 0xff00
#define MC_HUB_WDP_GBL1__STALL_THRESHOLD__SHIFT 0x8
#define MC_HUB_WDP_GBL1__STALL_MODE_MASK 0x10000
#define MC_HUB_WDP_GBL1__STALL_MODE__SHIFT 0x10
#define MC_HUB_WDP_GBL1__STALL_THRESHOLD_PRI_MASK 0x1fe0000
#define MC_HUB_WDP_GBL1__STALL_THRESHOLD_PRI__SHIFT 0x11
#define MC_HUB_WDP_GBL1__STALL_THRESHOLD_URG_MASK 0xfe000000
#define MC_HUB_WDP_GBL1__STALL_THRESHOLD_URG__SHIFT 0x19
#define MC_HUB_WDP_CREDITS3__STOR0_URG_MASK 0xff
#define MC_HUB_WDP_CREDITS3__STOR0_URG__SHIFT 0x0
#define MC_HUB_WDP_CREDITS3__STOR1_URG_MASK 0xff00
#define MC_HUB_WDP_CREDITS3__STOR1_URG__SHIFT 0x8
#define MC_HUB_RDREQ_CREDITS__VM0_MASK 0xff
#define MC_HUB_RDREQ_CREDITS__VM0__SHIFT 0x0
#define MC_HUB_RDREQ_CREDITS__VM1_MASK 0xff00
#define MC_HUB_RDREQ_CREDITS__VM1__SHIFT 0x8
#define MC_HUB_RDREQ_CREDITS__STOR0_MASK 0xff0000
#define MC_HUB_RDREQ_CREDITS__STOR0__SHIFT 0x10
#define MC_HUB_RDREQ_CREDITS__STOR1_MASK 0xff000000
#define MC_HUB_RDREQ_CREDITS__STOR1__SHIFT 0x18
#define MC_HUB_RDREQ_CREDITS2__STOR0_PRI_MASK 0xff
#define MC_HUB_RDREQ_CREDITS2__STOR0_PRI__SHIFT 0x0
#define MC_HUB_RDREQ_CREDITS2__STOR1_PRI_MASK 0xff00
#define MC_HUB_RDREQ_CREDITS2__STOR1_PRI__SHIFT 0x8
#define MC_HUB_SHARED_DAGB_DLY__DLY_MASK 0x3f
#define MC_HUB_SHARED_DAGB_DLY__DLY__SHIFT 0x0
#define MC_HUB_SHARED_DAGB_DLY__CLI_MASK 0x3f0000
#define MC_HUB_SHARED_DAGB_DLY__CLI__SHIFT 0x10
#define MC_HUB_SHARED_DAGB_DLY__POS_MASK 0x1f000000
#define MC_HUB_SHARED_DAGB_DLY__POS__SHIFT 0x18
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_GFX_READ_MASK 0x1
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_GFX_READ__SHIFT 0x0
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_GFX_WRITE_MASK 0x2
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_GFX_WRITE__SHIFT 0x1
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_RLC_READ_MASK 0x4
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_RLC_READ__SHIFT 0x2
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_RLC_WRITE_MASK 0x8
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_RLC_WRITE__SHIFT 0x3
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA0_READ_MASK 0x10
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA0_READ__SHIFT 0x4
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA0_WRITE_MASK 0x20
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA0_WRITE__SHIFT 0x5
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA1_READ_MASK 0x40
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA1_READ__SHIFT 0x6
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA1_WRITE_MASK 0x80
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA1_WRITE__SHIFT 0x7
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_DISP_READ_MASK 0x100
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_DISP_READ__SHIFT 0x8
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_DISP_WRITE_MASK 0x200
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_DISP_WRITE__SHIFT 0x9
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_UVD_READ_MASK 0x400
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_UVD_READ__SHIFT 0xa
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_UVD_WRITE_MASK 0x800
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_UVD_WRITE__SHIFT 0xb
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SMU_READ_MASK 0x1000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SMU_READ__SHIFT 0xc
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SMU_WRITE_MASK 0x2000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SMU_WRITE__SHIFT 0xd
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_HDP_READ_MASK 0x4000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_HDP_READ__SHIFT 0xe
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_HDP_WRITE_MASK 0x8000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_HDP_WRITE__SHIFT 0xf
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_OTH_READ_MASK 0x10000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_OTH_READ__SHIFT 0x10
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_OTH_WRITE_MASK 0x20000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_OTH_WRITE__SHIFT 0x11
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VMC_READ_MASK 0x40000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VMC_READ__SHIFT 0x12
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VMC_WRITE_MASK 0x80000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VMC_WRITE__SHIFT 0x13
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VCE_READ_MASK 0x100000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VCE_READ__SHIFT 0x14
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VCE_WRITE_MASK 0x200000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VCE_WRITE__SHIFT 0x15
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ACP_READ_MASK 0x400000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ACP_READ__SHIFT 0x16
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ACP_WRITE_MASK 0x800000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ACP_WRITE__SHIFT 0x17
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SAMMSP_READ_MASK 0x1000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SAMMSP_READ__SHIFT 0x18
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SAMMSP_WRITE_MASK 0x2000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SAMMSP_WRITE__SHIFT 0x19
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_XDMA_READ_MASK 0x4000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_XDMA_READ__SHIFT 0x1a
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_XDMA_WRITE_MASK 0x8000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_XDMA_WRITE__SHIFT 0x1b
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ISP_READ_MASK 0x10000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ISP_READ__SHIFT 0x1c
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ISP_WRITE_MASK 0x20000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ISP_WRITE__SHIFT 0x1d
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VP8_READ_MASK 0x40000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VP8_READ__SHIFT 0x1e
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VP8_WRITE_MASK 0x80000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VP8_WRITE__SHIFT 0x1f
#define MC_HUB_RDREQ_DMIF_LIMIT__ENABLE_MASK 0x3
#define MC_HUB_RDREQ_DMIF_LIMIT__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_DMIF_LIMIT__LIMIT_COUNT_MASK 0x7c
#define MC_HUB_RDREQ_DMIF_LIMIT__LIMIT_COUNT__SHIFT 0x2
#define MC_HUB_RDREQ_ACPG_LIMIT__ENABLE_MASK 0x3
#define MC_HUB_RDREQ_ACPG_LIMIT__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ACPG_LIMIT__LIMIT_COUNT_MASK 0x7c
#define MC_HUB_RDREQ_ACPG_LIMIT__LIMIT_COUNT__SHIFT 0x2
#define MC_HUB_WDP_BYPASS_GBL0__ENABLE_MASK 0x1
#define MC_HUB_WDP_BYPASS_GBL0__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_BYPASS_GBL0__CID1_MASK 0x1fe
#define MC_HUB_WDP_BYPASS_GBL0__CID1__SHIFT 0x1
#define MC_HUB_WDP_BYPASS_GBL0__CID2_MASK 0x1fe00
#define MC_HUB_WDP_BYPASS_GBL0__CID2__SHIFT 0x9
#define MC_HUB_WDP_BYPASS_GBL0__HDP_PRIORITY_TIME_MASK 0xfe0000
#define MC_HUB_WDP_BYPASS_GBL0__HDP_PRIORITY_TIME__SHIFT 0x11
#define MC_HUB_WDP_BYPASS_GBL0__OTH_PRIORITY_TIME_MASK 0x7f000000
#define MC_HUB_WDP_BYPASS_GBL0__OTH_PRIORITY_TIME__SHIFT 0x18
#define MC_HUB_WDP_BYPASS_GBL1__ENABLE_MASK 0x1
#define MC_HUB_WDP_BYPASS_GBL1__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_BYPASS_GBL1__CID1_MASK 0x1fe
#define MC_HUB_WDP_BYPASS_GBL1__CID1__SHIFT 0x1
#define MC_HUB_WDP_BYPASS_GBL1__CID2_MASK 0x1fe00
#define MC_HUB_WDP_BYPASS_GBL1__CID2__SHIFT 0x9
#define MC_HUB_WDP_BYPASS_GBL1__HDP_PRIORITY_TIME_MASK 0xfe0000
#define MC_HUB_WDP_BYPASS_GBL1__HDP_PRIORITY_TIME__SHIFT 0x11
#define MC_HUB_WDP_BYPASS_GBL1__OTH_PRIORITY_TIME_MASK 0x7f000000
#define MC_HUB_WDP_BYPASS_GBL1__OTH_PRIORITY_TIME__SHIFT 0x18
#define MC_HUB_RDREQ_BYPASS_GBL0__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_BYPASS_GBL0__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_BYPASS_GBL0__CID1_MASK 0x1fe
#define MC_HUB_RDREQ_BYPASS_GBL0__CID1__SHIFT 0x1
#define MC_HUB_RDREQ_BYPASS_GBL0__CID2_MASK 0x1fe00
#define MC_HUB_RDREQ_BYPASS_GBL0__CID2__SHIFT 0x9
#define MC_HUB_WDP_SH2__ENABLE_MASK 0x1
#define MC_HUB_WDP_SH2__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SH2__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SH2__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SH2__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SH2__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SH2__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SH2__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SH2__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SH2__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SH2__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SH2__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SH2__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SH2__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SH2__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SH2__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SH2__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SH2__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SH2__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SH2__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_SH3__ENABLE_MASK 0x1
#define MC_HUB_WDP_SH3__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SH3__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SH3__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SH3__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SH3__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SH3__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SH3__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SH3__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SH3__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SH3__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SH3__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SH3__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SH3__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SH3__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SH3__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SH3__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SH3__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SH3__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SH3__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_GFX_ATOMIC_MASK 0x1
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_GFX_ATOMIC__SHIFT 0x0
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_RLC_ATOMIC_MASK 0x2
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_RLC_ATOMIC__SHIFT 0x1
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_SDMA0_ATOMIC_MASK 0x4
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_SDMA0_ATOMIC__SHIFT 0x2
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_SDMA1_ATOMIC_MASK 0x8
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_SDMA1_ATOMIC__SHIFT 0x3
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_DISP_ATOMIC_MASK 0x10
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_DISP_ATOMIC__SHIFT 0x4
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_UVD_ATOMIC_MASK 0x20
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_UVD_ATOMIC__SHIFT 0x5
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_SMU_ATOMIC_MASK 0x40
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_SMU_ATOMIC__SHIFT 0x6
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_HDP_ATOMIC_MASK 0x80
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_HDP_ATOMIC__SHIFT 0x7
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_OTH_ATOMIC_MASK 0x100
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_OTH_ATOMIC__SHIFT 0x8
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VMC_ATOMIC_MASK 0x200
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VMC_ATOMIC__SHIFT 0x9
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VCE_ATOMIC_MASK 0x400
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VCE_ATOMIC__SHIFT 0xa
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_ACP_ATOMIC_MASK 0x800
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_ACP_ATOMIC__SHIFT 0xb
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_SAMMSP_ATOMIC_MASK 0x1000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_SAMMSP_ATOMIC__SHIFT 0xc
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_XDMA_ATOMIC_MASK 0x2000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_XDMA_ATOMIC__SHIFT 0xd
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_ISP_ATOMIC_MASK 0x4000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_ISP_ATOMIC__SHIFT 0xe
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VP8_ATOMIC_MASK 0x8000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VP8_ATOMIC__SHIFT 0xf
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VIN0_READ_MASK 0x10000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VIN0_READ__SHIFT 0x10
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VIN0_WRITE_MASK 0x20000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VIN0_WRITE__SHIFT 0x11
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VIN0_ATOMIC_MASK 0x40000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_VIN0_ATOMIC__SHIFT 0x12
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_TLS_READ_MASK 0x80000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_TLS_READ__SHIFT 0x13
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_TLS_WRITE_MASK 0x100000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_TLS_WRITE__SHIFT 0x14
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_TLS_ATOMIC_MASK 0x200000
#define MC_HUB_MISC_ATOMIC_IDLE_STATUS__OUTSTANDING_TLS_ATOMIC__SHIFT 0x15
#define MC_HUB_WDP_VIN0__ENABLE_MASK 0x1
#define MC_HUB_WDP_VIN0__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VIN0__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VIN0__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VIN0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VIN0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VIN0__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VIN0__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VIN0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VIN0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VIN0__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VIN0__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VIN0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VIN0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VIN0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VIN0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_VIN0__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_VIN0__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_VIN0__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_VIN0__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_RDREQ_MCDW__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDW__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDW__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDW__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDW__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDW__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDW__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDW__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDW__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDW__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDW__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDW__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDW__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDW__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDW__MED_CREDITS_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDW__MED_CREDITS__SHIFT 0x19
#define MC_HUB_RDREQ_MCDX__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDX__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDX__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDX__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDX__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDX__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDX__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDX__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDX__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDX__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDX__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDX__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDX__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDX__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDX__MED_CREDITS_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDX__MED_CREDITS__SHIFT 0x19
#define MC_HUB_RDREQ_MCDY__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDY__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDY__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDY__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDY__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDY__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDY__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDY__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDY__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDY__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDY__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDY__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDY__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDY__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDY__MED_CREDITS_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDY__MED_CREDITS__SHIFT 0x19
#define MC_HUB_RDREQ_MCDZ__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDZ__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDZ__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDZ__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDZ__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDZ__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDZ__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDZ__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDZ__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDZ__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDZ__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDZ__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDZ__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDZ__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDZ__MED_CREDITS_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDZ__MED_CREDITS__SHIFT 0x19
#define MC_HUB_RDREQ_SIP__ASK_CREDITS_MASK 0x7f
#define MC_HUB_RDREQ_SIP__ASK_CREDITS__SHIFT 0x0
#define MC_HUB_RDREQ_SIP__MED_CREDIT_SEL_MASK 0x80
#define MC_HUB_RDREQ_SIP__MED_CREDIT_SEL__SHIFT 0x7
#define MC_HUB_RDREQ_SIP__DISPLAY_CREDITS_MASK 0x7f00
#define MC_HUB_RDREQ_SIP__DISPLAY_CREDITS__SHIFT 0x8
#define MC_HUB_RDREQ_GBL0__STALL_THRESHOLD_MASK 0xff
#define MC_HUB_RDREQ_GBL0__STALL_THRESHOLD__SHIFT 0x0
#define MC_HUB_RDREQ_GBL0__STALL_THRESHOLD_PRI_MASK 0xff00
#define MC_HUB_RDREQ_GBL0__STALL_THRESHOLD_PRI__SHIFT 0x8
#define MC_HUB_RDREQ_GBL1__STALL_THRESHOLD_MASK 0xff
#define MC_HUB_RDREQ_GBL1__STALL_THRESHOLD__SHIFT 0x0
#define MC_HUB_RDREQ_GBL1__STALL_THRESHOLD_PRI_MASK 0xff00
#define MC_HUB_RDREQ_GBL1__STALL_THRESHOLD_PRI__SHIFT 0x8
#define MC_HUB_RDREQ_SMU__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SMU__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SMU__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SMU__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SMU__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SMU__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SMU__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SMU__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SMU__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SMU__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SMU__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SMU__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SMU__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SMU__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SMU__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SMU__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_SMU__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_SMU__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_SDMA0__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SDMA0__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SDMA0__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SDMA0__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SDMA0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SDMA0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SDMA0__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SDMA0__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SDMA0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SDMA0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SDMA0__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SDMA0__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SDMA0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SDMA0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SDMA0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SDMA0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_SDMA0__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_SDMA0__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_HDP__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_HDP__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_HDP__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_HDP__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_HDP__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_HDP__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_HDP__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_HDP__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_HDP__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_HDP__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_HDP__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_HDP__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_HDP__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_HDP__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_HDP__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_HDP__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_HDP__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_HDP__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_SDMA1__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SDMA1__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SDMA1__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SDMA1__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SDMA1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SDMA1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SDMA1__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SDMA1__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SDMA1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SDMA1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SDMA1__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SDMA1__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SDMA1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SDMA1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SDMA1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SDMA1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_SDMA1__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_SDMA1__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_RLC__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_RLC__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_RLC__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_RLC__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_RLC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_RLC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_RLC__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_RLC__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_RLC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_RLC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_RLC__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_RLC__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_RLC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_RLC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_RLC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_RLC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_RLC__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_RLC__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_SEM__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SEM__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SEM__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SEM__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SEM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SEM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SEM__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SEM__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SEM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SEM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SEM__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SEM__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SEM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SEM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SEM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SEM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_SEM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_SEM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_VCE0__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VCE0__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VCE0__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VCE0__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VCE0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VCE0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VCE0__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VCE0__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VCE0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VCE0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VCE0__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VCE0__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VCE0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VCE0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VCE0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VCE0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VCE0__VM_BYPASS_MASK 0x10000
#define MC_HUB_RDREQ_VCE0__VM_BYPASS__SHIFT 0x10
#define MC_HUB_RDREQ_VCE0__BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_RDREQ_VCE0__BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_RDREQ_UMC__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_UMC__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_UMC__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_UMC__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_UMC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_UMC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_UMC__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_UMC__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_UMC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_UMC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_UMC__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_UMC__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_UMC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_UMC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_UMC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_UMC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_UMC__VM_BYPASS_MASK 0x10000
#define MC_HUB_RDREQ_UMC__VM_BYPASS__SHIFT 0x10
#define MC_HUB_RDREQ_UMC__BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_RDREQ_UMC__BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_RDREQ_UVD__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_UVD__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_UVD__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_UVD__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_UVD__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_UVD__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_UVD__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_UVD__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_UVD__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_UVD__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_UVD__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_UVD__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_UVD__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_UVD__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_UVD__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_UVD__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_UVD__VM_BYPASS_MASK 0x10000
#define MC_HUB_RDREQ_UVD__VM_BYPASS__SHIFT 0x10
#define MC_HUB_RDREQ_UVD__BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_RDREQ_UVD__BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_RDREQ_TLS__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_TLS__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_TLS__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_TLS__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_TLS__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_TLS__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_TLS__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_TLS__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_TLS__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_TLS__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_TLS__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_TLS__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_TLS__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_TLS__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_TLS__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_TLS__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_TLS__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_TLS__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_DMIF__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_DMIF__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_DMIF__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_DMIF__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_DMIF__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_DMIF__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_DMIF__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_DMIF__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_DMIF__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_DMIF__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_DMIF__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_DMIF__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_DMIF__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_DMIF__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_DMIF__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_DMIF__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_DMIF__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_DMIF__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_MCIF__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCIF__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCIF__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_MCIF__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_MCIF__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_MCIF__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_MCIF__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_MCIF__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_MCIF__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_MCIF__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_MCIF__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_MCIF__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_MCIF__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_MCIF__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_MCIF__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_MCIF__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_MCIF__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_MCIF__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_VMC__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VMC__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VMC__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VMC__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VMC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VMC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VMC__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VMC__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VMC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VMC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VMC__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VMC__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VMC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VMC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VMC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VMC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VMC__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_VMC__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_VCEU0__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VCEU0__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VCEU0__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VCEU0__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VCEU0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VCEU0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VCEU0__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VCEU0__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VCEU0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VCEU0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VCEU0__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VCEU0__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VCEU0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VCEU0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VCEU0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VCEU0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VCEU0__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_VCEU0__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_MCDW__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDW__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDW__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDW__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDW__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDW__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDW__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDW__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDW__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDW__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDW__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDW__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDW__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDW__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDW__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDW__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDX__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDX__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDX__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDX__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDX__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDX__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDX__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDX__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDX__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDX__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDX__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDX__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDX__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDX__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDX__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDX__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDY__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDY__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDY__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDY__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDY__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDY__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDY__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDY__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDY__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDY__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDY__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDY__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDY__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDY__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDY__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDY__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDZ__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDZ__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDZ__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDZ__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDZ__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDZ__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDZ__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDZ__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDZ__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDZ__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDZ__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDZ__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDZ__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDZ__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDZ__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDZ__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_SIP__STALL_MODE_MASK 0x3
#define MC_HUB_WDP_SIP__STALL_MODE__SHIFT 0x0
#define MC_HUB_WDP_SIP__ASK_CREDITS_MASK 0x1fc
#define MC_HUB_WDP_SIP__ASK_CREDITS__SHIFT 0x2
#define MC_HUB_WDP_SDMA1__ENABLE_MASK 0x1
#define MC_HUB_WDP_SDMA1__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SDMA1__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SDMA1__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SDMA1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SDMA1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SDMA1__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SDMA1__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SDMA1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SDMA1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SDMA1__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SDMA1__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SDMA1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SDMA1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SDMA1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SDMA1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SDMA1__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SDMA1__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SDMA1__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SDMA1__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_SH0__ENABLE_MASK 0x1
#define MC_HUB_WDP_SH0__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SH0__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SH0__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SH0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SH0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SH0__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SH0__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SH0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SH0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SH0__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SH0__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SH0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SH0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SH0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SH0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SH0__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SH0__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SH0__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SH0__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_MCIF__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCIF__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCIF__PRESCALE_MASK 0x6
#define MC_HUB_WDP_MCIF__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_MCIF__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_MCIF__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_MCIF__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_MCIF__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_MCIF__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_MCIF__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_MCIF__MAXBURST_MASK 0x780
#define MC_HUB_WDP_MCIF__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_MCIF__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_MCIF__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_MCIF__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_MCIF__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_MCIF__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_MCIF__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_MCIF__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_MCIF__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_VCE0__ENABLE_MASK 0x1
#define MC_HUB_WDP_VCE0__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VCE0__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VCE0__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VCE0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VCE0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VCE0__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VCE0__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VCE0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VCE0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VCE0__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VCE0__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VCE0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VCE0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VCE0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VCE0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_VCE0__VM_BYPASS_MASK 0x10000
#define MC_HUB_WDP_VCE0__VM_BYPASS__SHIFT 0x10
#define MC_HUB_WDP_VCE0__BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_VCE0__BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_VCE0__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x40000
#define MC_HUB_WDP_VCE0__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x12
#define MC_HUB_WDP_XDP__ENABLE_MASK 0x1
#define MC_HUB_WDP_XDP__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_XDP__PRESCALE_MASK 0x6
#define MC_HUB_WDP_XDP__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_XDP__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_XDP__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_XDP__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_XDP__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_XDP__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_XDP__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_XDP__MAXBURST_MASK 0x780
#define MC_HUB_WDP_XDP__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_XDP__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_XDP__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_XDP__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_XDP__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_XDP__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_XDP__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_XDP__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_XDP__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_IH__ENABLE_MASK 0x1
#define MC_HUB_WDP_IH__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_IH__PRESCALE_MASK 0x6
#define MC_HUB_WDP_IH__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_IH__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_IH__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_IH__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_IH__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_IH__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_IH__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_IH__MAXBURST_MASK 0x780
#define MC_HUB_WDP_IH__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_IH__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_IH__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_IH__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_IH__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_IH__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_IH__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_IH__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_IH__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_RLC__ENABLE_MASK 0x1
#define MC_HUB_WDP_RLC__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_RLC__PRESCALE_MASK 0x6
#define MC_HUB_WDP_RLC__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_RLC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_RLC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_RLC__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_RLC__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_RLC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_RLC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_RLC__MAXBURST_MASK 0x780
#define MC_HUB_WDP_RLC__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_RLC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_RLC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_RLC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_RLC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_RLC__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_RLC__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_RLC__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_RLC__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_SEM__ENABLE_MASK 0x1
#define MC_HUB_WDP_SEM__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SEM__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SEM__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SEM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SEM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SEM__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SEM__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SEM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SEM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SEM__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SEM__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SEM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SEM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SEM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SEM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SEM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SEM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SEM__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SEM__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_SMU__ENABLE_MASK 0x1
#define MC_HUB_WDP_SMU__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SMU__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SMU__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SMU__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SMU__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SMU__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SMU__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SMU__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SMU__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SMU__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SMU__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SMU__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SMU__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SMU__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SMU__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SMU__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SMU__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SMU__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SMU__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_SH1__ENABLE_MASK 0x1
#define MC_HUB_WDP_SH1__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SH1__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SH1__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SH1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SH1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SH1__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SH1__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SH1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SH1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SH1__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SH1__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SH1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SH1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SH1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SH1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SH1__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SH1__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SH1__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SH1__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_UMC__ENABLE_MASK 0x1
#define MC_HUB_WDP_UMC__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_UMC__PRESCALE_MASK 0x6
#define MC_HUB_WDP_UMC__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_UMC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_UMC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_UMC__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_UMC__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_UMC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_UMC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_UMC__MAXBURST_MASK 0x780
#define MC_HUB_WDP_UMC__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_UMC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_UMC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_UMC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_UMC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_UMC__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_UMC__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_UMC__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_UMC__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_UVD__ENABLE_MASK 0x1
#define MC_HUB_WDP_UVD__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_UVD__PRESCALE_MASK 0x6
#define MC_HUB_WDP_UVD__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_UVD__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_UVD__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_UVD__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_UVD__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_UVD__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_UVD__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_UVD__MAXBURST_MASK 0x780
#define MC_HUB_WDP_UVD__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_UVD__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_UVD__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_UVD__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_UVD__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_UVD__VM_BYPASS_MASK 0x10000
#define MC_HUB_WDP_UVD__VM_BYPASS__SHIFT 0x10
#define MC_HUB_WDP_UVD__BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_UVD__BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_UVD__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x40000
#define MC_HUB_WDP_UVD__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x12
#define MC_HUB_WDP_HDP__ENABLE_MASK 0x1
#define MC_HUB_WDP_HDP__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_HDP__PRESCALE_MASK 0x6
#define MC_HUB_WDP_HDP__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_HDP__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_HDP__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_HDP__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_HDP__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_HDP__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_HDP__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_HDP__MAXBURST_MASK 0x780
#define MC_HUB_WDP_HDP__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_HDP__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_HDP__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_HDP__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_HDP__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_HDP__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_HDP__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_HDP__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_HDP__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_SDMA0__ENABLE_MASK 0x1
#define MC_HUB_WDP_SDMA0__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SDMA0__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SDMA0__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SDMA0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SDMA0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SDMA0__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SDMA0__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SDMA0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SDMA0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SDMA0__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SDMA0__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SDMA0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SDMA0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SDMA0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SDMA0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SDMA0__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SDMA0__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SDMA0__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SDMA0__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WRRET_MCDW__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDW__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDW__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDW__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDX__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDX__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDX__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDX__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDY__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDY__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDY__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDY__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDZ__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDZ__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDZ__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDZ__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WDP_VCEU0__ENABLE_MASK 0x1
#define MC_HUB_WDP_VCEU0__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VCEU0__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VCEU0__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VCEU0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VCEU0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VCEU0__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VCEU0__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VCEU0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VCEU0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VCEU0__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VCEU0__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VCEU0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VCEU0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VCEU0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VCEU0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_VCEU0__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_VCEU0__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_VCEU0__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_VCEU0__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_XDMAM__ENABLE_MASK 0x1
#define MC_HUB_WDP_XDMAM__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_XDMAM__PRESCALE_MASK 0x6
#define MC_HUB_WDP_XDMAM__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_XDMAM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_XDMAM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_XDMAM__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_XDMAM__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_XDMAM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_XDMAM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_XDMAM__MAXBURST_MASK 0x780
#define MC_HUB_WDP_XDMAM__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_XDMAM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_XDMAM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_XDMAM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_XDMAM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_XDMAM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_XDMAM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_XDMAM__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_XDMAM__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_XDMA__ENABLE_MASK 0x1
#define MC_HUB_WDP_XDMA__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_XDMA__PRESCALE_MASK 0x6
#define MC_HUB_WDP_XDMA__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_XDMA__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_XDMA__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_XDMA__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_XDMA__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_XDMA__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_XDMA__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_XDMA__MAXBURST_MASK 0x780
#define MC_HUB_WDP_XDMA__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_XDMA__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_XDMA__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_XDMA__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_XDMA__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_XDMA__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_XDMA__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_XDMA__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_XDMA__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_RDREQ_XDMAM__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_XDMAM__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_XDMAM__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_XDMAM__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_XDMAM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_XDMAM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_XDMAM__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_XDMAM__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_XDMAM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_XDMAM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_XDMAM__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_XDMAM__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_XDMAM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_XDMAM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_XDMAM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_XDMAM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_XDMAM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_XDMAM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_ACPG__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_ACPG__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ACPG__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_ACPG__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_ACPG__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_ACPG__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_ACPG__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_ACPG__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_ACPG__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_ACPG__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_ACPG__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_ACPG__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_ACPG__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_ACPG__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_ACPG__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_ACPG__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_ACPG__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_ACPG__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_ACPG__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_RDREQ_ACPG__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_RDREQ_ACPG__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_RDREQ_ACPG__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_RDREQ_ACPG__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_RDREQ_ACPG__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_RDREQ_ACPO__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_ACPO__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ACPO__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_ACPO__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_ACPO__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_ACPO__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_ACPO__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_ACPO__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_ACPO__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_ACPO__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_ACPO__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_ACPO__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_ACPO__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_ACPO__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_ACPO__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_ACPO__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_ACPO__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_ACPO__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_ACPO__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_RDREQ_ACPO__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_RDREQ_ACPO__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_RDREQ_ACPO__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_RDREQ_ACPO__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_RDREQ_ACPO__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_RDREQ_SAMMSP__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SAMMSP__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SAMMSP__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SAMMSP__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SAMMSP__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SAMMSP__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SAMMSP__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SAMMSP__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SAMMSP__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SAMMSP__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SAMMSP__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SAMMSP__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SAMMSP__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SAMMSP__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SAMMSP__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SAMMSP__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_SAMMSP__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_SAMMSP__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_VP8__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VP8__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VP8__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VP8__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VP8__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VP8__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VP8__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VP8__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VP8__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VP8__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VP8__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VP8__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VP8__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VP8__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VP8__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VP8__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VP8__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_VP8__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_VP8U__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VP8U__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VP8U__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VP8U__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VP8U__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VP8U__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VP8U__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VP8U__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VP8U__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VP8U__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VP8U__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VP8U__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VP8U__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VP8U__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VP8U__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VP8U__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VP8U__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_VP8U__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ACPG__ENABLE_MASK 0x1
#define MC_HUB_WDP_ACPG__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_ACPG__PRESCALE_MASK 0x6
#define MC_HUB_WDP_ACPG__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_ACPG__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_ACPG__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_ACPG__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_ACPG__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_ACPG__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_ACPG__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_ACPG__MAXBURST_MASK 0x780
#define MC_HUB_WDP_ACPG__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_ACPG__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_ACPG__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_ACPG__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_ACPG__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ACPG__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_ACPG__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ACPG__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_ACPG__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_ACPG__PRIORITY_DISABLE_MASK 0x40000
#define MC_HUB_WDP_ACPG__PRIORITY_DISABLE__SHIFT 0x12
#define MC_HUB_WDP_ACPG__STALL_FILTER_ENABLE_MASK 0x80000
#define MC_HUB_WDP_ACPG__STALL_FILTER_ENABLE__SHIFT 0x13
#define MC_HUB_WDP_ACPG__STALL_THRESHOLD_MASK 0x3f00000
#define MC_HUB_WDP_ACPG__STALL_THRESHOLD__SHIFT 0x14
#define MC_HUB_WDP_ACPO__ENABLE_MASK 0x1
#define MC_HUB_WDP_ACPO__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_ACPO__PRESCALE_MASK 0x6
#define MC_HUB_WDP_ACPO__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_ACPO__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_ACPO__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_ACPO__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_ACPO__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_ACPO__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_ACPO__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_ACPO__MAXBURST_MASK 0x780
#define MC_HUB_WDP_ACPO__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_ACPO__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_ACPO__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_ACPO__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_ACPO__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ACPO__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_ACPO__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ACPO__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_ACPO__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_ACPO__PRIORITY_DISABLE_MASK 0x40000
#define MC_HUB_WDP_ACPO__PRIORITY_DISABLE__SHIFT 0x12
#define MC_HUB_WDP_ACPO__STALL_FILTER_ENABLE_MASK 0x80000
#define MC_HUB_WDP_ACPO__STALL_FILTER_ENABLE__SHIFT 0x13
#define MC_HUB_WDP_ACPO__STALL_THRESHOLD_MASK 0x3f00000
#define MC_HUB_WDP_ACPO__STALL_THRESHOLD__SHIFT 0x14
#define MC_HUB_WDP_SAMMSP__ENABLE_MASK 0x1
#define MC_HUB_WDP_SAMMSP__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SAMMSP__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SAMMSP__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SAMMSP__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SAMMSP__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SAMMSP__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SAMMSP__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SAMMSP__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SAMMSP__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SAMMSP__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SAMMSP__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SAMMSP__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SAMMSP__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SAMMSP__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SAMMSP__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SAMMSP__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_SAMMSP__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_SAMMSP__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_SAMMSP__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_VP8__ENABLE_MASK 0x1
#define MC_HUB_WDP_VP8__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VP8__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VP8__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VP8__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VP8__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VP8__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VP8__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VP8__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VP8__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VP8__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VP8__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VP8__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VP8__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VP8__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VP8__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_VP8__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_VP8__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_VP8__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_VP8__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_VP8U__ENABLE_MASK 0x1
#define MC_HUB_WDP_VP8U__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VP8U__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VP8U__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VP8U__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VP8U__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VP8U__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VP8U__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VP8U__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VP8U__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VP8U__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VP8U__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VP8U__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VP8U__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VP8U__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VP8U__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_VP8U__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_VP8U__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_VP8U__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_VP8U__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_RDREQ_ISP_SPM__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_ISP_SPM__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ISP_SPM__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_ISP_SPM__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_ISP_SPM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_ISP_SPM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_ISP_SPM__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_ISP_SPM__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_ISP_SPM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_ISP_SPM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_ISP_SPM__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_ISP_SPM__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_ISP_SPM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_ISP_SPM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_ISP_SPM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_ISP_SPM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_ISP_SPM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_ISP_SPM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_ISP_SPM__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_RDREQ_ISP_SPM__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_RDREQ_ISP_SPM__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_RDREQ_ISP_SPM__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_RDREQ_ISP_SPM__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_RDREQ_ISP_SPM__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_RDREQ_ISP_MPM__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_ISP_MPM__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ISP_MPM__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_ISP_MPM__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_ISP_MPM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_ISP_MPM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_ISP_MPM__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_ISP_MPM__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_ISP_MPM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_ISP_MPM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_ISP_MPM__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_ISP_MPM__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_ISP_MPM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_ISP_MPM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_ISP_MPM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_ISP_MPM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_ISP_MPM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_ISP_MPM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_ISP_MPM__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_RDREQ_ISP_MPM__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_RDREQ_ISP_MPM__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_RDREQ_ISP_MPM__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_RDREQ_ISP_MPM__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_RDREQ_ISP_MPM__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_RDREQ_ISP_CCPU__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_ISP_CCPU__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ISP_CCPU__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_ISP_CCPU__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_ISP_CCPU__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_ISP_CCPU__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_ISP_CCPU__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_ISP_CCPU__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_ISP_CCPU__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_ISP_CCPU__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_ISP_CCPU__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_ISP_CCPU__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_ISP_CCPU__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_ISP_CCPU__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_ISP_CCPU__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_ISP_CCPU__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_ISP_CCPU__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_ISP_CCPU__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_ISP_CCPU__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_RDREQ_ISP_CCPU__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_RDREQ_ISP_CCPU__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_RDREQ_ISP_CCPU__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_RDREQ_ISP_CCPU__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_RDREQ_ISP_CCPU__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_WDP_ISP_SPM__ENABLE_MASK 0x1
#define MC_HUB_WDP_ISP_SPM__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_ISP_SPM__PRESCALE_MASK 0x6
#define MC_HUB_WDP_ISP_SPM__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_ISP_SPM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_ISP_SPM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_ISP_SPM__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_ISP_SPM__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_ISP_SPM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_ISP_SPM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_ISP_SPM__MAXBURST_MASK 0x780
#define MC_HUB_WDP_ISP_SPM__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_ISP_SPM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_ISP_SPM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_ISP_SPM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_ISP_SPM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ISP_SPM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_ISP_SPM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ISP_SPM__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_ISP_SPM__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_ISP_SPM__PRIORITY_DISABLE_MASK 0x40000
#define MC_HUB_WDP_ISP_SPM__PRIORITY_DISABLE__SHIFT 0x12
#define MC_HUB_WDP_ISP_SPM__STALL_FILTER_ENABLE_MASK 0x80000
#define MC_HUB_WDP_ISP_SPM__STALL_FILTER_ENABLE__SHIFT 0x13
#define MC_HUB_WDP_ISP_SPM__STALL_THRESHOLD_MASK 0x3f00000
#define MC_HUB_WDP_ISP_SPM__STALL_THRESHOLD__SHIFT 0x14
#define MC_HUB_WDP_ISP_MPS__ENABLE_MASK 0x1
#define MC_HUB_WDP_ISP_MPS__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_ISP_MPS__PRESCALE_MASK 0x6
#define MC_HUB_WDP_ISP_MPS__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_ISP_MPS__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_ISP_MPS__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_ISP_MPS__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_ISP_MPS__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_ISP_MPS__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_ISP_MPS__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_ISP_MPS__MAXBURST_MASK 0x780
#define MC_HUB_WDP_ISP_MPS__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_ISP_MPS__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_ISP_MPS__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_ISP_MPS__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_ISP_MPS__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ISP_MPS__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_ISP_MPS__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ISP_MPS__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_ISP_MPS__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_ISP_MPS__PRIORITY_DISABLE_MASK 0x40000
#define MC_HUB_WDP_ISP_MPS__PRIORITY_DISABLE__SHIFT 0x12
#define MC_HUB_WDP_ISP_MPS__STALL_FILTER_ENABLE_MASK 0x80000
#define MC_HUB_WDP_ISP_MPS__STALL_FILTER_ENABLE__SHIFT 0x13
#define MC_HUB_WDP_ISP_MPS__STALL_THRESHOLD_MASK 0x3f00000
#define MC_HUB_WDP_ISP_MPS__STALL_THRESHOLD__SHIFT 0x14
#define MC_HUB_WDP_ISP_MPM__ENABLE_MASK 0x1
#define MC_HUB_WDP_ISP_MPM__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_ISP_MPM__PRESCALE_MASK 0x6
#define MC_HUB_WDP_ISP_MPM__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_ISP_MPM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_ISP_MPM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_ISP_MPM__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_ISP_MPM__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_ISP_MPM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_ISP_MPM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_ISP_MPM__MAXBURST_MASK 0x780
#define MC_HUB_WDP_ISP_MPM__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_ISP_MPM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_ISP_MPM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_ISP_MPM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_ISP_MPM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ISP_MPM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_ISP_MPM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ISP_MPM__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_ISP_MPM__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_ISP_MPM__PRIORITY_DISABLE_MASK 0x40000
#define MC_HUB_WDP_ISP_MPM__PRIORITY_DISABLE__SHIFT 0x12
#define MC_HUB_WDP_ISP_MPM__STALL_FILTER_ENABLE_MASK 0x80000
#define MC_HUB_WDP_ISP_MPM__STALL_FILTER_ENABLE__SHIFT 0x13
#define MC_HUB_WDP_ISP_MPM__STALL_THRESHOLD_MASK 0x3f00000
#define MC_HUB_WDP_ISP_MPM__STALL_THRESHOLD__SHIFT 0x14
#define MC_HUB_WDP_ISP_CCPU__ENABLE_MASK 0x1
#define MC_HUB_WDP_ISP_CCPU__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_ISP_CCPU__PRESCALE_MASK 0x6
#define MC_HUB_WDP_ISP_CCPU__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_ISP_CCPU__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_ISP_CCPU__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_ISP_CCPU__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_ISP_CCPU__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_ISP_CCPU__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_ISP_CCPU__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_ISP_CCPU__MAXBURST_MASK 0x780
#define MC_HUB_WDP_ISP_CCPU__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_ISP_CCPU__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_ISP_CCPU__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_ISP_CCPU__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_ISP_CCPU__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ISP_CCPU__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_ISP_CCPU__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ISP_CCPU__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_ISP_CCPU__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_ISP_CCPU__PRIORITY_DISABLE_MASK 0x40000
#define MC_HUB_WDP_ISP_CCPU__PRIORITY_DISABLE__SHIFT 0x12
#define MC_HUB_WDP_ISP_CCPU__STALL_FILTER_ENABLE_MASK 0x80000
#define MC_HUB_WDP_ISP_CCPU__STALL_FILTER_ENABLE__SHIFT 0x13
#define MC_HUB_WDP_ISP_CCPU__STALL_THRESHOLD_MASK 0x3f00000
#define MC_HUB_WDP_ISP_CCPU__STALL_THRESHOLD__SHIFT 0x14
#define MC_HUB_RDREQ_MCDS__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDS__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDS__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDS__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDS__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDS__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDS__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDS__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDS__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDS__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDS__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDS__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDS__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDS__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDS__MED_CREDITS_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDS__MED_CREDITS__SHIFT 0x19
#define MC_HUB_RDREQ_MCDT__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDT__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDT__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDT__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDT__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDT__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDT__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDT__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDT__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDT__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDT__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDT__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDT__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDT__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDT__MED_CREDITS_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDT__MED_CREDITS__SHIFT 0x19
#define MC_HUB_RDREQ_MCDU__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDU__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDU__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDU__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDU__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDU__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDU__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDU__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDU__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDU__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDU__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDU__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDU__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDU__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDU__MED_CREDITS_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDU__MED_CREDITS__SHIFT 0x19
#define MC_HUB_RDREQ_MCDV__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDV__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDV__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDV__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDV__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDV__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDV__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDV__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDV__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDV__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDV__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDV__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDV__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDV__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDV__MED_CREDITS_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDV__MED_CREDITS__SHIFT 0x19
#define MC_HUB_WDP_MCDS__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDS__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDS__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDS__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDS__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDS__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDS__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDS__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDS__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDS__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDS__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDS__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDS__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDS__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDS__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDS__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDT__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDT__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDT__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDT__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDT__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDT__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDT__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDT__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDT__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDT__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDT__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDT__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDT__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDT__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDT__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDT__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDU__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDU__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDU__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDU__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDU__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDU__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDU__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDU__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDU__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDU__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDU__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDU__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDU__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDU__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDU__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDU__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDV__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDV__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDV__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDV__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDV__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDV__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDV__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDV__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDV__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDV__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDV__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDV__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDV__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDV__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDV__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDV__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WRRET_MCDS__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDS__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDS__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDS__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDT__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDT__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDT__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDT__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDU__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDU__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDU__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDU__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDV__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDV__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDV__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDV__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WDP_CREDITS_MCDW__WR_PRI_MASK 0x7f
#define MC_HUB_WDP_CREDITS_MCDW__WR_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS_MCDW__WR_PRI_STALL_THRESHOLD_MASK 0x3f80
#define MC_HUB_WDP_CREDITS_MCDW__WR_PRI_STALL_THRESHOLD__SHIFT 0x7
#define MC_HUB_WDP_CREDITS_MCDW__WR_URG_MASK 0x1fc000
#define MC_HUB_WDP_CREDITS_MCDW__WR_URG__SHIFT 0xe
#define MC_HUB_WDP_CREDITS_MCDW__WR_URG_STALL_THRESHOLD_MASK 0xfe00000
#define MC_HUB_WDP_CREDITS_MCDW__WR_URG_STALL_THRESHOLD__SHIFT 0x15
#define MC_HUB_WDP_CREDITS_MCDX__WR_PRI_MASK 0x7f
#define MC_HUB_WDP_CREDITS_MCDX__WR_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS_MCDX__WR_PRI_STALL_THRESHOLD_MASK 0x3f80
#define MC_HUB_WDP_CREDITS_MCDX__WR_PRI_STALL_THRESHOLD__SHIFT 0x7
#define MC_HUB_WDP_CREDITS_MCDX__WR_URG_MASK 0x1fc000
#define MC_HUB_WDP_CREDITS_MCDX__WR_URG__SHIFT 0xe
#define MC_HUB_WDP_CREDITS_MCDX__WR_URG_STALL_THRESHOLD_MASK 0xfe00000
#define MC_HUB_WDP_CREDITS_MCDX__WR_URG_STALL_THRESHOLD__SHIFT 0x15
#define MC_HUB_WDP_CREDITS_MCDY__WR_PRI_MASK 0x7f
#define MC_HUB_WDP_CREDITS_MCDY__WR_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS_MCDY__WR_PRI_STALL_THRESHOLD_MASK 0x3f80
#define MC_HUB_WDP_CREDITS_MCDY__WR_PRI_STALL_THRESHOLD__SHIFT 0x7
#define MC_HUB_WDP_CREDITS_MCDY__WR_URG_MASK 0x1fc000
#define MC_HUB_WDP_CREDITS_MCDY__WR_URG__SHIFT 0xe
#define MC_HUB_WDP_CREDITS_MCDY__WR_URG_STALL_THRESHOLD_MASK 0xfe00000
#define MC_HUB_WDP_CREDITS_MCDY__WR_URG_STALL_THRESHOLD__SHIFT 0x15
#define MC_HUB_WDP_CREDITS_MCDZ__WR_PRI_MASK 0x7f
#define MC_HUB_WDP_CREDITS_MCDZ__WR_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS_MCDZ__WR_PRI_STALL_THRESHOLD_MASK 0x3f80
#define MC_HUB_WDP_CREDITS_MCDZ__WR_PRI_STALL_THRESHOLD__SHIFT 0x7
#define MC_HUB_WDP_CREDITS_MCDZ__WR_URG_MASK 0x1fc000
#define MC_HUB_WDP_CREDITS_MCDZ__WR_URG__SHIFT 0xe
#define MC_HUB_WDP_CREDITS_MCDZ__WR_URG_STALL_THRESHOLD_MASK 0xfe00000
#define MC_HUB_WDP_CREDITS_MCDZ__WR_URG_STALL_THRESHOLD__SHIFT 0x15
#define MC_HUB_WDP_CREDITS_MCDS__WR_PRI_MASK 0x7f
#define MC_HUB_WDP_CREDITS_MCDS__WR_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS_MCDS__WR_PRI_STALL_THRESHOLD_MASK 0x3f80
#define MC_HUB_WDP_CREDITS_MCDS__WR_PRI_STALL_THRESHOLD__SHIFT 0x7
#define MC_HUB_WDP_CREDITS_MCDS__WR_URG_MASK 0x1fc000
#define MC_HUB_WDP_CREDITS_MCDS__WR_URG__SHIFT 0xe
#define MC_HUB_WDP_CREDITS_MCDS__WR_URG_STALL_THRESHOLD_MASK 0xfe00000
#define MC_HUB_WDP_CREDITS_MCDS__WR_URG_STALL_THRESHOLD__SHIFT 0x15
#define MC_HUB_WDP_CREDITS_MCDT__WR_PRI_MASK 0x7f
#define MC_HUB_WDP_CREDITS_MCDT__WR_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS_MCDT__WR_PRI_STALL_THRESHOLD_MASK 0x3f80
#define MC_HUB_WDP_CREDITS_MCDT__WR_PRI_STALL_THRESHOLD__SHIFT 0x7
#define MC_HUB_WDP_CREDITS_MCDT__WR_URG_MASK 0x1fc000
#define MC_HUB_WDP_CREDITS_MCDT__WR_URG__SHIFT 0xe
#define MC_HUB_WDP_CREDITS_MCDT__WR_URG_STALL_THRESHOLD_MASK 0xfe00000
#define MC_HUB_WDP_CREDITS_MCDT__WR_URG_STALL_THRESHOLD__SHIFT 0x15
#define MC_HUB_WDP_CREDITS_MCDU__WR_PRI_MASK 0x7f
#define MC_HUB_WDP_CREDITS_MCDU__WR_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS_MCDU__WR_PRI_STALL_THRESHOLD_MASK 0x3f80
#define MC_HUB_WDP_CREDITS_MCDU__WR_PRI_STALL_THRESHOLD__SHIFT 0x7
#define MC_HUB_WDP_CREDITS_MCDU__WR_URG_MASK 0x1fc000
#define MC_HUB_WDP_CREDITS_MCDU__WR_URG__SHIFT 0xe
#define MC_HUB_WDP_CREDITS_MCDU__WR_URG_STALL_THRESHOLD_MASK 0xfe00000
#define MC_HUB_WDP_CREDITS_MCDU__WR_URG_STALL_THRESHOLD__SHIFT 0x15
#define MC_HUB_WDP_CREDITS_MCDV__WR_PRI_MASK 0x7f
#define MC_HUB_WDP_CREDITS_MCDV__WR_PRI__SHIFT 0x0
#define MC_HUB_WDP_CREDITS_MCDV__WR_PRI_STALL_THRESHOLD_MASK 0x3f80
#define MC_HUB_WDP_CREDITS_MCDV__WR_PRI_STALL_THRESHOLD__SHIFT 0x7
#define MC_HUB_WDP_CREDITS_MCDV__WR_URG_MASK 0x1fc000
#define MC_HUB_WDP_CREDITS_MCDV__WR_URG__SHIFT 0xe
#define MC_HUB_WDP_CREDITS_MCDV__WR_URG_STALL_THRESHOLD_MASK 0xfe00000
#define MC_HUB_WDP_CREDITS_MCDV__WR_URG_STALL_THRESHOLD__SHIFT 0x15
#define MC_HUB_WDP_BP2__RDRET_MASK 0xffff
#define MC_HUB_WDP_BP2__RDRET__SHIFT 0x0
#define MC_HUB_RDREQ_VCE1__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VCE1__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VCE1__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VCE1__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VCE1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VCE1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VCE1__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VCE1__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VCE1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VCE1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VCE1__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VCE1__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VCE1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VCE1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VCE1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VCE1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VCE1__VM_BYPASS_MASK 0x10000
#define MC_HUB_RDREQ_VCE1__VM_BYPASS__SHIFT 0x10
#define MC_HUB_RDREQ_VCE1__BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_RDREQ_VCE1__BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_RDREQ_VCEU1__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VCEU1__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VCEU1__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VCEU1__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VCEU1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VCEU1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VCEU1__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VCEU1__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VCEU1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VCEU1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VCEU1__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VCEU1__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VCEU1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VCEU1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VCEU1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VCEU1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VCEU1__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_VCEU1__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_VCE1__ENABLE_MASK 0x1
#define MC_HUB_WDP_VCE1__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VCE1__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VCE1__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VCE1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VCE1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VCE1__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VCE1__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VCE1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VCE1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VCE1__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VCE1__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VCE1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VCE1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VCE1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VCE1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_VCE1__VM_BYPASS_MASK 0x10000
#define MC_HUB_WDP_VCE1__VM_BYPASS__SHIFT 0x10
#define MC_HUB_WDP_VCE1__BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_VCE1__BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_HUB_WDP_VCE1__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x40000
#define MC_HUB_WDP_VCE1__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x12
#define MC_HUB_WDP_VCEU1__ENABLE_MASK 0x1
#define MC_HUB_WDP_VCEU1__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VCEU1__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VCEU1__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VCEU1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VCEU1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VCEU1__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VCEU1__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VCEU1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VCEU1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VCEU1__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VCEU1__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VCEU1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VCEU1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VCEU1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VCEU1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_VCEU1__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_VCEU1__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_VCEU1__URG_BYPASS_AVAIL_OVERRIDE_MASK 0x20000
#define MC_HUB_WDP_VCEU1__URG_BYPASS_AVAIL_OVERRIDE__SHIFT 0x11
#define MC_RPB_CONF__XPB_PCIE_ORDER_MASK 0x8000
#define MC_RPB_CONF__XPB_PCIE_ORDER__SHIFT 0xf
#define MC_RPB_CONF__RPB_RD_PCIE_ORDER_MASK 0x10000
#define MC_RPB_CONF__RPB_RD_PCIE_ORDER__SHIFT 0x10
#define MC_RPB_CONF__RPB_WR_PCIE_ORDER_MASK 0x20000
#define MC_RPB_CONF__RPB_WR_PCIE_ORDER__SHIFT 0x11
#define MC_RPB_IF_CONF__RPB_BIF_CREDITS_MASK 0xff
#define MC_RPB_IF_CONF__RPB_BIF_CREDITS__SHIFT 0x0
#define MC_RPB_IF_CONF__OUTSTANDING_WRRET_ASK_MASK 0xff00
#define MC_RPB_IF_CONF__OUTSTANDING_WRRET_ASK__SHIFT 0x8
#define MC_RPB_DBG1__RPB_BIF_OUTSTANDING_RD_MASK 0xff
#define MC_RPB_DBG1__RPB_BIF_OUTSTANDING_RD__SHIFT 0x0
#define MC_RPB_DBG1__RPB_BIF_OUTSTANDING_RD_32B_MASK 0xfff00
#define MC_RPB_DBG1__RPB_BIF_OUTSTANDING_RD_32B__SHIFT 0x8
#define MC_RPB_DBG1__DEBUG_BITS_MASK 0xfff00000
#define MC_RPB_DBG1__DEBUG_BITS__SHIFT 0x14
#define MC_RPB_EFF_CNTL__WR_LAZY_TIMER_MASK 0xff
#define MC_RPB_EFF_CNTL__WR_LAZY_TIMER__SHIFT 0x0
#define MC_RPB_EFF_CNTL__RD_LAZY_TIMER_MASK 0xff00
#define MC_RPB_EFF_CNTL__RD_LAZY_TIMER__SHIFT 0x8
#define MC_RPB_ARB_CNTL__WR_SWITCH_NUM_MASK 0xff
#define MC_RPB_ARB_CNTL__WR_SWITCH_NUM__SHIFT 0x0
#define MC_RPB_ARB_CNTL__RD_SWITCH_NUM_MASK 0xff00
#define MC_RPB_ARB_CNTL__RD_SWITCH_NUM__SHIFT 0x8
#define MC_RPB_ARB_CNTL__ATC_SWITCH_NUM_MASK 0xff0000
#define MC_RPB_ARB_CNTL__ATC_SWITCH_NUM__SHIFT 0x10
#define MC_RPB_BIF_CNTL__ARB_SWITCH_NUM_MASK 0xff
#define MC_RPB_BIF_CNTL__ARB_SWITCH_NUM__SHIFT 0x0
#define MC_RPB_BIF_CNTL__XPB_SWITCH_NUM_MASK 0xff00
#define MC_RPB_BIF_CNTL__XPB_SWITCH_NUM__SHIFT 0x8
#define MC_RPB_WR_SWITCH_CNTL__QUEUE0_SWITCH_NUM_MASK 0xff
#define MC_RPB_WR_SWITCH_CNTL__QUEUE0_SWITCH_NUM__SHIFT 0x0
#define MC_RPB_WR_SWITCH_CNTL__QUEUE1_SWITCH_NUM_MASK 0xff00
#define MC_RPB_WR_SWITCH_CNTL__QUEUE1_SWITCH_NUM__SHIFT 0x8
#define MC_RPB_WR_SWITCH_CNTL__QUEUE2_SWITCH_NUM_MASK 0xff0000
#define MC_RPB_WR_SWITCH_CNTL__QUEUE2_SWITCH_NUM__SHIFT 0x10
#define MC_RPB_WR_SWITCH_CNTL__QUEUE3_SWITCH_NUM_MASK 0xff000000
#define MC_RPB_WR_SWITCH_CNTL__QUEUE3_SWITCH_NUM__SHIFT 0x18
#define MC_RPB_WR_COMBINE_CNTL__WC_ENABLE_MASK 0x1
#define MC_RPB_WR_COMBINE_CNTL__WC_ENABLE__SHIFT 0x0
#define MC_RPB_WR_COMBINE_CNTL__WC_MAX_PACKET_SIZE_MASK 0x6
#define MC_RPB_WR_COMBINE_CNTL__WC_MAX_PACKET_SIZE__SHIFT 0x1
#define MC_RPB_WR_COMBINE_CNTL__WC_FLUSH_TIMER_MASK 0x78
#define MC_RPB_WR_COMBINE_CNTL__WC_FLUSH_TIMER__SHIFT 0x3
#define MC_RPB_WR_COMBINE_CNTL__WC_ALIGN_MASK 0x80
#define MC_RPB_WR_COMBINE_CNTL__WC_ALIGN__SHIFT 0x7
#define MC_RPB_RD_SWITCH_CNTL__QUEUE0_SWITCH_NUM_MASK 0xff
#define MC_RPB_RD_SWITCH_CNTL__QUEUE0_SWITCH_NUM__SHIFT 0x0
#define MC_RPB_RD_SWITCH_CNTL__QUEUE1_SWITCH_NUM_MASK 0xff00
#define MC_RPB_RD_SWITCH_CNTL__QUEUE1_SWITCH_NUM__SHIFT 0x8
#define MC_RPB_RD_SWITCH_CNTL__QUEUE2_SWITCH_NUM_MASK 0xff0000
#define MC_RPB_RD_SWITCH_CNTL__QUEUE2_SWITCH_NUM__SHIFT 0x10
#define MC_RPB_RD_SWITCH_CNTL__QUEUE3_SWITCH_NUM_MASK 0xff000000
#define MC_RPB_RD_SWITCH_CNTL__QUEUE3_SWITCH_NUM__SHIFT 0x18
#define MC_RPB_CID_QUEUE_WR__CLIENT_ID_MASK 0xff
#define MC_RPB_CID_QUEUE_WR__CLIENT_ID__SHIFT 0x0
#define MC_RPB_CID_QUEUE_WR__UPDATE_MODE_MASK 0x100
#define MC_RPB_CID_QUEUE_WR__UPDATE_MODE__SHIFT 0x8
#define MC_RPB_CID_QUEUE_WR__WRITE_QUEUE_MASK 0x600
#define MC_RPB_CID_QUEUE_WR__WRITE_QUEUE__SHIFT 0x9
#define MC_RPB_CID_QUEUE_WR__READ_QUEUE_MASK 0x1800
#define MC_RPB_CID_QUEUE_WR__READ_QUEUE__SHIFT 0xb
#define MC_RPB_CID_QUEUE_WR__UPDATE_MASK 0x2000
#define MC_RPB_CID_QUEUE_WR__UPDATE__SHIFT 0xd
#define MC_RPB_CID_QUEUE_RD__CLIENT_ID_MASK 0xff
#define MC_RPB_CID_QUEUE_RD__CLIENT_ID__SHIFT 0x0
#define MC_RPB_CID_QUEUE_RD__WRITE_QUEUE_MASK 0x300
#define MC_RPB_CID_QUEUE_RD__WRITE_QUEUE__SHIFT 0x8
#define MC_RPB_CID_QUEUE_RD__READ_QUEUE_MASK 0xc00
#define MC_RPB_CID_QUEUE_RD__READ_QUEUE__SHIFT 0xa
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_SELECT_MASK 0x3
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_RPB_PERF_COUNTER_CNTL__CLEAR_SELECTED_PERF_COUNTER_MASK 0x4
#define MC_RPB_PERF_COUNTER_CNTL__CLEAR_SELECTED_PERF_COUNTER__SHIFT 0x2
#define MC_RPB_PERF_COUNTER_CNTL__CLEAR_ALL_PERF_COUNTERS_MASK 0x8
#define MC_RPB_PERF_COUNTER_CNTL__CLEAR_ALL_PERF_COUNTERS__SHIFT 0x3
#define MC_RPB_PERF_COUNTER_CNTL__STOP_ON_COUNTER_SATURATION_MASK 0x10
#define MC_RPB_PERF_COUNTER_CNTL__STOP_ON_COUNTER_SATURATION__SHIFT 0x4
#define MC_RPB_PERF_COUNTER_CNTL__ENABLE_PERF_COUNTERS_MASK 0x1e0
#define MC_RPB_PERF_COUNTER_CNTL__ENABLE_PERF_COUNTERS__SHIFT 0x5
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_0_MASK 0x3e00
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_0__SHIFT 0x9
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_1_MASK 0x7c000
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_1__SHIFT 0xe
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_2_MASK 0xf80000
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_2__SHIFT 0x13
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_3_MASK 0x1f000000
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_3__SHIFT 0x18
#define MC_RPB_PERF_COUNTER_STATUS__PERFORMANCE_COUNTER_VALUE_MASK 0xffffffff
#define MC_RPB_PERF_COUNTER_STATUS__PERFORMANCE_COUNTER_VALUE__SHIFT 0x0
#define MC_RPB_CID_QUEUE_EX__START_MASK 0x1
#define MC_RPB_CID_QUEUE_EX__START__SHIFT 0x0
#define MC_RPB_CID_QUEUE_EX__OFFSET_MASK 0x3e
#define MC_RPB_CID_QUEUE_EX__OFFSET__SHIFT 0x1
#define MC_RPB_CID_QUEUE_EX_DATA__WRITE_ENTRIES_MASK 0xffff
#define MC_RPB_CID_QUEUE_EX_DATA__WRITE_ENTRIES__SHIFT 0x0
#define MC_RPB_CID_QUEUE_EX_DATA__READ_ENTRIES_MASK 0xffff0000
#define MC_RPB_CID_QUEUE_EX_DATA__READ_ENTRIES__SHIFT 0x10
#define MC_RPB_TCI_CNTL__TCI_ENABLE_MASK 0x1
#define MC_RPB_TCI_CNTL__TCI_ENABLE__SHIFT 0x0
#define MC_RPB_TCI_CNTL__TCI_POLICY_MASK 0x6
#define MC_RPB_TCI_CNTL__TCI_POLICY__SHIFT 0x1
#define MC_RPB_TCI_CNTL__TCI_VOL_MASK 0x8
#define MC_RPB_TCI_CNTL__TCI_VOL__SHIFT 0x3
#define MC_RPB_TCI_CNTL__TCI_VMID_MASK 0xf0
#define MC_RPB_TCI_CNTL__TCI_VMID__SHIFT 0x4
#define MC_RPB_TCI_CNTL__TCI_REQ_CREDITS_MASK 0xff00
#define MC_RPB_TCI_CNTL__TCI_REQ_CREDITS__SHIFT 0x8
#define MC_RPB_TCI_CNTL__TCI_MAX_WRITES_MASK 0xff0000
#define MC_RPB_TCI_CNTL__TCI_MAX_WRITES__SHIFT 0x10
#define MC_RPB_TCI_CNTL__TCI_MAX_READS_MASK 0xff000000
#define MC_RPB_TCI_CNTL__TCI_MAX_READS__SHIFT 0x18
#define MC_RPB_TCI_CNTL2__TCI_POLICY_MASK 0x1
#define MC_RPB_TCI_CNTL2__TCI_POLICY__SHIFT 0x0
#define MC_RPB_TCI_CNTL2__TCI_MTYPE_MASK 0x6
#define MC_RPB_TCI_CNTL2__TCI_MTYPE__SHIFT 0x1
#define MC_RPB_TCI_CNTL2__TCI_SNOOP_MASK 0x8
#define MC_RPB_TCI_CNTL2__TCI_SNOOP__SHIFT 0x3
#define MC_RPB_TCI_CNTL2__TCI_PHYSICAL_MASK 0x10
#define MC_RPB_TCI_CNTL2__TCI_PHYSICAL__SHIFT 0x4
#define MC_RPB_TCI_CNTL2__TCI_PERF_CNTR_EN_MASK 0x20
#define MC_RPB_TCI_CNTL2__TCI_PERF_CNTR_EN__SHIFT 0x5
#define MC_RPB_TCI_CNTL2__TCI_EXE_MASK 0x40
#define MC_RPB_TCI_CNTL2__TCI_EXE__SHIFT 0x6
#define MC_SHARED_CHMAP__CHAN0_MASK 0xf
#define MC_SHARED_CHMAP__CHAN0__SHIFT 0x0
#define MC_SHARED_CHMAP__CHAN1_MASK 0xf0
#define MC_SHARED_CHMAP__CHAN1__SHIFT 0x4
#define MC_SHARED_CHMAP__CHAN2_MASK 0xf00
#define MC_SHARED_CHMAP__CHAN2__SHIFT 0x8
#define MC_SHARED_CHMAP__NOOFCHAN_MASK 0xf000
#define MC_SHARED_CHMAP__NOOFCHAN__SHIFT 0xc
#define MC_SHARED_CHMAP__CHAN3_MASK 0xf0000
#define MC_SHARED_CHMAP__CHAN3__SHIFT 0x10
#define MC_SHARED_CHMAP__CHAN4_MASK 0xf00000
#define MC_SHARED_CHMAP__CHAN4__SHIFT 0x14
#define MC_SHARED_CHREMAP__CHAN0_MASK 0xf
#define MC_SHARED_CHREMAP__CHAN0__SHIFT 0x0
#define MC_SHARED_CHREMAP__CHAN1_MASK 0xf0
#define MC_SHARED_CHREMAP__CHAN1__SHIFT 0x4
#define MC_SHARED_CHREMAP__CHAN2_MASK 0xf00
#define MC_SHARED_CHREMAP__CHAN2__SHIFT 0x8
#define MC_SHARED_CHREMAP__CHAN3_MASK 0xf000
#define MC_SHARED_CHREMAP__CHAN3__SHIFT 0xc
#define MC_SHARED_CHREMAP__CHAN4_MASK 0xf0000
#define MC_SHARED_CHREMAP__CHAN4__SHIFT 0x10
#define MC_SHARED_CHREMAP__CHAN5_MASK 0xf00000
#define MC_SHARED_CHREMAP__CHAN5__SHIFT 0x14
#define MC_SHARED_CHREMAP__CHAN6_MASK 0xf000000
#define MC_SHARED_CHREMAP__CHAN6__SHIFT 0x18
#define MC_SHARED_CHREMAP__CHAN7_MASK 0xf0000000
#define MC_SHARED_CHREMAP__CHAN7__SHIFT 0x1c
#define MC_RD_GRP_GFX__CP_MASK 0xf
#define MC_RD_GRP_GFX__CP__SHIFT 0x0
#define MC_RD_GRP_GFX__SH_MASK 0xf0
#define MC_RD_GRP_GFX__SH__SHIFT 0x4
#define MC_RD_GRP_GFX__TLS_MASK 0xf00
#define MC_RD_GRP_GFX__TLS__SHIFT 0x8
#define MC_RD_GRP_GFX__ACPG_MASK 0xf000
#define MC_RD_GRP_GFX__ACPG__SHIFT 0xc
#define MC_RD_GRP_GFX__ACPO_MASK 0xf0000
#define MC_RD_GRP_GFX__ACPO__SHIFT 0x10
#define MC_RD_GRP_GFX__XDMAM_MASK 0xf00000
#define MC_RD_GRP_GFX__XDMAM__SHIFT 0x14
#define MC_RD_GRP_GFX__ISP_MASK 0xf000000
#define MC_RD_GRP_GFX__ISP__SHIFT 0x18
#define MC_RD_GRP_GFX__VP8_MASK 0xf0000000
#define MC_RD_GRP_GFX__VP8__SHIFT 0x1c
#define MC_WR_GRP_GFX__VIN0_MASK 0xf
#define MC_WR_GRP_GFX__VIN0__SHIFT 0x0
#define MC_WR_GRP_GFX__SH_MASK 0xf0
#define MC_WR_GRP_GFX__SH__SHIFT 0x4
#define MC_WR_GRP_GFX__ACPG_MASK 0xf00
#define MC_WR_GRP_GFX__ACPG__SHIFT 0x8
#define MC_WR_GRP_GFX__ACPO_MASK 0xf000
#define MC_WR_GRP_GFX__ACPO__SHIFT 0xc
#define MC_WR_GRP_GFX__ISP_MASK 0xf0000
#define MC_WR_GRP_GFX__ISP__SHIFT 0x10
#define MC_WR_GRP_GFX__VP8_MASK 0xf00000
#define MC_WR_GRP_GFX__VP8__SHIFT 0x14
#define MC_WR_GRP_GFX__XDMA_MASK 0xf000000
#define MC_WR_GRP_GFX__XDMA__SHIFT 0x18
#define MC_WR_GRP_GFX__XDMAM_MASK 0xf0000000
#define MC_WR_GRP_GFX__XDMAM__SHIFT 0x1c
#define MC_RD_GRP_SYS__RLC_MASK 0xf
#define MC_RD_GRP_SYS__RLC__SHIFT 0x0
#define MC_RD_GRP_SYS__VMC_MASK 0xf0
#define MC_RD_GRP_SYS__VMC__SHIFT 0x4
#define MC_RD_GRP_SYS__SDMA1_MASK 0xf00
#define MC_RD_GRP_SYS__SDMA1__SHIFT 0x8
#define MC_RD_GRP_SYS__DMIF_MASK 0xf000
#define MC_RD_GRP_SYS__DMIF__SHIFT 0xc
#define MC_RD_GRP_SYS__MCIF_MASK 0xf0000
#define MC_RD_GRP_SYS__MCIF__SHIFT 0x10
#define MC_RD_GRP_SYS__SMU_MASK 0xf00000
#define MC_RD_GRP_SYS__SMU__SHIFT 0x14
#define MC_RD_GRP_SYS__VCE0_MASK 0xf000000
#define MC_RD_GRP_SYS__VCE0__SHIFT 0x18
#define MC_RD_GRP_SYS__VCE1_MASK 0xf0000000
#define MC_RD_GRP_SYS__VCE1__SHIFT 0x1c
#define MC_WR_GRP_SYS__IH_MASK 0xf
#define MC_WR_GRP_SYS__IH__SHIFT 0x0
#define MC_WR_GRP_SYS__MCIF_MASK 0xf0
#define MC_WR_GRP_SYS__MCIF__SHIFT 0x4
#define MC_WR_GRP_SYS__RLC_MASK 0xf00
#define MC_WR_GRP_SYS__RLC__SHIFT 0x8
#define MC_WR_GRP_SYS__SAMMSP_MASK 0xf000
#define MC_WR_GRP_SYS__SAMMSP__SHIFT 0xc
#define MC_WR_GRP_SYS__SMU_MASK 0xf0000
#define MC_WR_GRP_SYS__SMU__SHIFT 0x10
#define MC_WR_GRP_SYS__SDMA1_MASK 0xf00000
#define MC_WR_GRP_SYS__SDMA1__SHIFT 0x14
#define MC_WR_GRP_SYS__VCE0_MASK 0xf000000
#define MC_WR_GRP_SYS__VCE0__SHIFT 0x18
#define MC_WR_GRP_SYS__VCE1_MASK 0xf0000000
#define MC_WR_GRP_SYS__VCE1__SHIFT 0x1c
#define MC_RD_GRP_OTH__UVD_EXT0_MASK 0xf
#define MC_RD_GRP_OTH__UVD_EXT0__SHIFT 0x0
#define MC_RD_GRP_OTH__SDMA0_MASK 0xf0
#define MC_RD_GRP_OTH__SDMA0__SHIFT 0x4
#define MC_RD_GRP_OTH__HDP_MASK 0xf00
#define MC_RD_GRP_OTH__HDP__SHIFT 0x8
#define MC_RD_GRP_OTH__SEM_MASK 0xf000
#define MC_RD_GRP_OTH__SEM__SHIFT 0xc
#define MC_RD_GRP_OTH__UMC_MASK 0xf0000
#define MC_RD_GRP_OTH__UMC__SHIFT 0x10
#define MC_RD_GRP_OTH__UVD_MASK 0xf00000
#define MC_RD_GRP_OTH__UVD__SHIFT 0x14
#define MC_RD_GRP_OTH__UVD_EXT1_MASK 0xf000000
#define MC_RD_GRP_OTH__UVD_EXT1__SHIFT 0x18
#define MC_RD_GRP_OTH__SAMMSP_MASK 0xf0000000
#define MC_RD_GRP_OTH__SAMMSP__SHIFT 0x1c
#define MC_WR_GRP_OTH__UVD_EXT0_MASK 0xf
#define MC_WR_GRP_OTH__UVD_EXT0__SHIFT 0x0
#define MC_WR_GRP_OTH__SDMA0_MASK 0xf0
#define MC_WR_GRP_OTH__SDMA0__SHIFT 0x4
#define MC_WR_GRP_OTH__HDP_MASK 0xf00
#define MC_WR_GRP_OTH__HDP__SHIFT 0x8
#define MC_WR_GRP_OTH__SEM_MASK 0xf000
#define MC_WR_GRP_OTH__SEM__SHIFT 0xc
#define MC_WR_GRP_OTH__UMC_MASK 0xf0000
#define MC_WR_GRP_OTH__UMC__SHIFT 0x10
#define MC_WR_GRP_OTH__UVD_MASK 0xf00000
#define MC_WR_GRP_OTH__UVD__SHIFT 0x14
#define MC_WR_GRP_OTH__XDP_MASK 0xf000000
#define MC_WR_GRP_OTH__XDP__SHIFT 0x18
#define MC_WR_GRP_OTH__UVD_EXT1_MASK 0xf0000000
#define MC_WR_GRP_OTH__UVD_EXT1__SHIFT 0x1c
#define MC_VM_FB_LOCATION__FB_BASE_MASK 0xffff
#define MC_VM_FB_LOCATION__FB_BASE__SHIFT 0x0
#define MC_VM_FB_LOCATION__FB_TOP_MASK 0xffff0000
#define MC_VM_FB_LOCATION__FB_TOP__SHIFT 0x10
#define MC_VM_AGP_TOP__AGP_TOP_MASK 0x3ffff
#define MC_VM_AGP_TOP__AGP_TOP__SHIFT 0x0
#define MC_VM_AGP_BOT__AGP_BOT_MASK 0x3ffff
#define MC_VM_AGP_BOT__AGP_BOT__SHIFT 0x0
#define MC_VM_AGP_BASE__AGP_BASE_MASK 0x3ffff
#define MC_VM_AGP_BASE__AGP_BASE__SHIFT 0x0
#define MC_VM_SYSTEM_APERTURE_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define MC_VM_SYSTEM_APERTURE_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define MC_VM_SYSTEM_APERTURE_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define MC_VM_SYSTEM_APERTURE_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_0_MODE_MASK 0x3
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_0_MODE__SHIFT 0x0
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_1_MODE_MASK 0xc
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_1_MODE__SHIFT 0x2
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_2_MODE_MASK 0x30
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_2_MODE__SHIFT 0x4
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_3_MODE_MASK 0xc0
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_3_MODE__SHIFT 0x6
#define MC_VM_DC_WRITE_CNTL__DC_MEMORY_WRITE_LOCAL_MASK 0x100
#define MC_VM_DC_WRITE_CNTL__DC_MEMORY_WRITE_LOCAL__SHIFT 0x8
#define MC_VM_DC_WRITE_CNTL__DC_MEMORY_WRITE_SYSTEM_MASK 0x200
#define MC_VM_DC_WRITE_CNTL__DC_MEMORY_WRITE_SYSTEM__SHIFT 0x9
#define MC_VM_DC_WRITE_HIT_REGION_0_LOW_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_0_LOW_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_1_LOW_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_1_LOW_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_2_LOW_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_2_LOW_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_3_LOW_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_3_LOW_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_0_HIGH_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_0_HIGH_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_1_HIGH_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_1_HIGH_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_2_HIGH_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_2_HIGH_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_3_HIGH_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_3_HIGH_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_TLB_MASK 0x1
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_TLB__SHIFT 0x0
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_FRAGMENT_PROCESSING_MASK 0x2
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_FRAGMENT_PROCESSING__SHIFT 0x1
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_ACCESS_MODE_MASK 0x18
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_ACCESS_MODE__SHIFT 0x3
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_APERTURE_UNMAPPED_ACCESS_MASK 0x20
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_APERTURE_UNMAPPED_ACCESS__SHIFT 0x5
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_ADVANCED_DRIVER_MODEL_MASK 0x40
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_ADVANCED_DRIVER_MODEL__SHIFT 0x6
#define MC_VM_MX_L1_TLB_CNTL__ECO_BITS_MASK 0x780
#define MC_VM_MX_L1_TLB_CNTL__ECO_BITS__SHIFT 0x7
#define MC_VM_FB_OFFSET__FB_OFFSET_MASK 0x3ffff
#define MC_VM_FB_OFFSET__FB_OFFSET__SHIFT 0x0
#define MC_VM_STEERING__DEFAULT_STEERING_MASK 0x3
#define MC_VM_STEERING__DEFAULT_STEERING__SHIFT 0x0
#define MC_SHARED_CHREMAP2__CHAN8_MASK 0xf
#define MC_SHARED_CHREMAP2__CHAN8__SHIFT 0x0
#define MC_SHARED_CHREMAP2__CHAN9_MASK 0xf0
#define MC_SHARED_CHREMAP2__CHAN9__SHIFT 0x4
#define MC_SHARED_CHREMAP2__CHAN10_MASK 0xf00
#define MC_SHARED_CHREMAP2__CHAN10__SHIFT 0x8
#define MC_SHARED_CHREMAP2__CHAN11_MASK 0xf000
#define MC_SHARED_CHREMAP2__CHAN11__SHIFT 0xc
#define MC_SHARED_CHREMAP2__CHAN12_MASK 0xf0000
#define MC_SHARED_CHREMAP2__CHAN12__SHIFT 0x10
#define MC_SHARED_CHREMAP2__CHAN13_MASK 0xf00000
#define MC_SHARED_CHREMAP2__CHAN13__SHIFT 0x14
#define MC_SHARED_CHREMAP2__CHAN14_MASK 0xf000000
#define MC_SHARED_CHREMAP2__CHAN14__SHIFT 0x18
#define MC_SHARED_CHREMAP2__CHAN15_MASK 0xf0000000
#define MC_SHARED_CHREMAP2__CHAN15__SHIFT 0x1c
#define MC_SHARED_VF_ENABLE__VF_ENABLE_MASK 0x1
#define MC_SHARED_VF_ENABLE__VF_ENABLE__SHIFT 0x0
#define MC_SHARED_VIRT_RESET_REQ__VF_MASK 0xffff
#define MC_SHARED_VIRT_RESET_REQ__VF__SHIFT 0x0
#define MC_SHARED_VIRT_RESET_REQ__PF_MASK 0x80000000
#define MC_SHARED_VIRT_RESET_REQ__PF__SHIFT 0x1f
#define MC_SHARED_ACTIVE_FCN_ID__VFID_MASK 0xf
#define MC_SHARED_ACTIVE_FCN_ID__VFID__SHIFT 0x0
#define MC_SHARED_ACTIVE_FCN_ID__VF_MASK 0x80000000
#define MC_SHARED_ACTIVE_FCN_ID__VF__SHIFT 0x1f
#define MC_CONFIG_MCD__MCD0_WR_ENABLE_MASK 0x1
#define MC_CONFIG_MCD__MCD0_WR_ENABLE__SHIFT 0x0
#define MC_CONFIG_MCD__MCD1_WR_ENABLE_MASK 0x2
#define MC_CONFIG_MCD__MCD1_WR_ENABLE__SHIFT 0x1
#define MC_CONFIG_MCD__MCD2_WR_ENABLE_MASK 0x4
#define MC_CONFIG_MCD__MCD2_WR_ENABLE__SHIFT 0x2
#define MC_CONFIG_MCD__MCD3_WR_ENABLE_MASK 0x8
#define MC_CONFIG_MCD__MCD3_WR_ENABLE__SHIFT 0x3
#define MC_CONFIG_MCD__MCD4_WR_ENABLE_MASK 0x10
#define MC_CONFIG_MCD__MCD4_WR_ENABLE__SHIFT 0x4
#define MC_CONFIG_MCD__MCD5_WR_ENABLE_MASK 0x20
#define MC_CONFIG_MCD__MCD5_WR_ENABLE__SHIFT 0x5
#define MC_CONFIG_MCD__MCD6_WR_ENABLE_MASK 0x40
#define MC_CONFIG_MCD__MCD6_WR_ENABLE__SHIFT 0x6
#define MC_CONFIG_MCD__MCD7_WR_ENABLE_MASK 0x80
#define MC_CONFIG_MCD__MCD7_WR_ENABLE__SHIFT 0x7
#define MC_CONFIG_MCD__MC_RD_ENABLE_MASK 0x700
#define MC_CONFIG_MCD__MC_RD_ENABLE__SHIFT 0x8
#define MC_CONFIG_MCD__MC_RD_ENABLE_SUB_MASK 0x800
#define MC_CONFIG_MCD__MC_RD_ENABLE_SUB__SHIFT 0xb
#define MC_CONFIG_MCD__ARB0_WR_ENABLE_MASK 0x1000
#define MC_CONFIG_MCD__ARB0_WR_ENABLE__SHIFT 0xc
#define MC_CONFIG_MCD__ARB1_WR_ENABLE_MASK 0x2000
#define MC_CONFIG_MCD__ARB1_WR_ENABLE__SHIFT 0xd
#define MC_CONFIG_MCD__MCD_INDEX_MODE_ENABLE_MASK 0x80000000
#define MC_CONFIG_MCD__MCD_INDEX_MODE_ENABLE__SHIFT 0x1f
#define MC_CG_CONFIG_MCD__MCD0_WR_ENABLE_MASK 0x1
#define MC_CG_CONFIG_MCD__MCD0_WR_ENABLE__SHIFT 0x0
#define MC_CG_CONFIG_MCD__MCD1_WR_ENABLE_MASK 0x2
#define MC_CG_CONFIG_MCD__MCD1_WR_ENABLE__SHIFT 0x1
#define MC_CG_CONFIG_MCD__MCD2_WR_ENABLE_MASK 0x4
#define MC_CG_CONFIG_MCD__MCD2_WR_ENABLE__SHIFT 0x2
#define MC_CG_CONFIG_MCD__MCD3_WR_ENABLE_MASK 0x8
#define MC_CG_CONFIG_MCD__MCD3_WR_ENABLE__SHIFT 0x3
#define MC_CG_CONFIG_MCD__MCD4_WR_ENABLE_MASK 0x10
#define MC_CG_CONFIG_MCD__MCD4_WR_ENABLE__SHIFT 0x4
#define MC_CG_CONFIG_MCD__MCD5_WR_ENABLE_MASK 0x20
#define MC_CG_CONFIG_MCD__MCD5_WR_ENABLE__SHIFT 0x5
#define MC_CG_CONFIG_MCD__MCD6_WR_ENABLE_MASK 0x40
#define MC_CG_CONFIG_MCD__MCD6_WR_ENABLE__SHIFT 0x6
#define MC_CG_CONFIG_MCD__MCD7_WR_ENABLE_MASK 0x80
#define MC_CG_CONFIG_MCD__MCD7_WR_ENABLE__SHIFT 0x7
#define MC_CG_CONFIG_MCD__MC_RD_ENABLE_MASK 0x700
#define MC_CG_CONFIG_MCD__MC_RD_ENABLE__SHIFT 0x8
#define MC_CG_CONFIG_MCD__MC_RD_ENABLE_SUB_MASK 0x800
#define MC_CG_CONFIG_MCD__MC_RD_ENABLE_SUB__SHIFT 0xb
#define MC_CG_CONFIG_MCD__INDEX_MASK 0x1fffe000
#define MC_CG_CONFIG_MCD__INDEX__SHIFT 0xd
#define MC_MEM_POWER_LS__LS_SETUP_MASK 0x3f
#define MC_MEM_POWER_LS__LS_SETUP__SHIFT 0x0
#define MC_MEM_POWER_LS__LS_HOLD_MASK 0xfc0
#define MC_MEM_POWER_LS__LS_HOLD__SHIFT 0x6
#define MC_SHARED_BLACKOUT_CNTL__BLACKOUT_MODE_MASK 0x7
#define MC_SHARED_BLACKOUT_CNTL__BLACKOUT_MODE__SHIFT 0x0
#define MC_SHARED_BLACKOUT_CNTL__BLACKOUT_SEQ_FREE_MASK 0x8
#define MC_SHARED_BLACKOUT_CNTL__BLACKOUT_SEQ_FREE__SHIFT 0x3
#define MC_SHARED_BLACKOUT_CNTL__BLACKOUT_MCD_NUM_MASK 0xff0
#define MC_SHARED_BLACKOUT_CNTL__BLACKOUT_MCD_NUM__SHIFT 0x4
#define MC_SHARED_BLACKOUT_CNTL__FREE_TIE_HIGH_MASK 0x1000
#define MC_SHARED_BLACKOUT_CNTL__FREE_TIE_HIGH__SHIFT 0xc
#define MC_SHARED_BLACKOUT_CNTL__SRBM_DUMMY_READ_RETURN_MASK 0x2000
#define MC_SHARED_BLACKOUT_CNTL__SRBM_DUMMY_READ_RETURN__SHIFT 0xd
#define MC_VM_MB_L1_TLB0_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MB_L1_TLB0_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MB_L1_TLB0_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MB_L1_TLB0_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MB_L1_TLB0_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MB_L1_TLB0_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MB_L1_TLB0_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MB_L1_TLB0_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MB_L1_TLB0_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MB_L1_TLB0_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MB_L1_TLB0_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MB_L1_TLB0_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MB_L1_TLB1_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MB_L1_TLB1_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MB_L1_TLB1_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MB_L1_TLB1_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MB_L1_TLB1_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MB_L1_TLB1_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MB_L1_TLB1_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MB_L1_TLB1_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MB_L1_TLB1_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MB_L1_TLB1_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MB_L1_TLB1_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MB_L1_TLB1_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MB_L1_TLB2_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MB_L1_TLB2_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MB_L1_TLB2_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MB_L1_TLB2_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MB_L1_TLB2_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MB_L1_TLB2_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MB_L1_TLB2_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MB_L1_TLB2_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MB_L1_TLB2_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MB_L1_TLB2_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MB_L1_TLB2_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MB_L1_TLB2_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MB_L1_TLB0_STATUS__BUSY_MASK 0x1
#define MC_VM_MB_L1_TLB0_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MB_L1_TLB1_STATUS__BUSY_MASK 0x1
#define MC_VM_MB_L1_TLB1_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MB_L1_TLB2_STATUS__BUSY_MASK 0x1
#define MC_VM_MB_L1_TLB2_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MB_L2ARBITER_L2_CREDITS__L2_IF_CREDITS_MASK 0x3f
#define MC_VM_MB_L2ARBITER_L2_CREDITS__L2_IF_CREDITS__SHIFT 0x0
#define MC_VM_MB_L1_TLB3_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MB_L1_TLB3_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MB_L1_TLB3_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MB_L1_TLB3_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MB_L1_TLB3_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MB_L1_TLB3_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MB_L1_TLB3_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MB_L1_TLB3_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MB_L1_TLB3_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MB_L1_TLB3_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MB_L1_TLB3_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MB_L1_TLB3_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MB_L1_TLB3_STATUS__BUSY_MASK 0x1
#define MC_VM_MB_L1_TLB3_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MD_L1_TLB0_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MD_L1_TLB0_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MD_L1_TLB0_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MD_L1_TLB0_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MD_L1_TLB0_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MD_L1_TLB0_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MD_L1_TLB0_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MD_L1_TLB0_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MD_L1_TLB0_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MD_L1_TLB0_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MD_L1_TLB0_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MD_L1_TLB0_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MD_L1_TLB1_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MD_L1_TLB1_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MD_L1_TLB1_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MD_L1_TLB1_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MD_L1_TLB1_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MD_L1_TLB1_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MD_L1_TLB1_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MD_L1_TLB1_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MD_L1_TLB1_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MD_L1_TLB1_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MD_L1_TLB1_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MD_L1_TLB1_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MD_L1_TLB2_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MD_L1_TLB2_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MD_L1_TLB2_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MD_L1_TLB2_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MD_L1_TLB2_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MD_L1_TLB2_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MD_L1_TLB2_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MD_L1_TLB2_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MD_L1_TLB2_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MD_L1_TLB2_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MD_L1_TLB2_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MD_L1_TLB2_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MD_L1_TLB0_STATUS__BUSY_MASK 0x1
#define MC_VM_MD_L1_TLB0_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MD_L1_TLB1_STATUS__BUSY_MASK 0x1
#define MC_VM_MD_L1_TLB1_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MD_L1_TLB2_STATUS__BUSY_MASK 0x1
#define MC_VM_MD_L1_TLB2_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MD_L2ARBITER_L2_CREDITS__L2_IF_CREDITS_MASK 0x3f
#define MC_VM_MD_L2ARBITER_L2_CREDITS__L2_IF_CREDITS__SHIFT 0x0
#define MC_VM_MD_L1_TLB3_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MD_L1_TLB3_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MD_L1_TLB3_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MD_L1_TLB3_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MD_L1_TLB3_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MD_L1_TLB3_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MD_L1_TLB3_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MD_L1_TLB3_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MD_L1_TLB3_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MD_L1_TLB3_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MD_L1_TLB3_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MD_L1_TLB3_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MD_L1_TLB3_STATUS__BUSY_MASK 0x1
#define MC_VM_MD_L1_TLB3_STATUS__BUSY__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR0__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR0__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR1__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR1__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR2__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR2__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR3__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR3__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR4__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR4__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR5__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR5__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR6__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR6__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR7__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR7__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR8__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR8__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR9__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR9__BASE_ADDR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_SRC_APRTR0__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_XDMA_RTR_SRC_APRTR0__BASE_ADDR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_SRC_APRTR1__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_XDMA_RTR_SRC_APRTR1__BASE_ADDR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_SRC_APRTR2__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_XDMA_RTR_SRC_APRTR2__BASE_ADDR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_SRC_APRTR3__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_XDMA_RTR_SRC_APRTR3__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP0__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP0__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP0__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP0__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP0__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP0__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP0__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP0__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP0__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP0__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP0__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP0__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP1__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP1__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP1__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP1__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP1__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP1__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP1__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP1__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP1__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP1__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP1__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP1__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP2__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP2__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP2__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP2__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP2__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP2__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP2__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP2__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP2__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP2__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP2__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP2__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP3__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP3__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP3__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP3__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP3__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP3__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP3__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP3__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP3__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP3__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP3__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP3__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP4__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP4__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP4__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP4__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP4__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP4__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP4__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP4__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP4__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP4__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP4__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP4__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP5__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP5__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP5__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP5__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP5__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP5__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP5__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP5__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP5__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP5__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP5__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP5__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP6__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP6__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP6__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP6__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP6__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP6__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP6__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP6__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP6__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP6__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP6__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP6__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP7__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP7__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP7__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP7__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP7__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP7__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP7__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP7__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP7__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP7__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP7__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP7__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP8__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP8__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP8__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP8__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP8__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP8__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP8__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP8__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP8__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP8__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP8__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP8__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP9__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP9__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP9__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP9__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP9__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP9__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP9__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP9__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP9__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP9__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP9__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP9__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_XDMA_RTR_DEST_MAP0__NMR_MASK 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP0__NMR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_SEL_MASK 0xf00000
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_SEL__SHIFT 0x14
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_XDMA_RTR_DEST_MAP0__SIDE_OK_MASK 0x2000000
#define MC_XPB_XDMA_RTR_DEST_MAP0__SIDE_OK__SHIFT 0x19
#define MC_XPB_XDMA_RTR_DEST_MAP0__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_XDMA_RTR_DEST_MAP0__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_XDMA_RTR_DEST_MAP1__NMR_MASK 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP1__NMR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_SEL_MASK 0xf00000
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_SEL__SHIFT 0x14
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_XDMA_RTR_DEST_MAP1__SIDE_OK_MASK 0x2000000
#define MC_XPB_XDMA_RTR_DEST_MAP1__SIDE_OK__SHIFT 0x19
#define MC_XPB_XDMA_RTR_DEST_MAP1__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_XDMA_RTR_DEST_MAP1__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_XDMA_RTR_DEST_MAP2__NMR_MASK 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP2__NMR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_SEL_MASK 0xf00000
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_SEL__SHIFT 0x14
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_XDMA_RTR_DEST_MAP2__SIDE_OK_MASK 0x2000000
#define MC_XPB_XDMA_RTR_DEST_MAP2__SIDE_OK__SHIFT 0x19
#define MC_XPB_XDMA_RTR_DEST_MAP2__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_XDMA_RTR_DEST_MAP2__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_XDMA_RTR_DEST_MAP3__NMR_MASK 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP3__NMR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_SEL_MASK 0xf00000
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_SEL__SHIFT 0x14
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_XDMA_RTR_DEST_MAP3__SIDE_OK_MASK 0x2000000
#define MC_XPB_XDMA_RTR_DEST_MAP3__SIDE_OK__SHIFT 0x19
#define MC_XPB_XDMA_RTR_DEST_MAP3__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_XDMA_RTR_DEST_MAP3__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_CLG_CFG0__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG0__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG0__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG0__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG0__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG0__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG0__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG0__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG0__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG0__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG1__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG1__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG1__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG1__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG1__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG1__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG1__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG1__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG1__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG1__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG2__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG2__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG2__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG2__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG2__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG2__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG2__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG2__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG2__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG2__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG3__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG3__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG3__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG3__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG3__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG3__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG3__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG3__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG3__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG3__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG4__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG4__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG4__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG4__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG4__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG4__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG4__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG4__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG4__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG4__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG5__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG5__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG5__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG5__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG5__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG5__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG5__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG5__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG5__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG5__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG6__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG6__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG6__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG6__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG6__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG6__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG6__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG6__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG6__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG6__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG7__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG7__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG7__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG7__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG7__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG7__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG7__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG7__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG7__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG7__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG8__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG8__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG8__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG8__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG8__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG8__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG8__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG8__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG8__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG8__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG9__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG9__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG9__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG9__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG9__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG9__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG9__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG9__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG9__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG9__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG10__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG10__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG10__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG10__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG10__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG10__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG10__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG10__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG10__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG10__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG11__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG11__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG11__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG11__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG11__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG11__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG11__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG11__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG11__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG11__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG12__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG12__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG12__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG12__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG12__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG12__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG12__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG12__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG12__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG12__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG13__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG13__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG13__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG13__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG13__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG13__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG13__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG13__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG13__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG13__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG14__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG14__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG14__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG14__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG14__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG14__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG14__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG14__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG14__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG14__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG15__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG15__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG15__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG15__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG15__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG15__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG15__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG15__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG15__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG15__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG16__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG16__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG16__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG16__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG16__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG16__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG16__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG16__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG16__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG16__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG17__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG17__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG17__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG17__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG17__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG17__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG17__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG17__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG17__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG17__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG18__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG18__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG18__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG18__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG18__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG18__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG18__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG18__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG18__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG18__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG19__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG19__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG19__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG19__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG19__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG19__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG19__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG19__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG19__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG19__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_EXTRA__CMP0_MASK 0xff
#define MC_XPB_CLG_EXTRA__CMP0__SHIFT 0x0
#define MC_XPB_CLG_EXTRA__MSK0_MASK 0xff00
#define MC_XPB_CLG_EXTRA__MSK0__SHIFT 0x8
#define MC_XPB_CLG_EXTRA__VLD0_MASK 0x10000
#define MC_XPB_CLG_EXTRA__VLD0__SHIFT 0x10
#define MC_XPB_CLG_EXTRA__CMP1_MASK 0x1fe0000
#define MC_XPB_CLG_EXTRA__CMP1__SHIFT 0x11
#define MC_XPB_CLG_EXTRA__VLD1_MASK 0x2000000
#define MC_XPB_CLG_EXTRA__VLD1__SHIFT 0x19
#define MC_XPB_LB_ADDR__CMP0_MASK 0x3ff
#define MC_XPB_LB_ADDR__CMP0__SHIFT 0x0
#define MC_XPB_LB_ADDR__MASK0_MASK 0xffc00
#define MC_XPB_LB_ADDR__MASK0__SHIFT 0xa
#define MC_XPB_LB_ADDR__CMP1_MASK 0x3f00000
#define MC_XPB_LB_ADDR__CMP1__SHIFT 0x14
#define MC_XPB_LB_ADDR__MASK1_MASK 0xfc000000
#define MC_XPB_LB_ADDR__MASK1__SHIFT 0x1a
#define MC_XPB_UNC_THRESH_HST__CHANGE_PREF_MASK 0x3f
#define MC_XPB_UNC_THRESH_HST__CHANGE_PREF__SHIFT 0x0
#define MC_XPB_UNC_THRESH_HST__STRONG_PREF_MASK 0xfc0
#define MC_XPB_UNC_THRESH_HST__STRONG_PREF__SHIFT 0x6
#define MC_XPB_UNC_THRESH_HST__USE_UNFULL_MASK 0x3f000
#define MC_XPB_UNC_THRESH_HST__USE_UNFULL__SHIFT 0xc
#define MC_XPB_UNC_THRESH_SID__CHANGE_PREF_MASK 0x3f
#define MC_XPB_UNC_THRESH_SID__CHANGE_PREF__SHIFT 0x0
#define MC_XPB_UNC_THRESH_SID__STRONG_PREF_MASK 0xfc0
#define MC_XPB_UNC_THRESH_SID__STRONG_PREF__SHIFT 0x6
#define MC_XPB_UNC_THRESH_SID__USE_UNFULL_MASK 0x3f000
#define MC_XPB_UNC_THRESH_SID__USE_UNFULL__SHIFT 0xc
#define MC_XPB_WCB_STS__PBUF_VLD_MASK 0xffff
#define MC_XPB_WCB_STS__PBUF_VLD__SHIFT 0x0
#define MC_XPB_WCB_STS__WCB_HST_DATA_BUF_CNT_MASK 0x7f0000
#define MC_XPB_WCB_STS__WCB_HST_DATA_BUF_CNT__SHIFT 0x10
#define MC_XPB_WCB_STS__WCB_SID_DATA_BUF_CNT_MASK 0x3f800000
#define MC_XPB_WCB_STS__WCB_SID_DATA_BUF_CNT__SHIFT 0x17
#define MC_XPB_WCB_CFG__TIMEOUT_MASK 0xffff
#define MC_XPB_WCB_CFG__TIMEOUT__SHIFT 0x0
#define MC_XPB_WCB_CFG__HST_MAX_MASK 0x30000
#define MC_XPB_WCB_CFG__HST_MAX__SHIFT 0x10
#define MC_XPB_WCB_CFG__SID_MAX_MASK 0xc0000
#define MC_XPB_WCB_CFG__SID_MAX__SHIFT 0x12
#define MC_XPB_P2P_BAR_CFG__ADDR_SIZE_MASK 0xf
#define MC_XPB_P2P_BAR_CFG__ADDR_SIZE__SHIFT 0x0
#define MC_XPB_P2P_BAR_CFG__SEND_BAR_MASK 0x30
#define MC_XPB_P2P_BAR_CFG__SEND_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR_CFG__SNOOP_MASK 0x40
#define MC_XPB_P2P_BAR_CFG__SNOOP__SHIFT 0x6
#define MC_XPB_P2P_BAR_CFG__SEND_DIS_MASK 0x80
#define MC_XPB_P2P_BAR_CFG__SEND_DIS__SHIFT 0x7
#define MC_XPB_P2P_BAR_CFG__COMPRESS_DIS_MASK 0x100
#define MC_XPB_P2P_BAR_CFG__COMPRESS_DIS__SHIFT 0x8
#define MC_XPB_P2P_BAR_CFG__UPDATE_DIS_MASK 0x200
#define MC_XPB_P2P_BAR_CFG__UPDATE_DIS__SHIFT 0x9
#define MC_XPB_P2P_BAR_CFG__REGBAR_FROM_SYSBAR_MASK 0x400
#define MC_XPB_P2P_BAR_CFG__REGBAR_FROM_SYSBAR__SHIFT 0xa
#define MC_XPB_P2P_BAR_CFG__RD_EN_MASK 0x800
#define MC_XPB_P2P_BAR_CFG__RD_EN__SHIFT 0xb
#define MC_XPB_P2P_BAR_CFG__ATC_TRANSLATED_MASK 0x1000
#define MC_XPB_P2P_BAR_CFG__ATC_TRANSLATED__SHIFT 0xc
#define MC_XPB_P2P_BAR0__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR0__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR0__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR0__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR0__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR0__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR0__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR0__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR0__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR0__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR0__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR0__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR0__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR0__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR0__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR0__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR1__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR1__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR1__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR1__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR1__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR1__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR1__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR1__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR1__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR1__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR1__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR1__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR1__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR1__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR1__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR1__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR2__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR2__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR2__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR2__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR2__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR2__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR2__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR2__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR2__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR2__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR2__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR2__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR2__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR2__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR2__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR2__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR3__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR3__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR3__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR3__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR3__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR3__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR3__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR3__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR3__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR3__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR3__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR3__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR3__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR3__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR3__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR3__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR4__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR4__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR4__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR4__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR4__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR4__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR4__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR4__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR4__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR4__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR4__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR4__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR4__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR4__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR4__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR4__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR5__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR5__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR5__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR5__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR5__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR5__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR5__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR5__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR5__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR5__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR5__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR5__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR5__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR5__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR5__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR5__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR6__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR6__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR6__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR6__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR6__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR6__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR6__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR6__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR6__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR6__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR6__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR6__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR6__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR6__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR6__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR6__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR7__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR7__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR7__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR7__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR7__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR7__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR7__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR7__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR7__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR7__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR7__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR7__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR7__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR7__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR7__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR7__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR_SETUP__SEL_MASK 0xff
#define MC_XPB_P2P_BAR_SETUP__SEL__SHIFT 0x0
#define MC_XPB_P2P_BAR_SETUP__REG_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR_SETUP__REG_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR_SETUP__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR_SETUP__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR_SETUP__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR_SETUP__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR_SETUP__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR_SETUP__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR_SETUP__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR_SETUP__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR_SETUP__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR_SETUP__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR_DEBUG__SEL_MASK 0xff
#define MC_XPB_P2P_BAR_DEBUG__SEL__SHIFT 0x0
#define MC_XPB_P2P_BAR_DEBUG__HOST_FLUSH_MASK 0xf00
#define MC_XPB_P2P_BAR_DEBUG__HOST_FLUSH__SHIFT 0x8
#define MC_XPB_P2P_BAR_DEBUG__MEM_SYS_BAR_MASK 0xf000
#define MC_XPB_P2P_BAR_DEBUG__MEM_SYS_BAR__SHIFT 0xc
#define MC_XPB_P2P_BAR_DELTA_ABOVE__EN_MASK 0xff
#define MC_XPB_P2P_BAR_DELTA_ABOVE__EN__SHIFT 0x0
#define MC_XPB_P2P_BAR_DELTA_ABOVE__DELTA_MASK 0xfffff00
#define MC_XPB_P2P_BAR_DELTA_ABOVE__DELTA__SHIFT 0x8
#define MC_XPB_P2P_BAR_DELTA_BELOW__EN_MASK 0xff
#define MC_XPB_P2P_BAR_DELTA_BELOW__EN__SHIFT 0x0
#define MC_XPB_P2P_BAR_DELTA_BELOW__DELTA_MASK 0xfffff00
#define MC_XPB_P2P_BAR_DELTA_BELOW__DELTA__SHIFT 0x8
#define MC_XPB_PEER_SYS_BAR0__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR0__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR0__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR0__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR0__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR0__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR1__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR1__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR1__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR1__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR1__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR1__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR2__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR2__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR2__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR2__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR2__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR2__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR3__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR3__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR3__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR3__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR3__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR3__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR4__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR4__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR4__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR4__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR4__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR4__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR5__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR5__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR5__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR5__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR5__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR5__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR6__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR6__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR6__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR6__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR6__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR6__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR7__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR7__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR7__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR7__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR7__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR7__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR8__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR8__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR8__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR8__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR8__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR8__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR9__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR9__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR9__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR9__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR9__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR9__ADDR__SHIFT 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR0__VALID_MASK 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR0__VALID__SHIFT 0x0
#define MC_XPB_XDMA_PEER_SYS_BAR0__SIDE_OK_MASK 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR0__SIDE_OK__SHIFT 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR0__ADDR_MASK 0x7fffffc
#define MC_XPB_XDMA_PEER_SYS_BAR0__ADDR__SHIFT 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR1__VALID_MASK 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR1__VALID__SHIFT 0x0
#define MC_XPB_XDMA_PEER_SYS_BAR1__SIDE_OK_MASK 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR1__SIDE_OK__SHIFT 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR1__ADDR_MASK 0x7fffffc
#define MC_XPB_XDMA_PEER_SYS_BAR1__ADDR__SHIFT 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR2__VALID_MASK 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR2__VALID__SHIFT 0x0
#define MC_XPB_XDMA_PEER_SYS_BAR2__SIDE_OK_MASK 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR2__SIDE_OK__SHIFT 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR2__ADDR_MASK 0x7fffffc
#define MC_XPB_XDMA_PEER_SYS_BAR2__ADDR__SHIFT 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR3__VALID_MASK 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR3__VALID__SHIFT 0x0
#define MC_XPB_XDMA_PEER_SYS_BAR3__SIDE_OK_MASK 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR3__SIDE_OK__SHIFT 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR3__ADDR_MASK 0x7fffffc
#define MC_XPB_XDMA_PEER_SYS_BAR3__ADDR__SHIFT 0x2
#define MC_XPB_CLK_GAT__ONDLY_MASK 0x3f
#define MC_XPB_CLK_GAT__ONDLY__SHIFT 0x0
#define MC_XPB_CLK_GAT__OFFDLY_MASK 0xfc0
#define MC_XPB_CLK_GAT__OFFDLY__SHIFT 0x6
#define MC_XPB_CLK_GAT__RDYDLY_MASK 0x3f000
#define MC_XPB_CLK_GAT__RDYDLY__SHIFT 0xc
#define MC_XPB_CLK_GAT__ENABLE_MASK 0x40000
#define MC_XPB_CLK_GAT__ENABLE__SHIFT 0x12
#define MC_XPB_CLK_GAT__MEM_LS_ENABLE_MASK 0x80000
#define MC_XPB_CLK_GAT__MEM_LS_ENABLE__SHIFT 0x13
#define MC_XPB_INTF_CFG__RPB_WRREQ_CRD_MASK 0xff
#define MC_XPB_INTF_CFG__RPB_WRREQ_CRD__SHIFT 0x0
#define MC_XPB_INTF_CFG__MC_WRRET_ASK_MASK 0xff00
#define MC_XPB_INTF_CFG__MC_WRRET_ASK__SHIFT 0x8
#define MC_XPB_INTF_CFG__XSP_REQ_CRD_MASK 0x7f0000
#define MC_XPB_INTF_CFG__XSP_REQ_CRD__SHIFT 0x10
#define MC_XPB_INTF_CFG__BIF_REG_SNOOP_SEL_MASK 0x800000
#define MC_XPB_INTF_CFG__BIF_REG_SNOOP_SEL__SHIFT 0x17
#define MC_XPB_INTF_CFG__BIF_REG_SNOOP_VAL_MASK 0x1000000
#define MC_XPB_INTF_CFG__BIF_REG_SNOOP_VAL__SHIFT 0x18
#define MC_XPB_INTF_CFG__BIF_MEM_SNOOP_SEL_MASK 0x2000000
#define MC_XPB_INTF_CFG__BIF_MEM_SNOOP_SEL__SHIFT 0x19
#define MC_XPB_INTF_CFG__BIF_MEM_SNOOP_VAL_MASK 0x4000000
#define MC_XPB_INTF_CFG__BIF_MEM_SNOOP_VAL__SHIFT 0x1a
#define MC_XPB_INTF_CFG__XSP_SNOOP_SEL_MASK 0x18000000
#define MC_XPB_INTF_CFG__XSP_SNOOP_SEL__SHIFT 0x1b
#define MC_XPB_INTF_CFG__XSP_SNOOP_VAL_MASK 0x20000000
#define MC_XPB_INTF_CFG__XSP_SNOOP_VAL__SHIFT 0x1d
#define MC_XPB_INTF_CFG__XSP_ORDERING_SEL_MASK 0x40000000
#define MC_XPB_INTF_CFG__XSP_ORDERING_SEL__SHIFT 0x1e
#define MC_XPB_INTF_CFG__XSP_ORDERING_VAL_MASK 0x80000000
#define MC_XPB_INTF_CFG__XSP_ORDERING_VAL__SHIFT 0x1f
#define MC_XPB_INTF_STS__RPB_WRREQ_CRD_MASK 0xff
#define MC_XPB_INTF_STS__RPB_WRREQ_CRD__SHIFT 0x0
#define MC_XPB_INTF_STS__XSP_REQ_CRD_MASK 0x7f00
#define MC_XPB_INTF_STS__XSP_REQ_CRD__SHIFT 0x8
#define MC_XPB_INTF_STS__HOP_DATA_BUF_FULL_MASK 0x8000
#define MC_XPB_INTF_STS__HOP_DATA_BUF_FULL__SHIFT 0xf
#define MC_XPB_INTF_STS__HOP_ATTR_BUF_FULL_MASK 0x10000
#define MC_XPB_INTF_STS__HOP_ATTR_BUF_FULL__SHIFT 0x10
#define MC_XPB_INTF_STS__CNS_BUF_FULL_MASK 0x20000
#define MC_XPB_INTF_STS__CNS_BUF_FULL__SHIFT 0x11
#define MC_XPB_INTF_STS__CNS_BUF_BUSY_MASK 0x40000
#define MC_XPB_INTF_STS__CNS_BUF_BUSY__SHIFT 0x12
#define MC_XPB_INTF_STS__RPB_RDREQ_CRD_MASK 0x7f80000
#define MC_XPB_INTF_STS__RPB_RDREQ_CRD__SHIFT 0x13
#define MC_XPB_PIPE_STS__WCB_ANY_PBUF_MASK 0x1
#define MC_XPB_PIPE_STS__WCB_ANY_PBUF__SHIFT 0x0
#define MC_XPB_PIPE_STS__WCB_HST_DATA_BUF_CNT_MASK 0xfe
#define MC_XPB_PIPE_STS__WCB_HST_DATA_BUF_CNT__SHIFT 0x1
#define MC_XPB_PIPE_STS__WCB_SID_DATA_BUF_CNT_MASK 0x7f00
#define MC_XPB_PIPE_STS__WCB_SID_DATA_BUF_CNT__SHIFT 0x8
#define MC_XPB_PIPE_STS__WCB_HST_RD_PTR_BUF_FULL_MASK 0x8000
#define MC_XPB_PIPE_STS__WCB_HST_RD_PTR_BUF_FULL__SHIFT 0xf
#define MC_XPB_PIPE_STS__WCB_SID_RD_PTR_BUF_FULL_MASK 0x10000
#define MC_XPB_PIPE_STS__WCB_SID_RD_PTR_BUF_FULL__SHIFT 0x10
#define MC_XPB_PIPE_STS__WCB_HST_REQ_FIFO_FULL_MASK 0x20000
#define MC_XPB_PIPE_STS__WCB_HST_REQ_FIFO_FULL__SHIFT 0x11
#define MC_XPB_PIPE_STS__WCB_SID_REQ_FIFO_FULL_MASK 0x40000
#define MC_XPB_PIPE_STS__WCB_SID_REQ_FIFO_FULL__SHIFT 0x12
#define MC_XPB_PIPE_STS__WCB_HST_REQ_OBUF_FULL_MASK 0x80000
#define MC_XPB_PIPE_STS__WCB_HST_REQ_OBUF_FULL__SHIFT 0x13
#define MC_XPB_PIPE_STS__WCB_SID_REQ_OBUF_FULL_MASK 0x100000
#define MC_XPB_PIPE_STS__WCB_SID_REQ_OBUF_FULL__SHIFT 0x14
#define MC_XPB_PIPE_STS__WCB_HST_DATA_OBUF_FULL_MASK 0x200000
#define MC_XPB_PIPE_STS__WCB_HST_DATA_OBUF_FULL__SHIFT 0x15
#define MC_XPB_PIPE_STS__WCB_SID_DATA_OBUF_FULL_MASK 0x400000
#define MC_XPB_PIPE_STS__WCB_SID_DATA_OBUF_FULL__SHIFT 0x16
#define MC_XPB_PIPE_STS__RET_BUF_FULL_MASK 0x800000
#define MC_XPB_PIPE_STS__RET_BUF_FULL__SHIFT 0x17
#define MC_XPB_PIPE_STS__XPB_CLK_BUSY_BITS_MASK 0xff000000
#define MC_XPB_PIPE_STS__XPB_CLK_BUSY_BITS__SHIFT 0x18
#define MC_XPB_SUB_CTRL__WRREQ_BYPASS_XPB_MASK 0x1
#define MC_XPB_SUB_CTRL__WRREQ_BYPASS_XPB__SHIFT 0x0
#define MC_XPB_SUB_CTRL__STALL_CNS_RTR_REQ_MASK 0x2
#define MC_XPB_SUB_CTRL__STALL_CNS_RTR_REQ__SHIFT 0x1
#define MC_XPB_SUB_CTRL__STALL_RTR_RPB_WRREQ_MASK 0x4
#define MC_XPB_SUB_CTRL__STALL_RTR_RPB_WRREQ__SHIFT 0x2
#define MC_XPB_SUB_CTRL__STALL_RTR_MAP_REQ_MASK 0x8
#define MC_XPB_SUB_CTRL__STALL_RTR_MAP_REQ__SHIFT 0x3
#define MC_XPB_SUB_CTRL__STALL_MAP_WCB_REQ_MASK 0x10
#define MC_XPB_SUB_CTRL__STALL_MAP_WCB_REQ__SHIFT 0x4
#define MC_XPB_SUB_CTRL__STALL_WCB_SID_REQ_MASK 0x20
#define MC_XPB_SUB_CTRL__STALL_WCB_SID_REQ__SHIFT 0x5
#define MC_XPB_SUB_CTRL__STALL_MC_XSP_REQ_SEND_MASK 0x40
#define MC_XPB_SUB_CTRL__STALL_MC_XSP_REQ_SEND__SHIFT 0x6
#define MC_XPB_SUB_CTRL__STALL_WCB_HST_REQ_MASK 0x80
#define MC_XPB_SUB_CTRL__STALL_WCB_HST_REQ__SHIFT 0x7
#define MC_XPB_SUB_CTRL__STALL_HST_HOP_REQ_MASK 0x100
#define MC_XPB_SUB_CTRL__STALL_HST_HOP_REQ__SHIFT 0x8
#define MC_XPB_SUB_CTRL__STALL_XPB_RPB_REQ_ATTR_MASK 0x200
#define MC_XPB_SUB_CTRL__STALL_XPB_RPB_REQ_ATTR__SHIFT 0x9
#define MC_XPB_SUB_CTRL__RESET_CNS_MASK 0x400
#define MC_XPB_SUB_CTRL__RESET_CNS__SHIFT 0xa
#define MC_XPB_SUB_CTRL__RESET_RTR_MASK 0x800
#define MC_XPB_SUB_CTRL__RESET_RTR__SHIFT 0xb
#define MC_XPB_SUB_CTRL__RESET_RET_MASK 0x1000
#define MC_XPB_SUB_CTRL__RESET_RET__SHIFT 0xc
#define MC_XPB_SUB_CTRL__RESET_MAP_MASK 0x2000
#define MC_XPB_SUB_CTRL__RESET_MAP__SHIFT 0xd
#define MC_XPB_SUB_CTRL__RESET_WCB_MASK 0x4000
#define MC_XPB_SUB_CTRL__RESET_WCB__SHIFT 0xe
#define MC_XPB_SUB_CTRL__RESET_HST_MASK 0x8000
#define MC_XPB_SUB_CTRL__RESET_HST__SHIFT 0xf
#define MC_XPB_SUB_CTRL__RESET_HOP_MASK 0x10000
#define MC_XPB_SUB_CTRL__RESET_HOP__SHIFT 0x10
#define MC_XPB_SUB_CTRL__RESET_SID_MASK 0x20000
#define MC_XPB_SUB_CTRL__RESET_SID__SHIFT 0x11
#define MC_XPB_SUB_CTRL__RESET_SRB_MASK 0x40000
#define MC_XPB_SUB_CTRL__RESET_SRB__SHIFT 0x12
#define MC_XPB_SUB_CTRL__RESET_CGR_MASK 0x80000
#define MC_XPB_SUB_CTRL__RESET_CGR__SHIFT 0x13
#define MC_XPB_MAP_INVERT_FLUSH_NUM_LSB__ALTER_FLUSH_NUM_MASK 0xffff
#define MC_XPB_MAP_INVERT_FLUSH_NUM_LSB__ALTER_FLUSH_NUM__SHIFT 0x0
#define MC_XPB_PERF_KNOBS__CNS_FIFO_DEPTH_MASK 0x3f
#define MC_XPB_PERF_KNOBS__CNS_FIFO_DEPTH__SHIFT 0x0
#define MC_XPB_PERF_KNOBS__WCB_HST_FIFO_DEPTH_MASK 0xfc0
#define MC_XPB_PERF_KNOBS__WCB_HST_FIFO_DEPTH__SHIFT 0x6
#define MC_XPB_PERF_KNOBS__WCB_SID_FIFO_DEPTH_MASK 0x3f000
#define MC_XPB_PERF_KNOBS__WCB_SID_FIFO_DEPTH__SHIFT 0xc
#define MC_XPB_STICKY__BITS_MASK 0xffffffff
#define MC_XPB_STICKY__BITS__SHIFT 0x0
#define MC_XPB_STICKY_W1C__BITS_MASK 0xffffffff
#define MC_XPB_STICKY_W1C__BITS__SHIFT 0x0
#define MC_XPB_MISC_CFG__FIELDNAME0_MASK 0xff
#define MC_XPB_MISC_CFG__FIELDNAME0__SHIFT 0x0
#define MC_XPB_MISC_CFG__FIELDNAME1_MASK 0xff00
#define MC_XPB_MISC_CFG__FIELDNAME1__SHIFT 0x8
#define MC_XPB_MISC_CFG__FIELDNAME2_MASK 0xff0000
#define MC_XPB_MISC_CFG__FIELDNAME2__SHIFT 0x10
#define MC_XPB_MISC_CFG__FIELDNAME3_MASK 0x7f000000
#define MC_XPB_MISC_CFG__FIELDNAME3__SHIFT 0x18
#define MC_XPB_MISC_CFG__TRIGGERNAME_MASK 0x80000000
#define MC_XPB_MISC_CFG__TRIGGERNAME__SHIFT 0x1f
#define MC_XPB_CLG_CFG20__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG20__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG20__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG20__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG20__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG20__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG20__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG20__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG20__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG20__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG21__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG21__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG21__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG21__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG21__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG21__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG21__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG21__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG21__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG21__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG22__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG22__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG22__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG22__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG22__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG22__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG22__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG22__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG22__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG22__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG23__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG23__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG23__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG23__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG23__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG23__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG23__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG23__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG23__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG23__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG24__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG24__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG24__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG24__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG24__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG24__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG24__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG24__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG24__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG24__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG25__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG25__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG25__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG25__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG25__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG25__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG25__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG25__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG25__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG25__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG26__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG26__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG26__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG26__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG26__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG26__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG26__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG26__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG26__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG26__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG27__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG27__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG27__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG27__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG27__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG27__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG27__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG27__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG27__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG27__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG28__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG28__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG28__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG28__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG28__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG28__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG28__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG28__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG28__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG28__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG29__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG29__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG29__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG29__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG29__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG29__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG29__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG29__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG29__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG29__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG30__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG30__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG30__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG30__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG30__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG30__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG30__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG30__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG30__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG30__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG31__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG31__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG31__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG31__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG31__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG31__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG31__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG31__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG31__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG31__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_INTF_CFG2__RPB_RDREQ_CRD_MASK 0xff
#define MC_XPB_INTF_CFG2__RPB_RDREQ_CRD__SHIFT 0x0
#define MC_XPB_CLG_EXTRA_RD__CMP0_MASK 0xff
#define MC_XPB_CLG_EXTRA_RD__CMP0__SHIFT 0x0
#define MC_XPB_CLG_EXTRA_RD__MSK0_MASK 0xff00
#define MC_XPB_CLG_EXTRA_RD__MSK0__SHIFT 0x8
#define MC_XPB_CLG_EXTRA_RD__VLD0_MASK 0x10000
#define MC_XPB_CLG_EXTRA_RD__VLD0__SHIFT 0x10
#define MC_XPB_CLG_EXTRA_RD__CMP1_MASK 0x1fe0000
#define MC_XPB_CLG_EXTRA_RD__CMP1__SHIFT 0x11
#define MC_XPB_CLG_EXTRA_RD__VLD1_MASK 0x2000000
#define MC_XPB_CLG_EXTRA_RD__VLD1__SHIFT 0x19
#define MC_XPB_CLG_CFG32__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG32__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG32__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG32__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG32__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG32__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG32__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG32__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG32__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG32__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG33__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG33__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG33__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG33__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG33__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG33__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG33__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG33__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG33__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG33__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG34__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG34__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG34__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG34__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG34__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG34__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG34__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG34__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG34__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG34__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG35__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG35__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG35__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG35__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG35__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG35__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG35__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG35__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG35__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG35__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG36__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG36__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG36__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG36__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG36__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG36__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG36__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG36__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG36__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG36__SIDE_FLUSH__SHIFT 0xe
#define MC_XBAR_ADDR_DEC__NO_DIV_BY_3_MASK 0x1
#define MC_XBAR_ADDR_DEC__NO_DIV_BY_3__SHIFT 0x0
#define MC_XBAR_ADDR_DEC__GECC_MASK 0x2
#define MC_XBAR_ADDR_DEC__GECC__SHIFT 0x1
#define MC_XBAR_ADDR_DEC__RB_SPLIT_MASK 0x4
#define MC_XBAR_ADDR_DEC__RB_SPLIT__SHIFT 0x2
#define MC_XBAR_ADDR_DEC__RB_SPLIT_COLHI_MASK 0x8
#define MC_XBAR_ADDR_DEC__RB_SPLIT_COLHI__SHIFT 0x3
#define MC_XBAR_REMOTE__WRREQ_EN_GOQ_MASK 0x1
#define MC_XBAR_REMOTE__WRREQ_EN_GOQ__SHIFT 0x0
#define MC_XBAR_REMOTE__RDREQ_EN_GOQ_MASK 0x2
#define MC_XBAR_REMOTE__RDREQ_EN_GOQ__SHIFT 0x1
#define MC_XBAR_WRREQ_CREDIT__OUT0_MASK 0xff
#define MC_XBAR_WRREQ_CREDIT__OUT0__SHIFT 0x0
#define MC_XBAR_WRREQ_CREDIT__OUT1_MASK 0xff00
#define MC_XBAR_WRREQ_CREDIT__OUT1__SHIFT 0x8
#define MC_XBAR_WRREQ_CREDIT__OUT2_MASK 0xff0000
#define MC_XBAR_WRREQ_CREDIT__OUT2__SHIFT 0x10
#define MC_XBAR_WRREQ_CREDIT__OUT3_MASK 0xff000000
#define MC_XBAR_WRREQ_CREDIT__OUT3__SHIFT 0x18
#define MC_XBAR_RDREQ_CREDIT__OUT0_MASK 0xff
#define MC_XBAR_RDREQ_CREDIT__OUT0__SHIFT 0x0
#define MC_XBAR_RDREQ_CREDIT__OUT1_MASK 0xff00
#define MC_XBAR_RDREQ_CREDIT__OUT1__SHIFT 0x8
#define MC_XBAR_RDREQ_CREDIT__OUT2_MASK 0xff0000
#define MC_XBAR_RDREQ_CREDIT__OUT2__SHIFT 0x10
#define MC_XBAR_RDREQ_CREDIT__OUT3_MASK 0xff000000
#define MC_XBAR_RDREQ_CREDIT__OUT3__SHIFT 0x18
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT0_MASK 0xff
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT0__SHIFT 0x0
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT1_MASK 0xff00
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT1__SHIFT 0x8
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT2_MASK 0xff0000
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT2__SHIFT 0x10
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT3_MASK 0xff000000
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT3__SHIFT 0x18
#define MC_XBAR_WRRET_CREDIT1__OUT0_MASK 0xff
#define MC_XBAR_WRRET_CREDIT1__OUT0__SHIFT 0x0
#define MC_XBAR_WRRET_CREDIT1__OUT1_MASK 0xff00
#define MC_XBAR_WRRET_CREDIT1__OUT1__SHIFT 0x8
#define MC_XBAR_WRRET_CREDIT1__OUT2_MASK 0xff0000
#define MC_XBAR_WRRET_CREDIT1__OUT2__SHIFT 0x10
#define MC_XBAR_WRRET_CREDIT1__OUT3_MASK 0xff000000
#define MC_XBAR_WRRET_CREDIT1__OUT3__SHIFT 0x18
#define MC_XBAR_WRRET_CREDIT2__OUT4_MASK 0xff
#define MC_XBAR_WRRET_CREDIT2__OUT4__SHIFT 0x0
#define MC_XBAR_WRRET_CREDIT2__OUT5_MASK 0xff00
#define MC_XBAR_WRRET_CREDIT2__OUT5__SHIFT 0x8
#define MC_XBAR_RDRET_CREDIT1__OUT0_MASK 0xff
#define MC_XBAR_RDRET_CREDIT1__OUT0__SHIFT 0x0
#define MC_XBAR_RDRET_CREDIT1__OUT1_MASK 0xff00
#define MC_XBAR_RDRET_CREDIT1__OUT1__SHIFT 0x8
#define MC_XBAR_RDRET_CREDIT1__OUT2_MASK 0xff0000
#define MC_XBAR_RDRET_CREDIT1__OUT2__SHIFT 0x10
#define MC_XBAR_RDRET_CREDIT1__OUT3_MASK 0xff000000
#define MC_XBAR_RDRET_CREDIT1__OUT3__SHIFT 0x18
#define MC_XBAR_RDRET_CREDIT2__OUT4_MASK 0xff
#define MC_XBAR_RDRET_CREDIT2__OUT4__SHIFT 0x0
#define MC_XBAR_RDRET_CREDIT2__OUT5_MASK 0xff00
#define MC_XBAR_RDRET_CREDIT2__OUT5__SHIFT 0x8
#define MC_XBAR_RDRET_CREDIT2__HUB_LP_RDRET_SKID_MASK 0xff0000
#define MC_XBAR_RDRET_CREDIT2__HUB_LP_RDRET_SKID__SHIFT 0x10
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT0_MASK 0xff
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT0__SHIFT 0x0
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT1_MASK 0xff00
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT1__SHIFT 0x8
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT2_MASK 0xff0000
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT2__SHIFT 0x10
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT3_MASK 0xff000000
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT3__SHIFT 0x18
#define MC_XBAR_RDRET_PRI_CREDIT2__OUT4_MASK 0xff
#define MC_XBAR_RDRET_PRI_CREDIT2__OUT4__SHIFT 0x0
#define MC_XBAR_RDRET_PRI_CREDIT2__OUT5_MASK 0xff00
#define MC_XBAR_RDRET_PRI_CREDIT2__OUT5__SHIFT 0x8
#define MC_XBAR_CHTRIREMAP__CH0_MASK 0x3
#define MC_XBAR_CHTRIREMAP__CH0__SHIFT 0x0
#define MC_XBAR_CHTRIREMAP__CH1_MASK 0xc
#define MC_XBAR_CHTRIREMAP__CH1__SHIFT 0x2
#define MC_XBAR_CHTRIREMAP__CH2_MASK 0x30
#define MC_XBAR_CHTRIREMAP__CH2__SHIFT 0x4
#define MC_XBAR_TWOCHAN__DISABLE_ONEPORT_MASK 0x1
#define MC_XBAR_TWOCHAN__DISABLE_ONEPORT__SHIFT 0x0
#define MC_XBAR_TWOCHAN__CH0_MASK 0x6
#define MC_XBAR_TWOCHAN__CH0__SHIFT 0x1
#define MC_XBAR_TWOCHAN__CH1_MASK 0x18
#define MC_XBAR_TWOCHAN__CH1__SHIFT 0x3
#define MC_XBAR_ARB__HUBRD_HIGHEST_MASK 0x1
#define MC_XBAR_ARB__HUBRD_HIGHEST__SHIFT 0x0
#define MC_XBAR_ARB__DISABLE_HUB_STALL_HIGHEST_MASK 0x2
#define MC_XBAR_ARB__DISABLE_HUB_STALL_HIGHEST__SHIFT 0x1
#define MC_XBAR_ARB__BREAK_BURST_CID_CHANGE_MASK 0x4
#define MC_XBAR_ARB__BREAK_BURST_CID_CHANGE__SHIFT 0x2
#define MC_XBAR_ARB__ACP_RDRET_URG_MASK 0x8
#define MC_XBAR_ARB__ACP_RDRET_URG__SHIFT 0x3
#define MC_XBAR_ARB__HDP_RDRET_URG_MASK 0x10
#define MC_XBAR_ARB__HDP_RDRET_URG__SHIFT 0x4
#define MC_XBAR_ARB__BREAK_BURST_BY_URG_MASK 0x20
#define MC_XBAR_ARB__BREAK_BURST_BY_URG__SHIFT 0x5
#define MC_XBAR_ARB_MAX_BURST__RD_PORT0_MASK 0xf
#define MC_XBAR_ARB_MAX_BURST__RD_PORT0__SHIFT 0x0
#define MC_XBAR_ARB_MAX_BURST__RD_PORT1_MASK 0xf0
#define MC_XBAR_ARB_MAX_BURST__RD_PORT1__SHIFT 0x4
#define MC_XBAR_ARB_MAX_BURST__RD_PORT2_MASK 0xf00
#define MC_XBAR_ARB_MAX_BURST__RD_PORT2__SHIFT 0x8
#define MC_XBAR_ARB_MAX_BURST__RD_PORT3_MASK 0xf000
#define MC_XBAR_ARB_MAX_BURST__RD_PORT3__SHIFT 0xc
#define MC_XBAR_ARB_MAX_BURST__WR_PORT0_MASK 0xf0000
#define MC_XBAR_ARB_MAX_BURST__WR_PORT0__SHIFT 0x10
#define MC_XBAR_ARB_MAX_BURST__WR_PORT1_MASK 0xf00000
#define MC_XBAR_ARB_MAX_BURST__WR_PORT1__SHIFT 0x14
#define MC_XBAR_ARB_MAX_BURST__WR_PORT2_MASK 0xf000000
#define MC_XBAR_ARB_MAX_BURST__WR_PORT2__SHIFT 0x18
#define MC_XBAR_ARB_MAX_BURST__WR_PORT3_MASK 0xf0000000
#define MC_XBAR_ARB_MAX_BURST__WR_PORT3__SHIFT 0x1c
#define MC_XBAR_FIFO_MON_CNTL0__START_THRESH_MASK 0xfff
#define MC_XBAR_FIFO_MON_CNTL0__START_THRESH__SHIFT 0x0
#define MC_XBAR_FIFO_MON_CNTL0__STOP_THRESH_MASK 0xfff000
#define MC_XBAR_FIFO_MON_CNTL0__STOP_THRESH__SHIFT 0xc
#define MC_XBAR_FIFO_MON_CNTL0__START_MODE_MASK 0x3000000
#define MC_XBAR_FIFO_MON_CNTL0__START_MODE__SHIFT 0x18
#define MC_XBAR_FIFO_MON_CNTL0__STOP_MODE_MASK 0xc000000
#define MC_XBAR_FIFO_MON_CNTL0__STOP_MODE__SHIFT 0x1a
#define MC_XBAR_FIFO_MON_CNTL0__ALLOW_WRAP_MASK 0x10000000
#define MC_XBAR_FIFO_MON_CNTL0__ALLOW_WRAP__SHIFT 0x1c
#define MC_XBAR_FIFO_MON_CNTL1__THRESH_CNTR_ID_MASK 0xff
#define MC_XBAR_FIFO_MON_CNTL1__THRESH_CNTR_ID__SHIFT 0x0
#define MC_XBAR_FIFO_MON_CNTL1__START_TRIG_ID_MASK 0xff00
#define MC_XBAR_FIFO_MON_CNTL1__START_TRIG_ID__SHIFT 0x8
#define MC_XBAR_FIFO_MON_CNTL1__STOP_TRIG_ID_MASK 0xff0000
#define MC_XBAR_FIFO_MON_CNTL1__STOP_TRIG_ID__SHIFT 0x10
#define MC_XBAR_FIFO_MON_CNTL2__MON0_ID_MASK 0xff
#define MC_XBAR_FIFO_MON_CNTL2__MON0_ID__SHIFT 0x0
#define MC_XBAR_FIFO_MON_CNTL2__MON1_ID_MASK 0xff00
#define MC_XBAR_FIFO_MON_CNTL2__MON1_ID__SHIFT 0x8
#define MC_XBAR_FIFO_MON_CNTL2__MON2_ID_MASK 0xff0000
#define MC_XBAR_FIFO_MON_CNTL2__MON2_ID__SHIFT 0x10
#define MC_XBAR_FIFO_MON_CNTL2__MON3_ID_MASK 0xff000000
#define MC_XBAR_FIFO_MON_CNTL2__MON3_ID__SHIFT 0x18
#define MC_XBAR_FIFO_MON_RSLT0__COUNT_MASK 0xffffffff
#define MC_XBAR_FIFO_MON_RSLT0__COUNT__SHIFT 0x0
#define MC_XBAR_FIFO_MON_RSLT1__COUNT_MASK 0xffffffff
#define MC_XBAR_FIFO_MON_RSLT1__COUNT__SHIFT 0x0
#define MC_XBAR_FIFO_MON_RSLT2__COUNT_MASK 0xffffffff
#define MC_XBAR_FIFO_MON_RSLT2__COUNT__SHIFT 0x0
#define MC_XBAR_FIFO_MON_RSLT3__COUNT_MASK 0xffffffff
#define MC_XBAR_FIFO_MON_RSLT3__COUNT__SHIFT 0x0
#define MC_XBAR_FIFO_MON_MAX_THSH__MON0_MASK 0xff
#define MC_XBAR_FIFO_MON_MAX_THSH__MON0__SHIFT 0x0
#define MC_XBAR_FIFO_MON_MAX_THSH__MON1_MASK 0xff00
#define MC_XBAR_FIFO_MON_MAX_THSH__MON1__SHIFT 0x8
#define MC_XBAR_FIFO_MON_MAX_THSH__MON2_MASK 0xff0000
#define MC_XBAR_FIFO_MON_MAX_THSH__MON2__SHIFT 0x10
#define MC_XBAR_FIFO_MON_MAX_THSH__MON3_MASK 0xff000000
#define MC_XBAR_FIFO_MON_MAX_THSH__MON3__SHIFT 0x18
#define MC_XBAR_SPARE0__BIT_MASK 0xffffffff
#define MC_XBAR_SPARE0__BIT__SHIFT 0x0
#define MC_XBAR_SPARE1__BIT_MASK 0xffffffff
#define MC_XBAR_SPARE1__BIT__SHIFT 0x0
#define MC_CITF_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_CITF_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_HUB_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_HUB_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_RPB_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_RPB_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_MCBVM_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_MCDVM_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_VM_L2_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_ARB_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_ARB_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define ATC_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define ATC_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_CITF_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_CITF_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_CITF_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_CITF_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_HUB_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_HUB_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_HUB_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_HUB_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_MCBVM_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_MCBVM_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_MCBVM_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_MCDVM_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_MCDVM_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_MCDVM_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_RPB_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_RPB_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_RPB_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_RPB_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_VM_L2_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_VM_L2_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_VM_L2_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_ARB_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_ARB_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_ARB_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_ARB_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define ATC_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define ATC_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define ATC_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define ATC_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_CITF_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_CITF_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_CITF_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_CITF_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_CITF_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_CITF_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_CITF_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_CITF_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_CITF_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_CITF_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_CITF_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_CITF_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_CITF_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_CITF_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_CITF_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_CITF_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_CITF_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_CITF_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_CITF_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_CITF_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_CITF_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_CITF_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_CITF_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_CITF_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_CITF_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_CITF_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_CITF_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_CITF_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_CITF_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_CITF_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_CITF_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_CITF_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_CITF_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_CITF_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_CITF_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_CITF_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_CITF_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_CITF_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_CITF_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_CITF_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_HUB_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_HUB_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_HUB_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_HUB_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_HUB_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_HUB_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_HUB_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_HUB_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_HUB_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_HUB_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_HUB_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_HUB_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_HUB_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_HUB_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_HUB_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_HUB_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_HUB_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_HUB_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_HUB_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_HUB_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_HUB_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_HUB_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_HUB_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_HUB_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_HUB_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_HUB_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_HUB_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_HUB_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_HUB_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_HUB_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_HUB_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_HUB_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_HUB_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_HUB_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_HUB_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_HUB_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_HUB_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_HUB_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_HUB_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_HUB_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_RPB_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_RPB_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_RPB_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_RPB_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_RPB_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_RPB_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_RPB_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_RPB_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_RPB_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_RPB_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_RPB_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_RPB_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_RPB_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_RPB_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_RPB_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_RPB_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_RPB_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_RPB_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_RPB_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_RPB_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_RPB_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_RPB_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_RPB_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_RPB_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_RPB_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_RPB_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_RPB_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_RPB_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_RPB_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_RPB_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_RPB_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_RPB_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_RPB_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_RPB_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_RPB_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_RPB_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_RPB_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_RPB_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_RPB_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_RPB_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_ARB_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_ARB_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_ARB_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_ARB_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_ARB_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_ARB_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_ARB_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_ARB_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_ARB_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_ARB_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_ARB_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_ARB_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_ARB_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_ARB_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_ARB_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_ARB_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_ARB_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_ARB_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_ARB_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_ARB_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_ARB_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_ARB_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_ARB_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_ARB_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_ARB_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_ARB_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_ARB_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_ARB_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_ARB_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_ARB_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_ARB_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_ARB_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_ARB_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_ARB_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_ARB_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_ARB_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_ARB_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_ARB_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_ARB_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_ARB_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_MCBVM_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_MCBVM_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_MCBVM_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_MCBVM_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_MCBVM_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_MCBVM_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_MCBVM_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_MCBVM_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_MCBVM_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_MCBVM_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_MCBVM_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_MCBVM_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_MCDVM_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_MCDVM_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_MCDVM_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_MCDVM_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_MCDVM_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_MCDVM_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_MCDVM_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_MCDVM_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_MCDVM_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_MCDVM_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_MCDVM_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_MCDVM_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define ATC_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define ATC_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define ATC_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define ATC_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define ATC_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define ATC_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define ATC_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define ATC_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define ATC_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define ATC_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define ATC_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define ATC_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define ATC_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define ATC_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define ATC_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define ATC_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define ATC_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define ATC_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define ATC_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define ATC_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define ATC_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define ATC_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define ATC_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define ATC_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define ATC_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define ATC_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define ATC_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define ATC_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define ATC_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define ATC_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define ATC_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define ATC_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define ATC_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define ATC_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define ATC_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define ATC_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define ATC_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define ATC_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define ATC_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define ATC_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_VM_L2_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_VM_L2_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_VM_L2_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_VM_L2_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_VM_L2_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_VM_L2_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_VM_L2_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_VM_L2_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define ATC_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define ATC_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define ATC_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define ATC_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define ATC_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define ATC_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define ATC_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define ATC_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define ATC_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define ATC_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define ATC_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define ATC_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define CHUB_ATC_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define CHUB_ATC_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define CHUB_ATC_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define CHUB_ATC_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define CHUB_ATC_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define CHUB_ATC_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define CHUB_ATC_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define CHUB_ATC_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define CHUB_ATC_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define CHUB_ATC_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define CHUB_ATC_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define CHUB_ATC_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define ATC_VM_APERTURE0_LOW_ADDR__VIRTUAL_PAGE_NUMBER_MASK 0xfffffff
#define ATC_VM_APERTURE0_LOW_ADDR__VIRTUAL_PAGE_NUMBER__SHIFT 0x0
#define ATC_VM_APERTURE1_LOW_ADDR__VIRTUAL_PAGE_NUMBER_MASK 0xfffffff
#define ATC_VM_APERTURE1_LOW_ADDR__VIRTUAL_PAGE_NUMBER__SHIFT 0x0
#define ATC_VM_APERTURE0_HIGH_ADDR__VIRTUAL_PAGE_NUMBER_MASK 0xfffffff
#define ATC_VM_APERTURE0_HIGH_ADDR__VIRTUAL_PAGE_NUMBER__SHIFT 0x0
#define ATC_VM_APERTURE1_HIGH_ADDR__VIRTUAL_PAGE_NUMBER_MASK 0xfffffff
#define ATC_VM_APERTURE1_HIGH_ADDR__VIRTUAL_PAGE_NUMBER__SHIFT 0x0
#define ATC_VM_APERTURE0_CNTL__ATS_ACCESS_MODE_MASK 0x3
#define ATC_VM_APERTURE0_CNTL__ATS_ACCESS_MODE__SHIFT 0x0
#define ATC_VM_APERTURE1_CNTL__ATS_ACCESS_MODE_MASK 0x3
#define ATC_VM_APERTURE1_CNTL__ATS_ACCESS_MODE__SHIFT 0x0
#define ATC_VM_APERTURE0_CNTL2__VMIDS_USING_RANGE_MASK 0xffff
#define ATC_VM_APERTURE0_CNTL2__VMIDS_USING_RANGE__SHIFT 0x0
#define ATC_VM_APERTURE1_CNTL2__VMIDS_USING_RANGE_MASK 0xffff
#define ATC_VM_APERTURE1_CNTL2__VMIDS_USING_RANGE__SHIFT 0x0
#define ATC_ATS_CNTL__DISABLE_ATC_MASK 0x1
#define ATC_ATS_CNTL__DISABLE_ATC__SHIFT 0x0
#define ATC_ATS_CNTL__DISABLE_PRI_MASK 0x2
#define ATC_ATS_CNTL__DISABLE_PRI__SHIFT 0x1
#define ATC_ATS_CNTL__DISABLE_PASID_MASK 0x4
#define ATC_ATS_CNTL__DISABLE_PASID__SHIFT 0x2
#define ATC_ATS_CNTL__CREDITS_ATS_RPB_MASK 0x3f00
#define ATC_ATS_CNTL__CREDITS_ATS_RPB__SHIFT 0x8
#define ATC_ATS_CNTL__DEBUG_ECO_MASK 0xf0000
#define ATC_ATS_CNTL__DEBUG_ECO__SHIFT 0x10
#define ATC_ATS_DEBUG__INVALIDATE_ALL_MASK 0x1
#define ATC_ATS_DEBUG__INVALIDATE_ALL__SHIFT 0x0
#define ATC_ATS_DEBUG__IDENT_RETURN_MASK 0x2
#define ATC_ATS_DEBUG__IDENT_RETURN__SHIFT 0x1
#define ATC_ATS_DEBUG__ADDRESS_TRANSLATION_REQUEST_WRITE_PERMS_MASK 0x4
#define ATC_ATS_DEBUG__ADDRESS_TRANSLATION_REQUEST_WRITE_PERMS__SHIFT 0x2
#define ATC_ATS_DEBUG__PAGE_REQUESTS_USE_RELAXED_ORDERING_MASK 0x20
#define ATC_ATS_DEBUG__PAGE_REQUESTS_USE_RELAXED_ORDERING__SHIFT 0x5
#define ATC_ATS_DEBUG__PRIV_BIT_MASK 0x40
#define ATC_ATS_DEBUG__PRIV_BIT__SHIFT 0x6
#define ATC_ATS_DEBUG__EXE_BIT_MASK 0x80
#define ATC_ATS_DEBUG__EXE_BIT__SHIFT 0x7
#define ATC_ATS_DEBUG__PAGE_REQUEST_PERMS_MASK 0x100
#define ATC_ATS_DEBUG__PAGE_REQUEST_PERMS__SHIFT 0x8
#define ATC_ATS_DEBUG__UNTRANSLATED_ONLY_REQUESTS_CARRY_SIZE_MASK 0x200
#define ATC_ATS_DEBUG__UNTRANSLATED_ONLY_REQUESTS_CARRY_SIZE__SHIFT 0x9
#define ATC_ATS_DEBUG__NUM_REQUESTS_AT_ERR_MASK 0x3c00
#define ATC_ATS_DEBUG__NUM_REQUESTS_AT_ERR__SHIFT 0xa
#define ATC_ATS_DEBUG__DISALLOW_ERR_TO_DONE_MASK 0x4000
#define ATC_ATS_DEBUG__DISALLOW_ERR_TO_DONE__SHIFT 0xe
#define ATC_ATS_DEBUG__IGNORE_FED_MASK 0x8000
#define ATC_ATS_DEBUG__IGNORE_FED__SHIFT 0xf
#define ATC_ATS_DEBUG__INVALIDATION_REQUESTS_DISALLOWED_WHEN_ATC_IS_DISABLED_MASK 0x10000
#define ATC_ATS_DEBUG__INVALIDATION_REQUESTS_DISALLOWED_WHEN_ATC_IS_DISABLED__SHIFT 0x10
#define ATC_ATS_DEBUG__DEBUG_BUS_SELECT_MASK 0x20000
#define ATC_ATS_DEBUG__DEBUG_BUS_SELECT__SHIFT 0x11
#define ATC_ATS_DEBUG__DISABLE_INVALIDATE_PER_DOMAIN_MASK 0x40000
#define ATC_ATS_DEBUG__DISABLE_INVALIDATE_PER_DOMAIN__SHIFT 0x12
#define ATC_ATS_DEBUG__DISABLE_VMID0_PASID_MAPPING_MASK 0x80000
#define ATC_ATS_DEBUG__DISABLE_VMID0_PASID_MAPPING__SHIFT 0x13
#define ATC_ATS_DEBUG__DISABLE_INVALIDATION_ON_WORLD_SWITCH_MASK 0x100000
#define ATC_ATS_DEBUG__DISABLE_INVALIDATION_ON_WORLD_SWITCH__SHIFT 0x14
#define ATC_ATS_DEBUG__ENABLE_INVALIDATION_ON_VIRTUALIZATION_ENTRY_AND_EXIT_MASK 0x200000
#define ATC_ATS_DEBUG__ENABLE_INVALIDATION_ON_VIRTUALIZATION_ENTRY_AND_EXIT__SHIFT 0x15
#define ATC_ATS_FAULT_DEBUG__CREDITS_ATS_IH_MASK 0x1f
#define ATC_ATS_FAULT_DEBUG__CREDITS_ATS_IH__SHIFT 0x0
#define ATC_ATS_FAULT_DEBUG__ALLOW_SUBSEQUENT_FAULT_STATUS_ADDR_UPDATES_MASK 0x100
#define ATC_ATS_FAULT_DEBUG__ALLOW_SUBSEQUENT_FAULT_STATUS_ADDR_UPDATES__SHIFT 0x8
#define ATC_ATS_FAULT_DEBUG__CLEAR_FAULT_STATUS_ADDR_MASK 0x10000
#define ATC_ATS_FAULT_DEBUG__CLEAR_FAULT_STATUS_ADDR__SHIFT 0x10
#define ATC_ATS_STATUS__BUSY_MASK 0x1
#define ATC_ATS_STATUS__BUSY__SHIFT 0x0
#define ATC_ATS_STATUS__CRASHED_MASK 0x2
#define ATC_ATS_STATUS__CRASHED__SHIFT 0x1
#define ATC_ATS_STATUS__DEADLOCK_DETECTION_MASK 0x4
#define ATC_ATS_STATUS__DEADLOCK_DETECTION__SHIFT 0x2
#define ATC_ATS_FAULT_CNTL__FAULT_REGISTER_LOG_MASK 0x1ff
#define ATC_ATS_FAULT_CNTL__FAULT_REGISTER_LOG__SHIFT 0x0
#define ATC_ATS_FAULT_CNTL__FAULT_INTERRUPT_TABLE_MASK 0x7fc00
#define ATC_ATS_FAULT_CNTL__FAULT_INTERRUPT_TABLE__SHIFT 0xa
#define ATC_ATS_FAULT_CNTL__FAULT_CRASH_TABLE_MASK 0x1ff00000
#define ATC_ATS_FAULT_CNTL__FAULT_CRASH_TABLE__SHIFT 0x14
#define ATC_ATS_FAULT_STATUS_INFO__FAULT_TYPE_MASK 0x1ff
#define ATC_ATS_FAULT_STATUS_INFO__FAULT_TYPE__SHIFT 0x0
#define ATC_ATS_FAULT_STATUS_INFO__VMID_MASK 0x7c00
#define ATC_ATS_FAULT_STATUS_INFO__VMID__SHIFT 0xa
#define ATC_ATS_FAULT_STATUS_INFO__EXTRA_INFO_MASK 0x8000
#define ATC_ATS_FAULT_STATUS_INFO__EXTRA_INFO__SHIFT 0xf
#define ATC_ATS_FAULT_STATUS_INFO__EXTRA_INFO2_MASK 0x10000
#define ATC_ATS_FAULT_STATUS_INFO__EXTRA_INFO2__SHIFT 0x10
#define ATC_ATS_FAULT_STATUS_INFO__INVALIDATION_MASK 0x20000
#define ATC_ATS_FAULT_STATUS_INFO__INVALIDATION__SHIFT 0x11
#define ATC_ATS_FAULT_STATUS_INFO__PAGE_REQUEST_MASK 0x40000
#define ATC_ATS_FAULT_STATUS_INFO__PAGE_REQUEST__SHIFT 0x12
#define ATC_ATS_FAULT_STATUS_INFO__STATUS_MASK 0xf80000
#define ATC_ATS_FAULT_STATUS_INFO__STATUS__SHIFT 0x13
#define ATC_ATS_FAULT_STATUS_INFO__PAGE_ADDR_HIGH_MASK 0xf000000
#define ATC_ATS_FAULT_STATUS_INFO__PAGE_ADDR_HIGH__SHIFT 0x18
#define ATC_ATS_FAULT_STATUS_ADDR__PAGE_ADDR_MASK 0xffffffff
#define ATC_ATS_FAULT_STATUS_ADDR__PAGE_ADDR__SHIFT 0x0
#define ATC_ATS_DEFAULT_PAGE_LOW__DEFAULT_PAGE_MASK 0xfffffff
#define ATC_ATS_DEFAULT_PAGE_LOW__DEFAULT_PAGE__SHIFT 0x0
#define ATC_ATS_DEFAULT_PAGE_CNTL__SEND_DEFAULT_PAGE_MASK 0x1
#define ATC_ATS_DEFAULT_PAGE_CNTL__SEND_DEFAULT_PAGE__SHIFT 0x0
#define ATC_ATS_FAULT_STATUS_INFO2__VF_MASK 0x1
#define ATC_ATS_FAULT_STATUS_INFO2__VF__SHIFT 0x0
#define ATC_ATS_FAULT_STATUS_INFO2__VFID_MASK 0x3e
#define ATC_ATS_FAULT_STATUS_INFO2__VFID__SHIFT 0x1
#define ATC_ATS_FAULT_STATUS_INFO2__L1_ID_MASK 0x1fe00
#define ATC_ATS_FAULT_STATUS_INFO2__L1_ID__SHIFT 0x9
#define ATC_MISC_CG__OFFDLY_MASK 0xfc0
#define ATC_MISC_CG__OFFDLY__SHIFT 0x6
#define ATC_MISC_CG__ENABLE_MASK 0x40000
#define ATC_MISC_CG__ENABLE__SHIFT 0x12
#define ATC_MISC_CG__MEM_LS_ENABLE_MASK 0x80000
#define ATC_MISC_CG__MEM_LS_ENABLE__SHIFT 0x13
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READ_REQUESTS_MASK 0x3
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READ_REQUESTS__SHIFT 0x0
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITE_REQUESTS_MASK 0x30
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITE_REQUESTS__SHIFT 0x4
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READS_DEPENDS_ON_ADDR_MOD_MASK 0x100
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READS_DEPENDS_ON_ADDR_MOD__SHIFT 0x8
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITES_DEPENDS_ON_ADDR_MOD_MASK 0x200
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITES_DEPENDS_ON_ADDR_MOD__SHIFT 0x9
#define ATC_L2_CNTL2__BANK_SELECT_MASK 0x3f
#define ATC_L2_CNTL2__BANK_SELECT__SHIFT 0x0
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_MODE_MASK 0xc0
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_MODE__SHIFT 0x6
#define ATC_L2_CNTL2__ENABLE_L2_CACHE_LRU_UPDATE_BY_WRITE_MASK 0x100
#define ATC_L2_CNTL2__ENABLE_L2_CACHE_LRU_UPDATE_BY_WRITE__SHIFT 0x8
#define ATC_L2_CNTL2__L2_CACHE_SWAP_TAG_INDEX_LSBS_MASK 0xe00
#define ATC_L2_CNTL2__L2_CACHE_SWAP_TAG_INDEX_LSBS__SHIFT 0x9
#define ATC_L2_CNTL2__L2_CACHE_VMID_MODE_MASK 0x7000
#define ATC_L2_CNTL2__L2_CACHE_VMID_MODE__SHIFT 0xc
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE_MASK 0x1f8000
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE__SHIFT 0xf
#define ATC_L2_DEBUG__CREDITS_L2_ATS_MASK 0x3f
#define ATC_L2_DEBUG__CREDITS_L2_ATS__SHIFT 0x0
#define ATC_L2_DEBUG__L2_MEM_SELECT_MASK 0x80
#define ATC_L2_DEBUG__L2_MEM_SELECT__SHIFT 0x7
#define ATC_L2_DEBUG__CACHE_INDEX_MASK 0xfff00
#define ATC_L2_DEBUG__CACHE_INDEX__SHIFT 0x8
#define ATC_L2_DEBUG__CACHE_SELECT_MASK 0x1000000
#define ATC_L2_DEBUG__CACHE_SELECT__SHIFT 0x18
#define ATC_L2_DEBUG__CACHE_BANK_SELECT_MASK 0x2000000
#define ATC_L2_DEBUG__CACHE_BANK_SELECT__SHIFT 0x19
#define ATC_L2_DEBUG__CACHE_WAY_SELECT_MASK 0x8000000
#define ATC_L2_DEBUG__CACHE_WAY_SELECT__SHIFT 0x1b
#define ATC_L2_DEBUG__CACHE_READ_MASK 0x20000000
#define ATC_L2_DEBUG__CACHE_READ__SHIFT 0x1d
#define ATC_L2_DEBUG__CACHE_INJECT_SOFT_PARITY_ERROR_MASK 0x40000000
#define ATC_L2_DEBUG__CACHE_INJECT_SOFT_PARITY_ERROR__SHIFT 0x1e
#define ATC_L2_DEBUG__CACHE_INJECT_HARD_PARITY_ERROR_MASK 0x80000000
#define ATC_L2_DEBUG__CACHE_INJECT_HARD_PARITY_ERROR__SHIFT 0x1f
#define ATC_L2_DEBUG2__EFFECTIVE_CACHE_SIZE_MASK 0x1f
#define ATC_L2_DEBUG2__EFFECTIVE_CACHE_SIZE__SHIFT 0x0
#define ATC_L2_DEBUG2__EFFECTIVE_WORK_QUEUE_SIZE_MASK 0xe0
#define ATC_L2_DEBUG2__EFFECTIVE_WORK_QUEUE_SIZE__SHIFT 0x5
#define ATC_L2_DEBUG2__FORCE_CACHE_MISS_MASK 0x100
#define ATC_L2_DEBUG2__FORCE_CACHE_MISS__SHIFT 0x8
#define ATC_L2_DEBUG2__INVALIDATE_ALL_MASK 0x200
#define ATC_L2_DEBUG2__INVALIDATE_ALL__SHIFT 0x9
#define ATC_L2_DEBUG2__DISABLE_2M_CACHE_MASK 0x400
#define ATC_L2_DEBUG2__DISABLE_2M_CACHE__SHIFT 0xa
#define ATC_L2_DEBUG2__DISABLE_CACHING_SPECULATIVE_RETURNS_MASK 0x800
#define ATC_L2_DEBUG2__DISABLE_CACHING_SPECULATIVE_RETURNS__SHIFT 0xb
#define ATC_L2_DEBUG2__DISABLE_CACHING_FAULT_RETURNS_MASK 0x4000
#define ATC_L2_DEBUG2__DISABLE_CACHING_FAULT_RETURNS__SHIFT 0xe
#define ATC_L2_DEBUG2__DEBUG_BUS_SELECT_MASK 0x18000
#define ATC_L2_DEBUG2__DEBUG_BUS_SELECT__SHIFT 0xf
#define ATC_L2_DEBUG2__DEBUG_ECO_MASK 0x60000
#define ATC_L2_DEBUG2__DEBUG_ECO__SHIFT 0x11
#define ATC_L2_DEBUG2__EFFECTIVE_2M_CACHE_SIZE_MASK 0x780000
#define ATC_L2_DEBUG2__EFFECTIVE_2M_CACHE_SIZE__SHIFT 0x13
#define ATC_L2_DEBUG2__CACHE_PARITY_ERROR_INTERRUPT_THRESHOLD_MASK 0x7f800000
#define ATC_L2_DEBUG2__CACHE_PARITY_ERROR_INTERRUPT_THRESHOLD__SHIFT 0x17
#define ATC_L2_DEBUG2__CLEAR_PARITY_ERROR_INFO_MASK 0x80000000
#define ATC_L2_DEBUG2__CLEAR_PARITY_ERROR_INFO__SHIFT 0x1f
#define ATC_L2_CACHE_DATA0__DATA_REGISTER_VALID_MASK 0x1
#define ATC_L2_CACHE_DATA0__DATA_REGISTER_VALID__SHIFT 0x0
#define ATC_L2_CACHE_DATA0__CACHE_ENTRY_VALID_MASK 0x2
#define ATC_L2_CACHE_DATA0__CACHE_ENTRY_VALID__SHIFT 0x1
#define ATC_L2_CACHE_DATA0__CACHED_ATTRIBUTES_MASK 0x1fffffc
#define ATC_L2_CACHE_DATA0__CACHED_ATTRIBUTES__SHIFT 0x2
#define ATC_L2_CACHE_DATA0__VIRTUAL_PAGE_ADDRESS_HIGH_MASK 0x1e000000
#define ATC_L2_CACHE_DATA0__VIRTUAL_PAGE_ADDRESS_HIGH__SHIFT 0x19
#define ATC_L2_CACHE_DATA1__VIRTUAL_PAGE_ADDRESS_LOW_MASK 0xffffffff
#define ATC_L2_CACHE_DATA1__VIRTUAL_PAGE_ADDRESS_LOW__SHIFT 0x0
#define ATC_L2_CACHE_DATA2__PHYSICAL_PAGE_ADDRESS_LOW_MASK 0xfffffff
#define ATC_L2_CACHE_DATA2__PHYSICAL_PAGE_ADDRESS_LOW__SHIFT 0x0
#define ATC_L1_CNTL__DONT_NEED_ATS_BEHAVIOR_MASK 0x3
#define ATC_L1_CNTL__DONT_NEED_ATS_BEHAVIOR__SHIFT 0x0
#define ATC_L1_CNTL__NEED_ATS_BEHAVIOR_MASK 0x4
#define ATC_L1_CNTL__NEED_ATS_BEHAVIOR__SHIFT 0x2
#define ATC_L1_CNTL__NEED_ATS_SNOOP_DEFAULT_MASK 0x10
#define ATC_L1_CNTL__NEED_ATS_SNOOP_DEFAULT__SHIFT 0x4
#define ATC_L1_ADDRESS_OFFSET__LOGICAL_ADDRESS_MASK 0xffffffff
#define ATC_L1_ADDRESS_OFFSET__LOGICAL_ADDRESS__SHIFT 0x0
#define ATC_L1RD_DEBUG_TLB__DISABLE_FRAGMENTS_MASK 0x1
#define ATC_L1RD_DEBUG_TLB__DISABLE_FRAGMENTS__SHIFT 0x0
#define ATC_L1RD_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE_MASK 0x2
#define ATC_L1RD_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE__SHIFT 0x1
#define ATC_L1RD_DEBUG_TLB__EFFECTIVE_CAM_SIZE_MASK 0xf0
#define ATC_L1RD_DEBUG_TLB__EFFECTIVE_CAM_SIZE__SHIFT 0x4
#define ATC_L1RD_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE_MASK 0x700
#define ATC_L1RD_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE__SHIFT 0x8
#define ATC_L1RD_DEBUG_TLB__CREDITS_L1_L2_MASK 0x3f000
#define ATC_L1RD_DEBUG_TLB__CREDITS_L1_L2__SHIFT 0xc
#define ATC_L1RD_DEBUG_TLB__CREDITS_L1_RPB_MASK 0xff00000
#define ATC_L1RD_DEBUG_TLB__CREDITS_L1_RPB__SHIFT 0x14
#define ATC_L1RD_DEBUG_TLB__DEBUG_ECO_MASK 0x30000000
#define ATC_L1RD_DEBUG_TLB__DEBUG_ECO__SHIFT 0x1c
#define ATC_L1RD_DEBUG_TLB__INVALIDATE_ALL_MASK 0x40000000
#define ATC_L1RD_DEBUG_TLB__INVALIDATE_ALL__SHIFT 0x1e
#define ATC_L1RD_DEBUG_TLB__DISABLE_CACHING_FAULT_RETURNS_MASK 0x80000000
#define ATC_L1RD_DEBUG_TLB__DISABLE_CACHING_FAULT_RETURNS__SHIFT 0x1f
#define ATC_L1WR_DEBUG_TLB__DISABLE_FRAGMENTS_MASK 0x1
#define ATC_L1WR_DEBUG_TLB__DISABLE_FRAGMENTS__SHIFT 0x0
#define ATC_L1WR_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE_MASK 0x2
#define ATC_L1WR_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE__SHIFT 0x1
#define ATC_L1WR_DEBUG_TLB__EFFECTIVE_CAM_SIZE_MASK 0xf0
#define ATC_L1WR_DEBUG_TLB__EFFECTIVE_CAM_SIZE__SHIFT 0x4
#define ATC_L1WR_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE_MASK 0x700
#define ATC_L1WR_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE__SHIFT 0x8
#define ATC_L1WR_DEBUG_TLB__CREDITS_L1_L2_MASK 0x3f000
#define ATC_L1WR_DEBUG_TLB__CREDITS_L1_L2__SHIFT 0xc
#define ATC_L1WR_DEBUG_TLB__CREDITS_L1_RPB_MASK 0xff00000
#define ATC_L1WR_DEBUG_TLB__CREDITS_L1_RPB__SHIFT 0x14
#define ATC_L1WR_DEBUG_TLB__DEBUG_ECO_MASK 0x30000000
#define ATC_L1WR_DEBUG_TLB__DEBUG_ECO__SHIFT 0x1c
#define ATC_L1WR_DEBUG_TLB__INVALIDATE_ALL_MASK 0x40000000
#define ATC_L1WR_DEBUG_TLB__INVALIDATE_ALL__SHIFT 0x1e
#define ATC_L1WR_DEBUG_TLB__DISABLE_CACHING_FAULT_RETURNS_MASK 0x80000000
#define ATC_L1WR_DEBUG_TLB__DISABLE_CACHING_FAULT_RETURNS__SHIFT 0x1f
#define ATC_L1RD_STATUS__BUSY_MASK 0x1
#define ATC_L1RD_STATUS__BUSY__SHIFT 0x0
#define ATC_L1RD_STATUS__DEADLOCK_DETECTION_MASK 0x2
#define ATC_L1RD_STATUS__DEADLOCK_DETECTION__SHIFT 0x1
#define ATC_L1RD_STATUS__BAD_NEED_ATS_MASK 0x100
#define ATC_L1RD_STATUS__BAD_NEED_ATS__SHIFT 0x8
#define ATC_L1RD_STATUS__CAM_PARITY_ERRORS_MASK 0x1f000
#define ATC_L1RD_STATUS__CAM_PARITY_ERRORS__SHIFT 0xc
#define ATC_L1RD_STATUS__CAM_INDEX_MASK 0x3e0000
#define ATC_L1RD_STATUS__CAM_INDEX__SHIFT 0x11
#define ATC_L1WR_STATUS__BUSY_MASK 0x1
#define ATC_L1WR_STATUS__BUSY__SHIFT 0x0
#define ATC_L1WR_STATUS__DEADLOCK_DETECTION_MASK 0x2
#define ATC_L1WR_STATUS__DEADLOCK_DETECTION__SHIFT 0x1
#define ATC_L1WR_STATUS__BAD_NEED_ATS_MASK 0x100
#define ATC_L1WR_STATUS__BAD_NEED_ATS__SHIFT 0x8
#define ATC_L1WR_STATUS__CAM_PARITY_ERRORS_MASK 0x1f000
#define ATC_L1WR_STATUS__CAM_PARITY_ERRORS__SHIFT 0xc
#define ATC_L1WR_STATUS__CAM_INDEX_MASK 0x3e0000
#define ATC_L1WR_STATUS__CAM_INDEX__SHIFT 0x11
#define ATC_L1RD_DEBUG2_TLB__XNACK_RETRY_PERIOD_MASK 0xfff
#define ATC_L1RD_DEBUG2_TLB__XNACK_RETRY_PERIOD__SHIFT 0x0
#define ATC_L1RD_DEBUG2_TLB__XNACK_RETRY_MODE_MASK 0xc000
#define ATC_L1RD_DEBUG2_TLB__XNACK_RETRY_MODE__SHIFT 0xe
#define ATC_L1RD_DEBUG2_TLB__INJECT_SOFT_PARITY_ERROR_MASK 0x10000
#define ATC_L1RD_DEBUG2_TLB__INJECT_SOFT_PARITY_ERROR__SHIFT 0x10
#define ATC_L1RD_DEBUG2_TLB__INJECT_HARD_PARITY_ERROR_MASK 0x20000
#define ATC_L1RD_DEBUG2_TLB__INJECT_HARD_PARITY_ERROR__SHIFT 0x11
#define ATC_L1RD_DEBUG2_TLB__CLEAR_CAM_PARITY_ERROR_MASK 0x40000
#define ATC_L1RD_DEBUG2_TLB__CLEAR_CAM_PARITY_ERROR__SHIFT 0x12
#define ATC_L1RD_DEBUG2_TLB__CAM_INDEX_MASK 0xf80000
#define ATC_L1RD_DEBUG2_TLB__CAM_INDEX__SHIFT 0x13
#define ATC_L1WR_DEBUG2_TLB__XNACK_RETRY_PERIOD_MASK 0xfff
#define ATC_L1WR_DEBUG2_TLB__XNACK_RETRY_PERIOD__SHIFT 0x0
#define ATC_L1WR_DEBUG2_TLB__XNACK_RETRY_MODE_MASK 0xc000
#define ATC_L1WR_DEBUG2_TLB__XNACK_RETRY_MODE__SHIFT 0xe
#define ATC_L1WR_DEBUG2_TLB__INJECT_SOFT_PARITY_ERROR_MASK 0x10000
#define ATC_L1WR_DEBUG2_TLB__INJECT_SOFT_PARITY_ERROR__SHIFT 0x10
#define ATC_L1WR_DEBUG2_TLB__INJECT_HARD_PARITY_ERROR_MASK 0x20000
#define ATC_L1WR_DEBUG2_TLB__INJECT_HARD_PARITY_ERROR__SHIFT 0x11
#define ATC_L1WR_DEBUG2_TLB__CLEAR_CAM_PARITY_ERROR_MASK 0x40000
#define ATC_L1WR_DEBUG2_TLB__CLEAR_CAM_PARITY_ERROR__SHIFT 0x12
#define ATC_L1WR_DEBUG2_TLB__CAM_INDEX_MASK 0xf80000
#define ATC_L1WR_DEBUG2_TLB__CAM_INDEX__SHIFT 0x13
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID0_REMAPPING_FINISHED_MASK 0x1
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID0_REMAPPING_FINISHED__SHIFT 0x0
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID1_REMAPPING_FINISHED_MASK 0x2
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID1_REMAPPING_FINISHED__SHIFT 0x1
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID2_REMAPPING_FINISHED_MASK 0x4
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID2_REMAPPING_FINISHED__SHIFT 0x2
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID3_REMAPPING_FINISHED_MASK 0x8
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID3_REMAPPING_FINISHED__SHIFT 0x3
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID4_REMAPPING_FINISHED_MASK 0x10
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID4_REMAPPING_FINISHED__SHIFT 0x4
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID5_REMAPPING_FINISHED_MASK 0x20
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID5_REMAPPING_FINISHED__SHIFT 0x5
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID6_REMAPPING_FINISHED_MASK 0x40
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID6_REMAPPING_FINISHED__SHIFT 0x6
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID7_REMAPPING_FINISHED_MASK 0x80
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID7_REMAPPING_FINISHED__SHIFT 0x7
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID8_REMAPPING_FINISHED_MASK 0x100
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID8_REMAPPING_FINISHED__SHIFT 0x8
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID9_REMAPPING_FINISHED_MASK 0x200
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID9_REMAPPING_FINISHED__SHIFT 0x9
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID10_REMAPPING_FINISHED_MASK 0x400
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID10_REMAPPING_FINISHED__SHIFT 0xa
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID11_REMAPPING_FINISHED_MASK 0x800
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID11_REMAPPING_FINISHED__SHIFT 0xb
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID12_REMAPPING_FINISHED_MASK 0x1000
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID12_REMAPPING_FINISHED__SHIFT 0xc
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID13_REMAPPING_FINISHED_MASK 0x2000
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID13_REMAPPING_FINISHED__SHIFT 0xd
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID14_REMAPPING_FINISHED_MASK 0x4000
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID14_REMAPPING_FINISHED__SHIFT 0xe
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID15_REMAPPING_FINISHED_MASK 0x8000
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID15_REMAPPING_FINISHED__SHIFT 0xf
#define ATC_VMID0_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID0_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID0_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID0_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID0_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID0_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID1_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID1_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID1_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID1_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID1_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID1_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID2_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID2_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID2_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID2_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID2_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID2_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID3_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID3_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID3_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID3_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID3_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID3_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID4_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID4_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID4_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID4_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID4_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID4_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID5_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID5_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID5_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID5_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID5_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID5_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID6_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID6_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID6_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID6_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID6_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID6_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID7_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID7_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID7_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID7_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID7_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID7_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID8_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID8_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID8_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID8_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID8_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID8_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID9_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID9_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID9_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID9_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID9_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID9_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID10_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID10_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID10_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID10_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID10_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID10_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID11_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID11_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID11_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID11_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID11_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID11_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID12_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID12_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID12_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID12_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID12_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID12_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID13_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID13_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID13_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID13_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID13_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID13_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID14_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID14_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID14_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID14_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID14_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID14_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID15_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID15_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID15_PASID_MAPPING__NO_INVALIDATION_MASK 0x40000000
#define ATC_VMID15_PASID_MAPPING__NO_INVALIDATION__SHIFT 0x1e
#define ATC_VMID15_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID15_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_ATS_VMID_STATUS__VMID0_OUTSTANDING_MASK 0x1
#define ATC_ATS_VMID_STATUS__VMID0_OUTSTANDING__SHIFT 0x0
#define ATC_ATS_VMID_STATUS__VMID1_OUTSTANDING_MASK 0x2
#define ATC_ATS_VMID_STATUS__VMID1_OUTSTANDING__SHIFT 0x1
#define ATC_ATS_VMID_STATUS__VMID2_OUTSTANDING_MASK 0x4
#define ATC_ATS_VMID_STATUS__VMID2_OUTSTANDING__SHIFT 0x2
#define ATC_ATS_VMID_STATUS__VMID3_OUTSTANDING_MASK 0x8
#define ATC_ATS_VMID_STATUS__VMID3_OUTSTANDING__SHIFT 0x3
#define ATC_ATS_VMID_STATUS__VMID4_OUTSTANDING_MASK 0x10
#define ATC_ATS_VMID_STATUS__VMID4_OUTSTANDING__SHIFT 0x4
#define ATC_ATS_VMID_STATUS__VMID5_OUTSTANDING_MASK 0x20
#define ATC_ATS_VMID_STATUS__VMID5_OUTSTANDING__SHIFT 0x5
#define ATC_ATS_VMID_STATUS__VMID6_OUTSTANDING_MASK 0x40
#define ATC_ATS_VMID_STATUS__VMID6_OUTSTANDING__SHIFT 0x6
#define ATC_ATS_VMID_STATUS__VMID7_OUTSTANDING_MASK 0x80
#define ATC_ATS_VMID_STATUS__VMID7_OUTSTANDING__SHIFT 0x7
#define ATC_ATS_VMID_STATUS__VMID8_OUTSTANDING_MASK 0x100
#define ATC_ATS_VMID_STATUS__VMID8_OUTSTANDING__SHIFT 0x8
#define ATC_ATS_VMID_STATUS__VMID9_OUTSTANDING_MASK 0x200
#define ATC_ATS_VMID_STATUS__VMID9_OUTSTANDING__SHIFT 0x9
#define ATC_ATS_VMID_STATUS__VMID10_OUTSTANDING_MASK 0x400
#define ATC_ATS_VMID_STATUS__VMID10_OUTSTANDING__SHIFT 0xa
#define ATC_ATS_VMID_STATUS__VMID11_OUTSTANDING_MASK 0x800
#define ATC_ATS_VMID_STATUS__VMID11_OUTSTANDING__SHIFT 0xb
#define ATC_ATS_VMID_STATUS__VMID12_OUTSTANDING_MASK 0x1000
#define ATC_ATS_VMID_STATUS__VMID12_OUTSTANDING__SHIFT 0xc
#define ATC_ATS_VMID_STATUS__VMID13_OUTSTANDING_MASK 0x2000
#define ATC_ATS_VMID_STATUS__VMID13_OUTSTANDING__SHIFT 0xd
#define ATC_ATS_VMID_STATUS__VMID14_OUTSTANDING_MASK 0x4000
#define ATC_ATS_VMID_STATUS__VMID14_OUTSTANDING__SHIFT 0xe
#define ATC_ATS_VMID_STATUS__VMID15_OUTSTANDING_MASK 0x8000
#define ATC_ATS_VMID_STATUS__VMID15_OUTSTANDING__SHIFT 0xf
#define ATC_ATS_SMU_STATUS__VDDGFX_POWERED_DOWN_MASK 0x1
#define ATC_ATS_SMU_STATUS__VDDGFX_POWERED_DOWN__SHIFT 0x0
#define ATC_L2_CNTL3__ENABLE_HW_L2_CACHE_ADDRESS_MODES_SWITCHING_MASK 0x7f
#define ATC_L2_CNTL3__ENABLE_HW_L2_CACHE_ADDRESS_MODES_SWITCHING__SHIFT 0x0
#define ATC_L2_CNTL3__ENABLE_FREE_COUNTER_MASK 0x80
#define ATC_L2_CNTL3__ENABLE_FREE_COUNTER__SHIFT 0x7
#define ATC_L2_CNTL3__L2_CACHE_EVICTION_THRESHOLD_MASK 0x1f00
#define ATC_L2_CNTL3__L2_CACHE_EVICTION_THRESHOLD__SHIFT 0x8
#define ATC_L2_CNTL3__DISABLE_CLEAR_CACHE_EVICTION_COUNTER_ON_INVALIDATION_MASK 0x2000
#define ATC_L2_CNTL3__DISABLE_CLEAR_CACHE_EVICTION_COUNTER_ON_INVALIDATION__SHIFT 0xd
#define ATC_L2_CNTL3__L2_DELAY_SEND_INVALIDATION_REQUEST_MASK 0x1c000
#define ATC_L2_CNTL3__L2_DELAY_SEND_INVALIDATION_REQUEST__SHIFT 0xe
#define ATC_L2_STATUS__BUSY_MASK 0x1
#define ATC_L2_STATUS__BUSY__SHIFT 0x0
#define ATC_L2_STATUS__PARITY_ERROR_INFO_MASK 0x3ffffffe
#define ATC_L2_STATUS__PARITY_ERROR_INFO__SHIFT 0x1
#define ATC_L2_STATUS2__CACHE_ADDRESS_MODE_MASK 0x7
#define ATC_L2_STATUS2__CACHE_ADDRESS_MODE__SHIFT 0x0
#define ATC_L2_STATUS2__PARITY_ERROR_INFO_MASK 0x7f8
#define ATC_L2_STATUS2__PARITY_ERROR_INFO__SHIFT 0x3
#define GMCON_RENG_RAM_INDEX__RENG_RAM_INDEX_MASK 0x3ff
#define GMCON_RENG_RAM_INDEX__RENG_RAM_INDEX__SHIFT 0x0
#define GMCON_RENG_RAM_DATA__RENG_RAM_DATA_MASK 0xffffffff
#define GMCON_RENG_RAM_DATA__RENG_RAM_DATA__SHIFT 0x0
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_ON_PWR_UP_MASK 0x1
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_ON_PWR_UP__SHIFT 0x0
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_NOW_MASK 0x2
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_NOW__SHIFT 0x1
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_NOW_START_PTR_MASK 0xffc
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_NOW_START_PTR__SHIFT 0x2
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_DSP_END_PTR_MASK 0x3ff000
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_DSP_END_PTR__SHIFT 0xc
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_END_PTR_MASK 0xffc00000
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_END_PTR__SHIFT 0x16
#define GMCON_MISC__RENG_EXECUTE_NOW_MODE_MASK 0x400
#define GMCON_MISC__RENG_EXECUTE_NOW_MODE__SHIFT 0xa
#define GMCON_MISC__RENG_EXECUTE_ON_REG_UPDATE_MASK 0x800
#define GMCON_MISC__RENG_EXECUTE_ON_REG_UPDATE__SHIFT 0xb
#define GMCON_MISC__RENG_SRBM_CREDITS_MCD_MASK 0xf000
#define GMCON_MISC__RENG_SRBM_CREDITS_MCD__SHIFT 0xc
#define GMCON_MISC__STCTRL_STUTTER_EN_MASK 0x10000
#define GMCON_MISC__STCTRL_STUTTER_EN__SHIFT 0x10
#define GMCON_MISC__STCTRL_GMC_IDLE_THRESHOLD_MASK 0x60000
#define GMCON_MISC__STCTRL_GMC_IDLE_THRESHOLD__SHIFT 0x11
#define GMCON_MISC__STCTRL_SRBM_IDLE_THRESHOLD_MASK 0x180000
#define GMCON_MISC__STCTRL_SRBM_IDLE_THRESHOLD__SHIFT 0x13
#define GMCON_MISC__STCTRL_IGNORE_PRE_SR_MASK 0x200000
#define GMCON_MISC__STCTRL_IGNORE_PRE_SR__SHIFT 0x15
#define GMCON_MISC__STCTRL_IGNORE_ALLOW_STOP_MASK 0x400000
#define GMCON_MISC__STCTRL_IGNORE_ALLOW_STOP__SHIFT 0x16
#define GMCON_MISC__STCTRL_IGNORE_SR_COMMIT_MASK 0x800000
#define GMCON_MISC__STCTRL_IGNORE_SR_COMMIT__SHIFT 0x17
#define GMCON_MISC__STCTRL_IGNORE_PROTECTION_FAULT_MASK 0x1000000
#define GMCON_MISC__STCTRL_IGNORE_PROTECTION_FAULT__SHIFT 0x18
#define GMCON_MISC__STCTRL_DISABLE_ALLOW_SR_MASK 0x2000000
#define GMCON_MISC__STCTRL_DISABLE_ALLOW_SR__SHIFT 0x19
#define GMCON_MISC__STCTRL_DISABLE_GMC_OFFLINE_MASK 0x4000000
#define GMCON_MISC__STCTRL_DISABLE_GMC_OFFLINE__SHIFT 0x1a
#define GMCON_MISC__CRITICAL_REGS_LOCK_MASK 0x8000000
#define GMCON_MISC__CRITICAL_REGS_LOCK__SHIFT 0x1b
#define GMCON_MISC__ALLOW_DEEP_SLEEP_MODE_MASK 0x70000000
#define GMCON_MISC__ALLOW_DEEP_SLEEP_MODE__SHIFT 0x1c
#define GMCON_MISC__STCTRL_FORCE_ALLOW_SR_MASK 0x80000000
#define GMCON_MISC__STCTRL_FORCE_ALLOW_SR__SHIFT 0x1f
#define GMCON_MISC2__GMCON_MISC2_RESERVED0_MASK 0x3f
#define GMCON_MISC2__GMCON_MISC2_RESERVED0__SHIFT 0x0
#define GMCON_MISC2__STCTRL_NONDISP_IDLE_THRESHOLD_MASK 0x7c0
#define GMCON_MISC2__STCTRL_NONDISP_IDLE_THRESHOLD__SHIFT 0x6
#define GMCON_MISC2__RENG_SR_HOLD_THRESHOLD_MASK 0x1f800
#define GMCON_MISC2__RENG_SR_HOLD_THRESHOLD__SHIFT 0xb
#define GMCON_MISC2__GMCON_MISC2_RESERVED1_MASK 0x1ffe0000
#define GMCON_MISC2__GMCON_MISC2_RESERVED1__SHIFT 0x11
#define GMCON_MISC2__STCTRL_IGNORE_ARB_BUSY_MASK 0x20000000
#define GMCON_MISC2__STCTRL_IGNORE_ARB_BUSY__SHIFT 0x1d
#define GMCON_MISC2__STCTRL_EXTEND_GMC_OFFLINE_MASK 0x40000000
#define GMCON_MISC2__STCTRL_EXTEND_GMC_OFFLINE__SHIFT 0x1e
#define GMCON_MISC2__STCTRL_TIMER_PULSE_OVERRIDE_MASK 0x80000000
#define GMCON_MISC2__STCTRL_TIMER_PULSE_OVERRIDE__SHIFT 0x1f
#define GMCON_STCTRL_REGISTER_SAVE_RANGE0__STCTRL_REGISTER_SAVE_BASE0_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_RANGE0__STCTRL_REGISTER_SAVE_BASE0__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_RANGE0__STCTRL_REGISTER_SAVE_LIMIT0_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_RANGE0__STCTRL_REGISTER_SAVE_LIMIT0__SHIFT 0x10
#define GMCON_STCTRL_REGISTER_SAVE_RANGE1__STCTRL_REGISTER_SAVE_BASE1_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_RANGE1__STCTRL_REGISTER_SAVE_BASE1__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_RANGE1__STCTRL_REGISTER_SAVE_LIMIT1_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_RANGE1__STCTRL_REGISTER_SAVE_LIMIT1__SHIFT 0x10
#define GMCON_STCTRL_REGISTER_SAVE_RANGE2__STCTRL_REGISTER_SAVE_BASE2_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_RANGE2__STCTRL_REGISTER_SAVE_BASE2__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_RANGE2__STCTRL_REGISTER_SAVE_LIMIT2_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_RANGE2__STCTRL_REGISTER_SAVE_LIMIT2__SHIFT 0x10
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__STCTRL_REGISTER_SAVE_EXCL0_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__STCTRL_REGISTER_SAVE_EXCL0__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__STCTRL_REGISTER_SAVE_EXCL1_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__STCTRL_REGISTER_SAVE_EXCL1__SHIFT 0x10
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__STCTRL_REGISTER_SAVE_EXCL2_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__STCTRL_REGISTER_SAVE_EXCL2__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__STCTRL_REGISTER_SAVE_EXCL3_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__STCTRL_REGISTER_SAVE_EXCL3__SHIFT 0x10
#define GMCON_PERF_MON_CNTL0__START_THRESH_MASK 0xfff
#define GMCON_PERF_MON_CNTL0__START_THRESH__SHIFT 0x0
#define GMCON_PERF_MON_CNTL0__STOP_THRESH_MASK 0xfff000
#define GMCON_PERF_MON_CNTL0__STOP_THRESH__SHIFT 0xc
#define GMCON_PERF_MON_CNTL0__START_MODE_MASK 0x3000000
#define GMCON_PERF_MON_CNTL0__START_MODE__SHIFT 0x18
#define GMCON_PERF_MON_CNTL0__STOP_MODE_MASK 0xc000000
#define GMCON_PERF_MON_CNTL0__STOP_MODE__SHIFT 0x1a
#define GMCON_PERF_MON_CNTL0__ALLOW_WRAP_MASK 0x10000000
#define GMCON_PERF_MON_CNTL0__ALLOW_WRAP__SHIFT 0x1c
#define GMCON_PERF_MON_CNTL0__THRESH_CNTR_ID_EXT_MASK 0x20000000
#define GMCON_PERF_MON_CNTL0__THRESH_CNTR_ID_EXT__SHIFT 0x1d
#define GMCON_PERF_MON_CNTL0__START_TRIG_ID_EXT_MASK 0x40000000
#define GMCON_PERF_MON_CNTL0__START_TRIG_ID_EXT__SHIFT 0x1e
#define GMCON_PERF_MON_CNTL0__STOP_TRIG_ID_EXT_MASK 0x80000000
#define GMCON_PERF_MON_CNTL0__STOP_TRIG_ID_EXT__SHIFT 0x1f
#define GMCON_PERF_MON_CNTL1__THRESH_CNTR_ID_MASK 0x3f
#define GMCON_PERF_MON_CNTL1__THRESH_CNTR_ID__SHIFT 0x0
#define GMCON_PERF_MON_CNTL1__START_TRIG_ID_MASK 0xfc0
#define GMCON_PERF_MON_CNTL1__START_TRIG_ID__SHIFT 0x6
#define GMCON_PERF_MON_CNTL1__STOP_TRIG_ID_MASK 0x3f000
#define GMCON_PERF_MON_CNTL1__STOP_TRIG_ID__SHIFT 0xc
#define GMCON_PERF_MON_CNTL1__MON0_ID_MASK 0x1fc0000
#define GMCON_PERF_MON_CNTL1__MON0_ID__SHIFT 0x12
#define GMCON_PERF_MON_CNTL1__MON1_ID_MASK 0xfe000000
#define GMCON_PERF_MON_CNTL1__MON1_ID__SHIFT 0x19
#define GMCON_PERF_MON_RSLT0__COUNT_MASK 0xffffffff
#define GMCON_PERF_MON_RSLT0__COUNT__SHIFT 0x0
#define GMCON_PERF_MON_RSLT1__COUNT_MASK 0xffffffff
#define GMCON_PERF_MON_RSLT1__COUNT__SHIFT 0x0
#define GMCON_PGFSM_CONFIG__FSM_ADDR_MASK 0xff
#define GMCON_PGFSM_CONFIG__FSM_ADDR__SHIFT 0x0
#define GMCON_PGFSM_CONFIG__POWER_DOWN_MASK 0x100
#define GMCON_PGFSM_CONFIG__POWER_DOWN__SHIFT 0x8
#define GMCON_PGFSM_CONFIG__POWER_UP_MASK 0x200
#define GMCON_PGFSM_CONFIG__POWER_UP__SHIFT 0x9
#define GMCON_PGFSM_CONFIG__P1_SELECT_MASK 0x400
#define GMCON_PGFSM_CONFIG__P1_SELECT__SHIFT 0xa
#define GMCON_PGFSM_CONFIG__P2_SELECT_MASK 0x800
#define GMCON_PGFSM_CONFIG__P2_SELECT__SHIFT 0xb
#define GMCON_PGFSM_CONFIG__WRITE_MASK 0x1000
#define GMCON_PGFSM_CONFIG__WRITE__SHIFT 0xc
#define GMCON_PGFSM_CONFIG__READ_MASK 0x2000
#define GMCON_PGFSM_CONFIG__READ__SHIFT 0xd
#define GMCON_PGFSM_CONFIG__RSRVD_MASK 0x7ffc000
#define GMCON_PGFSM_CONFIG__RSRVD__SHIFT 0xe
#define GMCON_PGFSM_CONFIG__SRBM_OVERRIDE_MASK 0x8000000
#define GMCON_PGFSM_CONFIG__SRBM_OVERRIDE__SHIFT 0x1b
#define GMCON_PGFSM_CONFIG__REG_ADDR_MASK 0xf0000000
#define GMCON_PGFSM_CONFIG__REG_ADDR__SHIFT 0x1c
#define GMCON_PGFSM_WRITE__WRITE_VALUE_MASK 0xffffffff
#define GMCON_PGFSM_WRITE__WRITE_VALUE__SHIFT 0x0
#define GMCON_PGFSM_READ__READ_VALUE_MASK 0xffffff
#define GMCON_PGFSM_READ__READ_VALUE__SHIFT 0x0
#define GMCON_PGFSM_READ__PGFSM_SELECT_MASK 0xf000000
#define GMCON_PGFSM_READ__PGFSM_SELECT__SHIFT 0x18
#define GMCON_PGFSM_READ__SERDES_MASTER_BUSY_MASK 0x10000000
#define GMCON_PGFSM_READ__SERDES_MASTER_BUSY__SHIFT 0x1c
#define GMCON_MISC3__RENG_DISABLE_MCC_MASK 0xff
#define GMCON_MISC3__RENG_DISABLE_MCC__SHIFT 0x0
#define GMCON_MISC3__RENG_DISABLE_MCD_MASK 0xff00
#define GMCON_MISC3__RENG_DISABLE_MCD__SHIFT 0x8
#define GMCON_MISC3__STCTRL_FORCE_PGFSM_CMD_DONE_MASK 0xfff0000
#define GMCON_MISC3__STCTRL_FORCE_PGFSM_CMD_DONE__SHIFT 0x10
#define GMCON_MISC3__STCTRL_IGNORE_ALLOW_STUTTER_MASK 0x10000000
#define GMCON_MISC3__STCTRL_IGNORE_ALLOW_STUTTER__SHIFT 0x1c
#define GMCON_MISC3__RENG_MEM_LS_ENABLE_MASK 0x20000000
#define GMCON_MISC3__RENG_MEM_LS_ENABLE__SHIFT 0x1d
#define GMCON_MISC3__STCTRL_EXCLUDE_NONMEM_CLIENTS_MASK 0x40000000
#define GMCON_MISC3__STCTRL_EXCLUDE_NONMEM_CLIENTS__SHIFT 0x1e
#define GMCON_MASK__STCTRL_BUSY_MASK_ACP_RD_MASK 0x1
#define GMCON_MASK__STCTRL_BUSY_MASK_ACP_RD__SHIFT 0x0
#define GMCON_MASK__STCTRL_BUSY_MASK_ACP_WR_MASK 0x2
#define GMCON_MASK__STCTRL_BUSY_MASK_ACP_WR__SHIFT 0x1
#define GMCON_MASK__STCTRL_BUSY_MASK_VCE_RD_MASK 0x4
#define GMCON_MASK__STCTRL_BUSY_MASK_VCE_RD__SHIFT 0x2
#define GMCON_MASK__STCTRL_BUSY_MASK_VCE_WR_MASK 0x8
#define GMCON_MASK__STCTRL_BUSY_MASK_VCE_WR__SHIFT 0x3
#define GMCON_MASK__STCTRL_SR_HANDSHAKE_MASK_MASK 0xff0
#define GMCON_MASK__STCTRL_SR_HANDSHAKE_MASK__SHIFT 0x4
#define GMCON_LPT_TARGET__STCTRL_LPT_TARGET_MASK 0xffffffff
#define GMCON_LPT_TARGET__STCTRL_LPT_TARGET__SHIFT 0x0
#define GMCON_DEBUG__GFX_STALL_MASK 0x1
#define GMCON_DEBUG__GFX_STALL__SHIFT 0x0
#define GMCON_DEBUG__GFX_CLEAR_MASK 0x2
#define GMCON_DEBUG__GFX_CLEAR__SHIFT 0x1
#define GMCON_DEBUG__GMCON_DEBUG_RESERVED0_MASK 0x4
#define GMCON_DEBUG__GMCON_DEBUG_RESERVED0__SHIFT 0x2
#define GMCON_DEBUG__SR_COMMIT_STATE_MASK 0x8
#define GMCON_DEBUG__SR_COMMIT_STATE__SHIFT 0x3
#define GMCON_DEBUG__STCTRL_ST_MASK 0xf0
#define GMCON_DEBUG__STCTRL_ST__SHIFT 0x4
#define GMCON_DEBUG__MISC_FLAGS_MASK 0xffffff00
#define GMCON_DEBUG__MISC_FLAGS__SHIFT 0x8
#define VM_L2_CNTL__ENABLE_L2_CACHE_MASK 0x1
#define VM_L2_CNTL__ENABLE_L2_CACHE__SHIFT 0x0
#define VM_L2_CNTL__ENABLE_L2_FRAGMENT_PROCESSING_MASK 0x2
#define VM_L2_CNTL__ENABLE_L2_FRAGMENT_PROCESSING__SHIFT 0x1
#define VM_L2_CNTL__L2_CACHE_PTE_ENDIAN_SWAP_MODE_MASK 0xc
#define VM_L2_CNTL__L2_CACHE_PTE_ENDIAN_SWAP_MODE__SHIFT 0x2
#define VM_L2_CNTL__L2_CACHE_PDE_ENDIAN_SWAP_MODE_MASK 0x30
#define VM_L2_CNTL__L2_CACHE_PDE_ENDIAN_SWAP_MODE__SHIFT 0x4
#define VM_L2_CNTL__L2_PDE0_CACHE_TAG_GENERATION_MODE_MASK 0x100
#define VM_L2_CNTL__L2_PDE0_CACHE_TAG_GENERATION_MODE__SHIFT 0x8
#define VM_L2_CNTL__ENABLE_L2_PTE_CACHE_LRU_UPDATE_BY_WRITE_MASK 0x200
#define VM_L2_CNTL__ENABLE_L2_PTE_CACHE_LRU_UPDATE_BY_WRITE__SHIFT 0x9
#define VM_L2_CNTL__ENABLE_L2_PDE0_CACHE_LRU_UPDATE_BY_WRITE_MASK 0x400
#define VM_L2_CNTL__ENABLE_L2_PDE0_CACHE_LRU_UPDATE_BY_WRITE__SHIFT 0xa
#define VM_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY_MASK 0x800
#define VM_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY__SHIFT 0xb
#define VM_L2_CNTL__L2_PDE0_CACHE_SPLIT_MODE_MASK 0x7000
#define VM_L2_CNTL__L2_PDE0_CACHE_SPLIT_MODE__SHIFT 0xc
#define VM_L2_CNTL__EFFECTIVE_L2_QUEUE_SIZE_MASK 0x38000
#define VM_L2_CNTL__EFFECTIVE_L2_QUEUE_SIZE__SHIFT 0xf
#define VM_L2_CNTL__PDE_FAULT_CLASSIFICATION_MASK 0x40000
#define VM_L2_CNTL__PDE_FAULT_CLASSIFICATION__SHIFT 0x12
#define VM_L2_CNTL__CONTEXT1_IDENTITY_ACCESS_MODE_MASK 0x180000
#define VM_L2_CNTL__CONTEXT1_IDENTITY_ACCESS_MODE__SHIFT 0x13
#define VM_L2_CNTL__IDENTITY_MODE_FRAGMENT_SIZE_MASK 0x3e00000
#define VM_L2_CNTL__IDENTITY_MODE_FRAGMENT_SIZE__SHIFT 0x15
#define VM_L2_CNTL__L2_CACHE_4K_SWAP_TAG_INDEX_LSBS_MASK 0xc000000
#define VM_L2_CNTL__L2_CACHE_4K_SWAP_TAG_INDEX_LSBS__SHIFT 0x1a
#define VM_L2_CNTL__L2_CACHE_BIGK_SWAP_TAG_INDEX_LSBS_MASK 0x70000000
#define VM_L2_CNTL__L2_CACHE_BIGK_SWAP_TAG_INDEX_LSBS__SHIFT 0x1c
#define VM_L2_CNTL2__INVALIDATE_ALL_L1_TLBS_MASK 0x1
#define VM_L2_CNTL2__INVALIDATE_ALL_L1_TLBS__SHIFT 0x0
#define VM_L2_CNTL2__INVALIDATE_L2_CACHE_MASK 0x2
#define VM_L2_CNTL2__INVALIDATE_L2_CACHE__SHIFT 0x1
#define VM_L2_CNTL2__DISABLE_INVALIDATE_PER_DOMAIN_MASK 0x200000
#define VM_L2_CNTL2__DISABLE_INVALIDATE_PER_DOMAIN__SHIFT 0x15
#define VM_L2_CNTL2__DISABLE_BIGK_CACHE_OPTIMIZATION_MASK 0x400000
#define VM_L2_CNTL2__DISABLE_BIGK_CACHE_OPTIMIZATION__SHIFT 0x16
#define VM_L2_CNTL2__L2_CACHE_BIGK_VMID_MODE_MASK 0x3800000
#define VM_L2_CNTL2__L2_CACHE_BIGK_VMID_MODE__SHIFT 0x17
#define VM_L2_CNTL2__INVALIDATE_CACHE_MODE_MASK 0xc000000
#define VM_L2_CNTL2__INVALIDATE_CACHE_MODE__SHIFT 0x1a
#define VM_L2_CNTL2__PDE_CACHE_EFFECTIVE_SIZE_MASK 0x70000000
#define VM_L2_CNTL2__PDE_CACHE_EFFECTIVE_SIZE__SHIFT 0x1c
#define VM_L2_CNTL3__BANK_SELECT_MASK 0x3f
#define VM_L2_CNTL3__BANK_SELECT__SHIFT 0x0
#define VM_L2_CNTL3__L2_CACHE_UPDATE_MODE_MASK 0xc0
#define VM_L2_CNTL3__L2_CACHE_UPDATE_MODE__SHIFT 0x6
#define VM_L2_CNTL3__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE_MASK 0x1f00
#define VM_L2_CNTL3__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE__SHIFT 0x8
#define VM_L2_CNTL3__L2_CACHE_BIGK_FRAGMENT_SIZE_MASK 0xf8000
#define VM_L2_CNTL3__L2_CACHE_BIGK_FRAGMENT_SIZE__SHIFT 0xf
#define VM_L2_CNTL3__L2_CACHE_BIGK_ASSOCIATIVITY_MASK 0x100000
#define VM_L2_CNTL3__L2_CACHE_BIGK_ASSOCIATIVITY__SHIFT 0x14
#define VM_L2_CNTL3__L2_CACHE_4K_EFFECTIVE_SIZE_MASK 0xe00000
#define VM_L2_CNTL3__L2_CACHE_4K_EFFECTIVE_SIZE__SHIFT 0x15
#define VM_L2_CNTL3__L2_CACHE_BIGK_EFFECTIVE_SIZE_MASK 0xf000000
#define VM_L2_CNTL3__L2_CACHE_BIGK_EFFECTIVE_SIZE__SHIFT 0x18
#define VM_L2_CNTL3__L2_CACHE_4K_FORCE_MISS_MASK 0x10000000
#define VM_L2_CNTL3__L2_CACHE_4K_FORCE_MISS__SHIFT 0x1c
#define VM_L2_CNTL3__L2_CACHE_BIGK_FORCE_MISS_MASK 0x20000000
#define VM_L2_CNTL3__L2_CACHE_BIGK_FORCE_MISS__SHIFT 0x1d
#define VM_L2_CNTL3__PDE_CACHE_FORCE_MISS_MASK 0x40000000
#define VM_L2_CNTL3__PDE_CACHE_FORCE_MISS__SHIFT 0x1e
#define VM_L2_CNTL3__L2_CACHE_4K_ASSOCIATIVITY_MASK 0x80000000
#define VM_L2_CNTL3__L2_CACHE_4K_ASSOCIATIVITY__SHIFT 0x1f
#define VM_L2_STATUS__L2_BUSY_MASK 0x1
#define VM_L2_STATUS__L2_BUSY__SHIFT 0x0
#define VM_L2_STATUS__CONTEXT_DOMAIN_BUSY_MASK 0x1fffe
#define VM_L2_STATUS__CONTEXT_DOMAIN_BUSY__SHIFT 0x1
#define VM_CONTEXT0_CNTL__ENABLE_CONTEXT_MASK 0x1
#define VM_CONTEXT0_CNTL__ENABLE_CONTEXT__SHIFT 0x0
#define VM_CONTEXT0_CNTL__PAGE_TABLE_DEPTH_MASK 0x6
#define VM_CONTEXT0_CNTL__PAGE_TABLE_DEPTH__SHIFT 0x1
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x8
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x3
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x10
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x4
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x40
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x6
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x80
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x7
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x200
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x9
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x400
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0xa
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x800
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0xb
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x1000
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0xc
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x2000
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0xd
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x4000
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0xe
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x8000
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0xf
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x10000
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x10
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x20000
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x11
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x40000
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x12
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x80000
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x13
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x100000
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x14
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x200000
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x15
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x400000
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x16
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x800000
#define VM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x17
#define VM_CONTEXT0_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK 0xf000000
#define VM_CONTEXT0_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT 0x18
#define VM_CONTEXT1_CNTL__ENABLE_CONTEXT_MASK 0x1
#define VM_CONTEXT1_CNTL__ENABLE_CONTEXT__SHIFT 0x0
#define VM_CONTEXT1_CNTL__PAGE_TABLE_DEPTH_MASK 0x6
#define VM_CONTEXT1_CNTL__PAGE_TABLE_DEPTH__SHIFT 0x1
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x8
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x3
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x10
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x4
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x40
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x6
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x80
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x7
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x200
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x9
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x400
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0xa
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x800
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0xb
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x1000
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0xc
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x2000
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0xd
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x4000
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0xe
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x8000
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0xf
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x10000
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x10
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x20000
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x11
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x40000
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x12
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x80000
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x13
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x100000
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x14
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x200000
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x15
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x400000
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x16
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x800000
#define VM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x17
#define VM_CONTEXT1_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK 0xf000000
#define VM_CONTEXT1_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT 0x18
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_FAULT_ENABLE_MASK 0x1
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_FAULT_ENABLE__SHIFT 0x0
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_ADDRESS_LOGICAL_MASK 0x2
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_ADDRESS_LOGICAL__SHIFT 0x1
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_COMPARE_MASK_MASK 0xc
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_COMPARE_MASK__SHIFT 0x2
#define VM_DUMMY_PAGE_FAULT_ADDR__DUMMY_PAGE_ADDR_MASK 0xfffffff
#define VM_DUMMY_PAGE_FAULT_ADDR__DUMMY_PAGE_ADDR__SHIFT 0x0
#define VM_CONTEXT0_CNTL2__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK 0x1
#define VM_CONTEXT0_CNTL2__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT 0x0
#define VM_CONTEXT0_CNTL2__ENABLE_CLEAR_PROTECTION_FAULT_STATUS_ADDR_WHEN_INVALIDATE_CONTEXT_MASK 0x2
#define VM_CONTEXT0_CNTL2__ENABLE_CLEAR_PROTECTION_FAULT_STATUS_ADDR_WHEN_INVALIDATE_CONTEXT__SHIFT 0x1
#define VM_CONTEXT0_CNTL2__ENABLE_INTERRUPT_PROCESSING_FOR_SUBSEQUENT_FAULTS_PER_CONTEXT_MASK 0x4
#define VM_CONTEXT0_CNTL2__ENABLE_INTERRUPT_PROCESSING_FOR_SUBSEQUENT_FAULTS_PER_CONTEXT__SHIFT 0x2
#define VM_CONTEXT0_CNTL2__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES_MASK 0x8
#define VM_CONTEXT0_CNTL2__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES__SHIFT 0x3
#define VM_CONTEXT0_CNTL2__WAIT_FOR_IDLE_WHEN_INVALIDATE_MASK 0x10
#define VM_CONTEXT0_CNTL2__WAIT_FOR_IDLE_WHEN_INVALIDATE__SHIFT 0x4
#define VM_CONTEXT1_CNTL2__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK 0x1
#define VM_CONTEXT1_CNTL2__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT 0x0
#define VM_CONTEXT1_CNTL2__ENABLE_CLEAR_PROTECTION_FAULT_STATUS_ADDR_WHEN_INVALIDATE_CONTEXT_MASK 0x2
#define VM_CONTEXT1_CNTL2__ENABLE_CLEAR_PROTECTION_FAULT_STATUS_ADDR_WHEN_INVALIDATE_CONTEXT__SHIFT 0x1
#define VM_CONTEXT1_CNTL2__ENABLE_INTERRUPT_PROCESSING_FOR_SUBSEQUENT_FAULTS_PER_CONTEXT_MASK 0x4
#define VM_CONTEXT1_CNTL2__ENABLE_INTERRUPT_PROCESSING_FOR_SUBSEQUENT_FAULTS_PER_CONTEXT__SHIFT 0x2
#define VM_CONTEXT1_CNTL2__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES_MASK 0x8
#define VM_CONTEXT1_CNTL2__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES__SHIFT 0x3
#define VM_CONTEXT1_CNTL2__WAIT_FOR_IDLE_WHEN_INVALIDATE_MASK 0x10
#define VM_CONTEXT1_CNTL2__WAIT_FOR_IDLE_WHEN_INVALIDATE__SHIFT 0x4
#define VM_CONTEXT8_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT8_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT9_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT9_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT10_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT10_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT11_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT11_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT12_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT12_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT13_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT13_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT14_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT14_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT15_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT15_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_0_MASK 0x1
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_0__SHIFT 0x0
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_1_MASK 0x2
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_1__SHIFT 0x1
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_2_MASK 0x4
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_2__SHIFT 0x2
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_3_MASK 0x8
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_3__SHIFT 0x3
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_4_MASK 0x10
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_4__SHIFT 0x4
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_5_MASK 0x20
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_5__SHIFT 0x5
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_6_MASK 0x40
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_6__SHIFT 0x6
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_7_MASK 0x80
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_7__SHIFT 0x7
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_8_MASK 0x100
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_8__SHIFT 0x8
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_9_MASK 0x200
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_9__SHIFT 0x9
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_10_MASK 0x400
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_10__SHIFT 0xa
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_11_MASK 0x800
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_11__SHIFT 0xb
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_12_MASK 0x1000
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_12__SHIFT 0xc
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_13_MASK 0x2000
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_13__SHIFT 0xd
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_14_MASK 0x4000
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_14__SHIFT 0xe
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_15_MASK 0x8000
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_15__SHIFT 0xf
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_0_MASK 0x1
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_0__SHIFT 0x0
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_1_MASK 0x2
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_1__SHIFT 0x1
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_2_MASK 0x4
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_2__SHIFT 0x2
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_3_MASK 0x8
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_3__SHIFT 0x3
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_4_MASK 0x10
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_4__SHIFT 0x4
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_5_MASK 0x20
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_5__SHIFT 0x5
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_6_MASK 0x40
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_6__SHIFT 0x6
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_7_MASK 0x80
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_7__SHIFT 0x7
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_8_MASK 0x100
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_8__SHIFT 0x8
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_9_MASK 0x200
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_9__SHIFT 0x9
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_10_MASK 0x400
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_10__SHIFT 0xa
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_11_MASK 0x800
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_11__SHIFT 0xb
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_12_MASK 0x1000
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_12__SHIFT 0xc
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_13_MASK 0x2000
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_13__SHIFT 0xd
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_14_MASK 0x4000
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_14__SHIFT 0xe
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_15_MASK 0x8000
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_15__SHIFT 0xf
#define VM_PRT_APERTURE0_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE0_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE1_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE1_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE2_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE2_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE3_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE3_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE0_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE0_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE1_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE1_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE2_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE2_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE3_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE3_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_CNTL__CB_DISABLE_READ_FAULT_ON_UNMAPPED_ACCESS_MASK 0x1
#define VM_PRT_CNTL__CB_DISABLE_READ_FAULT_ON_UNMAPPED_ACCESS__SHIFT 0x0
#define VM_PRT_CNTL__TC_DISABLE_READ_FAULT_ON_UNMAPPED_ACCESS_MASK 0x2
#define VM_PRT_CNTL__TC_DISABLE_READ_FAULT_ON_UNMAPPED_ACCESS__SHIFT 0x1
#define VM_PRT_CNTL__L2_CACHE_STORE_INVALID_ENTRIES_MASK 0x4
#define VM_PRT_CNTL__L2_CACHE_STORE_INVALID_ENTRIES__SHIFT 0x2
#define VM_PRT_CNTL__L1_TLB_STORE_INVALID_ENTRIES_MASK 0x8
#define VM_PRT_CNTL__L1_TLB_STORE_INVALID_ENTRIES__SHIFT 0x3
#define VM_PRT_CNTL__CB_DISABLE_WRITE_FAULT_ON_UNMAPPED_ACCESS_MASK 0x10
#define VM_PRT_CNTL__CB_DISABLE_WRITE_FAULT_ON_UNMAPPED_ACCESS__SHIFT 0x4
#define VM_PRT_CNTL__TC_DISABLE_WRITE_FAULT_ON_UNMAPPED_ACCESS_MASK 0x20
#define VM_PRT_CNTL__TC_DISABLE_WRITE_FAULT_ON_UNMAPPED_ACCESS__SHIFT 0x5
#define VM_PRT_CNTL__MASK_PDE0_FAULT_MASK 0x40
#define VM_PRT_CNTL__MASK_PDE0_FAULT__SHIFT 0x6
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_0_MASK 0x1
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_0__SHIFT 0x0
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_1_MASK 0x2
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_1__SHIFT 0x1
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_2_MASK 0x4
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_2__SHIFT 0x2
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_3_MASK 0x8
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_3__SHIFT 0x3
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_4_MASK 0x10
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_4__SHIFT 0x4
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_5_MASK 0x20
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_5__SHIFT 0x5
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_6_MASK 0x40
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_6__SHIFT 0x6
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_7_MASK 0x80
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_7__SHIFT 0x7
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_8_MASK 0x100
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_8__SHIFT 0x8
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_9_MASK 0x200
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_9__SHIFT 0x9
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_10_MASK 0x400
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_10__SHIFT 0xa
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_11_MASK 0x800
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_11__SHIFT 0xb
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_12_MASK 0x1000
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_12__SHIFT 0xc
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_13_MASK 0x2000
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_13__SHIFT 0xd
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_14_MASK 0x4000
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_14__SHIFT 0xe
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_15_MASK 0x8000
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_15__SHIFT 0xf
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__PROTECTIONS_MASK 0xff
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__PROTECTIONS__SHIFT 0x0
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID_MASK 0x1ff000
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID__SHIFT 0xc
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW_MASK 0x1000000
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW__SHIFT 0x18
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__VMID_MASK 0x1e000000
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__VMID__SHIFT 0x19
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__ATOMIC_MASK 0x20000000
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__ATOMIC__SHIFT 0x1d
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__PROTECTIONS_MASK 0xff
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__PROTECTIONS__SHIFT 0x0
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID_MASK 0x1ff000
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID__SHIFT 0xc
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW_MASK 0x1000000
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW__SHIFT 0x18
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__VMID_MASK 0x1e000000
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__VMID__SHIFT 0x19
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__ATOMIC_MASK 0x20000000
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__ATOMIC__SHIFT 0x1d
#define VM_CONTEXT0_PROTECTION_FAULT_MCCLIENT__NAME_MASK 0xffffffff
#define VM_CONTEXT0_PROTECTION_FAULT_MCCLIENT__NAME__SHIFT 0x0
#define VM_CONTEXT1_PROTECTION_FAULT_MCCLIENT__NAME_MASK 0xffffffff
#define VM_CONTEXT1_PROTECTION_FAULT_MCCLIENT__NAME__SHIFT 0x0
#define VM_CONTEXT0_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR_MASK 0xfffffff
#define VM_CONTEXT0_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR__SHIFT 0x0
#define VM_CONTEXT1_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR_MASK 0xfffffff
#define VM_CONTEXT1_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR__SHIFT 0x0
#define VM_CONTEXT0_PROTECTION_FAULT_DEFAULT_ADDR__PHYSICAL_PAGE_ADDR_MASK 0xfffffff
#define VM_CONTEXT0_PROTECTION_FAULT_DEFAULT_ADDR__PHYSICAL_PAGE_ADDR__SHIFT 0x0
#define VM_CONTEXT1_PROTECTION_FAULT_DEFAULT_ADDR__PHYSICAL_PAGE_ADDR_MASK 0xfffffff
#define VM_CONTEXT1_PROTECTION_FAULT_DEFAULT_ADDR__PHYSICAL_PAGE_ADDR__SHIFT 0x0
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_MASK 0x1ff
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT__SHIFT 0x0
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_MASK_MASK 0x3fe00
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_MASK__SHIFT 0x9
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_ID_MSB_MASK 0x40000
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_ID_MSB__SHIFT 0x12
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_ID_MASK_MSB_MASK 0x80000
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_ID_MASK_MSB__SHIFT 0x13
#define VM_CONTEXT0_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT0_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT1_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT1_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT2_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT2_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT3_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT3_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT4_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT4_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT5_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT5_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT6_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT6_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT7_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT7_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT0_PAGE_TABLE_START_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT0_PAGE_TABLE_START_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT1_PAGE_TABLE_START_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT1_PAGE_TABLE_START_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT0_PAGE_TABLE_END_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT0_PAGE_TABLE_END_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT1_PAGE_TABLE_END_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT1_PAGE_TABLE_END_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_DEBUG__FLAGS_MASK 0xffffffff
#define VM_DEBUG__FLAGS__SHIFT 0x0
#define VM_L2_CG__OFFDLY_MASK 0xfc0
#define VM_L2_CG__OFFDLY__SHIFT 0x6
#define VM_L2_CG__ENABLE_MASK 0x40000
#define VM_L2_CG__ENABLE__SHIFT 0x12
#define VM_L2_CG__MEM_LS_ENABLE_MASK 0x80000
#define VM_L2_CG__MEM_LS_ENABLE__SHIFT 0x13
#define VM_L2_CG__OVERRIDE_MASK 0x100000
#define VM_L2_CG__OVERRIDE__SHIFT 0x14
#define VM_L2_BANK_SELECT_MASKA__BANK_SELECT_MASK_MASK 0xfffffff
#define VM_L2_BANK_SELECT_MASKA__BANK_SELECT_MASK__SHIFT 0x0
#define VM_L2_BANK_SELECT_MASKB__BANK_SELECT_MASK_MASK 0xff
#define VM_L2_BANK_SELECT_MASKB__BANK_SELECT_MASK__SHIFT 0x0
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET__PHYSICAL_PAGE_OFFSET_MASK 0xfffffff
#define VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET__PHYSICAL_PAGE_OFFSET__SHIFT 0x0
#define VM_L2_CNTL4__L2_CACHE_4K_PARTITION_COUNT_MASK 0x3f
#define VM_L2_CNTL4__L2_CACHE_4K_PARTITION_COUNT__SHIFT 0x0
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PDE_REQUEST_PHYSICAL_MASK 0x40
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PDE_REQUEST_PHYSICAL__SHIFT 0x6
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PDE_REQUEST_SHARED_MASK 0x80
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PDE_REQUEST_SHARED__SHIFT 0x7
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PDE_REQUEST_SNOOP_MASK 0x100
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PDE_REQUEST_SNOOP__SHIFT 0x8
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PTE_REQUEST_PHYSICAL_MASK 0x200
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PTE_REQUEST_PHYSICAL__SHIFT 0x9
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PTE_REQUEST_SHARED_MASK 0x400
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PTE_REQUEST_SHARED__SHIFT 0xa
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PTE_REQUEST_SNOOP_MASK 0x800
#define VM_L2_CNTL4__VMC_TAP_CONTEXT0_PTE_REQUEST_SNOOP__SHIFT 0xb
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PDE_REQUEST_PHYSICAL_MASK 0x1000
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PDE_REQUEST_PHYSICAL__SHIFT 0xc
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PDE_REQUEST_SHARED_MASK 0x2000
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PDE_REQUEST_SHARED__SHIFT 0xd
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PDE_REQUEST_SNOOP_MASK 0x4000
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PDE_REQUEST_SNOOP__SHIFT 0xe
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PTE_REQUEST_PHYSICAL_MASK 0x8000
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PTE_REQUEST_PHYSICAL__SHIFT 0xf
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PTE_REQUEST_SHARED_MASK 0x10000
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PTE_REQUEST_SHARED__SHIFT 0x10
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PTE_REQUEST_SNOOP_MASK 0x20000
#define VM_L2_CNTL4__VMC_TAP_CONTEXT1_PTE_REQUEST_SNOOP__SHIFT 0x11
#define VM_L2_CNTL4__L2_CACHE_4K_LRU_ADDR_MATCHING_MASK 0x40000
#define VM_L2_CNTL4__L2_CACHE_4K_LRU_ADDR_MATCHING__SHIFT 0x12
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_READ_CLIENT_ID_MASK 0x1ff
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_READ_CLIENT_ID__SHIFT 0x0
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_WRITE_CLIENT_ID_MASK 0x7fc00
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_WRITE_CLIENT_ID__SHIFT 0xa
#define VM_L2_BANK_SELECT_RESERVED_CID__ENABLE_MASK 0x100000
#define VM_L2_BANK_SELECT_RESERVED_CID__ENABLE__SHIFT 0x14
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_INVALIDATION_MODE_MASK 0x1000000
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_INVALIDATION_MODE__SHIFT 0x18
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_PRIVATE_INVALIDATION_MASK 0x2000000
#define VM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_PRIVATE_INVALIDATION__SHIFT 0x19
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_READ_CLIENT_ID_MASK 0x1ff
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_READ_CLIENT_ID__SHIFT 0x0
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_WRITE_CLIENT_ID_MASK 0x7fc00
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_WRITE_CLIENT_ID__SHIFT 0xa
#define VM_L2_BANK_SELECT_RESERVED_CID2__ENABLE_MASK 0x100000
#define VM_L2_BANK_SELECT_RESERVED_CID2__ENABLE__SHIFT 0x14
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_INVALIDATION_MODE_MASK 0x1000000
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_INVALIDATION_MODE__SHIFT 0x18
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_PRIVATE_INVALIDATION_MASK 0x2000000
#define VM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_PRIVATE_INVALIDATION__SHIFT 0x19
#define MC_VM_FB_SIZE_OFFSET_VF0__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF0__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF0__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF0__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF1__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF1__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF1__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF1__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF2__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF2__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF2__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF2__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF3__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF3__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF3__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF3__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF4__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF4__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF4__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF4__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF5__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF5__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF5__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF5__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF6__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF6__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF6__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF6__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF7__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF7__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF7__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF7__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF8__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF8__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF8__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF8__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF9__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF9__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF9__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF9__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF10__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF10__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF10__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF10__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF11__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF11__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF11__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF11__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF12__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF12__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF12__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF12__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF13__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF13__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF13__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF13__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF14__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF14__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF14__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF14__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_FB_SIZE_OFFSET_VF15__VF_FB_SIZE_MASK 0xffff
#define MC_VM_FB_SIZE_OFFSET_VF15__VF_FB_SIZE__SHIFT 0x0
#define MC_VM_FB_SIZE_OFFSET_VF15__VF_FB_OFFSET_MASK 0xffff0000
#define MC_VM_FB_SIZE_OFFSET_VF15__VF_FB_OFFSET__SHIFT 0x10
#define MC_VM_NB_MMIOBASE__MMIOBASE_MASK 0xffffffff
#define MC_VM_NB_MMIOBASE__MMIOBASE__SHIFT 0x0
#define MC_VM_NB_MMIOLIMIT__MMIOLIMIT_MASK 0xffffffff
#define MC_VM_NB_MMIOLIMIT__MMIOLIMIT__SHIFT 0x0
#define MC_VM_NB_PCI_CTRL__MMIOENABLE_MASK 0x800000
#define MC_VM_NB_PCI_CTRL__MMIOENABLE__SHIFT 0x17
#define MC_VM_NB_PCI_ARB__VGA_HOLE_MASK 0x8
#define MC_VM_NB_PCI_ARB__VGA_HOLE__SHIFT 0x3
#define MC_VM_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM_MASK 0xff800000
#define MC_VM_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM__SHIFT 0x17
#define MC_VM_NB_LOWER_TOP_OF_DRAM2__ENABLE_MASK 0x1
#define MC_VM_NB_LOWER_TOP_OF_DRAM2__ENABLE__SHIFT 0x0
#define MC_VM_NB_LOWER_TOP_OF_DRAM2__LOWER_TOM2_MASK 0xff800000
#define MC_VM_NB_LOWER_TOP_OF_DRAM2__LOWER_TOM2__SHIFT 0x17
#define MC_VM_NB_UPPER_TOP_OF_DRAM2__UPPER_TOM2_MASK 0xff
#define MC_VM_NB_UPPER_TOP_OF_DRAM2__UPPER_TOM2__SHIFT 0x0
#define MC_VM_NB_TOP_OF_DRAM3__TOM3_LIMIT_MASK 0x3fffffff
#define MC_VM_NB_TOP_OF_DRAM3__TOM3_LIMIT__SHIFT 0x0
#define MC_VM_NB_TOP_OF_DRAM3__TOM3_ENABLE_MASK 0x80000000
#define MC_VM_NB_TOP_OF_DRAM3__TOM3_ENABLE__SHIFT 0x1f
#define MC_VM_MARC_BASE_LO_0__MARC_BASE_LO_0_MASK 0xfffff000
#define MC_VM_MARC_BASE_LO_0__MARC_BASE_LO_0__SHIFT 0xc
#define MC_VM_MARC_BASE_LO_1__MARC_BASE_LO_1_MASK 0xfffff000
#define MC_VM_MARC_BASE_LO_1__MARC_BASE_LO_1__SHIFT 0xc
#define MC_VM_MARC_BASE_LO_2__MARC_BASE_LO_2_MASK 0xfffff000
#define MC_VM_MARC_BASE_LO_2__MARC_BASE_LO_2__SHIFT 0xc
#define MC_VM_MARC_BASE_LO_3__MARC_BASE_LO_3_MASK 0xfffff000
#define MC_VM_MARC_BASE_LO_3__MARC_BASE_LO_3__SHIFT 0xc
#define MC_VM_MARC_BASE_HI_0__MARC_BASE_HI_0_MASK 0xfffff
#define MC_VM_MARC_BASE_HI_0__MARC_BASE_HI_0__SHIFT 0x0
#define MC_VM_MARC_BASE_HI_1__MARC_BASE_HI_1_MASK 0xfffff
#define MC_VM_MARC_BASE_HI_1__MARC_BASE_HI_1__SHIFT 0x0
#define MC_VM_MARC_BASE_HI_2__MARC_BASE_HI_2_MASK 0xfffff
#define MC_VM_MARC_BASE_HI_2__MARC_BASE_HI_2__SHIFT 0x0
#define MC_VM_MARC_BASE_HI_3__MARC_BASE_HI_3_MASK 0xfffff
#define MC_VM_MARC_BASE_HI_3__MARC_BASE_HI_3__SHIFT 0x0
#define MC_VM_MARC_RELOC_LO_0__MARC_ENABLE_0_MASK 0x1
#define MC_VM_MARC_RELOC_LO_0__MARC_ENABLE_0__SHIFT 0x0
#define MC_VM_MARC_RELOC_LO_0__MARC_READONLY_0_MASK 0x2
#define MC_VM_MARC_RELOC_LO_0__MARC_READONLY_0__SHIFT 0x1
#define MC_VM_MARC_RELOC_LO_0__MARC_RELOC_LO_0_MASK 0xfffff000
#define MC_VM_MARC_RELOC_LO_0__MARC_RELOC_LO_0__SHIFT 0xc
#define MC_VM_MARC_RELOC_LO_1__MARC_ENABLE_1_MASK 0x1
#define MC_VM_MARC_RELOC_LO_1__MARC_ENABLE_1__SHIFT 0x0
#define MC_VM_MARC_RELOC_LO_1__MARC_READONLY_1_MASK 0x2
#define MC_VM_MARC_RELOC_LO_1__MARC_READONLY_1__SHIFT 0x1
#define MC_VM_MARC_RELOC_LO_1__MARC_RELOC_LO_1_MASK 0xfffff000
#define MC_VM_MARC_RELOC_LO_1__MARC_RELOC_LO_1__SHIFT 0xc
#define MC_VM_MARC_RELOC_LO_2__MARC_ENABLE_2_MASK 0x1
#define MC_VM_MARC_RELOC_LO_2__MARC_ENABLE_2__SHIFT 0x0
#define MC_VM_MARC_RELOC_LO_2__MARC_READONLY_2_MASK 0x2
#define MC_VM_MARC_RELOC_LO_2__MARC_READONLY_2__SHIFT 0x1
#define MC_VM_MARC_RELOC_LO_2__MARC_RELOC_LO_2_MASK 0xfffff000
#define MC_VM_MARC_RELOC_LO_2__MARC_RELOC_LO_2__SHIFT 0xc
#define MC_VM_MARC_RELOC_LO_3__MARC_ENABLE_3_MASK 0x1
#define MC_VM_MARC_RELOC_LO_3__MARC_ENABLE_3__SHIFT 0x0
#define MC_VM_MARC_RELOC_LO_3__MARC_READONLY_3_MASK 0x2
#define MC_VM_MARC_RELOC_LO_3__MARC_READONLY_3__SHIFT 0x1
#define MC_VM_MARC_RELOC_LO_3__MARC_RELOC_LO_3_MASK 0xfffff000
#define MC_VM_MARC_RELOC_LO_3__MARC_RELOC_LO_3__SHIFT 0xc
#define MC_VM_MARC_RELOC_HI_0__MARC_RELOC_HI_0_MASK 0xfffff
#define MC_VM_MARC_RELOC_HI_0__MARC_RELOC_HI_0__SHIFT 0x0
#define MC_VM_MARC_RELOC_HI_1__MARC_RELOC_HI_1_MASK 0xfffff
#define MC_VM_MARC_RELOC_HI_1__MARC_RELOC_HI_1__SHIFT 0x0
#define MC_VM_MARC_RELOC_HI_2__MARC_RELOC_HI_2_MASK 0xfffff
#define MC_VM_MARC_RELOC_HI_2__MARC_RELOC_HI_2__SHIFT 0x0
#define MC_VM_MARC_RELOC_HI_3__MARC_RELOC_HI_3_MASK 0xfffff
#define MC_VM_MARC_RELOC_HI_3__MARC_RELOC_HI_3__SHIFT 0x0
#define MC_VM_MARC_LEN_LO_0__MARC_LEN_LO_0_MASK 0xfffff000
#define MC_VM_MARC_LEN_LO_0__MARC_LEN_LO_0__SHIFT 0xc
#define MC_VM_MARC_LEN_LO_1__MARC_LEN_LO_1_MASK 0xfffff000
#define MC_VM_MARC_LEN_LO_1__MARC_LEN_LO_1__SHIFT 0xc
#define MC_VM_MARC_LEN_LO_2__MARC_LEN_LO_2_MASK 0xfffff000
#define MC_VM_MARC_LEN_LO_2__MARC_LEN_LO_2__SHIFT 0xc
#define MC_VM_MARC_LEN_LO_3__MARC_LEN_LO_3_MASK 0xfffff000
#define MC_VM_MARC_LEN_LO_3__MARC_LEN_LO_3__SHIFT 0xc
#define MC_VM_MARC_LEN_HI_0__MARC_LEN_HI_0_MASK 0xfffff
#define MC_VM_MARC_LEN_HI_0__MARC_LEN_HI_0__SHIFT 0x0
#define MC_VM_MARC_LEN_HI_1__MARC_LEN_HI_1_MASK 0xfffff
#define MC_VM_MARC_LEN_HI_1__MARC_LEN_HI_1__SHIFT 0x0
#define MC_VM_MARC_LEN_HI_2__MARC_LEN_HI_2_MASK 0xfffff
#define MC_VM_MARC_LEN_HI_2__MARC_LEN_HI_2__SHIFT 0x0
#define MC_VM_MARC_LEN_HI_3__MARC_LEN_HI_3_MASK 0xfffff
#define MC_VM_MARC_LEN_HI_3__MARC_LEN_HI_3__SHIFT 0x0
#define MC_VM_MARC_CNTL__ENABLE_ALL_CLIENTS_MASK 0x1
#define MC_VM_MARC_CNTL__ENABLE_ALL_CLIENTS__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL0__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL0__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL0__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL0__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL0__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL0__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_CNTL1__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL1__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL1__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL1__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL1__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL1__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_CNTL2__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL2__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL2__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL2__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL2__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL2__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_CNTL3__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL3__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL3__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL3__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL3__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL3__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_CNTL4__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL4__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL4__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL4__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL4__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL4__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_CNTL5__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL5__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL5__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL5__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL5__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL5__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_CNTL6__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL6__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL6__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL6__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL6__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL6__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_CNTL7__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL7__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL7__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL7__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL7__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL7__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_CNTL8__REQ_STREAM_ID_MASK 0x1ff
#define MC_VM_MB_L1_TLS0_CNTL8__REQ_STREAM_ID__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_CNTL8__EN_MASK 0x1000
#define MC_VM_MB_L1_TLS0_CNTL8__EN__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_CNTL8__PREFETCH_DONE_MASK 0x2000
#define MC_VM_MB_L1_TLS0_CNTL8__PREFETCH_DONE__SHIFT 0xd
#define MC_VM_MB_L1_TLS0_START_ADDR0__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR0__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_START_ADDR1__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR1__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_START_ADDR2__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR2__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_START_ADDR3__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR3__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_START_ADDR4__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR4__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_START_ADDR5__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR5__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_START_ADDR6__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR6__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_START_ADDR7__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR7__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_START_ADDR8__START_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_START_ADDR8__START_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR0__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR0__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR1__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR1__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR2__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR2__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR3__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR3__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR4__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR4__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR5__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR5__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR6__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR6__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR7__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR7__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_END_ADDR8__END_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_END_ADDR8__END_ADDR__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__PROTECTIONS_MASK 0xff
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__PROTECTIONS__SHIFT 0x0
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID_MASK 0x1ff000
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID__SHIFT 0xc
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW_MASK 0x1000000
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW__SHIFT 0x18
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__VMID_MASK 0x1e000000
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__VMID__SHIFT 0x19
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__ATOMIC_MASK 0x20000000
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS__ATOMIC__SHIFT 0x1d
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR_MASK 0xfffffff
#define MC_VM_MB_L1_TLS0_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR__SHIFT 0x0
#define MC_SEQ_CNTL__MEM_ADDR_MAP_COLS_MASK 0x3
#define MC_SEQ_CNTL__MEM_ADDR_MAP_COLS__SHIFT 0x0
#define MC_SEQ_CNTL__MEM_ADDR_MAP_BANK_MASK 0xc
#define MC_SEQ_CNTL__MEM_ADDR_MAP_BANK__SHIFT 0x2
#define MC_SEQ_CNTL__SAFE_MODE_MASK 0x30
#define MC_SEQ_CNTL__SAFE_MODE__SHIFT 0x4
#define MC_SEQ_CNTL__DAT_INV_MASK 0x40
#define MC_SEQ_CNTL__DAT_INV__SHIFT 0x6
#define MC_SEQ_CNTL__MSK_DF1_MASK 0x80
#define MC_SEQ_CNTL__MSK_DF1__SHIFT 0x7
#define MC_SEQ_CNTL__CHANNEL_DISABLE_MASK 0x300
#define MC_SEQ_CNTL__CHANNEL_DISABLE__SHIFT 0x8
#define MC_SEQ_CNTL__MSKOFF_DAT_TL_MASK 0x4000
#define MC_SEQ_CNTL__MSKOFF_DAT_TL__SHIFT 0xe
#define MC_SEQ_CNTL__MSKOFF_DAT_TH_MASK 0x8000
#define MC_SEQ_CNTL__MSKOFF_DAT_TH__SHIFT 0xf
#define MC_SEQ_CNTL__RET_HOLD_EOP_MASK 0x10000
#define MC_SEQ_CNTL__RET_HOLD_EOP__SHIFT 0x10
#define MC_SEQ_CNTL__BANKGROUP_SIZE_MASK 0x20000
#define MC_SEQ_CNTL__BANKGROUP_SIZE__SHIFT 0x11
#define MC_SEQ_CNTL__BANKGROUP_ENB_MASK 0x40000
#define MC_SEQ_CNTL__BANKGROUP_ENB__SHIFT 0x12
#define MC_SEQ_CNTL__RTR_OVERRIDE_MASK 0x80000
#define MC_SEQ_CNTL__RTR_OVERRIDE__SHIFT 0x13
#define MC_SEQ_CNTL__ARB_REQCMD_WMK_MASK 0xf00000
#define MC_SEQ_CNTL__ARB_REQCMD_WMK__SHIFT 0x14
#define MC_SEQ_CNTL__ARB_REQDAT_WMK_MASK 0xf000000
#define MC_SEQ_CNTL__ARB_REQDAT_WMK__SHIFT 0x18
#define MC_SEQ_CNTL__ARB_RTDAT_WMK_MASK 0xf0000000
#define MC_SEQ_CNTL__ARB_RTDAT_WMK__SHIFT 0x1c
#define MC_SEQ_CNTL_2__DRST_PDRV_MASK 0xf
#define MC_SEQ_CNTL_2__DRST_PDRV__SHIFT 0x0
#define MC_SEQ_CNTL_2__DRST_PU_MASK 0x10
#define MC_SEQ_CNTL_2__DRST_PU__SHIFT 0x4
#define MC_SEQ_CNTL_2__DRST_PD_MASK 0x20
#define MC_SEQ_CNTL_2__DRST_PD__SHIFT 0x5
#define MC_SEQ_CNTL_2__ARB_RTDAT_WMK_MSB_MASK 0x300
#define MC_SEQ_CNTL_2__ARB_RTDAT_WMK_MSB__SHIFT 0x8
#define MC_SEQ_CNTL_2__DRST_NSTR_MASK 0xfc00
#define MC_SEQ_CNTL_2__DRST_NSTR__SHIFT 0xa
#define MC_SEQ_CNTL_2__DRST_PSTR_MASK 0x3f0000
#define MC_SEQ_CNTL_2__DRST_PSTR__SHIFT 0x10
#define MC_SEQ_CNTL_2__PLL_TX_PWRON_D0_MASK 0x400000
#define MC_SEQ_CNTL_2__PLL_TX_PWRON_D0__SHIFT 0x16
#define MC_SEQ_CNTL_2__PLL_TX_PWRON_D1_MASK 0x800000
#define MC_SEQ_CNTL_2__PLL_TX_PWRON_D1__SHIFT 0x17
#define MC_SEQ_CNTL_2__PLL_RX_PWRON_D0_MASK 0xf000000
#define MC_SEQ_CNTL_2__PLL_RX_PWRON_D0__SHIFT 0x18
#define MC_SEQ_CNTL_2__PLL_RX_PWRON_D1_MASK 0xf0000000
#define MC_SEQ_CNTL_2__PLL_RX_PWRON_D1__SHIFT 0x1c
#define MC_SEQ_DRAM__ADR_2CK_MASK 0x1
#define MC_SEQ_DRAM__ADR_2CK__SHIFT 0x0
#define MC_SEQ_DRAM__ADR_MUX_MASK 0x2
#define MC_SEQ_DRAM__ADR_MUX__SHIFT 0x1
#define MC_SEQ_DRAM__ADR_DF1_MASK 0x4
#define MC_SEQ_DRAM__ADR_DF1__SHIFT 0x2
#define MC_SEQ_DRAM__AP8_MASK 0x8
#define MC_SEQ_DRAM__AP8__SHIFT 0x3
#define MC_SEQ_DRAM__DAT_DF1_MASK 0x10
#define MC_SEQ_DRAM__DAT_DF1__SHIFT 0x4
#define MC_SEQ_DRAM__DQS_DF1_MASK 0x20
#define MC_SEQ_DRAM__DQS_DF1__SHIFT 0x5
#define MC_SEQ_DRAM__DQM_DF1_MASK 0x40
#define MC_SEQ_DRAM__DQM_DF1__SHIFT 0x6
#define MC_SEQ_DRAM__DQM_ACT_MASK 0x80
#define MC_SEQ_DRAM__DQM_ACT__SHIFT 0x7
#define MC_SEQ_DRAM__STB_CNT_MASK 0xf00
#define MC_SEQ_DRAM__STB_CNT__SHIFT 0x8
#define MC_SEQ_DRAM__CKE_DYN_MASK 0x1000
#define MC_SEQ_DRAM__CKE_DYN__SHIFT 0xc
#define MC_SEQ_DRAM__CKE_ACT_MASK 0x2000
#define MC_SEQ_DRAM__CKE_ACT__SHIFT 0xd
#define MC_SEQ_DRAM__BO4_MASK 0x4000
#define MC_SEQ_DRAM__BO4__SHIFT 0xe
#define MC_SEQ_DRAM__DLL_CLR_MASK 0x8000
#define MC_SEQ_DRAM__DLL_CLR__SHIFT 0xf
#define MC_SEQ_DRAM__DLL_CNT_MASK 0xff0000
#define MC_SEQ_DRAM__DLL_CNT__SHIFT 0x10
#define MC_SEQ_DRAM__DAT_INV_MASK 0x1000000
#define MC_SEQ_DRAM__DAT_INV__SHIFT 0x18
#define MC_SEQ_DRAM__INV_ACM_MASK 0x2000000
#define MC_SEQ_DRAM__INV_ACM__SHIFT 0x19
#define MC_SEQ_DRAM__ODT_ENB_MASK 0x4000000
#define MC_SEQ_DRAM__ODT_ENB__SHIFT 0x1a
#define MC_SEQ_DRAM__ODT_ACT_MASK 0x8000000
#define MC_SEQ_DRAM__ODT_ACT__SHIFT 0x1b
#define MC_SEQ_DRAM__RST_CTL_MASK 0x10000000
#define MC_SEQ_DRAM__RST_CTL__SHIFT 0x1c
#define MC_SEQ_DRAM__TRI_MIO_DYN_MASK 0x20000000
#define MC_SEQ_DRAM__TRI_MIO_DYN__SHIFT 0x1d
#define MC_SEQ_DRAM__TRI_CKE_MASK 0x40000000
#define MC_SEQ_DRAM__TRI_CKE__SHIFT 0x1e
#define MC_SEQ_DRAM__RDSTRB_RSYC_DIS_MASK 0x80000000
#define MC_SEQ_DRAM__RDSTRB_RSYC_DIS__SHIFT 0x1f
#define MC_SEQ_DRAM_2__ADR_DDR_MASK 0x1
#define MC_SEQ_DRAM_2__ADR_DDR__SHIFT 0x0
#define MC_SEQ_DRAM_2__ADR_DBI_MASK 0x2
#define MC_SEQ_DRAM_2__ADR_DBI__SHIFT 0x1
#define MC_SEQ_DRAM_2__ADR_DBI_ACM_MASK 0x4
#define MC_SEQ_DRAM_2__ADR_DBI_ACM__SHIFT 0x2
#define MC_SEQ_DRAM_2__CMD_QDR_MASK 0x8
#define MC_SEQ_DRAM_2__CMD_QDR__SHIFT 0x3
#define MC_SEQ_DRAM_2__DAT_QDR_MASK 0x10
#define MC_SEQ_DRAM_2__DAT_QDR__SHIFT 0x4
#define MC_SEQ_DRAM_2__WDAT_EDC_MASK 0x20
#define MC_SEQ_DRAM_2__WDAT_EDC__SHIFT 0x5
#define MC_SEQ_DRAM_2__RDAT_EDC_MASK 0x40
#define MC_SEQ_DRAM_2__RDAT_EDC__SHIFT 0x6
#define MC_SEQ_DRAM_2__DQM_EST_MASK 0x80
#define MC_SEQ_DRAM_2__DQM_EST__SHIFT 0x7
#define MC_SEQ_DRAM_2__RD_DQS_MASK 0x100
#define MC_SEQ_DRAM_2__RD_DQS__SHIFT 0x8
#define MC_SEQ_DRAM_2__WR_DQS_MASK 0x200
#define MC_SEQ_DRAM_2__WR_DQS__SHIFT 0x9
#define MC_SEQ_DRAM_2__PLL_EST_MASK 0x400
#define MC_SEQ_DRAM_2__PLL_EST__SHIFT 0xa
#define MC_SEQ_DRAM_2__PLL_CLR_MASK 0x800
#define MC_SEQ_DRAM_2__PLL_CLR__SHIFT 0xb
#define MC_SEQ_DRAM_2__DLL_EST_MASK 0x1000
#define MC_SEQ_DRAM_2__DLL_EST__SHIFT 0xc
#define MC_SEQ_DRAM_2__BNK_MRS_MASK 0x2000
#define MC_SEQ_DRAM_2__BNK_MRS__SHIFT 0xd
#define MC_SEQ_DRAM_2__DBI_OVR_MASK 0x4000
#define MC_SEQ_DRAM_2__DBI_OVR__SHIFT 0xe
#define MC_SEQ_DRAM_2__TRI_CLK_MASK 0x8000
#define MC_SEQ_DRAM_2__TRI_CLK__SHIFT 0xf
#define MC_SEQ_DRAM_2__PLL_CNT_MASK 0xff0000
#define MC_SEQ_DRAM_2__PLL_CNT__SHIFT 0x10
#define MC_SEQ_DRAM_2__PCH_BNK_MASK 0x1000000
#define MC_SEQ_DRAM_2__PCH_BNK__SHIFT 0x18
#define MC_SEQ_DRAM_2__ADBI_DF1_MASK 0x2000000
#define MC_SEQ_DRAM_2__ADBI_DF1__SHIFT 0x19
#define MC_SEQ_DRAM_2__ADBI_ACT_MASK 0x4000000
#define MC_SEQ_DRAM_2__ADBI_ACT__SHIFT 0x1a
#define MC_SEQ_DRAM_2__DBI_DF1_MASK 0x8000000
#define MC_SEQ_DRAM_2__DBI_DF1__SHIFT 0x1b
#define MC_SEQ_DRAM_2__DBI_ACT_MASK 0x10000000
#define MC_SEQ_DRAM_2__DBI_ACT__SHIFT 0x1c
#define MC_SEQ_DRAM_2__DBI_EDC_DF1_MASK 0x20000000
#define MC_SEQ_DRAM_2__DBI_EDC_DF1__SHIFT 0x1d
#define MC_SEQ_DRAM_2__TESTCHIP_EN_MASK 0x40000000
#define MC_SEQ_DRAM_2__TESTCHIP_EN__SHIFT 0x1e
#define MC_SEQ_DRAM_2__CS_BY16_MASK 0x80000000
#define MC_SEQ_DRAM_2__CS_BY16__SHIFT 0x1f
#define MC_SEQ_RAS_TIMING__TRCDW_MASK 0x1f
#define MC_SEQ_RAS_TIMING__TRCDW__SHIFT 0x0
#define MC_SEQ_RAS_TIMING__TRCDWA_MASK 0x3e0
#define MC_SEQ_RAS_TIMING__TRCDWA__SHIFT 0x5
#define MC_SEQ_RAS_TIMING__TRCDR_MASK 0x7c00
#define MC_SEQ_RAS_TIMING__TRCDR__SHIFT 0xa
#define MC_SEQ_RAS_TIMING__TRCDRA_MASK 0xf8000
#define MC_SEQ_RAS_TIMING__TRCDRA__SHIFT 0xf
#define MC_SEQ_RAS_TIMING__TRRD_MASK 0xf00000
#define MC_SEQ_RAS_TIMING__TRRD__SHIFT 0x14
#define MC_SEQ_RAS_TIMING__TRC_MASK 0x7f000000
#define MC_SEQ_RAS_TIMING__TRC__SHIFT 0x18
#define MC_SEQ_CAS_TIMING__TNOPW_MASK 0x3
#define MC_SEQ_CAS_TIMING__TNOPW__SHIFT 0x0
#define MC_SEQ_CAS_TIMING__TNOPR_MASK 0xc
#define MC_SEQ_CAS_TIMING__TNOPR__SHIFT 0x2
#define MC_SEQ_CAS_TIMING__TR2W_MASK 0x1f0
#define MC_SEQ_CAS_TIMING__TR2W__SHIFT 0x4
#define MC_SEQ_CAS_TIMING__TCCDL_MASK 0xe00
#define MC_SEQ_CAS_TIMING__TCCDL__SHIFT 0x9
#define MC_SEQ_CAS_TIMING__TR2R_MASK 0xf000
#define MC_SEQ_CAS_TIMING__TR2R__SHIFT 0xc
#define MC_SEQ_CAS_TIMING__TW2R_MASK 0x1f0000
#define MC_SEQ_CAS_TIMING__TW2R__SHIFT 0x10
#define MC_SEQ_CAS_TIMING__TCL_MASK 0x1f000000
#define MC_SEQ_CAS_TIMING__TCL__SHIFT 0x18
#define MC_SEQ_MISC_TIMING__TRP_WRA_MASK 0x3f
#define MC_SEQ_MISC_TIMING__TRP_WRA__SHIFT 0x0
#define MC_SEQ_MISC_TIMING__TRP_RDA_MASK 0x3f00
#define MC_SEQ_MISC_TIMING__TRP_RDA__SHIFT 0x8
#define MC_SEQ_MISC_TIMING__TRP_MASK 0xf8000
#define MC_SEQ_MISC_TIMING__TRP__SHIFT 0xf
#define MC_SEQ_MISC_TIMING__TRFC_MASK 0x1ff00000
#define MC_SEQ_MISC_TIMING__TRFC__SHIFT 0x14
#define MC_SEQ_MISC_TIMING2__PA2RDATA_MASK 0x7
#define MC_SEQ_MISC_TIMING2__PA2RDATA__SHIFT 0x0
#define MC_SEQ_MISC_TIMING2__PA2WDATA_MASK 0x70
#define MC_SEQ_MISC_TIMING2__PA2WDATA__SHIFT 0x4
#define MC_SEQ_MISC_TIMING2__FAW_MASK 0x1f00
#define MC_SEQ_MISC_TIMING2__FAW__SHIFT 0x8
#define MC_SEQ_MISC_TIMING2__TREDC_MASK 0xe000
#define MC_SEQ_MISC_TIMING2__TREDC__SHIFT 0xd
#define MC_SEQ_MISC_TIMING2__TWEDC_MASK 0x1f0000
#define MC_SEQ_MISC_TIMING2__TWEDC__SHIFT 0x10
#define MC_SEQ_MISC_TIMING2__T32AW_MASK 0x1e00000
#define MC_SEQ_MISC_TIMING2__T32AW__SHIFT 0x15
#define MC_SEQ_MISC_TIMING2__TWDATATR_MASK 0xf0000000
#define MC_SEQ_MISC_TIMING2__TWDATATR__SHIFT 0x1c
#define MC_SEQ_PMG_TIMING__TCKSRE_MASK 0x7
#define MC_SEQ_PMG_TIMING__TCKSRE__SHIFT 0x0
#define MC_SEQ_PMG_TIMING__TCKSRX_MASK 0x70
#define MC_SEQ_PMG_TIMING__TCKSRX__SHIFT 0x4
#define MC_SEQ_PMG_TIMING__TCKE_PULSE_MASK 0xf00
#define MC_SEQ_PMG_TIMING__TCKE_PULSE__SHIFT 0x8
#define MC_SEQ_PMG_TIMING__TCKE_MASK 0x3f000
#define MC_SEQ_PMG_TIMING__TCKE__SHIFT 0xc
#define MC_SEQ_PMG_TIMING__SEQ_IDLE_MASK 0x1c0000
#define MC_SEQ_PMG_TIMING__SEQ_IDLE__SHIFT 0x12
#define MC_SEQ_PMG_TIMING__TCKE_PULSE_MSB_MASK 0x800000
#define MC_SEQ_PMG_TIMING__TCKE_PULSE_MSB__SHIFT 0x17
#define MC_SEQ_PMG_TIMING__SEQ_IDLE_SS_MASK 0xff000000
#define MC_SEQ_PMG_TIMING__SEQ_IDLE_SS__SHIFT 0x18
#define MC_SEQ_RD_CTL_D0__RCV_DLY_MASK 0x7
#define MC_SEQ_RD_CTL_D0__RCV_DLY__SHIFT 0x0
#define MC_SEQ_RD_CTL_D0__RCV_EXT_MASK 0xf8
#define MC_SEQ_RD_CTL_D0__RCV_EXT__SHIFT 0x3
#define MC_SEQ_RD_CTL_D0__RST_SEL_MASK 0x300
#define MC_SEQ_RD_CTL_D0__RST_SEL__SHIFT 0x8
#define MC_SEQ_RD_CTL_D0__RXDPWRON_DLY_MASK 0xc00
#define MC_SEQ_RD_CTL_D0__RXDPWRON_DLY__SHIFT 0xa
#define MC_SEQ_RD_CTL_D0__RST_HLD_MASK 0xf000
#define MC_SEQ_RD_CTL_D0__RST_HLD__SHIFT 0xc
#define MC_SEQ_RD_CTL_D0__STR_PRE_MASK 0x10000
#define MC_SEQ_RD_CTL_D0__STR_PRE__SHIFT 0x10
#define MC_SEQ_RD_CTL_D0__STR_PST_MASK 0x20000
#define MC_SEQ_RD_CTL_D0__STR_PST__SHIFT 0x11
#define MC_SEQ_RD_CTL_D0__RBS_DLY_MASK 0x1f00000
#define MC_SEQ_RD_CTL_D0__RBS_DLY__SHIFT 0x14
#define MC_SEQ_RD_CTL_D0__RBS_WEDC_DLY_MASK 0x3e000000
#define MC_SEQ_RD_CTL_D0__RBS_WEDC_DLY__SHIFT 0x19
#define MC_SEQ_RD_CTL_D1__RCV_DLY_MASK 0x7
#define MC_SEQ_RD_CTL_D1__RCV_DLY__SHIFT 0x0
#define MC_SEQ_RD_CTL_D1__RCV_EXT_MASK 0xf8
#define MC_SEQ_RD_CTL_D1__RCV_EXT__SHIFT 0x3
#define MC_SEQ_RD_CTL_D1__RST_SEL_MASK 0x300
#define MC_SEQ_RD_CTL_D1__RST_SEL__SHIFT 0x8
#define MC_SEQ_RD_CTL_D1__RXDPWRON_DLY_MASK 0xc00
#define MC_SEQ_RD_CTL_D1__RXDPWRON_DLY__SHIFT 0xa
#define MC_SEQ_RD_CTL_D1__RST_HLD_MASK 0xf000
#define MC_SEQ_RD_CTL_D1__RST_HLD__SHIFT 0xc
#define MC_SEQ_RD_CTL_D1__STR_PRE_MASK 0x10000
#define MC_SEQ_RD_CTL_D1__STR_PRE__SHIFT 0x10
#define MC_SEQ_RD_CTL_D1__STR_PST_MASK 0x20000
#define MC_SEQ_RD_CTL_D1__STR_PST__SHIFT 0x11
#define MC_SEQ_RD_CTL_D1__RBS_DLY_MASK 0x1f00000
#define MC_SEQ_RD_CTL_D1__RBS_DLY__SHIFT 0x14
#define MC_SEQ_RD_CTL_D1__RBS_WEDC_DLY_MASK 0x3e000000
#define MC_SEQ_RD_CTL_D1__RBS_WEDC_DLY__SHIFT 0x19
#define MC_SEQ_WR_CTL_D0__DAT_DLY_MASK 0xf
#define MC_SEQ_WR_CTL_D0__DAT_DLY__SHIFT 0x0
#define MC_SEQ_WR_CTL_D0__DQS_DLY_MASK 0xf0
#define MC_SEQ_WR_CTL_D0__DQS_DLY__SHIFT 0x4
#define MC_SEQ_WR_CTL_D0__DQS_XTR_MASK 0x100
#define MC_SEQ_WR_CTL_D0__DQS_XTR__SHIFT 0x8
#define MC_SEQ_WR_CTL_D0__DAT_2Y_DLY_MASK 0x200
#define MC_SEQ_WR_CTL_D0__DAT_2Y_DLY__SHIFT 0x9
#define MC_SEQ_WR_CTL_D0__ADR_2Y_DLY_MASK 0x400
#define MC_SEQ_WR_CTL_D0__ADR_2Y_DLY__SHIFT 0xa
#define MC_SEQ_WR_CTL_D0__CMD_2Y_DLY_MASK 0x800
#define MC_SEQ_WR_CTL_D0__CMD_2Y_DLY__SHIFT 0xb
#define MC_SEQ_WR_CTL_D0__OEN_DLY_MASK 0xf000
#define MC_SEQ_WR_CTL_D0__OEN_DLY__SHIFT 0xc
#define MC_SEQ_WR_CTL_D0__OEN_EXT_MASK 0xf0000
#define MC_SEQ_WR_CTL_D0__OEN_EXT__SHIFT 0x10
#define MC_SEQ_WR_CTL_D0__OEN_SEL_MASK 0x300000
#define MC_SEQ_WR_CTL_D0__OEN_SEL__SHIFT 0x14
#define MC_SEQ_WR_CTL_D0__ODT_DLY_MASK 0xf000000
#define MC_SEQ_WR_CTL_D0__ODT_DLY__SHIFT 0x18
#define MC_SEQ_WR_CTL_D0__ODT_EXT_MASK 0x10000000
#define MC_SEQ_WR_CTL_D0__ODT_EXT__SHIFT 0x1c
#define MC_SEQ_WR_CTL_D0__ADR_DLY_MASK 0x20000000
#define MC_SEQ_WR_CTL_D0__ADR_DLY__SHIFT 0x1d
#define MC_SEQ_WR_CTL_D0__CMD_DLY_MASK 0x40000000
#define MC_SEQ_WR_CTL_D0__CMD_DLY__SHIFT 0x1e
#define MC_SEQ_WR_CTL_D1__DAT_DLY_MASK 0xf
#define MC_SEQ_WR_CTL_D1__DAT_DLY__SHIFT 0x0
#define MC_SEQ_WR_CTL_D1__DQS_DLY_MASK 0xf0
#define MC_SEQ_WR_CTL_D1__DQS_DLY__SHIFT 0x4
#define MC_SEQ_WR_CTL_D1__DQS_XTR_MASK 0x100
#define MC_SEQ_WR_CTL_D1__DQS_XTR__SHIFT 0x8
#define MC_SEQ_WR_CTL_D1__DAT_2Y_DLY_MASK 0x200
#define MC_SEQ_WR_CTL_D1__DAT_2Y_DLY__SHIFT 0x9
#define MC_SEQ_WR_CTL_D1__ADR_2Y_DLY_MASK 0x400
#define MC_SEQ_WR_CTL_D1__ADR_2Y_DLY__SHIFT 0xa
#define MC_SEQ_WR_CTL_D1__CMD_2Y_DLY_MASK 0x800
#define MC_SEQ_WR_CTL_D1__CMD_2Y_DLY__SHIFT 0xb
#define MC_SEQ_WR_CTL_D1__OEN_DLY_MASK 0xf000
#define MC_SEQ_WR_CTL_D1__OEN_DLY__SHIFT 0xc
#define MC_SEQ_WR_CTL_D1__OEN_EXT_MASK 0xf0000
#define MC_SEQ_WR_CTL_D1__OEN_EXT__SHIFT 0x10
#define MC_SEQ_WR_CTL_D1__OEN_SEL_MASK 0x300000
#define MC_SEQ_WR_CTL_D1__OEN_SEL__SHIFT 0x14
#define MC_SEQ_WR_CTL_D1__ODT_DLY_MASK 0xf000000
#define MC_SEQ_WR_CTL_D1__ODT_DLY__SHIFT 0x18
#define MC_SEQ_WR_CTL_D1__ODT_EXT_MASK 0x10000000
#define MC_SEQ_WR_CTL_D1__ODT_EXT__SHIFT 0x1c
#define MC_SEQ_WR_CTL_D1__ADR_DLY_MASK 0x20000000
#define MC_SEQ_WR_CTL_D1__ADR_DLY__SHIFT 0x1d
#define MC_SEQ_WR_CTL_D1__CMD_DLY_MASK 0x40000000
#define MC_SEQ_WR_CTL_D1__CMD_DLY__SHIFT 0x1e
#define MC_SEQ_WR_CTL_2__DAT_DLY_H_D0_MASK 0x1
#define MC_SEQ_WR_CTL_2__DAT_DLY_H_D0__SHIFT 0x0
#define MC_SEQ_WR_CTL_2__DQS_DLY_H_D0_MASK 0x2
#define MC_SEQ_WR_CTL_2__DQS_DLY_H_D0__SHIFT 0x1
#define MC_SEQ_WR_CTL_2__OEN_DLY_H_D0_MASK 0x4
#define MC_SEQ_WR_CTL_2__OEN_DLY_H_D0__SHIFT 0x2
#define MC_SEQ_WR_CTL_2__DAT_DLY_H_D1_MASK 0x8
#define MC_SEQ_WR_CTL_2__DAT_DLY_H_D1__SHIFT 0x3
#define MC_SEQ_WR_CTL_2__DQS_DLY_H_D1_MASK 0x10
#define MC_SEQ_WR_CTL_2__DQS_DLY_H_D1__SHIFT 0x4
#define MC_SEQ_WR_CTL_2__OEN_DLY_H_D1_MASK 0x20
#define MC_SEQ_WR_CTL_2__OEN_DLY_H_D1__SHIFT 0x5
#define MC_SEQ_WR_CTL_2__WCDR_EN_MASK 0x40
#define MC_SEQ_WR_CTL_2__WCDR_EN__SHIFT 0x6
#define MC_SEQ_CMD__ADR_MASK 0xffff
#define MC_SEQ_CMD__ADR__SHIFT 0x0
#define MC_SEQ_CMD__MOP_MASK 0xf0000
#define MC_SEQ_CMD__MOP__SHIFT 0x10
#define MC_SEQ_CMD__END_MASK 0x100000
#define MC_SEQ_CMD__END__SHIFT 0x14
#define MC_SEQ_CMD__CSB_MASK 0x600000
#define MC_SEQ_CMD__CSB__SHIFT 0x15
#define MC_SEQ_CMD__CHAN0_MASK 0x1000000
#define MC_SEQ_CMD__CHAN0__SHIFT 0x18
#define MC_SEQ_CMD__CHAN1_MASK 0x2000000
#define MC_SEQ_CMD__CHAN1__SHIFT 0x19
#define MC_SEQ_CMD__ADR_MSB1_MASK 0x10000000
#define MC_SEQ_CMD__ADR_MSB1__SHIFT 0x1c
#define MC_SEQ_CMD__ADR_MSB0_MASK 0x20000000
#define MC_SEQ_CMD__ADR_MSB0__SHIFT 0x1d
#define MC_PMG_CMD_EMRS__ADR_MASK 0xffff
#define MC_PMG_CMD_EMRS__ADR__SHIFT 0x0
#define MC_PMG_CMD_EMRS__MOP_MASK 0x70000
#define MC_PMG_CMD_EMRS__MOP__SHIFT 0x10
#define MC_PMG_CMD_EMRS__BNK_MSB_MASK 0x80000
#define MC_PMG_CMD_EMRS__BNK_MSB__SHIFT 0x13
#define MC_PMG_CMD_EMRS__END_MASK 0x100000
#define MC_PMG_CMD_EMRS__END__SHIFT 0x14
#define MC_PMG_CMD_EMRS__CSB_MASK 0x600000
#define MC_PMG_CMD_EMRS__CSB__SHIFT 0x15
#define MC_PMG_CMD_EMRS__ADR_MSB1_MASK 0x10000000
#define MC_PMG_CMD_EMRS__ADR_MSB1__SHIFT 0x1c
#define MC_PMG_CMD_EMRS__ADR_MSB0_MASK 0x20000000
#define MC_PMG_CMD_EMRS__ADR_MSB0__SHIFT 0x1d
#define MC_PMG_CMD_MRS__ADR_MASK 0xffff
#define MC_PMG_CMD_MRS__ADR__SHIFT 0x0
#define MC_PMG_CMD_MRS__MOP_MASK 0x70000
#define MC_PMG_CMD_MRS__MOP__SHIFT 0x10
#define MC_PMG_CMD_MRS__BNK_MSB_MASK 0x80000
#define MC_PMG_CMD_MRS__BNK_MSB__SHIFT 0x13
#define MC_PMG_CMD_MRS__END_MASK 0x100000
#define MC_PMG_CMD_MRS__END__SHIFT 0x14
#define MC_PMG_CMD_MRS__CSB_MASK 0x600000
#define MC_PMG_CMD_MRS__CSB__SHIFT 0x15
#define MC_PMG_CMD_MRS__ADR_MSB1_MASK 0x10000000
#define MC_PMG_CMD_MRS__ADR_MSB1__SHIFT 0x1c
#define MC_PMG_CMD_MRS__ADR_MSB0_MASK 0x20000000
#define MC_PMG_CMD_MRS__ADR_MSB0__SHIFT 0x1d
#define MC_PMG_CMD_MRS1__ADR_MASK 0xffff
#define MC_PMG_CMD_MRS1__ADR__SHIFT 0x0
#define MC_PMG_CMD_MRS1__MOP_MASK 0x70000
#define MC_PMG_CMD_MRS1__MOP__SHIFT 0x10
#define MC_PMG_CMD_MRS1__BNK_MSB_MASK 0x80000
#define MC_PMG_CMD_MRS1__BNK_MSB__SHIFT 0x13
#define MC_PMG_CMD_MRS1__END_MASK 0x100000
#define MC_PMG_CMD_MRS1__END__SHIFT 0x14
#define MC_PMG_CMD_MRS1__CSB_MASK 0x600000
#define MC_PMG_CMD_MRS1__CSB__SHIFT 0x15
#define MC_PMG_CMD_MRS1__ADR_MSB1_MASK 0x10000000
#define MC_PMG_CMD_MRS1__ADR_MSB1__SHIFT 0x1c
#define MC_PMG_CMD_MRS1__ADR_MSB0_MASK 0x20000000
#define MC_PMG_CMD_MRS1__ADR_MSB0__SHIFT 0x1d
#define MC_PMG_CMD_MRS2__ADR_MASK 0xffff
#define MC_PMG_CMD_MRS2__ADR__SHIFT 0x0
#define MC_PMG_CMD_MRS2__MOP_MASK 0x70000
#define MC_PMG_CMD_MRS2__MOP__SHIFT 0x10
#define MC_PMG_CMD_MRS2__BNK_MSB_MASK 0x80000
#define MC_PMG_CMD_MRS2__BNK_MSB__SHIFT 0x13
#define MC_PMG_CMD_MRS2__END_MASK 0x100000
#define MC_PMG_CMD_MRS2__END__SHIFT 0x14
#define MC_PMG_CMD_MRS2__CSB_MASK 0x600000
#define MC_PMG_CMD_MRS2__CSB__SHIFT 0x15
#define MC_PMG_CMD_MRS2__ADR_MSB1_MASK 0x10000000
#define MC_PMG_CMD_MRS2__ADR_MSB1__SHIFT 0x1c
#define MC_PMG_CMD_MRS2__ADR_MSB0_MASK 0x20000000
#define MC_PMG_CMD_MRS2__ADR_MSB0__SHIFT 0x1d
#define MC_PMG_CFG__SYC_CLK_MASK 0x1
#define MC_PMG_CFG__SYC_CLK__SHIFT 0x0
#define MC_PMG_CFG__RST_MRS_MASK 0x2
#define MC_PMG_CFG__RST_MRS__SHIFT 0x1
#define MC_PMG_CFG__RST_EMRS_MASK 0x4
#define MC_PMG_CFG__RST_EMRS__SHIFT 0x2
#define MC_PMG_CFG__TRI_MIO_MASK 0x8
#define MC_PMG_CFG__TRI_MIO__SHIFT 0x3
#define MC_PMG_CFG__XSR_TMR_MASK 0xf0
#define MC_PMG_CFG__XSR_TMR__SHIFT 0x4
#define MC_PMG_CFG__RST_MRS1_MASK 0x100
#define MC_PMG_CFG__RST_MRS1__SHIFT 0x8
#define MC_PMG_CFG__RST_MRS2_MASK 0x200
#define MC_PMG_CFG__RST_MRS2__SHIFT 0x9
#define MC_PMG_CFG__DPM_WAKE_MASK 0x400
#define MC_PMG_CFG__DPM_WAKE__SHIFT 0xa
#define MC_PMG_CFG__RFS_SRX_MASK 0x1000
#define MC_PMG_CFG__RFS_SRX__SHIFT 0xc
#define MC_PMG_CFG__PREA_SRX_MASK 0x2000
#define MC_PMG_CFG__PREA_SRX__SHIFT 0xd
#define MC_PMG_CFG__MRS_WAIT_CNT_MASK 0xf0000
#define MC_PMG_CFG__MRS_WAIT_CNT__SHIFT 0x10
#define MC_PMG_CFG__WRITE_DURING_DLOCK_MASK 0x100000
#define MC_PMG_CFG__WRITE_DURING_DLOCK__SHIFT 0x14
#define MC_PMG_CFG__YCLK_ON_MASK 0x200000
#define MC_PMG_CFG__YCLK_ON__SHIFT 0x15
#define MC_PMG_CFG__EARLY_ACK_ACPI_MASK 0x400000
#define MC_PMG_CFG__EARLY_ACK_ACPI__SHIFT 0x16
#define MC_PMG_CFG__RXPDNB_MASK 0x2000000
#define MC_PMG_CFG__RXPDNB__SHIFT 0x19
#define MC_PMG_CFG__ZQCL_SEND_MASK 0xc000000
#define MC_PMG_CFG__ZQCL_SEND__SHIFT 0x1a
#define MC_PMG_AUTO_CMD__ADR_MASK 0x1ffff
#define MC_PMG_AUTO_CMD__ADR__SHIFT 0x0
#define MC_PMG_AUTO_CMD__ADR_MSB1_MASK 0x10000000
#define MC_PMG_AUTO_CMD__ADR_MSB1__SHIFT 0x1c
#define MC_PMG_AUTO_CMD__ADR_MSB0_MASK 0x20000000
#define MC_PMG_AUTO_CMD__ADR_MSB0__SHIFT 0x1d
#define MC_PMG_AUTO_CFG__SYC_CLK_MASK 0x1
#define MC_PMG_AUTO_CFG__SYC_CLK__SHIFT 0x0
#define MC_PMG_AUTO_CFG__RST_MRS_MASK 0x2
#define MC_PMG_AUTO_CFG__RST_MRS__SHIFT 0x1
#define MC_PMG_AUTO_CFG__TRI_MIO_MASK 0x4
#define MC_PMG_AUTO_CFG__TRI_MIO__SHIFT 0x2
#define MC_PMG_AUTO_CFG__XSR_TMR_MASK 0xf0
#define MC_PMG_AUTO_CFG__XSR_TMR__SHIFT 0x4
#define MC_PMG_AUTO_CFG__SS_ALWAYS_SLF_MASK 0x100
#define MC_PMG_AUTO_CFG__SS_ALWAYS_SLF__SHIFT 0x8
#define MC_PMG_AUTO_CFG__SS_S_SLF_MASK 0x200
#define MC_PMG_AUTO_CFG__SS_S_SLF__SHIFT 0x9
#define MC_PMG_AUTO_CFG__SCDS_MODE_MASK 0x400
#define MC_PMG_AUTO_CFG__SCDS_MODE__SHIFT 0xa
#define MC_PMG_AUTO_CFG__EXIT_ALLOW_STOP_MASK 0x800
#define MC_PMG_AUTO_CFG__EXIT_ALLOW_STOP__SHIFT 0xb
#define MC_PMG_AUTO_CFG__RFS_SRX_MASK 0x1000
#define MC_PMG_AUTO_CFG__RFS_SRX__SHIFT 0xc
#define MC_PMG_AUTO_CFG__PREA_SRX_MASK 0x2000
#define MC_PMG_AUTO_CFG__PREA_SRX__SHIFT 0xd
#define MC_PMG_AUTO_CFG__STUTTER_EN_MASK 0x4000
#define MC_PMG_AUTO_CFG__STUTTER_EN__SHIFT 0xe
#define MC_PMG_AUTO_CFG__SELFREFR_COMMIT_0_MASK 0x8000
#define MC_PMG_AUTO_CFG__SELFREFR_COMMIT_0__SHIFT 0xf
#define MC_PMG_AUTO_CFG__MRS_WAIT_CNT_MASK 0xf0000
#define MC_PMG_AUTO_CFG__MRS_WAIT_CNT__SHIFT 0x10
#define MC_PMG_AUTO_CFG__WRITE_DURING_DLOCK_MASK 0x100000
#define MC_PMG_AUTO_CFG__WRITE_DURING_DLOCK__SHIFT 0x14
#define MC_PMG_AUTO_CFG__YCLK_ON_MASK 0x200000
#define MC_PMG_AUTO_CFG__YCLK_ON__SHIFT 0x15
#define MC_PMG_AUTO_CFG__RXPDNB_MASK 0x400000
#define MC_PMG_AUTO_CFG__RXPDNB__SHIFT 0x16
#define MC_PMG_AUTO_CFG__SELFREFR_COMMIT_1_MASK 0x800000
#define MC_PMG_AUTO_CFG__SELFREFR_COMMIT_1__SHIFT 0x17
#define MC_PMG_AUTO_CFG__DLL_CNT_MASK 0xff000000
#define MC_PMG_AUTO_CFG__DLL_CNT__SHIFT 0x18
#define MC_IMP_CNTL__MEM_IO_UPDATE_RATE_MASK 0x1f
#define MC_IMP_CNTL__MEM_IO_UPDATE_RATE__SHIFT 0x0
#define MC_IMP_CNTL__CAL_VREF_SEL_MASK 0x20
#define MC_IMP_CNTL__CAL_VREF_SEL__SHIFT 0x5
#define MC_IMP_CNTL__CAL_VREFMODE_MASK 0x40
#define MC_IMP_CNTL__CAL_VREFMODE__SHIFT 0x6
#define MC_IMP_CNTL__TIMEOUT_ERR_MASK 0x100
#define MC_IMP_CNTL__TIMEOUT_ERR__SHIFT 0x8
#define MC_IMP_CNTL__CLEAR_TIMEOUT_ERR_MASK 0x200
#define MC_IMP_CNTL__CLEAR_TIMEOUT_ERR__SHIFT 0x9
#define MC_IMP_CNTL__MEM_IO_SAMPLE_CNT_MASK 0xe000
#define MC_IMP_CNTL__MEM_IO_SAMPLE_CNT__SHIFT 0xd
#define MC_IMP_CNTL__CAL_VREF_MASK 0x7f0000
#define MC_IMP_CNTL__CAL_VREF__SHIFT 0x10
#define MC_IMP_CNTL__CAL_WHEN_IDLE_MASK 0x20000000
#define MC_IMP_CNTL__CAL_WHEN_IDLE__SHIFT 0x1d
#define MC_IMP_CNTL__CAL_WHEN_REFRESH_MASK 0x40000000
#define MC_IMP_CNTL__CAL_WHEN_REFRESH__SHIFT 0x1e
#define MC_IMP_CNTL__CAL_PWRON_MASK 0x80000000
#define MC_IMP_CNTL__CAL_PWRON__SHIFT 0x1f
#define MC_IMP_DEBUG__TSTARTUP_CNTR_MASK 0xff
#define MC_IMP_DEBUG__TSTARTUP_CNTR__SHIFT 0x0
#define MC_IMP_DEBUG__TIMEOUT_CNTR_MASK 0xff00
#define MC_IMP_DEBUG__TIMEOUT_CNTR__SHIFT 0x8
#define MC_IMP_DEBUG__PMVCAL_RESERVED_MASK 0xfff0000
#define MC_IMP_DEBUG__PMVCAL_RESERVED__SHIFT 0x10
#define MC_IMP_DEBUG__DEBUG_CAL_EN_MASK 0x10000000
#define MC_IMP_DEBUG__DEBUG_CAL_EN__SHIFT 0x1c
#define MC_IMP_DEBUG__DEBUG_CAL_START_MASK 0x20000000
#define MC_IMP_DEBUG__DEBUG_CAL_START__SHIFT 0x1d
#define MC_IMP_DEBUG__DEBUG_CAL_INTR_MASK 0x40000000
#define MC_IMP_DEBUG__DEBUG_CAL_INTR__SHIFT 0x1e
#define MC_IMP_DEBUG__DEBUG_CAL_DONE_MASK 0x80000000
#define MC_IMP_DEBUG__DEBUG_CAL_DONE__SHIFT 0x1f
#define MC_IMP_STATUS__PSTR_CAL_MASK 0xff
#define MC_IMP_STATUS__PSTR_CAL__SHIFT 0x0
#define MC_IMP_STATUS__PSTR_ACCUM_VAL_MASK 0xff00
#define MC_IMP_STATUS__PSTR_ACCUM_VAL__SHIFT 0x8
#define MC_IMP_STATUS__NSTR_CAL_MASK 0xff0000
#define MC_IMP_STATUS__NSTR_CAL__SHIFT 0x10
#define MC_IMP_STATUS__NSTR_ACCUM_VAL_MASK 0xff000000
#define MC_IMP_STATUS__NSTR_ACCUM_VAL__SHIFT 0x18
#define MC_IMP_DQ_STATUS__CH0_DQ_PSTR_MASK 0xff
#define MC_IMP_DQ_STATUS__CH0_DQ_PSTR__SHIFT 0x0
#define MC_IMP_DQ_STATUS__CH0_DQ_NSTR_MASK 0xff00
#define MC_IMP_DQ_STATUS__CH0_DQ_NSTR__SHIFT 0x8
#define MC_IMP_DQ_STATUS__CH1_DQ_PSTR_MASK 0xff0000
#define MC_IMP_DQ_STATUS__CH1_DQ_PSTR__SHIFT 0x10
#define MC_IMP_DQ_STATUS__CH1_DQ_NSTR_MASK 0xff000000
#define MC_IMP_DQ_STATUS__CH1_DQ_NSTR__SHIFT 0x18
#define MC_SEQ_WCDR_CTRL__WCDR_PRE_MASK 0xff
#define MC_SEQ_WCDR_CTRL__WCDR_PRE__SHIFT 0x0
#define MC_SEQ_WCDR_CTRL__WCDR_TIM_MASK 0xf00
#define MC_SEQ_WCDR_CTRL__WCDR_TIM__SHIFT 0x8
#define MC_SEQ_WCDR_CTRL__WR_EN_MASK 0x1000
#define MC_SEQ_WCDR_CTRL__WR_EN__SHIFT 0xc
#define MC_SEQ_WCDR_CTRL__RD_EN_MASK 0x2000
#define MC_SEQ_WCDR_CTRL__RD_EN__SHIFT 0xd
#define MC_SEQ_WCDR_CTRL__AREF_EN_MASK 0x4000
#define MC_SEQ_WCDR_CTRL__AREF_EN__SHIFT 0xe
#define MC_SEQ_WCDR_CTRL__TRAIN_EN_MASK 0x8000
#define MC_SEQ_WCDR_CTRL__TRAIN_EN__SHIFT 0xf
#define MC_SEQ_WCDR_CTRL__TWCDRL_MASK 0xf0000
#define MC_SEQ_WCDR_CTRL__TWCDRL__SHIFT 0x10
#define MC_SEQ_WCDR_CTRL__PRBS_EN_MASK 0x100000
#define MC_SEQ_WCDR_CTRL__PRBS_EN__SHIFT 0x14
#define MC_SEQ_WCDR_CTRL__PRBS_RST_MASK 0x200000
#define MC_SEQ_WCDR_CTRL__PRBS_RST__SHIFT 0x15
#define MC_SEQ_WCDR_CTRL__PREAMBLE_MASK 0xf000000
#define MC_SEQ_WCDR_CTRL__PREAMBLE__SHIFT 0x18
#define MC_SEQ_WCDR_CTRL__PRE_MASK_MASK 0xf0000000
#define MC_SEQ_WCDR_CTRL__PRE_MASK__SHIFT 0x1c
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BOOT_UP_ADDR_TRAIN_MASK 0x1
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BOOT_UP_ADDR_TRAIN__SHIFT 0x0
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BOOT_UP_WCK_TRAIN_MASK 0x2
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BOOT_UP_WCK_TRAIN__SHIFT 0x1
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BOOT_UP_READ_TRAIN_MASK 0x4
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BOOT_UP_READ_TRAIN__SHIFT 0x2
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BOOT_UP_WRITE_TRAIN_MASK 0x8
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BOOT_UP_WRITE_TRAIN__SHIFT 0x3
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SELF_REFRESH_ADDR_TRAIN_MASK 0x10
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SELF_REFRESH_ADDR_TRAIN__SHIFT 0x4
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SELF_REFRESH_WCK_TRAIN_MASK 0x20
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SELF_REFRESH_WCK_TRAIN__SHIFT 0x5
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SELF_REFRESH_READ_TRAIN_MASK 0x40
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SELF_REFRESH_READ_TRAIN__SHIFT 0x6
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SELF_REFRESH_WRITE_TRAIN_MASK 0x80
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SELF_REFRESH_WRITE_TRAIN__SHIFT 0x7
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_ADDR_TRAIN_MASK 0x100
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_ADDR_TRAIN__SHIFT 0x8
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_WCK_TRAIN_MASK 0x200
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_WCK_TRAIN__SHIFT 0x9
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_READ_TRAIN_MASK 0x400
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_READ_TRAIN__SHIFT 0xa
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_WRITE_TRAIN_MASK 0x800
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_WRITE_TRAIN__SHIFT 0xb
#define MC_SEQ_TRAIN_WAKEUP_CNTL__WRITE_ECC_ADDR_TRAIN_MASK 0x1000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__WRITE_ECC_ADDR_TRAIN__SHIFT 0xc
#define MC_SEQ_TRAIN_WAKEUP_CNTL__WRITE_ECC_WCK_TRAIN_MASK 0x2000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__WRITE_ECC_WCK_TRAIN__SHIFT 0xd
#define MC_SEQ_TRAIN_WAKEUP_CNTL__WRITE_ECC_READ_TRAIN_MASK 0x4000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__WRITE_ECC_READ_TRAIN__SHIFT 0xe
#define MC_SEQ_TRAIN_WAKEUP_CNTL__WRITE_ECC_WRITE_TRAIN_MASK 0x8000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__WRITE_ECC_WRITE_TRAIN__SHIFT 0xf
#define MC_SEQ_TRAIN_WAKEUP_CNTL__READ_ECC_ADDR_TRAIN_MASK 0x10000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__READ_ECC_ADDR_TRAIN__SHIFT 0x10
#define MC_SEQ_TRAIN_WAKEUP_CNTL__READ_ECC_WCK_TRAIN_MASK 0x20000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__READ_ECC_WCK_TRAIN__SHIFT 0x11
#define MC_SEQ_TRAIN_WAKEUP_CNTL__READ_ECC_READ_TRAIN_MASK 0x40000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__READ_ECC_READ_TRAIN__SHIFT 0x12
#define MC_SEQ_TRAIN_WAKEUP_CNTL__READ_ECC_WRITE_TRAIN_MASK 0x80000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__READ_ECC_WRITE_TRAIN__SHIFT 0x13
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_WAKEUP_EARLY_MASK 0x100000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__AUTO_REFRESH_WAKEUP_EARLY__SHIFT 0x14
#define MC_SEQ_TRAIN_WAKEUP_CNTL__STOP_WCK_D0_MASK 0x200000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__STOP_WCK_D0__SHIFT 0x15
#define MC_SEQ_TRAIN_WAKEUP_CNTL__STOP_WCK_D1_MASK 0x400000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__STOP_WCK_D1__SHIFT 0x16
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BLOCK_ARB_RD_D0_MASK 0x1000000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BLOCK_ARB_RD_D0__SHIFT 0x18
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BLOCK_ARB_WR_D0_MASK 0x2000000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BLOCK_ARB_WR_D0__SHIFT 0x19
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BLOCK_ARB_RD_D1_MASK 0x4000000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BLOCK_ARB_RD_D1__SHIFT 0x1a
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BLOCK_ARB_WR_D1_MASK 0x8000000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__BLOCK_ARB_WR_D1__SHIFT 0x1b
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SW_WAKEUP_MASK 0x10000000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__SW_WAKEUP__SHIFT 0x1c
#define MC_SEQ_TRAIN_WAKEUP_CNTL__DISP_ASTOP_WAKEUP_MASK 0x20000000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__DISP_ASTOP_WAKEUP__SHIFT 0x1d
#define MC_SEQ_TRAIN_WAKEUP_CNTL__TRAIN_DONE_D0_MASK 0x40000000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__TRAIN_DONE_D0__SHIFT 0x1e
#define MC_SEQ_TRAIN_WAKEUP_CNTL__TRAIN_DONE_D1_MASK 0x80000000
#define MC_SEQ_TRAIN_WAKEUP_CNTL__TRAIN_DONE_D1__SHIFT 0x1f
#define MC_SEQ_TRAIN_EDC_THRESHOLD__WRITE_EDC_THRESHOLD_MASK 0xffff
#define MC_SEQ_TRAIN_EDC_THRESHOLD__WRITE_EDC_THRESHOLD__SHIFT 0x0
#define MC_SEQ_TRAIN_EDC_THRESHOLD__READ_EDC_THRESHOLD_MASK 0xffff0000
#define MC_SEQ_TRAIN_EDC_THRESHOLD__READ_EDC_THRESHOLD__SHIFT 0x10
#define MC_SEQ_TRAIN_EDC_THRESHOLD2__THRESHOLD_PERIOD_MASK 0xffffffff
#define MC_SEQ_TRAIN_EDC_THRESHOLD2__THRESHOLD_PERIOD__SHIFT 0x0
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CH0_LINK_RETRAIN_STATUS_MASK 0x1
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CH0_LINK_RETRAIN_STATUS__SHIFT 0x0
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CH1_LINK_RETRAIN_STATUS_MASK 0x2
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CH1_LINK_RETRAIN_STATUS__SHIFT 0x1
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CLEAR_RETRAIN_STATUS_MASK 0x4
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CLEAR_RETRAIN_STATUS__SHIFT 0x2
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__RETRAIN_VBI_MASK 0x8
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__RETRAIN_VBI__SHIFT 0x3
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__RETRAIN_MONITOR_MASK 0x30
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__RETRAIN_MONITOR__SHIFT 0x4
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CH0_LINK_RETRAIN_IN_PROGRESS_MASK 0x100
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CH0_LINK_RETRAIN_IN_PROGRESS__SHIFT 0x8
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CH1_LINK_RETRAIN_IN_PROGRESS_MASK 0x200
#define MC_SEQ_TRAIN_EDC_THRESHOLD3__CH1_LINK_RETRAIN_IN_PROGRESS__SHIFT 0x9
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_ARF_WAKEUP_MASK 0x1
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_ARF_WAKEUP__SHIFT 0x0
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_ARF_WAKEUP_MASK 0x2
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_ARF_WAKEUP__SHIFT 0x1
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_REDC_WAKEUP_MASK 0x4
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_REDC_WAKEUP__SHIFT 0x2
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_REDC_WAKEUP_MASK 0x8
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_REDC_WAKEUP__SHIFT 0x3
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_WEDC_WAKEUP_MASK 0x10
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_WEDC_WAKEUP__SHIFT 0x4
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_WEDC_WAKEUP_MASK 0x20
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_WEDC_WAKEUP__SHIFT 0x5
#define MC_SEQ_TRAIN_WAKEUP_EDGE__MCLK_FREQ_CHANGE_WAKEUP_MASK 0x40
#define MC_SEQ_TRAIN_WAKEUP_EDGE__MCLK_FREQ_CHANGE_WAKEUP__SHIFT 0x6
#define MC_SEQ_TRAIN_WAKEUP_EDGE__SCLK_SRBM_READY_WAKEUP_MASK 0x80
#define MC_SEQ_TRAIN_WAKEUP_EDGE__SCLK_SRBM_READY_WAKEUP__SHIFT 0x7
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_CMD_FIFO_READY_WAKEUP_MASK 0x100
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_CMD_FIFO_READY_WAKEUP__SHIFT 0x8
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_CMD_FIFO_READY_WAKEUP_MASK 0x200
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_CMD_FIFO_READY_WAKEUP__SHIFT 0x9
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_DATA_FIFO_READY_WAKEUP_MASK 0x400
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_DATA_FIFO_READY_WAKEUP__SHIFT 0xa
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_DATA_FIFO_READY_WAKEUP_MASK 0x800
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_DATA_FIFO_READY_WAKEUP__SHIFT 0xb
#define MC_SEQ_TRAIN_WAKEUP_EDGE__SOFTWARE_WAKEUP_WAKEUP_MASK 0x1000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__SOFTWARE_WAKEUP_WAKEUP__SHIFT 0xc
#define MC_SEQ_TRAIN_WAKEUP_EDGE__RESERVE0_WAKEUP_MASK 0x2000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__RESERVE0_WAKEUP__SHIFT 0xd
#define MC_SEQ_TRAIN_WAKEUP_EDGE__TSM_DONE_WAKEUP_MASK 0x4000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__TSM_DONE_WAKEUP__SHIFT 0xe
#define MC_SEQ_TRAIN_WAKEUP_EDGE__TIMER_DONE_WAKEUP_MASK 0x8000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__TIMER_DONE_WAKEUP__SHIFT 0xf
#define MC_SEQ_TRAIN_WAKEUP_EDGE__TCG_DONE_WAKEUP_MASK 0x20000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__TCG_DONE_WAKEUP__SHIFT 0x11
#define MC_SEQ_TRAIN_WAKEUP_EDGE__ALLOWSTOP0_WAKEUP_MASK 0x40000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__ALLOWSTOP0_WAKEUP__SHIFT 0x12
#define MC_SEQ_TRAIN_WAKEUP_EDGE__ALLOWSTOP1_WAKEUP_MASK 0x80000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__ALLOWSTOP1_WAKEUP__SHIFT 0x13
#define MC_SEQ_TRAIN_WAKEUP_EDGE__DPM_WAKEUP_MASK 0x100000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__DPM_WAKEUP__SHIFT 0x14
#define MC_SEQ_TRAIN_WAKEUP_EDGE__ALLOWSTOPB0_WAKEUP_MASK 0x200000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__ALLOWSTOPB0_WAKEUP__SHIFT 0x15
#define MC_SEQ_TRAIN_WAKEUP_EDGE__ALLOWSTOPB1_WAKEUP_MASK 0x400000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__ALLOWSTOPB1_WAKEUP__SHIFT 0x16
#define MC_SEQ_TRAIN_WAKEUP_EDGE__DPM_LPT_WAKEUP_MASK 0x800000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__DPM_LPT_WAKEUP__SHIFT 0x17
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_IDLEH_WAKEUP_MASK 0x1000000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D0_IDLEH_WAKEUP__SHIFT 0x18
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_IDLEH_WAKEUP_MASK 0x2000000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__D1_IDLEH_WAKEUP__SHIFT 0x19
#define MC_SEQ_TRAIN_WAKEUP_EDGE__PHY_PG_WAKEUP_MASK 0x4000000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__PHY_PG_WAKEUP__SHIFT 0x1a
#define MC_SEQ_TRAIN_WAKEUP_EDGE__SREG_WAKEUP_MASK 0x8000000
#define MC_SEQ_TRAIN_WAKEUP_EDGE__SREG_WAKEUP__SHIFT 0x1b
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_ARF_WAKEUP_MASK 0x1
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_ARF_WAKEUP__SHIFT 0x0
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_ARF_WAKEUP_MASK 0x2
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_ARF_WAKEUP__SHIFT 0x1
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_REDC_WAKEUP_MASK 0x4
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_REDC_WAKEUP__SHIFT 0x2
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_REDC_WAKEUP_MASK 0x8
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_REDC_WAKEUP__SHIFT 0x3
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_WEDC_WAKEUP_MASK 0x10
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_WEDC_WAKEUP__SHIFT 0x4
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_WEDC_WAKEUP_MASK 0x20
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_WEDC_WAKEUP__SHIFT 0x5
#define MC_SEQ_TRAIN_WAKEUP_MASK__MCLK_FREQ_CHANGE_WAKEUP_MASK 0x40
#define MC_SEQ_TRAIN_WAKEUP_MASK__MCLK_FREQ_CHANGE_WAKEUP__SHIFT 0x6
#define MC_SEQ_TRAIN_WAKEUP_MASK__SCLK_SRBM_READY_WAKEUP_MASK 0x80
#define MC_SEQ_TRAIN_WAKEUP_MASK__SCLK_SRBM_READY_WAKEUP__SHIFT 0x7
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_CMD_FIFO_READY_WAKEUP_MASK 0x100
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_CMD_FIFO_READY_WAKEUP__SHIFT 0x8
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_CMD_FIFO_READY_WAKEUP_MASK 0x200
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_CMD_FIFO_READY_WAKEUP__SHIFT 0x9
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_DATA_FIFO_READY_WAKEUP_MASK 0x400
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_DATA_FIFO_READY_WAKEUP__SHIFT 0xa
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_DATA_FIFO_READY_WAKEUP_MASK 0x800
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_DATA_FIFO_READY_WAKEUP__SHIFT 0xb
#define MC_SEQ_TRAIN_WAKEUP_MASK__SOFTWARE_WAKEUP_WAKEUP_MASK 0x1000
#define MC_SEQ_TRAIN_WAKEUP_MASK__SOFTWARE_WAKEUP_WAKEUP__SHIFT 0xc
#define MC_SEQ_TRAIN_WAKEUP_MASK__RESERVE0_WAKEUP_MASK 0x2000
#define MC_SEQ_TRAIN_WAKEUP_MASK__RESERVE0_WAKEUP__SHIFT 0xd
#define MC_SEQ_TRAIN_WAKEUP_MASK__TSM_DONE_WAKEUP_MASK 0x4000
#define MC_SEQ_TRAIN_WAKEUP_MASK__TSM_DONE_WAKEUP__SHIFT 0xe
#define MC_SEQ_TRAIN_WAKEUP_MASK__TIMER_DONE_WAKEUP_MASK 0x8000
#define MC_SEQ_TRAIN_WAKEUP_MASK__TIMER_DONE_WAKEUP__SHIFT 0xf
#define MC_SEQ_TRAIN_WAKEUP_MASK__TCG_DONE_WAKEUP_MASK 0x20000
#define MC_SEQ_TRAIN_WAKEUP_MASK__TCG_DONE_WAKEUP__SHIFT 0x11
#define MC_SEQ_TRAIN_WAKEUP_MASK__ALLOWSTOP0_WAKEUP_MASK 0x40000
#define MC_SEQ_TRAIN_WAKEUP_MASK__ALLOWSTOP0_WAKEUP__SHIFT 0x12
#define MC_SEQ_TRAIN_WAKEUP_MASK__ALLOWSTOP1_WAKEUP_MASK 0x80000
#define MC_SEQ_TRAIN_WAKEUP_MASK__ALLOWSTOP1_WAKEUP__SHIFT 0x13
#define MC_SEQ_TRAIN_WAKEUP_MASK__DPM_WAKEUP_MASK 0x100000
#define MC_SEQ_TRAIN_WAKEUP_MASK__DPM_WAKEUP__SHIFT 0x14
#define MC_SEQ_TRAIN_WAKEUP_MASK__ALLOWSTOPB0_WAKEUP_MASK 0x200000
#define MC_SEQ_TRAIN_WAKEUP_MASK__ALLOWSTOPB0_WAKEUP__SHIFT 0x15
#define MC_SEQ_TRAIN_WAKEUP_MASK__ALLOWSTOPB1_WAKEUP_MASK 0x400000
#define MC_SEQ_TRAIN_WAKEUP_MASK__ALLOWSTOPB1_WAKEUP__SHIFT 0x16
#define MC_SEQ_TRAIN_WAKEUP_MASK__DPM_LPT_WAKEUP_MASK 0x800000
#define MC_SEQ_TRAIN_WAKEUP_MASK__DPM_LPT_WAKEUP__SHIFT 0x17
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_IDLEH_WAKEUP_MASK 0x1000000
#define MC_SEQ_TRAIN_WAKEUP_MASK__D0_IDLEH_WAKEUP__SHIFT 0x18
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_IDLEH_WAKEUP_MASK 0x2000000
#define MC_SEQ_TRAIN_WAKEUP_MASK__D1_IDLEH_WAKEUP__SHIFT 0x19
#define MC_SEQ_TRAIN_WAKEUP_MASK__PHY_PG_WAKEUP_MASK 0x4000000
#define MC_SEQ_TRAIN_WAKEUP_MASK__PHY_PG_WAKEUP__SHIFT 0x1a
#define MC_SEQ_TRAIN_WAKEUP_MASK__SREG_WAKEUP_MASK 0x8000000
#define MC_SEQ_TRAIN_WAKEUP_MASK__SREG_WAKEUP__SHIFT 0x1b
#define MC_SEQ_TRAIN_CAPTURE__D0_ARF_WAKEUP_MASK 0x1
#define MC_SEQ_TRAIN_CAPTURE__D0_ARF_WAKEUP__SHIFT 0x0
#define MC_SEQ_TRAIN_CAPTURE__D1_ARF_WAKEUP_MASK 0x2
#define MC_SEQ_TRAIN_CAPTURE__D1_ARF_WAKEUP__SHIFT 0x1
#define MC_SEQ_TRAIN_CAPTURE__D0_REDC_WAKEUP_MASK 0x4
#define MC_SEQ_TRAIN_CAPTURE__D0_REDC_WAKEUP__SHIFT 0x2
#define MC_SEQ_TRAIN_CAPTURE__D1_REDC_WAKEUP_MASK 0x8
#define MC_SEQ_TRAIN_CAPTURE__D1_REDC_WAKEUP__SHIFT 0x3
#define MC_SEQ_TRAIN_CAPTURE__D0_WEDC_WAKEUP_MASK 0x10
#define MC_SEQ_TRAIN_CAPTURE__D0_WEDC_WAKEUP__SHIFT 0x4
#define MC_SEQ_TRAIN_CAPTURE__D1_WEDC_WAKEUP_MASK 0x20
#define MC_SEQ_TRAIN_CAPTURE__D1_WEDC_WAKEUP__SHIFT 0x5
#define MC_SEQ_TRAIN_CAPTURE__MCLK_FREQ_CHANGE_WAKEUP_MASK 0x40
#define MC_SEQ_TRAIN_CAPTURE__MCLK_FREQ_CHANGE_WAKEUP__SHIFT 0x6
#define MC_SEQ_TRAIN_CAPTURE__SCLK_SRBM_READY_WAKEUP_MASK 0x80
#define MC_SEQ_TRAIN_CAPTURE__SCLK_SRBM_READY_WAKEUP__SHIFT 0x7
#define MC_SEQ_TRAIN_CAPTURE__D0_CMD_FIFO_READY_WAKEUP_MASK 0x100
#define MC_SEQ_TRAIN_CAPTURE__D0_CMD_FIFO_READY_WAKEUP__SHIFT 0x8
#define MC_SEQ_TRAIN_CAPTURE__D1_CMD_FIFO_READY_WAKEUP_MASK 0x200
#define MC_SEQ_TRAIN_CAPTURE__D1_CMD_FIFO_READY_WAKEUP__SHIFT 0x9
#define MC_SEQ_TRAIN_CAPTURE__D0_DATA_FIFO_READY_WAKEUP_MASK 0x400
#define MC_SEQ_TRAIN_CAPTURE__D0_DATA_FIFO_READY_WAKEUP__SHIFT 0xa
#define MC_SEQ_TRAIN_CAPTURE__D1_DATA_FIFO_READY_WAKEUP_MASK 0x800
#define MC_SEQ_TRAIN_CAPTURE__D1_DATA_FIFO_READY_WAKEUP__SHIFT 0xb
#define MC_SEQ_TRAIN_CAPTURE__SOFTWARE_WAKEUP_WAKEUP_MASK 0x1000
#define MC_SEQ_TRAIN_CAPTURE__SOFTWARE_WAKEUP_WAKEUP__SHIFT 0xc
#define MC_SEQ_TRAIN_CAPTURE__RESERVE0_WAKEUP_MASK 0x2000
#define MC_SEQ_TRAIN_CAPTURE__RESERVE0_WAKEUP__SHIFT 0xd
#define MC_SEQ_TRAIN_CAPTURE__TSM_DONE_WAKEUP_MASK 0x4000
#define MC_SEQ_TRAIN_CAPTURE__TSM_DONE_WAKEUP__SHIFT 0xe
#define MC_SEQ_TRAIN_CAPTURE__TIMER_DONE_WAKEUP_MASK 0x8000
#define MC_SEQ_TRAIN_CAPTURE__TIMER_DONE_WAKEUP__SHIFT 0xf
#define MC_SEQ_TRAIN_CAPTURE__TCG_DONE_WAKEUP_MASK 0x20000
#define MC_SEQ_TRAIN_CAPTURE__TCG_DONE_WAKEUP__SHIFT 0x11
#define MC_SEQ_TRAIN_CAPTURE__ALLOWSTOP0_WAKEUP_MASK 0x40000
#define MC_SEQ_TRAIN_CAPTURE__ALLOWSTOP0_WAKEUP__SHIFT 0x12
#define MC_SEQ_TRAIN_CAPTURE__ALLOWSTOP1_WAKEUP_MASK 0x80000
#define MC_SEQ_TRAIN_CAPTURE__ALLOWSTOP1_WAKEUP__SHIFT 0x13
#define MC_SEQ_TRAIN_CAPTURE__DPM_WAKEUP_MASK 0x100000
#define MC_SEQ_TRAIN_CAPTURE__DPM_WAKEUP__SHIFT 0x14
#define MC_SEQ_TRAIN_CAPTURE__ALLOWSTOPB0_WAKEUP_MASK 0x200000
#define MC_SEQ_TRAIN_CAPTURE__ALLOWSTOPB0_WAKEUP__SHIFT 0x15
#define MC_SEQ_TRAIN_CAPTURE__ALLOWSTOPB1_WAKEUP_MASK 0x400000
#define MC_SEQ_TRAIN_CAPTURE__ALLOWSTOPB1_WAKEUP__SHIFT 0x16
#define MC_SEQ_TRAIN_CAPTURE__DPM_LPT_WAKEUP_MASK 0x800000
#define MC_SEQ_TRAIN_CAPTURE__DPM_LPT_WAKEUP__SHIFT 0x17
#define MC_SEQ_TRAIN_CAPTURE__D0_IDLEH_WAKEUP_MASK 0x1000000
#define MC_SEQ_TRAIN_CAPTURE__D0_IDLEH_WAKEUP__SHIFT 0x18
#define MC_SEQ_TRAIN_CAPTURE__D1_IDLEH_WAKEUP_MASK 0x2000000
#define MC_SEQ_TRAIN_CAPTURE__D1_IDLEH_WAKEUP__SHIFT 0x19
#define MC_SEQ_TRAIN_CAPTURE__PHY_PG_WAKEUP_MASK 0x4000000
#define MC_SEQ_TRAIN_CAPTURE__PHY_PG_WAKEUP__SHIFT 0x1a
#define MC_SEQ_TRAIN_CAPTURE__SREG_WAKEUP_MASK 0x8000000
#define MC_SEQ_TRAIN_CAPTURE__SREG_WAKEUP__SHIFT 0x1b
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_ARF_WAKEUP_MASK 0x1
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_ARF_WAKEUP__SHIFT 0x0
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_ARF_WAKEUP_MASK 0x2
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_ARF_WAKEUP__SHIFT 0x1
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_REDC_WAKEUP_MASK 0x4
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_REDC_WAKEUP__SHIFT 0x2
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_REDC_WAKEUP_MASK 0x8
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_REDC_WAKEUP__SHIFT 0x3
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_WEDC_WAKEUP_MASK 0x10
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_WEDC_WAKEUP__SHIFT 0x4
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_WEDC_WAKEUP_MASK 0x20
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_WEDC_WAKEUP__SHIFT 0x5
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__MCLK_FREQ_CHANGE_WAKEUP_MASK 0x40
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__MCLK_FREQ_CHANGE_WAKEUP__SHIFT 0x6
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__SCLK_SRBM_READY_WAKEUP_MASK 0x80
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__SCLK_SRBM_READY_WAKEUP__SHIFT 0x7
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_CMD_FIFO_READY_WAKEUP_MASK 0x100
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_CMD_FIFO_READY_WAKEUP__SHIFT 0x8
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_CMD_FIFO_READY_WAKEUP_MASK 0x200
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_CMD_FIFO_READY_WAKEUP__SHIFT 0x9
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_DATA_FIFO_READY_WAKEUP_MASK 0x400
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_DATA_FIFO_READY_WAKEUP__SHIFT 0xa
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_DATA_FIFO_READY_WAKEUP_MASK 0x800
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_DATA_FIFO_READY_WAKEUP__SHIFT 0xb
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__SOFTWARE_WAKEUP_WAKEUP_MASK 0x1000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__SOFTWARE_WAKEUP_WAKEUP__SHIFT 0xc
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__RESERVE0_WAKEUP_MASK 0x2000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__RESERVE0_WAKEUP__SHIFT 0xd
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__TSM_DONE_WAKEUP_MASK 0x4000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__TSM_DONE_WAKEUP__SHIFT 0xe
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__TIMER_DONE_WAKEUP_MASK 0x8000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__TIMER_DONE_WAKEUP__SHIFT 0xf
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__CLEARALL_MASK 0x10000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__CLEARALL__SHIFT 0x10
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__TCG_DONE_WAKEUP_MASK 0x20000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__TCG_DONE_WAKEUP__SHIFT 0x11
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__ALLOWSTOP0_WAKEUP_MASK 0x40000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__ALLOWSTOP0_WAKEUP__SHIFT 0x12
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__ALLOWSTOP1_WAKEUP_MASK 0x80000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__ALLOWSTOP1_WAKEUP__SHIFT 0x13
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__DPM_WAKEUP_MASK 0x100000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__DPM_WAKEUP__SHIFT 0x14
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__ALLOWSTOPB0_WAKEUP_MASK 0x200000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__ALLOWSTOPB0_WAKEUP__SHIFT 0x15
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__ALLOWSTOPB1_WAKEUP_MASK 0x400000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__ALLOWSTOPB1_WAKEUP__SHIFT 0x16
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__DPM_LPT_WAKEUP_MASK 0x800000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__DPM_LPT_WAKEUP__SHIFT 0x17
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_IDLEH_WAKEUP_MASK 0x1000000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D0_IDLEH_WAKEUP__SHIFT 0x18
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_IDLEH_WAKEUP_MASK 0x2000000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__D1_IDLEH_WAKEUP__SHIFT 0x19
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__PHY_PG_WAKEUP_MASK 0x4000000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__PHY_PG_WAKEUP__SHIFT 0x1a
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__SREG_WAKEUP_MASK 0x8000000
#define MC_SEQ_TRAIN_WAKEUP_CLEAR__SREG_WAKEUP__SHIFT 0x1b
#define MC_SEQ_TRAIN_TIMING__TWT2RT_MASK 0x1f
#define MC_SEQ_TRAIN_TIMING__TWT2RT__SHIFT 0x0
#define MC_SEQ_TRAIN_TIMING__TARF2T_MASK 0x3e0
#define MC_SEQ_TRAIN_TIMING__TARF2T__SHIFT 0x5
#define MC_SEQ_TRAIN_TIMING__TT2ROW_MASK 0x7c00
#define MC_SEQ_TRAIN_TIMING__TT2ROW__SHIFT 0xa
#define MC_SEQ_TRAIN_TIMING__TLD2LD_MASK 0xf8000
#define MC_SEQ_TRAIN_TIMING__TLD2LD__SHIFT 0xf
#define MC_TRAIN_EDCCDR_R_D0__EDC0_MASK 0xff
#define MC_TRAIN_EDCCDR_R_D0__EDC0__SHIFT 0x0
#define MC_TRAIN_EDCCDR_R_D0__EDC1_MASK 0xff00
#define MC_TRAIN_EDCCDR_R_D0__EDC1__SHIFT 0x8
#define MC_TRAIN_EDCCDR_R_D0__EDC2_MASK 0xff0000
#define MC_TRAIN_EDCCDR_R_D0__EDC2__SHIFT 0x10
#define MC_TRAIN_EDCCDR_R_D0__EDC3_MASK 0xff000000
#define MC_TRAIN_EDCCDR_R_D0__EDC3__SHIFT 0x18
#define MC_TRAIN_EDCCDR_R_D1__EDC0_MASK 0xff
#define MC_TRAIN_EDCCDR_R_D1__EDC0__SHIFT 0x0
#define MC_TRAIN_EDCCDR_R_D1__EDC1_MASK 0xff00
#define MC_TRAIN_EDCCDR_R_D1__EDC1__SHIFT 0x8
#define MC_TRAIN_EDCCDR_R_D1__EDC2_MASK 0xff0000
#define MC_TRAIN_EDCCDR_R_D1__EDC2__SHIFT 0x10
#define MC_TRAIN_EDCCDR_R_D1__EDC3_MASK 0xff000000
#define MC_TRAIN_EDCCDR_R_D1__EDC3__SHIFT 0x18
#define MC_TRAIN_PRBSERR_0_D0__DQ_STATUS_MASK 0xffffffff
#define MC_TRAIN_PRBSERR_0_D0__DQ_STATUS__SHIFT 0x0
#define MC_TRAIN_PRBSERR_1_D0__DBI_STATUS_MASK 0xf
#define MC_TRAIN_PRBSERR_1_D0__DBI_STATUS__SHIFT 0x0
#define MC_TRAIN_PRBSERR_1_D0__EDC_STATUS_MASK 0xf0
#define MC_TRAIN_PRBSERR_1_D0__EDC_STATUS__SHIFT 0x4
#define MC_TRAIN_PRBSERR_1_D0__WCK_STATUS_MASK 0xf00
#define MC_TRAIN_PRBSERR_1_D0__WCK_STATUS__SHIFT 0x8
#define MC_TRAIN_PRBSERR_1_D0__WCDR_STATUS_MASK 0xf000
#define MC_TRAIN_PRBSERR_1_D0__WCDR_STATUS__SHIFT 0xc
#define MC_TRAIN_PRBSERR_1_D0__PMA_PRBSCLR_MASK 0x10000000
#define MC_TRAIN_PRBSERR_1_D0__PMA_PRBSCLR__SHIFT 0x1c
#define MC_TRAIN_PRBSERR_1_D0__PMD0_PRBSCLR_MASK 0x20000000
#define MC_TRAIN_PRBSERR_1_D0__PMD0_PRBSCLR__SHIFT 0x1d
#define MC_TRAIN_PRBSERR_1_D0__PMD1_PRBSCLR_MASK 0x40000000
#define MC_TRAIN_PRBSERR_1_D0__PMD1_PRBSCLR__SHIFT 0x1e
#define MC_TRAIN_PRBSERR_2_D0__CK_STATUS_MASK 0x1
#define MC_TRAIN_PRBSERR_2_D0__CK_STATUS__SHIFT 0x0
#define MC_TRAIN_PRBSERR_2_D0__CKB_STATUS_MASK 0x2
#define MC_TRAIN_PRBSERR_2_D0__CKB_STATUS__SHIFT 0x1
#define MC_TRAIN_PRBSERR_2_D0__CS_STATUS_MASK 0x30
#define MC_TRAIN_PRBSERR_2_D0__CS_STATUS__SHIFT 0x4
#define MC_TRAIN_PRBSERR_2_D0__CKE_STATUS_MASK 0x100
#define MC_TRAIN_PRBSERR_2_D0__CKE_STATUS__SHIFT 0x8
#define MC_TRAIN_PRBSERR_2_D0__RAS_STATUS_MASK 0x200
#define MC_TRAIN_PRBSERR_2_D0__RAS_STATUS__SHIFT 0x9
#define MC_TRAIN_PRBSERR_2_D0__CAS_STATUS_MASK 0x400
#define MC_TRAIN_PRBSERR_2_D0__CAS_STATUS__SHIFT 0xa
#define MC_TRAIN_PRBSERR_2_D0__WE_STATUS_MASK 0x800
#define MC_TRAIN_PRBSERR_2_D0__WE_STATUS__SHIFT 0xb
#define MC_TRAIN_PRBSERR_2_D0__ADDR_STATUS_MASK 0x3ff0000
#define MC_TRAIN_PRBSERR_2_D0__ADDR_STATUS__SHIFT 0x10
#define MC_TRAIN_PRBSERR_2_D0__ABI_STATUS_MASK 0x10000000
#define MC_TRAIN_PRBSERR_2_D0__ABI_STATUS__SHIFT 0x1c
#define MC_TRAIN_EDC_STATUS_D0__WEDC_CNT_MASK 0xffff
#define MC_TRAIN_EDC_STATUS_D0__WEDC_CNT__SHIFT 0x0
#define MC_TRAIN_EDC_STATUS_D0__REDC_CNT_MASK 0xffff0000
#define MC_TRAIN_EDC_STATUS_D0__REDC_CNT__SHIFT 0x10
#define MC_TRAIN_PRBSERR_0_D1__DQ_STATUS_MASK 0xffffffff
#define MC_TRAIN_PRBSERR_0_D1__DQ_STATUS__SHIFT 0x0
#define MC_TRAIN_PRBSERR_1_D1__DBI_STATUS_MASK 0xf
#define MC_TRAIN_PRBSERR_1_D1__DBI_STATUS__SHIFT 0x0
#define MC_TRAIN_PRBSERR_1_D1__EDC_STATUS_MASK 0xf0
#define MC_TRAIN_PRBSERR_1_D1__EDC_STATUS__SHIFT 0x4
#define MC_TRAIN_PRBSERR_1_D1__WCK_STATUS_MASK 0xf00
#define MC_TRAIN_PRBSERR_1_D1__WCK_STATUS__SHIFT 0x8
#define MC_TRAIN_PRBSERR_1_D1__WCDR_STATUS_MASK 0xf000
#define MC_TRAIN_PRBSERR_1_D1__WCDR_STATUS__SHIFT 0xc
#define MC_TRAIN_PRBSERR_1_D1__PMA_PRBSCLR_MASK 0x10000000
#define MC_TRAIN_PRBSERR_1_D1__PMA_PRBSCLR__SHIFT 0x1c
#define MC_TRAIN_PRBSERR_1_D1__PMD0_PRBSCLR_MASK 0x20000000
#define MC_TRAIN_PRBSERR_1_D1__PMD0_PRBSCLR__SHIFT 0x1d
#define MC_TRAIN_PRBSERR_1_D1__PMD1_PRBSCLR_MASK 0x40000000
#define MC_TRAIN_PRBSERR_1_D1__PMD1_PRBSCLR__SHIFT 0x1e
#define MC_TRAIN_PRBSERR_2_D1__CK_STATUS_MASK 0x1
#define MC_TRAIN_PRBSERR_2_D1__CK_STATUS__SHIFT 0x0
#define MC_TRAIN_PRBSERR_2_D1__CKB_STATUS_MASK 0x2
#define MC_TRAIN_PRBSERR_2_D1__CKB_STATUS__SHIFT 0x1
#define MC_TRAIN_PRBSERR_2_D1__CS_STATUS_MASK 0x30
#define MC_TRAIN_PRBSERR_2_D1__CS_STATUS__SHIFT 0x4
#define MC_TRAIN_PRBSERR_2_D1__CKE_STATUS_MASK 0x100
#define MC_TRAIN_PRBSERR_2_D1__CKE_STATUS__SHIFT 0x8
#define MC_TRAIN_PRBSERR_2_D1__RAS_STATUS_MASK 0x200
#define MC_TRAIN_PRBSERR_2_D1__RAS_STATUS__SHIFT 0x9
#define MC_TRAIN_PRBSERR_2_D1__CAS_STATUS_MASK 0x400
#define MC_TRAIN_PRBSERR_2_D1__CAS_STATUS__SHIFT 0xa
#define MC_TRAIN_PRBSERR_2_D1__WE_STATUS_MASK 0x800
#define MC_TRAIN_PRBSERR_2_D1__WE_STATUS__SHIFT 0xb
#define MC_TRAIN_PRBSERR_2_D1__ADDR_STATUS_MASK 0x3ff0000
#define MC_TRAIN_PRBSERR_2_D1__ADDR_STATUS__SHIFT 0x10
#define MC_TRAIN_PRBSERR_2_D1__ABI_STATUS_MASK 0x10000000
#define MC_TRAIN_PRBSERR_2_D1__ABI_STATUS__SHIFT 0x1c
#define MC_TRAIN_EDC_STATUS_D1__WEDC_CNT_MASK 0xffff
#define MC_TRAIN_EDC_STATUS_D1__WEDC_CNT__SHIFT 0x0
#define MC_TRAIN_EDC_STATUS_D1__REDC_CNT_MASK 0xffff0000
#define MC_TRAIN_EDC_STATUS_D1__REDC_CNT__SHIFT 0x10
#define MC_IO_TXCNTL_DPHY0_D0__BIASSEL_MASK 0x3
#define MC_IO_TXCNTL_DPHY0_D0__BIASSEL__SHIFT 0x0
#define MC_IO_TXCNTL_DPHY0_D0__DRVDUTY_MASK 0xc
#define MC_IO_TXCNTL_DPHY0_D0__DRVDUTY__SHIFT 0x2
#define MC_IO_TXCNTL_DPHY0_D0__LOWCMEN_MASK 0x10
#define MC_IO_TXCNTL_DPHY0_D0__LOWCMEN__SHIFT 0x4
#define MC_IO_TXCNTL_DPHY0_D0__QDR_MASK 0x20
#define MC_IO_TXCNTL_DPHY0_D0__QDR__SHIFT 0x5
#define MC_IO_TXCNTL_DPHY0_D0__EMPH_MASK 0x40
#define MC_IO_TXCNTL_DPHY0_D0__EMPH__SHIFT 0x6
#define MC_IO_TXCNTL_DPHY0_D0__TXPD_MASK 0x80
#define MC_IO_TXCNTL_DPHY0_D0__TXPD__SHIFT 0x7
#define MC_IO_TXCNTL_DPHY0_D0__PTERM_MASK 0xf00
#define MC_IO_TXCNTL_DPHY0_D0__PTERM__SHIFT 0x8
#define MC_IO_TXCNTL_DPHY0_D0__NTERM_MASK 0xf000
#define MC_IO_TXCNTL_DPHY0_D0__NTERM__SHIFT 0xc
#define MC_IO_TXCNTL_DPHY0_D0__PDRV_MASK 0xf0000
#define MC_IO_TXCNTL_DPHY0_D0__PDRV__SHIFT 0x10
#define MC_IO_TXCNTL_DPHY0_D0__NDRV_MASK 0xf00000
#define MC_IO_TXCNTL_DPHY0_D0__NDRV__SHIFT 0x14
#define MC_IO_TXCNTL_DPHY0_D0__TSTEN_MASK 0x1000000
#define MC_IO_TXCNTL_DPHY0_D0__TSTEN__SHIFT 0x18
#define MC_IO_TXCNTL_DPHY0_D0__EDCTX_CLKGATE_EN_MASK 0x2000000
#define MC_IO_TXCNTL_DPHY0_D0__EDCTX_CLKGATE_EN__SHIFT 0x19
#define MC_IO_TXCNTL_DPHY0_D0__TXBYPASS_MASK 0x4000000
#define MC_IO_TXCNTL_DPHY0_D0__TXBYPASS__SHIFT 0x1a
#define MC_IO_TXCNTL_DPHY0_D0__PLL_LOOPBCK_MASK 0x8000000
#define MC_IO_TXCNTL_DPHY0_D0__PLL_LOOPBCK__SHIFT 0x1b
#define MC_IO_TXCNTL_DPHY0_D0__TXBYPASS_DATA_MASK 0xf0000000
#define MC_IO_TXCNTL_DPHY0_D0__TXBYPASS_DATA__SHIFT 0x1c
#define MC_IO_TXCNTL_DPHY1_D0__BIASSEL_MASK 0x3
#define MC_IO_TXCNTL_DPHY1_D0__BIASSEL__SHIFT 0x0
#define MC_IO_TXCNTL_DPHY1_D0__DRVDUTY_MASK 0xc
#define MC_IO_TXCNTL_DPHY1_D0__DRVDUTY__SHIFT 0x2
#define MC_IO_TXCNTL_DPHY1_D0__LOWCMEN_MASK 0x10
#define MC_IO_TXCNTL_DPHY1_D0__LOWCMEN__SHIFT 0x4
#define MC_IO_TXCNTL_DPHY1_D0__QDR_MASK 0x20
#define MC_IO_TXCNTL_DPHY1_D0__QDR__SHIFT 0x5
#define MC_IO_TXCNTL_DPHY1_D0__EMPH_MASK 0x40
#define MC_IO_TXCNTL_DPHY1_D0__EMPH__SHIFT 0x6
#define MC_IO_TXCNTL_DPHY1_D0__TXPD_MASK 0x80
#define MC_IO_TXCNTL_DPHY1_D0__TXPD__SHIFT 0x7
#define MC_IO_TXCNTL_DPHY1_D0__PTERM_MASK 0xf00
#define MC_IO_TXCNTL_DPHY1_D0__PTERM__SHIFT 0x8
#define MC_IO_TXCNTL_DPHY1_D0__NTERM_MASK 0xf000
#define MC_IO_TXCNTL_DPHY1_D0__NTERM__SHIFT 0xc
#define MC_IO_TXCNTL_DPHY1_D0__PDRV_MASK 0xf0000
#define MC_IO_TXCNTL_DPHY1_D0__PDRV__SHIFT 0x10
#define MC_IO_TXCNTL_DPHY1_D0__NDRV_MASK 0xf00000
#define MC_IO_TXCNTL_DPHY1_D0__NDRV__SHIFT 0x14
#define MC_IO_TXCNTL_DPHY1_D0__TSTEN_MASK 0x1000000
#define MC_IO_TXCNTL_DPHY1_D0__TSTEN__SHIFT 0x18
#define MC_IO_TXCNTL_DPHY1_D0__EDCTX_CLKGATE_EN_MASK 0x2000000
#define MC_IO_TXCNTL_DPHY1_D0__EDCTX_CLKGATE_EN__SHIFT 0x19
#define MC_IO_TXCNTL_DPHY1_D0__TXBYPASS_MASK 0x4000000
#define MC_IO_TXCNTL_DPHY1_D0__TXBYPASS__SHIFT 0x1a
#define MC_IO_TXCNTL_DPHY1_D0__PLL_LOOPBCK_MASK 0x8000000
#define MC_IO_TXCNTL_DPHY1_D0__PLL_LOOPBCK__SHIFT 0x1b
#define MC_IO_TXCNTL_DPHY1_D0__TXBYPASS_DATA_MASK 0xf0000000
#define MC_IO_TXCNTL_DPHY1_D0__TXBYPASS_DATA__SHIFT 0x1c
#define MC_IO_TXCNTL_APHY_D0__BIASSEL_MASK 0x3
#define MC_IO_TXCNTL_APHY_D0__BIASSEL__SHIFT 0x0
#define MC_IO_TXCNTL_APHY_D0__DRVDUTY_MASK 0xc
#define MC_IO_TXCNTL_APHY_D0__DRVDUTY__SHIFT 0x2
#define MC_IO_TXCNTL_APHY_D0__LOWCMEN_MASK 0x10
#define MC_IO_TXCNTL_APHY_D0__LOWCMEN__SHIFT 0x4
#define MC_IO_TXCNTL_APHY_D0__QDR_MASK 0x20
#define MC_IO_TXCNTL_APHY_D0__QDR__SHIFT 0x5
#define MC_IO_TXCNTL_APHY_D0__EMPH_MASK 0x40
#define MC_IO_TXCNTL_APHY_D0__EMPH__SHIFT 0x6
#define MC_IO_TXCNTL_APHY_D0__TXPD_MASK 0x80
#define MC_IO_TXCNTL_APHY_D0__TXPD__SHIFT 0x7
#define MC_IO_TXCNTL_APHY_D0__PTERM_MASK 0xf00
#define MC_IO_TXCNTL_APHY_D0__PTERM__SHIFT 0x8
#define MC_IO_TXCNTL_APHY_D0__TXBPASS_SEL_MASK 0x1000
#define MC_IO_TXCNTL_APHY_D0__TXBPASS_SEL__SHIFT 0xc
#define MC_IO_TXCNTL_APHY_D0__PMA_LOOPBACK_MASK 0xe000
#define MC_IO_TXCNTL_APHY_D0__PMA_LOOPBACK__SHIFT 0xd
#define MC_IO_TXCNTL_APHY_D0__PDRV_MASK 0xf0000
#define MC_IO_TXCNTL_APHY_D0__PDRV__SHIFT 0x10
#define MC_IO_TXCNTL_APHY_D0__NDRV_MASK 0x700000
#define MC_IO_TXCNTL_APHY_D0__NDRV__SHIFT 0x14
#define MC_IO_TXCNTL_APHY_D0__YCLKON_MASK 0x800000
#define MC_IO_TXCNTL_APHY_D0__YCLKON__SHIFT 0x17
#define MC_IO_TXCNTL_APHY_D0__TSTEN_MASK 0x1000000
#define MC_IO_TXCNTL_APHY_D0__TSTEN__SHIFT 0x18
#define MC_IO_TXCNTL_APHY_D0__TXRESET_MASK 0x2000000
#define MC_IO_TXCNTL_APHY_D0__TXRESET__SHIFT 0x19
#define MC_IO_TXCNTL_APHY_D0__TXBYPASS_MASK 0x4000000
#define MC_IO_TXCNTL_APHY_D0__TXBYPASS__SHIFT 0x1a
#define MC_IO_TXCNTL_APHY_D0__TXBYPASS_DATA_MASK 0x38000000
#define MC_IO_TXCNTL_APHY_D0__TXBYPASS_DATA__SHIFT 0x1b
#define MC_IO_TXCNTL_APHY_D0__CKE_BIT_MASK 0x40000000
#define MC_IO_TXCNTL_APHY_D0__CKE_BIT__SHIFT 0x1e
#define MC_IO_TXCNTL_APHY_D0__CKE_SEL_MASK 0x80000000
#define MC_IO_TXCNTL_APHY_D0__CKE_SEL__SHIFT 0x1f
#define MC_IO_RXCNTL_DPHY0_D0__RXBIASSEL_MASK 0x3
#define MC_IO_RXCNTL_DPHY0_D0__RXBIASSEL__SHIFT 0x0
#define MC_IO_RXCNTL_DPHY0_D0__RCVSEL_MASK 0x4
#define MC_IO_RXCNTL_DPHY0_D0__RCVSEL__SHIFT 0x2
#define MC_IO_RXCNTL_DPHY0_D0__VREFPDNB_MASK 0x8
#define MC_IO_RXCNTL_DPHY0_D0__VREFPDNB__SHIFT 0x3
#define MC_IO_RXCNTL_DPHY0_D0__RXDPWRON_DLY_MASK 0x30
#define MC_IO_RXCNTL_DPHY0_D0__RXDPWRON_DLY__SHIFT 0x4
#define MC_IO_RXCNTL_DPHY0_D0__RXPDNB_MASK 0x40
#define MC_IO_RXCNTL_DPHY0_D0__RXPDNB__SHIFT 0x6
#define MC_IO_RXCNTL_DPHY0_D0__RXLP_MASK 0x80
#define MC_IO_RXCNTL_DPHY0_D0__RXLP__SHIFT 0x7
#define MC_IO_RXCNTL_DPHY0_D0__VREFCAL_MASK 0xf00
#define MC_IO_RXCNTL_DPHY0_D0__VREFCAL__SHIFT 0x8
#define MC_IO_RXCNTL_DPHY0_D0__VREFCAL_STR_MASK 0xf000
#define MC_IO_RXCNTL_DPHY0_D0__VREFCAL_STR__SHIFT 0xc
#define MC_IO_RXCNTL_DPHY0_D0__VREFSEL_MASK 0x10000
#define MC_IO_RXCNTL_DPHY0_D0__VREFSEL__SHIFT 0x10
#define MC_IO_RXCNTL_DPHY0_D0__RX_PEAKSEL_MASK 0xc0000
#define MC_IO_RXCNTL_DPHY0_D0__RX_PEAKSEL__SHIFT 0x12
#define MC_IO_RXCNTL_DPHY0_D0__DLL_ADJ_B0_MASK 0x700000
#define MC_IO_RXCNTL_DPHY0_D0__DLL_ADJ_B0__SHIFT 0x14
#define MC_IO_RXCNTL_DPHY0_D0__DLL_ADJ_B1_MASK 0x7000000
#define MC_IO_RXCNTL_DPHY0_D0__DLL_ADJ_B1__SHIFT 0x18
#define MC_IO_RXCNTL_DPHY0_D0__DLL_ADJ_M_MASK 0x10000000
#define MC_IO_RXCNTL_DPHY0_D0__DLL_ADJ_M__SHIFT 0x1c
#define MC_IO_RXCNTL_DPHY0_D0__REFCLK_PWRON_MASK 0x20000000
#define MC_IO_RXCNTL_DPHY0_D0__REFCLK_PWRON__SHIFT 0x1d
#define MC_IO_RXCNTL_DPHY0_D0__DLL_BW_CTRL_MASK 0xc0000000
#define MC_IO_RXCNTL_DPHY0_D0__DLL_BW_CTRL__SHIFT 0x1e
#define MC_IO_RXCNTL1_DPHY0_D0__VREFCAL1_MSB_MASK 0xf
#define MC_IO_RXCNTL1_DPHY0_D0__VREFCAL1_MSB__SHIFT 0x0
#define MC_IO_RXCNTL1_DPHY0_D0__VREFCAL2_MSB_MASK 0xf0
#define MC_IO_RXCNTL1_DPHY0_D0__VREFCAL2_MSB__SHIFT 0x4
#define MC_IO_RXCNTL1_DPHY0_D0__VREFCAL3_MASK 0xff00
#define MC_IO_RXCNTL1_DPHY0_D0__VREFCAL3__SHIFT 0x8
#define MC_IO_RXCNTL1_DPHY0_D0__VREFSEL2_MASK 0x10000
#define MC_IO_RXCNTL1_DPHY0_D0__VREFSEL2__SHIFT 0x10
#define MC_IO_RXCNTL1_DPHY0_D0__VREFSEL3_MASK 0x20000
#define MC_IO_RXCNTL1_DPHY0_D0__VREFSEL3__SHIFT 0x11
#define MC_IO_RXCNTL1_DPHY0_D0__VREFPDNB_1_MASK 0x40000
#define MC_IO_RXCNTL1_DPHY0_D0__VREFPDNB_1__SHIFT 0x12
#define MC_IO_RXCNTL1_DPHY0_D0__DLL_PWRGOOD_OVR_MASK 0x80000
#define MC_IO_RXCNTL1_DPHY0_D0__DLL_PWRGOOD_OVR__SHIFT 0x13
#define MC_IO_RXCNTL1_DPHY0_D0__DLL_VCTRLADC_EN_MASK 0x100000
#define MC_IO_RXCNTL1_DPHY0_D0__DLL_VCTRLADC_EN__SHIFT 0x14
#define MC_IO_RXCNTL1_DPHY0_D0__DLL_MSTR_STBY_MASK 0x200000
#define MC_IO_RXCNTL1_DPHY0_D0__DLL_MSTR_STBY__SHIFT 0x15
#define MC_IO_RXCNTL1_DPHY0_D0__RXLEQ_EN_MASK 0x400000
#define MC_IO_RXCNTL1_DPHY0_D0__RXLEQ_EN__SHIFT 0x16
#define MC_IO_RXCNTL1_DPHY0_D0__RXLEQ_NXT_MASK 0x800000
#define MC_IO_RXCNTL1_DPHY0_D0__RXLEQ_NXT__SHIFT 0x17
#define MC_IO_RXCNTL1_DPHY0_D0__PMD_LOOPBACK_MASK 0xe000000
#define MC_IO_RXCNTL1_DPHY0_D0__PMD_LOOPBACK__SHIFT 0x19
#define MC_IO_RXCNTL1_DPHY0_D0__DLL_RSV_MASK 0xf0000000
#define MC_IO_RXCNTL1_DPHY0_D0__DLL_RSV__SHIFT 0x1c
#define MC_IO_RXCNTL_DPHY1_D0__RXBIASSEL_MASK 0x3
#define MC_IO_RXCNTL_DPHY1_D0__RXBIASSEL__SHIFT 0x0
#define MC_IO_RXCNTL_DPHY1_D0__RCVSEL_MASK 0x4
#define MC_IO_RXCNTL_DPHY1_D0__RCVSEL__SHIFT 0x2
#define MC_IO_RXCNTL_DPHY1_D0__VREFPDNB_MASK 0x8
#define MC_IO_RXCNTL_DPHY1_D0__VREFPDNB__SHIFT 0x3
#define MC_IO_RXCNTL_DPHY1_D0__RXDPWRON_DLY_MASK 0x30
#define MC_IO_RXCNTL_DPHY1_D0__RXDPWRON_DLY__SHIFT 0x4
#define MC_IO_RXCNTL_DPHY1_D0__RXPDNB_MASK 0x40
#define MC_IO_RXCNTL_DPHY1_D0__RXPDNB__SHIFT 0x6
#define MC_IO_RXCNTL_DPHY1_D0__RXLP_MASK 0x80
#define MC_IO_RXCNTL_DPHY1_D0__RXLP__SHIFT 0x7
#define MC_IO_RXCNTL_DPHY1_D0__VREFCAL_MASK 0xf00
#define MC_IO_RXCNTL_DPHY1_D0__VREFCAL__SHIFT 0x8
#define MC_IO_RXCNTL_DPHY1_D0__VREFCAL_STR_MASK 0xf000
#define MC_IO_RXCNTL_DPHY1_D0__VREFCAL_STR__SHIFT 0xc
#define MC_IO_RXCNTL_DPHY1_D0__VREFSEL_MASK 0x10000
#define MC_IO_RXCNTL_DPHY1_D0__VREFSEL__SHIFT 0x10
#define MC_IO_RXCNTL_DPHY1_D0__RX_PEAKSEL_MASK 0xc0000
#define MC_IO_RXCNTL_DPHY1_D0__RX_PEAKSEL__SHIFT 0x12
#define MC_IO_RXCNTL_DPHY1_D0__DLL_ADJ_B0_MASK 0x700000
#define MC_IO_RXCNTL_DPHY1_D0__DLL_ADJ_B0__SHIFT 0x14
#define MC_IO_RXCNTL_DPHY1_D0__DLL_ADJ_B1_MASK 0x7000000
#define MC_IO_RXCNTL_DPHY1_D0__DLL_ADJ_B1__SHIFT 0x18
#define MC_IO_RXCNTL_DPHY1_D0__DLL_ADJ_M_MASK 0x10000000
#define MC_IO_RXCNTL_DPHY1_D0__DLL_ADJ_M__SHIFT 0x1c
#define MC_IO_RXCNTL_DPHY1_D0__REFCLK_PWRON_MASK 0x20000000
#define MC_IO_RXCNTL_DPHY1_D0__REFCLK_PWRON__SHIFT 0x1d
#define MC_IO_RXCNTL_DPHY1_D0__DLL_BW_CTRL_MASK 0xc0000000
#define MC_IO_RXCNTL_DPHY1_D0__DLL_BW_CTRL__SHIFT 0x1e
#define MC_IO_RXCNTL1_DPHY1_D0__VREFCAL1_MSB_MASK 0xf
#define MC_IO_RXCNTL1_DPHY1_D0__VREFCAL1_MSB__SHIFT 0x0
#define MC_IO_RXCNTL1_DPHY1_D0__VREFCAL2_MSB_MASK 0xf0
#define MC_IO_RXCNTL1_DPHY1_D0__VREFCAL2_MSB__SHIFT 0x4
#define MC_IO_RXCNTL1_DPHY1_D0__VREFCAL3_MASK 0xff00
#define MC_IO_RXCNTL1_DPHY1_D0__VREFCAL3__SHIFT 0x8
#define MC_IO_RXCNTL1_DPHY1_D0__VREFSEL2_MASK 0x10000
#define MC_IO_RXCNTL1_DPHY1_D0__VREFSEL2__SHIFT 0x10
#define MC_IO_RXCNTL1_DPHY1_D0__VREFSEL3_MASK 0x20000
#define MC_IO_RXCNTL1_DPHY1_D0__VREFSEL3__SHIFT 0x11
#define MC_IO_RXCNTL1_DPHY1_D0__VREFPDNB_1_MASK 0x40000
#define MC_IO_RXCNTL1_DPHY1_D0__VREFPDNB_1__SHIFT 0x12
#define MC_IO_RXCNTL1_DPHY1_D0__DLL_PWRGOOD_OVR_MASK 0x80000
#define MC_IO_RXCNTL1_DPHY1_D0__DLL_PWRGOOD_OVR__SHIFT 0x13
#define MC_IO_RXCNTL1_DPHY1_D0__DLL_VCTRLADC_EN_MASK 0x100000
#define MC_IO_RXCNTL1_DPHY1_D0__DLL_VCTRLADC_EN__SHIFT 0x14
#define MC_IO_RXCNTL1_DPHY1_D0__DLL_MSTR_STBY_MASK 0x200000
#define MC_IO_RXCNTL1_DPHY1_D0__DLL_MSTR_STBY__SHIFT 0x15
#define MC_IO_RXCNTL1_DPHY1_D0__RXLEQ_EN_MASK 0x400000
#define MC_IO_RXCNTL1_DPHY1_D0__RXLEQ_EN__SHIFT 0x16
#define MC_IO_RXCNTL1_DPHY1_D0__RXLEQ_NXT_MASK 0x800000
#define MC_IO_RXCNTL1_DPHY1_D0__RXLEQ_NXT__SHIFT 0x17
#define MC_IO_RXCNTL1_DPHY1_D0__PMD_LOOPBACK_MASK 0xe000000
#define MC_IO_RXCNTL1_DPHY1_D0__PMD_LOOPBACK__SHIFT 0x19
#define MC_IO_RXCNTL1_DPHY1_D0__DLL_RSV_MASK 0xf0000000
#define MC_IO_RXCNTL1_DPHY1_D0__DLL_RSV__SHIFT 0x1c
#define MC_IO_DPHY_STR_CNTL_D0__PSTR_OFF_D_MASK 0x3f
#define MC_IO_DPHY_STR_CNTL_D0__PSTR_OFF_D__SHIFT 0x0
#define MC_IO_DPHY_STR_CNTL_D0__NSTR_OFF_D_MASK 0xfc0
#define MC_IO_DPHY_STR_CNTL_D0__NSTR_OFF_D__SHIFT 0x6
#define MC_IO_DPHY_STR_CNTL_D0__PSTR_OFF_S_MASK 0x3f000
#define MC_IO_DPHY_STR_CNTL_D0__PSTR_OFF_S__SHIFT 0xc
#define MC_IO_DPHY_STR_CNTL_D0__NSTR_OFF_S_MASK 0xfc0000
#define MC_IO_DPHY_STR_CNTL_D0__NSTR_OFF_S__SHIFT 0x12
#define MC_IO_DPHY_STR_CNTL_D0__USE_D_CAL_MASK 0x1000000
#define MC_IO_DPHY_STR_CNTL_D0__USE_D_CAL__SHIFT 0x18
#define MC_IO_DPHY_STR_CNTL_D0__USE_S_CAL_MASK 0x2000000
#define MC_IO_DPHY_STR_CNTL_D0__USE_S_CAL__SHIFT 0x19
#define MC_IO_DPHY_STR_CNTL_D0__CAL_SEL_MASK 0xc000000
#define MC_IO_DPHY_STR_CNTL_D0__CAL_SEL__SHIFT 0x1a
#define MC_IO_DPHY_STR_CNTL_D0__LOAD_D_STR_MASK 0x10000000
#define MC_IO_DPHY_STR_CNTL_D0__LOAD_D_STR__SHIFT 0x1c
#define MC_IO_DPHY_STR_CNTL_D0__LOAD_S_STR_MASK 0x20000000
#define MC_IO_DPHY_STR_CNTL_D0__LOAD_S_STR__SHIFT 0x1d
#define MC_IO_DPHY_STR_CNTL_D0__AUTO_LD_STR_MASK 0x40000000
#define MC_IO_DPHY_STR_CNTL_D0__AUTO_LD_STR__SHIFT 0x1e
#define MC_IO_APHY_STR_CNTL_D0__PSTR_OFF_A_MASK 0x3f
#define MC_IO_APHY_STR_CNTL_D0__PSTR_OFF_A__SHIFT 0x0
#define MC_IO_APHY_STR_CNTL_D0__NSTR_OFF_A_MASK 0xfc0
#define MC_IO_APHY_STR_CNTL_D0__NSTR_OFF_A__SHIFT 0x6
#define MC_IO_APHY_STR_CNTL_D0__PSTR_OFF_D_RD_MASK 0x3f000
#define MC_IO_APHY_STR_CNTL_D0__PSTR_OFF_D_RD__SHIFT 0xc
#define MC_IO_APHY_STR_CNTL_D0__USE_A_CAL_MASK 0x1000000
#define MC_IO_APHY_STR_CNTL_D0__USE_A_CAL__SHIFT 0x18
#define MC_IO_APHY_STR_CNTL_D0__USE_D_RD_CAL_MASK 0x2000000
#define MC_IO_APHY_STR_CNTL_D0__USE_D_RD_CAL__SHIFT 0x19
#define MC_IO_APHY_STR_CNTL_D0__CAL_SEL_MASK 0xc000000
#define MC_IO_APHY_STR_CNTL_D0__CAL_SEL__SHIFT 0x1a
#define MC_IO_APHY_STR_CNTL_D0__LOAD_A_STR_MASK 0x10000000
#define MC_IO_APHY_STR_CNTL_D0__LOAD_A_STR__SHIFT 0x1c
#define MC_IO_APHY_STR_CNTL_D0__LOAD_D_RD_STR_MASK 0x20000000
#define MC_IO_APHY_STR_CNTL_D0__LOAD_D_RD_STR__SHIFT 0x1d
#define MC_IO_TXCNTL_DPHY0_D1__BIASSEL_MASK 0x3
#define MC_IO_TXCNTL_DPHY0_D1__BIASSEL__SHIFT 0x0
#define MC_IO_TXCNTL_DPHY0_D1__DRVDUTY_MASK 0xc
#define MC_IO_TXCNTL_DPHY0_D1__DRVDUTY__SHIFT 0x2
#define MC_IO_TXCNTL_DPHY0_D1__LOWCMEN_MASK 0x10
#define MC_IO_TXCNTL_DPHY0_D1__LOWCMEN__SHIFT 0x4
#define MC_IO_TXCNTL_DPHY0_D1__QDR_MASK 0x20
#define MC_IO_TXCNTL_DPHY0_D1__QDR__SHIFT 0x5
#define MC_IO_TXCNTL_DPHY0_D1__EMPH_MASK 0x40
#define MC_IO_TXCNTL_DPHY0_D1__EMPH__SHIFT 0x6
#define MC_IO_TXCNTL_DPHY0_D1__TXPD_MASK 0x80
#define MC_IO_TXCNTL_DPHY0_D1__TXPD__SHIFT 0x7
#define MC_IO_TXCNTL_DPHY0_D1__PTERM_MASK 0xf00
#define MC_IO_TXCNTL_DPHY0_D1__PTERM__SHIFT 0x8
#define MC_IO_TXCNTL_DPHY0_D1__NTERM_MASK 0xf000
#define MC_IO_TXCNTL_DPHY0_D1__NTERM__SHIFT 0xc
#define MC_IO_TXCNTL_DPHY0_D1__PDRV_MASK 0xf0000
#define MC_IO_TXCNTL_DPHY0_D1__PDRV__SHIFT 0x10
#define MC_IO_TXCNTL_DPHY0_D1__NDRV_MASK 0xf00000
#define MC_IO_TXCNTL_DPHY0_D1__NDRV__SHIFT 0x14
#define MC_IO_TXCNTL_DPHY0_D1__TSTEN_MASK 0x1000000
#define MC_IO_TXCNTL_DPHY0_D1__TSTEN__SHIFT 0x18
#define MC_IO_TXCNTL_DPHY0_D1__EDCTX_CLKGATE_EN_MASK 0x2000000
#define MC_IO_TXCNTL_DPHY0_D1__EDCTX_CLKGATE_EN__SHIFT 0x19
#define MC_IO_TXCNTL_DPHY0_D1__TXBYPASS_MASK 0x4000000
#define MC_IO_TXCNTL_DPHY0_D1__TXBYPASS__SHIFT 0x1a
#define MC_IO_TXCNTL_DPHY0_D1__PLL_LOOPBCK_MASK 0x8000000
#define MC_IO_TXCNTL_DPHY0_D1__PLL_LOOPBCK__SHIFT 0x1b
#define MC_IO_TXCNTL_DPHY0_D1__TXBYPASS_DATA_MASK 0xf0000000
#define MC_IO_TXCNTL_DPHY0_D1__TXBYPASS_DATA__SHIFT 0x1c
#define MC_IO_TXCNTL_DPHY1_D1__BIASSEL_MASK 0x3
#define MC_IO_TXCNTL_DPHY1_D1__BIASSEL__SHIFT 0x0
#define MC_IO_TXCNTL_DPHY1_D1__DRVDUTY_MASK 0xc
#define MC_IO_TXCNTL_DPHY1_D1__DRVDUTY__SHIFT 0x2
#define MC_IO_TXCNTL_DPHY1_D1__LOWCMEN_MASK 0x10
#define MC_IO_TXCNTL_DPHY1_D1__LOWCMEN__SHIFT 0x4
#define MC_IO_TXCNTL_DPHY1_D1__QDR_MASK 0x20
#define MC_IO_TXCNTL_DPHY1_D1__QDR__SHIFT 0x5
#define MC_IO_TXCNTL_DPHY1_D1__EMPH_MASK 0x40
#define MC_IO_TXCNTL_DPHY1_D1__EMPH__SHIFT 0x6
#define MC_IO_TXCNTL_DPHY1_D1__TXPD_MASK 0x80
#define MC_IO_TXCNTL_DPHY1_D1__TXPD__SHIFT 0x7
#define MC_IO_TXCNTL_DPHY1_D1__PTERM_MASK 0xf00
#define MC_IO_TXCNTL_DPHY1_D1__PTERM__SHIFT 0x8
#define MC_IO_TXCNTL_DPHY1_D1__NTERM_MASK 0xf000
#define MC_IO_TXCNTL_DPHY1_D1__NTERM__SHIFT 0xc
#define MC_IO_TXCNTL_DPHY1_D1__PDRV_MASK 0xf0000
#define MC_IO_TXCNTL_DPHY1_D1__PDRV__SHIFT 0x10
#define MC_IO_TXCNTL_DPHY1_D1__NDRV_MASK 0xf00000
#define MC_IO_TXCNTL_DPHY1_D1__NDRV__SHIFT 0x14
#define MC_IO_TXCNTL_DPHY1_D1__TSTEN_MASK 0x1000000
#define MC_IO_TXCNTL_DPHY1_D1__TSTEN__SHIFT 0x18
#define MC_IO_TXCNTL_DPHY1_D1__EDCTX_CLKGATE_EN_MASK 0x2000000
#define MC_IO_TXCNTL_DPHY1_D1__EDCTX_CLKGATE_EN__SHIFT 0x19
#define MC_IO_TXCNTL_DPHY1_D1__TXBYPASS_MASK 0x4000000
#define MC_IO_TXCNTL_DPHY1_D1__TXBYPASS__SHIFT 0x1a
#define MC_IO_TXCNTL_DPHY1_D1__PLL_LOOPBCK_MASK 0x8000000
#define MC_IO_TXCNTL_DPHY1_D1__PLL_LOOPBCK__SHIFT 0x1b
#define MC_IO_TXCNTL_DPHY1_D1__TXBYPASS_DATA_MASK 0xf0000000
#define MC_IO_TXCNTL_DPHY1_D1__TXBYPASS_DATA__SHIFT 0x1c
#define MC_IO_TXCNTL_APHY_D1__BIASSEL_MASK 0x3
#define MC_IO_TXCNTL_APHY_D1__BIASSEL__SHIFT 0x0
#define MC_IO_TXCNTL_APHY_D1__DRVDUTY_MASK 0xc
#define MC_IO_TXCNTL_APHY_D1__DRVDUTY__SHIFT 0x2
#define MC_IO_TXCNTL_APHY_D1__LOWCMEN_MASK 0x10
#define MC_IO_TXCNTL_APHY_D1__LOWCMEN__SHIFT 0x4
#define MC_IO_TXCNTL_APHY_D1__QDR_MASK 0x20
#define MC_IO_TXCNTL_APHY_D1__QDR__SHIFT 0x5
#define MC_IO_TXCNTL_APHY_D1__EMPH_MASK 0x40
#define MC_IO_TXCNTL_APHY_D1__EMPH__SHIFT 0x6
#define MC_IO_TXCNTL_APHY_D1__TXPD_MASK 0x80
#define MC_IO_TXCNTL_APHY_D1__TXPD__SHIFT 0x7
#define MC_IO_TXCNTL_APHY_D1__PTERM_MASK 0xf00
#define MC_IO_TXCNTL_APHY_D1__PTERM__SHIFT 0x8
#define MC_IO_TXCNTL_APHY_D1__TXBPASS_SEL_MASK 0x1000
#define MC_IO_TXCNTL_APHY_D1__TXBPASS_SEL__SHIFT 0xc
#define MC_IO_TXCNTL_APHY_D1__PMA_LOOPBACK_MASK 0xe000
#define MC_IO_TXCNTL_APHY_D1__PMA_LOOPBACK__SHIFT 0xd
#define MC_IO_TXCNTL_APHY_D1__PDRV_MASK 0xf0000
#define MC_IO_TXCNTL_APHY_D1__PDRV__SHIFT 0x10
#define MC_IO_TXCNTL_APHY_D1__NDRV_MASK 0x700000
#define MC_IO_TXCNTL_APHY_D1__NDRV__SHIFT 0x14
#define MC_IO_TXCNTL_APHY_D1__YCLKON_MASK 0x800000
#define MC_IO_TXCNTL_APHY_D1__YCLKON__SHIFT 0x17
#define MC_IO_TXCNTL_APHY_D1__TSTEN_MASK 0x1000000
#define MC_IO_TXCNTL_APHY_D1__TSTEN__SHIFT 0x18
#define MC_IO_TXCNTL_APHY_D1__TXRESET_MASK 0x2000000
#define MC_IO_TXCNTL_APHY_D1__TXRESET__SHIFT 0x19
#define MC_IO_TXCNTL_APHY_D1__TXBYPASS_MASK 0x4000000
#define MC_IO_TXCNTL_APHY_D1__TXBYPASS__SHIFT 0x1a
#define MC_IO_TXCNTL_APHY_D1__TXBYPASS_DATA_MASK 0x38000000
#define MC_IO_TXCNTL_APHY_D1__TXBYPASS_DATA__SHIFT 0x1b
#define MC_IO_TXCNTL_APHY_D1__CKE_BIT_MASK 0x40000000
#define MC_IO_TXCNTL_APHY_D1__CKE_BIT__SHIFT 0x1e
#define MC_IO_TXCNTL_APHY_D1__CKE_SEL_MASK 0x80000000
#define MC_IO_TXCNTL_APHY_D1__CKE_SEL__SHIFT 0x1f
#define MC_IO_RXCNTL_DPHY0_D1__RXBIASSEL_MASK 0x3
#define MC_IO_RXCNTL_DPHY0_D1__RXBIASSEL__SHIFT 0x0
#define MC_IO_RXCNTL_DPHY0_D1__RCVSEL_MASK 0x4
#define MC_IO_RXCNTL_DPHY0_D1__RCVSEL__SHIFT 0x2
#define MC_IO_RXCNTL_DPHY0_D1__VREFPDNB_MASK 0x8
#define MC_IO_RXCNTL_DPHY0_D1__VREFPDNB__SHIFT 0x3
#define MC_IO_RXCNTL_DPHY0_D1__RXDPWRON_DLY_MASK 0x30
#define MC_IO_RXCNTL_DPHY0_D1__RXDPWRON_DLY__SHIFT 0x4
#define MC_IO_RXCNTL_DPHY0_D1__RXPDNB_MASK 0x40
#define MC_IO_RXCNTL_DPHY0_D1__RXPDNB__SHIFT 0x6
#define MC_IO_RXCNTL_DPHY0_D1__RXLP_MASK 0x80
#define MC_IO_RXCNTL_DPHY0_D1__RXLP__SHIFT 0x7
#define MC_IO_RXCNTL_DPHY0_D1__VREFCAL_MASK 0xf00
#define MC_IO_RXCNTL_DPHY0_D1__VREFCAL__SHIFT 0x8
#define MC_IO_RXCNTL_DPHY0_D1__VREFCAL_STR_MASK 0xf000
#define MC_IO_RXCNTL_DPHY0_D1__VREFCAL_STR__SHIFT 0xc
#define MC_IO_RXCNTL_DPHY0_D1__VREFSEL_MASK 0x10000
#define MC_IO_RXCNTL_DPHY0_D1__VREFSEL__SHIFT 0x10
#define MC_IO_RXCNTL_DPHY0_D1__RX_PEAKSEL_MASK 0xc0000
#define MC_IO_RXCNTL_DPHY0_D1__RX_PEAKSEL__SHIFT 0x12
#define MC_IO_RXCNTL_DPHY0_D1__DLL_ADJ_B0_MASK 0x700000
#define MC_IO_RXCNTL_DPHY0_D1__DLL_ADJ_B0__SHIFT 0x14
#define MC_IO_RXCNTL_DPHY0_D1__DLL_ADJ_B1_MASK 0x7000000
#define MC_IO_RXCNTL_DPHY0_D1__DLL_ADJ_B1__SHIFT 0x18
#define MC_IO_RXCNTL_DPHY0_D1__DLL_ADJ_M_MASK 0x10000000
#define MC_IO_RXCNTL_DPHY0_D1__DLL_ADJ_M__SHIFT 0x1c
#define MC_IO_RXCNTL_DPHY0_D1__REFCLK_PWRON_MASK 0x20000000
#define MC_IO_RXCNTL_DPHY0_D1__REFCLK_PWRON__SHIFT 0x1d
#define MC_IO_RXCNTL_DPHY0_D1__DLL_BW_CTRL_MASK 0xc0000000
#define MC_IO_RXCNTL_DPHY0_D1__DLL_BW_CTRL__SHIFT 0x1e
#define MC_IO_RXCNTL1_DPHY0_D1__VREFCAL1_MSB_MASK 0xf
#define MC_IO_RXCNTL1_DPHY0_D1__VREFCAL1_MSB__SHIFT 0x0
#define MC_IO_RXCNTL1_DPHY0_D1__VREFCAL2_MSB_MASK 0xf0
#define MC_IO_RXCNTL1_DPHY0_D1__VREFCAL2_MSB__SHIFT 0x4
#define MC_IO_RXCNTL1_DPHY0_D1__VREFCAL3_MASK 0xff00
#define MC_IO_RXCNTL1_DPHY0_D1__VREFCAL3__SHIFT 0x8
#define MC_IO_RXCNTL1_DPHY0_D1__VREFSEL2_MASK 0x10000
#define MC_IO_RXCNTL1_DPHY0_D1__VREFSEL2__SHIFT 0x10
#define MC_IO_RXCNTL1_DPHY0_D1__VREFSEL3_MASK 0x20000
#define MC_IO_RXCNTL1_DPHY0_D1__VREFSEL3__SHIFT 0x11
#define MC_IO_RXCNTL1_DPHY0_D1__VREFPDNB_1_MASK 0x40000
#define MC_IO_RXCNTL1_DPHY0_D1__VREFPDNB_1__SHIFT 0x12
#define MC_IO_RXCNTL1_DPHY0_D1__DLL_PWRGOOD_OVR_MASK 0x80000
#define MC_IO_RXCNTL1_DPHY0_D1__DLL_PWRGOOD_OVR__SHIFT 0x13
#define MC_IO_RXCNTL1_DPHY0_D1__DLL_VCTRLADC_EN_MASK 0x100000
#define MC_IO_RXCNTL1_DPHY0_D1__DLL_VCTRLADC_EN__SHIFT 0x14
#define MC_IO_RXCNTL1_DPHY0_D1__DLL_MSTR_STBY_MASK 0x200000
#define MC_IO_RXCNTL1_DPHY0_D1__DLL_MSTR_STBY__SHIFT 0x15
#define MC_IO_RXCNTL1_DPHY0_D1__RXLEQ_EN_MASK 0x400000
#define MC_IO_RXCNTL1_DPHY0_D1__RXLEQ_EN__SHIFT 0x16
#define MC_IO_RXCNTL1_DPHY0_D1__RXLEQ_NXT_MASK 0x800000
#define MC_IO_RXCNTL1_DPHY0_D1__RXLEQ_NXT__SHIFT 0x17
#define MC_IO_RXCNTL1_DPHY0_D1__PMD_LOOPBACK_MASK 0xe000000
#define MC_IO_RXCNTL1_DPHY0_D1__PMD_LOOPBACK__SHIFT 0x19
#define MC_IO_RXCNTL1_DPHY0_D1__DLL_RSV_MASK 0xf0000000
#define MC_IO_RXCNTL1_DPHY0_D1__DLL_RSV__SHIFT 0x1c
#define MC_IO_RXCNTL_DPHY1_D1__RXBIASSEL_MASK 0x3
#define MC_IO_RXCNTL_DPHY1_D1__RXBIASSEL__SHIFT 0x0
#define MC_IO_RXCNTL_DPHY1_D1__RCVSEL_MASK 0x4
#define MC_IO_RXCNTL_DPHY1_D1__RCVSEL__SHIFT 0x2
#define MC_IO_RXCNTL_DPHY1_D1__VREFPDNB_MASK 0x8
#define MC_IO_RXCNTL_DPHY1_D1__VREFPDNB__SHIFT 0x3
#define MC_IO_RXCNTL_DPHY1_D1__RXDPWRON_DLY_MASK 0x30
#define MC_IO_RXCNTL_DPHY1_D1__RXDPWRON_DLY__SHIFT 0x4
#define MC_IO_RXCNTL_DPHY1_D1__RXPDNB_MASK 0x40
#define MC_IO_RXCNTL_DPHY1_D1__RXPDNB__SHIFT 0x6
#define MC_IO_RXCNTL_DPHY1_D1__RXLP_MASK 0x80
#define MC_IO_RXCNTL_DPHY1_D1__RXLP__SHIFT 0x7
#define MC_IO_RXCNTL_DPHY1_D1__VREFCAL_MASK 0xf00
#define MC_IO_RXCNTL_DPHY1_D1__VREFCAL__SHIFT 0x8
#define MC_IO_RXCNTL_DPHY1_D1__VREFCAL_STR_MASK 0xf000
#define MC_IO_RXCNTL_DPHY1_D1__VREFCAL_STR__SHIFT 0xc
#define MC_IO_RXCNTL_DPHY1_D1__VREFSEL_MASK 0x10000
#define MC_IO_RXCNTL_DPHY1_D1__VREFSEL__SHIFT 0x10
#define MC_IO_RXCNTL_DPHY1_D1__RX_PEAKSEL_MASK 0xc0000
#define MC_IO_RXCNTL_DPHY1_D1__RX_PEAKSEL__SHIFT 0x12
#define MC_IO_RXCNTL_DPHY1_D1__DLL_ADJ_B0_MASK 0x700000
#define MC_IO_RXCNTL_DPHY1_D1__DLL_ADJ_B0__SHIFT 0x14
#define MC_IO_RXCNTL_DPHY1_D1__DLL_ADJ_B1_MASK 0x7000000
#define MC_IO_RXCNTL_DPHY1_D1__DLL_ADJ_B1__SHIFT 0x18
#define MC_IO_RXCNTL_DPHY1_D1__DLL_ADJ_M_MASK 0x10000000
#define MC_IO_RXCNTL_DPHY1_D1__DLL_ADJ_M__SHIFT 0x1c
#define MC_IO_RXCNTL_DPHY1_D1__REFCLK_PWRON_MASK 0x20000000
#define MC_IO_RXCNTL_DPHY1_D1__REFCLK_PWRON__SHIFT 0x1d
#define MC_IO_RXCNTL_DPHY1_D1__DLL_BW_CTRL_MASK 0xc0000000
#define MC_IO_RXCNTL_DPHY1_D1__DLL_BW_CTRL__SHIFT 0x1e
#define MC_IO_RXCNTL1_DPHY1_D1__VREFCAL1_MSB_MASK 0xf
#define MC_IO_RXCNTL1_DPHY1_D1__VREFCAL1_MSB__SHIFT 0x0
#define MC_IO_RXCNTL1_DPHY1_D1__VREFCAL2_MSB_MASK 0xf0
#define MC_IO_RXCNTL1_DPHY1_D1__VREFCAL2_MSB__SHIFT 0x4
#define MC_IO_RXCNTL1_DPHY1_D1__VREFCAL3_MASK 0xff00
#define MC_IO_RXCNTL1_DPHY1_D1__VREFCAL3__SHIFT 0x8
#define MC_IO_RXCNTL1_DPHY1_D1__VREFSEL2_MASK 0x10000
#define MC_IO_RXCNTL1_DPHY1_D1__VREFSEL2__SHIFT 0x10
#define MC_IO_RXCNTL1_DPHY1_D1__VREFSEL3_MASK 0x20000
#define MC_IO_RXCNTL1_DPHY1_D1__VREFSEL3__SHIFT 0x11
#define MC_IO_RXCNTL1_DPHY1_D1__VREFPDNB_1_MASK 0x40000
#define MC_IO_RXCNTL1_DPHY1_D1__VREFPDNB_1__SHIFT 0x12
#define MC_IO_RXCNTL1_DPHY1_D1__DLL_PWRGOOD_OVR_MASK 0x80000
#define MC_IO_RXCNTL1_DPHY1_D1__DLL_PWRGOOD_OVR__SHIFT 0x13
#define MC_IO_RXCNTL1_DPHY1_D1__DLL_VCTRLADC_EN_MASK 0x100000
#define MC_IO_RXCNTL1_DPHY1_D1__DLL_VCTRLADC_EN__SHIFT 0x14
#define MC_IO_RXCNTL1_DPHY1_D1__DLL_MSTR_STBY_MASK 0x200000
#define MC_IO_RXCNTL1_DPHY1_D1__DLL_MSTR_STBY__SHIFT 0x15
#define MC_IO_RXCNTL1_DPHY1_D1__RXLEQ_EN_MASK 0x400000
#define MC_IO_RXCNTL1_DPHY1_D1__RXLEQ_EN__SHIFT 0x16
#define MC_IO_RXCNTL1_DPHY1_D1__RXLEQ_NXT_MASK 0x800000
#define MC_IO_RXCNTL1_DPHY1_D1__RXLEQ_NXT__SHIFT 0x17
#define MC_IO_RXCNTL1_DPHY1_D1__PMD_LOOPBACK_MASK 0xe000000
#define MC_IO_RXCNTL1_DPHY1_D1__PMD_LOOPBACK__SHIFT 0x19
#define MC_IO_RXCNTL1_DPHY1_D1__DLL_RSV_MASK 0xf0000000
#define MC_IO_RXCNTL1_DPHY1_D1__DLL_RSV__SHIFT 0x1c
#define MC_IO_DPHY_STR_CNTL_D1__PSTR_OFF_D_MASK 0x3f
#define MC_IO_DPHY_STR_CNTL_D1__PSTR_OFF_D__SHIFT 0x0
#define MC_IO_DPHY_STR_CNTL_D1__NSTR_OFF_D_MASK 0xfc0
#define MC_IO_DPHY_STR_CNTL_D1__NSTR_OFF_D__SHIFT 0x6
#define MC_IO_DPHY_STR_CNTL_D1__PSTR_OFF_S_MASK 0x3f000
#define MC_IO_DPHY_STR_CNTL_D1__PSTR_OFF_S__SHIFT 0xc
#define MC_IO_DPHY_STR_CNTL_D1__NSTR_OFF_S_MASK 0xfc0000
#define MC_IO_DPHY_STR_CNTL_D1__NSTR_OFF_S__SHIFT 0x12
#define MC_IO_DPHY_STR_CNTL_D1__USE_D_CAL_MASK 0x1000000
#define MC_IO_DPHY_STR_CNTL_D1__USE_D_CAL__SHIFT 0x18
#define MC_IO_DPHY_STR_CNTL_D1__USE_S_CAL_MASK 0x2000000
#define MC_IO_DPHY_STR_CNTL_D1__USE_S_CAL__SHIFT 0x19
#define MC_IO_DPHY_STR_CNTL_D1__CAL_SEL_MASK 0xc000000
#define MC_IO_DPHY_STR_CNTL_D1__CAL_SEL__SHIFT 0x1a
#define MC_IO_DPHY_STR_CNTL_D1__LOAD_D_STR_MASK 0x10000000
#define MC_IO_DPHY_STR_CNTL_D1__LOAD_D_STR__SHIFT 0x1c
#define MC_IO_DPHY_STR_CNTL_D1__LOAD_S_STR_MASK 0x20000000
#define MC_IO_DPHY_STR_CNTL_D1__LOAD_S_STR__SHIFT 0x1d
#define MC_IO_DPHY_STR_CNTL_D1__AUTO_LD_STR_MASK 0x40000000
#define MC_IO_DPHY_STR_CNTL_D1__AUTO_LD_STR__SHIFT 0x1e
#define MC_IO_APHY_STR_CNTL_D1__PSTR_OFF_A_MASK 0x3f
#define MC_IO_APHY_STR_CNTL_D1__PSTR_OFF_A__SHIFT 0x0
#define MC_IO_APHY_STR_CNTL_D1__NSTR_OFF_A_MASK 0xfc0
#define MC_IO_APHY_STR_CNTL_D1__NSTR_OFF_A__SHIFT 0x6
#define MC_IO_APHY_STR_CNTL_D1__PSTR_OFF_D_RD_MASK 0x3f000
#define MC_IO_APHY_STR_CNTL_D1__PSTR_OFF_D_RD__SHIFT 0xc
#define MC_IO_APHY_STR_CNTL_D1__USE_A_CAL_MASK 0x1000000
#define MC_IO_APHY_STR_CNTL_D1__USE_A_CAL__SHIFT 0x18
#define MC_IO_APHY_STR_CNTL_D1__USE_D_RD_CAL_MASK 0x2000000
#define MC_IO_APHY_STR_CNTL_D1__USE_D_RD_CAL__SHIFT 0x19
#define MC_IO_APHY_STR_CNTL_D1__CAL_SEL_MASK 0xc000000
#define MC_IO_APHY_STR_CNTL_D1__CAL_SEL__SHIFT 0x1a
#define MC_IO_APHY_STR_CNTL_D1__LOAD_A_STR_MASK 0x10000000
#define MC_IO_APHY_STR_CNTL_D1__LOAD_A_STR__SHIFT 0x1c
#define MC_IO_APHY_STR_CNTL_D1__LOAD_D_RD_STR_MASK 0x20000000
#define MC_IO_APHY_STR_CNTL_D1__LOAD_D_RD_STR__SHIFT 0x1d
#define MC_IO_CDRCNTL_D0__RXPHASE_B01_MASK 0xf
#define MC_IO_CDRCNTL_D0__RXPHASE_B01__SHIFT 0x0
#define MC_IO_CDRCNTL_D0__RXPHASE_B23_MASK 0xf0
#define MC_IO_CDRCNTL_D0__RXPHASE_B23__SHIFT 0x4
#define MC_IO_CDRCNTL_D0__RXCDREN_B01_MASK 0x100
#define MC_IO_CDRCNTL_D0__RXCDREN_B01__SHIFT 0x8
#define MC_IO_CDRCNTL_D0__RXCDREN_B23_MASK 0x200
#define MC_IO_CDRCNTL_D0__RXCDREN_B23__SHIFT 0x9
#define MC_IO_CDRCNTL_D0__RXCDRBYPASS_B01_MASK 0x400
#define MC_IO_CDRCNTL_D0__RXCDRBYPASS_B01__SHIFT 0xa
#define MC_IO_CDRCNTL_D0__RXCDRBYPASS_B23_MASK 0x800
#define MC_IO_CDRCNTL_D0__RXCDRBYPASS_B23__SHIFT 0xb
#define MC_IO_CDRCNTL_D0__RXPHASE1_B01_MASK 0xf000
#define MC_IO_CDRCNTL_D0__RXPHASE1_B01__SHIFT 0xc
#define MC_IO_CDRCNTL_D0__RXPHASE1_B23_MASK 0xf0000
#define MC_IO_CDRCNTL_D0__RXPHASE1_B23__SHIFT 0x10
#define MC_IO_CDRCNTL_D0__DQTXCDREN_B0_MASK 0x100000
#define MC_IO_CDRCNTL_D0__DQTXCDREN_B0__SHIFT 0x14
#define MC_IO_CDRCNTL_D0__DQTXCDREN_B1_MASK 0x200000
#define MC_IO_CDRCNTL_D0__DQTXCDREN_B1__SHIFT 0x15
#define MC_IO_CDRCNTL_D0__DQRXCDREN_B0_MASK 0x400000
#define MC_IO_CDRCNTL_D0__DQRXCDREN_B0__SHIFT 0x16
#define MC_IO_CDRCNTL_D0__DQRXCDREN_B1_MASK 0x800000
#define MC_IO_CDRCNTL_D0__DQRXCDREN_B1__SHIFT 0x17
#define MC_IO_CDRCNTL_D0__WCDRRXCDREN_B0_MASK 0x1000000
#define MC_IO_CDRCNTL_D0__WCDRRXCDREN_B0__SHIFT 0x18
#define MC_IO_CDRCNTL_D0__WCDRRXCDREN_B1_MASK 0x2000000
#define MC_IO_CDRCNTL_D0__WCDRRXCDREN_B1__SHIFT 0x19
#define MC_IO_CDRCNTL_D0__WCDREDC_B0_MASK 0x4000000
#define MC_IO_CDRCNTL_D0__WCDREDC_B0__SHIFT 0x1a
#define MC_IO_CDRCNTL_D0__WCDREDC_B1_MASK 0x8000000
#define MC_IO_CDRCNTL_D0__WCDREDC_B1__SHIFT 0x1b
#define MC_IO_CDRCNTL_D0__DQRXSEL_B0_MASK 0x10000000
#define MC_IO_CDRCNTL_D0__DQRXSEL_B0__SHIFT 0x1c
#define MC_IO_CDRCNTL_D0__DQRXSEL_B1_MASK 0x20000000
#define MC_IO_CDRCNTL_D0__DQRXSEL_B1__SHIFT 0x1d
#define MC_IO_CDRCNTL_D0__DQTXSEL_B0_MASK 0x40000000
#define MC_IO_CDRCNTL_D0__DQTXSEL_B0__SHIFT 0x1e
#define MC_IO_CDRCNTL_D0__DQTXSEL_B1_MASK 0x80000000
#define MC_IO_CDRCNTL_D0__DQTXSEL_B1__SHIFT 0x1f
#define MC_IO_CDRCNTL1_D0__DQ_RXPHASE_B0_MASK 0xff
#define MC_IO_CDRCNTL1_D0__DQ_RXPHASE_B0__SHIFT 0x0
#define MC_IO_CDRCNTL1_D0__DQ_RXPHASE_B1_MASK 0xff00
#define MC_IO_CDRCNTL1_D0__DQ_RXPHASE_B1__SHIFT 0x8
#define MC_IO_CDRCNTL1_D0__WCDR_TXPHASE_B0_MASK 0xff0000
#define MC_IO_CDRCNTL1_D0__WCDR_TXPHASE_B0__SHIFT 0x10
#define MC_IO_CDRCNTL1_D0__WCDR_TXPHASE_B1_MASK 0xff000000
#define MC_IO_CDRCNTL1_D0__WCDR_TXPHASE_B1__SHIFT 0x18
#define MC_IO_CDRCNTL2_D0__CDR_FB_SEL0_MASK 0x1
#define MC_IO_CDRCNTL2_D0__CDR_FB_SEL0__SHIFT 0x0
#define MC_IO_CDRCNTL2_D0__CDR_FB_SEL1_MASK 0x2
#define MC_IO_CDRCNTL2_D0__CDR_FB_SEL1__SHIFT 0x1
#define MC_IO_CDRCNTL2_D0__EDC_RXEN_OVR0_MASK 0x4
#define MC_IO_CDRCNTL2_D0__EDC_RXEN_OVR0__SHIFT 0x2
#define MC_IO_CDRCNTL2_D0__EDC_RXEN_OVR1_MASK 0x8
#define MC_IO_CDRCNTL2_D0__EDC_RXEN_OVR1__SHIFT 0x3
#define MC_IO_CDRCNTL2_D0__TXCDRBYPASS0_MASK 0x10
#define MC_IO_CDRCNTL2_D0__TXCDRBYPASS0__SHIFT 0x4
#define MC_IO_CDRCNTL2_D0__TXCDRBYPASS1_MASK 0x20
#define MC_IO_CDRCNTL2_D0__TXCDRBYPASS1__SHIFT 0x5
#define MC_IO_CDRCNTL2_D0__WCK_RXEN_OVR0_MASK 0x40
#define MC_IO_CDRCNTL2_D0__WCK_RXEN_OVR0__SHIFT 0x6
#define MC_IO_CDRCNTL2_D0__WCK_RXEN_OVR1_MASK 0x80
#define MC_IO_CDRCNTL2_D0__WCK_RXEN_OVR1__SHIFT 0x7
#define MC_IO_CDRCNTL2_D0__WCDRTXPWRON_MASK 0xf00
#define MC_IO_CDRCNTL2_D0__WCDRTXPWRON__SHIFT 0x8
#define MC_IO_CDRCNTL2_D0__WCDRTXSEL_MASK 0xf000
#define MC_IO_CDRCNTL2_D0__WCDRTXSEL__SHIFT 0xc
#define MC_IO_CDRCNTL2_D0__WCDRTRACK01_MASK 0xf0000
#define MC_IO_CDRCNTL2_D0__WCDRTRACK01__SHIFT 0x10
#define MC_IO_CDRCNTL_D1__RXPHASE_B01_MASK 0xf
#define MC_IO_CDRCNTL_D1__RXPHASE_B01__SHIFT 0x0
#define MC_IO_CDRCNTL_D1__RXPHASE_B23_MASK 0xf0
#define MC_IO_CDRCNTL_D1__RXPHASE_B23__SHIFT 0x4
#define MC_IO_CDRCNTL_D1__RXCDREN_B01_MASK 0x100
#define MC_IO_CDRCNTL_D1__RXCDREN_B01__SHIFT 0x8
#define MC_IO_CDRCNTL_D1__RXCDREN_B23_MASK 0x200
#define MC_IO_CDRCNTL_D1__RXCDREN_B23__SHIFT 0x9
#define MC_IO_CDRCNTL_D1__RXCDRBYPASS_B01_MASK 0x400
#define MC_IO_CDRCNTL_D1__RXCDRBYPASS_B01__SHIFT 0xa
#define MC_IO_CDRCNTL_D1__RXCDRBYPASS_B23_MASK 0x800
#define MC_IO_CDRCNTL_D1__RXCDRBYPASS_B23__SHIFT 0xb
#define MC_IO_CDRCNTL_D1__RXPHASE1_B01_MASK 0xf000
#define MC_IO_CDRCNTL_D1__RXPHASE1_B01__SHIFT 0xc
#define MC_IO_CDRCNTL_D1__RXPHASE1_B23_MASK 0xf0000
#define MC_IO_CDRCNTL_D1__RXPHASE1_B23__SHIFT 0x10
#define MC_IO_CDRCNTL_D1__DQTXCDREN_B0_MASK 0x100000
#define MC_IO_CDRCNTL_D1__DQTXCDREN_B0__SHIFT 0x14
#define MC_IO_CDRCNTL_D1__DQTXCDREN_B1_MASK 0x200000
#define MC_IO_CDRCNTL_D1__DQTXCDREN_B1__SHIFT 0x15
#define MC_IO_CDRCNTL_D1__DQRXCDREN_B0_MASK 0x400000
#define MC_IO_CDRCNTL_D1__DQRXCDREN_B0__SHIFT 0x16
#define MC_IO_CDRCNTL_D1__DQRXCDREN_B1_MASK 0x800000
#define MC_IO_CDRCNTL_D1__DQRXCDREN_B1__SHIFT 0x17
#define MC_IO_CDRCNTL_D1__WCDRRXCDREN_B0_MASK 0x1000000
#define MC_IO_CDRCNTL_D1__WCDRRXCDREN_B0__SHIFT 0x18
#define MC_IO_CDRCNTL_D1__WCDRRXCDREN_B1_MASK 0x2000000
#define MC_IO_CDRCNTL_D1__WCDRRXCDREN_B1__SHIFT 0x19
#define MC_IO_CDRCNTL_D1__WCDREDC_B0_MASK 0x4000000
#define MC_IO_CDRCNTL_D1__WCDREDC_B0__SHIFT 0x1a
#define MC_IO_CDRCNTL_D1__WCDREDC_B1_MASK 0x8000000
#define MC_IO_CDRCNTL_D1__WCDREDC_B1__SHIFT 0x1b
#define MC_IO_CDRCNTL_D1__DQRXSEL_B0_MASK 0x10000000
#define MC_IO_CDRCNTL_D1__DQRXSEL_B0__SHIFT 0x1c
#define MC_IO_CDRCNTL_D1__DQRXSEL_B1_MASK 0x20000000
#define MC_IO_CDRCNTL_D1__DQRXSEL_B1__SHIFT 0x1d
#define MC_IO_CDRCNTL_D1__DQTXSEL_B0_MASK 0x40000000
#define MC_IO_CDRCNTL_D1__DQTXSEL_B0__SHIFT 0x1e
#define MC_IO_CDRCNTL_D1__DQTXSEL_B1_MASK 0x80000000
#define MC_IO_CDRCNTL_D1__DQTXSEL_B1__SHIFT 0x1f
#define MC_IO_CDRCNTL1_D1__DQ_RXPHASE_B0_MASK 0xff
#define MC_IO_CDRCNTL1_D1__DQ_RXPHASE_B0__SHIFT 0x0
#define MC_IO_CDRCNTL1_D1__DQ_RXPHASE_B1_MASK 0xff00
#define MC_IO_CDRCNTL1_D1__DQ_RXPHASE_B1__SHIFT 0x8
#define MC_IO_CDRCNTL1_D1__WCDR_TXPHASE_B0_MASK 0xff0000
#define MC_IO_CDRCNTL1_D1__WCDR_TXPHASE_B0__SHIFT 0x10
#define MC_IO_CDRCNTL1_D1__WCDR_TXPHASE_B1_MASK 0xff000000
#define MC_IO_CDRCNTL1_D1__WCDR_TXPHASE_B1__SHIFT 0x18
#define MC_IO_CDRCNTL2_D1__CDR_FB_SEL0_MASK 0x1
#define MC_IO_CDRCNTL2_D1__CDR_FB_SEL0__SHIFT 0x0
#define MC_IO_CDRCNTL2_D1__CDR_FB_SEL1_MASK 0x2
#define MC_IO_CDRCNTL2_D1__CDR_FB_SEL1__SHIFT 0x1
#define MC_IO_CDRCNTL2_D1__EDC_RXEN_OVR0_MASK 0x4
#define MC_IO_CDRCNTL2_D1__EDC_RXEN_OVR0__SHIFT 0x2
#define MC_IO_CDRCNTL2_D1__EDC_RXEN_OVR1_MASK 0x8
#define MC_IO_CDRCNTL2_D1__EDC_RXEN_OVR1__SHIFT 0x3
#define MC_IO_CDRCNTL2_D1__TXCDRBYPASS0_MASK 0x10
#define MC_IO_CDRCNTL2_D1__TXCDRBYPASS0__SHIFT 0x4
#define MC_IO_CDRCNTL2_D1__TXCDRBYPASS1_MASK 0x20
#define MC_IO_CDRCNTL2_D1__TXCDRBYPASS1__SHIFT 0x5
#define MC_IO_CDRCNTL2_D1__WCK_RXEN_OVR0_MASK 0x40
#define MC_IO_CDRCNTL2_D1__WCK_RXEN_OVR0__SHIFT 0x6
#define MC_IO_CDRCNTL2_D1__WCK_RXEN_OVR1_MASK 0x80
#define MC_IO_CDRCNTL2_D1__WCK_RXEN_OVR1__SHIFT 0x7
#define MC_IO_CDRCNTL2_D1__WCDRTXPWRON_MASK 0xf00
#define MC_IO_CDRCNTL2_D1__WCDRTXPWRON__SHIFT 0x8
#define MC_IO_CDRCNTL2_D1__WCDRTXSEL_MASK 0xf000
#define MC_IO_CDRCNTL2_D1__WCDRTXSEL__SHIFT 0xc
#define MC_IO_CDRCNTL2_D1__WCDRTRACK01_MASK 0xf0000
#define MC_IO_CDRCNTL2_D1__WCDRTRACK01__SHIFT 0x10
#define MC_SEQ_FIFO_CTL__W_LD_INIT_D0_MASK 0x3
#define MC_SEQ_FIFO_CTL__W_LD_INIT_D0__SHIFT 0x0
#define MC_SEQ_FIFO_CTL__W_SYC_SEL_MASK 0xc
#define MC_SEQ_FIFO_CTL__W_SYC_SEL__SHIFT 0x2
#define MC_SEQ_FIFO_CTL__R_LD_INIT_MASK 0x30
#define MC_SEQ_FIFO_CTL__R_LD_INIT__SHIFT 0x4
#define MC_SEQ_FIFO_CTL__R_SYC_SEL_MASK 0xc0
#define MC_SEQ_FIFO_CTL__R_SYC_SEL__SHIFT 0x6
#define MC_SEQ_FIFO_CTL__CG_DIS_D0_MASK 0x100
#define MC_SEQ_FIFO_CTL__CG_DIS_D0__SHIFT 0x8
#define MC_SEQ_FIFO_CTL__CG_DIS_D1_MASK 0x200
#define MC_SEQ_FIFO_CTL__CG_DIS_D1__SHIFT 0x9
#define MC_SEQ_FIFO_CTL__W_LD_INIT_D1_MASK 0xc00
#define MC_SEQ_FIFO_CTL__W_LD_INIT_D1__SHIFT 0xa
#define MC_SEQ_FIFO_CTL__SYC_DLY_MASK 0x7000
#define MC_SEQ_FIFO_CTL__SYC_DLY__SHIFT 0xc
#define MC_SEQ_FIFO_CTL__W_ASYC_EXT_MASK 0x30000
#define MC_SEQ_FIFO_CTL__W_ASYC_EXT__SHIFT 0x10
#define MC_SEQ_FIFO_CTL__W_DSYC_EXT_MASK 0xc0000
#define MC_SEQ_FIFO_CTL__W_DSYC_EXT__SHIFT 0x12
#define MC_SEQ_FIFO_CTL__R_DQS_LD_INIT_MASK 0xf00000
#define MC_SEQ_FIFO_CTL__R_DQS_LD_INIT__SHIFT 0x14
#define MC_SEQ_FIFO_CTL__R_DQS_STEP_MASK 0xf000000
#define MC_SEQ_FIFO_CTL__R_DQS_STEP__SHIFT 0x18
#define MC_SEQ_FIFO_CTL__R_DQS_FRC_MASK 0x10000000
#define MC_SEQ_FIFO_CTL__R_DQS_FRC__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ0_MASK 0xf
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ1_MASK 0xf0
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ2_MASK 0xf00
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ3_MASK 0xf000
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ4_MASK 0xf0000
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ4__SHIFT 0x10
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ5_MASK 0xf00000
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ5__SHIFT 0x14
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ6_MASK 0xf000000
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ6__SHIFT 0x18
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ7_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_BYTE0_D0__DQ7__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ0_MASK 0xf
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ1_MASK 0xf0
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ2_MASK 0xf00
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ3_MASK 0xf000
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ4_MASK 0xf0000
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ4__SHIFT 0x10
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ5_MASK 0xf00000
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ5__SHIFT 0x14
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ6_MASK 0xf000000
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ6__SHIFT 0x18
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ7_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_BYTE1_D0__DQ7__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ0_MASK 0xf
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ1_MASK 0xf0
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ2_MASK 0xf00
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ3_MASK 0xf000
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ4_MASK 0xf0000
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ4__SHIFT 0x10
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ5_MASK 0xf00000
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ5__SHIFT 0x14
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ6_MASK 0xf000000
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ6__SHIFT 0x18
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ7_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_BYTE2_D0__DQ7__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ0_MASK 0xf
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ1_MASK 0xf0
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ2_MASK 0xf00
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ3_MASK 0xf000
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ4_MASK 0xf0000
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ4__SHIFT 0x10
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ5_MASK 0xf00000
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ5__SHIFT 0x14
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ6_MASK 0xf000000
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ6__SHIFT 0x18
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ7_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_BYTE3_D0__DQ7__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_DBI_D0__DBI0_MASK 0xf
#define MC_SEQ_TXFRAMING_DBI_D0__DBI0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_DBI_D0__DBI1_MASK 0xf0
#define MC_SEQ_TXFRAMING_DBI_D0__DBI1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_DBI_D0__DBI2_MASK 0xf00
#define MC_SEQ_TXFRAMING_DBI_D0__DBI2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_DBI_D0__DBI3_MASK 0xf000
#define MC_SEQ_TXFRAMING_DBI_D0__DBI3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_EDC_D0__EDC0_MASK 0xf
#define MC_SEQ_TXFRAMING_EDC_D0__EDC0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_EDC_D0__EDC1_MASK 0xf0
#define MC_SEQ_TXFRAMING_EDC_D0__EDC1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_EDC_D0__EDC2_MASK 0xf00
#define MC_SEQ_TXFRAMING_EDC_D0__EDC2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_EDC_D0__EDC3_MASK 0xf000
#define MC_SEQ_TXFRAMING_EDC_D0__EDC3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_EDC_D0__WCDR0_MASK 0xf0000
#define MC_SEQ_TXFRAMING_EDC_D0__WCDR0__SHIFT 0x10
#define MC_SEQ_TXFRAMING_EDC_D0__WCDR1_MASK 0xf00000
#define MC_SEQ_TXFRAMING_EDC_D0__WCDR1__SHIFT 0x14
#define MC_SEQ_TXFRAMING_EDC_D0__WCDR2_MASK 0xf000000
#define MC_SEQ_TXFRAMING_EDC_D0__WCDR2__SHIFT 0x18
#define MC_SEQ_TXFRAMING_EDC_D0__WCDR3_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_EDC_D0__WCDR3__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_FCK_D0__FCK0_MASK 0xf
#define MC_SEQ_TXFRAMING_FCK_D0__FCK0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_FCK_D0__FCK1_MASK 0xf0
#define MC_SEQ_TXFRAMING_FCK_D0__FCK1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_FCK_D0__FCK2_MASK 0xf00
#define MC_SEQ_TXFRAMING_FCK_D0__FCK2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_FCK_D0__FCK3_MASK 0xf000
#define MC_SEQ_TXFRAMING_FCK_D0__FCK3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ0_MASK 0xf
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ1_MASK 0xf0
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ2_MASK 0xf00
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ3_MASK 0xf000
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ4_MASK 0xf0000
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ4__SHIFT 0x10
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ5_MASK 0xf00000
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ5__SHIFT 0x14
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ6_MASK 0xf000000
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ6__SHIFT 0x18
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ7_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_BYTE0_D1__DQ7__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ0_MASK 0xf
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ1_MASK 0xf0
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ2_MASK 0xf00
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ3_MASK 0xf000
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ4_MASK 0xf0000
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ4__SHIFT 0x10
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ5_MASK 0xf00000
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ5__SHIFT 0x14
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ6_MASK 0xf000000
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ6__SHIFT 0x18
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ7_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_BYTE1_D1__DQ7__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ0_MASK 0xf
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ1_MASK 0xf0
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ2_MASK 0xf00
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ3_MASK 0xf000
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ4_MASK 0xf0000
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ4__SHIFT 0x10
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ5_MASK 0xf00000
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ5__SHIFT 0x14
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ6_MASK 0xf000000
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ6__SHIFT 0x18
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ7_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_BYTE2_D1__DQ7__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ0_MASK 0xf
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ1_MASK 0xf0
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ2_MASK 0xf00
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ3_MASK 0xf000
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ4_MASK 0xf0000
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ4__SHIFT 0x10
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ5_MASK 0xf00000
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ5__SHIFT 0x14
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ6_MASK 0xf000000
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ6__SHIFT 0x18
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ7_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_BYTE3_D1__DQ7__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_DBI_D1__DBI0_MASK 0xf
#define MC_SEQ_TXFRAMING_DBI_D1__DBI0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_DBI_D1__DBI1_MASK 0xf0
#define MC_SEQ_TXFRAMING_DBI_D1__DBI1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_DBI_D1__DBI2_MASK 0xf00
#define MC_SEQ_TXFRAMING_DBI_D1__DBI2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_DBI_D1__DBI3_MASK 0xf000
#define MC_SEQ_TXFRAMING_DBI_D1__DBI3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_EDC_D1__EDC0_MASK 0xf
#define MC_SEQ_TXFRAMING_EDC_D1__EDC0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_EDC_D1__EDC1_MASK 0xf0
#define MC_SEQ_TXFRAMING_EDC_D1__EDC1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_EDC_D1__EDC2_MASK 0xf00
#define MC_SEQ_TXFRAMING_EDC_D1__EDC2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_EDC_D1__EDC3_MASK 0xf000
#define MC_SEQ_TXFRAMING_EDC_D1__EDC3__SHIFT 0xc
#define MC_SEQ_TXFRAMING_EDC_D1__WCDR0_MASK 0xf0000
#define MC_SEQ_TXFRAMING_EDC_D1__WCDR0__SHIFT 0x10
#define MC_SEQ_TXFRAMING_EDC_D1__WCDR1_MASK 0xf00000
#define MC_SEQ_TXFRAMING_EDC_D1__WCDR1__SHIFT 0x14
#define MC_SEQ_TXFRAMING_EDC_D1__WCDR2_MASK 0xf000000
#define MC_SEQ_TXFRAMING_EDC_D1__WCDR2__SHIFT 0x18
#define MC_SEQ_TXFRAMING_EDC_D1__WCDR3_MASK 0xf0000000
#define MC_SEQ_TXFRAMING_EDC_D1__WCDR3__SHIFT 0x1c
#define MC_SEQ_TXFRAMING_FCK_D1__FCK0_MASK 0xf
#define MC_SEQ_TXFRAMING_FCK_D1__FCK0__SHIFT 0x0
#define MC_SEQ_TXFRAMING_FCK_D1__FCK1_MASK 0xf0
#define MC_SEQ_TXFRAMING_FCK_D1__FCK1__SHIFT 0x4
#define MC_SEQ_TXFRAMING_FCK_D1__FCK2_MASK 0xf00
#define MC_SEQ_TXFRAMING_FCK_D1__FCK2__SHIFT 0x8
#define MC_SEQ_TXFRAMING_FCK_D1__FCK3_MASK 0xf000
#define MC_SEQ_TXFRAMING_FCK_D1__FCK3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ0_MASK 0xf
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ1_MASK 0xf0
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ2_MASK 0xf00
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ3_MASK 0xf000
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ4_MASK 0xf0000
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ4__SHIFT 0x10
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ5_MASK 0xf00000
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ5__SHIFT 0x14
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ6_MASK 0xf000000
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ6__SHIFT 0x18
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ7_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_BYTE0_D0__DQ7__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ0_MASK 0xf
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ1_MASK 0xf0
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ2_MASK 0xf00
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ3_MASK 0xf000
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ4_MASK 0xf0000
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ4__SHIFT 0x10
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ5_MASK 0xf00000
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ5__SHIFT 0x14
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ6_MASK 0xf000000
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ6__SHIFT 0x18
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ7_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_BYTE1_D0__DQ7__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ0_MASK 0xf
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ1_MASK 0xf0
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ2_MASK 0xf00
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ3_MASK 0xf000
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ4_MASK 0xf0000
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ4__SHIFT 0x10
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ5_MASK 0xf00000
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ5__SHIFT 0x14
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ6_MASK 0xf000000
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ6__SHIFT 0x18
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ7_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_BYTE2_D0__DQ7__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ0_MASK 0xf
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ1_MASK 0xf0
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ2_MASK 0xf00
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ3_MASK 0xf000
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ4_MASK 0xf0000
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ4__SHIFT 0x10
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ5_MASK 0xf00000
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ5__SHIFT 0x14
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ6_MASK 0xf000000
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ6__SHIFT 0x18
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ7_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_BYTE3_D0__DQ7__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_DBI_D0__DBI0_MASK 0xf
#define MC_SEQ_RXFRAMING_DBI_D0__DBI0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_DBI_D0__DBI1_MASK 0xf0
#define MC_SEQ_RXFRAMING_DBI_D0__DBI1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_DBI_D0__DBI2_MASK 0xf00
#define MC_SEQ_RXFRAMING_DBI_D0__DBI2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_DBI_D0__DBI3_MASK 0xf000
#define MC_SEQ_RXFRAMING_DBI_D0__DBI3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_EDC_D0__EDC0_MASK 0xf
#define MC_SEQ_RXFRAMING_EDC_D0__EDC0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_EDC_D0__EDC1_MASK 0xf0
#define MC_SEQ_RXFRAMING_EDC_D0__EDC1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_EDC_D0__EDC2_MASK 0xf00
#define MC_SEQ_RXFRAMING_EDC_D0__EDC2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_EDC_D0__EDC3_MASK 0xf000
#define MC_SEQ_RXFRAMING_EDC_D0__EDC3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_EDC_D0__WCDR0_MASK 0xf0000
#define MC_SEQ_RXFRAMING_EDC_D0__WCDR0__SHIFT 0x10
#define MC_SEQ_RXFRAMING_EDC_D0__WCDR1_MASK 0xf00000
#define MC_SEQ_RXFRAMING_EDC_D0__WCDR1__SHIFT 0x14
#define MC_SEQ_RXFRAMING_EDC_D0__WCDR2_MASK 0xf000000
#define MC_SEQ_RXFRAMING_EDC_D0__WCDR2__SHIFT 0x18
#define MC_SEQ_RXFRAMING_EDC_D0__WCDR3_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_EDC_D0__WCDR3__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ0_MASK 0xf
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ1_MASK 0xf0
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ2_MASK 0xf00
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ3_MASK 0xf000
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ4_MASK 0xf0000
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ4__SHIFT 0x10
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ5_MASK 0xf00000
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ5__SHIFT 0x14
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ6_MASK 0xf000000
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ6__SHIFT 0x18
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ7_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_BYTE0_D1__DQ7__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ0_MASK 0xf
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ1_MASK 0xf0
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ2_MASK 0xf00
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ3_MASK 0xf000
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ4_MASK 0xf0000
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ4__SHIFT 0x10
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ5_MASK 0xf00000
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ5__SHIFT 0x14
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ6_MASK 0xf000000
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ6__SHIFT 0x18
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ7_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_BYTE1_D1__DQ7__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ0_MASK 0xf
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ1_MASK 0xf0
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ2_MASK 0xf00
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ3_MASK 0xf000
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ4_MASK 0xf0000
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ4__SHIFT 0x10
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ5_MASK 0xf00000
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ5__SHIFT 0x14
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ6_MASK 0xf000000
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ6__SHIFT 0x18
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ7_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_BYTE2_D1__DQ7__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ0_MASK 0xf
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ1_MASK 0xf0
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ2_MASK 0xf00
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ3_MASK 0xf000
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ4_MASK 0xf0000
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ4__SHIFT 0x10
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ5_MASK 0xf00000
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ5__SHIFT 0x14
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ6_MASK 0xf000000
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ6__SHIFT 0x18
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ7_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_BYTE3_D1__DQ7__SHIFT 0x1c
#define MC_SEQ_RXFRAMING_DBI_D1__DBI0_MASK 0xf
#define MC_SEQ_RXFRAMING_DBI_D1__DBI0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_DBI_D1__DBI1_MASK 0xf0
#define MC_SEQ_RXFRAMING_DBI_D1__DBI1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_DBI_D1__DBI2_MASK 0xf00
#define MC_SEQ_RXFRAMING_DBI_D1__DBI2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_DBI_D1__DBI3_MASK 0xf000
#define MC_SEQ_RXFRAMING_DBI_D1__DBI3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_EDC_D1__EDC0_MASK 0xf
#define MC_SEQ_RXFRAMING_EDC_D1__EDC0__SHIFT 0x0
#define MC_SEQ_RXFRAMING_EDC_D1__EDC1_MASK 0xf0
#define MC_SEQ_RXFRAMING_EDC_D1__EDC1__SHIFT 0x4
#define MC_SEQ_RXFRAMING_EDC_D1__EDC2_MASK 0xf00
#define MC_SEQ_RXFRAMING_EDC_D1__EDC2__SHIFT 0x8
#define MC_SEQ_RXFRAMING_EDC_D1__EDC3_MASK 0xf000
#define MC_SEQ_RXFRAMING_EDC_D1__EDC3__SHIFT 0xc
#define MC_SEQ_RXFRAMING_EDC_D1__WCDR0_MASK 0xf0000
#define MC_SEQ_RXFRAMING_EDC_D1__WCDR0__SHIFT 0x10
#define MC_SEQ_RXFRAMING_EDC_D1__WCDR1_MASK 0xf00000
#define MC_SEQ_RXFRAMING_EDC_D1__WCDR1__SHIFT 0x14
#define MC_SEQ_RXFRAMING_EDC_D1__WCDR2_MASK 0xf000000
#define MC_SEQ_RXFRAMING_EDC_D1__WCDR2__SHIFT 0x18
#define MC_SEQ_RXFRAMING_EDC_D1__WCDR3_MASK 0xf0000000
#define MC_SEQ_RXFRAMING_EDC_D1__WCDR3__SHIFT 0x1c
#define MC_IO_PAD_CNTL__MEM_IO_IMP_MIN_MASK 0xff
#define MC_IO_PAD_CNTL__MEM_IO_IMP_MIN__SHIFT 0x0
#define MC_IO_PAD_CNTL__MEM_IO_IMP_MAX_MASK 0xff00
#define MC_IO_PAD_CNTL__MEM_IO_IMP_MAX__SHIFT 0x8
#define MC_IO_PAD_CNTL__TXPHASE_GRAY_MASK 0x10000
#define MC_IO_PAD_CNTL__TXPHASE_GRAY__SHIFT 0x10
#define MC_IO_PAD_CNTL__RXPHASE_GRAY_MASK 0x20000
#define MC_IO_PAD_CNTL__RXPHASE_GRAY__SHIFT 0x11
#define MC_IO_PAD_CNTL__OVL_YCLKON_D0_MASK 0x40000
#define MC_IO_PAD_CNTL__OVL_YCLKON_D0__SHIFT 0x12
#define MC_IO_PAD_CNTL__OVL_YCLKON_D1_MASK 0x80000
#define MC_IO_PAD_CNTL__OVL_YCLKON_D1__SHIFT 0x13
#define MC_IO_PAD_CNTL__ATBSEL_MASK 0xf00000
#define MC_IO_PAD_CNTL__ATBSEL__SHIFT 0x14
#define MC_IO_PAD_CNTL__ATBEN_MASK 0x3f000000
#define MC_IO_PAD_CNTL__ATBEN__SHIFT 0x18
#define MC_IO_PAD_CNTL__ATBSEL_D1_MASK 0x40000000
#define MC_IO_PAD_CNTL__ATBSEL_D1__SHIFT 0x1e
#define MC_IO_PAD_CNTL__ATBSEL_D0_MASK 0x80000000
#define MC_IO_PAD_CNTL__ATBSEL_D0__SHIFT 0x1f
#define MC_IO_PAD_CNTL_D0__DELAY_CLK_SYNC_MASK 0x4
#define MC_IO_PAD_CNTL_D0__DELAY_CLK_SYNC__SHIFT 0x2
#define MC_IO_PAD_CNTL_D0__DELAY_CMD_SYNC_MASK 0x8
#define MC_IO_PAD_CNTL_D0__DELAY_CMD_SYNC__SHIFT 0x3
#define MC_IO_PAD_CNTL_D0__DELAY_ADR_SYNC_MASK 0x10
#define MC_IO_PAD_CNTL_D0__DELAY_ADR_SYNC__SHIFT 0x4
#define MC_IO_PAD_CNTL_D0__MEM_FALL_OUT_CLK_MASK 0x80
#define MC_IO_PAD_CNTL_D0__MEM_FALL_OUT_CLK__SHIFT 0x7
#define MC_IO_PAD_CNTL_D0__MEM_FALL_OUT_CMD_MASK 0x100
#define MC_IO_PAD_CNTL_D0__MEM_FALL_OUT_CMD__SHIFT 0x8
#define MC_IO_PAD_CNTL_D0__MEM_FALL_OUT_ADR_MASK 0x200
#define MC_IO_PAD_CNTL_D0__MEM_FALL_OUT_ADR__SHIFT 0x9
#define MC_IO_PAD_CNTL_D0__FORCE_EN_RD_STR_MASK 0x400
#define MC_IO_PAD_CNTL_D0__FORCE_EN_RD_STR__SHIFT 0xa
#define MC_IO_PAD_CNTL_D0__EN_RD_STR_DLY_MASK 0x800
#define MC_IO_PAD_CNTL_D0__EN_RD_STR_DLY__SHIFT 0xb
#define MC_IO_PAD_CNTL_D0__DISABLE_CMD_MASK 0x1000
#define MC_IO_PAD_CNTL_D0__DISABLE_CMD__SHIFT 0xc
#define MC_IO_PAD_CNTL_D0__DISABLE_ADR_MASK 0x2000
#define MC_IO_PAD_CNTL_D0__DISABLE_ADR__SHIFT 0xd
#define MC_IO_PAD_CNTL_D0__VREFI_EN_MASK 0x4000
#define MC_IO_PAD_CNTL_D0__VREFI_EN__SHIFT 0xe
#define MC_IO_PAD_CNTL_D0__VREFI_SEL_MASK 0xf8000
#define MC_IO_PAD_CNTL_D0__VREFI_SEL__SHIFT 0xf
#define MC_IO_PAD_CNTL_D0__CK_AUTO_EN_MASK 0x100000
#define MC_IO_PAD_CNTL_D0__CK_AUTO_EN__SHIFT 0x14
#define MC_IO_PAD_CNTL_D0__CK_DELAY_SEL_MASK 0x200000
#define MC_IO_PAD_CNTL_D0__CK_DELAY_SEL__SHIFT 0x15
#define MC_IO_PAD_CNTL_D0__CK_DELAY_N_MASK 0xc00000
#define MC_IO_PAD_CNTL_D0__CK_DELAY_N__SHIFT 0x16
#define MC_IO_PAD_CNTL_D0__CK_DELAY_P_MASK 0x3000000
#define MC_IO_PAD_CNTL_D0__CK_DELAY_P__SHIFT 0x18
#define MC_IO_PAD_CNTL_D0__TXPWROFF_CKE_MASK 0x8000000
#define MC_IO_PAD_CNTL_D0__TXPWROFF_CKE__SHIFT 0x1b
#define MC_IO_PAD_CNTL_D0__UNI_STR_MASK 0x10000000
#define MC_IO_PAD_CNTL_D0__UNI_STR__SHIFT 0x1c
#define MC_IO_PAD_CNTL_D0__DIFF_STR_MASK 0x20000000
#define MC_IO_PAD_CNTL_D0__DIFF_STR__SHIFT 0x1d
#define MC_IO_PAD_CNTL_D0__GDDR_PWRON_MASK 0x40000000
#define MC_IO_PAD_CNTL_D0__GDDR_PWRON__SHIFT 0x1e
#define MC_IO_PAD_CNTL_D0__TXPWROFF_CLK_MASK 0x80000000
#define MC_IO_PAD_CNTL_D0__TXPWROFF_CLK__SHIFT 0x1f
#define MC_IO_PAD_CNTL_D1__DELAY_DATA_SYNC_MASK 0x1
#define MC_IO_PAD_CNTL_D1__DELAY_DATA_SYNC__SHIFT 0x0
#define MC_IO_PAD_CNTL_D1__DELAY_STR_SYNC_MASK 0x2
#define MC_IO_PAD_CNTL_D1__DELAY_STR_SYNC__SHIFT 0x1
#define MC_IO_PAD_CNTL_D1__DELAY_CLK_SYNC_MASK 0x4
#define MC_IO_PAD_CNTL_D1__DELAY_CLK_SYNC__SHIFT 0x2
#define MC_IO_PAD_CNTL_D1__DELAY_CMD_SYNC_MASK 0x8
#define MC_IO_PAD_CNTL_D1__DELAY_CMD_SYNC__SHIFT 0x3
#define MC_IO_PAD_CNTL_D1__DELAY_ADR_SYNC_MASK 0x10
#define MC_IO_PAD_CNTL_D1__DELAY_ADR_SYNC__SHIFT 0x4
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_DATA_MASK 0x20
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_DATA__SHIFT 0x5
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_STR_MASK 0x40
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_STR__SHIFT 0x6
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_CLK_MASK 0x80
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_CLK__SHIFT 0x7
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_CMD_MASK 0x100
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_CMD__SHIFT 0x8
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_ADR_MASK 0x200
#define MC_IO_PAD_CNTL_D1__MEM_FALL_OUT_ADR__SHIFT 0x9
#define MC_IO_PAD_CNTL_D1__FORCE_EN_RD_STR_MASK 0x400
#define MC_IO_PAD_CNTL_D1__FORCE_EN_RD_STR__SHIFT 0xa
#define MC_IO_PAD_CNTL_D1__EN_RD_STR_DLY_MASK 0x800
#define MC_IO_PAD_CNTL_D1__EN_RD_STR_DLY__SHIFT 0xb
#define MC_IO_PAD_CNTL_D1__DISABLE_CMD_MASK 0x1000
#define MC_IO_PAD_CNTL_D1__DISABLE_CMD__SHIFT 0xc
#define MC_IO_PAD_CNTL_D1__DISABLE_ADR_MASK 0x2000
#define MC_IO_PAD_CNTL_D1__DISABLE_ADR__SHIFT 0xd
#define MC_IO_PAD_CNTL_D1__VREFI_EN_MASK 0x4000
#define MC_IO_PAD_CNTL_D1__VREFI_EN__SHIFT 0xe
#define MC_IO_PAD_CNTL_D1__VREFI_SEL_MASK 0xf8000
#define MC_IO_PAD_CNTL_D1__VREFI_SEL__SHIFT 0xf
#define MC_IO_PAD_CNTL_D1__CK_AUTO_EN_MASK 0x100000
#define MC_IO_PAD_CNTL_D1__CK_AUTO_EN__SHIFT 0x14
#define MC_IO_PAD_CNTL_D1__CK_DELAY_SEL_MASK 0x200000
#define MC_IO_PAD_CNTL_D1__CK_DELAY_SEL__SHIFT 0x15
#define MC_IO_PAD_CNTL_D1__CK_DELAY_N_MASK 0xc00000
#define MC_IO_PAD_CNTL_D1__CK_DELAY_N__SHIFT 0x16
#define MC_IO_PAD_CNTL_D1__CK_DELAY_P_MASK 0x3000000
#define MC_IO_PAD_CNTL_D1__CK_DELAY_P__SHIFT 0x18
#define MC_IO_PAD_CNTL_D1__TXPWROFF_CKE_MASK 0x8000000
#define MC_IO_PAD_CNTL_D1__TXPWROFF_CKE__SHIFT 0x1b
#define MC_IO_PAD_CNTL_D1__UNI_STR_MASK 0x10000000
#define MC_IO_PAD_CNTL_D1__UNI_STR__SHIFT 0x1c
#define MC_IO_PAD_CNTL_D1__DIFF_STR_MASK 0x20000000
#define MC_IO_PAD_CNTL_D1__DIFF_STR__SHIFT 0x1d
#define MC_IO_PAD_CNTL_D1__GDDR_PWRON_MASK 0x40000000
#define MC_IO_PAD_CNTL_D1__GDDR_PWRON__SHIFT 0x1e
#define MC_IO_PAD_CNTL_D1__TXPWROFF_CLK_MASK 0x80000000
#define MC_IO_PAD_CNTL_D1__TXPWROFF_CLK__SHIFT 0x1f
#define MC_NPL_STATUS__D0_PDELAY_MASK 0x3
#define MC_NPL_STATUS__D0_PDELAY__SHIFT 0x0
#define MC_NPL_STATUS__D0_NDELAY_MASK 0xc
#define MC_NPL_STATUS__D0_NDELAY__SHIFT 0x2
#define MC_NPL_STATUS__D0_PEARLY_MASK 0x10
#define MC_NPL_STATUS__D0_PEARLY__SHIFT 0x4
#define MC_NPL_STATUS__D0_NEARLY_MASK 0x20
#define MC_NPL_STATUS__D0_NEARLY__SHIFT 0x5
#define MC_NPL_STATUS__D1_PDELAY_MASK 0xc0
#define MC_NPL_STATUS__D1_PDELAY__SHIFT 0x6
#define MC_NPL_STATUS__D1_NDELAY_MASK 0x300
#define MC_NPL_STATUS__D1_NDELAY__SHIFT 0x8
#define MC_NPL_STATUS__D1_PEARLY_MASK 0x400
#define MC_NPL_STATUS__D1_PEARLY__SHIFT 0xa
#define MC_NPL_STATUS__D1_NEARLY_MASK 0x800
#define MC_NPL_STATUS__D1_NEARLY__SHIFT 0xb
#define MC_BIST_CMD_CNTL__RESET_MASK 0x1
#define MC_BIST_CMD_CNTL__RESET__SHIFT 0x0
#define MC_BIST_CMD_CNTL__CMD_ISSUE_MODE_MASK 0x2
#define MC_BIST_CMD_CNTL__CMD_ISSUE_MODE__SHIFT 0x1
#define MC_BIST_CMD_CNTL__CMD_ISSUE_LOOP_MASK 0x4
#define MC_BIST_CMD_CNTL__CMD_ISSUE_LOOP__SHIFT 0x2
#define MC_BIST_CMD_CNTL__LOOP_END_CONDITION_MASK 0x8
#define MC_BIST_CMD_CNTL__LOOP_END_CONDITION__SHIFT 0x3
#define MC_BIST_CMD_CNTL__LOOP_CNT_MAX_MASK 0xfff0
#define MC_BIST_CMD_CNTL__LOOP_CNT_MAX__SHIFT 0x4
#define MC_BIST_CMD_CNTL__CMD_ISSUE_MODE_U_MASK 0x10000
#define MC_BIST_CMD_CNTL__CMD_ISSUE_MODE_U__SHIFT 0x10
#define MC_BIST_CMD_CNTL__CMD_ISSUE_RUN_MASK 0x20000
#define MC_BIST_CMD_CNTL__CMD_ISSUE_RUN__SHIFT 0x11
#define MC_BIST_CMD_CNTL__LOOP_CNT_RD_MASK 0xffc0000
#define MC_BIST_CMD_CNTL__LOOP_CNT_RD__SHIFT 0x12
#define MC_BIST_CMD_CNTL__ENABLE_D0_MASK 0x10000000
#define MC_BIST_CMD_CNTL__ENABLE_D0__SHIFT 0x1c
#define MC_BIST_CMD_CNTL__ENABLE_D1_MASK 0x20000000
#define MC_BIST_CMD_CNTL__ENABLE_D1__SHIFT 0x1d
#define MC_BIST_CMD_CNTL__STATUS_CH_MASK 0x40000000
#define MC_BIST_CMD_CNTL__STATUS_CH__SHIFT 0x1e
#define MC_BIST_CMD_CNTL__DONE_MASK 0x80000000
#define MC_BIST_CMD_CNTL__DONE__SHIFT 0x1f
#define MC_BIST_CNTL__RESET_MASK 0x1
#define MC_BIST_CNTL__RESET__SHIFT 0x0
#define MC_BIST_CNTL__RUN_MASK 0x2
#define MC_BIST_CNTL__RUN__SHIFT 0x1
#define MC_BIST_CNTL__PTR_RST_D0_MASK 0x4
#define MC_BIST_CNTL__PTR_RST_D0__SHIFT 0x2
#define MC_BIST_CNTL__PTR_RST_D1_MASK 0x8
#define MC_BIST_CNTL__PTR_RST_D1__SHIFT 0x3
#define MC_BIST_CNTL__MOP_MODE_MASK 0x10
#define MC_BIST_CNTL__MOP_MODE__SHIFT 0x4
#define MC_BIST_CNTL__ADR_MODE_MASK 0x20
#define MC_BIST_CNTL__ADR_MODE__SHIFT 0x5
#define MC_BIST_CNTL__DAT_MODE_MASK 0x40
#define MC_BIST_CNTL__DAT_MODE__SHIFT 0x6
#define MC_BIST_CNTL__LOOP_MASK 0xc00
#define MC_BIST_CNTL__LOOP__SHIFT 0xa
#define MC_BIST_CNTL__ENABLE_D0_MASK 0x1000
#define MC_BIST_CNTL__ENABLE_D0__SHIFT 0xc
#define MC_BIST_CNTL__ENABLE_D1_MASK 0x2000
#define MC_BIST_CNTL__ENABLE_D1__SHIFT 0xd
#define MC_BIST_CNTL__LOAD_RTDATA_CH_MASK 0x4000
#define MC_BIST_CNTL__LOAD_RTDATA_CH__SHIFT 0xe
#define MC_BIST_CNTL__LOOP_CNT_MASK 0xfff0000
#define MC_BIST_CNTL__LOOP_CNT__SHIFT 0x10
#define MC_BIST_CNTL__DONE_MASK 0x40000000
#define MC_BIST_CNTL__DONE__SHIFT 0x1e
#define MC_BIST_CNTL__LOAD_RTDATA_MASK 0x80000000
#define MC_BIST_CNTL__LOAD_RTDATA__SHIFT 0x1f
#define MC_BIST_AUTO_CNTL__MOP_MASK 0x3
#define MC_BIST_AUTO_CNTL__MOP__SHIFT 0x0
#define MC_BIST_AUTO_CNTL__ADR_GEN_MASK 0xf0
#define MC_BIST_AUTO_CNTL__ADR_GEN__SHIFT 0x4
#define MC_BIST_AUTO_CNTL__LFSR_KEY_MASK 0xffff00
#define MC_BIST_AUTO_CNTL__LFSR_KEY__SHIFT 0x8
#define MC_BIST_AUTO_CNTL__LFSR_RESET_MASK 0x1000000
#define MC_BIST_AUTO_CNTL__LFSR_RESET__SHIFT 0x18
#define MC_BIST_AUTO_CNTL__ADR_RESET_MASK 0x2000000
#define MC_BIST_AUTO_CNTL__ADR_RESET__SHIFT 0x19
#define MC_BIST_DIR_CNTL__MOP_MASK 0x7
#define MC_BIST_DIR_CNTL__MOP__SHIFT 0x0
#define MC_BIST_DIR_CNTL__EOB_MASK 0x8
#define MC_BIST_DIR_CNTL__EOB__SHIFT 0x3
#define MC_BIST_DIR_CNTL__MOP_LOAD_MASK 0x10
#define MC_BIST_DIR_CNTL__MOP_LOAD__SHIFT 0x4
#define MC_BIST_DIR_CNTL__DATA_LOAD_MASK 0x20
#define MC_BIST_DIR_CNTL__DATA_LOAD__SHIFT 0x5
#define MC_BIST_DIR_CNTL__CMD_RTR_D0_MASK 0x40
#define MC_BIST_DIR_CNTL__CMD_RTR_D0__SHIFT 0x6
#define MC_BIST_DIR_CNTL__DAT_RTR_D0_MASK 0x80
#define MC_BIST_DIR_CNTL__DAT_RTR_D0__SHIFT 0x7
#define MC_BIST_DIR_CNTL__CMD_RTR_D1_MASK 0x100
#define MC_BIST_DIR_CNTL__CMD_RTR_D1__SHIFT 0x8
#define MC_BIST_DIR_CNTL__DAT_RTR_D1_MASK 0x200
#define MC_BIST_DIR_CNTL__DAT_RTR_D1__SHIFT 0x9
#define MC_BIST_DIR_CNTL__MOP3_MASK 0x400
#define MC_BIST_DIR_CNTL__MOP3__SHIFT 0xa
#define MC_BIST_SADDR__COL_MASK 0x3ff
#define MC_BIST_SADDR__COL__SHIFT 0x0
#define MC_BIST_SADDR__ROW_MASK 0xfffc00
#define MC_BIST_SADDR__ROW__SHIFT 0xa
#define MC_BIST_SADDR__BANK_MASK 0xf000000
#define MC_BIST_SADDR__BANK__SHIFT 0x18
#define MC_BIST_SADDR__RANK_MASK 0x10000000
#define MC_BIST_SADDR__RANK__SHIFT 0x1c
#define MC_BIST_SADDR__COLH_MASK 0x20000000
#define MC_BIST_SADDR__COLH__SHIFT 0x1d
#define MC_BIST_SADDR__ROWH_MASK 0xc0000000
#define MC_BIST_SADDR__ROWH__SHIFT 0x1e
#define MC_BIST_EADDR__COL_MASK 0x3ff
#define MC_BIST_EADDR__COL__SHIFT 0x0
#define MC_BIST_EADDR__ROW_MASK 0xfffc00
#define MC_BIST_EADDR__ROW__SHIFT 0xa
#define MC_BIST_EADDR__BANK_MASK 0xf000000
#define MC_BIST_EADDR__BANK__SHIFT 0x18
#define MC_BIST_EADDR__RANK_MASK 0x10000000
#define MC_BIST_EADDR__RANK__SHIFT 0x1c
#define MC_BIST_EADDR__COLH_MASK 0x20000000
#define MC_BIST_EADDR__COLH__SHIFT 0x1d
#define MC_BIST_EADDR__ROWH_MASK 0xc0000000
#define MC_BIST_EADDR__ROWH__SHIFT 0x1e
#define MC_BIST_CMP_CNTL__CMP_MASK_BYTE_MASK 0xf
#define MC_BIST_CMP_CNTL__CMP_MASK_BYTE__SHIFT 0x0
#define MC_BIST_CMP_CNTL__CMP_MASK_BIT_MASK 0xff0
#define MC_BIST_CMP_CNTL__CMP_MASK_BIT__SHIFT 0x4
#define MC_BIST_CMP_CNTL__LOAD_RTEDC_MASK 0x1000
#define MC_BIST_CMP_CNTL__LOAD_RTEDC__SHIFT 0xc
#define MC_BIST_CMP_CNTL__DATA_STORE_SEL_MASK 0x2000
#define MC_BIST_CMP_CNTL__DATA_STORE_SEL__SHIFT 0xd
#define MC_BIST_CMP_CNTL__EDC_STORE_SEL_MASK 0x4000
#define MC_BIST_CMP_CNTL__EDC_STORE_SEL__SHIFT 0xe
#define MC_BIST_CMP_CNTL__ENABLE_CMD_FIFO_MASK 0x8000
#define MC_BIST_CMP_CNTL__ENABLE_CMD_FIFO__SHIFT 0xf
#define MC_BIST_CMP_CNTL__CMP_MASK 0x30000
#define MC_BIST_CMP_CNTL__CMP__SHIFT 0x10
#define MC_BIST_CMP_CNTL__DAT_MODE_MASK 0x40000
#define MC_BIST_CMP_CNTL__DAT_MODE__SHIFT 0x12
#define MC_BIST_CMP_CNTL__EDC_STORE_MODE_MASK 0x80000
#define MC_BIST_CMP_CNTL__EDC_STORE_MODE__SHIFT 0x13
#define MC_BIST_CMP_CNTL__DATA_STORE_MODE_MASK 0x300000
#define MC_BIST_CMP_CNTL__DATA_STORE_MODE__SHIFT 0x14
#define MC_BIST_CMP_CNTL__MISMATCH_CNT_MASK 0xffc00000
#define MC_BIST_CMP_CNTL__MISMATCH_CNT__SHIFT 0x16
#define MC_BIST_CMP_CNTL_2__DATA_STORE_CNT_MASK 0x1f
#define MC_BIST_CMP_CNTL_2__DATA_STORE_CNT__SHIFT 0x0
#define MC_BIST_CMP_CNTL_2__DATA_STORE_CNT_RST_MASK 0x100
#define MC_BIST_CMP_CNTL_2__DATA_STORE_CNT_RST__SHIFT 0x8
#define MC_BIST_CMP_CNTL_2__EDC_STORE_CNT_MASK 0x1f000
#define MC_BIST_CMP_CNTL_2__EDC_STORE_CNT__SHIFT 0xc
#define MC_BIST_CMP_CNTL_2__EDC_STORE_CNT_RST_MASK 0x100000
#define MC_BIST_CMP_CNTL_2__EDC_STORE_CNT_RST__SHIFT 0x14
#define MC_BIST_DATA_WORD0__DATA_MASK 0xffffffff
#define MC_BIST_DATA_WORD0__DATA__SHIFT 0x0
#define MC_BIST_DATA_WORD1__DATA_MASK 0xffffffff
#define MC_BIST_DATA_WORD1__DATA__SHIFT 0x0
#define MC_BIST_DATA_WORD2__DATA_MASK 0xffffffff
#define MC_BIST_DATA_WORD2__DATA__SHIFT 0x0
#define MC_BIST_DATA_WORD3__DATA_MASK 0xffffffff
#define MC_BIST_DATA_WORD3__DATA__SHIFT 0x0
#define MC_BIST_DATA_WORD4__DATA_MASK 0xffffffff
#define MC_BIST_DATA_WORD4__DATA__SHIFT 0x0
#define MC_BIST_DATA_WORD5__DATA_MASK 0xffffffff
#define MC_BIST_DATA_WORD5__DATA__SHIFT 0x0
#define MC_BIST_DATA_WORD6__DATA_MASK 0xffffffff
#define MC_BIST_DATA_WORD6__DATA__SHIFT 0x0
#define MC_BIST_DATA_WORD7__DATA_MASK 0xffffffff
#define MC_BIST_DATA_WORD7__DATA__SHIFT 0x0
#define MC_BIST_DATA_MASK__MASK_MASK 0xffffffff
#define MC_BIST_DATA_MASK__MASK__SHIFT 0x0
#define MC_BIST_MISMATCH_ADDR__COL_MASK 0x3ff
#define MC_BIST_MISMATCH_ADDR__COL__SHIFT 0x0
#define MC_BIST_MISMATCH_ADDR__ROW_MASK 0xfffc00
#define MC_BIST_MISMATCH_ADDR__ROW__SHIFT 0xa
#define MC_BIST_MISMATCH_ADDR__BANK_MASK 0xf000000
#define MC_BIST_MISMATCH_ADDR__BANK__SHIFT 0x18
#define MC_BIST_MISMATCH_ADDR__RANK_MASK 0x10000000
#define MC_BIST_MISMATCH_ADDR__RANK__SHIFT 0x1c
#define MC_BIST_MISMATCH_ADDR__COLH_MASK 0x20000000
#define MC_BIST_MISMATCH_ADDR__COLH__SHIFT 0x1d
#define MC_BIST_MISMATCH_ADDR__ROWH_MASK 0xc0000000
#define MC_BIST_MISMATCH_ADDR__ROWH__SHIFT 0x1e
#define MC_BIST_RDATA_WORD0__RDATA_MASK 0xffffffff
#define MC_BIST_RDATA_WORD0__RDATA__SHIFT 0x0
#define MC_BIST_RDATA_WORD1__RDATA_MASK 0xffffffff
#define MC_BIST_RDATA_WORD1__RDATA__SHIFT 0x0
#define MC_BIST_RDATA_WORD2__RDATA_MASK 0xffffffff
#define MC_BIST_RDATA_WORD2__RDATA__SHIFT 0x0
#define MC_BIST_RDATA_WORD3__RDATA_MASK 0xffffffff
#define MC_BIST_RDATA_WORD3__RDATA__SHIFT 0x0
#define MC_BIST_RDATA_WORD4__RDATA_MASK 0xffffffff
#define MC_BIST_RDATA_WORD4__RDATA__SHIFT 0x0
#define MC_BIST_RDATA_WORD5__RDATA_MASK 0xffffffff
#define MC_BIST_RDATA_WORD5__RDATA__SHIFT 0x0
#define MC_BIST_RDATA_WORD6__RDATA_MASK 0xffffffff
#define MC_BIST_RDATA_WORD6__RDATA__SHIFT 0x0
#define MC_BIST_RDATA_WORD7__RDATA_MASK 0xffffffff
#define MC_BIST_RDATA_WORD7__RDATA__SHIFT 0x0
#define MC_BIST_RDATA_MASK__MASK_MASK 0xffffffff
#define MC_BIST_RDATA_MASK__MASK__SHIFT 0x0
#define MC_BIST_RDATA_EDC__EDC_MASK 0xffffffff
#define MC_BIST_RDATA_EDC__EDC__SHIFT 0x0
#define MC_SEQ_PERF_CNTL__MONITOR_PERIOD_MASK 0x3fffffff
#define MC_SEQ_PERF_CNTL__MONITOR_PERIOD__SHIFT 0x0
#define MC_SEQ_PERF_CNTL__CNTL_MASK 0xc0000000
#define MC_SEQ_PERF_CNTL__CNTL__SHIFT 0x1e
#define MC_SEQ_PERF_CNTL_1__PAUSE_MASK 0x1
#define MC_SEQ_PERF_CNTL_1__PAUSE__SHIFT 0x0
#define MC_SEQ_PERF_CNTL_1__SEL_A_MSB_MASK 0x100
#define MC_SEQ_PERF_CNTL_1__SEL_A_MSB__SHIFT 0x8
#define MC_SEQ_PERF_CNTL_1__SEL_B_MSB_MASK 0x200
#define MC_SEQ_PERF_CNTL_1__SEL_B_MSB__SHIFT 0x9
#define MC_SEQ_PERF_CNTL_1__SEL_CH0_C_MSB_MASK 0x400
#define MC_SEQ_PERF_CNTL_1__SEL_CH0_C_MSB__SHIFT 0xa
#define MC_SEQ_PERF_CNTL_1__SEL_CH0_D_MSB_MASK 0x800
#define MC_SEQ_PERF_CNTL_1__SEL_CH0_D_MSB__SHIFT 0xb
#define MC_SEQ_PERF_CNTL_1__SEL_CH1_A_MSB_MASK 0x1000
#define MC_SEQ_PERF_CNTL_1__SEL_CH1_A_MSB__SHIFT 0xc
#define MC_SEQ_PERF_CNTL_1__SEL_CH1_B_MSB_MASK 0x2000
#define MC_SEQ_PERF_CNTL_1__SEL_CH1_B_MSB__SHIFT 0xd
#define MC_SEQ_PERF_CNTL_1__SEL_CH1_C_MSB_MASK 0x4000
#define MC_SEQ_PERF_CNTL_1__SEL_CH1_C_MSB__SHIFT 0xe
#define MC_SEQ_PERF_CNTL_1__SEL_CH1_D_MSB_MASK 0x8000
#define MC_SEQ_PERF_CNTL_1__SEL_CH1_D_MSB__SHIFT 0xf
#define MC_SEQ_PERF_SEQ_CTL__SEL_A_MASK 0xf
#define MC_SEQ_PERF_SEQ_CTL__SEL_A__SHIFT 0x0
#define MC_SEQ_PERF_SEQ_CTL__SEL_B_MASK 0xf0
#define MC_SEQ_PERF_SEQ_CTL__SEL_B__SHIFT 0x4
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH0_C_MASK 0xf00
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH0_C__SHIFT 0x8
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH0_D_MASK 0xf000
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH0_D__SHIFT 0xc
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH1_A_MASK 0xf0000
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH1_A__SHIFT 0x10
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH1_B_MASK 0xf00000
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH1_B__SHIFT 0x14
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH1_C_MASK 0xf000000
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH1_C__SHIFT 0x18
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH1_D_MASK 0xf0000000
#define MC_SEQ_PERF_SEQ_CTL__SEL_CH1_D__SHIFT 0x1c
#define MC_SEQ_PERF_SEQ_CNT_A_I0__VALUE_MASK 0xffffffff
#define MC_SEQ_PERF_SEQ_CNT_A_I0__VALUE__SHIFT 0x0
#define MC_SEQ_PERF_SEQ_CNT_A_I1__VALUE_MASK 0xffffffff
#define MC_SEQ_PERF_SEQ_CNT_A_I1__VALUE__SHIFT 0x0
#define MC_SEQ_PERF_SEQ_CNT_B_I0__VALUE_MASK 0xffffffff
#define MC_SEQ_PERF_SEQ_CNT_B_I0__VALUE__SHIFT 0x0
#define MC_SEQ_PERF_SEQ_CNT_B_I1__VALUE_MASK 0xffffffff
#define MC_SEQ_PERF_SEQ_CNT_B_I1__VALUE__SHIFT 0x0
#define MC_SEQ_PERF_SEQ_CNT_C_I0__VALUE_MASK 0xffffffff
#define MC_SEQ_PERF_SEQ_CNT_C_I0__VALUE__SHIFT 0x0
#define MC_SEQ_PERF_SEQ_CNT_C_I1__VALUE_MASK 0xffffffff
#define MC_SEQ_PERF_SEQ_CNT_C_I1__VALUE__SHIFT 0x0
#define MC_SEQ_PERF_SEQ_CNT_D_I0__VALUE_MASK 0xffffffff
#define MC_SEQ_PERF_SEQ_CNT_D_I0__VALUE__SHIFT 0x0
#define MC_SEQ_PERF_SEQ_CNT_D_I1__VALUE_MASK 0xffffffff
#define MC_SEQ_PERF_SEQ_CNT_D_I1__VALUE__SHIFT 0x0
#define MC_SEQ_STATUS_M__PWRUP_COMPL_D0_MASK 0x1
#define MC_SEQ_STATUS_M__PWRUP_COMPL_D0__SHIFT 0x0
#define MC_SEQ_STATUS_M__PWRUP_COMPL_D1_MASK 0x2
#define MC_SEQ_STATUS_M__PWRUP_COMPL_D1__SHIFT 0x1
#define MC_SEQ_STATUS_M__CMD_RDY_D0_MASK 0x4
#define MC_SEQ_STATUS_M__CMD_RDY_D0__SHIFT 0x2
#define MC_SEQ_STATUS_M__CMD_RDY_D1_MASK 0x8
#define MC_SEQ_STATUS_M__CMD_RDY_D1__SHIFT 0x3
#define MC_SEQ_STATUS_M__SLF_D0_MASK 0x10
#define MC_SEQ_STATUS_M__SLF_D0__SHIFT 0x4
#define MC_SEQ_STATUS_M__SLF_D1_MASK 0x20
#define MC_SEQ_STATUS_M__SLF_D1__SHIFT 0x5
#define MC_SEQ_STATUS_M__SS_SLF_D0_MASK 0x40
#define MC_SEQ_STATUS_M__SS_SLF_D0__SHIFT 0x6
#define MC_SEQ_STATUS_M__SS_SLF_D1_MASK 0x80
#define MC_SEQ_STATUS_M__SS_SLF_D1__SHIFT 0x7
#define MC_SEQ_STATUS_M__SEQ0_ARB_CMD_FIFO_EMPTY_MASK 0x100
#define MC_SEQ_STATUS_M__SEQ0_ARB_CMD_FIFO_EMPTY__SHIFT 0x8
#define MC_SEQ_STATUS_M__SEQ1_ARB_CMD_FIFO_EMPTY_MASK 0x200
#define MC_SEQ_STATUS_M__SEQ1_ARB_CMD_FIFO_EMPTY__SHIFT 0x9
#define MC_SEQ_STATUS_M__SEQ0_RS_DATA_FIFO_FULL_MASK 0x1000
#define MC_SEQ_STATUS_M__SEQ0_RS_DATA_FIFO_FULL__SHIFT 0xc
#define MC_SEQ_STATUS_M__SEQ1_RS_DATA_FIFO_FULL_MASK 0x2000
#define MC_SEQ_STATUS_M__SEQ1_RS_DATA_FIFO_FULL__SHIFT 0xd
#define MC_SEQ_STATUS_M__SEQ0_BUSY_MASK 0x4000
#define MC_SEQ_STATUS_M__SEQ0_BUSY__SHIFT 0xe
#define MC_SEQ_STATUS_M__SEQ1_BUSY_MASK 0x8000
#define MC_SEQ_STATUS_M__SEQ1_BUSY__SHIFT 0xf
#define MC_SEQ_STATUS_M__PMG_PWRSTATE_MASK 0x10000
#define MC_SEQ_STATUS_M__PMG_PWRSTATE__SHIFT 0x10
#define MC_SEQ_STATUS_M__PMG_FSMSTATE_MASK 0x1f00000
#define MC_SEQ_STATUS_M__PMG_FSMSTATE__SHIFT 0x14
#define MC_SEQ_STATUS_M__SEQ0_BUSY_HYS_MASK 0x2000000
#define MC_SEQ_STATUS_M__SEQ0_BUSY_HYS__SHIFT 0x19
#define MC_SEQ_STATUS_M__SEQ1_BUSY_HYS_MASK 0x4000000
#define MC_SEQ_STATUS_M__SEQ1_BUSY_HYS__SHIFT 0x1a
#define MC_SEQ_STATUS_M__SEQ0_ALLOWSTOP_MASK 0x8000000
#define MC_SEQ_STATUS_M__SEQ0_ALLOWSTOP__SHIFT 0x1b
#define MC_SEQ_STATUS_M__SEQ1_ALLOWSTOP_MASK 0x10000000
#define MC_SEQ_STATUS_M__SEQ1_ALLOWSTOP__SHIFT 0x1c
#define MC_SEQ_STATUS_S__SEQ0_ARB_DATA_FIFO_FULL_MASK 0x1
#define MC_SEQ_STATUS_S__SEQ0_ARB_DATA_FIFO_FULL__SHIFT 0x0
#define MC_SEQ_STATUS_S__SEQ1_ARB_DATA_FIFO_FULL_MASK 0x2
#define MC_SEQ_STATUS_S__SEQ1_ARB_DATA_FIFO_FULL__SHIFT 0x1
#define MC_SEQ_STATUS_S__SEQ0_ARB_CMD_FIFO_FULL_MASK 0x10
#define MC_SEQ_STATUS_S__SEQ0_ARB_CMD_FIFO_FULL__SHIFT 0x4
#define MC_SEQ_STATUS_S__SEQ1_ARB_CMD_FIFO_FULL_MASK 0x20
#define MC_SEQ_STATUS_S__SEQ1_ARB_CMD_FIFO_FULL__SHIFT 0x5
#define MC_SEQ_STATUS_S__SEQ0_RS_DATA_FIFO_EMPTY_MASK 0x100
#define MC_SEQ_STATUS_S__SEQ0_RS_DATA_FIFO_EMPTY__SHIFT 0x8
#define MC_SEQ_STATUS_S__SEQ1_RS_DATA_FIFO_EMPTY_MASK 0x200
#define MC_SEQ_STATUS_S__SEQ1_RS_DATA_FIFO_EMPTY__SHIFT 0x9
#define MC_CG_DATAPORT__DATA_FIELD_MASK 0xffffffff
#define MC_CG_DATAPORT__DATA_FIELD__SHIFT 0x0
#define MC_SEQ_VENDOR_ID_I0__VALUE_MASK 0xffffffff
#define MC_SEQ_VENDOR_ID_I0__VALUE__SHIFT 0x0
#define MC_SEQ_VENDOR_ID_I1__VALUE_MASK 0xffffffff
#define MC_SEQ_VENDOR_ID_I1__VALUE__SHIFT 0x0
#define MC_SEQ_MISC0__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC0__VALUE__SHIFT 0x0
#define MC_SEQ_MISC1__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC1__VALUE__SHIFT 0x0
#define MC_SEQ_RESERVE_0_S__SCLK_FIELD_MASK 0xffffffff
#define MC_SEQ_RESERVE_0_S__SCLK_FIELD__SHIFT 0x0
#define MC_SEQ_RESERVE_1_S__SCLK_FIELD_MASK 0xffffffff
#define MC_SEQ_RESERVE_1_S__SCLK_FIELD__SHIFT 0x0
#define MC_SEQ_RESERVE_M__MCLK_FIELD_MASK 0xffffffff
#define MC_SEQ_RESERVE_M__MCLK_FIELD__SHIFT 0x0
#define MC_SEQ_IO_RESERVE_D0__DPHY0_RSV_MASK 0xfff
#define MC_SEQ_IO_RESERVE_D0__DPHY0_RSV__SHIFT 0x0
#define MC_SEQ_IO_RESERVE_D0__DPHY1_RSV_MASK 0xfff000
#define MC_SEQ_IO_RESERVE_D0__DPHY1_RSV__SHIFT 0xc
#define MC_SEQ_IO_RESERVE_D0__APHY_RSV_MASK 0xff000000
#define MC_SEQ_IO_RESERVE_D0__APHY_RSV__SHIFT 0x18
#define MC_SEQ_IO_RESERVE_D1__DPHY0_RSV_MASK 0xfff
#define MC_SEQ_IO_RESERVE_D1__DPHY0_RSV__SHIFT 0x0
#define MC_SEQ_IO_RESERVE_D1__DPHY1_RSV_MASK 0xfff000
#define MC_SEQ_IO_RESERVE_D1__DPHY1_RSV__SHIFT 0xc
#define MC_SEQ_IO_RESERVE_D1__APHY_RSV_MASK 0xff000000
#define MC_SEQ_IO_RESERVE_D1__APHY_RSV__SHIFT 0x18
#define MC_SEQ_SUP_CNTL__RUN_MASK 0x1
#define MC_SEQ_SUP_CNTL__RUN__SHIFT 0x0
#define MC_SEQ_SUP_CNTL__SINGLE_STEP_MASK 0x2
#define MC_SEQ_SUP_CNTL__SINGLE_STEP__SHIFT 0x1
#define MC_SEQ_SUP_CNTL__SW_WAKE_MASK 0x4
#define MC_SEQ_SUP_CNTL__SW_WAKE__SHIFT 0x2
#define MC_SEQ_SUP_CNTL__RESET_PC_MASK 0x8
#define MC_SEQ_SUP_CNTL__RESET_PC__SHIFT 0x3
#define MC_SEQ_SUP_CNTL__PGM_WRITE_MASK 0x10
#define MC_SEQ_SUP_CNTL__PGM_WRITE__SHIFT 0x4
#define MC_SEQ_SUP_CNTL__PGM_READ_MASK 0x20
#define MC_SEQ_SUP_CNTL__PGM_READ__SHIFT 0x5
#define MC_SEQ_SUP_CNTL__FAST_WRITE_MASK 0x40
#define MC_SEQ_SUP_CNTL__FAST_WRITE__SHIFT 0x6
#define MC_SEQ_SUP_CNTL__BKPT_CLEAR_MASK 0x80
#define MC_SEQ_SUP_CNTL__BKPT_CLEAR__SHIFT 0x7
#define MC_SEQ_SUP_CNTL__PGM_CHKSUM_MASK 0xff800000
#define MC_SEQ_SUP_CNTL__PGM_CHKSUM__SHIFT 0x17
#define MC_SEQ_SUP_PGM__CNTL_MASK 0xffffffff
#define MC_SEQ_SUP_PGM__CNTL__SHIFT 0x0
#define MC_SEQ_SUP_GP0_STAT__STATUS_MASK 0xffffffff
#define MC_SEQ_SUP_GP0_STAT__STATUS__SHIFT 0x0
#define MC_SEQ_SUP_GP1_STAT__STATUS_MASK 0xffffffff
#define MC_SEQ_SUP_GP1_STAT__STATUS__SHIFT 0x0
#define MC_SEQ_SUP_GP2_STAT__STATUS_MASK 0xffffffff
#define MC_SEQ_SUP_GP2_STAT__STATUS__SHIFT 0x0
#define MC_SEQ_SUP_GP3_STAT__STATUS_MASK 0xffffffff
#define MC_SEQ_SUP_GP3_STAT__STATUS__SHIFT 0x0
#define MC_SEQ_SUP_IR_STAT__STATUS_MASK 0xffffffff
#define MC_SEQ_SUP_IR_STAT__STATUS__SHIFT 0x0
#define MC_SEQ_SUP_DEC_STAT__STATUS_MASK 0xffffffff
#define MC_SEQ_SUP_DEC_STAT__STATUS__SHIFT 0x0
#define MC_SEQ_SUP_PGM_STAT__STATUS_MASK 0xffffffff
#define MC_SEQ_SUP_PGM_STAT__STATUS__SHIFT 0x0
#define MC_SEQ_SUP_R_PGM__PGM_MASK 0xffffffff
#define MC_SEQ_SUP_R_PGM__PGM__SHIFT 0x0
#define MC_SEQ_MISC3__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC3__VALUE__SHIFT 0x0
#define MC_SEQ_MISC4__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC4__VALUE__SHIFT 0x0
#define MC_SEQ_MISC5__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC5__VALUE__SHIFT 0x0
#define MC_SEQ_MISC6__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC6__VALUE__SHIFT 0x0
#define MC_SEQ_MISC7__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC7__VALUE__SHIFT 0x0
#define MC_SEQ_MISC8__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC8__VALUE__SHIFT 0x0
#define MC_SEQ_MISC9__VALUE_MASK 0xffffffff
#define MC_SEQ_MISC9__VALUE__SHIFT 0x0
#define MC_SEQ_CG__CG_SEQ_REQ_MASK 0xff
#define MC_SEQ_CG__CG_SEQ_REQ__SHIFT 0x0
#define MC_SEQ_CG__CG_SEQ_RESP_MASK 0xff00
#define MC_SEQ_CG__CG_SEQ_RESP__SHIFT 0x8
#define MC_SEQ_CG__SEQ_CG_REQ_MASK 0xff0000
#define MC_SEQ_CG__SEQ_CG_REQ__SHIFT 0x10
#define MC_SEQ_CG__SEQ_CG_RESP_MASK 0xff000000
#define MC_SEQ_CG__SEQ_CG_RESP__SHIFT 0x18
#define MC_SEQ_BYTE_REMAP_D0__BYTE0_MASK 0x3
#define MC_SEQ_BYTE_REMAP_D0__BYTE0__SHIFT 0x0
#define MC_SEQ_BYTE_REMAP_D0__BYTE1_MASK 0xc
#define MC_SEQ_BYTE_REMAP_D0__BYTE1__SHIFT 0x2
#define MC_SEQ_BYTE_REMAP_D0__BYTE2_MASK 0x30
#define MC_SEQ_BYTE_REMAP_D0__BYTE2__SHIFT 0x4
#define MC_SEQ_BYTE_REMAP_D0__BYTE3_MASK 0xc0
#define MC_SEQ_BYTE_REMAP_D0__BYTE3__SHIFT 0x6
#define MC_SEQ_BYTE_REMAP_D1__BYTE0_MASK 0x3
#define MC_SEQ_BYTE_REMAP_D1__BYTE0__SHIFT 0x0
#define MC_SEQ_BYTE_REMAP_D1__BYTE1_MASK 0xc
#define MC_SEQ_BYTE_REMAP_D1__BYTE1__SHIFT 0x2
#define MC_SEQ_BYTE_REMAP_D1__BYTE2_MASK 0x30
#define MC_SEQ_BYTE_REMAP_D1__BYTE2__SHIFT 0x4
#define MC_SEQ_BYTE_REMAP_D1__BYTE3_MASK 0xc0
#define MC_SEQ_BYTE_REMAP_D1__BYTE3__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B0_D0__BIT0_MASK 0x7
#define MC_SEQ_BIT_REMAP_B0_D0__BIT0__SHIFT 0x0
#define MC_SEQ_BIT_REMAP_B0_D0__BIT1_MASK 0x38
#define MC_SEQ_BIT_REMAP_B0_D0__BIT1__SHIFT 0x3
#define MC_SEQ_BIT_REMAP_B0_D0__BIT2_MASK 0x1c0
#define MC_SEQ_BIT_REMAP_B0_D0__BIT2__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B0_D0__BIT3_MASK 0xe00
#define MC_SEQ_BIT_REMAP_B0_D0__BIT3__SHIFT 0x9
#define MC_SEQ_BIT_REMAP_B0_D0__BIT4_MASK 0x7000
#define MC_SEQ_BIT_REMAP_B0_D0__BIT4__SHIFT 0xc
#define MC_SEQ_BIT_REMAP_B0_D0__BIT5_MASK 0x38000
#define MC_SEQ_BIT_REMAP_B0_D0__BIT5__SHIFT 0xf
#define MC_SEQ_BIT_REMAP_B0_D0__BIT6_MASK 0x1c0000
#define MC_SEQ_BIT_REMAP_B0_D0__BIT6__SHIFT 0x12
#define MC_SEQ_BIT_REMAP_B0_D0__BIT7_MASK 0xe00000
#define MC_SEQ_BIT_REMAP_B0_D0__BIT7__SHIFT 0x15
#define MC_SEQ_BIT_REMAP_B1_D0__BIT0_MASK 0x7
#define MC_SEQ_BIT_REMAP_B1_D0__BIT0__SHIFT 0x0
#define MC_SEQ_BIT_REMAP_B1_D0__BIT1_MASK 0x38
#define MC_SEQ_BIT_REMAP_B1_D0__BIT1__SHIFT 0x3
#define MC_SEQ_BIT_REMAP_B1_D0__BIT2_MASK 0x1c0
#define MC_SEQ_BIT_REMAP_B1_D0__BIT2__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B1_D0__BIT3_MASK 0xe00
#define MC_SEQ_BIT_REMAP_B1_D0__BIT3__SHIFT 0x9
#define MC_SEQ_BIT_REMAP_B1_D0__BIT4_MASK 0x7000
#define MC_SEQ_BIT_REMAP_B1_D0__BIT4__SHIFT 0xc
#define MC_SEQ_BIT_REMAP_B1_D0__BIT5_MASK 0x38000
#define MC_SEQ_BIT_REMAP_B1_D0__BIT5__SHIFT 0xf
#define MC_SEQ_BIT_REMAP_B1_D0__BIT6_MASK 0x1c0000
#define MC_SEQ_BIT_REMAP_B1_D0__BIT6__SHIFT 0x12
#define MC_SEQ_BIT_REMAP_B1_D0__BIT7_MASK 0xe00000
#define MC_SEQ_BIT_REMAP_B1_D0__BIT7__SHIFT 0x15
#define MC_SEQ_BIT_REMAP_B2_D0__BIT0_MASK 0x7
#define MC_SEQ_BIT_REMAP_B2_D0__BIT0__SHIFT 0x0
#define MC_SEQ_BIT_REMAP_B2_D0__BIT1_MASK 0x38
#define MC_SEQ_BIT_REMAP_B2_D0__BIT1__SHIFT 0x3
#define MC_SEQ_BIT_REMAP_B2_D0__BIT2_MASK 0x1c0
#define MC_SEQ_BIT_REMAP_B2_D0__BIT2__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B2_D0__BIT3_MASK 0xe00
#define MC_SEQ_BIT_REMAP_B2_D0__BIT3__SHIFT 0x9
#define MC_SEQ_BIT_REMAP_B2_D0__BIT4_MASK 0x7000
#define MC_SEQ_BIT_REMAP_B2_D0__BIT4__SHIFT 0xc
#define MC_SEQ_BIT_REMAP_B2_D0__BIT5_MASK 0x38000
#define MC_SEQ_BIT_REMAP_B2_D0__BIT5__SHIFT 0xf
#define MC_SEQ_BIT_REMAP_B2_D0__BIT6_MASK 0x1c0000
#define MC_SEQ_BIT_REMAP_B2_D0__BIT6__SHIFT 0x12
#define MC_SEQ_BIT_REMAP_B2_D0__BIT7_MASK 0xe00000
#define MC_SEQ_BIT_REMAP_B2_D0__BIT7__SHIFT 0x15
#define MC_SEQ_BIT_REMAP_B3_D0__BIT0_MASK 0x7
#define MC_SEQ_BIT_REMAP_B3_D0__BIT0__SHIFT 0x0
#define MC_SEQ_BIT_REMAP_B3_D0__BIT1_MASK 0x38
#define MC_SEQ_BIT_REMAP_B3_D0__BIT1__SHIFT 0x3
#define MC_SEQ_BIT_REMAP_B3_D0__BIT2_MASK 0x1c0
#define MC_SEQ_BIT_REMAP_B3_D0__BIT2__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B3_D0__BIT3_MASK 0xe00
#define MC_SEQ_BIT_REMAP_B3_D0__BIT3__SHIFT 0x9
#define MC_SEQ_BIT_REMAP_B3_D0__BIT4_MASK 0x7000
#define MC_SEQ_BIT_REMAP_B3_D0__BIT4__SHIFT 0xc
#define MC_SEQ_BIT_REMAP_B3_D0__BIT5_MASK 0x38000
#define MC_SEQ_BIT_REMAP_B3_D0__BIT5__SHIFT 0xf
#define MC_SEQ_BIT_REMAP_B3_D0__BIT6_MASK 0x1c0000
#define MC_SEQ_BIT_REMAP_B3_D0__BIT6__SHIFT 0x12
#define MC_SEQ_BIT_REMAP_B3_D0__BIT7_MASK 0xe00000
#define MC_SEQ_BIT_REMAP_B3_D0__BIT7__SHIFT 0x15
#define MC_SEQ_BIT_REMAP_B0_D1__BIT0_MASK 0x7
#define MC_SEQ_BIT_REMAP_B0_D1__BIT0__SHIFT 0x0
#define MC_SEQ_BIT_REMAP_B0_D1__BIT1_MASK 0x38
#define MC_SEQ_BIT_REMAP_B0_D1__BIT1__SHIFT 0x3
#define MC_SEQ_BIT_REMAP_B0_D1__BIT2_MASK 0x1c0
#define MC_SEQ_BIT_REMAP_B0_D1__BIT2__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B0_D1__BIT3_MASK 0xe00
#define MC_SEQ_BIT_REMAP_B0_D1__BIT3__SHIFT 0x9
#define MC_SEQ_BIT_REMAP_B0_D1__BIT4_MASK 0x7000
#define MC_SEQ_BIT_REMAP_B0_D1__BIT4__SHIFT 0xc
#define MC_SEQ_BIT_REMAP_B0_D1__BIT5_MASK 0x38000
#define MC_SEQ_BIT_REMAP_B0_D1__BIT5__SHIFT 0xf
#define MC_SEQ_BIT_REMAP_B0_D1__BIT6_MASK 0x1c0000
#define MC_SEQ_BIT_REMAP_B0_D1__BIT6__SHIFT 0x12
#define MC_SEQ_BIT_REMAP_B0_D1__BIT7_MASK 0xe00000
#define MC_SEQ_BIT_REMAP_B0_D1__BIT7__SHIFT 0x15
#define MC_SEQ_BIT_REMAP_B1_D1__BIT0_MASK 0x7
#define MC_SEQ_BIT_REMAP_B1_D1__BIT0__SHIFT 0x0
#define MC_SEQ_BIT_REMAP_B1_D1__BIT1_MASK 0x38
#define MC_SEQ_BIT_REMAP_B1_D1__BIT1__SHIFT 0x3
#define MC_SEQ_BIT_REMAP_B1_D1__BIT2_MASK 0x1c0
#define MC_SEQ_BIT_REMAP_B1_D1__BIT2__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B1_D1__BIT3_MASK 0xe00
#define MC_SEQ_BIT_REMAP_B1_D1__BIT3__SHIFT 0x9
#define MC_SEQ_BIT_REMAP_B1_D1__BIT4_MASK 0x7000
#define MC_SEQ_BIT_REMAP_B1_D1__BIT4__SHIFT 0xc
#define MC_SEQ_BIT_REMAP_B1_D1__BIT5_MASK 0x38000
#define MC_SEQ_BIT_REMAP_B1_D1__BIT5__SHIFT 0xf
#define MC_SEQ_BIT_REMAP_B1_D1__BIT6_MASK 0x1c0000
#define MC_SEQ_BIT_REMAP_B1_D1__BIT6__SHIFT 0x12
#define MC_SEQ_BIT_REMAP_B1_D1__BIT7_MASK 0xe00000
#define MC_SEQ_BIT_REMAP_B1_D1__BIT7__SHIFT 0x15
#define MC_SEQ_BIT_REMAP_B2_D1__BIT0_MASK 0x7
#define MC_SEQ_BIT_REMAP_B2_D1__BIT0__SHIFT 0x0
#define MC_SEQ_BIT_REMAP_B2_D1__BIT1_MASK 0x38
#define MC_SEQ_BIT_REMAP_B2_D1__BIT1__SHIFT 0x3
#define MC_SEQ_BIT_REMAP_B2_D1__BIT2_MASK 0x1c0
#define MC_SEQ_BIT_REMAP_B2_D1__BIT2__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B2_D1__BIT3_MASK 0xe00
#define MC_SEQ_BIT_REMAP_B2_D1__BIT3__SHIFT 0x9
#define MC_SEQ_BIT_REMAP_B2_D1__BIT4_MASK 0x7000
#define MC_SEQ_BIT_REMAP_B2_D1__BIT4__SHIFT 0xc
#define MC_SEQ_BIT_REMAP_B2_D1__BIT5_MASK 0x38000
#define MC_SEQ_BIT_REMAP_B2_D1__BIT5__SHIFT 0xf
#define MC_SEQ_BIT_REMAP_B2_D1__BIT6_MASK 0x1c0000
#define MC_SEQ_BIT_REMAP_B2_D1__BIT6__SHIFT 0x12
#define MC_SEQ_BIT_REMAP_B2_D1__BIT7_MASK 0xe00000
#define MC_SEQ_BIT_REMAP_B2_D1__BIT7__SHIFT 0x15
#define MC_SEQ_BIT_REMAP_B3_D1__BIT0_MASK 0x7
#define MC_SEQ_BIT_REMAP_B3_D1__BIT0__SHIFT 0x0
#define MC_SEQ_BIT_REMAP_B3_D1__BIT1_MASK 0x38
#define MC_SEQ_BIT_REMAP_B3_D1__BIT1__SHIFT 0x3
#define MC_SEQ_BIT_REMAP_B3_D1__BIT2_MASK 0x1c0
#define MC_SEQ_BIT_REMAP_B3_D1__BIT2__SHIFT 0x6
#define MC_SEQ_BIT_REMAP_B3_D1__BIT3_MASK 0xe00
#define MC_SEQ_BIT_REMAP_B3_D1__BIT3__SHIFT 0x9
#define MC_SEQ_BIT_REMAP_B3_D1__BIT4_MASK 0x7000
#define MC_SEQ_BIT_REMAP_B3_D1__BIT4__SHIFT 0xc
#define MC_SEQ_BIT_REMAP_B3_D1__BIT5_MASK 0x38000
#define MC_SEQ_BIT_REMAP_B3_D1__BIT5__SHIFT 0xf
#define MC_SEQ_BIT_REMAP_B3_D1__BIT6_MASK 0x1c0000
#define MC_SEQ_BIT_REMAP_B3_D1__BIT6__SHIFT 0x12
#define MC_SEQ_BIT_REMAP_B3_D1__BIT7_MASK 0xe00000
#define MC_SEQ_BIT_REMAP_B3_D1__BIT7__SHIFT 0x15
#define MC_SEQ_RAS_TIMING_LP__TRCDW_MASK 0x1f
#define MC_SEQ_RAS_TIMING_LP__TRCDW__SHIFT 0x0
#define MC_SEQ_RAS_TIMING_LP__TRCDWA_MASK 0x3e0
#define MC_SEQ_RAS_TIMING_LP__TRCDWA__SHIFT 0x5
#define MC_SEQ_RAS_TIMING_LP__TRCDR_MASK 0x7c00
#define MC_SEQ_RAS_TIMING_LP__TRCDR__SHIFT 0xa
#define MC_SEQ_RAS_TIMING_LP__TRCDRA_MASK 0xf8000
#define MC_SEQ_RAS_TIMING_LP__TRCDRA__SHIFT 0xf
#define MC_SEQ_RAS_TIMING_LP__TRRD_MASK 0xf00000
#define MC_SEQ_RAS_TIMING_LP__TRRD__SHIFT 0x14
#define MC_SEQ_RAS_TIMING_LP__TRC_MASK 0x7f000000
#define MC_SEQ_RAS_TIMING_LP__TRC__SHIFT 0x18
#define MC_SEQ_CAS_TIMING_LP__TNOPW_MASK 0x3
#define MC_SEQ_CAS_TIMING_LP__TNOPW__SHIFT 0x0
#define MC_SEQ_CAS_TIMING_LP__TNOPR_MASK 0xc
#define MC_SEQ_CAS_TIMING_LP__TNOPR__SHIFT 0x2
#define MC_SEQ_CAS_TIMING_LP__TR2W_MASK 0x1f0
#define MC_SEQ_CAS_TIMING_LP__TR2W__SHIFT 0x4
#define MC_SEQ_CAS_TIMING_LP__TCCDL_MASK 0xe00
#define MC_SEQ_CAS_TIMING_LP__TCCDL__SHIFT 0x9
#define MC_SEQ_CAS_TIMING_LP__TR2R_MASK 0xf000
#define MC_SEQ_CAS_TIMING_LP__TR2R__SHIFT 0xc
#define MC_SEQ_CAS_TIMING_LP__TW2R_MASK 0x1f0000
#define MC_SEQ_CAS_TIMING_LP__TW2R__SHIFT 0x10
#define MC_SEQ_CAS_TIMING_LP__TCL_MASK 0x1f000000
#define MC_SEQ_CAS_TIMING_LP__TCL__SHIFT 0x18
#define MC_SEQ_MISC_TIMING_LP__TRP_WRA_MASK 0x3f
#define MC_SEQ_MISC_TIMING_LP__TRP_WRA__SHIFT 0x0
#define MC_SEQ_MISC_TIMING_LP__TRP_RDA_MASK 0x3f00
#define MC_SEQ_MISC_TIMING_LP__TRP_RDA__SHIFT 0x8
#define MC_SEQ_MISC_TIMING_LP__TRP_MASK 0xf8000
#define MC_SEQ_MISC_TIMING_LP__TRP__SHIFT 0xf
#define MC_SEQ_MISC_TIMING_LP__TRFC_MASK 0x1ff00000
#define MC_SEQ_MISC_TIMING_LP__TRFC__SHIFT 0x14
#define MC_SEQ_MISC_TIMING2_LP__PA2RDATA_MASK 0x7
#define MC_SEQ_MISC_TIMING2_LP__PA2RDATA__SHIFT 0x0
#define MC_SEQ_MISC_TIMING2_LP__PA2WDATA_MASK 0x70
#define MC_SEQ_MISC_TIMING2_LP__PA2WDATA__SHIFT 0x4
#define MC_SEQ_MISC_TIMING2_LP__FAW_MASK 0x1f00
#define MC_SEQ_MISC_TIMING2_LP__FAW__SHIFT 0x8
#define MC_SEQ_MISC_TIMING2_LP__TREDC_MASK 0xe000
#define MC_SEQ_MISC_TIMING2_LP__TREDC__SHIFT 0xd
#define MC_SEQ_MISC_TIMING2_LP__TWEDC_MASK 0x1f0000
#define MC_SEQ_MISC_TIMING2_LP__TWEDC__SHIFT 0x10
#define MC_SEQ_MISC_TIMING2_LP__TADR_MASK 0xe00000
#define MC_SEQ_MISC_TIMING2_LP__TADR__SHIFT 0x15
#define MC_SEQ_MISC_TIMING2_LP__TFCKTR_MASK 0xf000000
#define MC_SEQ_MISC_TIMING2_LP__TFCKTR__SHIFT 0x18
#define MC_SEQ_MISC_TIMING2_LP__TWDATATR_MASK 0xf0000000
#define MC_SEQ_MISC_TIMING2_LP__TWDATATR__SHIFT 0x1c
#define MC_SEQ_RD_CTL_D0_LP__RCV_DLY_MASK 0x7
#define MC_SEQ_RD_CTL_D0_LP__RCV_DLY__SHIFT 0x0
#define MC_SEQ_RD_CTL_D0_LP__RCV_EXT_MASK 0xf8
#define MC_SEQ_RD_CTL_D0_LP__RCV_EXT__SHIFT 0x3
#define MC_SEQ_RD_CTL_D0_LP__RST_SEL_MASK 0x300
#define MC_SEQ_RD_CTL_D0_LP__RST_SEL__SHIFT 0x8
#define MC_SEQ_RD_CTL_D0_LP__RXDPWRON_DLY_MASK 0xc00
#define MC_SEQ_RD_CTL_D0_LP__RXDPWRON_DLY__SHIFT 0xa
#define MC_SEQ_RD_CTL_D0_LP__RST_HLD_MASK 0xf000
#define MC_SEQ_RD_CTL_D0_LP__RST_HLD__SHIFT 0xc
#define MC_SEQ_RD_CTL_D0_LP__STR_PRE_MASK 0x10000
#define MC_SEQ_RD_CTL_D0_LP__STR_PRE__SHIFT 0x10
#define MC_SEQ_RD_CTL_D0_LP__STR_PST_MASK 0x20000
#define MC_SEQ_RD_CTL_D0_LP__STR_PST__SHIFT 0x11
#define MC_SEQ_RD_CTL_D0_LP__RBS_DLY_MASK 0x1f00000
#define MC_SEQ_RD_CTL_D0_LP__RBS_DLY__SHIFT 0x14
#define MC_SEQ_RD_CTL_D0_LP__RBS_WEDC_DLY_MASK 0x3e000000
#define MC_SEQ_RD_CTL_D0_LP__RBS_WEDC_DLY__SHIFT 0x19
#define MC_SEQ_RD_CTL_D1_LP__RCV_DLY_MASK 0x7
#define MC_SEQ_RD_CTL_D1_LP__RCV_DLY__SHIFT 0x0
#define MC_SEQ_RD_CTL_D1_LP__RCV_EXT_MASK 0xf8
#define MC_SEQ_RD_CTL_D1_LP__RCV_EXT__SHIFT 0x3
#define MC_SEQ_RD_CTL_D1_LP__RST_SEL_MASK 0x300
#define MC_SEQ_RD_CTL_D1_LP__RST_SEL__SHIFT 0x8
#define MC_SEQ_RD_CTL_D1_LP__RXDPWRON_DLY_MASK 0xc00
#define MC_SEQ_RD_CTL_D1_LP__RXDPWRON_DLY__SHIFT 0xa
#define MC_SEQ_RD_CTL_D1_LP__RST_HLD_MASK 0xf000
#define MC_SEQ_RD_CTL_D1_LP__RST_HLD__SHIFT 0xc
#define MC_SEQ_RD_CTL_D1_LP__STR_PRE_MASK 0x10000
#define MC_SEQ_RD_CTL_D1_LP__STR_PRE__SHIFT 0x10
#define MC_SEQ_RD_CTL_D1_LP__STR_PST_MASK 0x20000
#define MC_SEQ_RD_CTL_D1_LP__STR_PST__SHIFT 0x11
#define MC_SEQ_RD_CTL_D1_LP__RBS_DLY_MASK 0x1f00000
#define MC_SEQ_RD_CTL_D1_LP__RBS_DLY__SHIFT 0x14
#define MC_SEQ_RD_CTL_D1_LP__RBS_WEDC_DLY_MASK 0x3e000000
#define MC_SEQ_RD_CTL_D1_LP__RBS_WEDC_DLY__SHIFT 0x19
#define MC_SEQ_WR_CTL_D0_LP__DAT_DLY_MASK 0xf
#define MC_SEQ_WR_CTL_D0_LP__DAT_DLY__SHIFT 0x0
#define MC_SEQ_WR_CTL_D0_LP__DQS_DLY_MASK 0xf0
#define MC_SEQ_WR_CTL_D0_LP__DQS_DLY__SHIFT 0x4
#define MC_SEQ_WR_CTL_D0_LP__DQS_XTR_MASK 0x100
#define MC_SEQ_WR_CTL_D0_LP__DQS_XTR__SHIFT 0x8
#define MC_SEQ_WR_CTL_D0_LP__DAT_2Y_DLY_MASK 0x200
#define MC_SEQ_WR_CTL_D0_LP__DAT_2Y_DLY__SHIFT 0x9
#define MC_SEQ_WR_CTL_D0_LP__ADR_2Y_DLY_MASK 0x400
#define MC_SEQ_WR_CTL_D0_LP__ADR_2Y_DLY__SHIFT 0xa
#define MC_SEQ_WR_CTL_D0_LP__CMD_2Y_DLY_MASK 0x800
#define MC_SEQ_WR_CTL_D0_LP__CMD_2Y_DLY__SHIFT 0xb
#define MC_SEQ_WR_CTL_D0_LP__OEN_DLY_MASK 0xf000
#define MC_SEQ_WR_CTL_D0_LP__OEN_DLY__SHIFT 0xc
#define MC_SEQ_WR_CTL_D0_LP__OEN_EXT_MASK 0xf0000
#define MC_SEQ_WR_CTL_D0_LP__OEN_EXT__SHIFT 0x10
#define MC_SEQ_WR_CTL_D0_LP__OEN_SEL_MASK 0x300000
#define MC_SEQ_WR_CTL_D0_LP__OEN_SEL__SHIFT 0x14
#define MC_SEQ_WR_CTL_D0_LP__ODT_DLY_MASK 0xf000000
#define MC_SEQ_WR_CTL_D0_LP__ODT_DLY__SHIFT 0x18
#define MC_SEQ_WR_CTL_D0_LP__ODT_EXT_MASK 0x10000000
#define MC_SEQ_WR_CTL_D0_LP__ODT_EXT__SHIFT 0x1c
#define MC_SEQ_WR_CTL_D0_LP__ADR_DLY_MASK 0x20000000
#define MC_SEQ_WR_CTL_D0_LP__ADR_DLY__SHIFT 0x1d
#define MC_SEQ_WR_CTL_D0_LP__CMD_DLY_MASK 0x40000000
#define MC_SEQ_WR_CTL_D0_LP__CMD_DLY__SHIFT 0x1e
#define MC_SEQ_WR_CTL_D1_LP__DAT_DLY_MASK 0xf
#define MC_SEQ_WR_CTL_D1_LP__DAT_DLY__SHIFT 0x0
#define MC_SEQ_WR_CTL_D1_LP__DQS_DLY_MASK 0xf0
#define MC_SEQ_WR_CTL_D1_LP__DQS_DLY__SHIFT 0x4
#define MC_SEQ_WR_CTL_D1_LP__DQS_XTR_MASK 0x100
#define MC_SEQ_WR_CTL_D1_LP__DQS_XTR__SHIFT 0x8
#define MC_SEQ_WR_CTL_D1_LP__DAT_2Y_DLY_MASK 0x200
#define MC_SEQ_WR_CTL_D1_LP__DAT_2Y_DLY__SHIFT 0x9
#define MC_SEQ_WR_CTL_D1_LP__ADR_2Y_DLY_MASK 0x400
#define MC_SEQ_WR_CTL_D1_LP__ADR_2Y_DLY__SHIFT 0xa
#define MC_SEQ_WR_CTL_D1_LP__CMD_2Y_DLY_MASK 0x800
#define MC_SEQ_WR_CTL_D1_LP__CMD_2Y_DLY__SHIFT 0xb
#define MC_SEQ_WR_CTL_D1_LP__OEN_DLY_MASK 0xf000
#define MC_SEQ_WR_CTL_D1_LP__OEN_DLY__SHIFT 0xc
#define MC_SEQ_WR_CTL_D1_LP__OEN_EXT_MASK 0xf0000
#define MC_SEQ_WR_CTL_D1_LP__OEN_EXT__SHIFT 0x10
#define MC_SEQ_WR_CTL_D1_LP__OEN_SEL_MASK 0x300000
#define MC_SEQ_WR_CTL_D1_LP__OEN_SEL__SHIFT 0x14
#define MC_SEQ_WR_CTL_D1_LP__ODT_DLY_MASK 0xf000000
#define MC_SEQ_WR_CTL_D1_LP__ODT_DLY__SHIFT 0x18
#define MC_SEQ_WR_CTL_D1_LP__ODT_EXT_MASK 0x10000000
#define MC_SEQ_WR_CTL_D1_LP__ODT_EXT__SHIFT 0x1c
#define MC_SEQ_WR_CTL_D1_LP__ADR_DLY_MASK 0x20000000
#define MC_SEQ_WR_CTL_D1_LP__ADR_DLY__SHIFT 0x1d
#define MC_SEQ_WR_CTL_D1_LP__CMD_DLY_MASK 0x40000000
#define MC_SEQ_WR_CTL_D1_LP__CMD_DLY__SHIFT 0x1e
#define MC_SEQ_WR_CTL_2_LP__DAT_DLY_H_D0_MASK 0x1
#define MC_SEQ_WR_CTL_2_LP__DAT_DLY_H_D0__SHIFT 0x0
#define MC_SEQ_WR_CTL_2_LP__DQS_DLY_H_D0_MASK 0x2
#define MC_SEQ_WR_CTL_2_LP__DQS_DLY_H_D0__SHIFT 0x1
#define MC_SEQ_WR_CTL_2_LP__OEN_DLY_H_D0_MASK 0x4
#define MC_SEQ_WR_CTL_2_LP__OEN_DLY_H_D0__SHIFT 0x2
#define MC_SEQ_WR_CTL_2_LP__DAT_DLY_H_D1_MASK 0x8
#define MC_SEQ_WR_CTL_2_LP__DAT_DLY_H_D1__SHIFT 0x3
#define MC_SEQ_WR_CTL_2_LP__DQS_DLY_H_D1_MASK 0x10
#define MC_SEQ_WR_CTL_2_LP__DQS_DLY_H_D1__SHIFT 0x4
#define MC_SEQ_WR_CTL_2_LP__OEN_DLY_H_D1_MASK 0x20
#define MC_SEQ_WR_CTL_2_LP__OEN_DLY_H_D1__SHIFT 0x5
#define MC_SEQ_WR_CTL_2_LP__WCDR_EN_MASK 0x40
#define MC_SEQ_WR_CTL_2_LP__WCDR_EN__SHIFT 0x6
#define MC_SEQ_PMG_CMD_EMRS_LP__ADR_MASK 0xffff
#define MC_SEQ_PMG_CMD_EMRS_LP__ADR__SHIFT 0x0
#define MC_SEQ_PMG_CMD_EMRS_LP__MOP_MASK 0x70000
#define MC_SEQ_PMG_CMD_EMRS_LP__MOP__SHIFT 0x10
#define MC_SEQ_PMG_CMD_EMRS_LP__BNK_MSB_MASK 0x80000
#define MC_SEQ_PMG_CMD_EMRS_LP__BNK_MSB__SHIFT 0x13
#define MC_SEQ_PMG_CMD_EMRS_LP__END_MASK 0x100000
#define MC_SEQ_PMG_CMD_EMRS_LP__END__SHIFT 0x14
#define MC_SEQ_PMG_CMD_EMRS_LP__CSB_MASK 0x600000
#define MC_SEQ_PMG_CMD_EMRS_LP__CSB__SHIFT 0x15
#define MC_SEQ_PMG_CMD_EMRS_LP__ADR_MSB1_MASK 0x10000000
#define MC_SEQ_PMG_CMD_EMRS_LP__ADR_MSB1__SHIFT 0x1c
#define MC_SEQ_PMG_CMD_EMRS_LP__ADR_MSB0_MASK 0x20000000
#define MC_SEQ_PMG_CMD_EMRS_LP__ADR_MSB0__SHIFT 0x1d
#define MC_SEQ_PMG_CMD_MRS_LP__ADR_MASK 0xffff
#define MC_SEQ_PMG_CMD_MRS_LP__ADR__SHIFT 0x0
#define MC_SEQ_PMG_CMD_MRS_LP__MOP_MASK 0x70000
#define MC_SEQ_PMG_CMD_MRS_LP__MOP__SHIFT 0x10
#define MC_SEQ_PMG_CMD_MRS_LP__BNK_MSB_MASK 0x80000
#define MC_SEQ_PMG_CMD_MRS_LP__BNK_MSB__SHIFT 0x13
#define MC_SEQ_PMG_CMD_MRS_LP__END_MASK 0x100000
#define MC_SEQ_PMG_CMD_MRS_LP__END__SHIFT 0x14
#define MC_SEQ_PMG_CMD_MRS_LP__CSB_MASK 0x600000
#define MC_SEQ_PMG_CMD_MRS_LP__CSB__SHIFT 0x15
#define MC_SEQ_PMG_CMD_MRS_LP__ADR_MSB1_MASK 0x10000000
#define MC_SEQ_PMG_CMD_MRS_LP__ADR_MSB1__SHIFT 0x1c
#define MC_SEQ_PMG_CMD_MRS_LP__ADR_MSB0_MASK 0x20000000
#define MC_SEQ_PMG_CMD_MRS_LP__ADR_MSB0__SHIFT 0x1d
#define MC_SEQ_PMG_CMD_MRS1_LP__ADR_MASK 0xffff
#define MC_SEQ_PMG_CMD_MRS1_LP__ADR__SHIFT 0x0
#define MC_SEQ_PMG_CMD_MRS1_LP__MOP_MASK 0x70000
#define MC_SEQ_PMG_CMD_MRS1_LP__MOP__SHIFT 0x10
#define MC_SEQ_PMG_CMD_MRS1_LP__BNK_MSB_MASK 0x80000
#define MC_SEQ_PMG_CMD_MRS1_LP__BNK_MSB__SHIFT 0x13
#define MC_SEQ_PMG_CMD_MRS1_LP__END_MASK 0x100000
#define MC_SEQ_PMG_CMD_MRS1_LP__END__SHIFT 0x14
#define MC_SEQ_PMG_CMD_MRS1_LP__CSB_MASK 0x600000
#define MC_SEQ_PMG_CMD_MRS1_LP__CSB__SHIFT 0x15
#define MC_SEQ_PMG_CMD_MRS1_LP__ADR_MSB1_MASK 0x10000000
#define MC_SEQ_PMG_CMD_MRS1_LP__ADR_MSB1__SHIFT 0x1c
#define MC_SEQ_PMG_CMD_MRS1_LP__ADR_MSB0_MASK 0x20000000
#define MC_SEQ_PMG_CMD_MRS1_LP__ADR_MSB0__SHIFT 0x1d
#define MC_SEQ_PMG_CMD_MRS2_LP__ADR_MASK 0xffff
#define MC_SEQ_PMG_CMD_MRS2_LP__ADR__SHIFT 0x0
#define MC_SEQ_PMG_CMD_MRS2_LP__MOP_MASK 0x70000
#define MC_SEQ_PMG_CMD_MRS2_LP__MOP__SHIFT 0x10
#define MC_SEQ_PMG_CMD_MRS2_LP__BNK_MSB_MASK 0x80000
#define MC_SEQ_PMG_CMD_MRS2_LP__BNK_MSB__SHIFT 0x13
#define MC_SEQ_PMG_CMD_MRS2_LP__END_MASK 0x100000
#define MC_SEQ_PMG_CMD_MRS2_LP__END__SHIFT 0x14
#define MC_SEQ_PMG_CMD_MRS2_LP__CSB_MASK 0x600000
#define MC_SEQ_PMG_CMD_MRS2_LP__CSB__SHIFT 0x15
#define MC_SEQ_PMG_CMD_MRS2_LP__ADR_MSB1_MASK 0x10000000
#define MC_SEQ_PMG_CMD_MRS2_LP__ADR_MSB1__SHIFT 0x1c
#define MC_SEQ_PMG_CMD_MRS2_LP__ADR_MSB0_MASK 0x20000000
#define MC_SEQ_PMG_CMD_MRS2_LP__ADR_MSB0__SHIFT 0x1d
#define MC_SEQ_PMG_TIMING_LP__TCKSRE_MASK 0x7
#define MC_SEQ_PMG_TIMING_LP__TCKSRE__SHIFT 0x0
#define MC_SEQ_PMG_TIMING_LP__TCKSRX_MASK 0x70
#define MC_SEQ_PMG_TIMING_LP__TCKSRX__SHIFT 0x4
#define MC_SEQ_PMG_TIMING_LP__TCKE_PULSE_MASK 0xf00
#define MC_SEQ_PMG_TIMING_LP__TCKE_PULSE__SHIFT 0x8
#define MC_SEQ_PMG_TIMING_LP__TCKE_MASK 0x3f000
#define MC_SEQ_PMG_TIMING_LP__TCKE__SHIFT 0xc
#define MC_SEQ_PMG_TIMING_LP__SEQ_IDLE_MASK 0x1c0000
#define MC_SEQ_PMG_TIMING_LP__SEQ_IDLE__SHIFT 0x12
#define MC_SEQ_PMG_TIMING_LP__TCKE_PULSE_MSB_MASK 0x800000
#define MC_SEQ_PMG_TIMING_LP__TCKE_PULSE_MSB__SHIFT 0x17
#define MC_SEQ_PMG_TIMING_LP__SEQ_IDLE_SS_MASK 0xff000000
#define MC_SEQ_PMG_TIMING_LP__SEQ_IDLE_SS__SHIFT 0x18
#define MC_SEQ_IO_RWORD0__RDATA_MASK 0xffffffff
#define MC_SEQ_IO_RWORD0__RDATA__SHIFT 0x0
#define MC_SEQ_IO_RWORD1__RDATA_MASK 0xffffffff
#define MC_SEQ_IO_RWORD1__RDATA__SHIFT 0x0
#define MC_SEQ_IO_RWORD2__RDATA_MASK 0xffffffff
#define MC_SEQ_IO_RWORD2__RDATA__SHIFT 0x0
#define MC_SEQ_IO_RWORD3__RDATA_MASK 0xffffffff
#define MC_SEQ_IO_RWORD3__RDATA__SHIFT 0x0
#define MC_SEQ_IO_RWORD4__RDATA_MASK 0xffffffff
#define MC_SEQ_IO_RWORD4__RDATA__SHIFT 0x0
#define MC_SEQ_IO_RWORD5__RDATA_MASK 0xffffffff
#define MC_SEQ_IO_RWORD5__RDATA__SHIFT 0x0
#define MC_SEQ_IO_RWORD6__RDATA_MASK 0xffffffff
#define MC_SEQ_IO_RWORD6__RDATA__SHIFT 0x0
#define MC_SEQ_IO_RWORD7__RDATA_MASK 0xffffffff
#define MC_SEQ_IO_RWORD7__RDATA__SHIFT 0x0
#define MC_SEQ_IO_RDBI__MASK_MASK 0xffffffff
#define MC_SEQ_IO_RDBI__MASK__SHIFT 0x0
#define MC_SEQ_IO_REDC__EDC_MASK 0xffffffff
#define MC_SEQ_IO_REDC__EDC__SHIFT 0x0
#define MC_SEQ_TCG_CNTL__RESET_MASK 0x1
#define MC_SEQ_TCG_CNTL__RESET__SHIFT 0x0
#define MC_SEQ_TCG_CNTL__ENABLE_D0_MASK 0x2
#define MC_SEQ_TCG_CNTL__ENABLE_D0__SHIFT 0x1
#define MC_SEQ_TCG_CNTL__ENABLE_D1_MASK 0x4
#define MC_SEQ_TCG_CNTL__ENABLE_D1__SHIFT 0x2
#define MC_SEQ_TCG_CNTL__START_MASK 0x8
#define MC_SEQ_TCG_CNTL__START__SHIFT 0x3
#define MC_SEQ_TCG_CNTL__NFIFO_MASK 0x70
#define MC_SEQ_TCG_CNTL__NFIFO__SHIFT 0x4
#define MC_SEQ_TCG_CNTL__INFINITE_CMD_MASK 0x80
#define MC_SEQ_TCG_CNTL__INFINITE_CMD__SHIFT 0x7
#define MC_SEQ_TCG_CNTL__MOP_MASK 0xf00
#define MC_SEQ_TCG_CNTL__MOP__SHIFT 0x8
#define MC_SEQ_TCG_CNTL__DATA_CNT_MASK 0xf000
#define MC_SEQ_TCG_CNTL__DATA_CNT__SHIFT 0xc
#define MC_SEQ_TCG_CNTL__LOAD_FIFO_MASK 0x10000
#define MC_SEQ_TCG_CNTL__LOAD_FIFO__SHIFT 0x10
#define MC_SEQ_TCG_CNTL__SHORT_LDFF_MASK 0x20000
#define MC_SEQ_TCG_CNTL__SHORT_LDFF__SHIFT 0x11
#define MC_SEQ_TCG_CNTL__FRAME_TRAIN_MASK 0x40000
#define MC_SEQ_TCG_CNTL__FRAME_TRAIN__SHIFT 0x12
#define MC_SEQ_TCG_CNTL__BURST_NUM_MASK 0x380000
#define MC_SEQ_TCG_CNTL__BURST_NUM__SHIFT 0x13
#define MC_SEQ_TCG_CNTL__ISSUE_AREF_MASK 0x400000
#define MC_SEQ_TCG_CNTL__ISSUE_AREF__SHIFT 0x16
#define MC_SEQ_TCG_CNTL__TXDBI_CNTL_MASK 0x800000
#define MC_SEQ_TCG_CNTL__TXDBI_CNTL__SHIFT 0x17
#define MC_SEQ_TCG_CNTL__VPTR_MASK_MASK 0x1000000
#define MC_SEQ_TCG_CNTL__VPTR_MASK__SHIFT 0x18
#define MC_SEQ_TCG_CNTL__AREF_LAST_MASK 0x2000000
#define MC_SEQ_TCG_CNTL__AREF_LAST__SHIFT 0x19
#define MC_SEQ_TCG_CNTL__AREF_BOTH_MASK 0x4000000
#define MC_SEQ_TCG_CNTL__AREF_BOTH__SHIFT 0x1a
#define MC_SEQ_TCG_CNTL__LD_RTDATA_OVR_MASK 0x10000000
#define MC_SEQ_TCG_CNTL__LD_RTDATA_OVR__SHIFT 0x1c
#define MC_SEQ_TCG_CNTL__LD_RTDATA_CH_MASK 0x20000000
#define MC_SEQ_TCG_CNTL__LD_RTDATA_CH__SHIFT 0x1d
#define MC_SEQ_TCG_CNTL__DONE_MASK 0x80000000
#define MC_SEQ_TCG_CNTL__DONE__SHIFT 0x1f
#define MC_SEQ_TSM_CTRL__START_MASK 0x1
#define MC_SEQ_TSM_CTRL__START__SHIFT 0x0
#define MC_SEQ_TSM_CTRL__CAPTURE_START_MASK 0x2
#define MC_SEQ_TSM_CTRL__CAPTURE_START__SHIFT 0x1
#define MC_SEQ_TSM_CTRL__DONE_MASK 0x4
#define MC_SEQ_TSM_CTRL__DONE__SHIFT 0x2
#define MC_SEQ_TSM_CTRL__ERR_MASK 0x8
#define MC_SEQ_TSM_CTRL__ERR__SHIFT 0x3
#define MC_SEQ_TSM_CTRL__STEP_MASK 0x10
#define MC_SEQ_TSM_CTRL__STEP__SHIFT 0x4
#define MC_SEQ_TSM_CTRL__DIRECTION_MASK 0x20
#define MC_SEQ_TSM_CTRL__DIRECTION__SHIFT 0x5
#define MC_SEQ_TSM_CTRL__INVERT_MASK 0x40
#define MC_SEQ_TSM_CTRL__INVERT__SHIFT 0x6
#define MC_SEQ_TSM_CTRL__MASK_BITS_MASK 0x80
#define MC_SEQ_TSM_CTRL__MASK_BITS__SHIFT 0x7
#define MC_SEQ_TSM_CTRL__UPDATE_LOOP_MASK 0x300
#define MC_SEQ_TSM_CTRL__UPDATE_LOOP__SHIFT 0x8
#define MC_SEQ_TSM_CTRL__ROT_INV_MASK 0x400
#define MC_SEQ_TSM_CTRL__ROT_INV__SHIFT 0xa
#define MC_SEQ_TSM_CTRL__DUAL_CH_EN_MASK 0x800
#define MC_SEQ_TSM_CTRL__DUAL_CH_EN__SHIFT 0xb
#define MC_SEQ_TSM_CTRL__DONE0_MASK 0x1000
#define MC_SEQ_TSM_CTRL__DONE0__SHIFT 0xc
#define MC_SEQ_TSM_CTRL__DONE1_MASK 0x2000
#define MC_SEQ_TSM_CTRL__DONE1__SHIFT 0xd
#define MC_SEQ_TSM_CTRL__POINTER_MASK 0xffff0000
#define MC_SEQ_TSM_CTRL__POINTER__SHIFT 0x10
#define MC_SEQ_TSM_GCNT__TRUE_ACT_MASK 0xf
#define MC_SEQ_TSM_GCNT__TRUE_ACT__SHIFT 0x0
#define MC_SEQ_TSM_GCNT__FALSE_ACT_MASK 0xf0
#define MC_SEQ_TSM_GCNT__FALSE_ACT__SHIFT 0x4
#define MC_SEQ_TSM_GCNT__TESTS_MASK 0xff00
#define MC_SEQ_TSM_GCNT__TESTS__SHIFT 0x8
#define MC_SEQ_TSM_GCNT__COMP_VALUE_MASK 0xffff0000
#define MC_SEQ_TSM_GCNT__COMP_VALUE__SHIFT 0x10
#define MC_SEQ_TSM_OCNT__TRUE_ACT_MASK 0xf
#define MC_SEQ_TSM_OCNT__TRUE_ACT__SHIFT 0x0
#define MC_SEQ_TSM_OCNT__FALSE_ACT_MASK 0xf0
#define MC_SEQ_TSM_OCNT__FALSE_ACT__SHIFT 0x4
#define MC_SEQ_TSM_OCNT__TESTS_MASK 0xff00
#define MC_SEQ_TSM_OCNT__TESTS__SHIFT 0x8
#define MC_SEQ_TSM_OCNT__CMP_VALUE_MASK 0xffff0000
#define MC_SEQ_TSM_OCNT__CMP_VALUE__SHIFT 0x10
#define MC_SEQ_TSM_NCNT__TRUE_ACT_MASK 0xf
#define MC_SEQ_TSM_NCNT__TRUE_ACT__SHIFT 0x0
#define MC_SEQ_TSM_NCNT__FALSE_ACT_MASK 0xf0
#define MC_SEQ_TSM_NCNT__FALSE_ACT__SHIFT 0x4
#define MC_SEQ_TSM_NCNT__TESTS_MASK 0xff00
#define MC_SEQ_TSM_NCNT__TESTS__SHIFT 0x8
#define MC_SEQ_TSM_NCNT__RANGE_LOW_MASK 0xf0000
#define MC_SEQ_TSM_NCNT__RANGE_LOW__SHIFT 0x10
#define MC_SEQ_TSM_NCNT__RANGE_HIGH_MASK 0xf00000
#define MC_SEQ_TSM_NCNT__RANGE_HIGH__SHIFT 0x14
#define MC_SEQ_TSM_NCNT__NIBBLE_SKIP_MASK 0xf000000
#define MC_SEQ_TSM_NCNT__NIBBLE_SKIP__SHIFT 0x18
#define MC_SEQ_TSM_BCNT__TRUE_ACT_MASK 0xf
#define MC_SEQ_TSM_BCNT__TRUE_ACT__SHIFT 0x0
#define MC_SEQ_TSM_BCNT__FALSE_ACT_MASK 0xf0
#define MC_SEQ_TSM_BCNT__FALSE_ACT__SHIFT 0x4
#define MC_SEQ_TSM_BCNT__BCNT_TESTS_MASK 0xff00
#define MC_SEQ_TSM_BCNT__BCNT_TESTS__SHIFT 0x8
#define MC_SEQ_TSM_BCNT__COMP_VALUE_MASK 0xff0000
#define MC_SEQ_TSM_BCNT__COMP_VALUE__SHIFT 0x10
#define MC_SEQ_TSM_BCNT__DONE_TESTS_MASK 0xff000000
#define MC_SEQ_TSM_BCNT__DONE_TESTS__SHIFT 0x18
#define MC_SEQ_TSM_FLAG__TRUE_ACT_MASK 0xf
#define MC_SEQ_TSM_FLAG__TRUE_ACT__SHIFT 0x0
#define MC_SEQ_TSM_FLAG__FALSE_ACT_MASK 0xf0
#define MC_SEQ_TSM_FLAG__FALSE_ACT__SHIFT 0x4
#define MC_SEQ_TSM_FLAG__FLAG_TESTS_MASK 0xff00
#define MC_SEQ_TSM_FLAG__FLAG_TESTS__SHIFT 0x8
#define MC_SEQ_TSM_FLAG__NBBL_MASK_MASK 0xf0000
#define MC_SEQ_TSM_FLAG__NBBL_MASK__SHIFT 0x10
#define MC_SEQ_TSM_FLAG__ERROR_TESTS_MASK 0xff000000
#define MC_SEQ_TSM_FLAG__ERROR_TESTS__SHIFT 0x18
#define MC_SEQ_TSM_UPDATE__TRUE_ACT_MASK 0xf
#define MC_SEQ_TSM_UPDATE__TRUE_ACT__SHIFT 0x0
#define MC_SEQ_TSM_UPDATE__FALSE_ACT_MASK 0xf0
#define MC_SEQ_TSM_UPDATE__FALSE_ACT__SHIFT 0x4
#define MC_SEQ_TSM_UPDATE__UPDT_TESTS_MASK 0xff00
#define MC_SEQ_TSM_UPDATE__UPDT_TESTS__SHIFT 0x8
#define MC_SEQ_TSM_UPDATE__AREF_COUNT_MASK 0xff0000
#define MC_SEQ_TSM_UPDATE__AREF_COUNT__SHIFT 0x10
#define MC_SEQ_TSM_UPDATE__CAPTR_TESTS_MASK 0xff000000
#define MC_SEQ_TSM_UPDATE__CAPTR_TESTS__SHIFT 0x18
#define MC_SEQ_TSM_EDC__EDC_MASK 0xffffffff
#define MC_SEQ_TSM_EDC__EDC__SHIFT 0x0
#define MC_SEQ_TSM_DBI__DBI_MASK 0xffffffff
#define MC_SEQ_TSM_DBI__DBI__SHIFT 0x0
#define MC_SEQ_TSM_WCDR__WCDR_MASK 0xffffffff
#define MC_SEQ_TSM_WCDR__WCDR__SHIFT 0x0
#define MC_SEQ_TSM_MISC__WCDR_PTR_MASK 0xffff
#define MC_SEQ_TSM_MISC__WCDR_PTR__SHIFT 0x0
#define MC_SEQ_TSM_MISC__WCDR_MASK_MASK 0xf0000
#define MC_SEQ_TSM_MISC__WCDR_MASK__SHIFT 0x10
#define MC_SEQ_TSM_MISC__CH1_OFFSET_MASK 0x3f00000
#define MC_SEQ_TSM_MISC__CH1_OFFSET__SHIFT 0x14
#define MC_SEQ_TSM_MISC__CH1_WCDR_OFFSET_MASK 0xfc000000
#define MC_SEQ_TSM_MISC__CH1_WCDR_OFFSET__SHIFT 0x1a
#define MC_SEQ_TIMER_WR__COUNTER_MASK 0xffffffff
#define MC_SEQ_TIMER_WR__COUNTER__SHIFT 0x0
#define MC_SEQ_TIMER_RD__COUNTER_MASK 0xffffffff
#define MC_SEQ_TIMER_RD__COUNTER__SHIFT 0x0
#define MC_SEQ_DRAM_ERROR_INSERTION__TX_MASK 0xffff
#define MC_SEQ_DRAM_ERROR_INSERTION__TX__SHIFT 0x0
#define MC_SEQ_DRAM_ERROR_INSERTION__RX_MASK 0xffff0000
#define MC_SEQ_DRAM_ERROR_INSERTION__RX__SHIFT 0x10
#define MC_PHY_TIMING_D0__RXC0_DLY_MASK 0xf
#define MC_PHY_TIMING_D0__RXC0_DLY__SHIFT 0x0
#define MC_PHY_TIMING_D0__RXC0_EXT_MASK 0xf0
#define MC_PHY_TIMING_D0__RXC0_EXT__SHIFT 0x4
#define MC_PHY_TIMING_D0__RXC1_DLY_MASK 0xf00
#define MC_PHY_TIMING_D0__RXC1_DLY__SHIFT 0x8
#define MC_PHY_TIMING_D0__RXC1_EXT_MASK 0xf000
#define MC_PHY_TIMING_D0__RXC1_EXT__SHIFT 0xc
#define MC_PHY_TIMING_D0__TXC0_DLY_MASK 0x70000
#define MC_PHY_TIMING_D0__TXC0_DLY__SHIFT 0x10
#define MC_PHY_TIMING_D0__TXC0_EXT_MASK 0xf00000
#define MC_PHY_TIMING_D0__TXC0_EXT__SHIFT 0x14
#define MC_PHY_TIMING_D0__TXC1_DLY_MASK 0x7000000
#define MC_PHY_TIMING_D0__TXC1_DLY__SHIFT 0x18
#define MC_PHY_TIMING_D0__TXC1_EXT_MASK 0xf0000000
#define MC_PHY_TIMING_D0__TXC1_EXT__SHIFT 0x1c
#define MC_PHY_TIMING_D1__RXC0_DLY_MASK 0xf
#define MC_PHY_TIMING_D1__RXC0_DLY__SHIFT 0x0
#define MC_PHY_TIMING_D1__RXC0_EXT_MASK 0xf0
#define MC_PHY_TIMING_D1__RXC0_EXT__SHIFT 0x4
#define MC_PHY_TIMING_D1__RXC1_DLY_MASK 0xf00
#define MC_PHY_TIMING_D1__RXC1_DLY__SHIFT 0x8
#define MC_PHY_TIMING_D1__RXC1_EXT_MASK 0xf000
#define MC_PHY_TIMING_D1__RXC1_EXT__SHIFT 0xc
#define MC_PHY_TIMING_D1__TXC0_DLY_MASK 0x70000
#define MC_PHY_TIMING_D1__TXC0_DLY__SHIFT 0x10
#define MC_PHY_TIMING_D1__TXC0_EXT_MASK 0xf00000
#define MC_PHY_TIMING_D1__TXC0_EXT__SHIFT 0x14
#define MC_PHY_TIMING_D1__TXC1_DLY_MASK 0x7000000
#define MC_PHY_TIMING_D1__TXC1_DLY__SHIFT 0x18
#define MC_PHY_TIMING_D1__TXC1_EXT_MASK 0xf0000000
#define MC_PHY_TIMING_D1__TXC1_EXT__SHIFT 0x1c
#define MC_PHY_TIMING_2__IND_LD_CNT_MASK 0x7f
#define MC_PHY_TIMING_2__IND_LD_CNT__SHIFT 0x0
#define MC_PHY_TIMING_2__RXC0_INV_MASK 0x100
#define MC_PHY_TIMING_2__RXC0_INV__SHIFT 0x8
#define MC_PHY_TIMING_2__RXC1_INV_MASK 0x200
#define MC_PHY_TIMING_2__RXC1_INV__SHIFT 0x9
#define MC_PHY_TIMING_2__TXC0_INV_MASK 0x400
#define MC_PHY_TIMING_2__TXC0_INV__SHIFT 0xa
#define MC_PHY_TIMING_2__TXC1_INV_MASK 0x800
#define MC_PHY_TIMING_2__TXC1_INV__SHIFT 0xb
#define MC_PHY_TIMING_2__RXC0_FRC_MASK 0x1000
#define MC_PHY_TIMING_2__RXC0_FRC__SHIFT 0xc
#define MC_PHY_TIMING_2__RXC1_FRC_MASK 0x2000
#define MC_PHY_TIMING_2__RXC1_FRC__SHIFT 0xd
#define MC_PHY_TIMING_2__TXC0_FRC_MASK 0x4000
#define MC_PHY_TIMING_2__TXC0_FRC__SHIFT 0xe
#define MC_PHY_TIMING_2__TXC1_FRC_MASK 0x8000
#define MC_PHY_TIMING_2__TXC1_FRC__SHIFT 0xf
#define MC_PHY_TIMING_2__TX_CDREN_D0_MASK 0x10000
#define MC_PHY_TIMING_2__TX_CDREN_D0__SHIFT 0x10
#define MC_PHY_TIMING_2__TX_CDREN_D1_MASK 0x20000
#define MC_PHY_TIMING_2__TX_CDREN_D1__SHIFT 0x11
#define MC_PHY_TIMING_2__ADR_CLKEN_D0_MASK 0x40000
#define MC_PHY_TIMING_2__ADR_CLKEN_D0__SHIFT 0x12
#define MC_PHY_TIMING_2__ADR_CLKEN_D1_MASK 0x80000
#define MC_PHY_TIMING_2__ADR_CLKEN_D1__SHIFT 0x13
#define MC_PHY_TIMING_2__WR_DLY_MASK 0xf00000
#define MC_PHY_TIMING_2__WR_DLY__SHIFT 0x14
#define MC_PHY_TIMING_2__RXDPWRONC0_FRC_MASK 0x1000000
#define MC_PHY_TIMING_2__RXDPWRONC0_FRC__SHIFT 0x18
#define MC_PHY_TIMING_2__RXDPWRONC1_FRC_MASK 0x2000000
#define MC_PHY_TIMING_2__RXDPWRONC1_FRC__SHIFT 0x19
#define MC_SEQ_MPLL_OVERRIDE__AD_PLL_RESET_OVERRIDE_MASK 0x1
#define MC_SEQ_MPLL_OVERRIDE__AD_PLL_RESET_OVERRIDE__SHIFT 0x0
#define MC_SEQ_MPLL_OVERRIDE__DQ_0_0_PLL_RESET_OVERRIDE_MASK 0x2
#define MC_SEQ_MPLL_OVERRIDE__DQ_0_0_PLL_RESET_OVERRIDE__SHIFT 0x1
#define MC_SEQ_MPLL_OVERRIDE__DQ_0_1_PLL_RESET_OVERRIDE_MASK 0x4
#define MC_SEQ_MPLL_OVERRIDE__DQ_0_1_PLL_RESET_OVERRIDE__SHIFT 0x2
#define MC_SEQ_MPLL_OVERRIDE__DQ_1_0_PLL_RESET_OVERRIDE_MASK 0x8
#define MC_SEQ_MPLL_OVERRIDE__DQ_1_0_PLL_RESET_OVERRIDE__SHIFT 0x3
#define MC_SEQ_MPLL_OVERRIDE__DQ_1_1_PLL_RESET_OVERRIDE_MASK 0x10
#define MC_SEQ_MPLL_OVERRIDE__DQ_1_1_PLL_RESET_OVERRIDE__SHIFT 0x4
#define MC_SEQ_MPLL_OVERRIDE__ATGM_CLK_SEL_OVERRIDE_MASK 0x20
#define MC_SEQ_MPLL_OVERRIDE__ATGM_CLK_SEL_OVERRIDE__SHIFT 0x5
#define MC_SEQ_MPLL_OVERRIDE__TEST_BYPASS_CLK_EN_OVERRIDE_MASK 0x40
#define MC_SEQ_MPLL_OVERRIDE__TEST_BYPASS_CLK_EN_OVERRIDE__SHIFT 0x6
#define MC_SEQ_MPLL_OVERRIDE__TEST_BYPASS_CLK_SEL_OVERRIDE_MASK 0x80
#define MC_SEQ_MPLL_OVERRIDE__TEST_BYPASS_CLK_SEL_OVERRIDE__SHIFT 0x7
#define MCLK_PWRMGT_CNTL__DLL_SPEED_MASK 0x1f
#define MCLK_PWRMGT_CNTL__DLL_SPEED__SHIFT 0x0
#define MCLK_PWRMGT_CNTL__DLL_READY_MASK 0x40
#define MCLK_PWRMGT_CNTL__DLL_READY__SHIFT 0x6
#define MCLK_PWRMGT_CNTL__MC_INT_CNTL_MASK 0x80
#define MCLK_PWRMGT_CNTL__MC_INT_CNTL__SHIFT 0x7
#define MCLK_PWRMGT_CNTL__MRDCK0_PDNB_MASK 0x100
#define MCLK_PWRMGT_CNTL__MRDCK0_PDNB__SHIFT 0x8
#define MCLK_PWRMGT_CNTL__MRDCK1_PDNB_MASK 0x200
#define MCLK_PWRMGT_CNTL__MRDCK1_PDNB__SHIFT 0x9
#define MCLK_PWRMGT_CNTL__MRDCK0_RESET_MASK 0x10000
#define MCLK_PWRMGT_CNTL__MRDCK0_RESET__SHIFT 0x10
#define MCLK_PWRMGT_CNTL__MRDCK1_RESET_MASK 0x20000
#define MCLK_PWRMGT_CNTL__MRDCK1_RESET__SHIFT 0x11
#define MCLK_PWRMGT_CNTL__DLL_READY_READ_MASK 0x1000000
#define MCLK_PWRMGT_CNTL__DLL_READY_READ__SHIFT 0x18
#define DLL_CNTL__DLL_RESET_TIME_MASK 0x3ff
#define DLL_CNTL__DLL_RESET_TIME__SHIFT 0x0
#define DLL_CNTL__DLL_LOCK_TIME_MASK 0x3ff000
#define DLL_CNTL__DLL_LOCK_TIME__SHIFT 0xc
#define DLL_CNTL__MRDCK0_BYPASS_MASK 0x1000000
#define DLL_CNTL__MRDCK0_BYPASS__SHIFT 0x18
#define DLL_CNTL__MRDCK1_BYPASS_MASK 0x2000000
#define DLL_CNTL__MRDCK1_BYPASS__SHIFT 0x19
#define DLL_CNTL__PWR2_MODE_MASK 0x4000000
#define DLL_CNTL__PWR2_MODE__SHIFT 0x1a
#define MPLL_SEQ_UCODE_1__INSTR0_MASK 0xf
#define MPLL_SEQ_UCODE_1__INSTR0__SHIFT 0x0
#define MPLL_SEQ_UCODE_1__INSTR1_MASK 0xf0
#define MPLL_SEQ_UCODE_1__INSTR1__SHIFT 0x4
#define MPLL_SEQ_UCODE_1__INSTR2_MASK 0xf00
#define MPLL_SEQ_UCODE_1__INSTR2__SHIFT 0x8
#define MPLL_SEQ_UCODE_1__INSTR3_MASK 0xf000
#define MPLL_SEQ_UCODE_1__INSTR3__SHIFT 0xc
#define MPLL_SEQ_UCODE_1__INSTR4_MASK 0xf0000
#define MPLL_SEQ_UCODE_1__INSTR4__SHIFT 0x10
#define MPLL_SEQ_UCODE_1__INSTR5_MASK 0xf00000
#define MPLL_SEQ_UCODE_1__INSTR5__SHIFT 0x14
#define MPLL_SEQ_UCODE_1__INSTR6_MASK 0xf000000
#define MPLL_SEQ_UCODE_1__INSTR6__SHIFT 0x18
#define MPLL_SEQ_UCODE_1__INSTR7_MASK 0xf0000000
#define MPLL_SEQ_UCODE_1__INSTR7__SHIFT 0x1c
#define MPLL_SEQ_UCODE_2__INSTR8_MASK 0xf
#define MPLL_SEQ_UCODE_2__INSTR8__SHIFT 0x0
#define MPLL_SEQ_UCODE_2__INSTR9_MASK 0xf0
#define MPLL_SEQ_UCODE_2__INSTR9__SHIFT 0x4
#define MPLL_SEQ_UCODE_2__INSTR10_MASK 0xf00
#define MPLL_SEQ_UCODE_2__INSTR10__SHIFT 0x8
#define MPLL_SEQ_UCODE_2__INSTR11_MASK 0xf000
#define MPLL_SEQ_UCODE_2__INSTR11__SHIFT 0xc
#define MPLL_SEQ_UCODE_2__INSTR12_MASK 0xf0000
#define MPLL_SEQ_UCODE_2__INSTR12__SHIFT 0x10
#define MPLL_SEQ_UCODE_2__INSTR13_MASK 0xf00000
#define MPLL_SEQ_UCODE_2__INSTR13__SHIFT 0x14
#define MPLL_SEQ_UCODE_2__INSTR14_MASK 0xf000000
#define MPLL_SEQ_UCODE_2__INSTR14__SHIFT 0x18
#define MPLL_SEQ_UCODE_2__INSTR15_MASK 0xf0000000
#define MPLL_SEQ_UCODE_2__INSTR15__SHIFT 0x1c
#define MPLL_CNTL_MODE__INSTR_DELAY_MASK 0xff
#define MPLL_CNTL_MODE__INSTR_DELAY__SHIFT 0x0
#define MPLL_CNTL_MODE__MPLL_SW_DIR_CONTROL_MASK 0x100
#define MPLL_CNTL_MODE__MPLL_SW_DIR_CONTROL__SHIFT 0x8
#define MPLL_CNTL_MODE__GDDR_PWRON_OVR_MASK 0x200
#define MPLL_CNTL_MODE__GDDR_PWRON_OVR__SHIFT 0x9
#define MPLL_CNTL_MODE__MPLL_MCLK_SEL_MASK 0x800
#define MPLL_CNTL_MODE__MPLL_MCLK_SEL__SHIFT 0xb
#define MPLL_CNTL_MODE__SPARE_1_MASK 0x1000
#define MPLL_CNTL_MODE__SPARE_1__SHIFT 0xc
#define MPLL_CNTL_MODE__QDR_MASK 0x2000
#define MPLL_CNTL_MODE__QDR__SHIFT 0xd
#define MPLL_CNTL_MODE__MPLL_CTLREQ_MASK 0x4000
#define MPLL_CNTL_MODE__MPLL_CTLREQ__SHIFT 0xe
#define MPLL_CNTL_MODE__MPLL_CHG_STATUS_MASK 0x10000
#define MPLL_CNTL_MODE__MPLL_CHG_STATUS__SHIFT 0x10
#define MPLL_CNTL_MODE__FORCE_TESTMODE_MASK 0x20000
#define MPLL_CNTL_MODE__FORCE_TESTMODE__SHIFT 0x11
#define MPLL_CNTL_MODE__FAST_LOCK_EN_MASK 0x100000
#define MPLL_CNTL_MODE__FAST_LOCK_EN__SHIFT 0x14
#define MPLL_CNTL_MODE__FAST_LOCK_CNTRL_MASK 0x600000
#define MPLL_CNTL_MODE__FAST_LOCK_CNTRL__SHIFT 0x15
#define MPLL_CNTL_MODE__SPARE_2_MASK 0x800000
#define MPLL_CNTL_MODE__SPARE_2__SHIFT 0x17
#define MPLL_CNTL_MODE__SS_SSEN_MASK 0x3000000
#define MPLL_CNTL_MODE__SS_SSEN__SHIFT 0x18
#define MPLL_CNTL_MODE__SS_DSMODE_EN_MASK 0x4000000
#define MPLL_CNTL_MODE__SS_DSMODE_EN__SHIFT 0x1a
#define MPLL_CNTL_MODE__VTOI_BIAS_CNTRL_MASK 0x8000000
#define MPLL_CNTL_MODE__VTOI_BIAS_CNTRL__SHIFT 0x1b
#define MPLL_CNTL_MODE__SPARE_3_MASK 0x70000000
#define MPLL_CNTL_MODE__SPARE_3__SHIFT 0x1c
#define MPLL_CNTL_MODE__GLOBAL_MPLL_RESET_MASK 0x80000000
#define MPLL_CNTL_MODE__GLOBAL_MPLL_RESET__SHIFT 0x1f
#define MPLL_FUNC_CNTL__SPARE_0_MASK 0x20
#define MPLL_FUNC_CNTL__SPARE_0__SHIFT 0x5
#define MPLL_FUNC_CNTL__BG_100ADJ_MASK 0xf00
#define MPLL_FUNC_CNTL__BG_100ADJ__SHIFT 0x8
#define MPLL_FUNC_CNTL__BG_135ADJ_MASK 0xf0000
#define MPLL_FUNC_CNTL__BG_135ADJ__SHIFT 0x10
#define MPLL_FUNC_CNTL__BWCTRL_MASK 0xff00000
#define MPLL_FUNC_CNTL__BWCTRL__SHIFT 0x14
#define MPLL_FUNC_CNTL__REG_BIAS_MASK 0xc0000000
#define MPLL_FUNC_CNTL__REG_BIAS__SHIFT 0x1e
#define MPLL_FUNC_CNTL_1__VCO_MODE_MASK 0x3
#define MPLL_FUNC_CNTL_1__VCO_MODE__SHIFT 0x0
#define MPLL_FUNC_CNTL_1__SPARE_0_MASK 0xc
#define MPLL_FUNC_CNTL_1__SPARE_0__SHIFT 0x2
#define MPLL_FUNC_CNTL_1__CLKFRAC_MASK 0xfff0
#define MPLL_FUNC_CNTL_1__CLKFRAC__SHIFT 0x4
#define MPLL_FUNC_CNTL_1__CLKF_MASK 0xfff0000
#define MPLL_FUNC_CNTL_1__CLKF__SHIFT 0x10
#define MPLL_FUNC_CNTL_1__SPARE_1_MASK 0xf0000000
#define MPLL_FUNC_CNTL_1__SPARE_1__SHIFT 0x1c
#define MPLL_FUNC_CNTL_2__VCTRLADC_EN_MASK 0x1
#define MPLL_FUNC_CNTL_2__VCTRLADC_EN__SHIFT 0x0
#define MPLL_FUNC_CNTL_2__TEST_VCTL_EN_MASK 0x2
#define MPLL_FUNC_CNTL_2__TEST_VCTL_EN__SHIFT 0x1
#define MPLL_FUNC_CNTL_2__RESET_EN_MASK 0x4
#define MPLL_FUNC_CNTL_2__RESET_EN__SHIFT 0x2
#define MPLL_FUNC_CNTL_2__TEST_BYPCLK_EN_MASK 0x8
#define MPLL_FUNC_CNTL_2__TEST_BYPCLK_EN__SHIFT 0x3
#define MPLL_FUNC_CNTL_2__TEST_BYPCLK_SRC_MASK 0x10
#define MPLL_FUNC_CNTL_2__TEST_BYPCLK_SRC__SHIFT 0x4
#define MPLL_FUNC_CNTL_2__TEST_FBDIV_FRAC_BYPASS_MASK 0x20
#define MPLL_FUNC_CNTL_2__TEST_FBDIV_FRAC_BYPASS__SHIFT 0x5
#define MPLL_FUNC_CNTL_2__TEST_BYPMCLK_MASK 0x40
#define MPLL_FUNC_CNTL_2__TEST_BYPMCLK__SHIFT 0x6
#define MPLL_FUNC_CNTL_2__MPLL_UNLOCK_CLEAR_MASK 0x80
#define MPLL_FUNC_CNTL_2__MPLL_UNLOCK_CLEAR__SHIFT 0x7
#define MPLL_FUNC_CNTL_2__TEST_VCTL_CNTRL_MASK 0x100
#define MPLL_FUNC_CNTL_2__TEST_VCTL_CNTRL__SHIFT 0x8
#define MPLL_FUNC_CNTL_2__TEST_FBDIV_SSC_BYPASS_MASK 0x200
#define MPLL_FUNC_CNTL_2__TEST_FBDIV_SSC_BYPASS__SHIFT 0x9
#define MPLL_FUNC_CNTL_2__RESET_TIMER_MASK 0xc00
#define MPLL_FUNC_CNTL_2__RESET_TIMER__SHIFT 0xa
#define MPLL_FUNC_CNTL_2__PFD_RESET_CNTRL_MASK 0x3000
#define MPLL_FUNC_CNTL_2__PFD_RESET_CNTRL__SHIFT 0xc
#define MPLL_FUNC_CNTL_2__RISEFBVCO_EN_MASK 0x4000
#define MPLL_FUNC_CNTL_2__RISEFBVCO_EN__SHIFT 0xe
#define MPLL_FUNC_CNTL_2__PWRGOOD_OVR_MASK 0x8000
#define MPLL_FUNC_CNTL_2__PWRGOOD_OVR__SHIFT 0xf
#define MPLL_FUNC_CNTL_2__ISO_DIS_P_MASK 0x10000
#define MPLL_FUNC_CNTL_2__ISO_DIS_P__SHIFT 0x10
#define MPLL_FUNC_CNTL_2__BACKUP_2_MASK 0xe0000
#define MPLL_FUNC_CNTL_2__BACKUP_2__SHIFT 0x11
#define MPLL_FUNC_CNTL_2__LF_CNTRL_MASK 0x7f00000
#define MPLL_FUNC_CNTL_2__LF_CNTRL__SHIFT 0x14
#define MPLL_FUNC_CNTL_2__BACKUP_MASK 0xf8000000
#define MPLL_FUNC_CNTL_2__BACKUP__SHIFT 0x1b
#define MPLL_AD_FUNC_CNTL__YCLK_POST_DIV_MASK 0x7
#define MPLL_AD_FUNC_CNTL__YCLK_POST_DIV__SHIFT 0x0
#define MPLL_AD_FUNC_CNTL__SPARE_MASK 0xfffffff8
#define MPLL_AD_FUNC_CNTL__SPARE__SHIFT 0x3
#define MPLL_DQ_FUNC_CNTL__YCLK_POST_DIV_MASK 0x7
#define MPLL_DQ_FUNC_CNTL__YCLK_POST_DIV__SHIFT 0x0
#define MPLL_DQ_FUNC_CNTL__SPARE_0_MASK 0x8
#define MPLL_DQ_FUNC_CNTL__SPARE_0__SHIFT 0x3
#define MPLL_DQ_FUNC_CNTL__YCLK_SEL_MASK 0x10
#define MPLL_DQ_FUNC_CNTL__YCLK_SEL__SHIFT 0x4
#define MPLL_DQ_FUNC_CNTL__SPARE_MASK 0xffffffe0
#define MPLL_DQ_FUNC_CNTL__SPARE__SHIFT 0x5
#define MPLL_TIME__MPLL_LOCK_TIME_MASK 0xffff
#define MPLL_TIME__MPLL_LOCK_TIME__SHIFT 0x0
#define MPLL_TIME__MPLL_RESET_TIME_MASK 0xffff0000
#define MPLL_TIME__MPLL_RESET_TIME__SHIFT 0x10
#define MPLL_SS1__CLKV_MASK 0x3ffffff
#define MPLL_SS1__CLKV__SHIFT 0x0
#define MPLL_SS1__SPARE_MASK 0xfc000000
#define MPLL_SS1__SPARE__SHIFT 0x1a
#define MPLL_SS2__CLKS_MASK 0xfff
#define MPLL_SS2__CLKS__SHIFT 0x0
#define MPLL_SS2__SPARE_MASK 0xfffff000
#define MPLL_SS2__SPARE__SHIFT 0xc
#define MPLL_CONTROL__GDDR_PWRON_MASK 0x1
#define MPLL_CONTROL__GDDR_PWRON__SHIFT 0x0
#define MPLL_CONTROL__REFCLK_PWRON_MASK 0x2
#define MPLL_CONTROL__REFCLK_PWRON__SHIFT 0x1
#define MPLL_CONTROL__PLL_BUF_PWRON_TX_MASK 0x4
#define MPLL_CONTROL__PLL_BUF_PWRON_TX__SHIFT 0x2
#define MPLL_CONTROL__AD_BG_PWRON_MASK 0x1000
#define MPLL_CONTROL__AD_BG_PWRON__SHIFT 0xc
#define MPLL_CONTROL__AD_PLL_PWRON_MASK 0x2000
#define MPLL_CONTROL__AD_PLL_PWRON__SHIFT 0xd
#define MPLL_CONTROL__AD_PLL_RESET_MASK 0x4000
#define MPLL_CONTROL__AD_PLL_RESET__SHIFT 0xe
#define MPLL_CONTROL__SPARE_AD_0_MASK 0x8000
#define MPLL_CONTROL__SPARE_AD_0__SHIFT 0xf
#define MPLL_CONTROL__DQ_0_0_BG_PWRON_MASK 0x10000
#define MPLL_CONTROL__DQ_0_0_BG_PWRON__SHIFT 0x10
#define MPLL_CONTROL__DQ_0_0_PLL_PWRON_MASK 0x20000
#define MPLL_CONTROL__DQ_0_0_PLL_PWRON__SHIFT 0x11
#define MPLL_CONTROL__DQ_0_0_PLL_RESET_MASK 0x40000
#define MPLL_CONTROL__DQ_0_0_PLL_RESET__SHIFT 0x12
#define MPLL_CONTROL__SPARE_DQ_0_0_MASK 0x80000
#define MPLL_CONTROL__SPARE_DQ_0_0__SHIFT 0x13
#define MPLL_CONTROL__DQ_0_1_BG_PWRON_MASK 0x100000
#define MPLL_CONTROL__DQ_0_1_BG_PWRON__SHIFT 0x14
#define MPLL_CONTROL__DQ_0_1_PLL_PWRON_MASK 0x200000
#define MPLL_CONTROL__DQ_0_1_PLL_PWRON__SHIFT 0x15
#define MPLL_CONTROL__DQ_0_1_PLL_RESET_MASK 0x400000
#define MPLL_CONTROL__DQ_0_1_PLL_RESET__SHIFT 0x16
#define MPLL_CONTROL__SPARE_DQ_0_1_MASK 0x800000
#define MPLL_CONTROL__SPARE_DQ_0_1__SHIFT 0x17
#define MPLL_CONTROL__DQ_1_0_BG_PWRON_MASK 0x1000000
#define MPLL_CONTROL__DQ_1_0_BG_PWRON__SHIFT 0x18
#define MPLL_CONTROL__DQ_1_0_PLL_PWRON_MASK 0x2000000
#define MPLL_CONTROL__DQ_1_0_PLL_PWRON__SHIFT 0x19
#define MPLL_CONTROL__DQ_1_0_PLL_RESET_MASK 0x4000000
#define MPLL_CONTROL__DQ_1_0_PLL_RESET__SHIFT 0x1a
#define MPLL_CONTROL__SPARE_DQ_1_0_MASK 0x8000000
#define MPLL_CONTROL__SPARE_DQ_1_0__SHIFT 0x1b
#define MPLL_CONTROL__DQ_1_1_BG_PWRON_MASK 0x10000000
#define MPLL_CONTROL__DQ_1_1_BG_PWRON__SHIFT 0x1c
#define MPLL_CONTROL__DQ_1_1_PLL_PWRON_MASK 0x20000000
#define MPLL_CONTROL__DQ_1_1_PLL_PWRON__SHIFT 0x1d
#define MPLL_CONTROL__DQ_1_1_PLL_RESET_MASK 0x40000000
#define MPLL_CONTROL__DQ_1_1_PLL_RESET__SHIFT 0x1e
#define MPLL_CONTROL__SPARE_DQ_1_1_MASK 0x80000000
#define MPLL_CONTROL__SPARE_DQ_1_1__SHIFT 0x1f
#define MPLL_AD_STATUS__VCTRLADC_MASK 0x7
#define MPLL_AD_STATUS__VCTRLADC__SHIFT 0x0
#define MPLL_AD_STATUS__TEST_FBDIV_FRAC_MASK 0x70
#define MPLL_AD_STATUS__TEST_FBDIV_FRAC__SHIFT 0x4
#define MPLL_AD_STATUS__TEST_FBDIV_INT_MASK 0x1ff80
#define MPLL_AD_STATUS__TEST_FBDIV_INT__SHIFT 0x7
#define MPLL_AD_STATUS__OINT_RESET_MASK 0x20000
#define MPLL_AD_STATUS__OINT_RESET__SHIFT 0x11
#define MPLL_AD_STATUS__FREQ_LOCK_MASK 0x40000
#define MPLL_AD_STATUS__FREQ_LOCK__SHIFT 0x12
#define MPLL_AD_STATUS__FREQ_UNLOCK_STICKY_MASK 0x80000
#define MPLL_AD_STATUS__FREQ_UNLOCK_STICKY__SHIFT 0x13
#define MPLL_DQ_0_0_STATUS__VCTRLADC_MASK 0x7
#define MPLL_DQ_0_0_STATUS__VCTRLADC__SHIFT 0x0
#define MPLL_DQ_0_0_STATUS__TEST_FBDIV_FRAC_MASK 0x70
#define MPLL_DQ_0_0_STATUS__TEST_FBDIV_FRAC__SHIFT 0x4
#define MPLL_DQ_0_0_STATUS__TEST_FBDIV_INT_MASK 0x1ff80
#define MPLL_DQ_0_0_STATUS__TEST_FBDIV_INT__SHIFT 0x7
#define MPLL_DQ_0_0_STATUS__OINT_RESET_MASK 0x20000
#define MPLL_DQ_0_0_STATUS__OINT_RESET__SHIFT 0x11
#define MPLL_DQ_0_0_STATUS__FREQ_LOCK_MASK 0x40000
#define MPLL_DQ_0_0_STATUS__FREQ_LOCK__SHIFT 0x12
#define MPLL_DQ_0_0_STATUS__FREQ_UNLOCK_STICKY_MASK 0x80000
#define MPLL_DQ_0_0_STATUS__FREQ_UNLOCK_STICKY__SHIFT 0x13
#define MPLL_DQ_0_1_STATUS__VCTRLADC_MASK 0x7
#define MPLL_DQ_0_1_STATUS__VCTRLADC__SHIFT 0x0
#define MPLL_DQ_0_1_STATUS__TEST_FBDIV_FRAC_MASK 0x70
#define MPLL_DQ_0_1_STATUS__TEST_FBDIV_FRAC__SHIFT 0x4
#define MPLL_DQ_0_1_STATUS__TEST_FBDIV_INT_MASK 0x1ff80
#define MPLL_DQ_0_1_STATUS__TEST_FBDIV_INT__SHIFT 0x7
#define MPLL_DQ_0_1_STATUS__OINT_RESET_MASK 0x20000
#define MPLL_DQ_0_1_STATUS__OINT_RESET__SHIFT 0x11
#define MPLL_DQ_0_1_STATUS__FREQ_LOCK_MASK 0x40000
#define MPLL_DQ_0_1_STATUS__FREQ_LOCK__SHIFT 0x12
#define MPLL_DQ_0_1_STATUS__FREQ_UNLOCK_STICKY_MASK 0x80000
#define MPLL_DQ_0_1_STATUS__FREQ_UNLOCK_STICKY__SHIFT 0x13
#define MPLL_DQ_1_0_STATUS__VCTRLADC_MASK 0x7
#define MPLL_DQ_1_0_STATUS__VCTRLADC__SHIFT 0x0
#define MPLL_DQ_1_0_STATUS__TEST_FBDIV_FRAC_MASK 0x70
#define MPLL_DQ_1_0_STATUS__TEST_FBDIV_FRAC__SHIFT 0x4
#define MPLL_DQ_1_0_STATUS__TEST_FBDIV_INT_MASK 0x1ff80
#define MPLL_DQ_1_0_STATUS__TEST_FBDIV_INT__SHIFT 0x7
#define MPLL_DQ_1_0_STATUS__OINT_RESET_MASK 0x20000
#define MPLL_DQ_1_0_STATUS__OINT_RESET__SHIFT 0x11
#define MPLL_DQ_1_0_STATUS__FREQ_LOCK_MASK 0x40000
#define MPLL_DQ_1_0_STATUS__FREQ_LOCK__SHIFT 0x12
#define MPLL_DQ_1_0_STATUS__FREQ_UNLOCK_STICKY_MASK 0x80000
#define MPLL_DQ_1_0_STATUS__FREQ_UNLOCK_STICKY__SHIFT 0x13
#define MPLL_DQ_1_1_STATUS__VCTRLADC_MASK 0x7
#define MPLL_DQ_1_1_STATUS__VCTRLADC__SHIFT 0x0
#define MPLL_DQ_1_1_STATUS__TEST_FBDIV_FRAC_MASK 0x70
#define MPLL_DQ_1_1_STATUS__TEST_FBDIV_FRAC__SHIFT 0x4
#define MPLL_DQ_1_1_STATUS__TEST_FBDIV_INT_MASK 0x1ff80
#define MPLL_DQ_1_1_STATUS__TEST_FBDIV_INT__SHIFT 0x7
#define MPLL_DQ_1_1_STATUS__OINT_RESET_MASK 0x20000
#define MPLL_DQ_1_1_STATUS__OINT_RESET__SHIFT 0x11
#define MPLL_DQ_1_1_STATUS__FREQ_LOCK_MASK 0x40000
#define MPLL_DQ_1_1_STATUS__FREQ_LOCK__SHIFT 0x12
#define MPLL_DQ_1_1_STATUS__FREQ_UNLOCK_STICKY_MASK 0x80000
#define MPLL_DQ_1_1_STATUS__FREQ_UNLOCK_STICKY__SHIFT 0x13
#define MC_SEQ_PMG_PG_HWCNTL__PWRGATE_EN_MASK 0x1
#define MC_SEQ_PMG_PG_HWCNTL__PWRGATE_EN__SHIFT 0x0
#define MC_SEQ_PMG_PG_HWCNTL__STAGGER_EN_MASK 0x2
#define MC_SEQ_PMG_PG_HWCNTL__STAGGER_EN__SHIFT 0x1
#define MC_SEQ_PMG_PG_HWCNTL__TPGCG_MASK 0x3c
#define MC_SEQ_PMG_PG_HWCNTL__TPGCG__SHIFT 0x2
#define MC_SEQ_PMG_PG_HWCNTL__D_DLY_MASK 0xc0
#define MC_SEQ_PMG_PG_HWCNTL__D_DLY__SHIFT 0x6
#define MC_SEQ_PMG_PG_HWCNTL__AC_DLY_MASK 0x300
#define MC_SEQ_PMG_PG_HWCNTL__AC_DLY__SHIFT 0x8
#define MC_SEQ_PMG_PG_HWCNTL__G_DLY_MASK 0x3c00
#define MC_SEQ_PMG_PG_HWCNTL__G_DLY__SHIFT 0xa
#define MC_SEQ_PMG_PG_HWCNTL__TXAO_MASK 0x10000
#define MC_SEQ_PMG_PG_HWCNTL__TXAO__SHIFT 0x10
#define MC_SEQ_PMG_PG_HWCNTL__RXAO_MASK 0x20000
#define MC_SEQ_PMG_PG_HWCNTL__RXAO__SHIFT 0x11
#define MC_SEQ_PMG_PG_HWCNTL__ACAO_MASK 0x40000
#define MC_SEQ_PMG_PG_HWCNTL__ACAO__SHIFT 0x12
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_DQ_TX_ENB_MASK 0x1
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_DQ_TX_ENB__SHIFT 0x0
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_DBI_TX_ENB_MASK 0x2
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_DBI_TX_ENB__SHIFT 0x1
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_EDC_TX_ENB_MASK 0x4
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_EDC_TX_ENB__SHIFT 0x2
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_WCLKX_TX_ENB_MASK 0x8
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_WCLKX_TX_ENB__SHIFT 0x3
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_DQ_RX_ENB_MASK 0x10
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_DQ_RX_ENB__SHIFT 0x4
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_DBI_RX_ENB_MASK 0x20
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_DBI_RX_ENB__SHIFT 0x5
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_EDC_RX_ENB_MASK 0x40
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_EDC_RX_ENB__SHIFT 0x6
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_WCLKX_RX_ENB_MASK 0x80
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD0_WCLKX_RX_ENB__SHIFT 0x7
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_DQ_TX_ENB_MASK 0x100
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_DQ_TX_ENB__SHIFT 0x8
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_DBI_TX_ENB_MASK 0x200
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_DBI_TX_ENB__SHIFT 0x9
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_EDC_TX_ENB_MASK 0x400
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_EDC_TX_ENB__SHIFT 0xa
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_WCLKX_TX_ENB_MASK 0x800
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_WCLKX_TX_ENB__SHIFT 0xb
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_DQ_RX_ENB_MASK 0x1000
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_DQ_RX_ENB__SHIFT 0xc
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_DBI_RX_ENB_MASK 0x2000
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_DBI_RX_ENB__SHIFT 0xd
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_EDC_RX_ENB_MASK 0x4000
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_EDC_RX_ENB__SHIFT 0xe
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_WCLKX_RX_ENB_MASK 0x8000
#define MC_SEQ_PMG_PG_SWCNTL_0__PMD1_WCLKX_RX_ENB__SHIFT 0xf
#define MC_SEQ_PMG_PG_SWCNTL_0__PMA0_AC_ENB_MASK 0x10000
#define MC_SEQ_PMG_PG_SWCNTL_0__PMA0_AC_ENB__SHIFT 0x10
#define MC_SEQ_PMG_PG_SWCNTL_0__GMCON_SR_COMMIT_MASK 0x80000000
#define MC_SEQ_PMG_PG_SWCNTL_0__GMCON_SR_COMMIT__SHIFT 0x1f
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_DQ_TX_ENB_MASK 0x1
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_DQ_TX_ENB__SHIFT 0x0
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_DBI_TX_ENB_MASK 0x2
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_DBI_TX_ENB__SHIFT 0x1
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_EDC_TX_ENB_MASK 0x4
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_EDC_TX_ENB__SHIFT 0x2
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_WCLKX_TX_ENB_MASK 0x8
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_WCLKX_TX_ENB__SHIFT 0x3
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_DQ_RX_ENB_MASK 0x10
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_DQ_RX_ENB__SHIFT 0x4
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_DBI_RX_ENB_MASK 0x20
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_DBI_RX_ENB__SHIFT 0x5
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_EDC_RX_ENB_MASK 0x40
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_EDC_RX_ENB__SHIFT 0x6
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_WCLKX_RX_ENB_MASK 0x80
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD2_WCLKX_RX_ENB__SHIFT 0x7
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_DQ_TX_ENB_MASK 0x100
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_DQ_TX_ENB__SHIFT 0x8
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_DBI_TX_ENB_MASK 0x200
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_DBI_TX_ENB__SHIFT 0x9
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_EDC_TX_ENB_MASK 0x400
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_EDC_TX_ENB__SHIFT 0xa
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_WCLKX_TX_ENB_MASK 0x800
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_WCLKX_TX_ENB__SHIFT 0xb
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_DQ_RX_ENB_MASK 0x1000
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_DQ_RX_ENB__SHIFT 0xc
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_DBI_RX_ENB_MASK 0x2000
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_DBI_RX_ENB__SHIFT 0xd
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_EDC_RX_ENB_MASK 0x4000
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_EDC_RX_ENB__SHIFT 0xe
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_WCLKX_RX_ENB_MASK 0x8000
#define MC_SEQ_PMG_PG_SWCNTL_1__PMD3_WCLKX_RX_ENB__SHIFT 0xf
#define MC_SEQ_PMG_PG_SWCNTL_1__PMA1_AC_ENB_MASK 0x10000
#define MC_SEQ_PMG_PG_SWCNTL_1__PMA1_AC_ENB__SHIFT 0x10
#define MC_SEQ_PMG_PG_SWCNTL_1__GMCON_SR_COMMIT_MASK 0x80000000
#define MC_SEQ_PMG_PG_SWCNTL_1__GMCON_SR_COMMIT__SHIFT 0x1f
#define MC_SEQ_TSM_DEBUG_INDEX__TSM_DEBUG_INDEX_MASK 0x1f
#define MC_SEQ_TSM_DEBUG_INDEX__TSM_DEBUG_INDEX__SHIFT 0x0
#define MC_SEQ_TSM_DEBUG_DATA__TSM_DEBUG_DATA_MASK 0xffffffff
#define MC_SEQ_TSM_DEBUG_DATA__TSM_DEBUG_DATA__SHIFT 0x0
#define MC_TSM_DEBUG_GCNT__DATA_MASK 0xffffffff
#define MC_TSM_DEBUG_GCNT__DATA__SHIFT 0x0
#define MC_TSM_DEBUG_FLAG__DATA_MASK 0xffffffff
#define MC_TSM_DEBUG_FLAG__DATA__SHIFT 0x0
#define MC_TSM_DEBUG_MISC__FLAG_MASK 0xff
#define MC_TSM_DEBUG_MISC__FLAG__SHIFT 0x0
#define MC_TSM_DEBUG_MISC__NCNT_RD_MASK 0xf00
#define MC_TSM_DEBUG_MISC__NCNT_RD__SHIFT 0x8
#define MC_TSM_DEBUG_MISC__NCNT_WR_MASK 0xf000
#define MC_TSM_DEBUG_MISC__NCNT_WR__SHIFT 0xc
#define MC_TSM_DEBUG_BCNT0__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT0__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT0__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT0__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT0__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT0__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT0__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT0__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT1__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT1__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT1__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT1__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT1__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT1__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT1__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT1__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT2__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT2__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT2__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT2__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT2__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT2__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT2__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT2__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT3__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT3__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT3__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT3__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT3__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT3__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT3__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT3__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT4__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT4__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT4__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT4__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT4__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT4__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT4__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT4__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT5__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT5__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT5__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT5__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT5__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT5__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT5__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT5__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT6__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT6__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT6__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT6__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT6__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT6__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT6__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT6__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT7__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT7__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT7__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT7__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT7__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT7__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT7__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT7__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT8__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT8__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT8__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT8__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT8__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT8__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT8__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT8__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT9__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT9__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT9__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT9__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT9__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT9__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT9__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT9__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_BCNT10__BYTE0_MASK 0xff
#define MC_TSM_DEBUG_BCNT10__BYTE0__SHIFT 0x0
#define MC_TSM_DEBUG_BCNT10__BYTE1_MASK 0xff00
#define MC_TSM_DEBUG_BCNT10__BYTE1__SHIFT 0x8
#define MC_TSM_DEBUG_BCNT10__BYTE2_MASK 0xff0000
#define MC_TSM_DEBUG_BCNT10__BYTE2__SHIFT 0x10
#define MC_TSM_DEBUG_BCNT10__BYTE3_MASK 0xff000000
#define MC_TSM_DEBUG_BCNT10__BYTE3__SHIFT 0x18
#define MC_TSM_DEBUG_ST01__DATA_MASK 0xffffffff
#define MC_TSM_DEBUG_ST01__DATA__SHIFT 0x0
#define MC_TSM_DEBUG_ST23__DATA_MASK 0xffffffff
#define MC_TSM_DEBUG_ST23__DATA__SHIFT 0x0
#define MC_TSM_DEBUG_ST45__DATA_MASK 0xffffffff
#define MC_TSM_DEBUG_ST45__DATA__SHIFT 0x0
#define MC_TSM_DEBUG_BKPT__DATA_MASK 0xffffffff
#define MC_TSM_DEBUG_BKPT__DATA__SHIFT 0x0
#define MC_SEQ_IO_DEBUG_INDEX__IO_DEBUG_INDEX_MASK 0x1ff
#define MC_SEQ_IO_DEBUG_INDEX__IO_DEBUG_INDEX__SHIFT 0x0
#define MC_SEQ_IO_DEBUG_DATA__IO_DEBUG_DATA_MASK 0xffffffff
#define MC_SEQ_IO_DEBUG_DATA__IO_DEBUG_DATA__SHIFT 0x0
#define MC_IO_DEBUG_UP_0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_2__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_2__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_2__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_2__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_2__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_2__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_2__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_2__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_3__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_3__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_3__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_3__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_3__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_3__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_3__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_3__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_4__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_4__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_4__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_4__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_4__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_4__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_4__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_4__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_5__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_5__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_5__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_5__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_5__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_5__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_5__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_5__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_6__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_6__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_6__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_6__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_6__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_6__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_6__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_6__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_7__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_7__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_7__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_7__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_7__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_7__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_7__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_7__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_8__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_8__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_8__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_8__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_8__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_8__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_8__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_8__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_9__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_9__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_9__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_9__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_9__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_9__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_9__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_9__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_10__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_10__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_10__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_10__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_10__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_10__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_10__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_10__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_11__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_11__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_11__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_11__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_11__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_11__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_11__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_11__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_12__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_12__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_12__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_12__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_12__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_12__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_12__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_12__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_13__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_13__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_13__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_13__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_13__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_13__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_13__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_13__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_14__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_14__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_14__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_14__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_14__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_14__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_14__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_14__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_15__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_15__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_15__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_15__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_15__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_15__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_15__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_15__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_16__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_16__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_16__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_16__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_16__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_16__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_16__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_16__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_17__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_17__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_17__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_17__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_17__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_17__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_17__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_17__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_18__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_18__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_18__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_18__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_18__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_18__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_18__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_18__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_19__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_19__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_19__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_19__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_19__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_19__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_19__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_19__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_20__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_20__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_20__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_20__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_20__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_20__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_20__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_20__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_21__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_21__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_21__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_21__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_21__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_21__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_21__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_21__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_22__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_22__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_22__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_22__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_22__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_22__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_22__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_22__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_23__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_23__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_23__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_23__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_23__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_23__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_23__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_23__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_24__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_24__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_24__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_24__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_24__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_24__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_24__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_24__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_25__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_25__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_25__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_25__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_25__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_25__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_25__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_25__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_26__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_26__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_26__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_26__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_26__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_26__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_26__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_26__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_27__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_27__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_27__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_27__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_27__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_27__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_27__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_27__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_28__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_28__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_28__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_28__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_28__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_28__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_28__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_28__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_29__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_29__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_29__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_29__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_29__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_29__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_29__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_29__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_30__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_30__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_30__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_30__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_30__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_30__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_30__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_30__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_31__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_31__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_31__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_31__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_31__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_31__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_31__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_31__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_32__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_32__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_32__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_32__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_32__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_32__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_32__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_32__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_33__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_33__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_33__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_33__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_33__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_33__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_33__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_33__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_34__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_34__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_34__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_34__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_34__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_34__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_34__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_34__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_35__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_35__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_35__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_35__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_35__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_35__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_35__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_35__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_36__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_36__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_36__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_36__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_36__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_36__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_36__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_36__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_37__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_37__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_37__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_37__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_37__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_37__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_37__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_37__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_38__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_38__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_38__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_38__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_38__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_38__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_38__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_38__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_39__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_39__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_39__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_39__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_39__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_39__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_39__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_39__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_40__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_40__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_40__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_40__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_40__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_40__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_40__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_40__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_41__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_41__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_41__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_41__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_41__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_41__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_41__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_41__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_42__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_42__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_42__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_42__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_42__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_42__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_42__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_42__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_43__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_43__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_43__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_43__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_43__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_43__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_43__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_43__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_44__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_44__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_44__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_44__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_44__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_44__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_44__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_44__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_45__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_45__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_45__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_45__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_45__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_45__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_45__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_45__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_46__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_46__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_46__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_46__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_46__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_46__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_46__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_46__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_47__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_47__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_47__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_47__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_47__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_47__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_47__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_47__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_48__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_48__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_48__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_48__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_48__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_48__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_48__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_48__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_49__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_49__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_49__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_49__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_49__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_49__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_49__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_49__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_50__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_50__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_50__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_50__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_50__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_50__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_50__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_50__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_51__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_51__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_51__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_51__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_51__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_51__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_51__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_51__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_52__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_52__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_52__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_52__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_52__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_52__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_52__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_52__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_53__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_53__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_53__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_53__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_53__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_53__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_53__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_53__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_54__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_54__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_54__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_54__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_54__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_54__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_54__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_54__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_55__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_55__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_55__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_55__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_55__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_55__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_55__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_55__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_56__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_56__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_56__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_56__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_56__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_56__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_56__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_56__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_57__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_57__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_57__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_57__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_57__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_57__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_57__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_57__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_58__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_58__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_58__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_58__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_58__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_58__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_58__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_58__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_59__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_59__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_59__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_59__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_59__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_59__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_59__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_59__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_60__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_60__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_60__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_60__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_60__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_60__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_60__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_60__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_61__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_61__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_61__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_61__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_61__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_61__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_61__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_61__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_62__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_62__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_62__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_62__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_62__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_62__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_62__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_62__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_63__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_63__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_63__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_63__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_63__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_63__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_63__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_63__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_64__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_64__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_64__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_64__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_64__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_64__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_64__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_64__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_65__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_65__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_65__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_65__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_65__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_65__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_65__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_65__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_66__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_66__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_66__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_66__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_66__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_66__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_66__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_66__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_67__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_67__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_67__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_67__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_67__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_67__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_67__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_67__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_68__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_68__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_68__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_68__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_68__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_68__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_68__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_68__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_69__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_69__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_69__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_69__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_69__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_69__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_69__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_69__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_70__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_70__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_70__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_70__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_70__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_70__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_70__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_70__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_71__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_71__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_71__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_71__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_71__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_71__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_71__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_71__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_72__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_72__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_72__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_72__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_72__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_72__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_72__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_72__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_73__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_73__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_73__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_73__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_73__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_73__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_73__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_73__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_74__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_74__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_74__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_74__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_74__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_74__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_74__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_74__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_75__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_75__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_75__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_75__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_75__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_75__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_75__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_75__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_76__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_76__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_76__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_76__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_76__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_76__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_76__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_76__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_77__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_77__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_77__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_77__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_77__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_77__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_77__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_77__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_78__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_78__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_78__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_78__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_78__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_78__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_78__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_78__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_79__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_79__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_79__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_79__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_79__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_79__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_79__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_79__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_80__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_80__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_80__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_80__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_80__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_80__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_80__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_80__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_81__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_81__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_81__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_81__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_81__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_81__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_81__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_81__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_82__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_82__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_82__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_82__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_82__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_82__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_82__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_82__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_83__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_83__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_83__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_83__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_83__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_83__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_83__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_83__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_84__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_84__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_84__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_84__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_84__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_84__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_84__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_84__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_85__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_85__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_85__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_85__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_85__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_85__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_85__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_85__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_86__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_86__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_86__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_86__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_86__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_86__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_86__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_86__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_87__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_87__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_87__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_87__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_87__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_87__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_87__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_87__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_88__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_88__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_88__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_88__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_88__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_88__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_88__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_88__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_89__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_89__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_89__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_89__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_89__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_89__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_89__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_89__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_90__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_90__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_90__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_90__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_90__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_90__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_90__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_90__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_91__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_91__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_91__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_91__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_91__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_91__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_91__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_91__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_92__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_92__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_92__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_92__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_92__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_92__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_92__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_92__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_93__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_93__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_93__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_93__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_93__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_93__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_93__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_93__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_94__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_94__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_94__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_94__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_94__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_94__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_94__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_94__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_95__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_95__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_95__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_95__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_95__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_95__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_95__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_95__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_96__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_96__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_96__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_96__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_96__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_96__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_96__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_96__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_97__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_97__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_97__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_97__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_97__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_97__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_97__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_97__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_98__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_98__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_98__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_98__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_98__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_98__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_98__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_98__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_99__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_99__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_99__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_99__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_99__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_99__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_99__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_99__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_100__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_100__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_100__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_100__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_100__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_100__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_100__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_100__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_101__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_101__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_101__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_101__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_101__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_101__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_101__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_101__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_102__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_102__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_102__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_102__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_102__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_102__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_102__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_102__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_103__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_103__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_103__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_103__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_103__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_103__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_103__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_103__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_104__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_104__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_104__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_104__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_104__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_104__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_104__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_104__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_105__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_105__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_105__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_105__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_105__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_105__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_105__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_105__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_106__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_106__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_106__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_106__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_106__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_106__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_106__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_106__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_107__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_107__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_107__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_107__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_107__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_107__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_107__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_107__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_108__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_108__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_108__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_108__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_108__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_108__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_108__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_108__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_109__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_109__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_109__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_109__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_109__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_109__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_109__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_109__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_110__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_110__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_110__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_110__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_110__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_110__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_110__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_110__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_111__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_111__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_111__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_111__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_111__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_111__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_111__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_111__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_112__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_112__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_112__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_112__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_112__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_112__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_112__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_112__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_113__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_113__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_113__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_113__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_113__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_113__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_113__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_113__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_114__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_114__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_114__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_114__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_114__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_114__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_114__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_114__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_115__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_115__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_115__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_115__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_115__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_115__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_115__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_115__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_116__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_116__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_116__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_116__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_116__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_116__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_116__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_116__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_117__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_117__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_117__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_117__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_117__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_117__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_117__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_117__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_118__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_118__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_118__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_118__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_118__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_118__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_118__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_118__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_119__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_119__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_119__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_119__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_119__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_119__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_119__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_119__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_120__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_120__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_120__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_120__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_120__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_120__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_120__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_120__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_121__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_121__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_121__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_121__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_121__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_121__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_121__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_121__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_122__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_122__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_122__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_122__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_122__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_122__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_122__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_122__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_123__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_123__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_123__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_123__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_123__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_123__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_123__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_123__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_124__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_124__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_124__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_124__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_124__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_124__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_124__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_124__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_125__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_125__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_125__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_125__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_125__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_125__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_125__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_125__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_126__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_126__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_126__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_126__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_126__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_126__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_126__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_126__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_127__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_127__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_127__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_127__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_127__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_127__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_127__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_127__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_128__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_128__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_128__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_128__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_128__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_128__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_128__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_128__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_129__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_129__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_129__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_129__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_129__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_129__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_129__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_129__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_130__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_130__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_130__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_130__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_130__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_130__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_130__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_130__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_131__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_131__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_131__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_131__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_131__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_131__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_131__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_131__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_132__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_132__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_132__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_132__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_132__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_132__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_132__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_132__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_133__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_133__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_133__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_133__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_133__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_133__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_133__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_133__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_134__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_134__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_134__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_134__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_134__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_134__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_134__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_134__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_135__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_135__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_135__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_135__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_135__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_135__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_135__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_135__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_136__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_136__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_136__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_136__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_136__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_136__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_136__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_136__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_137__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_137__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_137__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_137__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_137__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_137__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_137__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_137__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_138__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_138__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_138__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_138__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_138__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_138__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_138__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_138__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_139__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_139__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_139__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_139__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_139__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_139__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_139__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_139__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_140__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_140__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_140__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_140__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_140__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_140__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_140__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_140__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_141__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_141__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_141__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_141__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_141__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_141__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_141__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_141__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_142__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_142__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_142__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_142__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_142__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_142__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_142__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_142__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_143__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_143__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_143__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_143__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_143__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_143__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_143__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_143__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_144__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_144__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_144__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_144__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_144__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_144__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_144__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_144__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_145__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_145__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_145__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_145__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_145__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_145__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_145__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_145__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_146__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_146__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_146__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_146__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_146__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_146__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_146__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_146__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_147__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_147__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_147__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_147__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_147__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_147__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_147__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_147__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_148__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_148__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_148__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_148__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_148__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_148__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_148__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_148__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_149__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_149__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_149__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_149__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_149__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_149__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_149__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_149__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_150__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_150__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_150__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_150__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_150__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_150__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_150__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_150__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_151__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_151__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_151__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_151__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_151__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_151__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_151__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_151__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_152__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_152__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_152__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_152__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_152__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_152__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_152__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_152__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_153__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_153__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_153__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_153__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_153__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_153__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_153__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_153__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_154__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_154__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_154__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_154__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_154__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_154__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_154__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_154__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_155__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_155__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_155__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_155__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_155__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_155__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_155__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_155__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_156__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_156__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_156__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_156__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_156__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_156__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_156__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_156__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_157__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_157__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_157__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_157__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_157__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_157__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_157__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_157__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_158__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_158__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_158__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_158__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_158__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_158__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_158__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_158__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_UP_159__VALUE0_MASK 0xff
#define MC_IO_DEBUG_UP_159__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_UP_159__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_UP_159__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_UP_159__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_UP_159__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_UP_159__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_UP_159__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RX_EQ_PM_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RX_DYN_PM_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_CDR_PHSIZE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0_CDR_PHSIZE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1_CDR_PHSIZE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2_CDR_PHSIZE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3_CDR_PHSIZE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_CDR_PHSIZE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CK_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CK_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CK_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CK_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CK_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CK_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CK_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CK_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRL_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ADDRH_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_ACMD_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_ACMD_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_ACMD_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_ACMD_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_ACMD_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_ACMD_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_ACMD_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_ACMD_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0L_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0L_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0L_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0L_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0L_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0L_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0L_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0L_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB0H_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB0H_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB0H_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB0H_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB0H_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB0H_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB0H_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB0H_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1L_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1L_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1L_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1L_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1L_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1L_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1L_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1L_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB1H_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB1H_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB1H_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB1H_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB1H_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB1H_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB1H_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB1H_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2L_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2L_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2L_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2L_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2L_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2L_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2L_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2L_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB2H_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB2H_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB2H_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB2H_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB2H_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB2H_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB2H_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB2H_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3L_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3L_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3L_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3L_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3L_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3L_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3L_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3L_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQB3H_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQB3H_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQB3H_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQB3H_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQB3H_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQB3H_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQB3H_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQB3H_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DBI_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DBI_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DBI_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DBI_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DBI_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DBI_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DBI_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DBI_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_EDC_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_EDC_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_EDC_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_EDC_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_EDC_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_EDC_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_EDC_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_EDC_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCK_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCK_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCK_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCK_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCK_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCK_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCK_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCK_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQ0_RX_EQ_PM_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQ1_RX_EQ_PM_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQ0_RX_DYN_PM_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_DQ1_RX_DYN_PM_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_CMD_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_CMD_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_CMD_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_CMD_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_CMD_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_CMD_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_CMD_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_CMD_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_MISC_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_MISC_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_MISC_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_MISC_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_MISC_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_MISC_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_MISC_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_MISC_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_CLKSEL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_CLKSEL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_CLKSEL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_CLKSEL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_CLKSEL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_CLKSEL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_CLKSEL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_CLKSEL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_OFSCAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_OFSCAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_OFSCAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_OFSCAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_OFSCAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_OFSCAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_OFSCAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_OFSCAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_TXPHASE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_TXPHASE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_TXPHASE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_TXPHASE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_TXPHASE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_TXPHASE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_TXPHASE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_TXPHASE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_TXSLF_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_TXSLF_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_TXSLF_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_TXSLF_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_TXSLF_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_TXSLF_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_TXSLF_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_TXSLF_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_TXBST_PD_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_TXBST_PD_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_TXBST_PD_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_TXBST_PD_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_TXBST_PD_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_TXBST_PD_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_TXBST_PD_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_TXBST_PD_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_TXBST_PU_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_TXBST_PU_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_TXBST_PU_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_TXBST_PU_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_TXBST_PU_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_TXBST_PU_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_TXBST_PU_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_TXBST_PU_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RX_EQ_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RX_EQ_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RX_EQ_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RX_EQ_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RX_EQ_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RX_EQ_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RX_EQ_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RX_EQ_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D0__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D0__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D0__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D0__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D0__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D0__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D0__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D0__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_MISC_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_MISC_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_MISC_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_MISC_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_MISC_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_MISC_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_MISC_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_MISC_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_CLKSEL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_CLKSEL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_CLKSEL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_CLKSEL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_CLKSEL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_CLKSEL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_CLKSEL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_CLKSEL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_OFSCAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_OFSCAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_OFSCAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_OFSCAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_OFSCAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_OFSCAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_OFSCAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_OFSCAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_TXPHASE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_TXPHASE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_TXPHASE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_TXPHASE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_TXPHASE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_TXPHASE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_TXPHASE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_TXPHASE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RX_VREF_CAL_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_TXSLF_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_TXSLF_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_TXSLF_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_TXSLF_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_TXSLF_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_TXSLF_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_TXSLF_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_TXSLF_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_TXBST_PD_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_TXBST_PD_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_TXBST_PD_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_TXBST_PD_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_TXBST_PD_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_TXBST_PD_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_TXBST_PD_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_TXBST_PD_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_TXBST_PU_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_TXBST_PU_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_TXBST_PU_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_TXBST_PU_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_TXBST_PU_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_TXBST_PU_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_TXBST_PU_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_TXBST_PU_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RX_EQ_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RX_EQ_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RX_EQ_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RX_EQ_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RX_EQ_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RX_EQ_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RX_EQ_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RX_EQ_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_CDR_PHSIZE_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RX_EQ_PM_D1__VALUE3__SHIFT 0x18
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D1__VALUE0_MASK 0xff
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D1__VALUE0__SHIFT 0x0
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D1__VALUE1_MASK 0xff00
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D1__VALUE1__SHIFT 0x8
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D1__VALUE2_MASK 0xff0000
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D1__VALUE2__SHIFT 0x10
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D1__VALUE3_MASK 0xff000000
#define MC_IO_DEBUG_WCDR_RX_DYN_PM_D1__VALUE3__SHIFT 0x18
#define MC_SEQ_CNTL_3__PIPE_DELAY_OUT_D0_MASK 0x7
#define MC_SEQ_CNTL_3__PIPE_DELAY_OUT_D0__SHIFT 0x0
#define MC_SEQ_CNTL_3__PIPE_DELAY_IN_D0_MASK 0x38
#define MC_SEQ_CNTL_3__PIPE_DELAY_IN_D0__SHIFT 0x3
#define MC_SEQ_CNTL_3__PIPE_DELAY_OUT_D1_MASK 0x1c0
#define MC_SEQ_CNTL_3__PIPE_DELAY_OUT_D1__SHIFT 0x6
#define MC_SEQ_CNTL_3__PIPE_DELAY_IN_D1_MASK 0xe00
#define MC_SEQ_CNTL_3__PIPE_DELAY_IN_D1__SHIFT 0x9
#define MC_SEQ_CNTL_3__REPCG_EN_D0_MASK 0x1000
#define MC_SEQ_CNTL_3__REPCG_EN_D0__SHIFT 0xc
#define MC_SEQ_CNTL_3__REPCG_EN_D1_MASK 0x2000
#define MC_SEQ_CNTL_3__REPCG_EN_D1__SHIFT 0xd
#define MC_SEQ_CNTL_3__REPCG_OFF_DLY_MASK 0xf0000
#define MC_SEQ_CNTL_3__REPCG_OFF_DLY__SHIFT 0x10
#define MC_SEQ_CNTL_3__FCK_FRC_MASK 0x100000
#define MC_SEQ_CNTL_3__FCK_FRC__SHIFT 0x14
#define MC_SEQ_CNTL_3__DBI_FRC_MASK 0x200000
#define MC_SEQ_CNTL_3__DBI_FRC__SHIFT 0x15
#define MC_SEQ_CNTL_3__PRGRM_CDC_MASK 0x400000
#define MC_SEQ_CNTL_3__PRGRM_CDC__SHIFT 0x16
#define MC_SEQ_CNTL_3__DQS_FRC_MASK 0x800000
#define MC_SEQ_CNTL_3__DQS_FRC__SHIFT 0x17
#define MC_SEQ_CNTL_3__DQS_FRC_PAT_MASK 0xf000000
#define MC_SEQ_CNTL_3__DQS_FRC_PAT__SHIFT 0x18
#define MC_SEQ_CNTL_3__IDSC_EN_MASK 0x40000000
#define MC_SEQ_CNTL_3__IDSC_EN__SHIFT 0x1e
#define MC_SEQ_CNTL_3__CAC_EN_MASK 0x80000000
#define MC_SEQ_CNTL_3__CAC_EN__SHIFT 0x1f
#define MC_SEQ_G5PDX_CTRL__CH0_ENABLE_MASK 0x1
#define MC_SEQ_G5PDX_CTRL__CH0_ENABLE__SHIFT 0x0
#define MC_SEQ_G5PDX_CTRL__CH1_ENABLE_MASK 0x2
#define MC_SEQ_G5PDX_CTRL__CH1_ENABLE__SHIFT 0x1
#define MC_SEQ_G5PDX_CTRL__WCKOFF_EARLY_MASK 0x4
#define MC_SEQ_G5PDX_CTRL__WCKOFF_EARLY__SHIFT 0x2
#define MC_SEQ_G5PDX_CTRL__WCKOFF_LATE_MASK 0x8
#define MC_SEQ_G5PDX_CTRL__WCKOFF_LATE__SHIFT 0x3
#define MC_SEQ_G5PDX_CTRL__TPD2MRS_MASK 0x3f0
#define MC_SEQ_G5PDX_CTRL__TPD2MRS__SHIFT 0x4
#define MC_SEQ_G5PDX_CTRL__TMRS2WCK_MASK 0xf000
#define MC_SEQ_G5PDX_CTRL__TMRS2WCK__SHIFT 0xc
#define MC_SEQ_G5PDX_CTRL__TWCK2MRS_MASK 0xf0000
#define MC_SEQ_G5PDX_CTRL__TWCK2MRS__SHIFT 0x10
#define MC_SEQ_G5PDX_CTRL__TMRD_MASK 0xf00000
#define MC_SEQ_G5PDX_CTRL__TMRD__SHIFT 0x14
#define MC_SEQ_G5PDX_CTRL_LP__CH0_ENABLE_MASK 0x1
#define MC_SEQ_G5PDX_CTRL_LP__CH0_ENABLE__SHIFT 0x0
#define MC_SEQ_G5PDX_CTRL_LP__CH1_ENABLE_MASK 0x2
#define MC_SEQ_G5PDX_CTRL_LP__CH1_ENABLE__SHIFT 0x1
#define MC_SEQ_G5PDX_CTRL_LP__WCKOFF_EARLY_MASK 0x4
#define MC_SEQ_G5PDX_CTRL_LP__WCKOFF_EARLY__SHIFT 0x2
#define MC_SEQ_G5PDX_CTRL_LP__WCKOFF_LATE_MASK 0x8
#define MC_SEQ_G5PDX_CTRL_LP__WCKOFF_LATE__SHIFT 0x3
#define MC_SEQ_G5PDX_CTRL_LP__TPD2MRS_MASK 0x3f0
#define MC_SEQ_G5PDX_CTRL_LP__TPD2MRS__SHIFT 0x4
#define MC_SEQ_G5PDX_CTRL_LP__TMRS2WCK_MASK 0xf000
#define MC_SEQ_G5PDX_CTRL_LP__TMRS2WCK__SHIFT 0xc
#define MC_SEQ_G5PDX_CTRL_LP__TWCK2MRS_MASK 0xf0000
#define MC_SEQ_G5PDX_CTRL_LP__TWCK2MRS__SHIFT 0x10
#define MC_SEQ_G5PDX_CTRL_LP__TMRD_MASK 0xf00000
#define MC_SEQ_G5PDX_CTRL_LP__TMRD__SHIFT 0x14
#define MC_SEQ_G5PDX_CMD0__CMD_MASK 0xffffffff
#define MC_SEQ_G5PDX_CMD0__CMD__SHIFT 0x0
#define MC_SEQ_G5PDX_CMD0_LP__CMD_MASK 0xffffffff
#define MC_SEQ_G5PDX_CMD0_LP__CMD__SHIFT 0x0
#define MC_SEQ_G5PDX_CMD1__CMD_MASK 0xffffffff
#define MC_SEQ_G5PDX_CMD1__CMD__SHIFT 0x0
#define MC_SEQ_G5PDX_CMD1_LP__CMD_MASK 0xffffffff
#define MC_SEQ_G5PDX_CMD1_LP__CMD__SHIFT 0x0
#define MC_SEQ_SREG_READ__DATA_MASK 0xffffffff
#define MC_SEQ_SREG_READ__DATA__SHIFT 0x0
#define MC_SEQ_SREG_STATUS__AVAIL_RTN_MASK 0xf
#define MC_SEQ_SREG_STATUS__AVAIL_RTN__SHIFT 0x0
#define MC_SEQ_SREG_STATUS__PND_RD_MASK 0xf00
#define MC_SEQ_SREG_STATUS__PND_RD__SHIFT 0x8
#define MC_SEQ_SREG_STATUS__PND_WR_MASK 0xf000
#define MC_SEQ_SREG_STATUS__PND_WR__SHIFT 0xc
#define MC_SEQ_PHYREG_BCAST__CH0_EN_MASK 0x1
#define MC_SEQ_PHYREG_BCAST__CH0_EN__SHIFT 0x0
#define MC_SEQ_PHYREG_BCAST__CH1_EN_MASK 0x2
#define MC_SEQ_PHYREG_BCAST__CH1_EN__SHIFT 0x1
#define MC_SEQ_PHYREG_BCAST__CKE_MASK_MASK 0x80
#define MC_SEQ_PHYREG_BCAST__CKE_MASK__SHIFT 0x7
#define MC_SEQ_PHYREG_BCAST__DQ_MASK_MASK 0x100
#define MC_SEQ_PHYREG_BCAST__DQ_MASK__SHIFT 0x8
#define MC_SEQ_PHYREG_BCAST__DBI_MASK_MASK 0x200
#define MC_SEQ_PHYREG_BCAST__DBI_MASK__SHIFT 0x9
#define MC_SEQ_PHYREG_BCAST__EDC_MASK_MASK 0x400
#define MC_SEQ_PHYREG_BCAST__EDC_MASK__SHIFT 0xa
#define MC_SEQ_PHYREG_BCAST__WCK_MASK_MASK 0x800
#define MC_SEQ_PHYREG_BCAST__WCK_MASK__SHIFT 0xb
#define MC_SEQ_PHYREG_BCAST__WCDR_MASK_MASK 0x1000
#define MC_SEQ_PHYREG_BCAST__WCDR_MASK__SHIFT 0xc
#define MC_SEQ_PHYREG_BCAST__CLK_MASK_MASK 0x2000
#define MC_SEQ_PHYREG_BCAST__CLK_MASK__SHIFT 0xd
#define MC_SEQ_PHYREG_BCAST__CMD_MASK_MASK 0x4000
#define MC_SEQ_PHYREG_BCAST__CMD_MASK__SHIFT 0xe
#define MC_SEQ_PHYREG_BCAST__ADR_MASK_MASK 0x8000
#define MC_SEQ_PHYREG_BCAST__ADR_MASK__SHIFT 0xf
#define MC_SEQ_PMG_DVS_CTL__ENABLE_MASK 0x1
#define MC_SEQ_PMG_DVS_CTL__ENABLE__SHIFT 0x0
#define MC_SEQ_PMG_DVS_CTL__TDVS_MASK 0x3e
#define MC_SEQ_PMG_DVS_CTL__TDVS__SHIFT 0x1
#define MC_SEQ_PMG_DVS_CTL_LP__ENABLE_MASK 0x1
#define MC_SEQ_PMG_DVS_CTL_LP__ENABLE__SHIFT 0x0
#define MC_SEQ_PMG_DVS_CTL_LP__TDVS_MASK 0x3e
#define MC_SEQ_PMG_DVS_CTL_LP__TDVS__SHIFT 0x1
#define MC_SEQ_PMG_DVS_CMD__ADR_MASK 0xffff
#define MC_SEQ_PMG_DVS_CMD__ADR__SHIFT 0x0
#define MC_SEQ_PMG_DVS_CMD__MOP_MASK 0x70000
#define MC_SEQ_PMG_DVS_CMD__MOP__SHIFT 0x10
#define MC_SEQ_PMG_DVS_CMD__BNK_MSB_MASK 0x80000
#define MC_SEQ_PMG_DVS_CMD__BNK_MSB__SHIFT 0x13
#define MC_SEQ_PMG_DVS_CMD__END_MASK 0x100000
#define MC_SEQ_PMG_DVS_CMD__END__SHIFT 0x14
#define MC_SEQ_PMG_DVS_CMD__CSB_MASK 0x600000
#define MC_SEQ_PMG_DVS_CMD__CSB__SHIFT 0x15
#define MC_SEQ_PMG_DVS_CMD__ADR_MSB1_MASK 0x800000
#define MC_SEQ_PMG_DVS_CMD__ADR_MSB1__SHIFT 0x17
#define MC_SEQ_PMG_DVS_CMD__ADR_MSB0_MASK 0x1000000
#define MC_SEQ_PMG_DVS_CMD__ADR_MSB0__SHIFT 0x18
#define MC_SEQ_PMG_DVS_CMD_LP__ADR_MASK 0xffff
#define MC_SEQ_PMG_DVS_CMD_LP__ADR__SHIFT 0x0
#define MC_SEQ_PMG_DVS_CMD_LP__MOP_MASK 0x70000
#define MC_SEQ_PMG_DVS_CMD_LP__MOP__SHIFT 0x10
#define MC_SEQ_PMG_DVS_CMD_LP__BNK_MSB_MASK 0x80000
#define MC_SEQ_PMG_DVS_CMD_LP__BNK_MSB__SHIFT 0x13
#define MC_SEQ_PMG_DVS_CMD_LP__END_MASK 0x100000
#define MC_SEQ_PMG_DVS_CMD_LP__END__SHIFT 0x14
#define MC_SEQ_PMG_DVS_CMD_LP__CSB_MASK 0x600000
#define MC_SEQ_PMG_DVS_CMD_LP__CSB__SHIFT 0x15
#define MC_SEQ_PMG_DVS_CMD_LP__ADR_MSB1_MASK 0x800000
#define MC_SEQ_PMG_DVS_CMD_LP__ADR_MSB1__SHIFT 0x17
#define MC_SEQ_PMG_DVS_CMD_LP__ADR_MSB0_MASK 0x1000000
#define MC_SEQ_PMG_DVS_CMD_LP__ADR_MSB0__SHIFT 0x18
#define MC_SEQ_DLL_STBY__EN_MASK 0x1
#define MC_SEQ_DLL_STBY__EN__SHIFT 0x0
#define MC_SEQ_DLL_STBY__VCTRLADC_FRC_MASK 0x2
#define MC_SEQ_DLL_STBY__VCTRLADC_FRC__SHIFT 0x1
#define MC_SEQ_DLL_STBY__VCTRLADC_VAL_MASK 0x4
#define MC_SEQ_DLL_STBY__VCTRLADC_VAL__SHIFT 0x2
#define MC_SEQ_DLL_STBY__MSTRSTBY_FRC_MASK 0x8
#define MC_SEQ_DLL_STBY__MSTRSTBY_FRC__SHIFT 0x3
#define MC_SEQ_DLL_STBY__MSTRSTBY_VAL_MASK 0x10
#define MC_SEQ_DLL_STBY__MSTRSTBY_VAL__SHIFT 0x4
#define MC_SEQ_DLL_STBY__ENTR_DLY_MASK 0xe0
#define MC_SEQ_DLL_STBY__ENTR_DLY__SHIFT 0x5
#define MC_SEQ_DLL_STBY__STBY_DLY_MASK 0xf00
#define MC_SEQ_DLL_STBY__STBY_DLY__SHIFT 0x8
#define MC_SEQ_DLL_STBY__TCKE_PULSE_EXTN_MASK 0xf000
#define MC_SEQ_DLL_STBY__TCKE_PULSE_EXTN__SHIFT 0xc
#define MC_SEQ_DLL_STBY__TCKE_EXTN_MASK 0xff0000
#define MC_SEQ_DLL_STBY__TCKE_EXTN__SHIFT 0x10
#define MC_SEQ_DLL_STBY__EXIT_DLY_MASK 0x3f000000
#define MC_SEQ_DLL_STBY__EXIT_DLY__SHIFT 0x18
#define MC_SEQ_DLL_STBY_LP__EN_MASK 0x1
#define MC_SEQ_DLL_STBY_LP__EN__SHIFT 0x0
#define MC_SEQ_DLL_STBY_LP__VCTRLADC_FRC_MASK 0x2
#define MC_SEQ_DLL_STBY_LP__VCTRLADC_FRC__SHIFT 0x1
#define MC_SEQ_DLL_STBY_LP__VCTRLADC_VAL_MASK 0x4
#define MC_SEQ_DLL_STBY_LP__VCTRLADC_VAL__SHIFT 0x2
#define MC_SEQ_DLL_STBY_LP__MSTRSTBY_FRC_MASK 0x8
#define MC_SEQ_DLL_STBY_LP__MSTRSTBY_FRC__SHIFT 0x3
#define MC_SEQ_DLL_STBY_LP__MSTRSTBY_VAL_MASK 0x10
#define MC_SEQ_DLL_STBY_LP__MSTRSTBY_VAL__SHIFT 0x4
#define MC_SEQ_DLL_STBY_LP__ENTR_DLY_MASK 0xe0
#define MC_SEQ_DLL_STBY_LP__ENTR_DLY__SHIFT 0x5
#define MC_SEQ_DLL_STBY_LP__STBY_DLY_MASK 0xf00
#define MC_SEQ_DLL_STBY_LP__STBY_DLY__SHIFT 0x8
#define MC_SEQ_DLL_STBY_LP__TCKE_PULSE_EXTN_MASK 0xf000
#define MC_SEQ_DLL_STBY_LP__TCKE_PULSE_EXTN__SHIFT 0xc
#define MC_SEQ_DLL_STBY_LP__TCKE_EXTN_MASK 0xff0000
#define MC_SEQ_DLL_STBY_LP__TCKE_EXTN__SHIFT 0x10
#define MC_SEQ_DLL_STBY_LP__EXIT_DLY_MASK 0x3f000000
#define MC_SEQ_DLL_STBY_LP__EXIT_DLY__SHIFT 0x18
#define MC_DLB_MISCCTRL0__UDD_ON_STATUS_BITS_MASK 0x1
#define MC_DLB_MISCCTRL0__UDD_ON_STATUS_BITS__SHIFT 0x0
#define MC_DLB_MISCCTRL0__LOAD_DATA_SEL_MASK 0x2
#define MC_DLB_MISCCTRL0__LOAD_DATA_SEL__SHIFT 0x1
#define MC_DLB_MISCCTRL0__LOAD_UDD_MASK 0x4
#define MC_DLB_MISCCTRL0__LOAD_UDD__SHIFT 0x2
#define MC_DLB_MISCCTRL0__ADR_STATUS_SEL_MASK 0x8
#define MC_DLB_MISCCTRL0__ADR_STATUS_SEL__SHIFT 0x3
#define MC_DLB_MISCCTRL0__DATA_SEL_MASK 0xf0
#define MC_DLB_MISCCTRL0__DATA_SEL__SHIFT 0x4
#define MC_DLB_MISCCTRL0__PRBS_CHK_LOAD_CNT_MASK 0x7f00
#define MC_DLB_MISCCTRL0__PRBS_CHK_LOAD_CNT__SHIFT 0x8
#define MC_DLB_MISCCTRL0__UDD_MASK 0xffff0000
#define MC_DLB_MISCCTRL0__UDD__SHIFT 0x10
#define MC_DLB_MISCCTRL1__PRBS_ERR_CNT_LIMIT_MASK 0xffffffff
#define MC_DLB_MISCCTRL1__PRBS_ERR_CNT_LIMIT__SHIFT 0x0
#define MC_DLB_MISCCTRL2__PRBS_RUN_LENGTH_MASK 0x1ffff
#define MC_DLB_MISCCTRL2__PRBS_RUN_LENGTH__SHIFT 0x0
#define MC_DLB_MISCCTRL2__PRBS_FREERUN_MASK 0x20000
#define MC_DLB_MISCCTRL2__PRBS_FREERUN__SHIFT 0x11
#define MC_DLB_MISCCTRL2__PRBS15_MODE_MASK 0x40000
#define MC_DLB_MISCCTRL2__PRBS15_MODE__SHIFT 0x12
#define MC_DLB_MISCCTRL2__PRBS23_MODE_MASK 0x80000
#define MC_DLB_MISCCTRL2__PRBS23_MODE__SHIFT 0x13
#define MC_DLB_MISCCTRL2__STOP_ON_NEXT_ERR_MASK 0x100000
#define MC_DLB_MISCCTRL2__STOP_ON_NEXT_ERR__SHIFT 0x14
#define MC_DLB_MISCCTRL2__STOP_CLK_MASK 0x200000
#define MC_DLB_MISCCTRL2__STOP_CLK__SHIFT 0x15
#define MC_DLB_MISCCTRL2__SWEEP_DLY_MASK 0x3000000
#define MC_DLB_MISCCTRL2__SWEEP_DLY__SHIFT 0x18
#define MC_DLB_MISCCTRL2__GRAY_CODE_EN_MASK 0x4000000
#define MC_DLB_MISCCTRL2__GRAY_CODE_EN__SHIFT 0x1a
#define MC_DLB_MISCCTRL2__SEL_PHY_PRBS_CHK_MASK 0x10000000
#define MC_DLB_MISCCTRL2__SEL_PHY_PRBS_CHK__SHIFT 0x1c
#define MC_DLB_MISCCTRL2__SEL_AC_PRBS_CHK_MASK 0x20000000
#define MC_DLB_MISCCTRL2__SEL_AC_PRBS_CHK__SHIFT 0x1d
#define MC_DLB_MISCCTRL2__STATUS_SEL_MASK 0x40000000
#define MC_DLB_MISCCTRL2__STATUS_SEL__SHIFT 0x1e
#define MC_DLB_CONFIG0__CONF_EN_CH0_MASK 0x1
#define MC_DLB_CONFIG0__CONF_EN_CH0__SHIFT 0x0
#define MC_DLB_CONFIG0__CONF_EN_CH1_MASK 0x2
#define MC_DLB_CONFIG0__CONF_EN_CH1__SHIFT 0x1
#define MC_DLB_CONFIG0__CONF_AUTO_EN_MASK 0x4
#define MC_DLB_CONFIG0__CONF_AUTO_EN__SHIFT 0x2
#define MC_DLB_CONFIG0__MASK_MASK 0xf0
#define MC_DLB_CONFIG0__MASK__SHIFT 0x4
#define MC_DLB_CONFIG0__PTR_MASK 0x3ff00
#define MC_DLB_CONFIG0__PTR__SHIFT 0x8
#define MC_DLB_CONFIG1__DATA_MASK 0xffffffff
#define MC_DLB_CONFIG1__DATA__SHIFT 0x0
#define MC_DLB_SETUP__DLB_EN_MASK 0x1
#define MC_DLB_SETUP__DLB_EN__SHIFT 0x0
#define MC_DLB_SETUP__DLB_FIFO_EN_MASK 0x2
#define MC_DLB_SETUP__DLB_FIFO_EN__SHIFT 0x1
#define MC_DLB_SETUP__DLB_STATUS_EN_MASK 0x4
#define MC_DLB_SETUP__DLB_STATUS_EN__SHIFT 0x2
#define MC_DLB_SETUP__DLB_CONFIG_EN_MASK 0x8
#define MC_DLB_SETUP__DLB_CONFIG_EN__SHIFT 0x3
#define MC_DLB_SETUP__DLB_PRBS_EN_MASK 0x10
#define MC_DLB_SETUP__DLB_PRBS_EN__SHIFT 0x4
#define MC_DLB_SETUP__PRBS_GEN_RST_MASK 0x20
#define MC_DLB_SETUP__PRBS_GEN_RST__SHIFT 0x5
#define MC_DLB_SETUP__PRBS_CHK_RST_MASK 0x40
#define MC_DLB_SETUP__PRBS_CHK_RST__SHIFT 0x6
#define MC_DLB_SETUP__PRBS_PHY_RST_MASK 0x80
#define MC_DLB_SETUP__PRBS_PHY_RST__SHIFT 0x7
#define MC_DLB_SETUP__QDR_MODE_MASK 0x100
#define MC_DLB_SETUP__QDR_MODE__SHIFT 0x8
#define MC_DLB_SETUP__CHK_DATA_BITS_MASK 0xff0000
#define MC_DLB_SETUP__CHK_DATA_BITS__SHIFT 0x10
#define MC_DLB_SETUP__MEM_BIT_SEL_MASK 0x1f000000
#define MC_DLB_SETUP__MEM_BIT_SEL__SHIFT 0x18
#define MC_DLB_SETUP__RXTXLP_EN_MASK 0x80000000
#define MC_DLB_SETUP__RXTXLP_EN__SHIFT 0x1f
#define MC_DLB_SETUPSWEEP__DLL_RST_MASK 0x1
#define MC_DLB_SETUPSWEEP__DLL_RST__SHIFT 0x0
#define MC_DLB_SETUPSWEEP__CONFIG_MASK 0x2
#define MC_DLB_SETUPSWEEP__CONFIG__SHIFT 0x1
#define MC_DLB_SETUPSWEEP__MASTER_MASK 0x4
#define MC_DLB_SETUPSWEEP__MASTER__SHIFT 0x2
#define MC_DLB_SETUPSWEEP__DLLDLY_MASK 0xf0
#define MC_DLB_SETUPSWEEP__DLLDLY__SHIFT 0x4
#define MC_DLB_SETUPSWEEP__DLLSTEPS_MASK 0x1f00
#define MC_DLB_SETUPSWEEP__DLLSTEPS__SHIFT 0x8
#define MC_DLB_SETUPFIFO__WRITE_FIFO_RST_MASK 0x1
#define MC_DLB_SETUPFIFO__WRITE_FIFO_RST__SHIFT 0x0
#define MC_DLB_SETUPFIFO__READ_FIFO_RST_MASK 0x2
#define MC_DLB_SETUPFIFO__READ_FIFO_RST__SHIFT 0x1
#define MC_DLB_SETUPFIFO__BOTH_FIFO_RST_MASK 0x4
#define MC_DLB_SETUPFIFO__BOTH_FIFO_RST__SHIFT 0x2
#define MC_DLB_SETUPFIFO__SYNC_RST_MASK 0x8
#define MC_DLB_SETUPFIFO__SYNC_RST__SHIFT 0x3
#define MC_DLB_SETUPFIFO__SYNC_RST_MASK_MASK 0x30
#define MC_DLB_SETUPFIFO__SYNC_RST_MASK__SHIFT 0x4
#define MC_DLB_SETUPFIFO__OUTPUT_EN_RST_MASK 0x40
#define MC_DLB_SETUPFIFO__OUTPUT_EN_RST__SHIFT 0x6
#define MC_DLB_SETUPFIFO__SHIFT_WR_FIFO_PTR_MASK 0x300
#define MC_DLB_SETUPFIFO__SHIFT_WR_FIFO_PTR__SHIFT 0x8
#define MC_DLB_SETUPFIFO__DELAY_RD_FIFO_PTR_MASK 0x1c00
#define MC_DLB_SETUPFIFO__DELAY_RD_FIFO_PTR__SHIFT 0xa
#define MC_DLB_SETUPFIFO__STROBE_MASK 0xf0000
#define MC_DLB_SETUPFIFO__STROBE__SHIFT 0x10
#define MC_DLB_WRITE_MASK__BIT_MASK_MASK 0x3fffff
#define MC_DLB_WRITE_MASK__BIT_MASK__SHIFT 0x0
#define MC_DLB_WRITE_MASK__CH_MASK_MASK 0xf000000
#define MC_DLB_WRITE_MASK__CH_MASK__SHIFT 0x18
#define MC_DLB_STATUS__STICK_ERROR_MASK 0xf
#define MC_DLB_STATUS__STICK_ERROR__SHIFT 0x0
#define MC_DLB_STATUS__LOCK_MASK 0xf0
#define MC_DLB_STATUS__LOCK__SHIFT 0x4
#define MC_DLB_STATUS__SWEEP_DONE_MASK 0xf00
#define MC_DLB_STATUS__SWEEP_DONE__SHIFT 0x8
#define MC_DLB_STATUS_MISC0__DATA_MASK 0xffffffff
#define MC_DLB_STATUS_MISC0__DATA__SHIFT 0x0
#define MC_DLB_STATUS_MISC1__DATA_MASK 0xffffffff
#define MC_DLB_STATUS_MISC1__DATA__SHIFT 0x0
#define MC_DLB_STATUS_MISC2__DATA_MASK 0xffffffff
#define MC_DLB_STATUS_MISC2__DATA__SHIFT 0x0
#define MC_DLB_STATUS_MISC3__DATA_MASK 0xffffffff
#define MC_DLB_STATUS_MISC3__DATA__SHIFT 0x0
#define MC_DLB_STATUS_MISC4__DATA_MASK 0xffffffff
#define MC_DLB_STATUS_MISC4__DATA__SHIFT 0x0
#define MC_DLB_STATUS_MISC5__DATA_MASK 0xffffffff
#define MC_DLB_STATUS_MISC5__DATA__SHIFT 0x0
#define MC_DLB_STATUS_MISC6__DATA_MASK 0xffffffff
#define MC_DLB_STATUS_MISC6__DATA__SHIFT 0x0
#define MC_DLB_STATUS_MISC7__DATA_MASK 0xffffffff
#define MC_DLB_STATUS_MISC7__DATA__SHIFT 0x0
#define MC_ARB_HARSH_EN_RD__TX_PRI_MASK 0xff
#define MC_ARB_HARSH_EN_RD__TX_PRI__SHIFT 0x0
#define MC_ARB_HARSH_EN_RD__BW_PRI_MASK 0xff00
#define MC_ARB_HARSH_EN_RD__BW_PRI__SHIFT 0x8
#define MC_ARB_HARSH_EN_RD__FIX_PRI_MASK 0xff0000
#define MC_ARB_HARSH_EN_RD__FIX_PRI__SHIFT 0x10
#define MC_ARB_HARSH_EN_RD__ST_PRI_MASK 0xff000000
#define MC_ARB_HARSH_EN_RD__ST_PRI__SHIFT 0x18
#define MC_ARB_HARSH_EN_WR__TX_PRI_MASK 0xff
#define MC_ARB_HARSH_EN_WR__TX_PRI__SHIFT 0x0
#define MC_ARB_HARSH_EN_WR__BW_PRI_MASK 0xff00
#define MC_ARB_HARSH_EN_WR__BW_PRI__SHIFT 0x8
#define MC_ARB_HARSH_EN_WR__FIX_PRI_MASK 0xff0000
#define MC_ARB_HARSH_EN_WR__FIX_PRI__SHIFT 0x10
#define MC_ARB_HARSH_EN_WR__ST_PRI_MASK 0xff000000
#define MC_ARB_HARSH_EN_WR__ST_PRI__SHIFT 0x18
#define MC_ARB_HARSH_TX_HI0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_TX_HI0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_TX_HI0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_TX_HI0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_TX_HI0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_TX_HI0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_TX_HI0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_TX_HI0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_TX_HI0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_TX_HI0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_TX_HI0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_TX_HI0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_TX_HI0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_TX_HI0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_TX_HI0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_TX_HI0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_TX_HI1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_TX_HI1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_TX_HI1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_TX_HI1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_TX_HI1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_TX_HI1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_TX_HI1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_TX_HI1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_TX_HI1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_TX_HI1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_TX_HI1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_TX_HI1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_TX_HI1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_TX_HI1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_TX_HI1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_TX_HI1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_TX_LO0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_TX_LO0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_TX_LO0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_TX_LO0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_TX_LO0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_TX_LO0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_TX_LO0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_TX_LO0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_TX_LO0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_TX_LO0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_TX_LO0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_TX_LO0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_TX_LO0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_TX_LO0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_TX_LO0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_TX_LO0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_TX_LO1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_TX_LO1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_TX_LO1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_TX_LO1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_TX_LO1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_TX_LO1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_TX_LO1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_TX_LO1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_TX_LO1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_TX_LO1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_TX_LO1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_TX_LO1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_TX_LO1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_TX_LO1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_TX_LO1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_TX_LO1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_BWCNT0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_BWCNT0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_BWCNT0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_BWCNT0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_BWCNT0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_BWCNT0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_BWCNT0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_BWCNT0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_BWCNT0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_BWCNT0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_BWCNT0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_BWCNT0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_BWCNT0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_BWCNT0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_BWCNT0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_BWCNT0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_BWCNT1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_BWCNT1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_BWCNT1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_BWCNT1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_BWCNT1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_BWCNT1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_BWCNT1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_BWCNT1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_BWCNT1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_BWCNT1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_BWCNT1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_BWCNT1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_BWCNT1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_BWCNT1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_BWCNT1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_BWCNT1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_SAT0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_SAT0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_SAT0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_SAT0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_SAT0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_SAT0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_SAT0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_SAT0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_SAT0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_SAT0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_SAT0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_SAT0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_SAT0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_SAT0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_SAT0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_SAT0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_SAT1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_SAT1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_SAT1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_SAT1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_SAT1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_SAT1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_SAT1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_SAT1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_SAT1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_SAT1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_SAT1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_SAT1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_SAT1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_SAT1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_SAT1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_SAT1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_CTL_RD__FORCE_HIGHEST_MASK 0xff
#define MC_ARB_HARSH_CTL_RD__FORCE_HIGHEST__SHIFT 0x0
#define MC_ARB_HARSH_CTL_RD__HARSH_RR_MASK 0x100
#define MC_ARB_HARSH_CTL_RD__HARSH_RR__SHIFT 0x8
#define MC_ARB_HARSH_CTL_RD__BANK_AGE_ONLY_MASK 0x200
#define MC_ARB_HARSH_CTL_RD__BANK_AGE_ONLY__SHIFT 0x9
#define MC_ARB_HARSH_CTL_RD__USE_LEGACY_HARSH_MASK 0x400
#define MC_ARB_HARSH_CTL_RD__USE_LEGACY_HARSH__SHIFT 0xa
#define MC_ARB_HARSH_CTL_RD__BWCNT_CATCHUP_MASK 0x800
#define MC_ARB_HARSH_CTL_RD__BWCNT_CATCHUP__SHIFT 0xb
#define MC_ARB_HARSH_CTL_RD__ST_MODE_MASK 0x3000
#define MC_ARB_HARSH_CTL_RD__ST_MODE__SHIFT 0xc
#define MC_ARB_HARSH_CTL_RD__FORCE_STALL_MASK 0x3fc000
#define MC_ARB_HARSH_CTL_RD__FORCE_STALL__SHIFT 0xe
#define MC_ARB_HARSH_CTL_RD__PERF_MON_SEL_MASK 0x1c00000
#define MC_ARB_HARSH_CTL_RD__PERF_MON_SEL__SHIFT 0x16
#define MC_ARB_HARSH_CTL_WR__FORCE_HIGHEST_MASK 0xff
#define MC_ARB_HARSH_CTL_WR__FORCE_HIGHEST__SHIFT 0x0
#define MC_ARB_HARSH_CTL_WR__HARSH_RR_MASK 0x100
#define MC_ARB_HARSH_CTL_WR__HARSH_RR__SHIFT 0x8
#define MC_ARB_HARSH_CTL_WR__BANK_AGE_ONLY_MASK 0x200
#define MC_ARB_HARSH_CTL_WR__BANK_AGE_ONLY__SHIFT 0x9
#define MC_ARB_HARSH_CTL_WR__USE_LEGACY_HARSH_MASK 0x400
#define MC_ARB_HARSH_CTL_WR__USE_LEGACY_HARSH__SHIFT 0xa
#define MC_ARB_HARSH_CTL_WR__BWCNT_CATCHUP_MASK 0x800
#define MC_ARB_HARSH_CTL_WR__BWCNT_CATCHUP__SHIFT 0xb
#define MC_ARB_HARSH_CTL_WR__ST_MODE_MASK 0x3000
#define MC_ARB_HARSH_CTL_WR__ST_MODE__SHIFT 0xc
#define MC_ARB_HARSH_CTL_WR__FORCE_STALL_MASK 0x3fc000
#define MC_ARB_HARSH_CTL_WR__FORCE_STALL__SHIFT 0xe
#define MC_ARB_HARSH_CTL_WR__PERF_MON_SEL_MASK 0x1c00000
#define MC_ARB_HARSH_CTL_WR__PERF_MON_SEL__SHIFT 0x16
#define MC_ARB_GRUB_PRIORITY1_RD__CB0_MASK 0x3
#define MC_ARB_GRUB_PRIORITY1_RD__CB0__SHIFT 0x0
#define MC_ARB_GRUB_PRIORITY1_RD__CBCMASK0_MASK 0xc
#define MC_ARB_GRUB_PRIORITY1_RD__CBCMASK0__SHIFT 0x2
#define MC_ARB_GRUB_PRIORITY1_RD__CBFMASK0_MASK 0x30
#define MC_ARB_GRUB_PRIORITY1_RD__CBFMASK0__SHIFT 0x4
#define MC_ARB_GRUB_PRIORITY1_RD__DB0_MASK 0xc0
#define MC_ARB_GRUB_PRIORITY1_RD__DB0__SHIFT 0x6
#define MC_ARB_GRUB_PRIORITY1_RD__DBHTILE0_MASK 0x300
#define MC_ARB_GRUB_PRIORITY1_RD__DBHTILE0__SHIFT 0x8
#define MC_ARB_GRUB_PRIORITY1_RD__DBSTEN0_MASK 0xc00
#define MC_ARB_GRUB_PRIORITY1_RD__DBSTEN0__SHIFT 0xa
#define MC_ARB_GRUB_PRIORITY1_RD__TC0_MASK 0x3000
#define MC_ARB_GRUB_PRIORITY1_RD__TC0__SHIFT 0xc
#define MC_ARB_GRUB_PRIORITY1_RD__ACPG_MASK 0xc000
#define MC_ARB_GRUB_PRIORITY1_RD__ACPG__SHIFT 0xe
#define MC_ARB_GRUB_PRIORITY1_RD__ACPO_MASK 0x30000
#define MC_ARB_GRUB_PRIORITY1_RD__ACPO__SHIFT 0x10
#define MC_ARB_GRUB_PRIORITY1_RD__DMIF_MASK 0xc0000
#define MC_ARB_GRUB_PRIORITY1_RD__DMIF__SHIFT 0x12
#define MC_ARB_GRUB_PRIORITY1_RD__DMIF_EXT0_MASK 0x300000
#define MC_ARB_GRUB_PRIORITY1_RD__DMIF_EXT0__SHIFT 0x14
#define MC_ARB_GRUB_PRIORITY1_RD__DMIF_EXT1_MASK 0xc00000
#define MC_ARB_GRUB_PRIORITY1_RD__DMIF_EXT1__SHIFT 0x16
#define MC_ARB_GRUB_PRIORITY1_RD__DMIF_TW_MASK 0x3000000
#define MC_ARB_GRUB_PRIORITY1_RD__DMIF_TW__SHIFT 0x18
#define MC_ARB_GRUB_PRIORITY1_RD__MCIF_MASK 0xc000000
#define MC_ARB_GRUB_PRIORITY1_RD__MCIF__SHIFT 0x1a
#define MC_ARB_GRUB_PRIORITY1_RD__RLC_MASK 0x30000000
#define MC_ARB_GRUB_PRIORITY1_RD__RLC__SHIFT 0x1c
#define MC_ARB_GRUB_PRIORITY1_RD__VMC_MASK 0xc0000000
#define MC_ARB_GRUB_PRIORITY1_RD__VMC__SHIFT 0x1e
#define MC_ARB_GRUB_PRIORITY1_WR__CB0_MASK 0x3
#define MC_ARB_GRUB_PRIORITY1_WR__CB0__SHIFT 0x0
#define MC_ARB_GRUB_PRIORITY1_WR__CBCMASK0_MASK 0xc
#define MC_ARB_GRUB_PRIORITY1_WR__CBCMASK0__SHIFT 0x2
#define MC_ARB_GRUB_PRIORITY1_WR__CBFMASK0_MASK 0x30
#define MC_ARB_GRUB_PRIORITY1_WR__CBFMASK0__SHIFT 0x4
#define MC_ARB_GRUB_PRIORITY1_WR__CBIMMED0_MASK 0xc0
#define MC_ARB_GRUB_PRIORITY1_WR__CBIMMED0__SHIFT 0x6
#define MC_ARB_GRUB_PRIORITY1_WR__DB0_MASK 0x300
#define MC_ARB_GRUB_PRIORITY1_WR__DB0__SHIFT 0x8
#define MC_ARB_GRUB_PRIORITY1_WR__DBHTILE0_MASK 0xc00
#define MC_ARB_GRUB_PRIORITY1_WR__DBHTILE0__SHIFT 0xa
#define MC_ARB_GRUB_PRIORITY1_WR__DBSTEN0_MASK 0x3000
#define MC_ARB_GRUB_PRIORITY1_WR__DBSTEN0__SHIFT 0xc
#define MC_ARB_GRUB_PRIORITY1_WR__TC0_MASK 0xc000
#define MC_ARB_GRUB_PRIORITY1_WR__TC0__SHIFT 0xe
#define MC_ARB_GRUB_PRIORITY1_WR__SH_MASK 0x30000
#define MC_ARB_GRUB_PRIORITY1_WR__SH__SHIFT 0x10
#define MC_ARB_GRUB_PRIORITY1_WR__ACPG_MASK 0xc0000
#define MC_ARB_GRUB_PRIORITY1_WR__ACPG__SHIFT 0x12
#define MC_ARB_GRUB_PRIORITY1_WR__ACPO_MASK 0x300000
#define MC_ARB_GRUB_PRIORITY1_WR__ACPO__SHIFT 0x14
#define MC_ARB_GRUB_PRIORITY1_WR__MCIF_MASK 0xc00000
#define MC_ARB_GRUB_PRIORITY1_WR__MCIF__SHIFT 0x16
#define MC_ARB_GRUB_PRIORITY1_WR__RLC_MASK 0x3000000
#define MC_ARB_GRUB_PRIORITY1_WR__RLC__SHIFT 0x18
#define MC_ARB_GRUB_PRIORITY1_WR__SDMA1_MASK 0xc000000
#define MC_ARB_GRUB_PRIORITY1_WR__SDMA1__SHIFT 0x1a
#define MC_ARB_GRUB_PRIORITY1_WR__SMU_MASK 0x30000000
#define MC_ARB_GRUB_PRIORITY1_WR__SMU__SHIFT 0x1c
#define MC_ARB_GRUB_PRIORITY1_WR__VCE0_MASK 0xc0000000
#define MC_ARB_GRUB_PRIORITY1_WR__VCE0__SHIFT 0x1e
#define MC_ARB_GRUB_PRIORITY2_RD__SDMA1_MASK 0x3
#define MC_ARB_GRUB_PRIORITY2_RD__SDMA1__SHIFT 0x0
#define MC_ARB_GRUB_PRIORITY2_RD__SMU_MASK 0xc
#define MC_ARB_GRUB_PRIORITY2_RD__SMU__SHIFT 0x2
#define MC_ARB_GRUB_PRIORITY2_RD__VCE0_MASK 0x30
#define MC_ARB_GRUB_PRIORITY2_RD__VCE0__SHIFT 0x4
#define MC_ARB_GRUB_PRIORITY2_RD__VCE1_MASK 0xc0
#define MC_ARB_GRUB_PRIORITY2_RD__VCE1__SHIFT 0x6
#define MC_ARB_GRUB_PRIORITY2_RD__XDMAM_MASK 0x300
#define MC_ARB_GRUB_PRIORITY2_RD__XDMAM__SHIFT 0x8
#define MC_ARB_GRUB_PRIORITY2_RD__SDMA0_MASK 0xc00
#define MC_ARB_GRUB_PRIORITY2_RD__SDMA0__SHIFT 0xa
#define MC_ARB_GRUB_PRIORITY2_RD__HDP_MASK 0x3000
#define MC_ARB_GRUB_PRIORITY2_RD__HDP__SHIFT 0xc
#define MC_ARB_GRUB_PRIORITY2_RD__UMC_MASK 0xc000
#define MC_ARB_GRUB_PRIORITY2_RD__UMC__SHIFT 0xe
#define MC_ARB_GRUB_PRIORITY2_RD__UVD_MASK 0x30000
#define MC_ARB_GRUB_PRIORITY2_RD__UVD__SHIFT 0x10
#define MC_ARB_GRUB_PRIORITY2_RD__UVD_EXT0_MASK 0xc0000
#define MC_ARB_GRUB_PRIORITY2_RD__UVD_EXT0__SHIFT 0x12
#define MC_ARB_GRUB_PRIORITY2_RD__UVD_EXT1_MASK 0x300000
#define MC_ARB_GRUB_PRIORITY2_RD__UVD_EXT1__SHIFT 0x14
#define MC_ARB_GRUB_PRIORITY2_RD__SEM_MASK 0xc00000
#define MC_ARB_GRUB_PRIORITY2_RD__SEM__SHIFT 0x16
#define MC_ARB_GRUB_PRIORITY2_RD__SAMMSP_MASK 0x3000000
#define MC_ARB_GRUB_PRIORITY2_RD__SAMMSP__SHIFT 0x18
#define MC_ARB_GRUB_PRIORITY2_RD__VP8_MASK 0xc000000
#define MC_ARB_GRUB_PRIORITY2_RD__VP8__SHIFT 0x1a
#define MC_ARB_GRUB_PRIORITY2_RD__ISP_MASK 0x30000000
#define MC_ARB_GRUB_PRIORITY2_RD__ISP__SHIFT 0x1c
#define MC_ARB_GRUB_PRIORITY2_RD__RSV2_MASK 0xc0000000
#define MC_ARB_GRUB_PRIORITY2_RD__RSV2__SHIFT 0x1e
#define MC_ARB_GRUB_PRIORITY2_WR__VCE1_MASK 0x3
#define MC_ARB_GRUB_PRIORITY2_WR__VCE1__SHIFT 0x0
#define MC_ARB_GRUB_PRIORITY2_WR__SAMMSP_MASK 0xc
#define MC_ARB_GRUB_PRIORITY2_WR__SAMMSP__SHIFT 0x2
#define MC_ARB_GRUB_PRIORITY2_WR__XDMA_MASK 0x30
#define MC_ARB_GRUB_PRIORITY2_WR__XDMA__SHIFT 0x4
#define MC_ARB_GRUB_PRIORITY2_WR__XDMAM_MASK 0xc0
#define MC_ARB_GRUB_PRIORITY2_WR__XDMAM__SHIFT 0x6
#define MC_ARB_GRUB_PRIORITY2_WR__SDMA0_MASK 0x300
#define MC_ARB_GRUB_PRIORITY2_WR__SDMA0__SHIFT 0x8
#define MC_ARB_GRUB_PRIORITY2_WR__HDP_MASK 0xc00
#define MC_ARB_GRUB_PRIORITY2_WR__HDP__SHIFT 0xa
#define MC_ARB_GRUB_PRIORITY2_WR__UMC_MASK 0x3000
#define MC_ARB_GRUB_PRIORITY2_WR__UMC__SHIFT 0xc
#define MC_ARB_GRUB_PRIORITY2_WR__UVD_MASK 0xc000
#define MC_ARB_GRUB_PRIORITY2_WR__UVD__SHIFT 0xe
#define MC_ARB_GRUB_PRIORITY2_WR__UVD_EXT0_MASK 0x30000
#define MC_ARB_GRUB_PRIORITY2_WR__UVD_EXT0__SHIFT 0x10
#define MC_ARB_GRUB_PRIORITY2_WR__UVD_EXT1_MASK 0xc0000
#define MC_ARB_GRUB_PRIORITY2_WR__UVD_EXT1__SHIFT 0x12
#define MC_ARB_GRUB_PRIORITY2_WR__XDP_MASK 0x300000
#define MC_ARB_GRUB_PRIORITY2_WR__XDP__SHIFT 0x14
#define MC_ARB_GRUB_PRIORITY2_WR__SEM_MASK 0xc00000
#define MC_ARB_GRUB_PRIORITY2_WR__SEM__SHIFT 0x16
#define MC_ARB_GRUB_PRIORITY2_WR__IH_MASK 0x3000000
#define MC_ARB_GRUB_PRIORITY2_WR__IH__SHIFT 0x18
#define MC_ARB_GRUB_PRIORITY2_WR__VP8_MASK 0xc000000
#define MC_ARB_GRUB_PRIORITY2_WR__VP8__SHIFT 0x1a
#define MC_ARB_GRUB_PRIORITY2_WR__ISP_MASK 0x30000000
#define MC_ARB_GRUB_PRIORITY2_WR__ISP__SHIFT 0x1c
#define MC_ARB_GRUB_PRIORITY2_WR__VIN0_MASK 0xc0000000
#define MC_ARB_GRUB_PRIORITY2_WR__VIN0__SHIFT 0x1e
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE_MASK 0x1
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE__SHIFT 0x0
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ_MASK 0x2
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ__SHIFT 0x1
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN_MASK 0x10
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN__SHIFT 0x4
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK_MASK 0x20
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK__SHIFT 0x5
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN_MASK 0x40
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN__SHIFT 0x6
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK_MASK 0xf00
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK__SHIFT 0x8
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID_MASK 0xf0000
#define MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID__SHIFT 0x10
#define MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R_MASK 0x1fff
#define MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R__SHIFT 0x0
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS_MASK 0x1
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS__SHIFT 0x0
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS_MASK 0x2
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS__SHIFT 0x1
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF_MASK 0x70
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF__SHIFT 0x4
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS_MASK 0x80
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS__SHIFT 0x7
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG_MASK 0xf00
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG__SHIFT 0x8
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L_MASK 0x1fff000
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L__SHIFT 0xc
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF_MASK 0x70000000
#define MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF__SHIFT 0x1c
#define MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH_MASK 0xff00
#define MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH__SHIFT 0x8
#define MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH_MASK 0xff000000
#define MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH__SHIFT 0x18
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE_MASK 0x1
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE__SHIFT 0x0
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED_MASK 0x2
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED__SHIFT 0x1
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED_MASK 0x4
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED__SHIFT 0x2
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW_MASK 0x8
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW__SHIFT 0x3
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE_MASK 0x10
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE__SHIFT 0x4
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE_MASK 0xe0
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE__SHIFT 0x5
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG_MASK 0xf00
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG__SHIFT 0x8
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF_MASK 0x7000
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF__SHIFT 0xc
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD_MASK 0x8000
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD__SHIFT 0xf
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L_MASK 0x1fff0000
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L__SHIFT 0x10
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR_MASK 0x20000000
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR__SHIFT 0x1d
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR_MASK 0x40000000
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR__SHIFT 0x1e
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR_MASK 0x80000000
#define MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR__SHIFT 0x1f
#define MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R_MASK 0x1fff
#define MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R__SHIFT 0x0
#define MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT_MASK 0x2000
#define MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT__SHIFT 0xd
#define MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH_MASK 0x4000
#define MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH__SHIFT 0xe
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE_MASK 0x1
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE__SHIFT 0x0
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED_MASK 0x2
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED__SHIFT 0x1
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED_MASK 0x4
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED__SHIFT 0x2
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW_MASK 0x8
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW__SHIFT 0x3
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE_MASK 0x10
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE__SHIFT 0x4
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE_MASK 0xe0
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE__SHIFT 0x5
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG_MASK 0xf00
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG__SHIFT 0x8
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF_MASK 0x7000
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF__SHIFT 0xc
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD_MASK 0x8000
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD__SHIFT 0xf
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L_MASK 0x1fff0000
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L__SHIFT 0x10
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR_MASK 0x20000000
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR__SHIFT 0x1d
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR_MASK 0x40000000
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR__SHIFT 0x1e
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR_MASK 0x80000000
#define MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR__SHIFT 0x1f
#define MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R_MASK 0x1fff
#define MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R__SHIFT 0x0
#define MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT_MASK 0x2000
#define MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT__SHIFT 0xd
#define MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH_MASK 0x4000
#define MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH__SHIFT 0xe
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE_MASK 0x1
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE__SHIFT 0x0
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED_MASK 0x2
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED__SHIFT 0x1
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED_MASK 0x4
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED__SHIFT 0x2
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW_MASK 0x8
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW__SHIFT 0x3
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE_MASK 0x10
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE__SHIFT 0x4
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE_MASK 0xe0
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE__SHIFT 0x5
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG_MASK 0xf00
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG__SHIFT 0x8
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF_MASK 0x7000
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF__SHIFT 0xc
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD_MASK 0x8000
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD__SHIFT 0xf
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L_MASK 0x1fff0000
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L__SHIFT 0x10
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR_MASK 0x20000000
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR__SHIFT 0x1d
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR_MASK 0x40000000
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR__SHIFT 0x1e
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR_MASK 0x80000000
#define MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR__SHIFT 0x1f
#define MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R_MASK 0x1fff
#define MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R__SHIFT 0x0
#define MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT_MASK 0x2000
#define MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT__SHIFT 0xd
#define MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH_MASK 0x4000
#define MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH__SHIFT 0xe
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE_MASK 0x1
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE__SHIFT 0x0
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED_MASK 0x2
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED__SHIFT 0x1
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED_MASK 0x4
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED__SHIFT 0x2
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW_MASK 0x8
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW__SHIFT 0x3
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE_MASK 0x10
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE__SHIFT 0x4
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE_MASK 0xe0
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE__SHIFT 0x5
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG_MASK 0xf00
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG__SHIFT 0x8
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF_MASK 0x7000
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF__SHIFT 0xc
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD_MASK 0x8000
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD__SHIFT 0xf
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L_MASK 0x1fff0000
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L__SHIFT 0x10
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR_MASK 0x20000000
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR__SHIFT 0x1d
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR_MASK 0x40000000
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR__SHIFT 0x1e
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR_MASK 0x80000000
#define MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR__SHIFT 0x1f
#define MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R_MASK 0x1fff
#define MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R__SHIFT 0x0
#define MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT_MASK 0x2000
#define MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT__SHIFT 0xd
#define MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH_MASK 0x4000
#define MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH__SHIFT 0xe
#define MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE_MASK 0x3
#define MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE__SHIFT 0x0
#define MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL_MASK 0xfc000000
#define MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL__SHIFT 0x1a
#define MCIF_WB_URGENCY_WATERMARK__MCIF_WB_CLIENT0_URGENCY_WATERMARK_MASK 0xffff
#define MCIF_WB_URGENCY_WATERMARK__MCIF_WB_CLIENT0_URGENCY_WATERMARK__SHIFT 0x0
#define MCIF_WB_URGENCY_WATERMARK__MCIF_WB_CLIENT1_URGENCY_WATERMARK_MASK 0xffff0000
#define MCIF_WB_URGENCY_WATERMARK__MCIF_WB_CLIENT1_URGENCY_WATERMARK__SHIFT 0x10
#define MCIF_WB_TEST_DEBUG_INDEX__MCIF_WB_TEST_DEBUG_INDEX_MASK 0xff
#define MCIF_WB_TEST_DEBUG_INDEX__MCIF_WB_TEST_DEBUG_INDEX__SHIFT 0x0
#define MCIF_WB_TEST_DEBUG_INDEX__MCIF_WB_TEST_DEBUG_WRITE_EN_MASK 0x100
#define MCIF_WB_TEST_DEBUG_INDEX__MCIF_WB_TEST_DEBUG_WRITE_EN__SHIFT 0x8
#define MCIF_WB_TEST_DEBUG_DATA__MCIF_WB_TEST_DEBUG_DATA_MASK 0xffffffff
#define MCIF_WB_TEST_DEBUG_DATA__MCIF_WB_TEST_DEBUG_DATA__SHIFT 0x0
#define MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y_MASK 0xffffffff
#define MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y__SHIFT 0x0
#define MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET_MASK 0x3ffff
#define MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET__SHIFT 0x0
#define MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C_MASK 0xffffffff
#define MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C__SHIFT 0x0
#define MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET_MASK 0x3ffff
#define MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET__SHIFT 0x0
#define MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y_MASK 0xffffffff
#define MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y__SHIFT 0x0
#define MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET_MASK 0x3ffff
#define MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET__SHIFT 0x0
#define MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C_MASK 0xffffffff
#define MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C__SHIFT 0x0
#define MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET_MASK 0x3ffff
#define MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET__SHIFT 0x0
#define MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y_MASK 0xffffffff
#define MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y__SHIFT 0x0
#define MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET_MASK 0x3ffff
#define MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET__SHIFT 0x0
#define MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C_MASK 0xffffffff
#define MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C__SHIFT 0x0
#define MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET_MASK 0x3ffff
#define MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET__SHIFT 0x0
#define MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y_MASK 0xffffffff
#define MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y__SHIFT 0x0
#define MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET_MASK 0x3ffff
#define MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET__SHIFT 0x0
#define MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C_MASK 0xffffffff
#define MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C__SHIFT 0x0
#define MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET_MASK 0x3ffff
#define MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET__SHIFT 0x0
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE_MASK 0x1
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE__SHIFT 0x0
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN_MASK 0x10
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN__SHIFT 0x4
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK_MASK 0x20
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK__SHIFT 0x5
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN_MASK 0x40
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN__SHIFT 0x6
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_MASK 0xf00
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK__SHIFT 0x8
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE_MASK 0x1fff0000
#define MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE__SHIFT 0x10
#define MCIF_WB_HVVMID_CONTROL__MCIF_WB_DEFAULT_VMID_MASK 0xf00
#define MCIF_WB_HVVMID_CONTROL__MCIF_WB_DEFAULT_VMID__SHIFT 0x8
#define MCIF_WB_HVVMID_CONTROL__MCIF_WB_ALLOWED_VMID_MASK_MASK 0xffff0000
#define MCIF_WB_HVVMID_CONTROL__MCIF_WB_ALLOWED_VMID_MASK__SHIFT 0x10

#endif /* GMC_8_1_SH_MASK_H */
