/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public final class Modifier
extends ASTNode
implements IExtendedModifier {
    public static final int NONE = 0;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;
    public static final SimplePropertyDescriptor KEYWORD_PROPERTY = new SimplePropertyDescriptor(class$org$eclipse$jdt$core$dom$Modifier == null ? (class$org$eclipse$jdt$core$dom$Modifier = Modifier.class$("org.eclipse.jdt.core.dom.Modifier")) : class$org$eclipse$jdt$core$dom$Modifier, "keyword", class$org$eclipse$jdt$core$dom$Modifier$ModifierKeyword == null ? (class$org$eclipse$jdt$core$dom$Modifier$ModifierKeyword = Modifier.class$("org.eclipse.jdt.core.dom.Modifier$ModifierKeyword")) : class$org$eclipse$jdt$core$dom$Modifier$ModifierKeyword, MANDATORY);
    private static final List PROPERTY_DESCRIPTORS;
    private ModifierKeyword modifierKeyword = ModifierKeyword.PUBLIC_KEYWORD;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Modifier;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Modifier$ModifierKeyword;

    public static boolean isPublic(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isPrivate(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isProtected(int flags) {
        return (flags & 4) != 0;
    }

    public static boolean isStatic(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isFinal(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean isSynchronized(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isVolatile(int flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean isTransient(int flags) {
        return (flags & 0x80) != 0;
    }

    public static boolean isNative(int flags) {
        return (flags & 0x100) != 0;
    }

    public static boolean isAbstract(int flags) {
        return (flags & 0x400) != 0;
    }

    public static boolean isStrictfp(int flags) {
        return (flags & 0x800) != 0;
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    Modifier(AST ast) {
        super(ast);
        this.unsupportedIn2();
    }

    final List internalStructuralPropertiesForType(int apiLevel) {
        return Modifier.propertyDescriptors(apiLevel);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == KEYWORD_PROPERTY) {
            if (get) {
                return this.getKeyword();
            }
            this.setKeyword((ModifierKeyword)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    final int getNodeType0() {
        return 83;
    }

    public boolean isModifier() {
        return true;
    }

    public boolean isAnnotation() {
        return false;
    }

    ASTNode clone0(AST target) {
        Modifier result = new Modifier(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setKeyword(this.getKeyword());
        return result;
    }

    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public ModifierKeyword getKeyword() {
        return this.modifierKeyword;
    }

    public void setKeyword(ModifierKeyword modifierKeyord) {
        if (modifierKeyord == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(KEYWORD_PROPERTY);
        this.modifierKeyword = modifierKeyord;
        this.postValueChange(KEYWORD_PROPERTY);
    }

    int memSize() {
        return 44;
    }

    int treeSize() {
        return this.memSize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList properyList = new ArrayList(2);
        Modifier.createPropertyList(class$org$eclipse$jdt$core$dom$Modifier == null ? (class$org$eclipse$jdt$core$dom$Modifier = Modifier.class$("org.eclipse.jdt.core.dom.Modifier")) : class$org$eclipse$jdt$core$dom$Modifier, properyList);
        Modifier.addProperty(KEYWORD_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = Modifier.reapPropertyList(properyList);
    }

    public static class ModifierKeyword {
        public static final ModifierKeyword PUBLIC_KEYWORD = new ModifierKeyword("public", 1);
        public static final ModifierKeyword PROTECTED_KEYWORD = new ModifierKeyword("protected", 4);
        public static final ModifierKeyword PRIVATE_KEYWORD = new ModifierKeyword("private", 2);
        public static final ModifierKeyword STATIC_KEYWORD = new ModifierKeyword("static", 8);
        public static final ModifierKeyword ABSTRACT_KEYWORD = new ModifierKeyword("abstract", 1024);
        public static final ModifierKeyword FINAL_KEYWORD = new ModifierKeyword("final", 16);
        public static final ModifierKeyword NATIVE_KEYWORD = new ModifierKeyword("native", 256);
        public static final ModifierKeyword SYNCHRONIZED_KEYWORD = new ModifierKeyword("synchronized", 32);
        public static final ModifierKeyword TRANSIENT_KEYWORD = new ModifierKeyword("transient", 128);
        public static final ModifierKeyword VOLATILE_KEYWORD = new ModifierKeyword("volatile", 64);
        public static final ModifierKeyword STRICTFP_KEYWORD = new ModifierKeyword("strictfp", 2048);
        private static final Map KEYWORDS = new HashMap(20);
        private String keyword;
        private int flagValue;

        private ModifierKeyword(String keyword, int flagValue) {
            this.keyword = keyword;
            this.flagValue = flagValue;
        }

        public String toString() {
            return this.keyword;
        }

        public static ModifierKeyword toKeyword(String keyword) {
            return (ModifierKeyword)KEYWORDS.get(keyword);
        }

        public int toFlagValue() {
            return this.flagValue;
        }

        public static ModifierKeyword fromFlagValue(int flagValue) {
            Iterator it = KEYWORDS.values().iterator();
            while (it.hasNext()) {
                ModifierKeyword k = (ModifierKeyword)it.next();
                if (k.toFlagValue() != flagValue) continue;
                return k;
            }
            return null;
        }

        static {
            ModifierKeyword[] ops = new ModifierKeyword[]{PUBLIC_KEYWORD, PROTECTED_KEYWORD, PRIVATE_KEYWORD, STATIC_KEYWORD, ABSTRACT_KEYWORD, FINAL_KEYWORD, NATIVE_KEYWORD, SYNCHRONIZED_KEYWORD, TRANSIENT_KEYWORD, VOLATILE_KEYWORD, STRICTFP_KEYWORD};
            for (int i = 0; i < ops.length; ++i) {
                KEYWORDS.put(ops[i].toString(), ops[i]);
            }
        }
    }
}

