/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public final class ArrayBinding
extends TypeBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, BaseTypes.IntBinding, 17, null, Constant.NotAConstant);
    public TypeBinding leafComponentType;
    public int dimensions;
    char[] constantPoolName;

    public ArrayBinding(TypeBinding type, int dimensions) {
        this.tagBits |= 1;
        this.leafComponentType = type;
        this.dimensions = dimensions;
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] brackets = new char[this.dimensions];
        for (int i = this.dimensions - 1; i >= 0; --i) {
            brackets[i] = 91;
        }
        this.constantPoolName = CharOperation.concat(brackets, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    String debugName() {
        StringBuffer brackets = new StringBuffer(this.dimensions * 2);
        int i = this.dimensions;
        while (--i >= 0) {
            brackets.append("[]");
        }
        return this.leafComponentType.debugName() + brackets.toString();
    }

    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType(Scope scope) {
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        return scope.createArray(this.leafComponentType, this.dimensions - 1);
    }

    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    public boolean isCompatibleWith(TypeBinding right) {
        if (this == right) {
            return true;
        }
        if (right.isArrayType()) {
            ArrayBinding rightArray = (ArrayBinding)right;
            if (rightArray.leafComponentType.isBaseType()) {
                return false;
            }
            if (this.dimensions == rightArray.dimensions) {
                return this.leafComponentType.isCompatibleWith(rightArray.leafComponentType);
            }
            if (this.dimensions < rightArray.dimensions) {
                return false;
            }
        } else if (right.isBaseType()) {
            return false;
        }
        switch (right.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    public int problemId() {
        return this.leafComponentType.problemId();
    }

    public char[] qualifiedSourceName() {
        char[] brackets = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), brackets);
    }

    public char[] readableName() {
        char[] brackets = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), brackets);
    }

    public char[] shortReadableName() {
        char[] brackets = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), brackets);
    }

    public char[] sourceName() {
        char[] brackets = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), brackets);
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }
}

