/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.internal.codeassist.ISearchableNameEnvironment;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProjectElementInfo;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SetClasspathOperation;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.XMLWriter;
import org.eclipse.jdt.internal.core.eval.EvaluationContextWrapper;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.eval.EvaluationContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaProject
extends Openable
implements IJavaProject,
IProjectNature,
SuffixConstants {
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    protected static final String[] NO_PREREQUISITES = new String[0];
    protected IProject project;
    public static final String CLASSPATH_FILENAME = ".classpath";
    public static final String PREF_FILENAME = ".jprefs";
    public static final IClasspathEntry[] INVALID_CLASSPATH = new IClasspathEntry[0];
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";
    private static final IClasspathEntry[] RESOLUTION_IN_PROGRESS = new IClasspathEntry[0];

    public static IPath canonicalizedPath(IPath externalPath) {
        Path result;
        if (externalPath == null) {
            return null;
        }
        if (IS_CASE_SENSITIVE) {
            return externalPath;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        Path canonicalPath = null;
        try {
            canonicalPath = new Path(new File(externalPath.toOSString()).getCanonicalPath());
        }
        catch (IOException e) {
            return externalPath;
        }
        int canonicalLength = canonicalPath.segmentCount();
        if (canonicalLength == 0) {
            return externalPath;
        }
        if (externalPath.isAbsolute()) {
            result = canonicalPath;
        } else {
            int externalLength = externalPath.segmentCount();
            if (canonicalLength >= externalLength) {
                result = canonicalPath.removeFirstSegments(canonicalLength - externalLength);
            } else {
                return externalPath;
            }
        }
        if (externalPath.getDevice() == null) {
            result = result.setDevice(null);
        }
        return result;
    }

    public JavaProject() {
        super(null, null);
    }

    public JavaProject(IProject project, JavaElement parent) {
        super(parent, project.getName());
        this.project = project;
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        int javaCommandIndex = this.getJavaCommandIndex(description.getBuildSpec());
        if (javaCommandIndex == -1) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setJavaCommand(description, command);
        }
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wRoot = workspace.getRoot();
        IClasspathEntry[] resolvedClasspath = this.getResolvedClasspath(true, false, false);
        info.setChildren(this.computePackageFragmentRoots(resolvedClasspath, false));
        int length = resolvedClasspath.length;
        for (int i = 0; i < length; ++i) {
            Hashtable externalTimeStamps;
            IPath path;
            Object target;
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getEntryKind() != 1 || !((target = JavaModel.getTarget((IContainer)wRoot, path = entry.getPath(), true)) instanceof File) || (externalTimeStamps = JavaModelManager.getJavaModelManager().deltaState.externalTimeStamps).get(path) != null) continue;
            long timestamp = DeltaProcessor.getTimeStamp((File)target);
            externalTimeStamps.put(path, new Long(timestamp));
        }
        return true;
    }

    protected void closing(Object info) {
        IJavaElement[] children = ((JavaElementInfo)info).children;
        int length = children.length;
        for (int i = 0; i < length; ++i) {
            IJavaElement child = children[i];
            if (!(child instanceof JarPackageFragmentRoot)) continue;
            ((JarPackageFragmentRoot)child).setSourceAttachmentProperty(null);
        }
        super.closing(info);
    }

    public void computeChildren(JavaProjectElementInfo info) throws JavaModelException {
        IClasspathEntry[] classpath;
        block3: {
            IPackageFragmentRoot[] newRoots;
            classpath = this.getResolvedClasspath(true, false, false);
            IPackageFragmentRoot[] oldRoots = info.allPkgFragmentRootsCache;
            if (oldRoots != null && oldRoots.length == (newRoots = this.computePackageFragmentRoots(classpath, true)).length) {
                int length = oldRoots.length;
                for (int i = 0; i < length; ++i) {
                    if (oldRoots[i].equals(newRoots[i])) {
                        continue;
                    }
                    break block3;
                }
                return;
            }
        }
        info.resetCaches();
        info.setNonJavaResources(null);
        info.setChildren(this.computePackageFragmentRoots(classpath, false));
    }

    private void computeExpandedClasspath(JavaProject initialProject, boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, HashSet rootIDs, ObjectVector accumulatedEntries, Map preferredClasspaths, Map preferredOutputs) throws JavaModelException {
        String projectRootId = this.rootID();
        if (rootIDs.contains(projectRootId)) {
            return;
        }
        rootIDs.add(projectRootId);
        IClasspathEntry[] preferredClasspath = preferredClasspaths != null ? (IClasspathEntry[])preferredClasspaths.get(this) : null;
        IPath preferredOutput = preferredOutputs != null ? (IPath)preferredOutputs.get(this) : null;
        IClasspathEntry[] immediateClasspath = preferredClasspath != null ? this.getResolvedClasspath(preferredClasspath, preferredOutput, ignoreUnresolvedVariable, generateMarkerOnError, null) : this.getResolvedClasspath(ignoreUnresolvedVariable, generateMarkerOnError, false);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        boolean isInitialProject = this.equals(initialProject);
        int length = immediateClasspath.length;
        for (int i = 0; i < length; ++i) {
            String rootID;
            ClasspathEntry entry = (ClasspathEntry)immediateClasspath[i];
            if (!isInitialProject && !entry.isExported() || rootIDs.contains(rootID = entry.rootID())) continue;
            accumulatedEntries.add(entry);
            if (entry.getEntryKind() == 2) {
                IProject projRsc;
                IResource member = workspaceRoot.findMember(entry.getPath());
                if (member == null || member.getType() != 4 || !JavaProject.hasJavaNature(projRsc = (IProject)member)) continue;
                JavaProject javaProject = (JavaProject)JavaCore.create(projRsc);
                javaProject.computeExpandedClasspath(initialProject, ignoreUnresolvedVariable, false, rootIDs, accumulatedEntries, preferredClasspaths, preferredOutputs);
                continue;
            }
            rootIDs.add(rootID);
        }
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IClasspathEntry[] resolvedClasspath, boolean retrieveExportedRoots) throws JavaModelException {
        ObjectVector accumulatedRoots = new ObjectVector();
        this.computePackageFragmentRoots(resolvedClasspath, accumulatedRoots, new HashSet(5), true, true, retrieveExportedRoots);
        Object[] rootArray = new IPackageFragmentRoot[accumulatedRoots.size()];
        accumulatedRoots.copyInto(rootArray);
        return rootArray;
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IClasspathEntry resolvedEntry) {
        try {
            return this.computePackageFragmentRoots(new IClasspathEntry[]{resolvedEntry}, false);
        }
        catch (JavaModelException e) {
            return new IPackageFragmentRoot[0];
        }
    }

    public void computePackageFragmentRoots(IClasspathEntry resolvedEntry, ObjectVector accumulatedRoots, HashSet rootIDs, boolean insideOriginalProject, boolean checkExistency, boolean retrieveExportedRoots) throws JavaModelException {
        String rootID = ((ClasspathEntry)resolvedEntry).rootID();
        if (rootIDs.contains(rootID)) {
            return;
        }
        IPath projectPath = this.project.getFullPath();
        IPath entryPath = resolvedEntry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        switch (resolvedEntry.getEntryKind()) {
            case 3: {
                if (!projectPath.isPrefixOf(entryPath)) break;
                if (checkExistency) {
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!(target instanceof IFolder) && !(target instanceof IProject)) break;
                    accumulatedRoots.add(this.getPackageFragmentRoot((IResource)target));
                    rootIDs.add(rootID);
                    break;
                }
                IPackageFragmentRoot root = this.getFolderPackageFragmentRoot(entryPath);
                if (root == null) break;
                accumulatedRoots.add(root);
                rootIDs.add(rootID);
                break;
            }
            case 1: {
                if (!insideOriginalProject && !resolvedEntry.isExported()) {
                    return;
                }
                if (checkExistency) {
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (target instanceof IResource) {
                        IResource resource = (IResource)target;
                        IPackageFragmentRoot root = this.getPackageFragmentRoot(resource);
                        if (root == null) break;
                        accumulatedRoots.add(root);
                        rootIDs.add(rootID);
                        break;
                    }
                    if (!((File)target).isFile() || !org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(entryPath.lastSegment())) break;
                    accumulatedRoots.add(new JarPackageFragmentRoot(entryPath, this));
                    rootIDs.add(rootID);
                    break;
                }
                IPackageFragmentRoot root = this.getPackageFragmentRoot(entryPath);
                if (root == null) break;
                accumulatedRoots.add(root);
                rootIDs.add(rootID);
                break;
            }
            case 2: {
                IProject requiredProjectRsc;
                if (!retrieveExportedRoots) {
                    return;
                }
                if (!insideOriginalProject && !resolvedEntry.isExported()) {
                    return;
                }
                IResource member = workspaceRoot.findMember(entryPath);
                if (member == null || member.getType() != 4 || !JavaProject.hasJavaNature(requiredProjectRsc = (IProject)member)) break;
                rootIDs.add(rootID);
                JavaProject requiredProject = (JavaProject)JavaCore.create(requiredProjectRsc);
                requiredProject.computePackageFragmentRoots(requiredProject.getResolvedClasspath(true, false, false), accumulatedRoots, rootIDs, false, checkExistency, retrieveExportedRoots);
                break;
            }
        }
    }

    public void computePackageFragmentRoots(IClasspathEntry[] resolvedClasspath, ObjectVector accumulatedRoots, HashSet rootIDs, boolean insideOriginalProject, boolean checkExistency, boolean retrieveExportedRoots) throws JavaModelException {
        if (insideOriginalProject) {
            rootIDs.add(this.rootID());
        }
        int length = resolvedClasspath.length;
        for (int i = 0; i < length; ++i) {
            this.computePackageFragmentRoots(resolvedClasspath[i], accumulatedRoots, rootIDs, insideOriginalProject, checkExistency, retrieveExportedRoots);
        }
    }

    public String computeSharedPropertyFileName(QualifiedName qName) {
        return '.' + qName.getLocalName();
    }

    public void configure() throws CoreException {
        this.addToBuildSpec("org.eclipse.jdt.core.javabuilder");
    }

    public boolean contains(IResource resource) {
        IPath output;
        IClasspathEntry[] classpath;
        try {
            classpath = this.getResolvedClasspath(true, false, false);
            output = this.getOutputLocation();
        }
        catch (JavaModelException e) {
            return false;
        }
        IPath fullPath = resource.getFullPath();
        IPath innerMostOutput = output.isPrefixOf(fullPath) ? output : null;
        IClasspathEntry innerMostEntry = null;
        int cpLength = classpath.length;
        for (int j = 0; j < cpLength; ++j) {
            IPath entryOutput;
            IClasspathEntry entry = classpath[j];
            IPath entryPath = entry.getPath();
            if ((innerMostEntry == null || innerMostEntry.getPath().isPrefixOf(entryPath)) && entryPath.isPrefixOf(fullPath)) {
                innerMostEntry = entry;
            }
            if ((entryOutput = classpath[j].getOutputLocation()) == null || !entryOutput.isPrefixOf(fullPath)) continue;
            innerMostOutput = entryOutput;
        }
        if (innerMostEntry != null) {
            if (innerMostOutput != null && innerMostOutput.segmentCount() > 1 && innerMostEntry.getPath().segmentCount() == 1) {
                return false;
            }
            if (resource instanceof IFolder) {
                return true;
            }
            switch (innerMostEntry.getEntryKind()) {
                case 3: {
                    return !org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(fullPath.lastSegment());
                }
                case 1: {
                    return !org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(fullPath.lastSegment());
                }
            }
        }
        return innerMostOutput == null;
    }

    void createClasspathProblemMarker(IJavaModelStatus status) {
        block11: {
            int severity;
            IMarker marker = null;
            String[] arguments = new String[]{};
            boolean isCycleProblem = false;
            boolean isClasspathFileFormatProblem = false;
            switch (status.getCode()) {
                case 1001: {
                    isCycleProblem = true;
                    if ("error".equals(this.getOption("org.eclipse.jdt.core.circularClasspath", true))) {
                        severity = 2;
                        break;
                    }
                    severity = 1;
                    break;
                }
                case 1000: {
                    isClasspathFileFormatProblem = true;
                    severity = 2;
                    break;
                }
                case 1004: {
                    String setting = this.getOption("org.eclipse.jdt.core.incompatibleJDKLevel", true);
                    if ("error".equals(setting)) {
                        severity = 2;
                        break;
                    }
                    if ("warning".equals(setting)) {
                        severity = 1;
                        break;
                    }
                    return;
                }
                default: {
                    IPath path = status.getPath();
                    if (path != null) {
                        arguments = new String[]{path.toString()};
                    }
                    severity = "error".equals(this.getOption("org.eclipse.jdt.core.incompleteClasspath", true)) ? 2 : 1;
                }
            }
            try {
                marker = this.project.createMarker("org.eclipse.jdt.core.buildpath_problem");
                marker.setAttributes(new String[]{"message", "severity", "location", "cycleDetected", "classpathFileFormat", "id", "arguments"}, new Object[]{status.getMessage(), new Integer(severity), Util.bind("classpath.buildPath"), isCycleProblem ? "true" : "false", isClasspathFileFormatProblem ? "true" : "false", new Integer(status.getCode()), Util.getProblemArgumentsForMarker(arguments)});
            }
            catch (CoreException e) {
                if (!JavaModelManager.VERBOSE) break block11;
                e.printStackTrace();
            }
        }
    }

    protected Object createElementInfo() {
        return new JavaProjectElementInfo();
    }

    protected IClasspathEntry[] decodeClasspath(String xmlClasspath, boolean createMarker, boolean logProblems) {
        ArrayList<IClasspathEntry> paths = new ArrayList<IClasspathEntry>();
        IClasspathEntry defaultOutput = null;
        try {
            Element cpElement;
            if (xmlClasspath == null) {
                return null;
            }
            StringReader reader = new StringReader(xmlClasspath);
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (SAXException e) {
                throw new IOException(Util.bind("file.badFormat"));
            }
            catch (ParserConfigurationException e) {
                throw new IOException(Util.bind("file.badFormat"));
            }
            finally {
                reader.close();
            }
            if (!cpElement.getNodeName().equalsIgnoreCase("classpath")) {
                throw new IOException(Util.bind("file.badFormat"));
            }
            NodeList list = cpElement.getElementsByTagName("classpathentry");
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                IClasspathEntry entry;
                Node node = list.item(i);
                if (node.getNodeType() != 1 || (entry = ClasspathEntry.elementDecode((Element)node, this)) == null) continue;
                if (entry.getContentKind() == 10) {
                    defaultOutput = entry;
                    continue;
                }
                paths.add(entry);
            }
        }
        catch (IOException e) {
            if (createMarker && this.project.isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.xmlFormatError", this.getElementName(), e.getMessage())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will mark classpath as invalid");
            }
            return INVALID_CLASSPATH;
        }
        catch (Assert.AssertionFailedException e) {
            if (createMarker && this.project.isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.illegalEntryInClasspathFile", this.getElementName(), e.getMessage())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will mark classpath as invalid");
            }
            return INVALID_CLASSPATH;
        }
        int pathSize = paths.size();
        if (pathSize > 0 || defaultOutput != null) {
            IClasspathEntry[] entries = new IClasspathEntry[pathSize + (defaultOutput == null ? 0 : 1)];
            paths.toArray(entries);
            if (defaultOutput != null) {
                entries[pathSize] = defaultOutput;
            }
            return entries;
        }
        return null;
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.eclipse.jdt.core.javabuilder");
    }

    protected IClasspathEntry[] defaultClasspath() {
        return new IClasspathEntry[]{JavaCore.newSourceEntry(this.project.getFullPath())};
    }

    protected IPath defaultOutputLocation() {
        return this.project.getFullPath().append("bin");
    }

    protected String encodeClasspath(IClasspathEntry[] classpath, IPath outputLocation, boolean indent) throws JavaModelException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter(writer);
            xmlWriter.startTag("classpath", indent);
            for (int i = 0; i < classpath.length; ++i) {
                ((ClasspathEntry)classpath[i]).elementEncode(xmlWriter, this.project.getFullPath(), indent, true);
            }
            if (outputLocation != null) {
                outputLocation = outputLocation.removeFirstSegments(1);
                outputLocation = outputLocation.makeRelative();
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("kind", ClasspathEntry.kindToString(10));
                parameters.put("path", String.valueOf(outputLocation));
                xmlWriter.printTag("classpathentry", parameters, indent, true, true);
            }
            xmlWriter.endTag("classpath", indent);
            writer.flush();
            writer.close();
            return s.toString("UTF8");
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaProject)) {
            return false;
        }
        JavaProject other = (JavaProject)o;
        return this.project.equals(other.getProject()) && this.occurrenceCount == other.occurrenceCount;
    }

    public boolean exists() {
        return JavaProject.hasJavaNature(this.project);
    }

    public IJavaElement findElement(IPath path) throws JavaModelException {
        return this.findElement(path, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IJavaElement findElement(IPath path, WorkingCopyOwner owner) throws JavaModelException {
        if (path == null || path.isAbsolute()) {
            throw new JavaModelException(new JavaModelStatus(979, path));
        }
        try {
            String extension = path.getFileExtension();
            if (extension == null) {
                String packageName = path.toString().replace('/', '.');
                NameLookup lookup = this.newNameLookup((WorkingCopyOwner)null);
                IPackageFragment[] pkgFragments = lookup.findPackageFragments(packageName, false);
                if (pkgFragments == null) {
                    return null;
                }
                int length = pkgFragments.length;
                for (int i = 0; i < length; ++i) {
                    IPackageFragment pkgFragment = pkgFragments[i];
                    if (!this.equals(pkgFragment.getParent().getParent())) continue;
                    return pkgFragment;
                }
                return pkgFragments[0];
            }
            if (extension.equalsIgnoreCase("java") || extension.equalsIgnoreCase("class")) {
                IPath packagePath = path.removeLastSegments(1);
                String packageName = packagePath.toString().replace('/', '.');
                String typeName = path.lastSegment();
                typeName = typeName.substring(0, typeName.length() - extension.length() - 1);
                String qualifiedName = null;
                qualifiedName = packageName.length() > 0 ? packageName + "." + typeName : typeName;
                NameLookup lookup = this.newNameLookup(owner);
                IType type = lookup.findType(qualifiedName, false, 6);
                if (type != null) {
                    return type.getParent();
                }
                return null;
            }
            return null;
        }
        catch (JavaModelException e) {
            if (e.getStatus().getCode() == 969) {
                return null;
            }
            throw e;
        }
    }

    public IPackageFragment findPackageFragment(IPath path) throws JavaModelException {
        return this.findPackageFragment0(JavaProject.canonicalizedPath(path));
    }

    private IPackageFragment findPackageFragment0(IPath path) throws JavaModelException {
        NameLookup lookup = this.newNameLookup((WorkingCopyOwner)null);
        return lookup.findPackageFragment(path);
    }

    public IPackageFragmentRoot findPackageFragmentRoot(IPath path) throws JavaModelException {
        return this.findPackageFragmentRoot0(JavaProject.canonicalizedPath(path));
    }

    public IPackageFragmentRoot findPackageFragmentRoot0(IPath path) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = this.getAllPackageFragmentRoots();
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Util.bind("path.mustBeAbsolute"));
        }
        for (int i = 0; i < allRoots.length; ++i) {
            IPackageFragmentRoot classpathRoot = allRoots[i];
            if (!classpathRoot.getPath().equals(path)) continue;
            return classpathRoot;
        }
        return null;
    }

    public IPackageFragmentRoot[] findPackageFragmentRoots(IClasspathEntry entry) {
        try {
            IClasspathEntry[] classpath = this.getRawClasspath();
            int length = classpath.length;
            for (int i = 0; i < length; ++i) {
                if (!classpath[i].equals(entry)) continue;
                return this.computePackageFragmentRoots(this.getResolvedClasspath(new IClasspathEntry[]{entry}, null, true, false, null), false);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return new IPackageFragmentRoot[0];
    }

    public IType findType(String fullyQualifiedName) throws JavaModelException {
        return this.findType(fullyQualifiedName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IType findType(String fullyQualifiedName, WorkingCopyOwner owner) throws JavaModelException {
        NameLookup lookup = this.newNameLookup(owner);
        IType type = lookup.findType(fullyQualifiedName, false, 6);
        if (type == null) {
            int lastDot = fullyQualifiedName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            type = this.findType(fullyQualifiedName.substring(0, lastDot));
            if (type != null && !(type = type.getType(fullyQualifiedName.substring(lastDot + 1))).exists()) {
                return null;
            }
        }
        return type;
    }

    public IType findType(String packageName, String typeQualifiedName) throws JavaModelException {
        return this.findType(packageName, typeQualifiedName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IType findType(String packageName, String typeQualifiedName, WorkingCopyOwner owner) throws JavaModelException {
        NameLookup lookup = this.newNameLookup(owner);
        return lookup.findType(typeQualifiedName, packageName, false, 6);
    }

    protected void flushClasspathProblemMarkers(boolean flushCycleMarkers, boolean flushClasspathFormatMarkers) {
        block5: {
            try {
                if (this.project.isAccessible()) {
                    IMarker[] markers = this.project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
                    int length = markers.length;
                    for (int i = 0; i < length; ++i) {
                        IMarker marker = markers[i];
                        if (flushCycleMarkers && flushClasspathFormatMarkers) {
                            marker.delete();
                            continue;
                        }
                        String cycleAttr = (String)marker.getAttribute("cycleDetected");
                        String classpathFileFormatAttr = (String)marker.getAttribute("classpathFileFormat");
                        if (flushCycleMarkers != (cycleAttr != null && cycleAttr.equals("true")) || flushClasspathFormatMarkers != (classpathFileFormatAttr != null && classpathFileFormatAttr.equals("true"))) continue;
                        marker.delete();
                    }
                }
            }
            catch (CoreException e) {
                if (!JavaModelManager.VERBOSE) break block5;
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void forceClasspathReload(IProgressMonitor monitor) throws JavaModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        wasSuccessful = false;
        try {
            try {
                fileEntries = this.readClasspathFile(false, false);
                if (fileEntries != null) {
                    info = this.getPerProjectInfo();
                    if (info.rawClasspath != null && this.isClasspathEqualsTo(info.rawClasspath, info.outputLocation, fileEntries)) {
                        return;
                    }
                    outputLocation = null;
                    if (fileEntries != null && fileEntries.length > 0 && (entry = fileEntries[fileEntries.length - 1]).getContentKind() == 10) {
                        outputLocation = entry.getPath();
                        copy = new IClasspathEntry[fileEntries.length - 1];
                        System.arraycopy(fileEntries, 0, copy, 0, copy.length);
                        fileEntries = copy;
                    }
                    if (outputLocation == null) {
                        outputLocation = SetClasspathOperation.ReuseOutputLocation;
                    }
                    oldResolvedClasspath = info.resolvedClasspath;
                    this.setRawClasspath(fileEntries, outputLocation, monitor, ResourcesPlugin.getWorkspace().isTreeLocked() == false, oldResolvedClasspath != null ? oldResolvedClasspath : this.getResolvedClasspath(true, false, false), true, false);
                    return;
                }
                var9_6 = null;
                if (wasSuccessful != false) return;
            }
            catch (RuntimeException e) {
                if (this.project.isAccessible() == false) throw e;
                Util.log(e, "Could not set classpath for " + this.getPath());
                throw e;
            }
            catch (JavaModelException e) {
                if (ResourcesPlugin.getWorkspace().isTreeLocked() != false) throw e;
                if (this.project.isAccessible() == false) throw e;
                if (e.getJavaModelStatus().getException() instanceof CoreException) {
                    this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.couldNotWriteClasspathFile", this.getElementName(), e.getMessage())));
                    throw e;
                }
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.invalidClasspathInClasspathFile", this.getElementName(), e.getMessage())));
                throw e;
            }
        }
        catch (Throwable var8_18) {
            var9_9 = null;
            if (wasSuccessful != false) throw var8_18;
            try {
                this.getPerProjectInfo().updateClasspathInformation(JavaProject.INVALID_CLASSPATH);
                this.updatePackageFragmentRoots();
                throw var8_18;
            }
            catch (JavaModelException e) {
                // empty catch block
            }
            throw var8_18;
        }
        ** try [egrp 2[TRYBLOCK] [10 : 357->374)] { 
lbl50:
        // 1 sources

        this.getPerProjectInfo().updateClasspathInformation(JavaProject.INVALID_CLASSPATH);
        this.updatePackageFragmentRoots();
        return;
lbl53:
        // 1 sources

        catch (JavaModelException e) {
            // empty catch block
        }
    }

    public IPackageFragmentRoot[] getAllPackageFragmentRoots() throws JavaModelException {
        return this.computePackageFragmentRoots(this.getResolvedClasspath(true, false, false), true);
    }

    public IClasspathEntry getClasspathEntryFor(IPath path) throws JavaModelException {
        IClasspathEntry[] entries = this.getExpandedClasspath(true);
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].getPath().equals(path)) continue;
            return entries[i];
        }
        return null;
    }

    public IMarker getCycleMarker() {
        try {
            if (this.project.isAccessible()) {
                IMarker[] markers = this.project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
                int length = markers.length;
                for (int i = 0; i < length; ++i) {
                    IMarker marker = markers[i];
                    String cycleAttr = (String)marker.getAttribute("cycleDetected");
                    if (cycleAttr == null || !cycleAttr.equals("true")) continue;
                    return marker;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public int getElementType() {
        return 2;
    }

    public IClasspathEntry[] getExpandedClasspath(boolean ignoreUnresolvedVariable) throws JavaModelException {
        return this.getExpandedClasspath(ignoreUnresolvedVariable, false, null, null);
    }

    public IClasspathEntry[] getExpandedClasspath(boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, Map preferredClasspaths, Map preferredOutputs) throws JavaModelException {
        ObjectVector accumulatedEntries = new ObjectVector();
        this.computeExpandedClasspath(this, ignoreUnresolvedVariable, generateMarkerOnError, new HashSet(5), accumulatedEntries, preferredClasspaths, preferredOutputs);
        Object[] expandedPath = new IClasspathEntry[accumulatedEntries.size()];
        accumulatedEntries.copyInto(expandedPath);
        return expandedPath;
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
            case '/': {
                char firstChar;
                String rootPath = "";
                token = null;
                while (memento.hasMoreTokens() && (firstChar = (token = memento.nextToken()).charAt(0)) != '<' && firstChar != '!') {
                    rootPath = rootPath + token;
                }
                JavaElement root = (JavaElement)((Object)this.getPackageFragmentRoot((IPath)new Path(rootPath)));
                if (token != null && token.charAt(0) == '<') {
                    return root.getHandleFromMemento(token, memento, owner);
                }
                return root.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '=';
    }

    private int getJavaCommandIndex(ICommand[] buildSpec) {
        for (int i = 0; i < buildSpec.length; ++i) {
            if (!buildSpec[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) continue;
            return i;
        }
        return -1;
    }

    protected JavaProjectElementInfo getJavaProjectElementInfo() throws JavaModelException {
        return (JavaProjectElementInfo)this.getElementInfo();
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((JavaProjectElementInfo)this.getElementInfo()).getNonJavaResources(this);
    }

    public String getOption(String optionName, boolean inheritJavaCoreOptions) {
        String propertyName = optionName;
        if (JavaModelManager.getJavaModelManager().optionNames.contains(propertyName)) {
            Preferences preferences = this.getPreferences();
            if (preferences == null || preferences.isDefault(propertyName)) {
                return inheritJavaCoreOptions ? JavaCore.getOption(propertyName) : null;
            }
            return preferences.getString(propertyName).trim();
        }
        return null;
    }

    public Map getOptions(boolean inheritJavaCoreOptions) {
        Hashtable options = inheritJavaCoreOptions ? JavaCore.getOptions() : new Hashtable(5);
        Preferences preferences = this.getPreferences();
        if (preferences == null) {
            return options;
        }
        HashSet optionNames = JavaModelManager.getJavaModelManager().optionNames;
        String[] propertyNames = preferences.propertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            String value = preferences.getString(propertyName).trim();
            if (!optionNames.contains(propertyName)) continue;
            options.put(propertyName, value);
        }
        return options;
    }

    public IPath getOutputLocation() throws JavaModelException {
        return this.getOutputLocation(false, true);
    }

    public IPath getOutputLocation(boolean createMarkers, boolean logProblems) throws JavaModelException {
        JavaModelManager.PerProjectInfo perProjectInfo = this.getPerProjectInfo();
        IPath outputLocation = perProjectInfo.outputLocation;
        if (outputLocation != null) {
            return outputLocation;
        }
        this.getRawClasspath(createMarkers, logProblems);
        outputLocation = perProjectInfo.outputLocation;
        if (outputLocation == null) {
            return this.defaultOutputLocation();
        }
        return outputLocation;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IPath path) {
        if (!path.isAbsolute()) {
            path = this.getPath().append(path);
        }
        int segmentCount = path.segmentCount();
        switch (segmentCount) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getPackageFragmentRoot((IResource)this.project);
            }
        }
        if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(path.lastSegment())) {
            IResource resource = this.project.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 2) {
                return this.getPackageFragmentRoot(resource);
            }
            return this.getPackageFragmentRoot0(path);
        }
        return this.getPackageFragmentRoot((IResource)this.project.getWorkspace().getRoot().getFolder(path));
    }

    public IPackageFragmentRoot getFolderPackageFragmentRoot(IPath path) {
        if (path.segmentCount() == 1) {
            return this.getPackageFragmentRoot((IResource)this.project);
        }
        return this.getPackageFragmentRoot((IResource)this.project.getWorkspace().getRoot().getFolder(path));
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(resource.getName())) {
                    return new JarPackageFragmentRoot(resource, this);
                }
                return null;
            }
            case 2: {
                return new PackageFragmentRoot(resource, this, resource.getName());
            }
            case 4: {
                return new PackageFragmentRoot(resource, this, "");
            }
        }
        return null;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(String jarPath) {
        return this.getPackageFragmentRoot0(JavaProject.canonicalizedPath((IPath)new Path(jarPath)));
    }

    public IPackageFragmentRoot getPackageFragmentRoot0(IPath jarPath) {
        return new JarPackageFragmentRoot(jarPath, this);
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots() throws JavaModelException {
        IJavaElement[] children = this.getChildren();
        int length = children.length;
        IPackageFragmentRoot[] roots = new IPackageFragmentRoot[length];
        System.arraycopy(children, 0, roots, 0, length);
        return roots;
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots(IClasspathEntry entry) {
        return this.findPackageFragmentRoots(entry);
    }

    protected IPackageFragmentRoot[] getPackageFragmentRoots(IPath path) throws JavaModelException {
        IPackageFragmentRoot[] roots = this.getAllPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> matches = new ArrayList<IPackageFragmentRoot>();
        for (int i = 0; i < roots.length; ++i) {
            if (!path.isPrefixOf(roots[i].getPath())) continue;
            matches.add(roots[i]);
        }
        IPackageFragmentRoot[] copy = new IPackageFragmentRoot[matches.size()];
        matches.toArray(copy);
        return copy;
    }

    public IPackageFragment[] getPackageFragments() throws JavaModelException {
        IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
        return this.getPackageFragmentsInRoots(roots);
    }

    public IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots) {
        ArrayList<IJavaElement> frags = new ArrayList<IJavaElement>();
        for (int i = 0; i < roots.length; ++i) {
            IPackageFragmentRoot root = roots[i];
            try {
                IJavaElement[] rootFragments = root.getChildren();
                for (int j = 0; j < rootFragments.length; ++j) {
                    frags.add(rootFragments[j]);
                }
                continue;
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    public IPath getPath() {
        return this.project.getFullPath();
    }

    public JavaModelManager.PerProjectInfo getPerProjectInfo() throws JavaModelException {
        return JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    public Preferences getPreferences() {
        if (!JavaProject.hasJavaNature(this.project)) {
            return null;
        }
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(this.project, true);
        Preferences preferences = perProjectInfo.preferences;
        if (preferences != null) {
            return preferences;
        }
        preferences = this.loadPreferences();
        if (preferences == null) {
            preferences = new Preferences();
        }
        perProjectInfo.preferences = preferences;
        return preferences;
    }

    public IClasspathEntry[] getRawClasspath() throws JavaModelException {
        return this.getRawClasspath(false, true);
    }

    public IClasspathEntry[] getRawClasspath(boolean createMarkers, boolean logProblems) throws JavaModelException {
        IClasspathEntry entry;
        IClasspathEntry[] classpath;
        JavaModelManager.PerProjectInfo perProjectInfo = null;
        if (createMarkers) {
            this.flushClasspathProblemMarkers(false, true);
            classpath = this.readClasspathFile(createMarkers, logProblems);
        } else {
            perProjectInfo = this.getPerProjectInfo();
            classpath = perProjectInfo.rawClasspath;
            if (classpath != null) {
                return classpath;
            }
            classpath = this.readClasspathFile(createMarkers, logProblems);
        }
        IPath outputLocation = null;
        if (classpath != null && classpath.length > 0 && (entry = classpath[classpath.length - 1]).getContentKind() == 10) {
            outputLocation = entry.getPath();
            IClasspathEntry[] copy = new IClasspathEntry[classpath.length - 1];
            System.arraycopy(classpath, 0, copy, 0, copy.length);
            classpath = copy;
        }
        if (classpath == null) {
            return this.defaultClasspath();
        }
        if (!createMarkers) {
            perProjectInfo.rawClasspath = classpath;
            perProjectInfo.outputLocation = outputLocation;
        }
        return classpath;
    }

    public String[] getRequiredProjectNames() throws JavaModelException {
        return this.projectPrerequisites(this.getResolvedClasspath(true, false, false));
    }

    public IClasspathEntry[] getResolvedClasspath(boolean ignoreUnresolvedEntry) throws JavaModelException {
        return this.getResolvedClasspath(ignoreUnresolvedEntry, false, true);
    }

    public IClasspathEntry[] getResolvedClasspath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError) throws JavaModelException {
        return this.getResolvedClasspath(ignoreUnresolvedEntry, generateMarkerOnError, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClasspathEntry[] getResolvedClasspath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, boolean returnResolutionInProgress) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerProjectInfo perProjectInfo = null;
        if (ignoreUnresolvedEntry && !generateMarkerOnError && (perProjectInfo = this.getPerProjectInfo()) != null) {
            IClasspathEntry[] infoPath = perProjectInfo.resolvedClasspath;
            if (infoPath != null) {
                return infoPath;
            }
            if (returnResolutionInProgress && manager.isClasspathBeingResolved(this)) {
                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                    Util.verbose("CPResolution: reentering raw classpath resolution, will use empty classpath instead\tproject: " + this.getElementName() + '\n' + "\tinvocation stack trace:");
                    new Exception("<Fake exception>").printStackTrace(System.out);
                }
                return RESOLUTION_IN_PROGRESS;
            }
        }
        HashMap reverseMap = perProjectInfo == null ? null : new HashMap(5);
        IClasspathEntry[] resolvedPath = null;
        boolean nullOldResolvedCP = perProjectInfo != null && perProjectInfo.resolvedClasspath == null;
        try {
            if (nullOldResolvedCP) {
                manager.setClasspathBeingResolved(this, true);
            }
            resolvedPath = this.getResolvedClasspath(this.getRawClasspath(generateMarkerOnError, !generateMarkerOnError), generateMarkerOnError ? this.getOutputLocation() : null, ignoreUnresolvedEntry, generateMarkerOnError, reverseMap);
        }
        finally {
            if (nullOldResolvedCP) {
                perProjectInfo.resolvedClasspath = null;
            }
        }
        if (perProjectInfo != null) {
            if (perProjectInfo.rawClasspath == null && generateMarkerOnError && JavaProject.hasJavaNature(this.project)) {
                this.flushClasspathProblemMarkers(false, true);
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.cannotReadClasspathFile", this.getElementName())));
            }
            perProjectInfo.resolvedClasspath = resolvedPath;
            perProjectInfo.resolvedPathToRawEntries = reverseMap;
            manager.setClasspathBeingResolved(this, false);
        }
        return resolvedPath;
    }

    /*
     * Unable to fully structure code
     */
    public IClasspathEntry[] getResolvedClasspath(IClasspathEntry[] classpathEntries, IPath projectOutputLocation, boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, Map reverseMap) throws JavaModelException {
        if (generateMarkerOnError) {
            this.flushClasspathProblemMarkers(false, false);
        }
        length = classpathEntries.length;
        resolvedEntries = new ArrayList<IClasspathEntry>();
        block6: for (i = 0; i < length; ++i) {
            rawEntry = classpathEntries[i];
            status = null;
            if (generateMarkerOnError || !ignoreUnresolvedEntry) {
                status = ClasspathEntry.validateClasspathEntry(this, rawEntry, false, false);
                if (generateMarkerOnError && !status.isOK()) {
                    this.createClasspathProblemMarker(status);
                }
            }
            switch (rawEntry.getEntryKind()) {
                case 4: {
                    resolvedEntry = null;
                    try {
                        resolvedEntry = JavaCore.getResolvedClasspathEntry(rawEntry);
                    }
                    catch (Assert.AssertionFailedException e) {
                        if (ignoreUnresolvedEntry) ** GOTO lbl21
                        throw new JavaModelException(status);
                    }
lbl21:
                    // 2 sources

                    if (resolvedEntry == null) {
                        if (ignoreUnresolvedEntry) continue block6;
                        throw new JavaModelException(status);
                    }
                    if (reverseMap != null && reverseMap.get(resolvedPath = resolvedEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(resolvedEntry);
                    continue block6;
                }
                case 5: {
                    container = JavaCore.getClasspathContainer(rawEntry.getPath(), this);
                    if (container == null) {
                        if (ignoreUnresolvedEntry) continue block6;
                        throw new JavaModelException(status);
                    }
                    containerEntries = container.getClasspathEntries();
                    if (containerEntries == null) continue block6;
                    containerLength = containerEntries.length;
                    for (j = 0; j < containerLength; ++j) {
                        cEntry = containerEntries[j];
                        if (generateMarkerOnError && !(containerStatus = ClasspathEntry.validateClasspathEntry(this, cEntry, false, true)).isOK()) {
                            this.createClasspathProblemMarker(containerStatus);
                        }
                        if (rawEntry.isExported()) {
                            cEntry = new ClasspathEntry(cEntry.getContentKind(), cEntry.getEntryKind(), cEntry.getPath(), cEntry.getInclusionPatterns(), cEntry.getExclusionPatterns(), cEntry.getSourceAttachmentPath(), cEntry.getSourceAttachmentRootPath(), cEntry.getOutputLocation(), true);
                        }
                        if (reverseMap != null && reverseMap.get(resolvedPath = cEntry.getPath()) == null) {
                            reverseMap.put(resolvedPath, rawEntry);
                        }
                        resolvedEntries.add(cEntry);
                    }
                    continue block6;
                }
                default: {
                    if (reverseMap != null && reverseMap.get(resolvedPath = rawEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(rawEntry);
                }
            }
        }
        resolvedPath = new IClasspathEntry[resolvedEntries.size()];
        resolvedEntries.toArray(resolvedPath);
        if (generateMarkerOnError && projectOutputLocation != null && !(status = ClasspathEntry.validateClasspath(this, resolvedPath, projectOutputLocation)).isOK()) {
            this.createClasspathProblemMarker(status);
        }
        return resolvedPath;
    }

    public IResource getResource() {
        return this.project;
    }

    public String getSharedProperty(String key) throws CoreException {
        String property = null;
        IFile rscFile = this.project.getFile(key);
        if (rscFile.exists()) {
            byte[] bytes = Util.getResourceContentsAsByteArray(rscFile);
            try {
                property = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.log(e, "Could not read .classpath with UTF-8 encoding");
                property = new String(bytes);
            }
        }
        return property;
    }

    public SourceMapper getSourceMapper() {
        return null;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.project;
    }

    public boolean hasBuildState() {
        return JavaModelManager.getJavaModelManager().getLastBuiltState(this.project, null) != null;
    }

    public boolean hasClasspathCycle(IClasspathEntry[] preferredClasspath) {
        HashSet cycleParticipants = new HashSet();
        HashMap<JavaProject, IClasspathEntry[]> preferredClasspaths = new HashMap<JavaProject, IClasspathEntry[]>(1);
        preferredClasspaths.put(this, preferredClasspath);
        this.updateCycleParticipants(new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2), preferredClasspaths);
        return !cycleParticipants.isEmpty();
    }

    public boolean hasCycleMarker() {
        return this.getCycleMarker() != null;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean hasSource() {
        IClasspathEntry[] entries;
        try {
            entries = this.getRawClasspath();
        }
        catch (JavaModelException e) {
            return true;
        }
        int max = entries.length;
        for (int i = 0; i < max; ++i) {
            if (entries[i].getEntryKind() != 3) continue;
            return true;
        }
        return false;
    }

    public boolean isClasspathEqualsTo(IClasspathEntry[] newClasspath, IPath newOutputLocation, IClasspathEntry[] otherClasspathWithOutput) {
        int length;
        if (otherClasspathWithOutput != null && otherClasspathWithOutput.length > 0 && (length = otherClasspathWithOutput.length) == newClasspath.length + 1) {
            for (int i = 0; i < length - 1; ++i) {
                if (otherClasspathWithOutput[i].equals(newClasspath[i])) continue;
                return false;
            }
            IClasspathEntry output = otherClasspathWithOutput[length - 1];
            if (output.getContentKind() == 10 && output.getPath().equals(newOutputLocation)) {
                return true;
            }
        }
        return false;
    }

    public boolean isOnClasspath(IJavaElement element) {
        IClasspathEntry[] classpath;
        IPath path = element.getPath();
        try {
            classpath = this.getResolvedClasspath(true, false, false);
        }
        catch (JavaModelException e) {
            return false;
        }
        boolean isFolderPath = false;
        switch (element.getElementType()) {
            case 3: {
                for (int i = 0; i < classpath.length; ++i) {
                    IClasspathEntry entry = classpath[i];
                    IPath entryPath = entry.getPath();
                    if (!entryPath.equals(path)) continue;
                    return true;
                }
                return false;
            }
            case 4: {
                if (((IPackageFragmentRoot)element.getParent()).isArchive()) break;
                isFolderPath = true;
            }
        }
        for (int i = 0; i < classpath.length; ++i) {
            IClasspathEntry entry = classpath[i];
            IPath entryPath = entry.getPath();
            if (!entryPath.isPrefixOf(path) || Util.isExcluded(path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), isFolderPath)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnClasspath(IResource resource) {
        IClasspathEntry[] classpath;
        IPath exactPath;
        IPath path = exactPath = resource.getFullPath();
        boolean isFolderPath = resource.getType() == 2;
        try {
            classpath = this.getResolvedClasspath(true, false, false);
        }
        catch (JavaModelException e) {
            return false;
        }
        for (int i = 0; i < classpath.length; ++i) {
            IClasspathEntry entry = classpath[i];
            IPath entryPath = entry.getPath();
            if (entryPath.equals(exactPath)) {
                return true;
            }
            if (!entryPath.isPrefixOf(path) || Util.isExcluded(path, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars(), isFolderPath)) continue;
            return true;
        }
        return false;
    }

    private IPath getPluginWorkingLocation() {
        return this.project.getWorkingLocation("org.eclipse.jdt.core");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Preferences loadPreferences() {
        File prefFile;
        Preferences preferences = new Preferences();
        IPath projectMetaLocation = this.getPluginWorkingLocation();
        if (projectMetaLocation == null || !(prefFile = projectMetaLocation.append(PREF_FILENAME).toFile()).exists()) return null;
        BufferedInputStream in = null;
        in = new BufferedInputStream(new FileInputStream(prefFile));
        preferences.load((InputStream)in);
        Preferences preferences2 = preferences;
        Object var7_7 = null;
        if (in == null) return preferences2;
        try {
            ((InputStream)in).close();
            return preferences2;
        }
        catch (IOException e2) {
            // empty catch block
        }
        return preferences2;
        catch (IOException e) {
            try {
                Object var7_8 = null;
                if (in == null) return null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (in == null) throw throwable;
                try {
                    ((InputStream)in).close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)in).close();
                return null;
            }
            catch (IOException e2) {}
            return null;
        }
    }

    public IEvaluationContext newEvaluationContext() {
        return new EvaluationContextWrapper(new EvaluationContext(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameLookup newNameLookup(ICompilationUnit[] workingCopies) throws JavaModelException {
        JavaProjectElementInfo info;
        JavaProjectElementInfo javaProjectElementInfo = info = this.getJavaProjectElementInfo();
        synchronized (javaProjectElementInfo) {
            return new NameLookup(info.getAllPackageFragmentRoots(this), info.getAllPackageFragments(this), workingCopies);
        }
    }

    public NameLookup newNameLookup(WorkingCopyOwner owner) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        ICompilationUnit[] workingCopies = owner == null ? null : manager.getWorkingCopies(owner, true);
        return this.newNameLookup(workingCopies);
    }

    public ISearchableNameEnvironment newSearchableNameEnvironment(ICompilationUnit[] workingCopies) throws JavaModelException {
        return new SearchableEnvironment(this, workingCopies);
    }

    public ISearchableNameEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws JavaModelException {
        return new SearchableEnvironment(this, owner);
    }

    public ITypeHierarchy newTypeHierarchy(IRegion region, IProgressMonitor monitor) throws JavaModelException {
        return this.newTypeHierarchy(region, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(IRegion region, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        if (region == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullRegion"));
        }
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(region, this, workingCopies, null, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IType type, IRegion region, IProgressMonitor monitor) throws JavaModelException {
        return this.newTypeHierarchy(type, region, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(IType type, IRegion region, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        if (type == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullFocusType"));
        }
        if (region == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullRegion"));
        }
        ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(region, this, workingCopies, type, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public String[] projectPrerequisites(IClasspathEntry[] entries) throws JavaModelException {
        ArrayList<String> prerequisites = new ArrayList<String>();
        entries = this.getResolvedClasspath(entries, null, true, false, null);
        int length = entries.length;
        for (int i = 0; i < length; ++i) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() != 2) continue;
            prerequisites.add(entry.getPath().lastSegment());
        }
        int size = prerequisites.size();
        if (size == 0) {
            return NO_PREREQUISITES;
        }
        String[] result = new String[size];
        prerequisites.toArray(result);
        return result;
    }

    protected IClasspathEntry[] readClasspathFile(boolean createMarker, boolean logProblems) {
        try {
            String xmlClasspath = this.getSharedProperty(CLASSPATH_FILENAME);
            if (xmlClasspath == null) {
                if (createMarker && this.project.isAccessible()) {
                    this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.cannotReadClasspathFile", this.getElementName())));
                }
                return null;
            }
            return this.decodeClasspath(xmlClasspath, createMarker, logProblems);
        }
        catch (CoreException e) {
            if (createMarker && this.project.isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.cannotReadClasspathFile", this.getElementName())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will revert to default classpath");
            }
            return null;
        }
    }

    public IPath readOutputLocation() {
        IClasspathEntry entry;
        IClasspathEntry[] classpath = this.readClasspathFile(false, false);
        IPath outputLocation = null;
        if (classpath != null && classpath.length > 0 && (entry = classpath[classpath.length - 1]).getContentKind() == 10) {
            outputLocation = entry.getPath();
        }
        return outputLocation;
    }

    public IClasspathEntry[] readRawClasspath() {
        IClasspathEntry entry;
        IClasspathEntry[] classpath = this.readClasspathFile(false, false);
        if (classpath != null && classpath.length > 0 && (entry = classpath[classpath.length - 1]).getContentKind() == 10) {
            IClasspathEntry[] copy = new IClasspathEntry[classpath.length - 1];
            System.arraycopy(classpath, 0, copy, 0, copy.length);
            classpath = copy;
        }
        return classpath;
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].getBuilderName().equals(builderID)) continue;
            ICommand[] newCommands = new ICommand[commands.length - 1];
            System.arraycopy(commands, 0, newCommands, 0, i);
            System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
            description.setBuildSpec(newCommands);
            this.project.setDescription(description, null);
            return;
        }
    }

    public void resetCaches() {
        JavaProjectElementInfo info = (JavaProjectElementInfo)JavaModelManager.getJavaModelManager().peekAtInfo(this);
        if (info != null) {
            info.resetCaches();
        }
    }

    public String rootID() {
        return "[PRJ]" + this.project.getFullPath();
    }

    public boolean saveClasspath(IClasspathEntry[] newClasspath, IPath newOutputLocation) throws JavaModelException {
        if (!this.project.isAccessible()) {
            return false;
        }
        IClasspathEntry[] fileEntries = this.readClasspathFile(false, false);
        if (fileEntries != null && this.isClasspathEqualsTo(newClasspath, newOutputLocation, fileEntries)) {
            return false;
        }
        try {
            this.setSharedProperty(CLASSPATH_FILENAME, this.encodeClasspath(newClasspath, newOutputLocation, true));
            return true;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void savePreferences(Preferences preferences) {
        if (!JavaProject.hasJavaNature(this.project)) {
            return;
        }
        if (preferences == null || !preferences.needsSaving() && preferences.propertyNames().length != 0) {
            return;
        }
        File prefFile = this.getPluginWorkingLocation().append(PREF_FILENAME).toFile();
        if (preferences.propertyNames().length == 0) {
            if (!prefFile.exists()) return;
            prefFile.delete();
            return;
        }
        BufferedOutputStream out = null;
        out = new BufferedOutputStream(new FileOutputStream(prefFile));
        preferences.store((OutputStream)out, null);
        Object var6_4 = null;
        if (out == null) return;
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                Object var6_5 = null;
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void setJavaCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldBuildSpec = description.getBuildSpec();
        int oldJavaCommandIndex = this.getJavaCommandIndex(oldBuildSpec);
        if (oldJavaCommandIndex == -1) {
            newCommands = new ICommand[oldBuildSpec.length + 1];
            System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
            newCommands[0] = newCommand;
        } else {
            oldBuildSpec[oldJavaCommandIndex] = newCommand;
            newCommands = oldBuildSpec;
        }
        description.setBuildSpec(newCommands);
        this.project.setDescription(description, null);
    }

    public void setOption(String optionName, String optionValue) {
        if (!JavaModelManager.getJavaModelManager().optionNames.contains(optionName)) {
            return;
        }
        Preferences preferences = this.getPreferences();
        preferences.setDefault(optionName, CUSTOM_DEFAULT_OPTION_VALUE);
        preferences.setValue(optionName, optionValue);
        this.savePreferences(preferences);
    }

    public void setOptions(Map newOptions) {
        Preferences preferences = this.getPreferences();
        if (newOptions != null) {
            Iterator keys = newOptions.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!JavaModelManager.getJavaModelManager().optionNames.contains(key)) continue;
                String value = (String)newOptions.get(key);
                preferences.setDefault(key, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(key, value);
            }
        }
        String[] pNames = preferences.propertyNames();
        int ln = pNames.length;
        for (int i = 0; i < ln; ++i) {
            String key = pNames[i];
            if (newOptions != null && newOptions.containsKey(key)) continue;
            preferences.setToDefault(key);
        }
        this.savePreferences(preferences);
    }

    public void setOutputLocation(IPath path, IProgressMonitor monitor) throws JavaModelException {
        if (path == null) {
            throw new IllegalArgumentException(Util.bind("path.nullPath"));
        }
        if (path.equals(this.getOutputLocation())) {
            return;
        }
        this.setRawClasspath(SetClasspathOperation.ReuseClasspath, path, monitor);
    }

    public void setPreferences(Preferences preferences) {
        if (!JavaProject.hasJavaNature(this.project)) {
            return;
        }
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(this.project, true);
        perProjectInfo.preferences = preferences;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.parent = JavaModelManager.getJavaModelManager().getJavaModel();
        this.name = project.getName();
    }

    public void setRawClasspath(IClasspathEntry[] entries, IPath outputLocation, IProgressMonitor monitor) throws JavaModelException {
        this.setRawClasspath(entries, outputLocation, monitor, true, this.getResolvedClasspath(true, false, false), true, true);
    }

    public void setRawClasspath(IClasspathEntry[] newEntries, IPath newOutputLocation, IProgressMonitor monitor, boolean canChangeResource, IClasspathEntry[] oldResolvedPath, boolean needValidation, boolean needSave) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            IClasspathEntry[] newRawPath = newEntries;
            if (newRawPath == null) {
                newRawPath = this.defaultClasspath();
            }
            SetClasspathOperation op = new SetClasspathOperation(this, oldResolvedPath, newRawPath, newOutputLocation, canChangeResource, needValidation, needSave);
            op.runOperation(monitor);
        }
        catch (JavaModelException e) {
            manager.getDeltaProcessor().flush();
            throw e;
        }
    }

    public void setRawClasspath(IClasspathEntry[] entries, IProgressMonitor monitor) throws JavaModelException {
        this.setRawClasspath(entries, SetClasspathOperation.ReuseOutputLocation, monitor, true, this.getResolvedClasspath(true, false, false), true, true);
    }

    public void setSharedProperty(String key, String value) throws CoreException {
        IFile rscFile = this.project.getFile(key);
        byte[] bytes = null;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.log(e, "Could not write .classpath with UTF-8 encoding ");
            bytes = value.getBytes();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        if (rscFile.exists()) {
            if (rscFile.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
            }
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
    }

    public static void updateAllCycleMarkers(Map preferredClasspaths) throws JavaModelException {
        JavaProject project;
        int i;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] rscProjects = workspaceRoot.getProjects();
        int length = rscProjects.length;
        JavaProject[] projects = new JavaProject[length];
        HashSet cycleParticipants = new HashSet();
        HashSet traversed = new HashSet();
        ArrayList prereqChain = new ArrayList();
        for (i = 0; i < length; ++i) {
            if (!JavaProject.hasJavaNature(rscProjects[i]) || traversed.contains((project = (projects[i] = (JavaProject)JavaCore.create(rscProjects[i]))).getPath())) continue;
            prereqChain.clear();
            project.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredClasspaths);
        }
        for (i = 0; i < length; ++i) {
            project = projects[i];
            if (project == null) continue;
            if (cycleParticipants.contains(project.getPath())) {
                int circularCPSeverity;
                IMarker cycleMarker = project.getCycleMarker();
                String circularCPOption = project.getOption("org.eclipse.jdt.core.circularClasspath", true);
                int n = circularCPSeverity = "error".equals(circularCPOption) ? 2 : 1;
                if (cycleMarker != null) {
                    try {
                        int existingSeverity = (Integer)cycleMarker.getAttribute("severity");
                        if (existingSeverity == circularCPSeverity) continue;
                        cycleMarker.setAttribute("severity", circularCPSeverity);
                        continue;
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
                project.createClasspathProblemMarker(new JavaModelStatus(1001, project));
                continue;
            }
            project.flushClasspathProblemMarkers(true, false);
        }
    }

    public void updateCycleParticipants(ArrayList prereqChain, HashSet cycleParticipants, IWorkspaceRoot workspaceRoot, HashSet traversed, Map preferredClasspaths) {
        IPath path = this.getPath();
        prereqChain.add(path);
        traversed.add(path);
        try {
            IClasspathEntry[] classpath = null;
            if (preferredClasspaths != null) {
                classpath = (IClasspathEntry[])preferredClasspaths.get(this);
            }
            if (classpath == null) {
                classpath = this.getResolvedClasspath(true, false, false);
            }
            int length = classpath.length;
            for (int i = 0; i < length; ++i) {
                IResource member;
                int index;
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() != 2) continue;
                IPath prereqProjectPath = entry.getPath();
                int n = index = cycleParticipants.contains(prereqProjectPath) ? 0 : prereqChain.indexOf(prereqProjectPath);
                if (index >= 0) {
                    int size = prereqChain.size();
                    while (index < size) {
                        cycleParticipants.add(prereqChain.get(index));
                        ++index;
                    }
                    continue;
                }
                if (traversed.contains(prereqProjectPath) || (member = workspaceRoot.findMember(prereqProjectPath)) == null || member.getType() != 4) continue;
                JavaProject javaProject = (JavaProject)JavaCore.create((IProject)member);
                javaProject.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredClasspaths);
            }
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        prereqChain.remove(path);
    }

    public void updateClasspathMarkers(Map preferredClasspaths, Map preferredOutputs) {
        IClasspathEntry entry;
        this.flushClasspathProblemMarkers(false, true);
        this.flushClasspathProblemMarkers(false, false);
        IClasspathEntry[] classpath = this.readClasspathFile(true, false);
        IPath output = null;
        if (classpath != null && classpath.length > 0 && (entry = classpath[classpath.length - 1]).getContentKind() == 10) {
            IClasspathEntry[] copy = new IClasspathEntry[classpath.length - 1];
            System.arraycopy(classpath, 0, copy, 0, copy.length);
            classpath = copy;
            output = entry.getPath();
        }
        if (preferredClasspaths != null) {
            preferredClasspaths.put(this, classpath == null ? INVALID_CLASSPATH : classpath);
        }
        if (preferredOutputs != null) {
            preferredOutputs.put(this, output == null ? this.defaultOutputLocation() : output);
        }
        if (classpath != null && output != null) {
            for (int i = 0; i < classpath.length; ++i) {
                IJavaModelStatus status = ClasspathEntry.validateClasspathEntry(this, classpath[i], false, true);
                if (status.isOK()) continue;
                this.createClasspathProblemMarker(status);
            }
            IJavaModelStatus status = ClasspathEntry.validateClasspath(this, classpath, output);
            if (!status.isOK()) {
                this.createClasspathProblemMarker(status);
            }
        }
    }

    public void updatePackageFragmentRoots() {
        if (this.isOpen()) {
            try {
                JavaProjectElementInfo info = this.getJavaProjectElementInfo();
                this.computeChildren(info);
            }
            catch (JavaModelException e) {
                try {
                    this.close();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
    }
}

